/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.faaast.converter.packageexplorer;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.jayway.jsonpath.Configuration;
import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Option;
import com.jayway.jsonpath.Predicate;
import com.jayway.jsonpath.TypeRef;
import com.jayway.jsonpath.spi.json.JacksonJsonNodeJsonProvider;
import com.jayway.jsonpath.spi.mapper.JacksonMappingProvider;
import io.adminshell.aas.v3.dataformat.core.util.AasUtils;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PackageExplorerConverter {
    private static final Logger LOGGER = LoggerFactory.getLogger(PackageExplorerConverter.class);
    private static final TypeRef<List<ObjectNode>> TYPE_OBJECT_NODE_LIST = new TypeRef<List<ObjectNode>>(){};
    private static final TypeRef<List<JsonNode>> TYPE_JSON_NODE_LIST = new TypeRef<List<JsonNode>>(){};
    private final DocumentContext document;

    private PackageExplorerConverter(InputStream input) {
        this.document = JsonPath.using(new Configuration.ConfigurationBuilder().jsonProvider(new JacksonJsonNodeJsonProvider()).mappingProvider(new JacksonMappingProvider()).options(Option.SUPPRESS_EXCEPTIONS).build()).parse(input, StandardCharsets.UTF_8.name());
    }

    public static InputStream toFaaast(InputStream input) {
        return new PackageExplorerConverter(input).convert();
    }

    private ByteArrayInputStream convert() {
        this.removeEmptyKeys();
        this.removeKeyIndex();
        this.removeKeyLocal();
        this.capitalizeEnumValues();
        this.transformAssets();
        this.flattenValueType();
        this.flattenOperationVariables();
        this.fixEmbeddedDataSpecificationDataType();
        if (LOGGER.isDebugEnabled()) {
            try {
                LOGGER.debug(new ObjectMapper().writerWithDefaultPrettyPrinter().writeValueAsString(this.document.json()));
            }
            catch (JsonProcessingException e) {
                LOGGER.warn("Could not log converter result as serialization failed", e);
            }
        }
        return new ByteArrayInputStream(this.document.jsonString().getBytes());
    }

    private void delete(String path, Function<List<JsonNode>, String> logMessageProvider, boolean logElements) {
        List<JsonNode> elements = this.document.read(path, TYPE_JSON_NODE_LIST);
        if (!elements.isEmpty()) {
            LOGGER.debug(logMessageProvider.apply(elements));
            if (logElements) {
                elements.forEach(x -> LOGGER.debug("     {}", x));
            }
        }
        try {
            this.document.delete(path, new Predicate[0]);
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
    }

    private void removeEmptyKeys() {
        this.delete("$..keys[?(@.type == '' || @.value == '' || @.idType == '')]", x -> String.format("Found %d keys with empty type, value, and/or idType. These keys will be removed which may render enclosing element (e.g. a reference) invalid.", x.size()), true);
    }

    private void removeKeyIndex() {
        this.delete("$..keys[*].index", x -> String.format("Removed key.index (because package explorer-specific)", new Object[0]), false);
    }

    private void removeKeyLocal() {
        this.delete("$..keys[*].local", x -> String.format("Removed key.local (because removed in AAS v3.0)", new Object[0]), false);
    }

    private void capitalizeEnumValues() {
        LOGGER.debug("Adjusting values for 'idType' and 'category' (FA\u00b3ST-specific)");
        this.document.map("$..idType", (x, config) -> AasUtils.serializeEnumName(x.toString()), new Predicate[0]);
        this.document.map("$..category", (x, config) -> AasUtils.serializeEnumName(x.toString()), new Predicate[0]);
    }

    private void fixEmbeddedDataSpecificationDataType() {
        LOGGER.debug("Adjusting values for 'dataType' inside embeddedDataSpecifications (FA\u00b3ST-specific)");
        this.document.map("$..embeddedDataSpecifications[*]..dataType", (x, config) -> {
            if (x.toString().isBlank()) {
                LOGGER.warn("Found embeddedDataSpecification with missing datatype property - setting to 'String' (default)");
                return "String";
            }
            return AasUtils.serializeEnumName(x.toString());
        }, new Predicate[0]);
    }

    private void transformAssets() {
        Map<Object, Object> assetKinds;
        LOGGER.debug("Updating assets: removing top-level 'assets' array and converter 'AssetAdministrationShell.asset' to 'AssetAdministrationShell.assetInformation' (introduced in v3.0)");
        List<ObjectNode> assets = this.document.read("$.assets", TYPE_OBJECT_NODE_LIST);
        if (assets == null) {
            assetKinds = Map.of();
        } else {
            assetKinds = assets.stream().collect(Collectors.toMap(x -> x.at("/identification/id").asText(), x -> x.get("kind").asText()));
            this.document.delete("$.assets", new Predicate[0]);
        }
        this.document.map("$.assetAdministrationShells[?(@.asset)]", (x, config) -> {
            ObjectNode node = (ObjectNode)x;
            ObjectNode nodeAssetInformation = node.putObject("assetInformation");
            String id = node.at("/asset/keys/0/value").asText();
            nodeAssetInformation.put("assetKind", assetKinds.containsKey(id) ? (String)assetKinds.get(id) : "Instance");
            nodeAssetInformation.putObject("globalAssetId").putArray("keys").addObject().put("value", id).set("idType", node.at("/asset/keys/0/idType"));
            node.remove("asset");
            return node;
        }, new Predicate[0]);
    }

    private void flattenValueType() {
        LOGGER.debug("Flattening valueType structure (because package explorer-specific)");
        this.document.map("$..valueType[?(@.dataObjectType)]", (x, config) -> {
            ObjectNode node = (ObjectNode)x;
            return JsonNodeFactory.instance.textNode(node.at("/dataObjectType/name").asText().toLowerCase());
        }, new Predicate[0]);
    }

    private void flattenOperationVariables() {
        LOGGER.debug("Flattening operation variable structure (because package explorer-specific)");
        this.document.map("$..value[?(@.submodelElement)]", (x, config) -> {
            ObjectNode node = (ObjectNode)x;
            return node.elements().next();
        }, new Predicate[0]);
    }
}

