/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.frostserver.util.pathparser;

import de.fraunhofer.iosb.ilt.frostserver.util.pathparser.PConstants;
import de.fraunhofer.iosb.ilt.frostserver.util.pathparser.PParser;
import de.fraunhofer.iosb.ilt.frostserver.util.pathparser.Token;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;

public class ParseException
extends Exception
implements PConstants {
    private Token token;
    private EnumSet<PConstants.TokenType> expectedTypes;
    private List<PParser.NonTerminalCall> callStack;
    private boolean alreadyAdjusted;

    public ParseException() {
    }

    public ParseException(Token token, EnumSet<PConstants.TokenType> expectedTypes, List<PParser.NonTerminalCall> callStack) {
        this.token = token.getNext() != null ? token.getNext() : token;
        this.expectedTypes = expectedTypes;
        this.callStack = new ArrayList<PParser.NonTerminalCall>(callStack);
    }

    public ParseException(PParser parser, String message) {
        super(message);
        this.token = parser.lastConsumedToken;
        if (this.token != null && this.token.getNext() != null) {
            this.token = this.token.getNext();
        }
        this.callStack = new ArrayList<PParser.NonTerminalCall>(parser.parsingStack);
    }

    public ParseException(PParser parser, EnumSet<PConstants.TokenType> expectedTypes, List<PParser.NonTerminalCall> callStack) {
        this.token = parser.lastConsumedToken;
        if (this.token != null && this.token.getNext() != null) {
            this.token = this.token.getNext();
        }
        this.expectedTypes = expectedTypes;
        this.callStack = new ArrayList<PParser.NonTerminalCall>(callStack);
    }

    public ParseException(String message) {
        super(message);
    }

    public ParseException(Token token) {
        this.token = token;
    }

    @Override
    public String getMessage() {
        Object content;
        String msg = super.getMessage();
        if (this.token == null && this.expectedTypes == null) {
            return msg;
        }
        StringBuilder buf = new StringBuilder();
        if (msg != null) {
            buf.append(msg);
        }
        buf.append("\nEncountered an error at (or somewhere around) " + this.token.getLocation());
        if (this.expectedTypes != null && this.token != null && this.expectedTypes.contains((Object)this.token.getType())) {
            return buf.toString();
        }
        if (this.expectedTypes != null) {
            buf.append("\nWas expecting one of the following:\n");
            boolean isFirst = true;
            for (PConstants.TokenType type : this.expectedTypes) {
                if (!isFirst) {
                    buf.append(", ");
                }
                isFirst = false;
                buf.append((Object)type);
            }
        }
        if ((content = this.token.getImage()) == null) {
            content = "";
        }
        if (((String)content).length() > 32) {
            content = ((String)content).substring(0, 32) + "...";
        }
        buf.append("\nFound string \"" + PConstants.addEscapes((String)content) + "\" of type " + this.token.getType());
        return buf.toString();
    }

    @Override
    public StackTraceElement[] getStackTrace() {
        this.adjustStackTrace();
        return super.getStackTrace();
    }

    @Override
    public void printStackTrace(PrintStream s) {
        this.adjustStackTrace();
        super.printStackTrace(s);
    }

    public Token getToken() {
        return this.token;
    }

    private void adjustStackTrace() {
        StackTraceElement[] jvmCallStack;
        if (this.alreadyAdjusted || this.callStack == null || this.callStack.isEmpty()) {
            return;
        }
        LinkedList<StackTraceElement> fullTrace = new LinkedList<StackTraceElement>();
        LinkedList<StackTraceElement> ourCallStack = new LinkedList<StackTraceElement>();
        for (PParser.NonTerminalCall nonTerminalCall : this.callStack) {
            ourCallStack.add(nonTerminalCall.createStackTraceElement());
        }
        for (StackTraceElement regularEntry : jvmCallStack = super.getStackTrace()) {
            if (ourCallStack.isEmpty()) break;
            String methodName = regularEntry.getMethodName();
            StackTraceElement ourEntry = this.lastElementWithName(ourCallStack, methodName);
            if (ourEntry != null) {
                fullTrace.add(ourEntry);
            }
            fullTrace.add(regularEntry);
        }
        StackTraceElement[] stackTraceElementArray = new StackTraceElement[fullTrace.size()];
        this.setStackTrace(fullTrace.toArray(stackTraceElementArray));
        this.alreadyAdjusted = true;
    }

    private StackTraceElement lastElementWithName(List<StackTraceElement> elements, String methodName) {
        ListIterator<StackTraceElement> it = elements.listIterator(elements.size());
        while (it.hasPrevious()) {
            StackTraceElement elem = it.previous();
            if (!elem.getMethodName().equals(methodName)) continue;
            it.remove();
            return elem;
        }
        return null;
    }
}

