/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.frostserver.util;

import de.fraunhofer.iosb.ilt.frostserver.util.wktparser.BaseNode;
import de.fraunhofer.iosb.ilt.frostserver.util.wktparser.Node;
import de.fraunhofer.iosb.ilt.frostserver.util.wktparser.ParseException;
import de.fraunhofer.iosb.ilt.frostserver.util.wktparser.WParser;
import de.fraunhofer.iosb.ilt.frostserver.util.wktparser.nodes.Coords2;
import de.fraunhofer.iosb.ilt.frostserver.util.wktparser.nodes.Coords3;
import de.fraunhofer.iosb.ilt.frostserver.util.wktparser.nodes.DOUBLE;
import de.fraunhofer.iosb.ilt.frostserver.util.wktparser.nodes.LinearRing;
import de.fraunhofer.iosb.ilt.frostserver.util.wktparser.nodes.Start;
import de.fraunhofer.iosb.ilt.frostserver.util.wktparser.nodes.WktLineString;
import de.fraunhofer.iosb.ilt.frostserver.util.wktparser.nodes.WktMultiPoint;
import de.fraunhofer.iosb.ilt.frostserver.util.wktparser.nodes.WktPoint;
import de.fraunhofer.iosb.ilt.frostserver.util.wktparser.nodes.WktPolygon;
import java.io.ByteArrayInputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.geojson.GeoJsonObject;
import org.geojson.LineString;
import org.geojson.LngLatAlt;
import org.geojson.MultiPoint;
import org.geojson.Point;
import org.geojson.Polygon;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WktParser
extends Node.Visitor {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)WktParser.class.getName());
    private GeoJsonObject result;
    private LngLatAlt lastLngLatAlt;
    private List<LngLatAlt> lastLinearRing;
    private Polygon lastPolygon;
    private LineString lastLineString;
    private MultiPoint lastMultiPoint;
    private Point lastPoint;

    public WktParser(GeoJsonObject result, LngLatAlt lastLngLatAlt, List<LngLatAlt> lastLinearRing, Polygon lastPolygon, LineString lastLineString, MultiPoint lastMultiPoint, Point lastPoint) {
        this.result = result;
        this.lastLngLatAlt = lastLngLatAlt;
        this.lastLinearRing = lastLinearRing;
        this.lastPolygon = lastPolygon;
        this.lastLineString = lastLineString;
        this.lastMultiPoint = lastMultiPoint;
        this.lastPoint = lastPoint;
    }

    private WktParser() {
    }

    public static GeoJsonObject parseWkt(String wkt) {
        try {
            LOGGER.debug("Parsing: {}", (Object)wkt);
            ByteArrayInputStream is = new ByteArrayInputStream(wkt.getBytes(StandardCharsets.UTF_8));
            WParser parser = new WParser(is);
            Start start = parser.Start();
            return new WktParser().visit(start);
        }
        catch (ParseException ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    public GeoJsonObject visit(Start node) {
        if (node.getChildCount() != 2) {
            throw new IllegalArgumentException("Multiple items found in WKT, expected only one.");
        }
        this.visit(node.getChild(0));
        return this.result;
    }

    public void visit(WktPoint node) {
        if (this.lastPoint != null) {
            throw new IllegalArgumentException("Previously parsed Point not used.");
        }
        ArrayList<BaseNode> children = new ArrayList<BaseNode>();
        children.addAll(node.childrenOfType(Coords2.class));
        children.addAll(node.childrenOfType(Coords3.class));
        if (children.size() != 1) {
            throw new IllegalArgumentException("Multiple items (" + children.size() + ") found in Point, expected only one.");
        }
        this.lastLngLatAlt = null;
        this.visit((Node)children.get(0));
        this.lastPoint = new Point(this.lastLngLatAlt);
        this.result = this.lastPoint;
    }

    public void visit(WktMultiPoint node) {
        if (this.lastMultiPoint != null) {
            throw new IllegalArgumentException("Previously parsed MultiPoint not used.");
        }
        this.lastMultiPoint = new MultiPoint();
        for (Node child : node.children()) {
            this.lastLngLatAlt = null;
            this.visit(child);
            if (this.lastLngLatAlt == null) continue;
            this.lastMultiPoint.add((Object)this.lastLngLatAlt);
        }
        this.result = this.lastMultiPoint;
    }

    public void visit(WktLineString node) {
        if (this.lastLineString != null) {
            throw new IllegalArgumentException("Previously parsed LineString not used.");
        }
        this.lastLineString = new LineString();
        for (Node child : node.children()) {
            this.lastLngLatAlt = null;
            this.visit(child);
            if (this.lastLngLatAlt == null) continue;
            this.lastLineString.add((Object)this.lastLngLatAlt);
        }
        this.result = this.lastLineString;
    }

    public void visit(WktPolygon node) {
        if (this.lastPolygon != null) {
            throw new IllegalArgumentException("Previously parsed Polygon not used.");
        }
        List<LinearRing> children = node.childrenOfType(LinearRing.class);
        this.lastPolygon = new Polygon();
        this.lastLinearRing = null;
        this.visit(children.get(0));
        this.lastPolygon.setExteriorRing(this.lastLinearRing);
        int childCount = children.size();
        for (int i = 1; i < childCount; ++i) {
            this.lastLinearRing = null;
            this.visit(children.get(i));
            if (this.lastLinearRing == null) continue;
            this.lastPolygon.addInteriorRing(this.lastLinearRing);
        }
        this.result = this.lastPolygon;
    }

    public void visit(LinearRing node) {
        if (this.lastLinearRing != null) {
            throw new IllegalArgumentException("Previously parsed coordinates not used.");
        }
        this.lastLinearRing = new ArrayList<LngLatAlt>();
        for (Node child : node.children()) {
            this.lastLngLatAlt = null;
            this.visit(child);
            if (this.lastLngLatAlt == null) continue;
            this.lastLinearRing.add(this.lastLngLatAlt);
        }
    }

    public void visit(Coords2 node) {
        if (this.lastLngLatAlt != null) {
            throw new IllegalArgumentException("Previously parsed LngLatAlt not used.");
        }
        List<DOUBLE> children = node.childrenOfType(DOUBLE.class);
        if (children.size() != 2) {
            throw new IllegalArgumentException("Point can not have " + children.size() + " coordinates.");
        }
        this.lastLngLatAlt = new LngLatAlt(Double.valueOf(children.get(0).getImage()).doubleValue(), Double.valueOf(children.get(1).getImage()).doubleValue());
    }

    public void visit(Coords3 node) {
        if (this.lastLngLatAlt != null) {
            throw new IllegalArgumentException("Previously parsed LngLatAlt not used.");
        }
        List<DOUBLE> children = node.childrenOfType(DOUBLE.class);
        if (children.size() != 3) {
            throw new IllegalArgumentException("Point can not have " + children.size() + " coordinates.");
        }
        this.lastLngLatAlt = new LngLatAlt(Double.valueOf(children.get(0).getImage()).doubleValue(), Double.valueOf(children.get(1).getImage()).doubleValue(), Double.valueOf(children.get(2).getImage()).doubleValue());
    }
}

