/* Generated by: JavaCC 21 Parser Generator. WNfaData.java */
package de.fraunhofer.iosb.ilt.frostserver.util.wktparser;

import static de.fraunhofer.iosb.ilt.frostserver.util.wktparser.WConstants.TokenType.*;
import java.util.Arrays;
import java.util.BitSet;
import java.util.EnumSet;
/**
 * Holder class for the data used by WLexer
 * to do the NFA thang
 */
class WNfaData implements WConstants {
    // The functional interface that represents 
    // the acceptance method of an NFA state
    static interface NfaFunction {
        TokenType apply(int ch, BitSet bs, EnumSet<TokenType> validTypes);
    }
    static private NfaFunction[] nfaFunctions;
    // This data holder class is never instantiated
    private WNfaData() {
    }

    /**
   * @param the lexical state
   * @return the table of function pointers that implement the lexical state
   */
    static final NfaFunction[] getFunctionTableMap(LexicalState lexicalState) {
        // We only have one lexical state in this case, so we return that!
        return nfaFunctions;
    }

    // Initialize the various NFA method tables
    static {
        DEFAULT.NFA_FUNCTIONS_init();
    }
    /**
  * Holder class for NFA code related to DEFAULT lexical state
  */
    private static class DEFAULT {
        static TokenType NFA_COMPOSITE_0(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            TokenType type= null;
            if ((ch== '+')||(ch== '-')) {
                nextStates.set(124);
            }
            else if (ch== '.') {
                nextStates.set(131);
            }
            else if ((ch== 'G')||(ch== 'g')) {
                nextStates.set(96);
            }
            else if ((ch== 'L')||(ch== 'l')) {
                nextStates.set(20);
            }
            else if ((ch== 'M')||(ch== 'm')) {
                nextStates.set(100);
                nextStates.set(61);
                nextStates.set(92);
            }
            else if ((ch== 'P')||(ch== 'p')) {
                nextStates.set(58);
                nextStates.set(94);
                nextStates.set(111);
            }
            else if ((ch== 'T')||(ch== 't')) {
                nextStates.set(39);
                nextStates.set(74);
            }
            else if ((ch== 'Z')||(ch== 'z')) {
                nextStates.set(49);
            }
            if ((ch== 'M')||(ch== 'm')) {
                if (validTypes.contains(ZoM)) type= ZoM;
            }
            else if ((ch== 'Z')||(ch== 'z')) {
                if (validTypes.contains(ZoM)) type= ZoM;
            }
            else if (ch>='0'&&ch<='9') {
                nextStates.set(2);
                if (validTypes.contains(DOUBLE)) type= DOUBLE;
            }
            else if (ch== ',') {
                if (validTypes.contains(COMMA)) type= COMMA;
            }
            else if (ch== ')') {
                if (validTypes.contains(RB)) type= RB;
            }
            else if (ch== '(') {
                if (validTypes.contains(LB)) type= LB;
            }
            else if (ch== '\r') {
                if (validTypes.contains(_TOKEN_4)) type= _TOKEN_4;
            }
            else if (ch== '\n') {
                if (validTypes.contains(_TOKEN_3)) type= _TOKEN_3;
            }
            else if (ch== '\t') {
                if (validTypes.contains(_TOKEN_2)) type= _TOKEN_2;
            }
            else if (ch== ' ') {
                if (validTypes.contains(_TOKEN_1)) type= _TOKEN_1;
            }
            return type;
        }

        static TokenType NFA_COMPOSITE_1(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            TokenType type= null;
            if (ch== '-') {
                nextStates.set(128);
            }
            else if (ch>='0'&&ch<='9') {
                nextStates.set(128);
                if (validTypes.contains(DOUBLE)) type= DOUBLE;
            }
            return type;
        }

        static TokenType NFA_COMPOSITE_2(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            TokenType type= null;
            if (ch== '.') {
                nextStates.set(57);
                if (validTypes.contains(DOUBLE)) type= DOUBLE;
            }
            else if (ch>='0'&&ch<='9') {
                nextStates.set(2);
                if (validTypes.contains(DOUBLE)) type= DOUBLE;
            }
            return type;
        }

        static TokenType NFA_COMPOSITE_3(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            TokenType type= null;
            if ((ch== '+')||(ch== '-')) {
                nextStates.set(124);
            }
            else if (ch>='0'&&ch<='9') {
                nextStates.set(2);
                if (validTypes.contains(DOUBLE)) type= DOUBLE;
            }
            return type;
        }

        static TokenType NFA_COMPOSITE_4(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            TokenType type= null;
            if ((ch== 'E')||(ch== 'e')) {
                nextStates.set(1);
            }
            else if (ch>='0'&&ch<='9') {
                nextStates.set(4);
                if (validTypes.contains(DOUBLE)) type= DOUBLE;
            }
            return type;
        }

        static TokenType NFA_COMPOSITE_5(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            TokenType type= null;
            if ((ch== 'M')||(ch== 'm')) {
                if (validTypes.contains(ZoM)) type= ZoM;
            }
            else if ((ch== 'Z')||(ch== 'z')) {
                if (validTypes.contains(ZoM)) type= ZoM;
            }
            return type;
        }

        static TokenType NFA_COMPOSITE_6(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            TokenType type= null;
            if ((ch== '+')||(ch== '-')) {
                nextStates.set(124);
            }
            else if (ch== '.') {
                nextStates.set(131);
            }
            else if (ch>='0'&&ch<='9') {
                nextStates.set(2);
                if (validTypes.contains(DOUBLE)) type= DOUBLE;
            }
            return type;
        }

        static TokenType NFA_7(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'E')||(ch== 'e')) {
                nextStates.set(43);
            }
            return null;
        }

        static TokenType NFA_8(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'N')||(ch== 'n')) {
                nextStates.set(101);
            }
            return null;
        }

        static TokenType NFA_9(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'T')||(ch== 't')) {
                nextStates.set(39);
            }
            return null;
        }

        static TokenType NFA_10(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'A')||(ch== 'a')) {
                nextStates.set(50);
            }
            return null;
        }

        static TokenType NFA_11(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'S')||(ch== 's')) {
                nextStates.set(29);
            }
            return null;
        }

        static TokenType NFA_12(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'E')||(ch== 'e')) {
                if (validTypes.contains(POLYHEDRALSURFACE)) return POLYHEDRALSURFACE;
            }
            return null;
        }

        static TokenType NFA_13(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'I')||(ch== 'i')) {
                nextStates.set(30);
            }
            return null;
        }

        static TokenType NFA_14(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'I')||(ch== 'i')) {
                nextStates.set(114);
            }
            return null;
        }

        static TokenType NFA_15(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'L')||(ch== 'l')) {
                nextStates.set(23);
            }
            return null;
        }

        static TokenType NFA_16(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'F')||(ch== 'f')) {
                nextStates.set(10);
            }
            return null;
        }

        static TokenType NFA_17(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'T')||(ch== 't')) {
                if (validTypes.contains(MULTIPOINT)) return MULTIPOINT;
            }
            return null;
        }

        static TokenType NFA_18(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'T')||(ch== 't')) {
                nextStates.set(74);
            }
            return null;
        }

        static TokenType NFA_19(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'O')||(ch== 'o')) {
                nextStates.set(87);
            }
            return null;
        }

        static TokenType NFA_20(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'I')||(ch== 'i')) {
                nextStates.set(27);
            }
            return null;
        }

        static TokenType NFA_21(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'L')||(ch== 'l')) {
                nextStates.set(11);
            }
            return null;
        }

        static TokenType NFA_22(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'L')||(ch== 'l')) {
                nextStates.set(65);
            }
            return null;
        }

        static TokenType NFA_23(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'T')||(ch== 't')) {
                nextStates.set(95);
            }
            return null;
        }

        static TokenType NFA_24(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'Z')||(ch== 'z')) {
                nextStates.set(49);
            }
            return null;
        }

        static TokenType NFA_25(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'A')||(ch== 'a')) {
                nextStates.set(117);
            }
            return null;
        }

        static TokenType NFA_26(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'A')||(ch== 'a')) {
                nextStates.set(21);
            }
            return null;
        }

        static TokenType NFA_27(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'N')||(ch== 'n')) {
                nextStates.set(7);
            }
            return null;
        }

        static TokenType NFA_28(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'G')||(ch== 'g')) {
                nextStates.set(42);
            }
            return null;
        }

        static TokenType NFA_29(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'U')||(ch== 'u')) {
                nextStates.set(75);
            }
            return null;
        }

        static TokenType NFA_30(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'P')||(ch== 'p')) {
                nextStates.set(88);
            }
            return null;
        }

        static TokenType NFA_31(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch== '\r') {
                if (validTypes.contains(_TOKEN_4)) return _TOKEN_4;
            }
            return null;
        }

        static TokenType NFA_32(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'I')||(ch== 'i')) {
                nextStates.set(8);
            }
            return null;
        }

        static TokenType NFA_33(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'Y')||(ch== 'y')) {
                nextStates.set(28);
            }
            return null;
        }

        static TokenType NFA_34(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'M')||(ch== 'm')) {
                nextStates.set(100);
            }
            return null;
        }

        static TokenType NFA_35(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'I')||(ch== 'i')) {
                nextStates.set(70);
            }
            return null;
        }

        static TokenType NFA_36(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'R')||(ch== 'r')) {
                nextStates.set(32);
            }
            return null;
        }

        static TokenType NFA_37(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'P')||(ch== 'p')) {
                nextStates.set(60);
            }
            return null;
        }

        static TokenType NFA_38(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'L')||(ch== 'l')) {
                nextStates.set(40);
            }
            return null;
        }

        static TokenType NFA_39(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'R')||(ch== 'r')) {
                nextStates.set(93);
            }
            return null;
        }

        static TokenType NFA_40(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'T')||(ch== 't')) {
                nextStates.set(13);
            }
            return null;
        }

        static TokenType NFA_41(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'E')||(ch== 'e')) {
                if (validTypes.contains(TRIANGLE)) return TRIANGLE;
            }
            return null;
        }

        static TokenType NFA_42(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'O')||(ch== 'o')) {
                nextStates.set(52);
            }
            return null;
        }

        static TokenType NFA_43(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'S')||(ch== 's')) {
                nextStates.set(109);
            }
            return null;
        }

        static TokenType NFA_44(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch== '(') {
                if (validTypes.contains(LB)) return LB;
            }
            return null;
        }

        static TokenType NFA_45(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'L')||(ch== 'l')) {
                nextStates.set(99);
            }
            return null;
        }

        static TokenType NFA_46(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch== ' ') {
                if (validTypes.contains(_TOKEN_1)) return _TOKEN_1;
            }
            return null;
        }

        static TokenType NFA_47(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'G')||(ch== 'g')) {
                nextStates.set(103);
            }
            return null;
        }

        static TokenType NFA_48(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'Y')||(ch== 'y')) {
                nextStates.set(47);
            }
            return null;
        }

        static TokenType NFA_49(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'M')||(ch== 'm')) {
                if (validTypes.contains(ZaM)) return ZaM;
            }
            return null;
        }

        static TokenType NFA_50(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'C')||(ch== 'c')) {
                nextStates.set(12);
            }
            return null;
        }

        static TokenType NFA_51(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'D')||(ch== 'd')) {
                nextStates.set(82);
            }
            return null;
        }

        static TokenType NFA_52(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'N')||(ch== 'n')) {
                if (validTypes.contains(MULTIPOLYGON)) return MULTIPOLYGON;
            }
            return null;
        }

        static TokenType NFA_53(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'L')||(ch== 'l')) {
                nextStates.set(22);
            }
            return null;
        }

        static TokenType NFA_54(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'N')||(ch== 'n')) {
                nextStates.set(73);
            }
            return null;
        }

        static TokenType NFA_55(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'I')||(ch== 'i')) {
                nextStates.set(89);
            }
            return null;
        }

        static TokenType NFA_56(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'N')||(ch== 'n')) {
                if (validTypes.contains(TIN)) return TIN;
            }
            return null;
        }

        static TokenType NFA_57(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch>='0'&&ch<='9') {
                nextStates.set(57);
                if (validTypes.contains(DOUBLE)) return DOUBLE;
            }
            return null;
        }

        static TokenType NFA_58(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'O')||(ch== 'o')) {
                nextStates.set(66);
            }
            return null;
        }

        static TokenType NFA_59(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'C')||(ch== 'c')) {
                nextStates.set(121);
            }
            return null;
        }

        static TokenType NFA_60(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'O')||(ch== 'o')) {
                nextStates.set(83);
            }
            return null;
        }

        static TokenType NFA_61(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'U')||(ch== 'u')) {
                nextStates.set(91);
            }
            return null;
        }

        static TokenType NFA_62(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'C')||(ch== 'c')) {
                nextStates.set(90);
            }
            return null;
        }

        static TokenType NFA_63(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'G')||(ch== 'g')) {
                nextStates.set(76);
            }
            return null;
        }

        static TokenType NFA_64(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'I')||(ch== 'i')) {
                nextStates.set(19);
            }
            return null;
        }

        static TokenType NFA_65(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'E')||(ch== 'e')) {
                nextStates.set(59);
            }
            return null;
        }

        static TokenType NFA_66(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'L')||(ch== 'l')) {
                nextStates.set(48);
            }
            return null;
        }

        static TokenType NFA_67(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'E')||(ch== 'e')) {
                nextStates.set(51);
            }
            return null;
        }

        static TokenType NFA_68(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'P')||(ch== 'p')) {
                nextStates.set(94);
            }
            return null;
        }

        static TokenType NFA_69(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'P')||(ch== 'p')) {
                nextStates.set(111);
            }
            return null;
        }

        static TokenType NFA_70(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'N')||(ch== 'n')) {
                nextStates.set(104);
            }
            return null;
        }

        static TokenType NFA_71(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'I')||(ch== 'i')) {
                nextStates.set(54);
            }
            return null;
        }

        static TokenType NFA_72(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch== ')') {
                if (validTypes.contains(RB)) return RB;
            }
            return null;
        }

        static TokenType NFA_73(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'G')||(ch== 'g')) {
                if (validTypes.contains(LINESTRING)) return LINESTRING;
            }
            return null;
        }

        static TokenType NFA_74(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'I')||(ch== 'i')) {
                nextStates.set(56);
            }
            return null;
        }

        static TokenType NFA_75(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'R')||(ch== 'r')) {
                nextStates.set(16);
            }
            return null;
        }

        static TokenType NFA_76(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'L')||(ch== 'l')) {
                nextStates.set(41);
            }
            return null;
        }

        static TokenType NFA_77(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'E')||(ch== 'e')) {
                nextStates.set(118);
            }
            return null;
        }

        static TokenType NFA_78(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'Y')||(ch== 'y')) {
                nextStates.set(62);
            }
            return null;
        }

        static TokenType NFA_79(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'L')||(ch== 'l')) {
                nextStates.set(20);
            }
            return null;
        }

        static TokenType NFA_80(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'N')||(ch== 'n')) {
                if (validTypes.contains(POLYGON)) return POLYGON;
            }
            return null;
        }

        static TokenType NFA_81(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch== ',') {
                if (validTypes.contains(COMMA)) return COMMA;
            }
            return null;
        }

        static TokenType NFA_82(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'R')||(ch== 'r')) {
                nextStates.set(26);
            }
            return null;
        }

        static TokenType NFA_83(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'L')||(ch== 'l')) {
                nextStates.set(33);
            }
            return null;
        }

        static TokenType NFA_84(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'M')||(ch== 'm')) {
                nextStates.set(92);
            }
            return null;
        }

        static TokenType NFA_85(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'S')||(ch== 's')) {
                nextStates.set(105);
            }
            return null;
        }

        static TokenType NFA_86(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'R')||(ch== 'r')) {
                nextStates.set(78);
            }
            return null;
        }

        static TokenType NFA_87(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'N')||(ch== 'n')) {
                if (validTypes.contains(GEOMETRYCOLLECTION)) return GEOMETRYCOLLECTION;
            }
            return null;
        }

        static TokenType NFA_88(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'O')||(ch== 'o')) {
                nextStates.set(14);
            }
            return null;
        }

        static TokenType NFA_89(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'N')||(ch== 'n')) {
                nextStates.set(119);
            }
            return null;
        }

        static TokenType NFA_90(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'O')||(ch== 'o')) {
                nextStates.set(53);
            }
            return null;
        }

        static TokenType NFA_91(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'L')||(ch== 'l')) {
                nextStates.set(107);
            }
            return null;
        }

        static TokenType NFA_92(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'U')||(ch== 'u')) {
                nextStates.set(15);
            }
            return null;
        }

        static TokenType NFA_93(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'I')||(ch== 'i')) {
                nextStates.set(25);
            }
            return null;
        }

        static TokenType NFA_94(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'O')||(ch== 'o')) {
                nextStates.set(35);
            }
            return null;
        }

        static TokenType NFA_95(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'I')||(ch== 'i')) {
                nextStates.set(102);
            }
            return null;
        }

        static TokenType NFA_96(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'E')||(ch== 'e')) {
                nextStates.set(120);
            }
            return null;
        }

        static TokenType NFA_97(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch== '\n') {
                if (validTypes.contains(_TOKEN_3)) return _TOKEN_3;
            }
            return null;
        }

        static TokenType NFA_98(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'M')||(ch== 'm')) {
                nextStates.set(61);
            }
            return null;
        }

        static TokenType NFA_99(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'Y')||(ch== 'y')) {
                nextStates.set(116);
            }
            return null;
        }

        static TokenType NFA_100(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'U')||(ch== 'u')) {
                nextStates.set(38);
            }
            return null;
        }

        static TokenType NFA_101(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'G')||(ch== 'g')) {
                if (validTypes.contains(MULTILINESTRING)) return MULTILINESTRING;
            }
            return null;
        }

        static TokenType NFA_102(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'L')||(ch== 'l')) {
                nextStates.set(55);
            }
            return null;
        }

        static TokenType NFA_103(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'O')||(ch== 'o')) {
                nextStates.set(80);
            }
            return null;
        }

        static TokenType NFA_104(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'T')||(ch== 't')) {
                if (validTypes.contains(POINT)) return POINT;
            }
            return null;
        }

        static TokenType NFA_105(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'T')||(ch== 't')) {
                nextStates.set(36);
            }
            return null;
        }

        static TokenType NFA_106(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'M')||(ch== 'm')) {
                nextStates.set(77);
            }
            return null;
        }

        static TokenType NFA_107(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'T')||(ch== 't')) {
                nextStates.set(108);
            }
            return null;
        }

        static TokenType NFA_108(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'I')||(ch== 'i')) {
                nextStates.set(37);
            }
            return null;
        }

        static TokenType NFA_109(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'T')||(ch== 't')) {
                nextStates.set(110);
            }
            return null;
        }

        static TokenType NFA_110(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'R')||(ch== 'r')) {
                nextStates.set(71);
            }
            return null;
        }

        static TokenType NFA_111(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'O')||(ch== 'o')) {
                nextStates.set(45);
            }
            return null;
        }

        static TokenType NFA_112(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'G')||(ch== 'g')) {
                nextStates.set(96);
            }
            return null;
        }

        static TokenType NFA_113(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'P')||(ch== 'p')) {
                nextStates.set(58);
            }
            return null;
        }

        static TokenType NFA_114(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'N')||(ch== 'n')) {
                nextStates.set(17);
            }
            return null;
        }

        static TokenType NFA_115(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch== '\t') {
                if (validTypes.contains(_TOKEN_2)) return _TOKEN_2;
            }
            return null;
        }

        static TokenType NFA_116(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'H')||(ch== 'h')) {
                nextStates.set(67);
            }
            return null;
        }

        static TokenType NFA_117(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'N')||(ch== 'n')) {
                nextStates.set(63);
            }
            return null;
        }

        static TokenType NFA_118(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'T')||(ch== 't')) {
                nextStates.set(86);
            }
            return null;
        }

        static TokenType NFA_119(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'E')||(ch== 'e')) {
                nextStates.set(85);
            }
            return null;
        }

        static TokenType NFA_120(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'O')||(ch== 'o')) {
                nextStates.set(106);
            }
            return null;
        }

        static TokenType NFA_121(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'T')||(ch== 't')) {
                nextStates.set(64);
            }
            return null;
        }

        static TokenType NFA_122(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'Z')||(ch== 'z')) {
                if (validTypes.contains(ZoM)) return ZoM;
            }
            return null;
        }

        static TokenType NFA_123(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== '+')||(ch== '-')) {
                nextStates.set(124);
            }
            return null;
        }

        static TokenType NFA_124(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch>='0'&&ch<='9') {
                nextStates.set(2);
                if (validTypes.contains(DOUBLE)) return DOUBLE;
            }
            return null;
        }

        static TokenType NFA_125(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'M')||(ch== 'm')) {
                if (validTypes.contains(ZoM)) return ZoM;
            }
            return null;
        }

        static TokenType NFA_126(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'E')||(ch== 'e')) {
                nextStates.set(1);
            }
            return null;
        }

        static TokenType NFA_127(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch== '-') {
                nextStates.set(128);
            }
            return null;
        }

        static TokenType NFA_128(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch>='0'&&ch<='9') {
                nextStates.set(128);
                if (validTypes.contains(DOUBLE)) return DOUBLE;
            }
            return null;
        }

        static TokenType NFA_129(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch== '.') {
                nextStates.set(57);
                if (validTypes.contains(DOUBLE)) return DOUBLE;
            }
            return null;
        }

        static TokenType NFA_130(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch== '.') {
                nextStates.set(131);
            }
            return null;
        }

        static TokenType NFA_131(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch>='0'&&ch<='9') {
                nextStates.set(4);
                if (validTypes.contains(DOUBLE)) return DOUBLE;
            }
            return null;
        }

        static private void NFA_FUNCTIONS_init() {
            NfaFunction[] functions= new NfaFunction[132];
            functions[0]= DEFAULT::NFA_COMPOSITE_0;
            functions[1]= DEFAULT::NFA_COMPOSITE_1;
            functions[2]= DEFAULT::NFA_COMPOSITE_2;
            functions[3]= DEFAULT::NFA_COMPOSITE_3;
            functions[4]= DEFAULT::NFA_COMPOSITE_4;
            functions[5]= DEFAULT::NFA_COMPOSITE_5;
            functions[6]= DEFAULT::NFA_COMPOSITE_6;
            functions[7]= DEFAULT::NFA_7;
            functions[8]= DEFAULT::NFA_8;
            functions[9]= DEFAULT::NFA_9;
            functions[10]= DEFAULT::NFA_10;
            functions[11]= DEFAULT::NFA_11;
            functions[12]= DEFAULT::NFA_12;
            functions[13]= DEFAULT::NFA_13;
            functions[14]= DEFAULT::NFA_14;
            functions[15]= DEFAULT::NFA_15;
            functions[16]= DEFAULT::NFA_16;
            functions[17]= DEFAULT::NFA_17;
            functions[18]= DEFAULT::NFA_18;
            functions[19]= DEFAULT::NFA_19;
            functions[20]= DEFAULT::NFA_20;
            functions[21]= DEFAULT::NFA_21;
            functions[22]= DEFAULT::NFA_22;
            functions[23]= DEFAULT::NFA_23;
            functions[24]= DEFAULT::NFA_24;
            functions[25]= DEFAULT::NFA_25;
            functions[26]= DEFAULT::NFA_26;
            functions[27]= DEFAULT::NFA_27;
            functions[28]= DEFAULT::NFA_28;
            functions[29]= DEFAULT::NFA_29;
            functions[30]= DEFAULT::NFA_30;
            functions[31]= DEFAULT::NFA_31;
            functions[32]= DEFAULT::NFA_32;
            functions[33]= DEFAULT::NFA_33;
            functions[34]= DEFAULT::NFA_34;
            functions[35]= DEFAULT::NFA_35;
            functions[36]= DEFAULT::NFA_36;
            functions[37]= DEFAULT::NFA_37;
            functions[38]= DEFAULT::NFA_38;
            functions[39]= DEFAULT::NFA_39;
            functions[40]= DEFAULT::NFA_40;
            functions[41]= DEFAULT::NFA_41;
            functions[42]= DEFAULT::NFA_42;
            functions[43]= DEFAULT::NFA_43;
            functions[44]= DEFAULT::NFA_44;
            functions[45]= DEFAULT::NFA_45;
            functions[46]= DEFAULT::NFA_46;
            functions[47]= DEFAULT::NFA_47;
            functions[48]= DEFAULT::NFA_48;
            functions[49]= DEFAULT::NFA_49;
            functions[50]= DEFAULT::NFA_50;
            functions[51]= DEFAULT::NFA_51;
            functions[52]= DEFAULT::NFA_52;
            functions[53]= DEFAULT::NFA_53;
            functions[54]= DEFAULT::NFA_54;
            functions[55]= DEFAULT::NFA_55;
            functions[56]= DEFAULT::NFA_56;
            functions[57]= DEFAULT::NFA_57;
            functions[58]= DEFAULT::NFA_58;
            functions[59]= DEFAULT::NFA_59;
            functions[60]= DEFAULT::NFA_60;
            functions[61]= DEFAULT::NFA_61;
            functions[62]= DEFAULT::NFA_62;
            functions[63]= DEFAULT::NFA_63;
            functions[64]= DEFAULT::NFA_64;
            functions[65]= DEFAULT::NFA_65;
            functions[66]= DEFAULT::NFA_66;
            functions[67]= DEFAULT::NFA_67;
            functions[68]= DEFAULT::NFA_68;
            functions[69]= DEFAULT::NFA_69;
            functions[70]= DEFAULT::NFA_70;
            functions[71]= DEFAULT::NFA_71;
            functions[72]= DEFAULT::NFA_72;
            functions[73]= DEFAULT::NFA_73;
            functions[74]= DEFAULT::NFA_74;
            functions[75]= DEFAULT::NFA_75;
            functions[76]= DEFAULT::NFA_76;
            functions[77]= DEFAULT::NFA_77;
            functions[78]= DEFAULT::NFA_78;
            functions[79]= DEFAULT::NFA_79;
            functions[80]= DEFAULT::NFA_80;
            functions[81]= DEFAULT::NFA_81;
            functions[82]= DEFAULT::NFA_82;
            functions[83]= DEFAULT::NFA_83;
            functions[84]= DEFAULT::NFA_84;
            functions[85]= DEFAULT::NFA_85;
            functions[86]= DEFAULT::NFA_86;
            functions[87]= DEFAULT::NFA_87;
            functions[88]= DEFAULT::NFA_88;
            functions[89]= DEFAULT::NFA_89;
            functions[90]= DEFAULT::NFA_90;
            functions[91]= DEFAULT::NFA_91;
            functions[92]= DEFAULT::NFA_92;
            functions[93]= DEFAULT::NFA_93;
            functions[94]= DEFAULT::NFA_94;
            functions[95]= DEFAULT::NFA_95;
            functions[96]= DEFAULT::NFA_96;
            functions[97]= DEFAULT::NFA_97;
            functions[98]= DEFAULT::NFA_98;
            functions[99]= DEFAULT::NFA_99;
            functions[100]= DEFAULT::NFA_100;
            functions[101]= DEFAULT::NFA_101;
            functions[102]= DEFAULT::NFA_102;
            functions[103]= DEFAULT::NFA_103;
            functions[104]= DEFAULT::NFA_104;
            functions[105]= DEFAULT::NFA_105;
            functions[106]= DEFAULT::NFA_106;
            functions[107]= DEFAULT::NFA_107;
            functions[108]= DEFAULT::NFA_108;
            functions[109]= DEFAULT::NFA_109;
            functions[110]= DEFAULT::NFA_110;
            functions[111]= DEFAULT::NFA_111;
            functions[112]= DEFAULT::NFA_112;
            functions[113]= DEFAULT::NFA_113;
            functions[114]= DEFAULT::NFA_114;
            functions[115]= DEFAULT::NFA_115;
            functions[116]= DEFAULT::NFA_116;
            functions[117]= DEFAULT::NFA_117;
            functions[118]= DEFAULT::NFA_118;
            functions[119]= DEFAULT::NFA_119;
            functions[120]= DEFAULT::NFA_120;
            functions[121]= DEFAULT::NFA_121;
            functions[122]= DEFAULT::NFA_122;
            functions[123]= DEFAULT::NFA_123;
            functions[124]= DEFAULT::NFA_124;
            functions[125]= DEFAULT::NFA_125;
            functions[126]= DEFAULT::NFA_126;
            functions[127]= DEFAULT::NFA_127;
            functions[128]= DEFAULT::NFA_128;
            functions[129]= DEFAULT::NFA_129;
            functions[130]= DEFAULT::NFA_130;
            functions[131]= DEFAULT::NFA_131;
            nfaFunctions= functions;
        }

    }
}
