/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.frostserver.util.wktparser;

import de.fraunhofer.iosb.ilt.frostserver.util.wktparser.InvalidToken;
import de.fraunhofer.iosb.ilt.frostserver.util.wktparser.Node;
import de.fraunhofer.iosb.ilt.frostserver.util.wktparser.WConstants;
import de.fraunhofer.iosb.ilt.frostserver.util.wktparser.WLexer;
import de.fraunhofer.iosb.ilt.frostserver.util.wktparser.nodes.COMMA;
import de.fraunhofer.iosb.ilt.frostserver.util.wktparser.nodes.DOUBLE;
import de.fraunhofer.iosb.ilt.frostserver.util.wktparser.nodes.GEOMETRYCOLLECTION;
import de.fraunhofer.iosb.ilt.frostserver.util.wktparser.nodes.LB;
import de.fraunhofer.iosb.ilt.frostserver.util.wktparser.nodes.LINESTRING;
import de.fraunhofer.iosb.ilt.frostserver.util.wktparser.nodes.MULTILINESTRING;
import de.fraunhofer.iosb.ilt.frostserver.util.wktparser.nodes.MULTIPOINT;
import de.fraunhofer.iosb.ilt.frostserver.util.wktparser.nodes.MULTIPOLYGON;
import de.fraunhofer.iosb.ilt.frostserver.util.wktparser.nodes.POINT;
import de.fraunhofer.iosb.ilt.frostserver.util.wktparser.nodes.POLYGON;
import de.fraunhofer.iosb.ilt.frostserver.util.wktparser.nodes.POLYHEDRALSURFACE;
import de.fraunhofer.iosb.ilt.frostserver.util.wktparser.nodes.RB;
import de.fraunhofer.iosb.ilt.frostserver.util.wktparser.nodes.TIN;
import de.fraunhofer.iosb.ilt.frostserver.util.wktparser.nodes.TRIANGLE;
import de.fraunhofer.iosb.ilt.frostserver.util.wktparser.nodes.ZaM;
import de.fraunhofer.iosb.ilt.frostserver.util.wktparser.nodes.ZoM;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

public class Token
implements WConstants,
Node {
    private WConstants.TokenType type;
    private WLexer tokenSource;
    private int beginOffset;
    private int endOffset;
    private boolean unparsed;
    private Node parent;
    private String image;
    private Token prependedToken;
    private Token appendedToken;
    private boolean inserted;

    public void setImage(String image) {
        this.image = image;
    }

    public boolean isInserted() {
        return this.inserted;
    }

    public void preInsert(Token prependedToken) {
        if (prependedToken == this.prependedToken) {
            return;
        }
        prependedToken.appendedToken = this;
        Token existingPreviousToken = this.previousCachedToken();
        if (existingPreviousToken != null) {
            existingPreviousToken.appendedToken = prependedToken;
            prependedToken.prependedToken = existingPreviousToken;
        }
        prependedToken.inserted = true;
        prependedToken.beginOffset = prependedToken.endOffset = this.beginOffset;
        this.prependedToken = prependedToken;
    }

    void unsetAppendedToken() {
        this.appendedToken = null;
    }

    public Token(WConstants.TokenType type, String image, WLexer tokenSource) {
        this.type = type;
        this.image = image;
        this.tokenSource = tokenSource;
    }

    public static Token newToken(WConstants.TokenType type, String image, WLexer tokenSource) {
        Token result = Token.newToken(type, tokenSource, 0, 0);
        result.setImage(image);
        return result;
    }

    @Override
    public void setBeginOffset(int beginOffset) {
        this.beginOffset = beginOffset;
    }

    @Override
    public void setEndOffset(int endOffset) {
        this.endOffset = endOffset;
    }

    @Override
    public WLexer getTokenSource() {
        WLexer flm = this.tokenSource;
        if (flm == null) {
            if (this.prependedToken != null) {
                flm = this.prependedToken.getTokenSource();
            }
            if (flm == null && this.appendedToken != null) {
                flm = this.appendedToken.getTokenSource();
            }
        }
        return flm;
    }

    @Override
    public void setTokenSource(WLexer tokenSource) {
        this.tokenSource = tokenSource;
    }

    public WConstants.TokenType getType() {
        return this.type;
    }

    protected void setType(WConstants.TokenType type) {
        this.type = type;
    }

    public boolean isVirtual() {
        return this.type == WConstants.TokenType.EOF;
    }

    public boolean isSkipped() {
        return false;
    }

    @Override
    public int getBeginOffset() {
        return this.beginOffset;
    }

    @Override
    public int getEndOffset() {
        return this.endOffset;
    }

    public String getImage() {
        return this.image != null ? this.image : this.getSource();
    }

    public final Token getNext() {
        return this.getNextParsedToken();
    }

    public final Token getPrevious() {
        Token result;
        for (result = this.previousCachedToken(); result != null && result.isUnparsed(); result = result.previousCachedToken()) {
        }
        return result;
    }

    private Token getNextParsedToken() {
        Token result;
        for (result = this.nextCachedToken(); result != null && result.isUnparsed(); result = result.nextCachedToken()) {
        }
        return result;
    }

    public Token nextCachedToken() {
        if (this.appendedToken != null) {
            return this.appendedToken;
        }
        WLexer tokenSource = this.getTokenSource();
        return tokenSource != null ? tokenSource.nextCachedToken(this.getEndOffset()) : null;
    }

    public Token previousCachedToken() {
        if (this.prependedToken != null) {
            return this.prependedToken;
        }
        if (this.getTokenSource() == null) {
            return null;
        }
        return this.getTokenSource().previousCachedToken(this.getBeginOffset());
    }

    Token getPreviousToken() {
        return this.previousCachedToken();
    }

    public Token replaceType(WConstants.TokenType type) {
        Token result = Token.newToken(type, this.getTokenSource(), this.getBeginOffset(), this.getEndOffset());
        result.prependedToken = this.prependedToken;
        result.appendedToken = this.appendedToken;
        result.inserted = this.inserted;
        if (result.appendedToken != null) {
            result.appendedToken.prependedToken = result;
        }
        if (result.prependedToken != null) {
            result.prependedToken.appendedToken = result;
        }
        if (!result.inserted) {
            this.getTokenSource().cacheToken(result);
        }
        return result;
    }

    @Override
    public String getSource() {
        if (this.type == WConstants.TokenType.EOF) {
            return "";
        }
        WLexer flm = this.getTokenSource();
        return flm == null ? null : flm.getText(this.getBeginOffset(), this.getEndOffset());
    }

    protected Token() {
    }

    public Token(WConstants.TokenType type, WLexer tokenSource, int beginOffset, int endOffset) {
        this.type = type;
        this.tokenSource = tokenSource;
        this.beginOffset = beginOffset;
        this.endOffset = endOffset;
    }

    @Override
    public boolean isUnparsed() {
        return this.unparsed;
    }

    @Override
    public void setUnparsed(boolean unparsed) {
        this.unparsed = unparsed;
    }

    @Override
    public void clearChildren() {
    }

    public String getNormalizedText() {
        if (this.getType() == WConstants.TokenType.EOF) {
            return "EOF";
        }
        return this.getImage();
    }

    public String toString() {
        return this.getNormalizedText();
    }

    public Iterator<Token> precedingTokens() {
        return new Iterator<Token>(){
            Token currentPoint;
            {
                this.currentPoint = Token.this;
            }

            @Override
            public boolean hasNext() {
                return this.currentPoint.previousCachedToken() != null;
            }

            @Override
            public Token next() {
                Token previous = this.currentPoint.previousCachedToken();
                if (previous == null) {
                    throw new NoSuchElementException("No previous token!");
                }
                this.currentPoint = previous;
                return this.currentPoint;
            }
        };
    }

    public List<Token> precedingUnparsedTokens() {
        ArrayList<Token> result = new ArrayList<Token>();
        for (Token t = this.previousCachedToken(); t != null && t.isUnparsed(); t = t.previousCachedToken()) {
            result.add(t);
        }
        Collections.reverse(result);
        return result;
    }

    public Iterator<Token> followingTokens() {
        return new Iterator<Token>(){
            Token currentPoint;
            {
                this.currentPoint = Token.this;
            }

            @Override
            public boolean hasNext() {
                return this.currentPoint.nextCachedToken() != null;
            }

            @Override
            public Token next() {
                Token next = this.currentPoint.nextCachedToken();
                if (next == null) {
                    throw new NoSuchElementException("No next token!");
                }
                this.currentPoint = next;
                return this.currentPoint;
            }
        };
    }

    @Override
    public void copyLocationInfo(Node from) {
        Node.super.copyLocationInfo(from);
        if (from instanceof Token) {
            Token otherTok = (Token)from;
            this.appendedToken = otherTok.appendedToken;
            this.prependedToken = otherTok.prependedToken;
        }
        this.setTokenSource(from.getTokenSource());
    }

    @Override
    public void copyLocationInfo(Node start, Node end) {
        Node.super.copyLocationInfo(start, end);
        if (start instanceof Token) {
            this.prependedToken = ((Token)start).prependedToken;
        }
        if (end instanceof Token) {
            Token endToken = (Token)end;
            this.appendedToken = endToken.appendedToken;
        }
    }

    public static Token newToken(WConstants.TokenType type, WLexer tokenSource, int beginOffset, int endOffset) {
        switch (type) {
            case LB: {
                return new LB(WConstants.TokenType.LB, tokenSource, beginOffset, endOffset);
            }
            case RB: {
                return new RB(WConstants.TokenType.RB, tokenSource, beginOffset, endOffset);
            }
            case COMMA: {
                return new COMMA(WConstants.TokenType.COMMA, tokenSource, beginOffset, endOffset);
            }
            case DOUBLE: {
                return new DOUBLE(WConstants.TokenType.DOUBLE, tokenSource, beginOffset, endOffset);
            }
            case ZoM: {
                return new ZoM(WConstants.TokenType.ZoM, tokenSource, beginOffset, endOffset);
            }
            case ZaM: {
                return new ZaM(WConstants.TokenType.ZaM, tokenSource, beginOffset, endOffset);
            }
            case POINT: {
                return new POINT(WConstants.TokenType.POINT, tokenSource, beginOffset, endOffset);
            }
            case MULTIPOINT: {
                return new MULTIPOINT(WConstants.TokenType.MULTIPOINT, tokenSource, beginOffset, endOffset);
            }
            case LINESTRING: {
                return new LINESTRING(WConstants.TokenType.LINESTRING, tokenSource, beginOffset, endOffset);
            }
            case MULTILINESTRING: {
                return new MULTILINESTRING(WConstants.TokenType.MULTILINESTRING, tokenSource, beginOffset, endOffset);
            }
            case POLYGON: {
                return new POLYGON(WConstants.TokenType.POLYGON, tokenSource, beginOffset, endOffset);
            }
            case MULTIPOLYGON: {
                return new MULTIPOLYGON(WConstants.TokenType.MULTIPOLYGON, tokenSource, beginOffset, endOffset);
            }
            case TRIANGLE: {
                return new TRIANGLE(WConstants.TokenType.TRIANGLE, tokenSource, beginOffset, endOffset);
            }
            case TIN: {
                return new TIN(WConstants.TokenType.TIN, tokenSource, beginOffset, endOffset);
            }
            case POLYHEDRALSURFACE: {
                return new POLYHEDRALSURFACE(WConstants.TokenType.POLYHEDRALSURFACE, tokenSource, beginOffset, endOffset);
            }
            case GEOMETRYCOLLECTION: {
                return new GEOMETRYCOLLECTION(WConstants.TokenType.GEOMETRYCOLLECTION, tokenSource, beginOffset, endOffset);
            }
            case INVALID: {
                return new InvalidToken(tokenSource, beginOffset, endOffset);
            }
        }
        return new Token(type, tokenSource, beginOffset, endOffset);
    }

    @Override
    public String getLocation() {
        return this.getInputSource() + ":" + this.getBeginLine() + ":" + this.getBeginColumn();
    }

    @Override
    public void setChild(int i, Node n) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void addChild(Node n) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void addChild(int i, Node n) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Node removeChild(int i) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final int indexOf(Node n) {
        return -1;
    }

    @Override
    public Node getParent() {
        return this.parent;
    }

    @Override
    public void setParent(Node parent) {
        this.parent = parent;
    }

    @Override
    public final int getChildCount() {
        return 0;
    }

    @Override
    public final Node getChild(int i) {
        return null;
    }

    @Override
    public final List<Node> children() {
        return Collections.emptyList();
    }
}

