/* Generated by: JavaCC 21 Parser Generator. Token.java */
package de.fraunhofer.iosb.ilt.frostserver.util.pathparser;

import de.fraunhofer.iosb.ilt.frostserver.util.pathparser.nodes.*;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
public class Token implements PConstants, Node {
    private TokenType type;
    private PLexer tokenSource;
    private int beginOffset, endOffset;
    private boolean unparsed;
    private Node parent;
    private String image;
    public void setImage(String image) {
        this.image= image;
    }

    private Token prependedToken, appendedToken;
    private boolean inserted;
    public boolean isInserted() {
        return inserted;
    }

    public void preInsert(Token prependedToken) {
        if (prependedToken== this.prependedToken) return;
        prependedToken.appendedToken= this;
        Token existingPreviousToken= this.previousCachedToken();
        if (existingPreviousToken!=null) {
            existingPreviousToken.appendedToken= prependedToken;
            prependedToken.prependedToken= existingPreviousToken;
        }
        prependedToken.inserted= true;
        prependedToken.beginOffset= prependedToken.endOffset= this.beginOffset;
        this.prependedToken= prependedToken;
    }

    void unsetAppendedToken() {
        this.appendedToken= null;
    }

    /**
     * @param type the #TokenType of the token being constructed
     * @param image the String content of the token
     * @param tokenSource the object that vended this token.
     */
    public Token(TokenType type, String image, PLexer tokenSource) {
        this.type= type;
        this.image= image;
        this.tokenSource= tokenSource;
    }

    public static Token newToken(TokenType type, String image, PLexer tokenSource) {
        Token result= newToken(type, tokenSource, 0, 0);
        result.setImage(image);
        return result;
    }

    /**
     * It would be extremely rare that an application
     * programmer would use this method. It needs to
     * be public because it is part of the de.fraunhofer.iosb.ilt.frostserver.util.pathparser.Node interface.
     */
    public void setBeginOffset(int beginOffset) {
        this.beginOffset= beginOffset;
    }

    /**
     * It would be extremely rare that an application
     * programmer would use this method. It needs to
     * be public because it is part of the de.fraunhofer.iosb.ilt.frostserver.util.pathparser.Node interface.
     */
    public void setEndOffset(int endOffset) {
        this.endOffset= endOffset;
    }

    /**
     * @return the PLexer object that handles 
     * location info for the tokens. 
     */
    public PLexer getTokenSource() {
        PLexer flm= this.tokenSource;
        // If this is null and we have chained tokens,
        // we try to get it from there! (Why not?)
        if (flm== null) {
            if (prependedToken!=null) {
                flm= prependedToken.getTokenSource();
            }
            if (flm== null&&appendedToken!=null) {
                flm= appendedToken.getTokenSource();
            }
        }
        return flm;
    }

    /**
     * It should be exceedingly rare that an application
     * programmer needs to use this method.
     */
    public void setTokenSource(PLexer tokenSource) {
        this.tokenSource= tokenSource;
    }

    /**
     * Return the TokenType of this Token object
     */
    public TokenType getType() {
        return type;
    }

    protected void setType(TokenType type) {
        this.type= type;
    }

    /**
     * @return whether this Token represent actual input or was it inserted somehow?
     */
    public boolean isVirtual() {
        return type== TokenType.EOF;
    }

    /**
     * @return Did we skip this token in parsing?
     */
    public boolean isSkipped() {
        return false;
    }

    public int getBeginOffset() {
        return beginOffset;
    }

    public int getEndOffset() {
        return endOffset;
    }

    /**
     * @return the string image of the token.
     */
    public String getImage() {
        return image!=null?image:
        getSource();
    }

    /**
     * @return the next _cached_ regular (i.e. parsed) token
     * or null
     */
    public final Token getNext() {
        return getNextParsedToken();
    }

    /**
     * @return the previous regular (i.e. parsed) token
     * or null
     */
    public final Token getPrevious() {
        Token result= previousCachedToken();
        while (result!=null&&result.isUnparsed()) {
            result= result.previousCachedToken();
        }
        return result;
    }

    /**
     * @return the next regular (i.e. parsed) token
     */
    private Token getNextParsedToken() {
        Token result= nextCachedToken();
        while (result!=null&&result.isUnparsed()) {
            result= result.nextCachedToken();
        }
        return result;
    }

    /**
     * @return the next token of any sort (parsed or unparsed or invalid)
     */
    public Token nextCachedToken() {
        if (appendedToken!=null) return appendedToken;
        PLexer tokenSource= getTokenSource();
        return tokenSource!=null?tokenSource.nextCachedToken(getEndOffset()):
        null;
    }

    public Token previousCachedToken() {
        if (prependedToken!=null) return prependedToken;
        if (getTokenSource()== null) return null;
        return getTokenSource().previousCachedToken(getBeginOffset());
    }

    Token getPreviousToken() {
        return previousCachedToken();
    }

    public Token replaceType(TokenType type) {
        Token result= newToken(type, getTokenSource(), getBeginOffset(), getEndOffset());
        result.prependedToken= this.prependedToken;
        result.appendedToken= this.appendedToken;
        result.inserted= this.inserted;
        if (result.appendedToken!=null) {
            result.appendedToken.prependedToken= result;
        }
        if (result.prependedToken!=null) {
            result.prependedToken.appendedToken= result;
        }
        if (!result.inserted) {
            getTokenSource().cacheToken(result);
        }
        return result;
    }

    public String getSource() {
        if (type== TokenType.EOF) return"";
        PLexer flm= getTokenSource();
        return flm== null?null:
        flm.getText(getBeginOffset(), getEndOffset());
    }

    protected Token() {
    }

    public Token(TokenType type, PLexer tokenSource, int beginOffset, int endOffset) {
        this.type= type;
        this.tokenSource= tokenSource;
        this.beginOffset= beginOffset;
        this.endOffset= endOffset;
    }

    public boolean isUnparsed() {
        return unparsed;
    }

    public void setUnparsed(boolean unparsed) {
        this.unparsed= unparsed;
    }

    public void clearChildren() {
    }

    public String getNormalizedText() {
        if (getType()== TokenType.EOF) {
            return"EOF";
        }
        return getImage();
    }

    public String toString() {
        return getNormalizedText();
    }

    /**
     * @return An iterator of the tokens preceding this one.
     */
    public Iterator<Token> precedingTokens() {
        return new Iterator<Token> () {
            Token currentPoint= Token.this;
            public boolean hasNext() {
                return currentPoint.previousCachedToken()!=null;
            }

            public Token next() {
                Token previous= currentPoint.previousCachedToken();
                if (previous== null) throw new java.util.NoSuchElementException("No previous token!");
                return currentPoint= previous;
            }

        }
        ;
    }

    /**
     * @return a list of the unparsed tokens preceding this one in the order they appear in the input
     */
    public List<Token> precedingUnparsedTokens() {
        List<Token> result= new ArrayList<> ();
        Token t= this.previousCachedToken();
        while (t!=null&&t.isUnparsed()) {
            result.add(t);
            t= t.previousCachedToken();
        }
        Collections.reverse(result);
        return result;
    }

    /**
     * @return An iterator of the (cached) tokens that follow this one.
     */
    public Iterator<Token> followingTokens() {
        return new java.util.Iterator<Token> () {
            Token currentPoint= Token.this;
            public boolean hasNext() {
                return currentPoint.nextCachedToken()!=null;
            }

            public Token next() {
                Token next= currentPoint.nextCachedToken();
                if (next== null) throw new java.util.NoSuchElementException("No next token!");
                return currentPoint= next;
            }

        }
        ;
    }

    /**
     * Copy the location info from a Node
     */
    public void copyLocationInfo(Node from) {
        Node.super.copyLocationInfo(from);
        if (from instanceof Token) {
            Token otherTok= (Token) from;
            appendedToken= otherTok.appendedToken;
            prependedToken= otherTok.prependedToken;
        }
        setTokenSource(from.getTokenSource());
    }

    public void copyLocationInfo(Node start, Node end) {
        Node.super.copyLocationInfo(start, end);
        if (start instanceof Token) {
            prependedToken= ((Token) start).prependedToken;
        }
        if (end instanceof Token) {
            Token endToken= (Token) end;
            appendedToken= endToken.appendedToken;
        }
    }

    public static Token newToken(TokenType type, PLexer tokenSource, int beginOffset, int endOffset) {
        switch(type) {
            case T_PATH_SEPARATOR:
            return new T_PATH_SEPARATOR(TokenType.T_PATH_SEPARATOR, tokenSource, beginOffset, endOffset);
            case T_VALUE:
            return new T_VALUE(TokenType.T_VALUE, tokenSource, beginOffset, endOffset);
            case T_REF:
            return new T_REF(TokenType.T_REF, tokenSource, beginOffset, endOffset);
            case T_LB:
            return new T_LB(TokenType.T_LB, tokenSource, beginOffset, endOffset);
            case T_RB:
            return new T_RB(TokenType.T_RB, tokenSource, beginOffset, endOffset);
            case T_NAME:
            return new T_NAME(TokenType.T_NAME, tokenSource, beginOffset, endOffset);
            case T_LONG:
            return new T_LONG(TokenType.T_LONG, tokenSource, beginOffset, endOffset);
            case T_DOUBLE:
            return new T_DOUBLE(TokenType.T_DOUBLE, tokenSource, beginOffset, endOffset);
            case T_STR_LIT:
            return new T_STR_LIT(TokenType.T_STR_LIT, tokenSource, beginOffset, endOffset);
            case T_ARRAYINDEX:
            return new T_ARRAYINDEX(TokenType.T_ARRAYINDEX, tokenSource, beginOffset, endOffset);
            case INVALID:
            return new InvalidToken(tokenSource, beginOffset, endOffset);
            default:
            return new Token(type, tokenSource, beginOffset, endOffset);
        }
    }

    public String getLocation() {
        return getInputSource()+":"+getBeginLine()+":"+getBeginColumn();
    }

    public void setChild(int i, Node n) {
        throw new UnsupportedOperationException();
    }

    public void addChild(Node n) {
        throw new UnsupportedOperationException();
    }

    public void addChild(int i, Node n) {
        throw new UnsupportedOperationException();
    }

    public Node removeChild(int i) {
        throw new UnsupportedOperationException();
    }

    public final int indexOf(Node n) {
        return-1;
    }

    public Node getParent() {
        return parent;
    }

    public void setParent(Node parent) {
        this.parent= parent;
    }

    public final int getChildCount() {
        return 0;
    }

    public final Node getChild(int i) {
        return null;
    }

    public final List<Node> children() {
        return java.util.Collections.emptyList();
    }

}
