/* Generated by: JavaCC 21 Parser Generator. PParser.java */
package de.fraunhofer.iosb.ilt.frostserver.util.pathparser;

import java.util.Arrays;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Map;
import java.util.concurrent.CancellationException;
import java.io.*;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.charset.Charset;
import de.fraunhofer.iosb.ilt.frostserver.util.pathparser.nodes.Start;
import de.fraunhofer.iosb.ilt.frostserver.util.pathparser.nodes.P_PathElement;
import de.fraunhofer.iosb.ilt.frostserver.util.pathparser.nodes.P_EntityId;
import static de.fraunhofer.iosb.ilt.frostserver.util.pathparser.PConstants.TokenType.*;
@SuppressWarnings("unused")
public class PParser implements PConstants {
    static final int UNLIMITED= Integer.MAX_VALUE;
    // The last token successfully "consumed"
    Token lastConsumedToken;
    private TokenType nextTokenType;
    private Token currentLookaheadToken;
    private boolean scanToEnd;
    private String currentlyParsedProduction, currentLookaheadProduction;
    private boolean cancelled;
    public void cancel() {
        cancelled= true;
    }

    public boolean isCancelled() {
        return cancelled;
    }

    /** Generated Lexer. */
    public PLexer token_source;
    public void setInputSource(String inputSource) {
        token_source.setInputSource(inputSource);
    }

    String getInputSource() {
        return token_source.getInputSource();
    }

    //=================================
    // Generated constructors
    //=================================
    public PParser(String inputSource, CharSequence content) {
        this(new PLexer(inputSource, content));
    }

    public PParser(CharSequence content) {
        this("input", content);
    }

    /**
   * @param inputSource just the name of the input source (typically the filename) that 
   * will be used in error messages and so on.
   * @param path The location (typically the filename) from which to get the input to parse
   */
    public PParser(String inputSource, Path path) throws IOException {
        this(inputSource, PConstants.stringFromBytes(Files.readAllBytes(path)));
    }

    public PParser(String inputSource, Path path, Charset charset) throws IOException {
        this(inputSource, PConstants.stringFromBytes(Files.readAllBytes(path), charset));
    }

    /**
   * @param path The location (typically the filename) from which to get the input to parse
   */
    public PParser(Path path) throws IOException {
        this(path.toString(), path);
    }

    /**
   * @Deprecated Use the constructor that takes a #java.nio.files.Path or just 
   * a String (i.e. CharSequence) directly.
   */
    public PParser(java.io.InputStream stream) {
        this(new InputStreamReader(stream));
    }

    /**
   * @Deprecated Use the constructor that takes a #java.nio.files.Path or just 
   * a String (i.e. CharSequence) directly.
   */
    public PParser(Reader reader) {
        this(new PLexer("input", reader));
    }

    /** Constructor with user supplied Lexer. */
    public PParser(PLexer lexer) {
        token_source= lexer;
        lastConsumedToken= lexer.DUMMY_START_TOKEN;
        lastConsumedToken.setTokenSource(lexer);
    }

    // If the next token is cached, it returns that
    // Otherwise, it goes to the token_source, i.e. the Lexer.
    final private Token nextToken(final Token tok) {
        Token result= token_source.getNextToken(tok);
        while (result.isUnparsed()) {
            result= token_source.getNextToken(result);
        }
        nextTokenType= null;
        return result;
    }

    /**
   * @return the next Token off the stream. This is the same as #getToken(1)
   */
    final public Token getNextToken() {
        return getToken(1);
    }

    /**
 * @param index how many tokens to look ahead
 * @return the specific regular (i.e. parsed) Token index ahead/behind in the stream. 
 * If we are in a lookahead, it looks ahead from the currentLookaheadToken
 * Otherwise, it is the lastConsumedToken. If you pass in a negative
 * number it goes backward.
 */
    final public Token getToken(final int index) {
        Token t= currentLookaheadToken== null?lastConsumedToken:
        currentLookaheadToken;
        for (int i= 0; i<index; i++) {
            t= nextToken(t);
        }
        for (int i= 0; i> index; i--) {
            t= t.getPrevious();
            if (t== null) break;
        }
        return t;
    }

    private final TokenType nextTokenType() {
        if (nextTokenType== null) {
            nextTokenType= nextToken(lastConsumedToken).getType();
        }
        return nextTokenType;
    }

    boolean activateTokenTypes(TokenType...types) {
        boolean result= false;
        for (TokenType tt : types) {
            result|=token_source.activeTokenTypes.add(tt);
        }
        token_source.reset(getToken(0));
        nextTokenType= null;
        return result;
    }

    boolean deactivateTokenTypes(TokenType...types) {
        boolean result= false;
        for (TokenType tt : types) {
            result|=token_source.activeTokenTypes.remove(tt);
        }
        token_source.reset(getToken(0));
        nextTokenType= null;
        return result;
    }

    private static HashMap<TokenType[], EnumSet<TokenType> > enumSetCache= new HashMap<> ();
    private static EnumSet<TokenType> tokenTypeSet(TokenType first, TokenType...rest) {
        TokenType[] key= new TokenType[1+rest.length];
        key[0]= first;
        if (rest.length> 0) {
            System.arraycopy(rest, 0, key, 1, rest.length);
        }
        Arrays.sort(key);
        if (enumSetCache.containsKey(key)) {
            return enumSetCache.get(key);
        }
        EnumSet<TokenType> result= (rest.length== 0)?EnumSet.of(first):
        EnumSet.of(first, rest);
        enumSetCache.put(key, result);
        return result;
    }

    // src/main/congocc/pathParser.ccc:43:1
    final public Start Start() throws ParseException {
        if (cancelled) throw new CancellationException();
        String prevProduction= currentlyParsedProduction;
        this.currentlyParsedProduction= "Start";
        Start Start1= null;
        if (buildTree) {
            Start1= new Start();
            openNodeScope(Start1);
        }
        ParseException parseException1= null;
        int callStackSize2= parsingStack.size();
        try {
            if (false) throw new ParseException("Never happens!");
            // Code for RegexpRef specified at:
            // src/main/congocc/pathParser.ccc:44:3
            consumeToken(T_PATH_SEPARATOR);
            // Code for NonTerminal specified at:
            // src/main/congocc/pathParser.ccc:44:22
            pushOntoCallStack("Start", "src/main/congocc/pathParser.ccc", 44, 22);
            try {
                P_PathElement();
            }
            finally {
                popCallStack();
            }
            // Code for ZeroOrMore specified at:
            // src/main/congocc/pathParser.ccc:44:36
            while (true) {
                if (!(nextTokenType()== T_PATH_SEPARATOR)) break;
                // Code for RegexpRef specified at:
                // src/main/congocc/pathParser.ccc:44:37
                consumeToken(T_PATH_SEPARATOR);
                // Code for NonTerminal specified at:
                // src/main/congocc/pathParser.ccc:44:56
                pushOntoCallStack("Start", "src/main/congocc/pathParser.ccc", 44, 56);
                try {
                    P_PathElement();
                }
                finally {
                    popCallStack();
                }
            }
            // Code for ZeroOrOne specified at:
            // src/main/congocc/pathParser.ccc:44:72
            // Code for ExpansionChoice specified at:
            // src/main/congocc/pathParser.ccc:44:74
            if (nextTokenType()== T_REF) {
                // Code for RegexpRef specified at:
                // src/main/congocc/pathParser.ccc:44:74
                consumeToken(T_REF);
            }
            else if (nextTokenType()== T_VALUE) {
                // Code for RegexpRef specified at:
                // src/main/congocc/pathParser.ccc:44:84
                consumeToken(T_VALUE);
            }
            // Code for EndOfFile specified at:
            // src/main/congocc/pathParser.ccc:44:97
            consumeToken(EOF);
            // Code for CodeBlock specified at:
            // src/main/congocc/pathParser.ccc:44:103
            return Start1;
        }
        catch(ParseException e) {
            parseException1= e;
            throw e;
        }
        finally {
            restoreCallStack(callStackSize2);
            if (Start1!=null) {
                if (parseException1== null) {
                    closeNodeScope(Start1, nodeArity()> 1);
                }
                else  {
                    clearNodeScope();
                }
            }
            this.currentlyParsedProduction= prevProduction;
        }
    }

    // src/main/congocc/pathParser.ccc:47:1
    final public void P_PathElement() throws ParseException {
        if (cancelled) throw new CancellationException();
        String prevProduction= currentlyParsedProduction;
        this.currentlyParsedProduction= "P_PathElement";
        P_PathElement P_PathElement2= null;
        if (buildTree) {
            P_PathElement2= new P_PathElement();
            openNodeScope(P_PathElement2);
        }
        ParseException parseException46= null;
        int callStackSize47= parsingStack.size();
        try {
            if (false) throw new ParseException("Never happens!");
            // Code for RegexpRef specified at:
            // src/main/congocc/pathParser.ccc:48:3
            consumeToken(T_NAME);
            // Code for ZeroOrOne specified at:
            // src/main/congocc/pathParser.ccc:48:12
            // Code for ExpansionChoice specified at:
            // src/main/congocc/pathParser.ccc:48:14
            if (nextTokenType()== T_ARRAYINDEX) {
                // Code for NonTerminal specified at:
                // src/main/congocc/pathParser.ccc:48:14
                pushOntoCallStack("P_PathElement", "src/main/congocc/pathParser.ccc", 48, 14);
                try {
                    P_ArrayIndex();
                }
                finally {
                    popCallStack();
                }
            }
            else if (nextTokenType()== T_LB) {
                // Code for NonTerminal specified at:
                // src/main/congocc/pathParser.ccc:48:29
                pushOntoCallStack("P_PathElement", "src/main/congocc/pathParser.ccc", 48, 29);
                try {
                    P_EntityId();
                }
                finally {
                    popCallStack();
                }
            }
        }
        catch(ParseException e) {
            parseException46= e;
            throw e;
        }
        finally {
            restoreCallStack(callStackSize47);
            if (P_PathElement2!=null) {
                if (parseException46== null) {
                    closeNodeScope(P_PathElement2, nodeArity()> 1);
                }
                else  {
                    clearNodeScope();
                }
            }
            this.currentlyParsedProduction= prevProduction;
        }
    }

    // src/main/congocc/pathParser.ccc:51:1
    final public void P_EntityId() throws ParseException {
        if (cancelled) throw new CancellationException();
        String prevProduction= currentlyParsedProduction;
        this.currentlyParsedProduction= "P_EntityId";
        P_EntityId P_EntityId3= null;
        if (buildTree) {
            P_EntityId3= new P_EntityId();
            openNodeScope(P_EntityId3);
        }
        ParseException parseException70= null;
        int callStackSize71= parsingStack.size();
        try {
            if (false) throw new ParseException("Never happens!");
            // Code for RegexpRef specified at:
            // src/main/congocc/pathParser.ccc:52:5
            consumeToken(T_LB);
            if (nextTokenType()== T_LONG) {
                // Code for RegexpRef specified at:
                // src/main/congocc/pathParser.ccc:52:14
                consumeToken(T_LONG);
            }
            else if (nextTokenType()== T_STR_LIT) {
                // Code for RegexpRef specified at:
                // src/main/congocc/pathParser.ccc:52:25
                consumeToken(T_STR_LIT);
            }
            else  {
                pushOntoCallStack("P_EntityId", "src/main/congocc/pathParser.ccc", 52, 14);
                throw new ParseException(this, first_set$pathParser_ccc$52$14, parsingStack);
            }
            // Code for RegexpRef specified at:
            // src/main/congocc/pathParser.ccc:52:38
            consumeToken(T_RB);
        }
        catch(ParseException e) {
            parseException70= e;
            throw e;
        }
        finally {
            restoreCallStack(callStackSize71);
            if (P_EntityId3!=null) {
                if (parseException70== null) {
                    closeNodeScope(P_EntityId3, true);
                }
                else  {
                    clearNodeScope();
                }
            }
            this.currentlyParsedProduction= prevProduction;
        }
    }

    // src/main/congocc/pathParser.ccc:55:1
    final public void P_ArrayIndex() throws ParseException {
        if (cancelled) throw new CancellationException();
        String prevProduction= currentlyParsedProduction;
        this.currentlyParsedProduction= "P_ArrayIndex";
        // Code for RegexpRef specified at:
        // src/main/congocc/pathParser.ccc:56:5
        consumeToken(T_ARRAYINDEX);
        // Code for ZeroOrMore specified at:
        // src/main/congocc/pathParser.ccc:56:20
        while (true) {
            if (!(nextTokenType()== T_ARRAYINDEX)) break;
            // Code for RegexpRef specified at:
            // src/main/congocc/pathParser.ccc:56:21
            consumeToken(T_ARRAYINDEX);
        }
    }

    static private final EnumSet<TokenType> first_set$pathParser_ccc$52$14= tokenTypeSet(T_LONG, T_STR_LIT);
    ArrayList<NonTerminalCall> parsingStack= new ArrayList<> ();
    private ArrayList<NonTerminalCall> lookaheadStack= new ArrayList<> ();
    /**
 * Inner class that represents entering a grammar production
 */
    class NonTerminalCall {
        final String sourceFile;
        final String productionName;
        final int line, column;
        // We actually only use this when we're working with the LookaheadStack
        final boolean scanToEnd;
        NonTerminalCall(String sourceFile, String productionName, int line, int column) {
            this.sourceFile= sourceFile;
            this.productionName= productionName;
            this.line= line;
            this.column= column;
            this.scanToEnd= PParser.this.scanToEnd;
        }

        final PLexer getTokenSource() {
            return PParser.this.token_source;
        }

        StackTraceElement createStackTraceElement() {
            return new StackTraceElement("PParser", productionName, sourceFile, line);
        }

        void dump(PrintStream ps) {
            ps.println(productionName+":"+line+":"+column);
        }

    }
    private final void pushOntoCallStack(String methodName, String fileName, int line, int column) {
        parsingStack.add(new NonTerminalCall(fileName, methodName, line, column));
    }

    private final void popCallStack() {
        NonTerminalCall ntc= parsingStack.remove(parsingStack.size()-1);
        this.currentlyParsedProduction= ntc.productionName;
    }

    private final void restoreCallStack(int prevSize) {
        while (parsingStack.size()> prevSize) {
            popCallStack();
        }
    }

    void dumpLookaheadStack(PrintStream ps) {
        ListIterator<NonTerminalCall> it= lookaheadStack.listIterator(lookaheadStack.size());
        while (it.hasPrevious()) {
            it.previous().dump(ps);
        }
    }

    void dumpCallStack(PrintStream ps) {
        ListIterator<NonTerminalCall> it= parsingStack.listIterator(parsingStack.size());
        while (it.hasPrevious()) {
            it.previous().dump(ps);
        }
    }

    void dumpLookaheadCallStack(PrintStream ps) {
        ps.println("Current Parser Production is: "+currentlyParsedProduction);
        ps.println("Current Lookahead Production is: "+currentLookaheadProduction);
        ps.println("---Lookahead Stack---");
        dumpLookaheadStack(ps);
        ps.println("---Call Stack---");
        dumpCallStack(ps);
    }

    public boolean isParserTolerant() {
        return false;
    }

    public void setParserTolerant(boolean tolerantParsing) {
        if (tolerantParsing) {
            throw new UnsupportedOperationException("This parser was not built with that feature!");
        }
    }

    private Token consumeToken(TokenType expectedType) throws ParseException {
        Token oldToken= lastConsumedToken;
        Token nextToken= nextToken(lastConsumedToken);
        if (nextToken.getType()!=expectedType) {
            nextToken= handleUnexpectedTokenType(expectedType, nextToken);
        }
        this.lastConsumedToken= nextToken;
        this.nextTokenType= null;
        if (buildTree&&tokensAreNodes) {
            pushNode(lastConsumedToken);
        }
        return lastConsumedToken;
    }

    private Token handleUnexpectedTokenType(TokenType expectedType, Token nextToken) throws ParseException {
        throw new ParseException(nextToken, EnumSet.of(expectedType), parsingStack);
    }

    private class ParseState {
        Token lastConsumed;
        ArrayList<NonTerminalCall> parsingStack;
        NodeScope nodeScope;
        ParseState() {
            this.lastConsumed= PParser.this.lastConsumedToken;
            @SuppressWarnings("unchecked")
            ArrayList<NonTerminalCall> parsingStack= (ArrayList<NonTerminalCall> ) PParser.this.parsingStack.clone();
            this.parsingStack= parsingStack;
            this.nodeScope= (NodeScope) currentNodeScope.clone();
        }

    }
    private boolean buildTree= true;
    private boolean tokensAreNodes= true;
    private boolean unparsedTokensAreNodes= false;
    public boolean isTreeBuildingEnabled() {
        return buildTree;
    }

    public void setUnparsedTokensAreNodes(boolean unparsedTokensAreNodes) {
        this.unparsedTokensAreNodes= unparsedTokensAreNodes;
    }

    public void setTokensAreNodes(boolean tokensAreNodes) {
        this.tokensAreNodes= tokensAreNodes;
    }

    NodeScope currentNodeScope= new NodeScope();
    /** 
         * @return the root node of the AST. It only makes sense to call
         * this after a successful parse. 
         */
    public Node rootNode() {
        return currentNodeScope.rootNode();
    }

    /**
     * push a node onto the top of the node stack
     * @param n the node to push
     */
    public void pushNode(Node n) {
        currentNodeScope.add(n);
    }

    /** 
     * @return the node on the top of the stack, and remove it from the
     * stack.  
     */
    public Node popNode() {
        return currentNodeScope.pop();
    }

    /** 
     * @return the node currently on the top of the tree-building stack. 
     */
    public Node peekNode() {
        return currentNodeScope.peek();
    }

    /**
     * Puts the node on the top of the stack. However, unlike pushNode()
     * it replaces the node that is currently on the top of the stack.
     * This is effectively equivalent to popNode() followed by pushNode(n)
     * @param n the node to poke
     */
    public void pokeNode(Node n) {
        currentNodeScope.poke(n);
    }

    /** 
     * @return the number of Nodes on the tree-building stack in the current node
         * scope. 
         */
    public int nodeArity() {
        return currentNodeScope.size();
    }

    private void clearNodeScope() {
        currentNodeScope.clear();
    }

    private void openNodeScope(Node n) {
        new NodeScope();
        if (n!=null) {
            Token next= nextToken(lastConsumedToken);
            n.setTokenSource(lastConsumedToken.getTokenSource());
            n.setBeginOffset(next.getBeginOffset());
            n.open();
        }
    }

    /* A definite node is constructed from a specified number of
         * children.  That number of nodes are popped from the stack and
         * made the children of the definite node.  Then the definite node
         * is pushed on to the stack.
         */
    private void closeNodeScope(Node n, int num) {
        n.setEndOffset(lastConsumedToken.getEndOffset());
        currentNodeScope.close();
        ArrayList<Node> nodes= new ArrayList<Node> ();
        for (int i= 0; i<num; i++) {
            nodes.add(popNode());
        }
        Collections.reverse(nodes);
        for (Node child : nodes) {
            // FIXME deal with the UNPARSED_TOKENS_ARE_NODES case
            n.addChild(child);
        }
        n.close();
        pushNode(n);
    }

    /**
         * A conditional node is constructed if the condition is true.  All
         * the nodes that have been pushed since the node was opened are
         * made children of the conditional node, which is then pushed
         * on to the stack.  If the condition is false the node is not
         * constructed and they are left on the stack. 
         */
    private void closeNodeScope(Node n, boolean condition) {
        if (n!=null&&condition) {
            n.setEndOffset(lastConsumedToken.getEndOffset());
            int a= nodeArity();
            currentNodeScope.close();
            ArrayList<Node> nodes= new ArrayList<Node> ();
            while (a--> 0) {
                nodes.add(popNode());
            }
            Collections.reverse(nodes);
            for (Node child : nodes) {
                if (unparsedTokensAreNodes&&child instanceof Token) {
                    Token tok= (Token) child;
                    while (tok.previousCachedToken()!=null&&tok.previousCachedToken().isUnparsed()) {
                        tok= tok.previousCachedToken();
                    }
                    while (tok.isUnparsed()) {
                        n.addChild(tok);
                        tok= tok.nextCachedToken();
                    }
                }
                n.addChild(child);
            }
            n.close();
            pushNode(n);
        }
        else  {
            currentNodeScope.close();
        }
    }

    public boolean getBuildTree() {
        return buildTree;
    }

    public void setBuildTree(boolean buildTree) {
        this.buildTree= buildTree;
    }

    /**
     * Just a kludge so that existing jjtree-based code that uses
     * parser.jjtree.foo can work without change.
     */
    PParser jjtree= this;
    @SuppressWarnings("serial")
    class NodeScope extends ArrayList<Node>  {
        NodeScope parentScope;
        NodeScope() {
            this.parentScope= PParser.this.currentNodeScope;
            PParser.this.currentNodeScope= this;
        }

        boolean isRootScope() {
            return parentScope== null;
        }

        Node rootNode() {
            NodeScope ns= this;
            while (ns.parentScope!=null) {
                ns= ns.parentScope;
            }
            return ns.isEmpty()?null:
            ns.get(0);
        }

        Node peek() {
            return isEmpty()?parentScope.peek():
            get(size()-1);
        }

        Node pop() {
            return isEmpty()?parentScope.pop():
            remove(size()-1);
        }

        void poke(Node n) {
            if (isEmpty()) {
                parentScope.poke(n);
            }
            else  {
                set(size()-1, n);
            }
        }

        void close() {
            parentScope.addAll(this);
            PParser.this.currentNodeScope= parentScope;
        }

        int nestingLevel() {
            int result= 0;
            NodeScope parent= this;
            while (parent.parentScope!=null) {
                result++;
                parent= parent.parentScope;
            }
            return result;
        }

        public NodeScope clone() {
            NodeScope clone= (NodeScope) super.clone();
            if (parentScope!=null) {
                clone.parentScope= (NodeScope) parentScope.clone();
            }
            return clone;
        }

    }
}
