/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.frostserver.util.user;

import java.security.Principal;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class PrincipalExtended
implements Principal {
    public static final String USER_NAME_ANONYMOUS = "anonymous";
    public static final String ROLE_ADMIN = "admin";
    public static final String ROLE_DELETE = "delete";
    public static final String ROLE_UPDATE = "update";
    public static final String ROLE_CREATE = "create";
    public static final String ROLE_READ = "read";
    public static final PrincipalExtended ANONYMOUS_PRINCIPAL = new PrincipalExtended("anonymous", false, Collections.emptySet());
    public static final PrincipalExtended INTERNAL_ADMIN_PRINCIPAL = new PrincipalExtended("admin", true, Collections.emptySet());
    private static final ThreadLocal<PrincipalExtended> LOCAL_PRINCIPAL = ThreadLocal.withInitial(() -> ANONYMOUS_PRINCIPAL);
    private final String name;
    private final boolean admin;
    private final Set<String> roles;
    private Map<String, Object> context;

    public PrincipalExtended(String name, boolean admin, Set<String> roles) {
        this.name = name;
        this.admin = admin;
        this.roles = roles;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public boolean isAdmin() {
        return this.admin;
    }

    public Set<String> getRoles() {
        return this.roles;
    }

    @Override
    public String toString() {
        return this.name + " (" + this.admin + ")";
    }

    public Map<String, Object> getContext() {
        return this.context;
    }

    public PrincipalExtended addContextItem(String key, Object value) {
        if (this.context == null) {
            this.context = new HashMap<String, Object>();
        }
        this.context.put(key, value);
        return this;
    }

    public boolean hasContextItem(String key) {
        if (this.context == null) {
            return false;
        }
        return this.context.containsKey(key);
    }

    public Object getContextItem(String key, Object dflt) {
        if (this.context == null) {
            return dflt;
        }
        Object value = this.context.get(key);
        if (value == null) {
            return dflt;
        }
        return value;
    }

    public Object getContextItem(String key) {
        return this.getContextItem(key, null);
    }

    public PrincipalExtended setContext(Map<String, Object> context) {
        this.context = context;
        return this;
    }

    public static final PrincipalExtended fromPrincipal(Principal principal) {
        if (principal == null) {
            return ANONYMOUS_PRINCIPAL;
        }
        if (principal instanceof PrincipalExtended) {
            PrincipalExtended principalExtended = (PrincipalExtended)principal;
            return principalExtended;
        }
        return new PrincipalExtended(principal.getName(), false, Collections.emptySet());
    }

    public static PrincipalExtended getLocalPrincipal() {
        return LOCAL_PRINCIPAL.get();
    }

    public static void setLocalPrincipal(PrincipalExtended localPrincipal) {
        LOCAL_PRINCIPAL.set(localPrincipal);
    }

    public static void removeLocalPrincipal() {
        LOCAL_PRINCIPAL.remove();
    }
}

