/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.frostserver.util.queryparser;

import de.fraunhofer.iosb.ilt.frostserver.util.queryparser.QConstants;
import java.util.BitSet;
import java.util.EnumMap;
import java.util.EnumSet;

class QNfaData
implements QConstants {
    private static final EnumMap<QConstants.LexicalState, NfaFunction[]> functionTableMap = new EnumMap(QConstants.LexicalState.class);

    private QNfaData() {
    }

    static final NfaFunction[] getFunctionTableMap(QConstants.LexicalState lexicalState) {
        return functionTableMap.get((Object)lexicalState);
    }

    static {
        DEFAULT.NFA_FUNCTIONS_init();
        LS_REF.NFA_FUNCTIONS_init();
        LS_QUERY.NFA_FUNCTIONS_init();
        LS_SUBQUERY.NFA_FUNCTIONS_init();
        LS_FILTER.NFA_FUNCTIONS_init();
        LS_CONSTANTS.NFA_FUNCTIONS_init();
        LS_PLAIN_PATH.NFA_FUNCTIONS_init();
        LS_ORDERBYS.NFA_FUNCTIONS_init();
        LS_ORDERBY.NFA_FUNCTIONS_init();
        LS_ANYSTRING.NFA_FUNCTIONS_init();
        LS_FORMAT.NFA_FUNCTIONS_init();
        LS_METADATA.NFA_FUNCTIONS_init();
        LS_COUNT.NFA_FUNCTIONS_init();
        LS_TOP.NFA_FUNCTIONS_init();
        LS_SKIP.NFA_FUNCTIONS_init();
        LS_EXPAND.NFA_FUNCTIONS_init();
        LS_SELECT.NFA_FUNCTIONS_init();
    }

    static interface NfaFunction {
        public QConstants.TokenType apply(int var1, BitSet var2, EnumSet<QConstants.TokenType> var3);
    }

    private static class DEFAULT {
        private DEFAULT() {
        }

        static QConstants.TokenType NFA_COMPOSITE_0(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            QConstants.TokenType type = null;
            if (ch == 9) {
                if (validTypes.contains((Object)QConstants.TokenType._TOKEN_4)) {
                    type = QConstants.TokenType._TOKEN_4;
                }
            } else if (ch == 13) {
                if (validTypes.contains((Object)QConstants.TokenType._TOKEN_3)) {
                    type = QConstants.TokenType._TOKEN_3;
                }
            } else if (ch == 10) {
                if (validTypes.contains((Object)QConstants.TokenType._TOKEN_2)) {
                    type = QConstants.TokenType._TOKEN_2;
                }
            } else if (ch == 32 && validTypes.contains((Object)QConstants.TokenType._TOKEN_1)) {
                type = QConstants.TokenType._TOKEN_1;
            }
            return type;
        }

        static QConstants.TokenType NFA_1(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 9 && validTypes.contains((Object)QConstants.TokenType._TOKEN_4)) {
                return QConstants.TokenType._TOKEN_4;
            }
            return null;
        }

        static QConstants.TokenType NFA_2(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 10 && validTypes.contains((Object)QConstants.TokenType._TOKEN_2)) {
                return QConstants.TokenType._TOKEN_2;
            }
            return null;
        }

        static QConstants.TokenType NFA_3(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 13 && validTypes.contains((Object)QConstants.TokenType._TOKEN_3)) {
                return QConstants.TokenType._TOKEN_3;
            }
            return null;
        }

        static QConstants.TokenType NFA_4(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 32 && validTypes.contains((Object)QConstants.TokenType._TOKEN_1)) {
                return QConstants.TokenType._TOKEN_1;
            }
            return null;
        }

        private static void NFA_FUNCTIONS_init() {
            NfaFunction[] functions = new NfaFunction[]{DEFAULT::NFA_COMPOSITE_0, DEFAULT::NFA_1, DEFAULT::NFA_2, DEFAULT::NFA_3, DEFAULT::NFA_4};
            functionTableMap.put(QConstants.LexicalState.DEFAULT, functions);
        }
    }

    private static class LS_REF {
        private LS_REF() {
        }

        static QConstants.TokenType NFA_COMPOSITE_LS_REF_0(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            QConstants.TokenType type = null;
            if (ch == 36) {
                nextStates.set(7);
            } else if (ch == 9) {
                if (validTypes.contains((Object)QConstants.TokenType._TOKEN_4)) {
                    type = QConstants.TokenType._TOKEN_4;
                }
            } else if (ch == 13) {
                if (validTypes.contains((Object)QConstants.TokenType._TOKEN_3)) {
                    type = QConstants.TokenType._TOKEN_3;
                }
            } else if (ch == 10) {
                if (validTypes.contains((Object)QConstants.TokenType._TOKEN_2)) {
                    type = QConstants.TokenType._TOKEN_2;
                }
            } else if (ch == 32 && validTypes.contains((Object)QConstants.TokenType._TOKEN_1)) {
                type = QConstants.TokenType._TOKEN_1;
            }
            return type;
        }

        static QConstants.TokenType NFA_LS_REF_1(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 9 && validTypes.contains((Object)QConstants.TokenType._TOKEN_4)) {
                return QConstants.TokenType._TOKEN_4;
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_REF_2(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 10 && validTypes.contains((Object)QConstants.TokenType._TOKEN_2)) {
                return QConstants.TokenType._TOKEN_2;
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_REF_3(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 13 && validTypes.contains((Object)QConstants.TokenType._TOKEN_3)) {
                return QConstants.TokenType._TOKEN_3;
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_REF_4(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 68 || ch == 100) {
                nextStates.set(8);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_REF_5(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 32 && validTypes.contains((Object)QConstants.TokenType._TOKEN_1)) {
                return QConstants.TokenType._TOKEN_1;
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_REF_6(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 36) {
                nextStates.set(7);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_REF_7(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 73 || ch == 105) {
                nextStates.set(4);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_REF_8(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 61 && validTypes.contains((Object)QConstants.TokenType.T_O_ID)) {
                return QConstants.TokenType.T_O_ID;
            }
            return null;
        }

        private static void NFA_FUNCTIONS_init() {
            NfaFunction[] functions = new NfaFunction[]{LS_REF::NFA_COMPOSITE_LS_REF_0, LS_REF::NFA_LS_REF_1, LS_REF::NFA_LS_REF_2, LS_REF::NFA_LS_REF_3, LS_REF::NFA_LS_REF_4, LS_REF::NFA_LS_REF_5, LS_REF::NFA_LS_REF_6, LS_REF::NFA_LS_REF_7, LS_REF::NFA_LS_REF_8};
            functionTableMap.put(QConstants.LexicalState.LS_REF, functions);
        }
    }

    private static class LS_QUERY {
        private LS_QUERY() {
        }

        static QConstants.TokenType NFA_COMPOSITE_LS_QUERY_0(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            QConstants.TokenType type = null;
            if (ch == 36) {
                nextStates.set(79);
                nextStates.set(58);
                nextStates.set(33);
                nextStates.set(92);
                nextStates.set(84);
                nextStates.set(69);
                nextStates.set(41);
                nextStates.set(1);
                nextStates.set(62);
                nextStates.set(77);
            } else if (ch == 38) {
                if (validTypes.contains((Object)QConstants.TokenType.T_OPTIONS_SEPARATOR)) {
                    type = QConstants.TokenType.T_OPTIONS_SEPARATOR;
                }
            } else if (ch == 9) {
                if (validTypes.contains((Object)QConstants.TokenType._TOKEN_4)) {
                    type = QConstants.TokenType._TOKEN_4;
                }
            } else if (ch == 13) {
                if (validTypes.contains((Object)QConstants.TokenType._TOKEN_3)) {
                    type = QConstants.TokenType._TOKEN_3;
                }
            } else if (ch == 10) {
                if (validTypes.contains((Object)QConstants.TokenType._TOKEN_2)) {
                    type = QConstants.TokenType._TOKEN_2;
                }
            } else if (ch == 32 && validTypes.contains((Object)QConstants.TokenType._TOKEN_1)) {
                type = QConstants.TokenType._TOKEN_1;
            }
            return type;
        }

        static QConstants.TokenType NFA_COMPOSITE_LS_QUERY_1(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            QConstants.TokenType type = null;
            if (ch == 70 || ch == 102) {
                nextStates.set(25);
            } else if (ch == 82 || ch == 114) {
                nextStates.set(10);
            }
            return type;
        }

        static QConstants.TokenType NFA_LS_QUERY_2(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 84 || ch == 116) {
                nextStates.set(36);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_QUERY_3(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 36) {
                nextStates.set(79);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_QUERY_4(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 76 || ch == 108) {
                nextStates.set(30);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_QUERY_5(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 68 || ch == 100) {
                nextStates.set(39);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_QUERY_6(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 82 || ch == 114) {
                nextStates.set(59);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_QUERY_7(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 84 || ch == 116) {
                nextStates.set(23);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_QUERY_8(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 36) {
                nextStates.set(92);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_QUERY_9(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 75 || ch == 107) {
                nextStates.set(18);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_QUERY_10(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 69 || ch == 101) {
                nextStates.set(52);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_QUERY_11(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 79 || ch == 111) {
                nextStates.set(76);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_QUERY_12(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 82 || ch == 114) {
                nextStates.set(5);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_QUERY_13(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 69 || ch == 101) {
                nextStates.set(85);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_QUERY_14(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 82 || ch == 114) {
                nextStates.set(53);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_QUERY_15(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 76 || ch == 108) {
                nextStates.set(57);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_QUERY_16(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 77 || ch == 109) {
                nextStates.set(21);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_QUERY_17(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 61 && validTypes.contains((Object)QConstants.TokenType.T_O_EXPAND)) {
                return QConstants.TokenType.T_O_EXPAND;
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_QUERY_18(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 73 || ch == 105) {
                nextStates.set(73);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_QUERY_19(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 84 || ch == 116) {
                nextStates.set(94);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_QUERY_20(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 68 || ch == 100) {
                nextStates.set(17);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_QUERY_21(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 69 || ch == 101) {
                nextStates.set(2);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_QUERY_22(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 36) {
                nextStates.set(58);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_QUERY_23(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 61 && validTypes.contains((Object)QConstants.TokenType.T_O_FORMAT)) {
                return QConstants.TokenType.T_O_FORMAT;
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_QUERY_24(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 61 && validTypes.contains((Object)QConstants.TokenType.T_O_SKIP)) {
                return QConstants.TokenType.T_O_SKIP;
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_QUERY_25(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 79 || ch == 111) {
                nextStates.set(78);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_QUERY_26(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 76 || ch == 108) {
                nextStates.set(54);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_QUERY_27(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 61 && validTypes.contains((Object)QConstants.TokenType.T_O_SKIPFILTER)) {
                return QConstants.TokenType.T_O_SKIPFILTER;
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_QUERY_28(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 75 || ch == 107) {
                nextStates.set(46);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_QUERY_29(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 77 || ch == 109) {
                nextStates.set(31);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_QUERY_30(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 69 || ch == 101) {
                nextStates.set(70);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_QUERY_31(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 65 || ch == 97) {
                nextStates.set(7);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_QUERY_32(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 13 && validTypes.contains((Object)QConstants.TokenType._TOKEN_3)) {
                return QConstants.TokenType._TOKEN_3;
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_QUERY_33(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 70 || ch == 102) {
                nextStates.set(35);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_QUERY_34(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 36) {
                nextStates.set(41);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_QUERY_35(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 73 || ch == 105) {
                nextStates.set(15);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_QUERY_36(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 65 || ch == 97) {
                nextStates.set(86);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_QUERY_37(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 36) {
                nextStates.set(77);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_QUERY_38(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 61 && validTypes.contains((Object)QConstants.TokenType.T_O_COUNT)) {
                return QConstants.TokenType.T_O_COUNT;
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_QUERY_39(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 69 || ch == 101) {
                nextStates.set(6);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_QUERY_40(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 65 || ch == 97) {
                nextStates.set(63);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_QUERY_41(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 83 || ch == 115) {
                nextStates.set(90);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_QUERY_42(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 65 || ch == 97) {
                nextStates.set(56);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_QUERY_43(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 73 || ch == 105) {
                nextStates.set(68);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_QUERY_44(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 69 || ch == 101) {
                nextStates.set(14);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_QUERY_45(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 78 || ch == 110) {
                nextStates.set(49);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_QUERY_46(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 73 || ch == 105) {
                nextStates.set(64);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_QUERY_47(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 61 && validTypes.contains((Object)QConstants.TokenType.T_O_TOP)) {
                return QConstants.TokenType.T_O_TOP;
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_QUERY_48(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 38 && validTypes.contains((Object)QConstants.TokenType.T_OPTIONS_SEPARATOR)) {
                return QConstants.TokenType.T_OPTIONS_SEPARATOR;
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_QUERY_49(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 84 || ch == 116) {
                nextStates.set(38);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_QUERY_50(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 80 || ch == 112) {
                nextStates.set(40);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_QUERY_51(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 85 || ch == 117) {
                nextStates.set(88);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_QUERY_52(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 83 || ch == 115) {
                nextStates.set(72);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_QUERY_53(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 61 && validTypes.contains((Object)QConstants.TokenType.T_O_FILTER)) {
                return QConstants.TokenType.T_O_FILTER;
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_QUERY_54(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 84 || ch == 116) {
                nextStates.set(98);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_QUERY_55(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 84 || ch == 116) {
                nextStates.set(42);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_QUERY_56(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 61 && validTypes.contains((Object)QConstants.TokenType.T_O_METADATA)) {
                return QConstants.TokenType.T_O_METADATA;
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_QUERY_57(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 84 || ch == 116) {
                nextStates.set(44);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_QUERY_58(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 79 || ch == 111) {
                nextStates.set(12);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_QUERY_59(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 66 || ch == 98) {
                nextStates.set(89);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_QUERY_60(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 36) {
                nextStates.set(33);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_QUERY_61(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 84 || ch == 116) {
                nextStates.set(16);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_QUERY_62(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 84 || ch == 116) {
                nextStates.set(11);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_QUERY_63(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 78 || ch == 110) {
                nextStates.set(20);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_QUERY_64(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 80 || ch == 112) {
                nextStates.set(24);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_QUERY_65(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 36) {
                nextStates.set(69);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_QUERY_66(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 69 || ch == 101) {
                nextStates.set(82);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_QUERY_67(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 36) {
                nextStates.set(1);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_QUERY_68(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 76 || ch == 108) {
                nextStates.set(95);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_QUERY_69(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 83 || ch == 115) {
                nextStates.set(9);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_QUERY_70(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 67 || ch == 99) {
                nextStates.set(19);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_QUERY_71(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 79 || ch == 111) {
                nextStates.set(91);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_QUERY_72(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 85 || ch == 117) {
                nextStates.set(26);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_QUERY_73(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 80 || ch == 112) {
                nextStates.set(80);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_QUERY_74(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 10 && validTypes.contains((Object)QConstants.TokenType._TOKEN_2)) {
                return QConstants.TokenType._TOKEN_2;
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_QUERY_75(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 61 && validTypes.contains((Object)QConstants.TokenType.T_O_ORDERBY)) {
                return QConstants.TokenType.T_O_ORDERBY;
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_QUERY_76(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 80 || ch == 112) {
                nextStates.set(47);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_QUERY_77(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 69 || ch == 101) {
                nextStates.set(93);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_QUERY_78(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 82 || ch == 114) {
                nextStates.set(29);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_QUERY_79(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 67 || ch == 99) {
                nextStates.set(71);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_QUERY_80(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 70 || ch == 102) {
                nextStates.set(43);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_QUERY_81(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 36) {
                nextStates.set(62);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_QUERY_82(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 82 || ch == 114) {
                nextStates.set(27);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_QUERY_83(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 36) {
                nextStates.set(84);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_QUERY_84(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 83 || ch == 115) {
                nextStates.set(28);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_QUERY_85(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 83 || ch == 115) {
                nextStates.set(51);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_QUERY_86(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 68 || ch == 100) {
                nextStates.set(87);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_QUERY_87(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 65 || ch == 97) {
                nextStates.set(55);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_QUERY_88(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 76 || ch == 108) {
                nextStates.set(61);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_QUERY_89(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 89 || ch == 121) {
                nextStates.set(75);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_QUERY_90(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 69 || ch == 101) {
                nextStates.set(4);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_QUERY_91(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 85 || ch == 117) {
                nextStates.set(45);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_QUERY_92(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 82 || ch == 114) {
                nextStates.set(13);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_QUERY_93(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 88 || ch == 120) {
                nextStates.set(50);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_QUERY_94(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 61 && validTypes.contains((Object)QConstants.TokenType.T_O_SELECT)) {
                return QConstants.TokenType.T_O_SELECT;
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_QUERY_95(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 84 || ch == 116) {
                nextStates.set(66);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_QUERY_96(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 32 && validTypes.contains((Object)QConstants.TokenType._TOKEN_1)) {
                return QConstants.TokenType._TOKEN_1;
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_QUERY_97(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 9 && validTypes.contains((Object)QConstants.TokenType._TOKEN_4)) {
                return QConstants.TokenType._TOKEN_4;
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_QUERY_98(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 70 || ch == 102) {
                nextStates.set(25);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_QUERY_99(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 82 || ch == 114) {
                nextStates.set(10);
            }
            return null;
        }

        private static void NFA_FUNCTIONS_init() {
            NfaFunction[] functions = new NfaFunction[]{LS_QUERY::NFA_COMPOSITE_LS_QUERY_0, LS_QUERY::NFA_COMPOSITE_LS_QUERY_1, LS_QUERY::NFA_LS_QUERY_2, LS_QUERY::NFA_LS_QUERY_3, LS_QUERY::NFA_LS_QUERY_4, LS_QUERY::NFA_LS_QUERY_5, LS_QUERY::NFA_LS_QUERY_6, LS_QUERY::NFA_LS_QUERY_7, LS_QUERY::NFA_LS_QUERY_8, LS_QUERY::NFA_LS_QUERY_9, LS_QUERY::NFA_LS_QUERY_10, LS_QUERY::NFA_LS_QUERY_11, LS_QUERY::NFA_LS_QUERY_12, LS_QUERY::NFA_LS_QUERY_13, LS_QUERY::NFA_LS_QUERY_14, LS_QUERY::NFA_LS_QUERY_15, LS_QUERY::NFA_LS_QUERY_16, LS_QUERY::NFA_LS_QUERY_17, LS_QUERY::NFA_LS_QUERY_18, LS_QUERY::NFA_LS_QUERY_19, LS_QUERY::NFA_LS_QUERY_20, LS_QUERY::NFA_LS_QUERY_21, LS_QUERY::NFA_LS_QUERY_22, LS_QUERY::NFA_LS_QUERY_23, LS_QUERY::NFA_LS_QUERY_24, LS_QUERY::NFA_LS_QUERY_25, LS_QUERY::NFA_LS_QUERY_26, LS_QUERY::NFA_LS_QUERY_27, LS_QUERY::NFA_LS_QUERY_28, LS_QUERY::NFA_LS_QUERY_29, LS_QUERY::NFA_LS_QUERY_30, LS_QUERY::NFA_LS_QUERY_31, LS_QUERY::NFA_LS_QUERY_32, LS_QUERY::NFA_LS_QUERY_33, LS_QUERY::NFA_LS_QUERY_34, LS_QUERY::NFA_LS_QUERY_35, LS_QUERY::NFA_LS_QUERY_36, LS_QUERY::NFA_LS_QUERY_37, LS_QUERY::NFA_LS_QUERY_38, LS_QUERY::NFA_LS_QUERY_39, LS_QUERY::NFA_LS_QUERY_40, LS_QUERY::NFA_LS_QUERY_41, LS_QUERY::NFA_LS_QUERY_42, LS_QUERY::NFA_LS_QUERY_43, LS_QUERY::NFA_LS_QUERY_44, LS_QUERY::NFA_LS_QUERY_45, LS_QUERY::NFA_LS_QUERY_46, LS_QUERY::NFA_LS_QUERY_47, LS_QUERY::NFA_LS_QUERY_48, LS_QUERY::NFA_LS_QUERY_49, LS_QUERY::NFA_LS_QUERY_50, LS_QUERY::NFA_LS_QUERY_51, LS_QUERY::NFA_LS_QUERY_52, LS_QUERY::NFA_LS_QUERY_53, LS_QUERY::NFA_LS_QUERY_54, LS_QUERY::NFA_LS_QUERY_55, LS_QUERY::NFA_LS_QUERY_56, LS_QUERY::NFA_LS_QUERY_57, LS_QUERY::NFA_LS_QUERY_58, LS_QUERY::NFA_LS_QUERY_59, LS_QUERY::NFA_LS_QUERY_60, LS_QUERY::NFA_LS_QUERY_61, LS_QUERY::NFA_LS_QUERY_62, LS_QUERY::NFA_LS_QUERY_63, LS_QUERY::NFA_LS_QUERY_64, LS_QUERY::NFA_LS_QUERY_65, LS_QUERY::NFA_LS_QUERY_66, LS_QUERY::NFA_LS_QUERY_67, LS_QUERY::NFA_LS_QUERY_68, LS_QUERY::NFA_LS_QUERY_69, LS_QUERY::NFA_LS_QUERY_70, LS_QUERY::NFA_LS_QUERY_71, LS_QUERY::NFA_LS_QUERY_72, LS_QUERY::NFA_LS_QUERY_73, LS_QUERY::NFA_LS_QUERY_74, LS_QUERY::NFA_LS_QUERY_75, LS_QUERY::NFA_LS_QUERY_76, LS_QUERY::NFA_LS_QUERY_77, LS_QUERY::NFA_LS_QUERY_78, LS_QUERY::NFA_LS_QUERY_79, LS_QUERY::NFA_LS_QUERY_80, LS_QUERY::NFA_LS_QUERY_81, LS_QUERY::NFA_LS_QUERY_82, LS_QUERY::NFA_LS_QUERY_83, LS_QUERY::NFA_LS_QUERY_84, LS_QUERY::NFA_LS_QUERY_85, LS_QUERY::NFA_LS_QUERY_86, LS_QUERY::NFA_LS_QUERY_87, LS_QUERY::NFA_LS_QUERY_88, LS_QUERY::NFA_LS_QUERY_89, LS_QUERY::NFA_LS_QUERY_90, LS_QUERY::NFA_LS_QUERY_91, LS_QUERY::NFA_LS_QUERY_92, LS_QUERY::NFA_LS_QUERY_93, LS_QUERY::NFA_LS_QUERY_94, LS_QUERY::NFA_LS_QUERY_95, LS_QUERY::NFA_LS_QUERY_96, LS_QUERY::NFA_LS_QUERY_97, LS_QUERY::NFA_LS_QUERY_98, LS_QUERY::NFA_LS_QUERY_99};
            functionTableMap.put(QConstants.LexicalState.LS_QUERY, functions);
        }
    }

    private static class LS_SUBQUERY {
        private LS_SUBQUERY() {
        }

        static QConstants.TokenType NFA_COMPOSITE_LS_SUBQUERY_0(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            QConstants.TokenType type = null;
            if (ch == 36) {
                nextStates.set(32);
                nextStates.set(53);
                nextStates.set(37);
                nextStates.set(33);
                nextStates.set(2);
                nextStates.set(44);
                nextStates.set(39);
            } else if (ch == 59) {
                if (validTypes.contains((Object)QConstants.TokenType.T_SUBQUERY_OPTIONS_SEPARATOR)) {
                    type = QConstants.TokenType.T_SUBQUERY_OPTIONS_SEPARATOR;
                }
            } else if (ch == 9) {
                if (validTypes.contains((Object)QConstants.TokenType._TOKEN_4)) {
                    type = QConstants.TokenType._TOKEN_4;
                }
            } else if (ch == 13) {
                if (validTypes.contains((Object)QConstants.TokenType._TOKEN_3)) {
                    type = QConstants.TokenType._TOKEN_3;
                }
            } else if (ch == 10) {
                if (validTypes.contains((Object)QConstants.TokenType._TOKEN_2)) {
                    type = QConstants.TokenType._TOKEN_2;
                }
            } else if (ch == 32 && validTypes.contains((Object)QConstants.TokenType._TOKEN_1)) {
                type = QConstants.TokenType._TOKEN_1;
            }
            return type;
        }

        static QConstants.TokenType NFA_LS_SUBQUERY_1(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 84 || ch == 116) {
                nextStates.set(25);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_SUBQUERY_2(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 84 || ch == 116) {
                nextStates.set(19);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_SUBQUERY_3(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 82 || ch == 114) {
                nextStates.set(24);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_SUBQUERY_4(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 61 && validTypes.contains((Object)QConstants.TokenType.T_O_SKIP)) {
                return QConstants.TokenType.T_O_SKIP;
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_SUBQUERY_5(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 69 || ch == 101) {
                nextStates.set(50);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_SUBQUERY_6(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 82 || ch == 114) {
                nextStates.set(55);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_SUBQUERY_7(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 10 && validTypes.contains((Object)QConstants.TokenType._TOKEN_2)) {
                return QConstants.TokenType._TOKEN_2;
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_SUBQUERY_8(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 65 || ch == 97) {
                nextStates.set(27);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_SUBQUERY_9(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 69 || ch == 101) {
                nextStates.set(45);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_SUBQUERY_10(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 89 || ch == 121) {
                nextStates.set(29);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_SUBQUERY_11(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 85 || ch == 117) {
                nextStates.set(17);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_SUBQUERY_12(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 36) {
                nextStates.set(33);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_SUBQUERY_13(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 80 || ch == 112) {
                nextStates.set(4);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_SUBQUERY_14(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 69 || ch == 101) {
                nextStates.set(3);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_SUBQUERY_15(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 68 || ch == 100) {
                nextStates.set(48);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_SUBQUERY_16(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 9 && validTypes.contains((Object)QConstants.TokenType._TOKEN_4)) {
                return QConstants.TokenType._TOKEN_4;
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_SUBQUERY_17(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 78 || ch == 110) {
                nextStates.set(1);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_SUBQUERY_18(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 36) {
                nextStates.set(2);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_SUBQUERY_19(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 79 || ch == 111) {
                nextStates.set(21);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_SUBQUERY_20(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 13 && validTypes.contains((Object)QConstants.TokenType._TOKEN_3)) {
                return QConstants.TokenType._TOKEN_3;
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_SUBQUERY_21(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 80 || ch == 112) {
                nextStates.set(51);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_SUBQUERY_22(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 66 || ch == 98) {
                nextStates.set(10);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_SUBQUERY_23(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 76 || ch == 108) {
                nextStates.set(43);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_SUBQUERY_24(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 61 && validTypes.contains((Object)QConstants.TokenType.T_O_FILTER)) {
                return QConstants.TokenType.T_O_FILTER;
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_SUBQUERY_25(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 61 && validTypes.contains((Object)QConstants.TokenType.T_O_COUNT)) {
                return QConstants.TokenType.T_O_COUNT;
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_SUBQUERY_26(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 88 || ch == 120) {
                nextStates.set(31);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_SUBQUERY_27(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 78 || ch == 110) {
                nextStates.set(15);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_SUBQUERY_28(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 67 || ch == 99) {
                nextStates.set(56);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_SUBQUERY_29(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 61 && validTypes.contains((Object)QConstants.TokenType.T_O_ORDERBY)) {
                return QConstants.TokenType.T_O_ORDERBY;
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_SUBQUERY_30(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 36) {
                nextStates.set(32);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_SUBQUERY_31(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 80 || ch == 112) {
                nextStates.set(8);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_SUBQUERY_32(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 83 || ch == 115) {
                nextStates.set(5);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_SUBQUERY_33(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 79 || ch == 111) {
                nextStates.set(6);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_SUBQUERY_34(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 73 || ch == 105) {
                nextStates.set(23);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_SUBQUERY_35(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 36) {
                nextStates.set(37);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_SUBQUERY_36(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 61 && validTypes.contains((Object)QConstants.TokenType.T_O_SELECT)) {
                return QConstants.TokenType.T_O_SELECT;
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_SUBQUERY_37(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 83 || ch == 115) {
                nextStates.set(41);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_SUBQUERY_38(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 36) {
                nextStates.set(39);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_SUBQUERY_39(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 69 || ch == 101) {
                nextStates.set(26);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_SUBQUERY_40(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 69 || ch == 101) {
                nextStates.set(28);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_SUBQUERY_41(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 75 || ch == 107) {
                nextStates.set(42);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_SUBQUERY_42(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 73 || ch == 105) {
                nextStates.set(13);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_SUBQUERY_43(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 84 || ch == 116) {
                nextStates.set(14);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_SUBQUERY_44(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 70 || ch == 102) {
                nextStates.set(34);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_SUBQUERY_45(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 82 || ch == 114) {
                nextStates.set(22);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_SUBQUERY_46(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 36) {
                nextStates.set(53);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_SUBQUERY_47(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 59 && validTypes.contains((Object)QConstants.TokenType.T_SUBQUERY_OPTIONS_SEPARATOR)) {
                return QConstants.TokenType.T_SUBQUERY_OPTIONS_SEPARATOR;
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_SUBQUERY_48(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 61 && validTypes.contains((Object)QConstants.TokenType.T_O_EXPAND)) {
                return QConstants.TokenType.T_O_EXPAND;
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_SUBQUERY_49(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 32 && validTypes.contains((Object)QConstants.TokenType._TOKEN_1)) {
                return QConstants.TokenType._TOKEN_1;
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_SUBQUERY_50(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 76 || ch == 108) {
                nextStates.set(40);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_SUBQUERY_51(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 61 && validTypes.contains((Object)QConstants.TokenType.T_O_TOP)) {
                return QConstants.TokenType.T_O_TOP;
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_SUBQUERY_52(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 79 || ch == 111) {
                nextStates.set(11);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_SUBQUERY_53(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 67 || ch == 99) {
                nextStates.set(52);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_SUBQUERY_54(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 36) {
                nextStates.set(44);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_SUBQUERY_55(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 68 || ch == 100) {
                nextStates.set(9);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_SUBQUERY_56(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 84 || ch == 116) {
                nextStates.set(36);
            }
            return null;
        }

        private static void NFA_FUNCTIONS_init() {
            NfaFunction[] functions = new NfaFunction[]{LS_SUBQUERY::NFA_COMPOSITE_LS_SUBQUERY_0, LS_SUBQUERY::NFA_LS_SUBQUERY_1, LS_SUBQUERY::NFA_LS_SUBQUERY_2, LS_SUBQUERY::NFA_LS_SUBQUERY_3, LS_SUBQUERY::NFA_LS_SUBQUERY_4, LS_SUBQUERY::NFA_LS_SUBQUERY_5, LS_SUBQUERY::NFA_LS_SUBQUERY_6, LS_SUBQUERY::NFA_LS_SUBQUERY_7, LS_SUBQUERY::NFA_LS_SUBQUERY_8, LS_SUBQUERY::NFA_LS_SUBQUERY_9, LS_SUBQUERY::NFA_LS_SUBQUERY_10, LS_SUBQUERY::NFA_LS_SUBQUERY_11, LS_SUBQUERY::NFA_LS_SUBQUERY_12, LS_SUBQUERY::NFA_LS_SUBQUERY_13, LS_SUBQUERY::NFA_LS_SUBQUERY_14, LS_SUBQUERY::NFA_LS_SUBQUERY_15, LS_SUBQUERY::NFA_LS_SUBQUERY_16, LS_SUBQUERY::NFA_LS_SUBQUERY_17, LS_SUBQUERY::NFA_LS_SUBQUERY_18, LS_SUBQUERY::NFA_LS_SUBQUERY_19, LS_SUBQUERY::NFA_LS_SUBQUERY_20, LS_SUBQUERY::NFA_LS_SUBQUERY_21, LS_SUBQUERY::NFA_LS_SUBQUERY_22, LS_SUBQUERY::NFA_LS_SUBQUERY_23, LS_SUBQUERY::NFA_LS_SUBQUERY_24, LS_SUBQUERY::NFA_LS_SUBQUERY_25, LS_SUBQUERY::NFA_LS_SUBQUERY_26, LS_SUBQUERY::NFA_LS_SUBQUERY_27, LS_SUBQUERY::NFA_LS_SUBQUERY_28, LS_SUBQUERY::NFA_LS_SUBQUERY_29, LS_SUBQUERY::NFA_LS_SUBQUERY_30, LS_SUBQUERY::NFA_LS_SUBQUERY_31, LS_SUBQUERY::NFA_LS_SUBQUERY_32, LS_SUBQUERY::NFA_LS_SUBQUERY_33, LS_SUBQUERY::NFA_LS_SUBQUERY_34, LS_SUBQUERY::NFA_LS_SUBQUERY_35, LS_SUBQUERY::NFA_LS_SUBQUERY_36, LS_SUBQUERY::NFA_LS_SUBQUERY_37, LS_SUBQUERY::NFA_LS_SUBQUERY_38, LS_SUBQUERY::NFA_LS_SUBQUERY_39, LS_SUBQUERY::NFA_LS_SUBQUERY_40, LS_SUBQUERY::NFA_LS_SUBQUERY_41, LS_SUBQUERY::NFA_LS_SUBQUERY_42, LS_SUBQUERY::NFA_LS_SUBQUERY_43, LS_SUBQUERY::NFA_LS_SUBQUERY_44, LS_SUBQUERY::NFA_LS_SUBQUERY_45, LS_SUBQUERY::NFA_LS_SUBQUERY_46, LS_SUBQUERY::NFA_LS_SUBQUERY_47, LS_SUBQUERY::NFA_LS_SUBQUERY_48, LS_SUBQUERY::NFA_LS_SUBQUERY_49, LS_SUBQUERY::NFA_LS_SUBQUERY_50, LS_SUBQUERY::NFA_LS_SUBQUERY_51, LS_SUBQUERY::NFA_LS_SUBQUERY_52, LS_SUBQUERY::NFA_LS_SUBQUERY_53, LS_SUBQUERY::NFA_LS_SUBQUERY_54, LS_SUBQUERY::NFA_LS_SUBQUERY_55, LS_SUBQUERY::NFA_LS_SUBQUERY_56};
            functionTableMap.put(QConstants.LexicalState.LS_SUBQUERY, functions);
        }
    }

    private static class LS_FILTER {
        private LS_FILTER() {
        }

        static QConstants.TokenType NFA_COMPOSITE_LS_FILTER_0(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            QConstants.TokenType type = null;
            if (ch == 65 || ch == 97) {
                nextStates.set(284);
                nextStates.set(225);
                nextStates.set(279);
            } else if (ch == 66 || ch == 98) {
                nextStates.set(286);
            } else if (ch == 67 || ch == 99) {
                nextStates.set(181);
                nextStates.set(17);
            } else if (ch == 68 || ch == 100) {
                nextStates.set(77);
                nextStates.set(344);
                nextStates.set(404);
                nextStates.set(310);
            } else if (ch == 69 || ch == 101) {
                nextStates.set(38);
                nextStates.set(216);
            } else if (ch == 70 || ch == 102) {
                nextStates.set(297);
                nextStates.set(349);
                nextStates.set(145);
            } else if (ch == 71 || ch == 103) {
                nextStates.set(127);
                nextStates.set(68);
                nextStates.set(346);
                nextStates.set(432);
                nextStates.set(250);
            } else if (ch == 72 || ch == 104) {
                nextStates.set(222);
            } else if (ch == 73 || ch == 105) {
                nextStates.set(87);
                nextStates.set(229);
            } else if (ch == 76 || ch == 108) {
                nextStates.set(224);
                nextStates.set(333);
                nextStates.set(27);
            } else if (ch == 77 || ch == 109) {
                nextStates.set(340);
                nextStates.set(421);
                nextStates.set(36);
                nextStates.set(428);
                nextStates.set(92);
                nextStates.set(51);
                nextStates.set(403);
            } else if (ch == 78 || ch == 110) {
                nextStates.set(274);
                nextStates.set(50);
                nextStates.set(155);
            } else if (ch == 79 || ch == 111) {
                nextStates.set(213);
                nextStates.set(318);
            } else if (ch == 80 || ch == 112) {
                nextStates.set(150);
            } else if (ch == 82 || ch == 114) {
                nextStates.set(267);
            } else if (ch == 83 || ch == 115) {
                nextStates.set(139);
                nextStates.set(423);
                nextStates.set(437);
                nextStates.set(435);
                nextStates.set(24);
                nextStates.set(78);
                nextStates.set(30);
                nextStates.set(319);
                nextStates.set(3);
                nextStates.set(429);
                nextStates.set(277);
                nextStates.set(10);
                nextStates.set(283);
                nextStates.set(238);
                nextStates.set(90);
            } else if (ch == 84 || ch == 116) {
                nextStates.set(448);
                nextStates.set(63);
                nextStates.set(260);
                nextStates.set(215);
                nextStates.set(128);
            } else if (ch == 89 || ch == 121) {
                nextStates.set(214);
            } else if (ch == 41) {
                if (validTypes.contains((Object)QConstants.TokenType.T_RB)) {
                    type = QConstants.TokenType.T_RB;
                }
            } else if (ch == 40) {
                if (validTypes.contains((Object)QConstants.TokenType.T_LB)) {
                    type = QConstants.TokenType.T_LB;
                }
            } else if (ch == 44) {
                if (validTypes.contains((Object)QConstants.TokenType.T_VALUE_SEPARATOR)) {
                    type = QConstants.TokenType.T_VALUE_SEPARATOR;
                }
            } else if (ch == 9) {
                if (validTypes.contains((Object)QConstants.TokenType._TOKEN_4)) {
                    type = QConstants.TokenType._TOKEN_4;
                }
            } else if (ch == 13) {
                if (validTypes.contains((Object)QConstants.TokenType._TOKEN_3)) {
                    type = QConstants.TokenType._TOKEN_3;
                }
            } else if (ch == 10) {
                if (validTypes.contains((Object)QConstants.TokenType._TOKEN_2)) {
                    type = QConstants.TokenType._TOKEN_2;
                }
            } else if (ch == 32 && validTypes.contains((Object)QConstants.TokenType._TOKEN_1)) {
                type = QConstants.TokenType._TOKEN_1;
            }
            return type;
        }

        static QConstants.TokenType NFA_LS_FILTER_1(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 73 || ch == 105) {
                nextStates.set(316);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_2(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 40 && validTypes.contains((Object)QConstants.TokenType.T_QF_SECOND)) {
                return QConstants.TokenType.T_QF_SECOND;
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_3(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 85 || ch == 117) {
                nextStates.set(454);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_4(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 71 || ch == 103) {
                nextStates.set(315);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_5(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 72 || ch == 104) {
                nextStates.set(222);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_6(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 77 || ch == 109) {
                nextStates.set(421);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_7(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 78 || ch == 110) {
                nextStates.set(84);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_8(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 73 || ch == 105) {
                nextStates.set(193);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_9(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 69 || ch == 101) {
                nextStates.set(72);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_10(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 84 || ch == 116) {
                nextStates.set(113);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_11(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 78 || ch == 110) {
                nextStates.set(268);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_12(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 68 || ch == 100) {
                nextStates.set(404);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_13(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 78 || ch == 110) {
                nextStates.set(451);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_14(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 95) {
                nextStates.set(398);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_15(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 78 || ch == 110) {
                nextStates.set(101);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_16(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 95) {
                nextStates.set(91);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_17(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 69 || ch == 101) {
                nextStates.set(56);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_18(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 83 || ch == 115) {
                nextStates.set(78);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_19(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 77 || ch == 109) {
                nextStates.set(428);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_20(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 13 && validTypes.contains((Object)QConstants.TokenType._TOKEN_3)) {
                return QConstants.TokenType._TOKEN_3;
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_21(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 85 || ch == 117) {
                nextStates.set(391);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_22(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 82 || ch == 114) {
                nextStates.set(166);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_23(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 81 || ch == 113) {
                nextStates.set(266);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_24(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 84 || ch == 116) {
                nextStates.set(331);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_25(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 69 || ch == 101) {
                nextStates.set(13);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_26(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if ((ch == 68 || ch == 100) && validTypes.contains((Object)QConstants.TokenType.T_QO_MOD)) {
                return QConstants.TokenType.T_QO_MOD;
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_27(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 69 || ch == 101) {
                nextStates.set(290);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_28(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 82 || ch == 114) {
                nextStates.set(118);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_29(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 65 || ch == 97) {
                nextStates.set(449);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_30(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 84 || ch == 116) {
                nextStates.set(200);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_31(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 40 && validTypes.contains((Object)QConstants.TokenType.T_QF_YEAR)) {
                return QConstants.TokenType.T_QF_YEAR;
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_32(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 83 || ch == 115) {
                nextStates.set(10);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_33(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 82 || ch == 114) {
                nextStates.set(45);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_34(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 76 || ch == 108) {
                nextStates.set(27);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_35(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 83 || ch == 115) {
                nextStates.set(129);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_36(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 73 || ch == 105) {
                nextStates.set(7);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_37(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 70 || ch == 102) {
                nextStates.set(136);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_38(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if ((ch == 81 || ch == 113) && validTypes.contains((Object)QConstants.TokenType.T_QO_EQ)) {
                return QConstants.TokenType.T_QO_EQ;
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_39(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 40 && validTypes.contains((Object)QConstants.TokenType.T_QF_SUBSTRINGOF)) {
                return QConstants.TokenType.T_QF_SUBSTRINGOF;
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_40(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 67 || ch == 99) {
                nextStates.set(160);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_41(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 67 || ch == 99) {
                nextStates.set(17);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_42(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 83 || ch == 115) {
                nextStates.set(192);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_43(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 40 && validTypes.contains((Object)QConstants.TokenType.T_QF_ST_TOUCHES)) {
                return QConstants.TokenType.T_QF_ST_TOUCHES;
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_44(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 69 || ch == 101) {
                nextStates.set(23);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_45(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 76 || ch == 108) {
                nextStates.set(29);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_46(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 87 || ch == 119) {
                nextStates.set(380);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_47(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if ((ch == 76 || ch == 108) && validTypes.contains((Object)QConstants.TokenType.T_QO_MUL)) {
                return QConstants.TokenType.T_QO_MUL;
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_48(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 83 || ch == 115) {
                nextStates.set(238);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_49(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 79 || ch == 111) {
                nextStates.set(204);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_50(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 79 || ch == 111) {
                nextStates.set(280);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_51(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 69 || ch == 101) {
                nextStates.set(411);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_52(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 84 || ch == 116) {
                nextStates.set(419);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_53(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 71 || ch == 103) {
                nextStates.set(49);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_54(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 65 || ch == 97) {
                nextStates.set(296);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_55(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 84 || ch == 116) {
                nextStates.set(448);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_56(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 73 || ch == 105) {
                nextStates.set(144);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_57(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 84 || ch == 116) {
                nextStates.set(223);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_58(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 82 || ch == 114) {
                nextStates.set(322);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_59(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 78 || ch == 110) {
                nextStates.set(420);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_60(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 84 || ch == 116) {
                nextStates.set(312);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_61(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 77 || ch == 109) {
                nextStates.set(95);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_62(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 40 && validTypes.contains((Object)QConstants.TokenType.T_QF_TIME)) {
                return QConstants.TokenType.T_QF_TIME;
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_63(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 79 || ch == 111) {
                nextStates.set(21);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_64(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 73 || ch == 105) {
                nextStates.set(459);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_65(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 69 || ch == 101) {
                nextStates.set(126);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_66(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 82 || ch == 114) {
                nextStates.set(406);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_67(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 73 || ch == 105) {
                nextStates.set(202);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_68(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if ((ch == 69 || ch == 101) && validTypes.contains((Object)QConstants.TokenType.T_QO_GE)) {
                return QConstants.TokenType.T_QO_GE;
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_69(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 89 || ch == 121) {
                nextStates.set(214);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_70(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 78 || ch == 110) {
                nextStates.set(386);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_71(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 73 || ch == 105) {
                nextStates.set(138);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_72(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 40 && validTypes.contains((Object)QConstants.TokenType.T_QF_MAXDATETIME)) {
                return QConstants.TokenType.T_QF_MAXDATETIME;
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_73(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 76 || ch == 108) {
                nextStates.set(417);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_74(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 83 || ch == 115) {
                nextStates.set(407);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_75(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 72 || ch == 104) {
                nextStates.set(246);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_76(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if ((ch == 86 || ch == 118) && validTypes.contains((Object)QConstants.TokenType.T_QO_DIV)) {
                return QConstants.TokenType.T_QO_DIV;
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_77(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 85 || ch == 117) {
                nextStates.set(58);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_78(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 84 || ch == 116) {
                nextStates.set(240);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_79(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 40 && validTypes.contains((Object)QConstants.TokenType.T_QF_GEO_LENGTH)) {
                return QConstants.TokenType.T_QF_GEO_LENGTH;
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_80(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 84 || ch == 116) {
                nextStates.set(457);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_81(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 46) {
                nextStates.set(8);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_82(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if ((ch == 66 || ch == 98) && validTypes.contains((Object)QConstants.TokenType.T_QO_SUB)) {
                return QConstants.TokenType.T_QO_SUB;
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_83(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 40 && validTypes.contains((Object)QConstants.TokenType.T_QF_STARTS)) {
                return QConstants.TokenType.T_QF_STARTS;
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_84(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 68 || ch == 100) {
                nextStates.set(335);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_85(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 83 || ch == 115) {
                nextStates.set(30);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_86(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 72 || ch == 104) {
                nextStates.set(165);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_87(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if ((ch == 78 || ch == 110) && validTypes.contains((Object)QConstants.TokenType.T_QO_IN)) {
                return QConstants.TokenType.T_QO_IN;
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_88(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 69 || ch == 101) {
                nextStates.set(38);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_89(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 83 || ch == 115) {
                nextStates.set(130);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_90(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 84 || ch == 116) {
                nextStates.set(102);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_91(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 82 || ch == 114) {
                nextStates.set(185);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_92(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 79 || ch == 111) {
                nextStates.set(124);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_93(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 84 || ch == 116) {
                nextStates.set(1);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_94(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 73 || ch == 105) {
                nextStates.set(369);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_95(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 40 && validTypes.contains((Object)QConstants.TokenType.T_QF_TRIM)) {
                return QConstants.TokenType.T_QF_TRIM;
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_96(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 83 || ch == 115) {
                nextStates.set(83);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_97(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 84 || ch == 116) {
                nextStates.set(215);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_98(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 69 || ch == 101) {
                nextStates.set(385);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_99(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 78 || ch == 110) {
                nextStates.set(334);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_100(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 73 || ch == 105) {
                nextStates.set(229);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_101(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 68 || ch == 100) {
                nextStates.set(2);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_102(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 95) {
                nextStates.set(337);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_103(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 68 || ch == 100) {
                nextStates.set(94);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_104(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 84 || ch == 116) {
                nextStates.set(111);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_105(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 65 || ch == 97) {
                nextStates.set(279);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_106(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 76 || ch == 108) {
                nextStates.set(326);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_107(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 65 || ch == 97) {
                nextStates.set(269);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_108(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 82 || ch == 114) {
                nextStates.set(383);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_109(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if ((ch == 68 || ch == 100) && validTypes.contains((Object)QConstants.TokenType.T_QO_ADD)) {
                return QConstants.TokenType.T_QO_ADD;
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_110(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 83 || ch == 115) {
                nextStates.set(437);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_111(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 69 || ch == 101) {
                nextStates.set(247);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_112(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 84 || ch == 116) {
                nextStates.set(365);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_113(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 95) {
                nextStates.set(46);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_114(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 78 || ch == 110) {
                nextStates.set(189);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_115(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 40 && validTypes.contains((Object)QConstants.TokenType.T_QF_BEFORE)) {
                return QConstants.TokenType.T_QF_BEFORE;
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_116(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 71 || ch == 103) {
                nextStates.set(68);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_117(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 71 || ch == 103) {
                nextStates.set(203);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_118(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 40 && validTypes.contains((Object)QConstants.TokenType.T_QF_FLOOR)) {
                return QConstants.TokenType.T_QF_FLOOR;
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_119(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 84 || ch == 116) {
                nextStates.set(98);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_120(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 65 || ch == 97) {
                nextStates.set(304);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_121(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 83 || ch == 115) {
                nextStates.set(163);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_122(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 46) {
                nextStates.set(103);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_123(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 73 || ch == 105) {
                nextStates.set(87);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_124(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 78 || ch == 110) {
                nextStates.set(52);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_125(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 40 && validTypes.contains((Object)QConstants.TokenType.T_QF_ST_DISJOINT)) {
                return QConstants.TokenType.T_QF_ST_DISJOINT;
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_126(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 82 || ch == 114) {
                nextStates.set(271);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_127(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 69 || ch == 101) {
                nextStates.set(164);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_128(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 82 || ch == 114) {
                nextStates.set(410);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_129(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 87 || ch == 119) {
                nextStates.set(343);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_130(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 40 && validTypes.contains((Object)QConstants.TokenType.T_QF_ST_INTERSECTS)) {
                return QConstants.TokenType.T_QF_ST_INTERSECTS;
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_131(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 79 || ch == 111) {
                nextStates.set(458);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_132(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 40 && validTypes.contains((Object)QConstants.TokenType.T_QF_MINUTE)) {
                return QConstants.TokenType.T_QF_MINUTE;
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_133(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 95) {
                nextStates.set(44);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_134(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 82 || ch == 114) {
                nextStates.set(371);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_135(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 77 || ch == 109) {
                nextStates.set(443);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_136(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 83 || ch == 115) {
                nextStates.set(402);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_137(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 40 && validTypes.contains((Object)QConstants.TokenType.T_QF_INDEXOF)) {
                return QConstants.TokenType.T_QF_INDEXOF;
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_138(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 78 || ch == 110) {
                nextStates.set(272);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_139(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 84 || ch == 116) {
                nextStates.set(464);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_140(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 79 || ch == 111) {
                nextStates.set(318);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_141(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 83 || ch == 115) {
                nextStates.set(3);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_142(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 76 || ch == 108) {
                nextStates.set(333);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_143(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 87 || ch == 119) {
                nextStates.set(178);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_144(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 76 || ch == 108) {
                nextStates.set(67);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_145(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 82 || ch == 114) {
                nextStates.set(323);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_146(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 40 && validTypes.contains((Object)QConstants.TokenType.T_QF_FRACTIONALSECONDS)) {
                return QConstants.TokenType.T_QF_FRACTIONALSECONDS;
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_147(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 95) {
                nextStates.set(207);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_148(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 40 && validTypes.contains((Object)QConstants.TokenType.T_QF_TOLOWER)) {
                return QConstants.TokenType.T_QF_TOLOWER;
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_149(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 40 && validTypes.contains((Object)QConstants.TokenType.T_QF_PRINCIPAL_NAME)) {
                return QConstants.TokenType.T_QF_PRINCIPAL_NAME;
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_150(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 82 || ch == 114) {
                nextStates.set(248);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_151(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 82 || ch == 114) {
                nextStates.set(401);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_152(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 82 || ch == 114) {
                nextStates.set(267);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_153(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 84 || ch == 116) {
                nextStates.set(89);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_154(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 40 && validTypes.contains((Object)QConstants.TokenType.T_QF_FINISHES)) {
                return QConstants.TokenType.T_QF_FINISHES;
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_155(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if ((ch == 69 || ch == 101) && validTypes.contains((Object)QConstants.TokenType.T_QO_NE)) {
                return QConstants.TokenType.T_QO_NE;
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_156(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 46) {
                nextStates.set(220);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_157(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 65 || ch == 97) {
                nextStates.set(232);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_158(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 84 || ch == 116) {
                nextStates.set(415);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_159(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 67 || ch == 99) {
                nextStates.set(168);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_160(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 65 || ch == 97) {
                nextStates.set(325);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_161(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 67 || ch == 99) {
                nextStates.set(285);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_162(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 40 && validTypes.contains((Object)QConstants.TokenType.T_QF_ROUND)) {
                return QConstants.TokenType.T_QF_ROUND;
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_163(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 40 && validTypes.contains((Object)QConstants.TokenType.T_QF_ST_CROSSES)) {
                return QConstants.TokenType.T_QF_ST_CROSSES;
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_164(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 79 || ch == 111) {
                nextStates.set(156);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_165(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 40 && validTypes.contains((Object)QConstants.TokenType.T_QF_LENGTH)) {
                return QConstants.TokenType.T_QF_LENGTH;
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_166(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 76 || ch == 108) {
                nextStates.set(355);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_167(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 40 && validTypes.contains((Object)QConstants.TokenType.T_QF_MINDATETIME)) {
                return QConstants.TokenType.T_QF_MINDATETIME;
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_168(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 79 || ch == 111) {
                nextStates.set(463);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_169(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 69 || ch == 101) {
                nextStates.set(33);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_170(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 83 || ch == 115) {
                nextStates.set(311);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_171(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 88 || ch == 120) {
                nextStates.set(438);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_172(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if ((ch == 84 || ch == 116) && validTypes.contains((Object)QConstants.TokenType.T_QO_NOT)) {
                return QConstants.TokenType.T_QO_NOT;
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_173(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 84 || ch == 116) {
                nextStates.set(63);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_174(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 88 || ch == 120) {
                nextStates.set(308);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_175(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 73 || ch == 105) {
                nextStates.set(455);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_176(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 71 || ch == 103) {
                nextStates.set(127);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_177(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 84 || ch == 116) {
                nextStates.set(376);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_178(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 73 || ch == 105) {
                nextStates.set(359);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_179(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 82 || ch == 114) {
                nextStates.set(148);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_180(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 68 || ch == 100) {
                nextStates.set(344);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_181(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 79 || ch == 111) {
                nextStates.set(462);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_182(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 84 || ch == 116) {
                nextStates.set(206);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_183(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 79 || ch == 111) {
                nextStates.set(213);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_184(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 83 || ch == 115) {
                nextStates.set(154);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_185(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 69 || ch == 101) {
                nextStates.set(194);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_186(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 83 || ch == 115) {
                nextStates.set(24);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_187(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 69 || ch == 101) {
                nextStates.set(149);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_188(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 65 || ch == 97) {
                nextStates.set(338);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_189(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 73 || ch == 105) {
                nextStates.set(42);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_190(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 9 && validTypes.contains((Object)QConstants.TokenType._TOKEN_4)) {
                return QConstants.TokenType._TOKEN_4;
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_191(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 78 || ch == 110) {
                nextStates.set(390);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_192(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 72 || ch == 104) {
                nextStates.set(309);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_193(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 78 || ch == 110) {
                nextStates.set(60);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_194(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 76 || ch == 108) {
                nextStates.set(236);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_195(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 83 || ch == 115) {
                nextStates.set(433);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_196(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 69 || ch == 101) {
                nextStates.set(444);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_197(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 84 || ch == 116) {
                nextStates.set(400);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_198(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 84 || ch == 116) {
                nextStates.set(260);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_199(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 69 || ch == 101) {
                nextStates.set(228);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_200(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 95) {
                nextStates.set(182);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_201(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 83 || ch == 115) {
                nextStates.set(303);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_202(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 78 || ch == 110) {
                nextStates.set(4);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_203(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 40 && validTypes.contains((Object)QConstants.TokenType.T_QF_DURING)) {
                return QConstants.TokenType.T_QF_DURING;
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_204(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 70 || ch == 102) {
                nextStates.set(39);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_205(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 79 || ch == 111) {
                nextStates.set(28);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_206(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 79 || ch == 111) {
                nextStates.set(357);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_207(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 68 || ch == 100) {
                nextStates.set(418);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_208(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 84 || ch == 116) {
                nextStates.set(384);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_209(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 69 || ch == 101) {
                nextStates.set(22);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_210(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 78 || ch == 110) {
                nextStates.set(155);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_211(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 67 || ch == 99) {
                nextStates.set(422);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_212(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 40 && validTypes.contains((Object)QConstants.TokenType.T_QF_NOW)) {
                return QConstants.TokenType.T_QF_NOW;
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_213(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 86 || ch == 118) {
                nextStates.set(169);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_214(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 69 || ch == 101) {
                nextStates.set(157);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_215(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 79 || ch == 111) {
                nextStates.set(294);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_216(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 78 || ch == 110) {
                nextStates.set(452);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_217(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 83 || ch == 115) {
                nextStates.set(146);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_218(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 82 || ch == 114) {
                nextStates.set(367);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_219(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 83 || ch == 115) {
                nextStates.set(273);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_220(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 76 || ch == 108) {
                nextStates.set(25);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_221(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 67 || ch == 99) {
                nextStates.set(347);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_222(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 79 || ch == 111) {
                nextStates.set(373);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_223(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 82 || ch == 114) {
                nextStates.set(293);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_224(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if ((ch == 69 || ch == 101) && validTypes.contains((Object)QConstants.TokenType.T_QO_LE)) {
                return QConstants.TokenType.T_QO_LE;
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_225(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 70 || ch == 102) {
                nextStates.set(158);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_226(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 78 || ch == 110) {
                nextStates.set(431);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_227(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 70 || ch == 102) {
                nextStates.set(37);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_228(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 67 || ch == 99) {
                nextStates.set(131);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_229(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 78 || ch == 110) {
                nextStates.set(388);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_230(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 84 || ch == 116) {
                nextStates.set(125);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_231(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 40 && validTypes.contains((Object)QConstants.TokenType.T_QF_MONTH)) {
                return QConstants.TokenType.T_QF_MONTH;
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_232(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 82 || ch == 114) {
                nextStates.set(31);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_233(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 40 && validTypes.contains((Object)QConstants.TokenType.T_QF_STARTSWITH)) {
                return QConstants.TokenType.T_QF_STARTSWITH;
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_234(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 32 && validTypes.contains((Object)QConstants.TokenType._TOKEN_1)) {
                return QConstants.TokenType._TOKEN_1;
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_235(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 83 || ch == 115) {
                nextStates.set(389);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_236(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 65 || ch == 97) {
                nextStates.set(288);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_237(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 76 || ch == 108) {
                nextStates.set(224);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_238(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 84 || ch == 116) {
                nextStates.set(133);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_239(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 69 || ch == 101) {
                nextStates.set(121);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_240(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 65 || ch == 97) {
                nextStates.set(218);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_241(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 65 || ch == 97) {
                nextStates.set(106);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_242(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 83 || ch == 115) {
                nextStates.set(143);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_243(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 71 || ch == 103) {
                nextStates.set(346);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_244(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 65 || ch == 97) {
                nextStates.set(225);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_245(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 84 || ch == 116) {
                nextStates.set(446);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_246(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 69 || ch == 101) {
                nextStates.set(321);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_247(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 83 || ch == 115) {
                nextStates.set(263);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_248(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 73 || ch == 105) {
                nextStates.set(456);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_249(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 80 || ch == 112) {
                nextStates.set(241);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_250(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if ((ch == 84 || ch == 116) && validTypes.contains((Object)QConstants.TokenType.T_QO_GT)) {
                return QConstants.TokenType.T_QO_GT;
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_251(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 78 || ch == 110) {
                nextStates.set(274);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_252(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 79 || ch == 111) {
                nextStates.set(205);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_253(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 76 || ch == 108) {
                nextStates.set(327);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_254(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 79 || ch == 111) {
                nextStates.set(330);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_255(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 80 || ch == 112) {
                nextStates.set(195);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_256(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 40 && validTypes.contains((Object)QConstants.TokenType.T_QF_GEO_DISTANCE)) {
                return QConstants.TokenType.T_QF_GEO_DISTANCE;
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_257(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 40 && validTypes.contains((Object)QConstants.TokenType.T_QF_DATE)) {
                return QConstants.TokenType.T_QF_DATE;
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_258(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 74 || ch == 106) {
                nextStates.set(302);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_259(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 83 || ch == 115) {
                nextStates.set(197);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_260(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 79 || ch == 111) {
                nextStates.set(381);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_261(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 65 || ch == 97) {
                nextStates.set(253);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_262(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 67 || ch == 99) {
                nextStates.set(181);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_263(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 40 && validTypes.contains((Object)QConstants.TokenType.T_QF_TOTALOFFSETMINUTES)) {
                return QConstants.TokenType.T_QF_TOTALOFFSETMINUTES;
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_264(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 66 || ch == 98) {
                nextStates.set(259);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_265(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 83 || ch == 115) {
                nextStates.set(427);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_266(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 85 || ch == 117) {
                nextStates.set(379);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_267(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 79 || ch == 111) {
                nextStates.set(430);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_268(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 67 || ch == 99) {
                nextStates.set(414);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_269(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 76 || ch == 108) {
                nextStates.set(313);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_270(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 82 || ch == 114) {
                nextStates.set(74);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_271(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 40 && validTypes.contains((Object)QConstants.TokenType.T_QF_TOUPPER)) {
                return QConstants.TokenType.T_QF_TOUPPER;
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_272(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 85 || ch == 117) {
                nextStates.set(104);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_273(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 40 && validTypes.contains((Object)QConstants.TokenType.T_QF_GEO_INTERSECTS)) {
                return QConstants.TokenType.T_QF_GEO_INTERSECTS;
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_274(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 79 || ch == 111) {
                nextStates.set(172);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_275(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 78 || ch == 110) {
                nextStates.set(107);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_276(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 40 && validTypes.contains((Object)QConstants.TokenType.T_QF_CONCAT)) {
                return QConstants.TokenType.T_QF_CONCAT;
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_277(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 84 || ch == 116) {
                nextStates.set(16);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_278(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 41 && validTypes.contains((Object)QConstants.TokenType.T_RB)) {
                return QConstants.TokenType.T_RB;
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_279(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 78 || ch == 110) {
                nextStates.set(409);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_280(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 87 || ch == 119) {
                nextStates.set(212);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_281(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 69 || ch == 101) {
                nextStates.set(216);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_282(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 67 || ch == 99) {
                nextStates.set(93);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_283(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 84 || ch == 116) {
                nextStates.set(147);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_284(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 68 || ch == 100) {
                nextStates.set(109);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_285(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 79 || ch == 111) {
                nextStates.set(15);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_286(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 69 || ch == 101) {
                nextStates.set(450);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_287(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 70 || ch == 102) {
                nextStates.set(145);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_288(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 84 || ch == 116) {
                nextStates.set(196);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_289(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 83 || ch == 115) {
                nextStates.set(90);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_290(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 78 || ch == 110) {
                nextStates.set(348);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_291(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 77 || ch == 109) {
                nextStates.set(340);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_292(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 68 || ch == 100) {
                nextStates.set(77);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_293(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 73 || ch == 105) {
                nextStates.set(99);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_294(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 84 || ch == 116) {
                nextStates.set(261);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_295(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 65 || ch == 97) {
                nextStates.set(11);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_296(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 82 || ch == 114) {
                nextStates.set(364);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_297(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 73 || ch == 105) {
                nextStates.set(114);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_298(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 69 || ch == 101) {
                nextStates.set(361);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_299(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 70 || ch == 102) {
                nextStates.set(297);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_300(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 70 || ch == 102) {
                nextStates.set(137);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_301(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 83 || ch == 115) {
                nextStates.set(435);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_302(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 79 || ch == 111) {
                nextStates.set(447);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_303(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 40 && validTypes.contains((Object)QConstants.TokenType.T_QF_ST_CONTAINS)) {
                return QConstants.TokenType.T_QF_ST_CONTAINS;
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_304(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 77 || ch == 109) {
                nextStates.set(187);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_305(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 44 && validTypes.contains((Object)QConstants.TokenType.T_VALUE_SEPARATOR)) {
                return QConstants.TokenType.T_VALUE_SEPARATOR;
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_306(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 78 || ch == 110) {
                nextStates.set(53);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_307(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 86 || ch == 118) {
                nextStates.set(209);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_308(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 68 || ch == 100) {
                nextStates.set(332);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_309(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 69 || ch == 101) {
                nextStates.set(184);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_310(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 73 || ch == 105) {
                nextStates.set(76);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_311(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 40 && validTypes.contains((Object)QConstants.TokenType.T_QF_OVERLAPS)) {
                return QConstants.TokenType.T_QF_OVERLAPS;
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_312(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 69 || ch == 101) {
                nextStates.set(270);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_313(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 83 || ch == 115) {
                nextStates.set(199);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_314(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 83 || ch == 115) {
                nextStates.set(319);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_315(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 40 && validTypes.contains((Object)QConstants.TokenType.T_QF_CEILING)) {
                return QConstants.TokenType.T_QF_CEILING;
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_316(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 79 || ch == 111) {
                nextStates.set(275);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_317(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 80 || ch == 112) {
                nextStates.set(150);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_318(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if ((ch == 82 || ch == 114) && validTypes.contains((Object)QConstants.TokenType.T_QO_OR)) {
                return QConstants.TokenType.T_QO_OR;
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_319(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 84 || ch == 116) {
                nextStates.set(54);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_320(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 82 || ch == 114) {
                nextStates.set(353);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_321(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 83 || ch == 115) {
                nextStates.set(43);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_322(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 73 || ch == 105) {
                nextStates.set(352);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_323(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 65 || ch == 97) {
                nextStates.set(282);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_324(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 77 || ch == 109) {
                nextStates.set(403);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_325(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 84 || ch == 116) {
                nextStates.set(276);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_326(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 78 || ch == 110) {
                nextStates.set(120);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_327(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 79 || ch == 111) {
                nextStates.set(227);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_328(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 67 || ch == 99) {
                nextStates.set(108);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_329(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 68 || ch == 100) {
                nextStates.set(310);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_330(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 87 || ch == 119) {
                nextStates.set(350);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_331(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 95) {
                nextStates.set(159);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_332(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 65 || ch == 97) {
                nextStates.set(119);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_333(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if ((ch == 84 || ch == 116) && validTypes.contains((Object)QConstants.TokenType.T_QO_LT)) {
                return QConstants.TokenType.T_QO_LT;
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_334(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 71 || ch == 103) {
                nextStates.set(460);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_335(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 65 || ch == 97) {
                nextStates.set(439);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_336(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 79 || ch == 111) {
                nextStates.set(122);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_337(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 79 || ch == 111) {
                nextStates.set(307);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_338(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 73 || ch == 105) {
                nextStates.set(413);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_339(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 80 || ch == 112) {
                nextStates.set(65);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_340(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 85 || ch == 117) {
                nextStates.set(47);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_341(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 89 || ch == 121) {
                nextStates.set(387);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_342(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 83 || ch == 115) {
                nextStates.set(139);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_343(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 73 || ch == 105) {
                nextStates.set(112);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_344(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 65 || ch == 97) {
                nextStates.set(208);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_345(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 84 || ch == 116) {
                nextStates.set(295);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_346(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 69 || ch == 101) {
                nextStates.set(399);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_347(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 73 || ch == 105) {
                nextStates.set(249);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_348(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 71 || ch == 103) {
                nextStates.set(434);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_349(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 76 || ch == 108) {
                nextStates.set(252);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_350(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 69 || ch == 101) {
                nextStates.set(179);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_351(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 79 || ch == 111) {
                nextStates.set(66);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_352(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 78 || ch == 110) {
                nextStates.set(117);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_353(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 83 || ch == 115) {
                nextStates.set(298);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_354(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 65 || ch == 97) {
                nextStates.set(284);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_355(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 65 || ch == 97) {
                nextStates.set(255);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_356(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 40 && validTypes.contains((Object)QConstants.TokenType.T_LB)) {
                return QConstants.TokenType.T_LB;
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_357(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 85 || ch == 117) {
                nextStates.set(358);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_358(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 67 || ch == 99) {
                nextStates.set(75);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_359(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 84 || ch == 116) {
                nextStates.set(445);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_360(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 73 || ch == 105) {
                nextStates.set(70);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_361(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 67 || ch == 99) {
                nextStates.set(153);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_362(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 69 || ch == 101) {
                nextStates.set(320);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_363(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 77 || ch == 109) {
                nextStates.set(36);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_364(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 84 || ch == 116) {
                nextStates.set(35);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_365(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 72 || ch == 104) {
                nextStates.set(233);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_366(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 72 || ch == 104) {
                nextStates.set(360);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_367(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 84 || ch == 116) {
                nextStates.set(96);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_368(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 83 || ch == 115) {
                nextStates.set(57);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_369(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 83 || ch == 115) {
                nextStates.set(345);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_370(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 70 || ch == 102) {
                nextStates.set(349);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_371(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 40 && validTypes.contains((Object)QConstants.TokenType.T_QF_AFTER)) {
                return QConstants.TokenType.T_QF_AFTER;
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_372(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 78 || ch == 110) {
                nextStates.set(50);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_373(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 85 || ch == 117) {
                nextStates.set(151);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_374(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 84 || ch == 116) {
                nextStates.set(64);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_375(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 84 || ch == 116) {
                nextStates.set(366);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_376(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 77 || ch == 109) {
                nextStates.set(71);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_377(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 84 || ch == 116) {
                nextStates.set(265);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_378(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 77 || ch == 109) {
                nextStates.set(51);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_379(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 65 || ch == 97) {
                nextStates.set(73);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_380(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 73 || ch == 105) {
                nextStates.set(375);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_381(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 76 || ch == 108) {
                nextStates.set(254);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_382(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 84 || ch == 116) {
                nextStates.set(188);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_383(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 79 || ch == 111) {
                nextStates.set(235);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_384(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 69 || ch == 101) {
                nextStates.set(257);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_385(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 84 || ch == 116) {
                nextStates.set(175);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_386(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 40 && validTypes.contains((Object)QConstants.TokenType.T_QF_ST_WITHIN)) {
                return QConstants.TokenType.T_QF_ST_WITHIN;
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_387(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 40 && validTypes.contains((Object)QConstants.TokenType.T_QF_DAY)) {
                return QConstants.TokenType.T_QF_DAY;
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_388(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 68 || ch == 100) {
                nextStates.set(395);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_389(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 83 || ch == 115) {
                nextStates.set(239);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_390(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 85 || ch == 117) {
                nextStates.set(80);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_391(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 80 || ch == 112) {
                nextStates.set(339);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_392(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 40 && validTypes.contains((Object)QConstants.TokenType.T_QF_ENDSWITH)) {
                return QConstants.TokenType.T_QF_ENDSWITH;
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_393(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 84 || ch == 116) {
                nextStates.set(128);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_394(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 83 || ch == 115) {
                nextStates.set(283);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_395(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 69 || ch == 101) {
                nextStates.set(171);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_396(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 68 || ch == 100) {
                nextStates.set(217);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_397(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 71 || ch == 103) {
                nextStates.set(250);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_398(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 73 || ch == 105) {
                nextStates.set(59);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_399(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 79 || ch == 111) {
                nextStates.set(81);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_400(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 82 || ch == 114) {
                nextStates.set(441);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_401(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 40 && validTypes.contains((Object)QConstants.TokenType.T_QF_HOUR)) {
                return QConstants.TokenType.T_QF_HOUR;
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_402(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 69 || ch == 101) {
                nextStates.set(177);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_403(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 65 || ch == 97) {
                nextStates.set(174);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_404(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 65 || ch == 97) {
                nextStates.set(341);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_405(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 83 || ch == 115) {
                nextStates.set(423);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_406(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 69 || ch == 101) {
                nextStates.set(115);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_407(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 69 || ch == 101) {
                nextStates.set(211);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_408(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 69 || ch == 101) {
                nextStates.set(374);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_409(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if ((ch == 68 || ch == 100) && validTypes.contains((Object)QConstants.TokenType.T_QO_AND)) {
                return QConstants.TokenType.T_QO_AND;
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_410(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 73 || ch == 105) {
                nextStates.set(61);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_411(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 69 || ch == 101) {
                nextStates.set(377);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_412(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 40 && validTypes.contains((Object)QConstants.TokenType.T_QF_ST_EQUALS)) {
                return QConstants.TokenType.T_QF_ST_EQUALS;
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_413(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 78 || ch == 110) {
                nextStates.set(201);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_414(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 69 || ch == 101) {
                nextStates.set(256);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_415(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 69 || ch == 101) {
                nextStates.set(134);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_416(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 78 || ch == 110) {
                nextStates.set(230);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_417(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 83 || ch == 115) {
                nextStates.set(412);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_418(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 73 || ch == 105) {
                nextStates.set(425);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_419(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 72 || ch == 104) {
                nextStates.set(231);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_420(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 84 || ch == 116) {
                nextStates.set(362);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_421(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 73 || ch == 105) {
                nextStates.set(191);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_422(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 84 || ch == 116) {
                nextStates.set(219);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_423(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 85 || ch == 117) {
                nextStates.set(82);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_424(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 69 || ch == 101) {
                nextStates.set(167);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_425(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 83 || ch == 115) {
                nextStates.set(258);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_426(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 77 || ch == 109) {
                nextStates.set(92);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_427(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 40 && validTypes.contains((Object)QConstants.TokenType.T_QF_MEETS)) {
                return QConstants.TokenType.T_QF_MEETS;
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_428(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 79 || ch == 111) {
                nextStates.set(26);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_429(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 85 || ch == 117) {
                nextStates.set(264);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_430(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 85 || ch == 117) {
                nextStates.set(226);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_431(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 68 || ch == 100) {
                nextStates.set(162);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_432(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 69 || ch == 101) {
                nextStates.set(336);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_433(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 40 && validTypes.contains((Object)QConstants.TokenType.T_QF_ST_OVERLAPS)) {
                return QConstants.TokenType.T_QF_ST_OVERLAPS;
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_434(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 84 || ch == 116) {
                nextStates.set(86);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_435(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 69 || ch == 101) {
                nextStates.set(161);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_436(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 83 || ch == 115) {
                nextStates.set(429);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_437(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 84 || ch == 116) {
                nextStates.set(14);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_438(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 79 || ch == 111) {
                nextStates.set(300);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_439(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 84 || ch == 116) {
                nextStates.set(408);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_440(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 10 && validTypes.contains((Object)QConstants.TokenType._TOKEN_2)) {
                return QConstants.TokenType._TOKEN_2;
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_441(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 73 || ch == 105) {
                nextStates.set(306);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_442(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 83 || ch == 115) {
                nextStates.set(277);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_443(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 69 || ch == 101) {
                nextStates.set(62);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_444(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 40 && validTypes.contains((Object)QConstants.TokenType.T_QF_ST_RELATE)) {
                return QConstants.TokenType.T_QF_ST_RELATE;
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_445(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 72 || ch == 104) {
                nextStates.set(392);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_446(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 72 || ch == 104) {
                nextStates.set(79);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_447(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 73 || ch == 105) {
                nextStates.set(416);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_448(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 73 || ch == 105) {
                nextStates.set(135);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_449(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 80 || ch == 112) {
                nextStates.set(170);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_450(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 70 || ch == 102) {
                nextStates.set(351);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_451(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 71 || ch == 103) {
                nextStates.set(245);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_452(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 68 || ch == 100) {
                nextStates.set(242);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_453(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 71 || ch == 103) {
                nextStates.set(432);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_454(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 66 || ch == 98) {
                nextStates.set(368);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_455(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 77 || ch == 109) {
                nextStates.set(9);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_456(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 78 || ch == 110) {
                nextStates.set(221);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_457(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 69 || ch == 101) {
                nextStates.set(132);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_458(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 78 || ch == 110) {
                nextStates.set(396);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_459(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 77 || ch == 109) {
                nextStates.set(424);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_460(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 40 && validTypes.contains((Object)QConstants.TokenType.T_QF_SUBSTRING)) {
                return QConstants.TokenType.T_QF_SUBSTRING;
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_461(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 66 || ch == 98) {
                nextStates.set(286);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_462(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 78 || ch == 110) {
                nextStates.set(40);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_463(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 78 || ch == 110) {
                nextStates.set(382);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_FILTER_464(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 95) {
                nextStates.set(328);
            }
            return null;
        }

        private static void NFA_FUNCTIONS_init() {
            NfaFunction[] functions = new NfaFunction[]{LS_FILTER::NFA_COMPOSITE_LS_FILTER_0, LS_FILTER::NFA_LS_FILTER_1, LS_FILTER::NFA_LS_FILTER_2, LS_FILTER::NFA_LS_FILTER_3, LS_FILTER::NFA_LS_FILTER_4, LS_FILTER::NFA_LS_FILTER_5, LS_FILTER::NFA_LS_FILTER_6, LS_FILTER::NFA_LS_FILTER_7, LS_FILTER::NFA_LS_FILTER_8, LS_FILTER::NFA_LS_FILTER_9, LS_FILTER::NFA_LS_FILTER_10, LS_FILTER::NFA_LS_FILTER_11, LS_FILTER::NFA_LS_FILTER_12, LS_FILTER::NFA_LS_FILTER_13, LS_FILTER::NFA_LS_FILTER_14, LS_FILTER::NFA_LS_FILTER_15, LS_FILTER::NFA_LS_FILTER_16, LS_FILTER::NFA_LS_FILTER_17, LS_FILTER::NFA_LS_FILTER_18, LS_FILTER::NFA_LS_FILTER_19, LS_FILTER::NFA_LS_FILTER_20, LS_FILTER::NFA_LS_FILTER_21, LS_FILTER::NFA_LS_FILTER_22, LS_FILTER::NFA_LS_FILTER_23, LS_FILTER::NFA_LS_FILTER_24, LS_FILTER::NFA_LS_FILTER_25, LS_FILTER::NFA_LS_FILTER_26, LS_FILTER::NFA_LS_FILTER_27, LS_FILTER::NFA_LS_FILTER_28, LS_FILTER::NFA_LS_FILTER_29, LS_FILTER::NFA_LS_FILTER_30, LS_FILTER::NFA_LS_FILTER_31, LS_FILTER::NFA_LS_FILTER_32, LS_FILTER::NFA_LS_FILTER_33, LS_FILTER::NFA_LS_FILTER_34, LS_FILTER::NFA_LS_FILTER_35, LS_FILTER::NFA_LS_FILTER_36, LS_FILTER::NFA_LS_FILTER_37, LS_FILTER::NFA_LS_FILTER_38, LS_FILTER::NFA_LS_FILTER_39, LS_FILTER::NFA_LS_FILTER_40, LS_FILTER::NFA_LS_FILTER_41, LS_FILTER::NFA_LS_FILTER_42, LS_FILTER::NFA_LS_FILTER_43, LS_FILTER::NFA_LS_FILTER_44, LS_FILTER::NFA_LS_FILTER_45, LS_FILTER::NFA_LS_FILTER_46, LS_FILTER::NFA_LS_FILTER_47, LS_FILTER::NFA_LS_FILTER_48, LS_FILTER::NFA_LS_FILTER_49, LS_FILTER::NFA_LS_FILTER_50, LS_FILTER::NFA_LS_FILTER_51, LS_FILTER::NFA_LS_FILTER_52, LS_FILTER::NFA_LS_FILTER_53, LS_FILTER::NFA_LS_FILTER_54, LS_FILTER::NFA_LS_FILTER_55, LS_FILTER::NFA_LS_FILTER_56, LS_FILTER::NFA_LS_FILTER_57, LS_FILTER::NFA_LS_FILTER_58, LS_FILTER::NFA_LS_FILTER_59, LS_FILTER::NFA_LS_FILTER_60, LS_FILTER::NFA_LS_FILTER_61, LS_FILTER::NFA_LS_FILTER_62, LS_FILTER::NFA_LS_FILTER_63, LS_FILTER::NFA_LS_FILTER_64, LS_FILTER::NFA_LS_FILTER_65, LS_FILTER::NFA_LS_FILTER_66, LS_FILTER::NFA_LS_FILTER_67, LS_FILTER::NFA_LS_FILTER_68, LS_FILTER::NFA_LS_FILTER_69, LS_FILTER::NFA_LS_FILTER_70, LS_FILTER::NFA_LS_FILTER_71, LS_FILTER::NFA_LS_FILTER_72, LS_FILTER::NFA_LS_FILTER_73, LS_FILTER::NFA_LS_FILTER_74, LS_FILTER::NFA_LS_FILTER_75, LS_FILTER::NFA_LS_FILTER_76, LS_FILTER::NFA_LS_FILTER_77, LS_FILTER::NFA_LS_FILTER_78, LS_FILTER::NFA_LS_FILTER_79, LS_FILTER::NFA_LS_FILTER_80, LS_FILTER::NFA_LS_FILTER_81, LS_FILTER::NFA_LS_FILTER_82, LS_FILTER::NFA_LS_FILTER_83, LS_FILTER::NFA_LS_FILTER_84, LS_FILTER::NFA_LS_FILTER_85, LS_FILTER::NFA_LS_FILTER_86, LS_FILTER::NFA_LS_FILTER_87, LS_FILTER::NFA_LS_FILTER_88, LS_FILTER::NFA_LS_FILTER_89, LS_FILTER::NFA_LS_FILTER_90, LS_FILTER::NFA_LS_FILTER_91, LS_FILTER::NFA_LS_FILTER_92, LS_FILTER::NFA_LS_FILTER_93, LS_FILTER::NFA_LS_FILTER_94, LS_FILTER::NFA_LS_FILTER_95, LS_FILTER::NFA_LS_FILTER_96, LS_FILTER::NFA_LS_FILTER_97, LS_FILTER::NFA_LS_FILTER_98, LS_FILTER::NFA_LS_FILTER_99, LS_FILTER::NFA_LS_FILTER_100, LS_FILTER::NFA_LS_FILTER_101, LS_FILTER::NFA_LS_FILTER_102, LS_FILTER::NFA_LS_FILTER_103, LS_FILTER::NFA_LS_FILTER_104, LS_FILTER::NFA_LS_FILTER_105, LS_FILTER::NFA_LS_FILTER_106, LS_FILTER::NFA_LS_FILTER_107, LS_FILTER::NFA_LS_FILTER_108, LS_FILTER::NFA_LS_FILTER_109, LS_FILTER::NFA_LS_FILTER_110, LS_FILTER::NFA_LS_FILTER_111, LS_FILTER::NFA_LS_FILTER_112, LS_FILTER::NFA_LS_FILTER_113, LS_FILTER::NFA_LS_FILTER_114, LS_FILTER::NFA_LS_FILTER_115, LS_FILTER::NFA_LS_FILTER_116, LS_FILTER::NFA_LS_FILTER_117, LS_FILTER::NFA_LS_FILTER_118, LS_FILTER::NFA_LS_FILTER_119, LS_FILTER::NFA_LS_FILTER_120, LS_FILTER::NFA_LS_FILTER_121, LS_FILTER::NFA_LS_FILTER_122, LS_FILTER::NFA_LS_FILTER_123, LS_FILTER::NFA_LS_FILTER_124, LS_FILTER::NFA_LS_FILTER_125, LS_FILTER::NFA_LS_FILTER_126, LS_FILTER::NFA_LS_FILTER_127, LS_FILTER::NFA_LS_FILTER_128, LS_FILTER::NFA_LS_FILTER_129, LS_FILTER::NFA_LS_FILTER_130, LS_FILTER::NFA_LS_FILTER_131, LS_FILTER::NFA_LS_FILTER_132, LS_FILTER::NFA_LS_FILTER_133, LS_FILTER::NFA_LS_FILTER_134, LS_FILTER::NFA_LS_FILTER_135, LS_FILTER::NFA_LS_FILTER_136, LS_FILTER::NFA_LS_FILTER_137, LS_FILTER::NFA_LS_FILTER_138, LS_FILTER::NFA_LS_FILTER_139, LS_FILTER::NFA_LS_FILTER_140, LS_FILTER::NFA_LS_FILTER_141, LS_FILTER::NFA_LS_FILTER_142, LS_FILTER::NFA_LS_FILTER_143, LS_FILTER::NFA_LS_FILTER_144, LS_FILTER::NFA_LS_FILTER_145, LS_FILTER::NFA_LS_FILTER_146, LS_FILTER::NFA_LS_FILTER_147, LS_FILTER::NFA_LS_FILTER_148, LS_FILTER::NFA_LS_FILTER_149, LS_FILTER::NFA_LS_FILTER_150, LS_FILTER::NFA_LS_FILTER_151, LS_FILTER::NFA_LS_FILTER_152, LS_FILTER::NFA_LS_FILTER_153, LS_FILTER::NFA_LS_FILTER_154, LS_FILTER::NFA_LS_FILTER_155, LS_FILTER::NFA_LS_FILTER_156, LS_FILTER::NFA_LS_FILTER_157, LS_FILTER::NFA_LS_FILTER_158, LS_FILTER::NFA_LS_FILTER_159, LS_FILTER::NFA_LS_FILTER_160, LS_FILTER::NFA_LS_FILTER_161, LS_FILTER::NFA_LS_FILTER_162, LS_FILTER::NFA_LS_FILTER_163, LS_FILTER::NFA_LS_FILTER_164, LS_FILTER::NFA_LS_FILTER_165, LS_FILTER::NFA_LS_FILTER_166, LS_FILTER::NFA_LS_FILTER_167, LS_FILTER::NFA_LS_FILTER_168, LS_FILTER::NFA_LS_FILTER_169, LS_FILTER::NFA_LS_FILTER_170, LS_FILTER::NFA_LS_FILTER_171, LS_FILTER::NFA_LS_FILTER_172, LS_FILTER::NFA_LS_FILTER_173, LS_FILTER::NFA_LS_FILTER_174, LS_FILTER::NFA_LS_FILTER_175, LS_FILTER::NFA_LS_FILTER_176, LS_FILTER::NFA_LS_FILTER_177, LS_FILTER::NFA_LS_FILTER_178, LS_FILTER::NFA_LS_FILTER_179, LS_FILTER::NFA_LS_FILTER_180, LS_FILTER::NFA_LS_FILTER_181, LS_FILTER::NFA_LS_FILTER_182, LS_FILTER::NFA_LS_FILTER_183, LS_FILTER::NFA_LS_FILTER_184, LS_FILTER::NFA_LS_FILTER_185, LS_FILTER::NFA_LS_FILTER_186, LS_FILTER::NFA_LS_FILTER_187, LS_FILTER::NFA_LS_FILTER_188, LS_FILTER::NFA_LS_FILTER_189, LS_FILTER::NFA_LS_FILTER_190, LS_FILTER::NFA_LS_FILTER_191, LS_FILTER::NFA_LS_FILTER_192, LS_FILTER::NFA_LS_FILTER_193, LS_FILTER::NFA_LS_FILTER_194, LS_FILTER::NFA_LS_FILTER_195, LS_FILTER::NFA_LS_FILTER_196, LS_FILTER::NFA_LS_FILTER_197, LS_FILTER::NFA_LS_FILTER_198, LS_FILTER::NFA_LS_FILTER_199, LS_FILTER::NFA_LS_FILTER_200, LS_FILTER::NFA_LS_FILTER_201, LS_FILTER::NFA_LS_FILTER_202, LS_FILTER::NFA_LS_FILTER_203, LS_FILTER::NFA_LS_FILTER_204, LS_FILTER::NFA_LS_FILTER_205, LS_FILTER::NFA_LS_FILTER_206, LS_FILTER::NFA_LS_FILTER_207, LS_FILTER::NFA_LS_FILTER_208, LS_FILTER::NFA_LS_FILTER_209, LS_FILTER::NFA_LS_FILTER_210, LS_FILTER::NFA_LS_FILTER_211, LS_FILTER::NFA_LS_FILTER_212, LS_FILTER::NFA_LS_FILTER_213, LS_FILTER::NFA_LS_FILTER_214, LS_FILTER::NFA_LS_FILTER_215, LS_FILTER::NFA_LS_FILTER_216, LS_FILTER::NFA_LS_FILTER_217, LS_FILTER::NFA_LS_FILTER_218, LS_FILTER::NFA_LS_FILTER_219, LS_FILTER::NFA_LS_FILTER_220, LS_FILTER::NFA_LS_FILTER_221, LS_FILTER::NFA_LS_FILTER_222, LS_FILTER::NFA_LS_FILTER_223, LS_FILTER::NFA_LS_FILTER_224, LS_FILTER::NFA_LS_FILTER_225, LS_FILTER::NFA_LS_FILTER_226, LS_FILTER::NFA_LS_FILTER_227, LS_FILTER::NFA_LS_FILTER_228, LS_FILTER::NFA_LS_FILTER_229, LS_FILTER::NFA_LS_FILTER_230, LS_FILTER::NFA_LS_FILTER_231, LS_FILTER::NFA_LS_FILTER_232, LS_FILTER::NFA_LS_FILTER_233, LS_FILTER::NFA_LS_FILTER_234, LS_FILTER::NFA_LS_FILTER_235, LS_FILTER::NFA_LS_FILTER_236, LS_FILTER::NFA_LS_FILTER_237, LS_FILTER::NFA_LS_FILTER_238, LS_FILTER::NFA_LS_FILTER_239, LS_FILTER::NFA_LS_FILTER_240, LS_FILTER::NFA_LS_FILTER_241, LS_FILTER::NFA_LS_FILTER_242, LS_FILTER::NFA_LS_FILTER_243, LS_FILTER::NFA_LS_FILTER_244, LS_FILTER::NFA_LS_FILTER_245, LS_FILTER::NFA_LS_FILTER_246, LS_FILTER::NFA_LS_FILTER_247, LS_FILTER::NFA_LS_FILTER_248, LS_FILTER::NFA_LS_FILTER_249, LS_FILTER::NFA_LS_FILTER_250, LS_FILTER::NFA_LS_FILTER_251, LS_FILTER::NFA_LS_FILTER_252, LS_FILTER::NFA_LS_FILTER_253, LS_FILTER::NFA_LS_FILTER_254, LS_FILTER::NFA_LS_FILTER_255, LS_FILTER::NFA_LS_FILTER_256, LS_FILTER::NFA_LS_FILTER_257, LS_FILTER::NFA_LS_FILTER_258, LS_FILTER::NFA_LS_FILTER_259, LS_FILTER::NFA_LS_FILTER_260, LS_FILTER::NFA_LS_FILTER_261, LS_FILTER::NFA_LS_FILTER_262, LS_FILTER::NFA_LS_FILTER_263, LS_FILTER::NFA_LS_FILTER_264, LS_FILTER::NFA_LS_FILTER_265, LS_FILTER::NFA_LS_FILTER_266, LS_FILTER::NFA_LS_FILTER_267, LS_FILTER::NFA_LS_FILTER_268, LS_FILTER::NFA_LS_FILTER_269, LS_FILTER::NFA_LS_FILTER_270, LS_FILTER::NFA_LS_FILTER_271, LS_FILTER::NFA_LS_FILTER_272, LS_FILTER::NFA_LS_FILTER_273, LS_FILTER::NFA_LS_FILTER_274, LS_FILTER::NFA_LS_FILTER_275, LS_FILTER::NFA_LS_FILTER_276, LS_FILTER::NFA_LS_FILTER_277, LS_FILTER::NFA_LS_FILTER_278, LS_FILTER::NFA_LS_FILTER_279, LS_FILTER::NFA_LS_FILTER_280, LS_FILTER::NFA_LS_FILTER_281, LS_FILTER::NFA_LS_FILTER_282, LS_FILTER::NFA_LS_FILTER_283, LS_FILTER::NFA_LS_FILTER_284, LS_FILTER::NFA_LS_FILTER_285, LS_FILTER::NFA_LS_FILTER_286, LS_FILTER::NFA_LS_FILTER_287, LS_FILTER::NFA_LS_FILTER_288, LS_FILTER::NFA_LS_FILTER_289, LS_FILTER::NFA_LS_FILTER_290, LS_FILTER::NFA_LS_FILTER_291, LS_FILTER::NFA_LS_FILTER_292, LS_FILTER::NFA_LS_FILTER_293, LS_FILTER::NFA_LS_FILTER_294, LS_FILTER::NFA_LS_FILTER_295, LS_FILTER::NFA_LS_FILTER_296, LS_FILTER::NFA_LS_FILTER_297, LS_FILTER::NFA_LS_FILTER_298, LS_FILTER::NFA_LS_FILTER_299, LS_FILTER::NFA_LS_FILTER_300, LS_FILTER::NFA_LS_FILTER_301, LS_FILTER::NFA_LS_FILTER_302, LS_FILTER::NFA_LS_FILTER_303, LS_FILTER::NFA_LS_FILTER_304, LS_FILTER::NFA_LS_FILTER_305, LS_FILTER::NFA_LS_FILTER_306, LS_FILTER::NFA_LS_FILTER_307, LS_FILTER::NFA_LS_FILTER_308, LS_FILTER::NFA_LS_FILTER_309, LS_FILTER::NFA_LS_FILTER_310, LS_FILTER::NFA_LS_FILTER_311, LS_FILTER::NFA_LS_FILTER_312, LS_FILTER::NFA_LS_FILTER_313, LS_FILTER::NFA_LS_FILTER_314, LS_FILTER::NFA_LS_FILTER_315, LS_FILTER::NFA_LS_FILTER_316, LS_FILTER::NFA_LS_FILTER_317, LS_FILTER::NFA_LS_FILTER_318, LS_FILTER::NFA_LS_FILTER_319, LS_FILTER::NFA_LS_FILTER_320, LS_FILTER::NFA_LS_FILTER_321, LS_FILTER::NFA_LS_FILTER_322, LS_FILTER::NFA_LS_FILTER_323, LS_FILTER::NFA_LS_FILTER_324, LS_FILTER::NFA_LS_FILTER_325, LS_FILTER::NFA_LS_FILTER_326, LS_FILTER::NFA_LS_FILTER_327, LS_FILTER::NFA_LS_FILTER_328, LS_FILTER::NFA_LS_FILTER_329, LS_FILTER::NFA_LS_FILTER_330, LS_FILTER::NFA_LS_FILTER_331, LS_FILTER::NFA_LS_FILTER_332, LS_FILTER::NFA_LS_FILTER_333, LS_FILTER::NFA_LS_FILTER_334, LS_FILTER::NFA_LS_FILTER_335, LS_FILTER::NFA_LS_FILTER_336, LS_FILTER::NFA_LS_FILTER_337, LS_FILTER::NFA_LS_FILTER_338, LS_FILTER::NFA_LS_FILTER_339, LS_FILTER::NFA_LS_FILTER_340, LS_FILTER::NFA_LS_FILTER_341, LS_FILTER::NFA_LS_FILTER_342, LS_FILTER::NFA_LS_FILTER_343, LS_FILTER::NFA_LS_FILTER_344, LS_FILTER::NFA_LS_FILTER_345, LS_FILTER::NFA_LS_FILTER_346, LS_FILTER::NFA_LS_FILTER_347, LS_FILTER::NFA_LS_FILTER_348, LS_FILTER::NFA_LS_FILTER_349, LS_FILTER::NFA_LS_FILTER_350, LS_FILTER::NFA_LS_FILTER_351, LS_FILTER::NFA_LS_FILTER_352, LS_FILTER::NFA_LS_FILTER_353, LS_FILTER::NFA_LS_FILTER_354, LS_FILTER::NFA_LS_FILTER_355, LS_FILTER::NFA_LS_FILTER_356, LS_FILTER::NFA_LS_FILTER_357, LS_FILTER::NFA_LS_FILTER_358, LS_FILTER::NFA_LS_FILTER_359, LS_FILTER::NFA_LS_FILTER_360, LS_FILTER::NFA_LS_FILTER_361, LS_FILTER::NFA_LS_FILTER_362, LS_FILTER::NFA_LS_FILTER_363, LS_FILTER::NFA_LS_FILTER_364, LS_FILTER::NFA_LS_FILTER_365, LS_FILTER::NFA_LS_FILTER_366, LS_FILTER::NFA_LS_FILTER_367, LS_FILTER::NFA_LS_FILTER_368, LS_FILTER::NFA_LS_FILTER_369, LS_FILTER::NFA_LS_FILTER_370, LS_FILTER::NFA_LS_FILTER_371, LS_FILTER::NFA_LS_FILTER_372, LS_FILTER::NFA_LS_FILTER_373, LS_FILTER::NFA_LS_FILTER_374, LS_FILTER::NFA_LS_FILTER_375, LS_FILTER::NFA_LS_FILTER_376, LS_FILTER::NFA_LS_FILTER_377, LS_FILTER::NFA_LS_FILTER_378, LS_FILTER::NFA_LS_FILTER_379, LS_FILTER::NFA_LS_FILTER_380, LS_FILTER::NFA_LS_FILTER_381, LS_FILTER::NFA_LS_FILTER_382, LS_FILTER::NFA_LS_FILTER_383, LS_FILTER::NFA_LS_FILTER_384, LS_FILTER::NFA_LS_FILTER_385, LS_FILTER::NFA_LS_FILTER_386, LS_FILTER::NFA_LS_FILTER_387, LS_FILTER::NFA_LS_FILTER_388, LS_FILTER::NFA_LS_FILTER_389, LS_FILTER::NFA_LS_FILTER_390, LS_FILTER::NFA_LS_FILTER_391, LS_FILTER::NFA_LS_FILTER_392, LS_FILTER::NFA_LS_FILTER_393, LS_FILTER::NFA_LS_FILTER_394, LS_FILTER::NFA_LS_FILTER_395, LS_FILTER::NFA_LS_FILTER_396, LS_FILTER::NFA_LS_FILTER_397, LS_FILTER::NFA_LS_FILTER_398, LS_FILTER::NFA_LS_FILTER_399, LS_FILTER::NFA_LS_FILTER_400, LS_FILTER::NFA_LS_FILTER_401, LS_FILTER::NFA_LS_FILTER_402, LS_FILTER::NFA_LS_FILTER_403, LS_FILTER::NFA_LS_FILTER_404, LS_FILTER::NFA_LS_FILTER_405, LS_FILTER::NFA_LS_FILTER_406, LS_FILTER::NFA_LS_FILTER_407, LS_FILTER::NFA_LS_FILTER_408, LS_FILTER::NFA_LS_FILTER_409, LS_FILTER::NFA_LS_FILTER_410, LS_FILTER::NFA_LS_FILTER_411, LS_FILTER::NFA_LS_FILTER_412, LS_FILTER::NFA_LS_FILTER_413, LS_FILTER::NFA_LS_FILTER_414, LS_FILTER::NFA_LS_FILTER_415, LS_FILTER::NFA_LS_FILTER_416, LS_FILTER::NFA_LS_FILTER_417, LS_FILTER::NFA_LS_FILTER_418, LS_FILTER::NFA_LS_FILTER_419, LS_FILTER::NFA_LS_FILTER_420, LS_FILTER::NFA_LS_FILTER_421, LS_FILTER::NFA_LS_FILTER_422, LS_FILTER::NFA_LS_FILTER_423, LS_FILTER::NFA_LS_FILTER_424, LS_FILTER::NFA_LS_FILTER_425, LS_FILTER::NFA_LS_FILTER_426, LS_FILTER::NFA_LS_FILTER_427, LS_FILTER::NFA_LS_FILTER_428, LS_FILTER::NFA_LS_FILTER_429, LS_FILTER::NFA_LS_FILTER_430, LS_FILTER::NFA_LS_FILTER_431, LS_FILTER::NFA_LS_FILTER_432, LS_FILTER::NFA_LS_FILTER_433, LS_FILTER::NFA_LS_FILTER_434, LS_FILTER::NFA_LS_FILTER_435, LS_FILTER::NFA_LS_FILTER_436, LS_FILTER::NFA_LS_FILTER_437, LS_FILTER::NFA_LS_FILTER_438, LS_FILTER::NFA_LS_FILTER_439, LS_FILTER::NFA_LS_FILTER_440, LS_FILTER::NFA_LS_FILTER_441, LS_FILTER::NFA_LS_FILTER_442, LS_FILTER::NFA_LS_FILTER_443, LS_FILTER::NFA_LS_FILTER_444, LS_FILTER::NFA_LS_FILTER_445, LS_FILTER::NFA_LS_FILTER_446, LS_FILTER::NFA_LS_FILTER_447, LS_FILTER::NFA_LS_FILTER_448, LS_FILTER::NFA_LS_FILTER_449, LS_FILTER::NFA_LS_FILTER_450, LS_FILTER::NFA_LS_FILTER_451, LS_FILTER::NFA_LS_FILTER_452, LS_FILTER::NFA_LS_FILTER_453, LS_FILTER::NFA_LS_FILTER_454, LS_FILTER::NFA_LS_FILTER_455, LS_FILTER::NFA_LS_FILTER_456, LS_FILTER::NFA_LS_FILTER_457, LS_FILTER::NFA_LS_FILTER_458, LS_FILTER::NFA_LS_FILTER_459, LS_FILTER::NFA_LS_FILTER_460, LS_FILTER::NFA_LS_FILTER_461, LS_FILTER::NFA_LS_FILTER_462, LS_FILTER::NFA_LS_FILTER_463, LS_FILTER::NFA_LS_FILTER_464};
            functionTableMap.put(QConstants.LexicalState.LS_FILTER, functions);
        }
    }

    private static class LS_CONSTANTS {
        private LS_CONSTANTS() {
        }

        static QConstants.TokenType NFA_COMPOSITE_LS_CONSTANTS_0(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            QConstants.TokenType type = null;
            if (ch == 39) {
                nextStates.set(18);
            } else if (ch == 43 || ch == 45) {
                nextStates.set(55);
                nextStates.set(32);
                nextStates.set(354);
                nextStates.set(39);
                nextStates.set(152);
                nextStates.set(73);
            } else if (ch == 48) {
                nextStates.set(229);
            }
            if (ch >= 48 && ch <= 57) {
                nextStates.set(489);
                nextStates.set(476);
                nextStates.set(292);
            }
            if (ch == 49) {
                nextStates.set(264);
            }
            if (ch >= 49 && ch <= 57) {
                nextStates.set(289);
                nextStates.set(245);
                nextStates.set(445);
                nextStates.set(401);
                nextStates.set(339);
            }
            if (ch == 50) {
                nextStates.set(216);
            } else if (ch == 68 || ch == 100) {
                nextStates.set(226);
            } else if (ch == 70 || ch == 102) {
                nextStates.set(182);
            } else if (ch == 71 || ch == 103) {
                nextStates.set(270);
            } else if (ch == 78 || ch == 110) {
                nextStates.set(190);
            } else if (ch == 80 || ch == 112) {
                nextStates.set(133);
            } else if (ch == 84 || ch == 116) {
                nextStates.set(158);
            }
            if (ch >= 48 && ch <= 57) {
                nextStates.set(117);
                if (validTypes.contains((Object)QConstants.TokenType.T_DOUBLE)) {
                    type = QConstants.TokenType.T_DOUBLE;
                }
            } else if (ch == 41) {
                if (validTypes.contains((Object)QConstants.TokenType.T_RB)) {
                    type = QConstants.TokenType.T_RB;
                }
            } else if (ch == 40) {
                if (validTypes.contains((Object)QConstants.TokenType.T_LB)) {
                    type = QConstants.TokenType.T_LB;
                }
            } else if (ch == 44 && validTypes.contains((Object)QConstants.TokenType.T_VALUE_SEPARATOR)) {
                type = QConstants.TokenType.T_VALUE_SEPARATOR;
            }
            if (ch >= 48 && ch <= 57) {
                if (validTypes.contains((Object)QConstants.TokenType.T_LONG)) {
                    type = QConstants.TokenType.T_LONG;
                }
            } else if (ch == 9) {
                if (validTypes.contains((Object)QConstants.TokenType._TOKEN_4)) {
                    type = QConstants.TokenType._TOKEN_4;
                }
            } else if (ch == 13) {
                if (validTypes.contains((Object)QConstants.TokenType._TOKEN_3)) {
                    type = QConstants.TokenType._TOKEN_3;
                }
            } else if (ch == 10) {
                if (validTypes.contains((Object)QConstants.TokenType._TOKEN_2)) {
                    type = QConstants.TokenType._TOKEN_2;
                }
            } else if (ch == 32 && validTypes.contains((Object)QConstants.TokenType._TOKEN_1)) {
                type = QConstants.TokenType._TOKEN_1;
            }
            return type;
        }

        static QConstants.TokenType NFA_COMPOSITE_LS_CONSTANTS_1(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            QConstants.TokenType type = null;
            if (ch == 46) {
                nextStates.set(79);
            } else if (ch >= 48 && ch <= 57) {
                nextStates.set(1);
            } else if (ch == 83 || ch == 115) {
                nextStates.set(353);
            }
            return type;
        }

        static QConstants.TokenType NFA_COMPOSITE_LS_CONSTANTS_2(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            QConstants.TokenType type = null;
            if (ch >= 48 && ch <= 57) {
                nextStates.set(2);
            } else if (ch == 87 || ch == 119) {
                nextStates.set(88);
            }
            return type;
        }

        static QConstants.TokenType NFA_COMPOSITE_LS_CONSTANTS_3(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            QConstants.TokenType type = null;
            if (ch >= 48 && ch <= 57) {
                nextStates.set(3);
            } else if (ch == 68 || ch == 100) {
                nextStates.set(499);
                if (validTypes.contains((Object)QConstants.TokenType.T_DATETIMEINTERVAL)) {
                    type = QConstants.TokenType.T_DATETIMEINTERVAL;
                }
            }
            return type;
        }

        static QConstants.TokenType NFA_COMPOSITE_LS_CONSTANTS_4(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            QConstants.TokenType type = null;
            if (ch == 43 || ch == 45) {
                nextStates.set(140);
                nextStates.set(108);
                nextStates.set(35);
            } else if (ch == 47) {
                nextStates.set(17);
            } else if (ch >= 48 && ch <= 57) {
                nextStates.set(393);
                nextStates.set(277);
                nextStates.set(350);
            }
            if (ch >= 49 && ch <= 57) {
                nextStates.set(396);
                nextStates.set(425);
                nextStates.set(436);
            } else if (ch == 84 || ch == 116) {
                nextStates.set(37);
            }
            return type;
        }

        static QConstants.TokenType NFA_COMPOSITE_LS_CONSTANTS_5(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            QConstants.TokenType type = null;
            if (ch == 43 || ch == 45) {
                nextStates.set(132);
            } else if (ch == 44) {
                nextStates.set(322);
            } else if (ch == 46) {
                nextStates.set(322);
            } else if ((ch == 90 || ch == 122) && validTypes.contains((Object)QConstants.TokenType.T_DATETIMEINTERVAL)) {
                type = QConstants.TokenType.T_DATETIMEINTERVAL;
            }
            return type;
        }

        static QConstants.TokenType NFA_COMPOSITE_LS_CONSTANTS_6(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            QConstants.TokenType type = null;
            if (ch == 48) {
                nextStates.set(239);
            } else if (ch == 49) {
                nextStates.set(221);
            }
            return type;
        }

        static QConstants.TokenType NFA_COMPOSITE_LS_CONSTANTS_7(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            QConstants.TokenType type = null;
            if (ch == 43 || ch == 45) {
                nextStates.set(96);
            } else if (ch == 58) {
                nextStates.set(236);
            } else if ((ch == 90 || ch == 122) && validTypes.contains((Object)QConstants.TokenType.T_DATETIME)) {
                type = QConstants.TokenType.T_DATETIME;
            }
            return type;
        }

        static QConstants.TokenType NFA_COMPOSITE_LS_CONSTANTS_8(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            QConstants.TokenType type = null;
            if (ch == 48) {
                nextStates.set(175);
            } else if (ch == 49) {
                nextStates.set(203);
            } else if (ch == 50) {
                nextStates.set(210);
            }
            return type;
        }

        static QConstants.TokenType NFA_COMPOSITE_LS_CONSTANTS_9(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            QConstants.TokenType type = null;
            if (ch == 43 || ch == 45) {
                nextStates.set(137);
                nextStates.set(92);
            } else if (ch == 47) {
                nextStates.set(17);
            } else if (ch >= 48 && ch <= 57) {
                nextStates.set(85);
                nextStates.set(323);
            }
            if (ch >= 49 && ch <= 57) {
                nextStates.set(303);
                nextStates.set(382);
            }
            return type;
        }

        static QConstants.TokenType NFA_COMPOSITE_LS_CONSTANTS_10(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            QConstants.TokenType type = null;
            if (ch == 48) {
                nextStates.set(189);
            } else if (ch == 49) {
                nextStates.set(178);
            } else if (ch == 50) {
                nextStates.set(208);
            }
            return type;
        }

        static QConstants.TokenType NFA_COMPOSITE_LS_CONSTANTS_11(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            QConstants.TokenType type = null;
            if (ch == 43 || ch == 45) {
                nextStates.set(32);
            } else if (ch >= 48 && ch <= 57) {
                nextStates.set(476);
            }
            if (ch >= 49 && ch <= 57) {
                nextStates.set(401);
            }
            return type;
        }

        static QConstants.TokenType NFA_COMPOSITE_LS_CONSTANTS_12(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            QConstants.TokenType type = null;
            if (ch >= 48 && ch <= 50) {
                nextStates.set(242);
            } else if (ch == 51) {
                nextStates.set(186);
            }
            return type;
        }

        static QConstants.TokenType NFA_COMPOSITE_LS_CONSTANTS_13(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            QConstants.TokenType type = null;
            if (ch >= 48 && ch <= 57) {
                nextStates.set(13);
            } else if (ch == 89 || ch == 121) {
                nextStates.set(110);
            }
            return type;
        }

        static QConstants.TokenType NFA_COMPOSITE_LS_CONSTANTS_14(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            QConstants.TokenType type = null;
            if (ch >= 48 && ch <= 57) {
                nextStates.set(14);
            } else if (ch == 77 || ch == 109) {
                nextStates.set(19);
            }
            return type;
        }

        static QConstants.TokenType NFA_COMPOSITE_LS_CONSTANTS_15(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            QConstants.TokenType type = null;
            if (ch == 43 || ch == 45) {
                nextStates.set(55);
            } else if (ch >= 49 && ch <= 57) {
                nextStates.set(339);
            }
            if (ch >= 48 && ch <= 57) {
                nextStates.set(117);
                if (validTypes.contains((Object)QConstants.TokenType.T_DOUBLE)) {
                    type = QConstants.TokenType.T_DOUBLE;
                }
            }
            return type;
        }

        static QConstants.TokenType NFA_COMPOSITE_LS_CONSTANTS_16(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            QConstants.TokenType type = null;
            if (ch >= 48 && ch <= 57) {
                nextStates.set(16);
            } else if (ch == 77 || ch == 109) {
                nextStates.set(136);
            }
            return type;
        }

        static QConstants.TokenType NFA_COMPOSITE_LS_CONSTANTS_17(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            QConstants.TokenType type = null;
            if (ch == 43 || ch == 45) {
                nextStates.set(327);
                nextStates.set(56);
            } else if (ch >= 48 && ch <= 57) {
                nextStates.set(324);
            }
            if (ch >= 49 && ch <= 57) {
                nextStates.set(477);
            } else if (ch == 80 || ch == 112) {
                nextStates.set(45);
                if (validTypes.contains((Object)QConstants.TokenType.T_DATETIMEINTERVAL)) {
                    type = QConstants.TokenType.T_DATETIMEINTERVAL;
                }
            }
            return type;
        }

        static QConstants.TokenType NFA_COMPOSITE_LS_CONSTANTS_18(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            QConstants.TokenType type = null;
            if (ch >= 0 && ch <= 38 || ch >= 40) {
                nextStates.set(18);
            } else if (ch == 39) {
                nextStates.set(257);
                if (validTypes.contains((Object)QConstants.TokenType.T_STR_LIT)) {
                    type = QConstants.TokenType.T_STR_LIT;
                }
            }
            return type;
        }

        static QConstants.TokenType NFA_COMPOSITE_LS_CONSTANTS_19(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            QConstants.TokenType type = null;
            if (ch == 43 || ch == 45) {
                nextStates.set(64);
                nextStates.set(113);
            } else if (ch >= 48 && ch <= 57) {
                nextStates.set(402);
                nextStates.set(291);
            }
            if (ch >= 49 && ch <= 57) {
                nextStates.set(316);
                nextStates.set(335);
            } else if (ch == 84 || ch == 116) {
                nextStates.set(119);
            } else if (ch == 39 && validTypes.contains((Object)QConstants.TokenType.T_DURATION)) {
                type = QConstants.TokenType.T_DURATION;
            }
            return type;
        }

        static QConstants.TokenType NFA_COMPOSITE_LS_CONSTANTS_20(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            QConstants.TokenType type = null;
            if (ch >= 48 && ch <= 57) {
                nextStates.set(344);
            }
            if (ch >= 49 && ch <= 57) {
                nextStates.set(430);
            }
            return type;
        }

        static QConstants.TokenType NFA_COMPOSITE_LS_CONSTANTS_21(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            QConstants.TokenType type = null;
            if (ch == 45) {
                nextStates.set(6);
            } else if (ch >= 48 && ch <= 57) {
                nextStates.set(21);
            }
            return type;
        }

        static QConstants.TokenType NFA_COMPOSITE_LS_CONSTANTS_22(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            QConstants.TokenType type = null;
            if (ch == 43 || ch == 45) {
                nextStates.set(47);
            } else if (ch >= 48 && ch <= 57) {
                nextStates.set(385);
            }
            if (ch >= 49 && ch <= 57) {
                nextStates.set(356);
            }
            return type;
        }

        static QConstants.TokenType NFA_COMPOSITE_LS_CONSTANTS_23(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            QConstants.TokenType type = null;
            if (ch >= 48 && ch <= 57) {
                nextStates.set(392);
            }
            if (ch >= 49 && ch <= 57) {
                nextStates.set(346);
            }
            return type;
        }

        static QConstants.TokenType NFA_COMPOSITE_LS_CONSTANTS_24(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            QConstants.TokenType type = null;
            if (ch >= 48 && ch <= 57) {
                nextStates.set(24);
            } else if (ch == 83 || ch == 115) {
                nextStates.set(358);
            }
            return type;
        }

        static QConstants.TokenType NFA_COMPOSITE_LS_CONSTANTS_25(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            QConstants.TokenType type = null;
            if (ch == 43 || ch == 45) {
                nextStates.set(20);
            } else if (ch >= 48 && ch <= 57) {
                nextStates.set(344);
            }
            if (ch >= 49 && ch <= 57) {
                nextStates.set(430);
            }
            return type;
        }

        static QConstants.TokenType NFA_COMPOSITE_LS_CONSTANTS_26(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            QConstants.TokenType type = null;
            if (ch == 46) {
                nextStates.set(299);
            } else if (ch == 69 || ch == 101) {
                nextStates.set(118);
            } else if (ch >= 48 && ch <= 57) {
                nextStates.set(26);
                if (validTypes.contains((Object)QConstants.TokenType.T_DOUBLE)) {
                    type = QConstants.TokenType.T_DOUBLE;
                }
            }
            return type;
        }

        static QConstants.TokenType NFA_COMPOSITE_LS_CONSTANTS_27(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            QConstants.TokenType type = null;
            if (ch == 44) {
                nextStates.set(322);
            } else if (ch == 46) {
                nextStates.set(322);
            }
            return type;
        }

        static QConstants.TokenType NFA_COMPOSITE_LS_CONSTANTS_28(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            QConstants.TokenType type = null;
            if (ch == 43 || ch == 45) {
                nextStates.set(10);
            } else if (ch >= 48 && ch <= 57) {
                nextStates.set(28);
            } else if (ch == 90 || ch == 122) {
                nextStates.set(358);
            }
            return type;
        }

        static QConstants.TokenType NFA_COMPOSITE_LS_CONSTANTS_29(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            QConstants.TokenType type = null;
            if (ch == 43 || ch == 45) {
                nextStates.set(115);
            } else if (ch >= 48 && ch <= 57) {
                nextStates.set(67);
            }
            if (ch >= 49 && ch <= 57) {
                nextStates.set(467);
            }
            return type;
        }

        static QConstants.TokenType NFA_COMPOSITE_LS_CONSTANTS_30(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            QConstants.TokenType type = null;
            if (ch == 48) {
                nextStates.set(249);
            } else if (ch == 49) {
                nextStates.set(234);
            }
            return type;
        }

        static QConstants.TokenType NFA_COMPOSITE_LS_CONSTANTS_31(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            QConstants.TokenType type = null;
            if (ch >= 0 && ch <= 38 || ch >= 40) {
                nextStates.set(31);
            } else if (ch == 39 && validTypes.contains((Object)QConstants.TokenType.T_GEO_STR_LIT)) {
                type = QConstants.TokenType.T_GEO_STR_LIT;
            }
            return type;
        }

        static QConstants.TokenType NFA_COMPOSITE_LS_CONSTANTS_32(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            QConstants.TokenType type = null;
            if (ch >= 48 && ch <= 57) {
                nextStates.set(476);
            }
            if (ch >= 49 && ch <= 57) {
                nextStates.set(401);
            }
            return type;
        }

        static QConstants.TokenType NFA_COMPOSITE_LS_CONSTANTS_33(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            QConstants.TokenType type = null;
            if (ch == 43 || ch == 45) {
                nextStates.set(35);
            } else if (ch >= 48 && ch <= 57) {
                nextStates.set(277);
            }
            if (ch >= 49 && ch <= 57) {
                nextStates.set(436);
            }
            return type;
        }

        static QConstants.TokenType NFA_COMPOSITE_LS_CONSTANTS_34(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            QConstants.TokenType type = null;
            if (ch >= 48 && ch <= 57) {
                nextStates.set(435);
            }
            if (ch >= 49 && ch <= 57) {
                nextStates.set(321);
            }
            return type;
        }

        static QConstants.TokenType NFA_COMPOSITE_LS_CONSTANTS_35(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            QConstants.TokenType type = null;
            if (ch >= 48 && ch <= 57) {
                nextStates.set(277);
            }
            if (ch >= 49 && ch <= 57) {
                nextStates.set(436);
            }
            return type;
        }

        static QConstants.TokenType NFA_COMPOSITE_LS_CONSTANTS_36(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            QConstants.TokenType type = null;
            if (ch == 43 || ch == 45) {
                nextStates.set(10);
            } else if (ch == 58) {
                nextStates.set(162);
            } else if (ch == 90 || ch == 122) {
                nextStates.set(358);
            }
            return type;
        }

        static QConstants.TokenType NFA_COMPOSITE_LS_CONSTANTS_37(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            QConstants.TokenType type = null;
            if (ch == 43 || ch == 45) {
                nextStates.set(149);
                nextStates.set(137);
                nextStates.set(92);
            } else if (ch == 47) {
                nextStates.set(17);
            } else if (ch >= 48 && ch <= 57) {
                nextStates.set(454);
                nextStates.set(85);
                nextStates.set(323);
            }
            if (ch >= 49 && ch <= 57) {
                nextStates.set(439);
                nextStates.set(303);
                nextStates.set(382);
            }
            return type;
        }

        static QConstants.TokenType NFA_COMPOSITE_LS_CONSTANTS_38(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            QConstants.TokenType type = null;
            if (ch == 48) {
                nextStates.set(266);
            } else if (ch == 49) {
                nextStates.set(224);
            } else if (ch == 50) {
                nextStates.set(206);
            }
            return type;
        }

        static QConstants.TokenType NFA_COMPOSITE_LS_CONSTANTS_39(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            QConstants.TokenType type = null;
            if (ch >= 48 && ch <= 57) {
                nextStates.set(489);
            }
            if (ch >= 49 && ch <= 57) {
                nextStates.set(289);
            }
            return type;
        }

        static QConstants.TokenType NFA_COMPOSITE_LS_CONSTANTS_40(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            QConstants.TokenType type = null;
            if (ch == 43 || ch == 45) {
                nextStates.set(39);
            } else if (ch >= 48 && ch <= 57) {
                nextStates.set(489);
            }
            if (ch >= 49 && ch <= 57) {
                nextStates.set(289);
            }
            return type;
        }

        static QConstants.TokenType NFA_COMPOSITE_LS_CONSTANTS_41(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            QConstants.TokenType type = null;
            if (ch == 43 || ch == 45) {
                nextStates.set(47);
                nextStates.set(113);
                nextStates.set(64);
                nextStates.set(127);
            } else if (ch >= 48 && ch <= 57) {
                nextStates.set(337);
                nextStates.set(385);
                nextStates.set(402);
                nextStates.set(291);
            }
            if (ch >= 49 && ch <= 57) {
                nextStates.set(316);
                nextStates.set(335);
                nextStates.set(422);
                nextStates.set(356);
            } else if (ch == 84 || ch == 116) {
                nextStates.set(119);
            } else if (ch == 39 && validTypes.contains((Object)QConstants.TokenType.T_DURATION)) {
                type = QConstants.TokenType.T_DURATION;
            }
            return type;
        }

        static QConstants.TokenType NFA_COMPOSITE_LS_CONSTANTS_42(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            QConstants.TokenType type = null;
            if (ch == 43 || ch == 45) {
                nextStates.set(354);
            } else if (ch == 80 || ch == 112) {
                nextStates.set(133);
            }
            return type;
        }

        static QConstants.TokenType NFA_COMPOSITE_LS_CONSTANTS_43(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            QConstants.TokenType type = null;
            if (ch == 43 || ch == 45) {
                nextStates.set(39);
                nextStates.set(354);
            } else if (ch >= 48 && ch <= 57) {
                nextStates.set(489);
            }
            if (ch >= 49 && ch <= 57) {
                nextStates.set(289);
            } else if (ch == 80 || ch == 112) {
                nextStates.set(133);
            }
            return type;
        }

        static QConstants.TokenType NFA_COMPOSITE_LS_CONSTANTS_44(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            QConstants.TokenType type = null;
            if (ch == 43 || ch == 45) {
                nextStates.set(10);
            } else if (ch == 90 || ch == 122) {
                nextStates.set(358);
            }
            return type;
        }

        static QConstants.TokenType NFA_COMPOSITE_LS_CONSTANTS_45(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            QConstants.TokenType type = null;
            if (ch == 43 || ch == 45) {
                nextStates.set(34);
                nextStates.set(20);
                nextStates.set(51);
                nextStates.set(101);
            } else if (ch >= 48 && ch <= 57) {
                nextStates.set(344);
                nextStates.set(286);
                nextStates.set(345);
                nextStates.set(435);
            }
            if (ch >= 49 && ch <= 57) {
                nextStates.set(430);
                nextStates.set(340);
                nextStates.set(321);
                nextStates.set(423);
            } else if (ch == 84 || ch == 116) {
                nextStates.set(95);
                if (validTypes.contains((Object)QConstants.TokenType.T_DATETIMEINTERVAL)) {
                    type = QConstants.TokenType.T_DATETIMEINTERVAL;
                }
            }
            return type;
        }

        static QConstants.TokenType NFA_COMPOSITE_LS_CONSTANTS_46(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            QConstants.TokenType type = null;
            if (ch == 43 || ch == 45) {
                nextStates.set(140);
            } else if (ch >= 48 && ch <= 57) {
                nextStates.set(350);
            }
            if (ch >= 49 && ch <= 57) {
                nextStates.set(425);
            }
            return type;
        }

        static QConstants.TokenType NFA_COMPOSITE_LS_CONSTANTS_47(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            QConstants.TokenType type = null;
            if (ch >= 48 && ch <= 57) {
                nextStates.set(385);
            }
            if (ch >= 49 && ch <= 57) {
                nextStates.set(356);
            }
            return type;
        }

        static QConstants.TokenType NFA_COMPOSITE_LS_CONSTANTS_48(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            QConstants.TokenType type = null;
            if (ch == 43 || ch == 45) {
                nextStates.set(149);
            } else if (ch >= 48 && ch <= 57) {
                nextStates.set(454);
            }
            if (ch >= 49 && ch <= 57) {
                nextStates.set(439);
            }
            return type;
        }

        static QConstants.TokenType NFA_COMPOSITE_LS_CONSTANTS_49(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            QConstants.TokenType type = null;
            if (ch == 43 || ch == 45) {
                nextStates.set(126);
            } else if (ch >= 48 && ch <= 57) {
                nextStates.set(318);
            }
            if (ch >= 49 && ch <= 57) {
                nextStates.set(434);
            }
            return type;
        }

        static QConstants.TokenType NFA_COMPOSITE_LS_CONSTANTS_50(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            QConstants.TokenType type = null;
            if (ch == 43 || ch == 45) {
                nextStates.set(34);
            } else if (ch >= 48 && ch <= 57) {
                nextStates.set(435);
            }
            if (ch >= 49 && ch <= 57) {
                nextStates.set(321);
            }
            return type;
        }

        static QConstants.TokenType NFA_COMPOSITE_LS_CONSTANTS_51(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            QConstants.TokenType type = null;
            if (ch >= 48 && ch <= 57) {
                nextStates.set(286);
            }
            if (ch >= 49 && ch <= 57) {
                nextStates.set(423);
            }
            return type;
        }

        static QConstants.TokenType NFA_COMPOSITE_LS_CONSTANTS_52(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            QConstants.TokenType type = null;
            if (ch == 43 || ch == 45) {
                nextStates.set(74);
            } else if (ch >= 48 && ch <= 57) {
                nextStates.set(427);
            }
            if (ch >= 49 && ch <= 57) {
                nextStates.set(498);
            }
            return type;
        }

        static QConstants.TokenType NFA_COMPOSITE_LS_CONSTANTS_53(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            QConstants.TokenType type = null;
            if (ch == 43 || ch == 45) {
                nextStates.set(93);
            } else if (ch >= 48 && ch <= 57) {
                nextStates.set(466);
            }
            if (ch >= 49 && ch <= 57) {
                nextStates.set(440);
            }
            return type;
        }

        static QConstants.TokenType NFA_COMPOSITE_LS_CONSTANTS_54(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            QConstants.TokenType type = null;
            if (ch >= 48 && ch <= 57) {
                nextStates.set(54);
            } else if (ch == 89 || ch == 121) {
                nextStates.set(128);
                if (validTypes.contains((Object)QConstants.TokenType.T_DATETIMEINTERVAL)) {
                    type = QConstants.TokenType.T_DATETIMEINTERVAL;
                }
            }
            return type;
        }

        static QConstants.TokenType NFA_COMPOSITE_LS_CONSTANTS_55(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            QConstants.TokenType type = null;
            if (ch >= 49 && ch <= 57) {
                nextStates.set(339);
            }
            if (ch >= 48 && ch <= 57) {
                nextStates.set(117);
                if (validTypes.contains((Object)QConstants.TokenType.T_DOUBLE)) {
                    type = QConstants.TokenType.T_DOUBLE;
                }
            }
            return type;
        }

        static QConstants.TokenType NFA_COMPOSITE_LS_CONSTANTS_56(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            QConstants.TokenType type = null;
            if (ch >= 48 && ch <= 57) {
                nextStates.set(324);
            }
            if (ch >= 49 && ch <= 57) {
                nextStates.set(477);
            }
            return type;
        }

        static QConstants.TokenType NFA_COMPOSITE_LS_CONSTANTS_57(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            QConstants.TokenType type = null;
            if (ch == 43 || ch == 45) {
                nextStates.set(10);
            } else if (ch == 44) {
                nextStates.set(442);
            } else if (ch == 46) {
                nextStates.set(442);
            } else if (ch == 90 || ch == 122) {
                nextStates.set(358);
            }
            return type;
        }

        static QConstants.TokenType NFA_COMPOSITE_LS_CONSTANTS_58(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            QConstants.TokenType type = null;
            if (ch >= 48 && ch <= 57) {
                nextStates.set(463);
            }
            if (ch >= 49 && ch <= 57) {
                nextStates.set(451);
            }
            return type;
        }

        static QConstants.TokenType NFA_COMPOSITE_LS_CONSTANTS_59(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            QConstants.TokenType type = null;
            if (ch == 43 || ch == 45) {
                nextStates.set(56);
            } else if (ch >= 48 && ch <= 57) {
                nextStates.set(324);
            }
            if (ch >= 49 && ch <= 57) {
                nextStates.set(477);
            }
            return type;
        }

        static QConstants.TokenType NFA_COMPOSITE_LS_CONSTANTS_60(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            QConstants.TokenType type = null;
            if (ch >= 48 && ch <= 57) {
                nextStates.set(60);
            } else if (ch == 77 || ch == 109) {
                nextStates.set(146);
                if (validTypes.contains((Object)QConstants.TokenType.T_DATETIMEINTERVAL)) {
                    type = QConstants.TokenType.T_DATETIMEINTERVAL;
                }
            }
            return type;
        }

        static QConstants.TokenType NFA_COMPOSITE_LS_CONSTANTS_61(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            QConstants.TokenType type = null;
            if (ch >= 48 && ch <= 57) {
                nextStates.set(61);
            } else if (ch == 83 || ch == 115) {
                nextStates.set(353);
            }
            return type;
        }

        static QConstants.TokenType NFA_COMPOSITE_LS_CONSTANTS_62(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            QConstants.TokenType type = null;
            if (ch >= 48 && ch <= 57) {
                nextStates.set(62);
            } else if (ch == 89 || ch == 121) {
                nextStates.set(4);
            }
            return type;
        }

        static QConstants.TokenType NFA_COMPOSITE_LS_CONSTANTS_63(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            QConstants.TokenType type = null;
            if (ch == 84 || ch == 116) {
                nextStates.set(119);
            } else if (ch == 39 && validTypes.contains((Object)QConstants.TokenType.T_DURATION)) {
                type = QConstants.TokenType.T_DURATION;
            }
            return type;
        }

        static QConstants.TokenType NFA_COMPOSITE_LS_CONSTANTS_64(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            QConstants.TokenType type = null;
            if (ch >= 48 && ch <= 57) {
                nextStates.set(291);
            }
            if (ch >= 49 && ch <= 57) {
                nextStates.set(335);
            }
            return type;
        }

        static QConstants.TokenType NFA_COMPOSITE_LS_CONSTANTS_65(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            QConstants.TokenType type = null;
            if (ch == 43 || ch == 45) {
                nextStates.set(92);
            } else if (ch >= 48 && ch <= 57) {
                nextStates.set(323);
            }
            if (ch >= 49 && ch <= 57) {
                nextStates.set(303);
            }
            return type;
        }

        static QConstants.TokenType NFA_COMPOSITE_LS_CONSTANTS_66(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            QConstants.TokenType type = null;
            if (ch == 48) {
                nextStates.set(225);
            } else if (ch == 49) {
                nextStates.set(204);
            } else if (ch == 50) {
                nextStates.set(217);
            }
            return type;
        }

        static QConstants.TokenType NFA_COMPOSITE_LS_CONSTANTS_67(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            QConstants.TokenType type = null;
            if (ch == 46) {
                nextStates.set(79);
            } else if (ch == 83 || ch == 115) {
                nextStates.set(353);
            }
            return type;
        }

        static QConstants.TokenType NFA_COMPOSITE_LS_CONSTANTS_68(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            QConstants.TokenType type = null;
            if (ch == 46) {
                nextStates.set(138);
            } else if (ch >= 48 && ch <= 57) {
                nextStates.set(68);
            } else if ((ch == 83 || ch == 115) && validTypes.contains((Object)QConstants.TokenType.T_DATETIMEINTERVAL)) {
                type = QConstants.TokenType.T_DATETIMEINTERVAL;
            }
            return type;
        }

        static QConstants.TokenType NFA_COMPOSITE_LS_CONSTANTS_69(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            QConstants.TokenType type = null;
            if (ch == 43 || ch == 45) {
                nextStates.set(327);
            } else if (ch == 80 || ch == 112) {
                nextStates.set(45);
                if (validTypes.contains((Object)QConstants.TokenType.T_DATETIMEINTERVAL)) {
                    type = QConstants.TokenType.T_DATETIMEINTERVAL;
                }
            }
            return type;
        }

        static QConstants.TokenType NFA_COMPOSITE_LS_CONSTANTS_70(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            QConstants.TokenType type = null;
            if (ch >= 48 && ch <= 57) {
                nextStates.set(70);
            } else if (ch == 77 || ch == 109) {
                nextStates.set(112);
            }
            return type;
        }

        static QConstants.TokenType NFA_COMPOSITE_LS_CONSTANTS_71(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            QConstants.TokenType type = null;
            if (ch == 43 || ch == 45) {
                nextStates.set(113);
            } else if (ch >= 48 && ch <= 57) {
                nextStates.set(402);
            }
            if (ch >= 49 && ch <= 57) {
                nextStates.set(316);
            }
            return type;
        }

        static QConstants.TokenType NFA_COMPOSITE_LS_CONSTANTS_72(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            QConstants.TokenType type = null;
            if (ch == 43 || ch == 45) {
                nextStates.set(108);
            } else if (ch >= 48 && ch <= 57) {
                nextStates.set(393);
            }
            if (ch >= 49 && ch <= 57) {
                nextStates.set(396);
            }
            return type;
        }

        static QConstants.TokenType NFA_COMPOSITE_LS_CONSTANTS_73(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            QConstants.TokenType type = null;
            if (ch >= 49 && ch <= 57) {
                nextStates.set(245);
            }
            if (ch >= 48 && ch <= 57 && validTypes.contains((Object)QConstants.TokenType.T_LONG)) {
                type = QConstants.TokenType.T_LONG;
            }
            return type;
        }

        static QConstants.TokenType NFA_COMPOSITE_LS_CONSTANTS_74(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            QConstants.TokenType type = null;
            if (ch >= 48 && ch <= 57) {
                nextStates.set(427);
            }
            if (ch >= 49 && ch <= 57) {
                nextStates.set(498);
            }
            return type;
        }

        static QConstants.TokenType NFA_COMPOSITE_LS_CONSTANTS_75(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            QConstants.TokenType type = null;
            if (ch >= 48 && ch <= 50) {
                nextStates.set(240);
            } else if (ch == 51) {
                nextStates.set(198);
            }
            return type;
        }

        static QConstants.TokenType NFA_COMPOSITE_LS_CONSTANTS_76(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            QConstants.TokenType type = null;
            if (ch == 48) {
                nextStates.set(185);
            } else if (ch == 49) {
                nextStates.set(168);
            }
            return type;
        }

        static QConstants.TokenType NFA_COMPOSITE_LS_CONSTANTS_77(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            QConstants.TokenType type = null;
            if (ch >= 48 && ch <= 57) {
                nextStates.set(389);
            }
            if (ch >= 49 && ch <= 57) {
                nextStates.set(431);
            }
            return type;
        }

        static QConstants.TokenType NFA_COMPOSITE_LS_CONSTANTS_78(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            QConstants.TokenType type = null;
            if (ch == 43 || ch == 45) {
                nextStates.set(132);
            } else if (ch == 58) {
                nextStates.set(237);
            } else if ((ch == 90 || ch == 122) && validTypes.contains((Object)QConstants.TokenType.T_DATETIMEINTERVAL)) {
                type = QConstants.TokenType.T_DATETIMEINTERVAL;
            }
            return type;
        }

        static QConstants.TokenType NFA_COMPOSITE_LS_CONSTANTS_79(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            QConstants.TokenType type = null;
            if (ch == 43 || ch == 45) {
                nextStates.set(77);
            } else if (ch >= 48 && ch <= 57) {
                nextStates.set(389);
            }
            if (ch >= 49 && ch <= 57) {
                nextStates.set(431);
            }
            return type;
        }

        static QConstants.TokenType NFA_COMPOSITE_LS_CONSTANTS_80(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            QConstants.TokenType type = null;
            if (ch == 43 || ch == 45) {
                nextStates.set(127);
            } else if (ch >= 48 && ch <= 57) {
                nextStates.set(337);
            }
            if (ch >= 49 && ch <= 57) {
                nextStates.set(422);
            }
            return type;
        }

        static QConstants.TokenType NFA_COMPOSITE_LS_CONSTANTS_81(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            QConstants.TokenType type = null;
            if (ch == 43 || ch == 45) {
                nextStates.set(51);
            } else if (ch >= 48 && ch <= 57) {
                nextStates.set(286);
            }
            if (ch >= 49 && ch <= 57) {
                nextStates.set(423);
            }
            return type;
        }

        static QConstants.TokenType NFA_COMPOSITE_LS_CONSTANTS_82(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            QConstants.TokenType type = null;
            if (ch == 43 || ch == 45) {
                nextStates.set(93);
                nextStates.set(115);
            } else if (ch >= 48 && ch <= 57) {
                nextStates.set(466);
                nextStates.set(67);
            }
            if (ch >= 49 && ch <= 57) {
                nextStates.set(467);
                nextStates.set(440);
            } else if (ch == 39 && validTypes.contains((Object)QConstants.TokenType.T_DURATION)) {
                type = QConstants.TokenType.T_DURATION;
            }
            return type;
        }

        static QConstants.TokenType NFA_COMPOSITE_LS_CONSTANTS_83(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            QConstants.TokenType type = null;
            if (ch == 43 || ch == 45) {
                nextStates.set(96);
            } else if (ch == 44) {
                nextStates.set(404);
            } else if (ch == 46) {
                nextStates.set(404);
            } else if ((ch == 90 || ch == 122) && validTypes.contains((Object)QConstants.TokenType.T_DATETIME)) {
                type = QConstants.TokenType.T_DATETIME;
            }
            return type;
        }

        static QConstants.TokenType NFA_COMPOSITE_LS_CONSTANTS_84(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            QConstants.TokenType type = null;
            if (ch >= 48 && ch <= 57) {
                nextStates.set(351);
            }
            if (ch >= 49 && ch <= 57) {
                nextStates.set(375);
            }
            return type;
        }

        static QConstants.TokenType NFA_COMPOSITE_LS_CONSTANTS_85(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            QConstants.TokenType type = null;
            if (ch == 46) {
                nextStates.set(124);
            } else if (ch == 83 || ch == 115) {
                nextStates.set(358);
            }
            return type;
        }

        static QConstants.TokenType NFA_COMPOSITE_LS_CONSTANTS_86(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            QConstants.TokenType type = null;
            if (ch >= 48 && ch <= 57) {
                nextStates.set(374);
            }
            if (ch >= 49 && ch <= 57) {
                nextStates.set(387);
            }
            return type;
        }

        static QConstants.TokenType NFA_COMPOSITE_LS_CONSTANTS_87(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            QConstants.TokenType type = null;
            if (ch >= 0 && ch <= 38 || ch >= 40) {
                nextStates.set(18);
            } else if (ch == 39) {
                nextStates.set(257);
            }
            return type;
        }

        static QConstants.TokenType NFA_COMPOSITE_LS_CONSTANTS_88(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            QConstants.TokenType type = null;
            if (ch == 43 || ch == 45) {
                nextStates.set(64);
            } else if (ch >= 48 && ch <= 57) {
                nextStates.set(291);
            }
            if (ch >= 49 && ch <= 57) {
                nextStates.set(335);
            } else if (ch == 84 || ch == 116) {
                nextStates.set(119);
            } else if (ch == 39 && validTypes.contains((Object)QConstants.TokenType.T_DURATION)) {
                type = QConstants.TokenType.T_DURATION;
            }
            return type;
        }

        static QConstants.TokenType NFA_COMPOSITE_LS_CONSTANTS_89(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            QConstants.TokenType type = null;
            if (ch == 45) {
                nextStates.set(151);
            } else if (ch >= 48 && ch <= 57) {
                nextStates.set(89);
            }
            return type;
        }

        static QConstants.TokenType NFA_COMPOSITE_LS_CONSTANTS_90(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            QConstants.TokenType type = null;
            if (ch == 44) {
                nextStates.set(258);
            } else if (ch == 46) {
                nextStates.set(258);
            }
            return type;
        }

        static QConstants.TokenType NFA_COMPOSITE_LS_CONSTANTS_91(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            QConstants.TokenType type = null;
            if (ch == 43 || ch == 45) {
                nextStates.set(73);
            } else if (ch >= 49 && ch <= 57) {
                nextStates.set(245);
            }
            if (ch >= 48 && ch <= 57 && validTypes.contains((Object)QConstants.TokenType.T_LONG)) {
                type = QConstants.TokenType.T_LONG;
            }
            return type;
        }

        static QConstants.TokenType NFA_COMPOSITE_LS_CONSTANTS_92(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            QConstants.TokenType type = null;
            if (ch >= 48 && ch <= 57) {
                nextStates.set(323);
            }
            if (ch >= 49 && ch <= 57) {
                nextStates.set(303);
            }
            return type;
        }

        static QConstants.TokenType NFA_COMPOSITE_LS_CONSTANTS_93(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            QConstants.TokenType type = null;
            if (ch >= 48 && ch <= 57) {
                nextStates.set(466);
            }
            if (ch >= 49 && ch <= 57) {
                nextStates.set(440);
            }
            return type;
        }

        static QConstants.TokenType NFA_COMPOSITE_LS_CONSTANTS_94(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            QConstants.TokenType type = null;
            if (ch == 69 || ch == 101) {
                nextStates.set(118);
            } else if (ch >= 48 && ch <= 57) {
                nextStates.set(94);
                if (validTypes.contains((Object)QConstants.TokenType.T_DOUBLE)) {
                    type = QConstants.TokenType.T_DOUBLE;
                }
            }
            return type;
        }

        static QConstants.TokenType NFA_COMPOSITE_LS_CONSTANTS_95(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            QConstants.TokenType type = null;
            if (ch == 43 || ch == 45) {
                nextStates.set(86);
                nextStates.set(139);
                nextStates.set(126);
            } else if (ch >= 48 && ch <= 57) {
                nextStates.set(318);
                nextStates.set(374);
                nextStates.set(155);
            }
            if (ch >= 49 && ch <= 57) {
                nextStates.set(387);
                nextStates.set(338);
                nextStates.set(434);
            }
            return type;
        }

        static QConstants.TokenType NFA_COMPOSITE_LS_CONSTANTS_96(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            QConstants.TokenType type = null;
            if (ch == 48) {
                nextStates.set(195);
            } else if (ch == 49) {
                nextStates.set(246);
            } else if (ch == 50) {
                nextStates.set(205);
            }
            return type;
        }

        static QConstants.TokenType NFA_COMPOSITE_LS_CONSTANTS_97(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            QConstants.TokenType type = null;
            if (ch == 43 || ch == 45) {
                nextStates.set(64);
            } else if (ch >= 48 && ch <= 57) {
                nextStates.set(291);
            }
            if (ch >= 49 && ch <= 57) {
                nextStates.set(335);
            }
            return type;
        }

        static QConstants.TokenType NFA_COMPOSITE_LS_CONSTANTS_98(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            QConstants.TokenType type = null;
            if (ch == 43 || ch == 45) {
                nextStates.set(96);
            } else if ((ch == 90 || ch == 122) && validTypes.contains((Object)QConstants.TokenType.T_DATETIME)) {
                type = QConstants.TokenType.T_DATETIME;
            }
            return type;
        }

        static QConstants.TokenType NFA_COMPOSITE_LS_CONSTANTS_99(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            QConstants.TokenType type = null;
            if (ch == 70 || ch == 102) {
                nextStates.set(182);
            } else if (ch == 84 || ch == 116) {
                nextStates.set(158);
            }
            return type;
        }

        static QConstants.TokenType NFA_COMPOSITE_LS_CONSTANTS_100(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            QConstants.TokenType type = null;
            if (ch == 45) {
                nextStates.set(76);
            } else if (ch >= 48 && ch <= 57) {
                nextStates.set(100);
            }
            return type;
        }

        static QConstants.TokenType NFA_COMPOSITE_LS_CONSTANTS_101(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            QConstants.TokenType type = null;
            if (ch >= 48 && ch <= 57) {
                nextStates.set(345);
            }
            if (ch >= 49 && ch <= 57) {
                nextStates.set(340);
            }
            return type;
        }

        static QConstants.TokenType NFA_COMPOSITE_LS_CONSTANTS_102(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            QConstants.TokenType type = null;
            if (ch == 43 || ch == 45) {
                nextStates.set(23);
            } else if (ch >= 48 && ch <= 57) {
                nextStates.set(392);
            }
            if (ch >= 49 && ch <= 57) {
                nextStates.set(346);
            }
            return type;
        }

        static QConstants.TokenType NFA_COMPOSITE_LS_CONSTANTS_103(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            QConstants.TokenType type = null;
            if (ch == 43 || ch == 45) {
                nextStates.set(132);
            } else if (ch >= 48 && ch <= 57) {
                nextStates.set(103);
            } else if ((ch == 90 || ch == 122) && validTypes.contains((Object)QConstants.TokenType.T_DATETIMEINTERVAL)) {
                type = QConstants.TokenType.T_DATETIMEINTERVAL;
            }
            return type;
        }

        static QConstants.TokenType NFA_COMPOSITE_LS_CONSTANTS_104(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            QConstants.TokenType type = null;
            if (ch == 43 || ch == 45) {
                nextStates.set(96);
            } else if (ch >= 48 && ch <= 57) {
                nextStates.set(104);
            } else if ((ch == 90 || ch == 122) && validTypes.contains((Object)QConstants.TokenType.T_DATETIME)) {
                type = QConstants.TokenType.T_DATETIME;
            }
            return type;
        }

        static QConstants.TokenType NFA_COMPOSITE_LS_CONSTANTS_105(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            QConstants.TokenType type = null;
            if (ch == 43 || ch == 45) {
                nextStates.set(86);
            } else if (ch >= 48 && ch <= 57) {
                nextStates.set(374);
            }
            if (ch >= 49 && ch <= 57) {
                nextStates.set(387);
            }
            return type;
        }

        static QConstants.TokenType NFA_COMPOSITE_LS_CONSTANTS_106(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            QConstants.TokenType type = null;
            if (ch == 43 || ch == 45) {
                nextStates.set(137);
            } else if (ch >= 48 && ch <= 57) {
                nextStates.set(85);
            }
            if (ch >= 49 && ch <= 57) {
                nextStates.set(382);
            }
            return type;
        }

        static QConstants.TokenType NFA_COMPOSITE_LS_CONSTANTS_107(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            QConstants.TokenType type = null;
            if (ch >= 48 && ch <= 50) {
                nextStates.set(250);
            } else if (ch == 51) {
                nextStates.set(184);
            }
            return type;
        }

        static QConstants.TokenType NFA_COMPOSITE_LS_CONSTANTS_108(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            QConstants.TokenType type = null;
            if (ch >= 48 && ch <= 57) {
                nextStates.set(393);
            }
            if (ch >= 49 && ch <= 57) {
                nextStates.set(396);
            }
            return type;
        }

        static QConstants.TokenType NFA_COMPOSITE_LS_CONSTANTS_109(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            QConstants.TokenType type = null;
            if (ch >= 48 && ch <= 50) {
                nextStates.set(220);
            } else if (ch == 51) {
                nextStates.set(169);
            }
            return type;
        }

        static QConstants.TokenType NFA_COMPOSITE_LS_CONSTANTS_110(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            QConstants.TokenType type = null;
            if (ch == 43 || ch == 45) {
                nextStates.set(64);
                nextStates.set(47);
                nextStates.set(113);
            } else if (ch >= 48 && ch <= 57) {
                nextStates.set(385);
                nextStates.set(402);
                nextStates.set(291);
            }
            if (ch >= 49 && ch <= 57) {
                nextStates.set(316);
                nextStates.set(335);
                nextStates.set(356);
            } else if (ch == 84 || ch == 116) {
                nextStates.set(119);
            } else if (ch == 39 && validTypes.contains((Object)QConstants.TokenType.T_DURATION)) {
                type = QConstants.TokenType.T_DURATION;
            }
            return type;
        }

        static QConstants.TokenType NFA_COMPOSITE_LS_CONSTANTS_111(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            QConstants.TokenType type = null;
            if (ch == 47) {
                nextStates.set(17);
            } else if (ch == 84 || ch == 116) {
                nextStates.set(37);
            }
            return type;
        }

        static QConstants.TokenType NFA_COMPOSITE_LS_CONSTANTS_112(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            QConstants.TokenType type = null;
            if (ch == 43 || ch == 45) {
                nextStates.set(137);
            } else if (ch == 47) {
                nextStates.set(17);
            } else if (ch >= 48 && ch <= 57) {
                nextStates.set(85);
            }
            if (ch >= 49 && ch <= 57) {
                nextStates.set(382);
            }
            return type;
        }

        static QConstants.TokenType NFA_COMPOSITE_LS_CONSTANTS_113(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            QConstants.TokenType type = null;
            if (ch >= 48 && ch <= 57) {
                nextStates.set(402);
            }
            if (ch >= 49 && ch <= 57) {
                nextStates.set(316);
            }
            return type;
        }

        static QConstants.TokenType NFA_COMPOSITE_LS_CONSTANTS_114(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            QConstants.TokenType type = null;
            if (ch == 43 || ch == 45) {
                nextStates.set(51);
                nextStates.set(20);
            } else if (ch >= 48 && ch <= 57) {
                nextStates.set(344);
                nextStates.set(286);
            }
            if (ch >= 49 && ch <= 57) {
                nextStates.set(430);
                nextStates.set(423);
            } else if (ch == 84 || ch == 116) {
                nextStates.set(95);
                if (validTypes.contains((Object)QConstants.TokenType.T_DATETIMEINTERVAL)) {
                    type = QConstants.TokenType.T_DATETIMEINTERVAL;
                }
            }
            return type;
        }

        static QConstants.TokenType NFA_COMPOSITE_LS_CONSTANTS_115(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            QConstants.TokenType type = null;
            if (ch >= 48 && ch <= 57) {
                nextStates.set(67);
            }
            if (ch >= 49 && ch <= 57) {
                nextStates.set(467);
            }
            return type;
        }

        static QConstants.TokenType NFA_COMPOSITE_LS_CONSTANTS_116(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            QConstants.TokenType type = null;
            if (ch == 44) {
                nextStates.set(404);
            } else if (ch == 46) {
                nextStates.set(404);
            }
            return type;
        }

        static QConstants.TokenType NFA_COMPOSITE_LS_CONSTANTS_117(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            QConstants.TokenType type = null;
            if (ch == 46) {
                nextStates.set(299);
            } else if (ch == 69 || ch == 101) {
                nextStates.set(118);
            }
            return type;
        }

        static QConstants.TokenType NFA_COMPOSITE_LS_CONSTANTS_118(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            QConstants.TokenType type = null;
            if (ch == 45) {
                nextStates.set(282);
            } else if (ch >= 48 && ch <= 57) {
                nextStates.set(282);
                if (validTypes.contains((Object)QConstants.TokenType.T_DOUBLE)) {
                    type = QConstants.TokenType.T_DOUBLE;
                }
            }
            return type;
        }

        static QConstants.TokenType NFA_COMPOSITE_LS_CONSTANTS_119(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            QConstants.TokenType type = null;
            if (ch == 43 || ch == 45) {
                nextStates.set(74);
                nextStates.set(93);
                nextStates.set(115);
            } else if (ch >= 48 && ch <= 57) {
                nextStates.set(466);
                nextStates.set(427);
                nextStates.set(67);
            }
            if (ch >= 49 && ch <= 57) {
                nextStates.set(498);
                nextStates.set(467);
                nextStates.set(440);
            } else if (ch == 39 && validTypes.contains((Object)QConstants.TokenType.T_DURATION)) {
                type = QConstants.TokenType.T_DURATION;
            }
            return type;
        }

        static QConstants.TokenType NFA_COMPOSITE_LS_CONSTANTS_120(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            QConstants.TokenType type = null;
            if (ch >= 48 && ch <= 57) {
                nextStates.set(120);
            } else if (ch == 77 || ch == 109) {
                nextStates.set(114);
                if (validTypes.contains((Object)QConstants.TokenType.T_DATETIMEINTERVAL)) {
                    type = QConstants.TokenType.T_DATETIMEINTERVAL;
                }
            }
            return type;
        }

        static QConstants.TokenType NFA_COMPOSITE_LS_CONSTANTS_121(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            QConstants.TokenType type = null;
            if (ch >= 48 && ch <= 57) {
                nextStates.set(121);
            } else if ((ch == 83 || ch == 115) && validTypes.contains((Object)QConstants.TokenType.T_DATETIMEINTERVAL)) {
                type = QConstants.TokenType.T_DATETIMEINTERVAL;
            }
            return type;
        }

        static QConstants.TokenType NFA_COMPOSITE_LS_CONSTANTS_122(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            QConstants.TokenType type = null;
            if (ch == 46) {
                nextStates.set(124);
            } else if (ch >= 48 && ch <= 57) {
                nextStates.set(122);
            } else if (ch == 83 || ch == 115) {
                nextStates.set(358);
            }
            return type;
        }

        static QConstants.TokenType NFA_COMPOSITE_LS_CONSTANTS_123(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            QConstants.TokenType type = null;
            if (ch >= 48 && ch <= 57) {
                nextStates.set(123);
            } else if (ch == 87 || ch == 119) {
                nextStates.set(145);
                if (validTypes.contains((Object)QConstants.TokenType.T_DATETIMEINTERVAL)) {
                    type = QConstants.TokenType.T_DATETIMEINTERVAL;
                }
            }
            return type;
        }

        static QConstants.TokenType NFA_COMPOSITE_LS_CONSTANTS_124(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            QConstants.TokenType type = null;
            if (ch == 43 || ch == 45) {
                nextStates.set(58);
            } else if (ch >= 48 && ch <= 57) {
                nextStates.set(463);
            }
            if (ch >= 49 && ch <= 57) {
                nextStates.set(451);
            }
            return type;
        }

        static QConstants.TokenType NFA_COMPOSITE_LS_CONSTANTS_125(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            QConstants.TokenType type = null;
            if (ch == 45) {
                nextStates.set(30);
            } else if (ch >= 48 && ch <= 57) {
                nextStates.set(125);
            }
            return type;
        }

        static QConstants.TokenType NFA_COMPOSITE_LS_CONSTANTS_126(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            QConstants.TokenType type = null;
            if (ch >= 48 && ch <= 57) {
                nextStates.set(318);
            }
            if (ch >= 49 && ch <= 57) {
                nextStates.set(434);
            }
            return type;
        }

        static QConstants.TokenType NFA_COMPOSITE_LS_CONSTANTS_127(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            QConstants.TokenType type = null;
            if (ch >= 48 && ch <= 57) {
                nextStates.set(337);
            }
            if (ch >= 49 && ch <= 57) {
                nextStates.set(422);
            }
            return type;
        }

        static QConstants.TokenType NFA_COMPOSITE_LS_CONSTANTS_128(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            QConstants.TokenType type = null;
            if (ch == 43 || ch == 45) {
                nextStates.set(51);
                nextStates.set(101);
                nextStates.set(20);
            } else if (ch >= 48 && ch <= 57) {
                nextStates.set(344);
                nextStates.set(286);
                nextStates.set(345);
            }
            if (ch >= 49 && ch <= 57) {
                nextStates.set(430);
                nextStates.set(340);
                nextStates.set(423);
            } else if (ch == 84 || ch == 116) {
                nextStates.set(95);
                if (validTypes.contains((Object)QConstants.TokenType.T_DATETIMEINTERVAL)) {
                    type = QConstants.TokenType.T_DATETIMEINTERVAL;
                }
            }
            return type;
        }

        static QConstants.TokenType NFA_COMPOSITE_LS_CONSTANTS_129(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            QConstants.TokenType type = null;
            if (ch == 43 || ch == 45) {
                nextStates.set(152);
            } else if (ch >= 48 && ch <= 57) {
                nextStates.set(292);
            }
            if (ch >= 49 && ch <= 57) {
                nextStates.set(445);
            }
            return type;
        }

        static QConstants.TokenType NFA_COMPOSITE_LS_CONSTANTS_130(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            QConstants.TokenType type = null;
            if (ch >= 48 && ch <= 57) {
                nextStates.set(130);
            } else if (ch == 72 || ch == 104) {
                nextStates.set(9);
            }
            return type;
        }

        static QConstants.TokenType NFA_COMPOSITE_LS_CONSTANTS_131(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            QConstants.TokenType type = null;
            if (ch == 43 || ch == 45) {
                nextStates.set(132);
            } else if ((ch == 90 || ch == 122) && validTypes.contains((Object)QConstants.TokenType.T_DATETIMEINTERVAL)) {
                type = QConstants.TokenType.T_DATETIMEINTERVAL;
            }
            return type;
        }

        static QConstants.TokenType NFA_COMPOSITE_LS_CONSTANTS_132(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            QConstants.TokenType type = null;
            if (ch == 48) {
                nextStates.set(244);
            } else if (ch == 49) {
                nextStates.set(196);
            } else if (ch == 50) {
                nextStates.set(177);
            }
            return type;
        }

        static QConstants.TokenType NFA_COMPOSITE_LS_CONSTANTS_133(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            QConstants.TokenType type = null;
            if (ch == 43 || ch == 45) {
                nextStates.set(140);
                nextStates.set(23);
                nextStates.set(108);
                nextStates.set(35);
            } else if (ch == 47) {
                nextStates.set(17);
            } else if (ch >= 48 && ch <= 57) {
                nextStates.set(393);
                nextStates.set(277);
                nextStates.set(392);
                nextStates.set(350);
            }
            if (ch >= 49 && ch <= 57) {
                nextStates.set(346);
                nextStates.set(436);
                nextStates.set(396);
                nextStates.set(425);
            } else if (ch == 84 || ch == 116) {
                nextStates.set(37);
            }
            return type;
        }

        static QConstants.TokenType NFA_COMPOSITE_LS_CONSTANTS_134(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            QConstants.TokenType type = null;
            if (ch == 43 || ch == 45) {
                nextStates.set(140);
            } else if (ch == 47) {
                nextStates.set(17);
            } else if (ch >= 48 && ch <= 57) {
                nextStates.set(350);
            }
            if (ch >= 49 && ch <= 57) {
                nextStates.set(425);
            } else if (ch == 84 || ch == 116) {
                nextStates.set(37);
            }
            return type;
        }

        static QConstants.TokenType NFA_COMPOSITE_LS_CONSTANTS_135(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            QConstants.TokenType type = null;
            if (ch == 43 || ch == 45) {
                nextStates.set(115);
            } else if (ch >= 48 && ch <= 57) {
                nextStates.set(67);
            }
            if (ch >= 49 && ch <= 57) {
                nextStates.set(467);
            } else if (ch == 39 && validTypes.contains((Object)QConstants.TokenType.T_DURATION)) {
                type = QConstants.TokenType.T_DURATION;
            }
            return type;
        }

        static QConstants.TokenType NFA_COMPOSITE_LS_CONSTANTS_136(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            QConstants.TokenType type = null;
            if (ch == 43 || ch == 45) {
                nextStates.set(108);
                nextStates.set(140);
            } else if (ch == 47) {
                nextStates.set(17);
            } else if (ch >= 48 && ch <= 57) {
                nextStates.set(393);
                nextStates.set(350);
            }
            if (ch >= 49 && ch <= 57) {
                nextStates.set(396);
                nextStates.set(425);
            } else if (ch == 84 || ch == 116) {
                nextStates.set(37);
            }
            return type;
        }

        static QConstants.TokenType NFA_COMPOSITE_LS_CONSTANTS_137(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            QConstants.TokenType type = null;
            if (ch >= 48 && ch <= 57) {
                nextStates.set(85);
            }
            if (ch >= 49 && ch <= 57) {
                nextStates.set(382);
            }
            return type;
        }

        static QConstants.TokenType NFA_COMPOSITE_LS_CONSTANTS_138(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            QConstants.TokenType type = null;
            if (ch == 43 || ch == 45) {
                nextStates.set(84);
            } else if (ch >= 48 && ch <= 57) {
                nextStates.set(351);
            }
            if (ch >= 49 && ch <= 57) {
                nextStates.set(375);
            }
            return type;
        }

        static QConstants.TokenType NFA_COMPOSITE_LS_CONSTANTS_139(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            QConstants.TokenType type = null;
            if (ch >= 48 && ch <= 57) {
                nextStates.set(155);
            }
            if (ch >= 49 && ch <= 57) {
                nextStates.set(338);
            }
            return type;
        }

        static QConstants.TokenType NFA_COMPOSITE_LS_CONSTANTS_140(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            QConstants.TokenType type = null;
            if (ch >= 48 && ch <= 57) {
                nextStates.set(350);
            }
            if (ch >= 49 && ch <= 57) {
                nextStates.set(425);
            }
            return type;
        }

        static QConstants.TokenType NFA_COMPOSITE_LS_CONSTANTS_141(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            QConstants.TokenType type = null;
            if (ch == 43 || ch == 45) {
                nextStates.set(424);
            } else if (ch == 80 || ch == 112) {
                nextStates.set(41);
            }
            return type;
        }

        static QConstants.TokenType NFA_COMPOSITE_LS_CONSTANTS_142(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            QConstants.TokenType type = null;
            if (ch == 43 || ch == 45) {
                nextStates.set(101);
            } else if (ch >= 48 && ch <= 57) {
                nextStates.set(345);
            }
            if (ch >= 49 && ch <= 57) {
                nextStates.set(340);
            }
            return type;
        }

        static QConstants.TokenType NFA_COMPOSITE_LS_CONSTANTS_143(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            QConstants.TokenType type = null;
            if (ch >= 48 && ch <= 57) {
                nextStates.set(143);
            } else if (ch == 72 || ch == 104) {
                nextStates.set(156);
                if (validTypes.contains((Object)QConstants.TokenType.T_DATETIMEINTERVAL)) {
                    type = QConstants.TokenType.T_DATETIMEINTERVAL;
                }
            }
            return type;
        }

        static QConstants.TokenType NFA_COMPOSITE_LS_CONSTANTS_144(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            QConstants.TokenType type = null;
            if (ch == 44) {
                nextStates.set(442);
            } else if (ch == 46) {
                nextStates.set(442);
            }
            return type;
        }

        static QConstants.TokenType NFA_COMPOSITE_LS_CONSTANTS_145(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            QConstants.TokenType type = null;
            if (ch == 43 || ch == 45) {
                nextStates.set(51);
            } else if (ch >= 48 && ch <= 57) {
                nextStates.set(286);
            }
            if (ch >= 49 && ch <= 57) {
                nextStates.set(423);
            } else if (ch == 84 || ch == 116) {
                nextStates.set(95);
                if (validTypes.contains((Object)QConstants.TokenType.T_DATETIMEINTERVAL)) {
                    type = QConstants.TokenType.T_DATETIMEINTERVAL;
                }
            }
            return type;
        }

        static QConstants.TokenType NFA_COMPOSITE_LS_CONSTANTS_146(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            QConstants.TokenType type = null;
            if (ch == 43 || ch == 45) {
                nextStates.set(139);
            } else if (ch >= 48 && ch <= 57) {
                nextStates.set(155);
            }
            if (ch >= 49 && ch <= 57) {
                nextStates.set(338);
            }
            return type;
        }

        static QConstants.TokenType NFA_COMPOSITE_LS_CONSTANTS_147(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            QConstants.TokenType type = null;
            if (ch >= 48 && ch <= 57) {
                nextStates.set(147);
            } else if (ch == 77 || ch == 109) {
                nextStates.set(135);
            }
            return type;
        }

        static QConstants.TokenType NFA_COMPOSITE_LS_CONSTANTS_148(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            QConstants.TokenType type = null;
            if (ch == 48) {
                nextStates.set(229);
            } else if (ch == 49) {
                nextStates.set(264);
            } else if (ch == 50) {
                nextStates.set(216);
            }
            return type;
        }

        static QConstants.TokenType NFA_COMPOSITE_LS_CONSTANTS_149(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            QConstants.TokenType type = null;
            if (ch >= 48 && ch <= 57) {
                nextStates.set(454);
            }
            if (ch >= 49 && ch <= 57) {
                nextStates.set(439);
            }
            return type;
        }

        static QConstants.TokenType NFA_COMPOSITE_LS_CONSTANTS_150(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            QConstants.TokenType type = null;
            if (ch >= 48 && ch <= 57) {
                nextStates.set(150);
            } else if (ch == 68 || ch == 100) {
                nextStates.set(63);
            }
            return type;
        }

        static QConstants.TokenType NFA_COMPOSITE_LS_CONSTANTS_151(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            QConstants.TokenType type = null;
            if (ch == 48) {
                nextStates.set(181);
            } else if (ch == 49) {
                nextStates.set(260);
            }
            return type;
        }

        static QConstants.TokenType NFA_COMPOSITE_LS_CONSTANTS_152(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            QConstants.TokenType type = null;
            if (ch >= 48 && ch <= 57) {
                nextStates.set(292);
            }
            if (ch >= 49 && ch <= 57) {
                nextStates.set(445);
            }
            return type;
        }

        static QConstants.TokenType NFA_COMPOSITE_LS_CONSTANTS_153(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            QConstants.TokenType type = null;
            if (ch >= 48 && ch <= 57) {
                nextStates.set(153);
            } else if (ch == 87 || ch == 119) {
                nextStates.set(134);
            }
            return type;
        }

        static QConstants.TokenType NFA_COMPOSITE_LS_CONSTANTS_154(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            QConstants.TokenType type = null;
            if (ch >= 48 && ch <= 57) {
                nextStates.set(154);
            } else if (ch == 68 || ch == 100) {
                nextStates.set(111);
            }
            return type;
        }

        static QConstants.TokenType NFA_COMPOSITE_LS_CONSTANTS_155(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            QConstants.TokenType type = null;
            if (ch == 46) {
                nextStates.set(138);
            } else if ((ch == 83 || ch == 115) && validTypes.contains((Object)QConstants.TokenType.T_DATETIMEINTERVAL)) {
                type = QConstants.TokenType.T_DATETIMEINTERVAL;
            }
            return type;
        }

        static QConstants.TokenType NFA_COMPOSITE_LS_CONSTANTS_156(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            QConstants.TokenType type = null;
            if (ch == 43 || ch == 45) {
                nextStates.set(139);
                nextStates.set(126);
            } else if (ch >= 48 && ch <= 57) {
                nextStates.set(318);
                nextStates.set(155);
            }
            if (ch >= 49 && ch <= 57) {
                nextStates.set(338);
                nextStates.set(434);
            }
            return type;
        }

        static QConstants.TokenType NFA_COMPOSITE_LS_CONSTANTS_157(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            QConstants.TokenType type = null;
            if (ch >= 48 && ch <= 57) {
                nextStates.set(157);
            } else if (ch == 72 || ch == 104) {
                nextStates.set(82);
            }
            return type;
        }

        static QConstants.TokenType NFA_LS_CONSTANTS_158(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 82 || ch == 114) {
                nextStates.set(188);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_CONSTANTS_159(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if ((ch == 76 || ch == 108) && validTypes.contains((Object)QConstants.TokenType.T_NULL)) {
                return QConstants.TokenType.T_NULL;
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_CONSTANTS_160(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 71 || ch == 103) {
                nextStates.set(253);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_CONSTANTS_161(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 58) {
                nextStates.set(179);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_CONSTANTS_162(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch >= 48 && ch <= 53) {
                nextStates.set(163);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_CONSTANTS_163(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch >= 48 && ch <= 57) {
                nextStates.set(57);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_CONSTANTS_164(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch >= 48 && ch <= 53) {
                nextStates.set(255);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_CONSTANTS_165(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 84 || ch == 116) {
                nextStates.set(8);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_CONSTANTS_166(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if ((ch == 69 || ch == 101) && validTypes.contains((Object)QConstants.TokenType.T_BOOL)) {
                return QConstants.TokenType.T_BOOL;
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_CONSTANTS_167(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 58) {
                nextStates.set(254);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_CONSTANTS_168(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch >= 48 && ch <= 50) {
                nextStates.set(256);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_CONSTANTS_169(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if ((ch == 48 || ch == 49) && validTypes.contains((Object)QConstants.TokenType.T_DATE)) {
                return QConstants.TokenType.T_DATE;
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_CONSTANTS_170(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 45) {
                nextStates.set(109);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_CONSTANTS_171(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch >= 48 && ch <= 57) {
                nextStates.set(78);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_CONSTANTS_172(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 72 || ch == 104) {
                nextStates.set(262);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_CONSTANTS_173(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 9 && validTypes.contains((Object)QConstants.TokenType._TOKEN_4)) {
                return QConstants.TokenType._TOKEN_4;
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_CONSTANTS_174(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch >= 48 && ch <= 57) {
                nextStates.set(83);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_CONSTANTS_175(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch >= 48 && ch <= 57) {
                nextStates.set(211);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_CONSTANTS_176(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch >= 48 && ch <= 53) {
                nextStates.set(267);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_CONSTANTS_177(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch >= 48 && ch <= 51) {
                nextStates.set(231);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_CONSTANTS_178(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch >= 48 && ch <= 57) {
                nextStates.set(233);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_CONSTANTS_179(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch >= 48 && ch <= 53) {
                nextStates.set(207);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_CONSTANTS_180(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch >= 48 && ch <= 53) {
                nextStates.set(171);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_CONSTANTS_181(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch >= 48 && ch <= 57) {
                nextStates.set(170);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_CONSTANTS_182(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 65 || ch == 97) {
                nextStates.set(251);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_CONSTANTS_183(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 83 || ch == 115) {
                nextStates.set(200);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_CONSTANTS_184(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 48 || ch == 49) {
                nextStates.set(230);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_CONSTANTS_185(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch >= 48 && ch <= 57) {
                nextStates.set(256);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_CONSTANTS_186(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 48 || ch == 49) {
                nextStates.set(165);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_CONSTANTS_187(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 58) {
                nextStates.set(218);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_CONSTANTS_188(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 85 || ch == 117) {
                nextStates.set(166);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_CONSTANTS_189(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch >= 48 && ch <= 57) {
                nextStates.set(233);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_CONSTANTS_190(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 85 || ch == 117) {
                nextStates.set(199);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_CONSTANTS_191(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 41 && validTypes.contains((Object)QConstants.TokenType.T_RB)) {
                return QConstants.TokenType.T_RB;
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_CONSTANTS_192(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 39) {
                nextStates.set(141);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_CONSTANTS_193(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 84 || ch == 116) {
                nextStates.set(66);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_CONSTANTS_194(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 68 || ch == 100) {
                nextStates.set(226);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_CONSTANTS_195(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch >= 48 && ch <= 57) {
                nextStates.set(272);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_CONSTANTS_196(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch >= 48 && ch <= 57) {
                nextStates.set(231);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_CONSTANTS_197(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 39) {
                nextStates.set(31);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_CONSTANTS_198(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 48 || ch == 49) {
                nextStates.set(193);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_CONSTANTS_199(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 76 || ch == 108) {
                nextStates.set(159);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_CONSTANTS_200(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if ((ch == 69 || ch == 101) && validTypes.contains((Object)QConstants.TokenType.T_BOOL)) {
                return QConstants.TokenType.T_BOOL;
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_CONSTANTS_201(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 45) {
                nextStates.set(12);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_CONSTANTS_202(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 45) {
                nextStates.set(75);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_CONSTANTS_203(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch >= 48 && ch <= 57) {
                nextStates.set(211);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_CONSTANTS_204(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch >= 48 && ch <= 57) {
                nextStates.set(161);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_CONSTANTS_205(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch >= 48 && ch <= 51) {
                nextStates.set(272);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_CONSTANTS_206(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch >= 48 && ch <= 51) {
                nextStates.set(261);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_CONSTANTS_207(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch >= 48 && ch <= 57) {
                nextStates.set(7);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_CONSTANTS_208(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch >= 48 && ch <= 51) {
                nextStates.set(233);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_CONSTANTS_209(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 78 || ch == 110) {
                nextStates.set(190);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_CONSTANTS_210(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch >= 48 && ch <= 51) {
                nextStates.set(211);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_CONSTANTS_211(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 58) {
                nextStates.set(180);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_CONSTANTS_212(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 82 || ch == 114) {
                nextStates.set(223);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_CONSTANTS_213(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch >= 48 && ch <= 57) {
                nextStates.set(5);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_CONSTANTS_214(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch >= 48 && ch <= 53) {
                nextStates.set(263);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_CONSTANTS_215(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 79 || ch == 111) {
                nextStates.set(268);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_CONSTANTS_216(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch >= 48 && ch <= 51) {
                nextStates.set(167);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_CONSTANTS_217(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch >= 48 && ch <= 51) {
                nextStates.set(161);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_CONSTANTS_218(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch >= 48 && ch <= 53) {
                nextStates.set(227);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_CONSTANTS_219(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 73 || ch == 105) {
                nextStates.set(215);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_CONSTANTS_220(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch >= 48 && ch <= 57 && validTypes.contains((Object)QConstants.TokenType.T_DATE)) {
                return QConstants.TokenType.T_DATE;
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_CONSTANTS_221(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch >= 48 && ch <= 50) {
                nextStates.set(202);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_CONSTANTS_222(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 65 || ch == 97) {
                nextStates.set(238);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_CONSTANTS_223(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 65 || ch == 97) {
                nextStates.set(247);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_CONSTANTS_224(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch >= 48 && ch <= 57) {
                nextStates.set(261);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_CONSTANTS_225(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch >= 48 && ch <= 57) {
                nextStates.set(161);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_CONSTANTS_226(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 85 || ch == 117) {
                nextStates.set(212);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_CONSTANTS_227(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch >= 48 && ch <= 57) {
                nextStates.set(90);
                if (validTypes.contains((Object)QConstants.TokenType.T_TIME)) {
                    return QConstants.TokenType.T_TIME;
                }
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_CONSTANTS_228(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 13 && validTypes.contains((Object)QConstants.TokenType._TOKEN_3)) {
                return QConstants.TokenType._TOKEN_3;
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_CONSTANTS_229(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch >= 48 && ch <= 57) {
                nextStates.set(167);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_CONSTANTS_230(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 84 || ch == 116) {
                nextStates.set(38);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_CONSTANTS_231(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 58) {
                nextStates.set(259);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_CONSTANTS_232(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch >= 48 && ch <= 57) {
                nextStates.set(187);
                if (validTypes.contains((Object)QConstants.TokenType.T_TIME)) {
                    return QConstants.TokenType.T_TIME;
                }
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_CONSTANTS_233(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 58) {
                nextStates.set(176);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_CONSTANTS_234(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch >= 48 && ch <= 50) {
                nextStates.set(201);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_CONSTANTS_235(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 39) {
                nextStates.set(18);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_CONSTANTS_236(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch >= 48 && ch <= 53) {
                nextStates.set(174);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_CONSTANTS_237(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch >= 48 && ch <= 53) {
                nextStates.set(213);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_CONSTANTS_238(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 80 || ch == 112) {
                nextStates.set(172);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_CONSTANTS_239(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch >= 48 && ch <= 57) {
                nextStates.set(202);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_CONSTANTS_240(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch >= 48 && ch <= 57) {
                nextStates.set(193);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_CONSTANTS_241(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 71 || ch == 103) {
                nextStates.set(270);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_CONSTANTS_242(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch >= 48 && ch <= 57) {
                nextStates.set(165);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_CONSTANTS_243(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 10 && validTypes.contains((Object)QConstants.TokenType._TOKEN_2)) {
                return QConstants.TokenType._TOKEN_2;
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_CONSTANTS_244(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch >= 48 && ch <= 57) {
                nextStates.set(231);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_CONSTANTS_245(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch >= 48 && ch <= 57) {
                nextStates.set(245);
                if (validTypes.contains((Object)QConstants.TokenType.T_LONG)) {
                    return QConstants.TokenType.T_LONG;
                }
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_CONSTANTS_246(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch >= 48 && ch <= 57) {
                nextStates.set(272);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_CONSTANTS_247(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 84 || ch == 116) {
                nextStates.set(219);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_CONSTANTS_248(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 40 && validTypes.contains((Object)QConstants.TokenType.T_LB)) {
                return QConstants.TokenType.T_LB;
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_CONSTANTS_249(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch >= 48 && ch <= 57) {
                nextStates.set(201);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_CONSTANTS_250(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch >= 48 && ch <= 57) {
                nextStates.set(230);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_CONSTANTS_251(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 76 || ch == 108) {
                nextStates.set(183);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_CONSTANTS_252(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch >= 48 && ch <= 57 && validTypes.contains((Object)QConstants.TokenType.T_DATETIMEINTERVAL)) {
                return QConstants.TokenType.T_DATETIMEINTERVAL;
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_CONSTANTS_253(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 82 || ch == 114) {
                nextStates.set(222);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_CONSTANTS_254(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch >= 48 && ch <= 53) {
                nextStates.set(232);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_CONSTANTS_255(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch >= 48 && ch <= 57) {
                nextStates.set(36);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_CONSTANTS_256(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 45) {
                nextStates.set(107);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_CONSTANTS_257(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 39) {
                nextStates.set(18);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_CONSTANTS_258(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch >= 48 && ch <= 57) {
                nextStates.set(258);
                if (validTypes.contains((Object)QConstants.TokenType.T_TIME)) {
                    return QConstants.TokenType.T_TIME;
                }
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_CONSTANTS_259(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch >= 48 && ch <= 53) {
                nextStates.set(252);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_CONSTANTS_260(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch >= 48 && ch <= 50) {
                nextStates.set(170);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_CONSTANTS_261(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 58) {
                nextStates.set(164);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_CONSTANTS_262(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 89 || ch == 121) {
                nextStates.set(197);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_CONSTANTS_263(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch >= 48 && ch <= 57 && validTypes.contains((Object)QConstants.TokenType.T_DATETIME)) {
                return QConstants.TokenType.T_DATETIME;
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_CONSTANTS_264(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch >= 48 && ch <= 57) {
                nextStates.set(167);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_CONSTANTS_265(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 32 && validTypes.contains((Object)QConstants.TokenType._TOKEN_1)) {
                return QConstants.TokenType._TOKEN_1;
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_CONSTANTS_266(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch >= 48 && ch <= 57) {
                nextStates.set(261);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_CONSTANTS_267(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch >= 48 && ch <= 57) {
                nextStates.set(358);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_CONSTANTS_268(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 78 || ch == 110) {
                nextStates.set(192);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_CONSTANTS_269(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 44 && validTypes.contains((Object)QConstants.TokenType.T_VALUE_SEPARATOR)) {
                return QConstants.TokenType.T_VALUE_SEPARATOR;
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_CONSTANTS_270(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 69 || ch == 101) {
                nextStates.set(271);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_CONSTANTS_271(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 79 || ch == 111) {
                nextStates.set(160);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_CONSTANTS_272(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 58) {
                nextStates.set(214);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_CONSTANTS_273(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch >= 48 && ch <= 57) {
                nextStates.set(489);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_CONSTANTS_274(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 39) {
                nextStates.set(257);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_CONSTANTS_275(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch >= 48 && ch <= 57) {
                nextStates.set(385);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_CONSTANTS_276(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 48) {
                nextStates.set(185);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_CONSTANTS_277(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 77 || ch == 109) {
                nextStates.set(136);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_CONSTANTS_278(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 43 || ch == 45) {
                nextStates.set(354);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_CONSTANTS_279(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 58) {
                nextStates.set(236);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_CONSTANTS_280(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 43 || ch == 45) {
                nextStates.set(84);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_CONSTANTS_281(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 58) {
                nextStates.set(237);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_CONSTANTS_282(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch >= 48 && ch <= 57) {
                nextStates.set(282);
                if (validTypes.contains((Object)QConstants.TokenType.T_DOUBLE)) {
                    return QConstants.TokenType.T_DOUBLE;
                }
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_CONSTANTS_283(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 48) {
                nextStates.set(239);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_CONSTANTS_284(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch >= 49 && ch <= 57) {
                nextStates.set(422);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_CONSTANTS_285(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 43 || ch == 45) {
                nextStates.set(137);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_CONSTANTS_286(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 68 || ch == 100) {
                nextStates.set(499);
                if (validTypes.contains((Object)QConstants.TokenType.T_DATETIMEINTERVAL)) {
                    return QConstants.TokenType.T_DATETIMEINTERVAL;
                }
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_CONSTANTS_287(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 43 || ch == 45) {
                nextStates.set(108);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_CONSTANTS_288(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 46) {
                nextStates.set(404);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_CONSTANTS_289(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch >= 48 && ch <= 57) {
                nextStates.set(100);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_CONSTANTS_290(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 39 && validTypes.contains((Object)QConstants.TokenType.T_GEO_STR_LIT)) {
                return QConstants.TokenType.T_GEO_STR_LIT;
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_CONSTANTS_291(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 68 || ch == 100) {
                nextStates.set(63);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_CONSTANTS_292(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 45) {
                nextStates.set(6);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_CONSTANTS_293(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch >= 48 && ch <= 57) {
                nextStates.set(466);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_CONSTANTS_294(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 46) {
                nextStates.set(138);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_CONSTANTS_295(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch >= 48 && ch <= 57) {
                nextStates.set(337);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_CONSTANTS_296(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch >= 48 && ch <= 57) {
                nextStates.set(427);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_CONSTANTS_297(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch >= 48 && ch <= 50) {
                nextStates.set(242);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_CONSTANTS_298(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 43 || ch == 45) {
                nextStates.set(113);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_CONSTANTS_299(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch >= 48 && ch <= 57) {
                nextStates.set(94);
                if (validTypes.contains((Object)QConstants.TokenType.T_DOUBLE)) {
                    return QConstants.TokenType.T_DOUBLE;
                }
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_CONSTANTS_300(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch >= 48 && ch <= 57) {
                nextStates.set(350);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_CONSTANTS_301(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 43 || ch == 45) {
                nextStates.set(149);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_CONSTANTS_302(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 51) {
                nextStates.set(184);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_CONSTANTS_303(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch >= 48 && ch <= 57) {
                nextStates.set(70);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_CONSTANTS_304(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 39 && validTypes.contains((Object)QConstants.TokenType.T_STR_LIT)) {
                return QConstants.TokenType.T_STR_LIT;
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_CONSTANTS_305(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch >= 48 && ch <= 57) {
                nextStates.set(344);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_CONSTANTS_306(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if ((ch == 90 || ch == 122) && validTypes.contains((Object)QConstants.TokenType.T_DATETIMEINTERVAL)) {
                return QConstants.TokenType.T_DATETIMEINTERVAL;
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_CONSTANTS_307(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 44) {
                nextStates.set(322);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_CONSTANTS_308(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 44) {
                nextStates.set(404);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_CONSTANTS_309(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 46) {
                nextStates.set(79);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_CONSTANTS_310(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 43 || ch == 45) {
                nextStates.set(20);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_CONSTANTS_311(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch >= 49 && ch <= 57) {
                nextStates.set(289);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_CONSTANTS_312(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 43 || ch == 45) {
                nextStates.set(86);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_CONSTANTS_313(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 48) {
                nextStates.set(195);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_CONSTANTS_314(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 46) {
                nextStates.set(322);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_CONSTANTS_315(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if ((ch == 90 || ch == 122) && validTypes.contains((Object)QConstants.TokenType.T_DATETIME)) {
                return QConstants.TokenType.T_DATETIME;
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_CONSTANTS_316(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch >= 48 && ch <= 57) {
                nextStates.set(2);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_CONSTANTS_317(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 84 || ch == 116) {
                nextStates.set(37);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_CONSTANTS_318(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 77 || ch == 109) {
                nextStates.set(146);
                if (validTypes.contains((Object)QConstants.TokenType.T_DATETIMEINTERVAL)) {
                    return QConstants.TokenType.T_DATETIMEINTERVAL;
                }
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_CONSTANTS_319(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 50) {
                nextStates.set(177);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_CONSTANTS_320(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch >= 48 && ch <= 57) {
                nextStates.set(393);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_CONSTANTS_321(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch >= 48 && ch <= 57) {
                nextStates.set(54);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_CONSTANTS_322(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch >= 48 && ch <= 57) {
                nextStates.set(103);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_CONSTANTS_323(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 77 || ch == 109) {
                nextStates.set(112);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_CONSTANTS_324(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 45) {
                nextStates.set(30);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_CONSTANTS_325(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 50) {
                nextStates.set(208);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_CONSTANTS_326(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 43 || ch == 45) {
                nextStates.set(73);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_CONSTANTS_327(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 80 || ch == 112) {
                nextStates.set(45);
                if (validTypes.contains((Object)QConstants.TokenType.T_DATETIMEINTERVAL)) {
                    return QConstants.TokenType.T_DATETIMEINTERVAL;
                }
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_CONSTANTS_328(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 51) {
                nextStates.set(169);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_CONSTANTS_329(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch >= 49 && ch <= 57) {
                nextStates.set(387);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_CONSTANTS_330(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch >= 48 && ch <= 57) {
                nextStates.set(291);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_CONSTANTS_331(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch >= 49 && ch <= 57) {
                nextStates.set(451);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_CONSTANTS_332(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch >= 48 && ch <= 57) {
                nextStates.set(155);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_CONSTANTS_333(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch >= 49 && ch <= 57) {
                nextStates.set(430);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_CONSTANTS_334(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 84 || ch == 116) {
                nextStates.set(158);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_CONSTANTS_335(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch >= 48 && ch <= 57) {
                nextStates.set(150);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_CONSTANTS_336(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 43 || ch == 45) {
                nextStates.set(32);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_CONSTANTS_337(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 89 || ch == 121) {
                nextStates.set(110);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_CONSTANTS_338(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch >= 48 && ch <= 57) {
                nextStates.set(68);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_CONSTANTS_339(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch >= 48 && ch <= 57) {
                nextStates.set(26);
                if (validTypes.contains((Object)QConstants.TokenType.T_DOUBLE)) {
                    return QConstants.TokenType.T_DOUBLE;
                }
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_CONSTANTS_340(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch >= 48 && ch <= 57) {
                nextStates.set(120);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_CONSTANTS_341(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch >= 48 && ch <= 57) {
                nextStates.set(402);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_CONSTANTS_342(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch >= 49 && ch <= 57) {
                nextStates.set(303);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_CONSTANTS_343(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 84 || ch == 116) {
                nextStates.set(119);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_CONSTANTS_344(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 87 || ch == 119) {
                nextStates.set(145);
                if (validTypes.contains((Object)QConstants.TokenType.T_DATETIMEINTERVAL)) {
                    return QConstants.TokenType.T_DATETIMEINTERVAL;
                }
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_CONSTANTS_345(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 77 || ch == 109) {
                nextStates.set(114);
                if (validTypes.contains((Object)QConstants.TokenType.T_DATETIMEINTERVAL)) {
                    return QConstants.TokenType.T_DATETIMEINTERVAL;
                }
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_CONSTANTS_346(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch >= 48 && ch <= 57) {
                nextStates.set(62);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_CONSTANTS_347(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch >= 48 && ch <= 57) {
                nextStates.set(323);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_CONSTANTS_348(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 43 || ch == 45) {
                nextStates.set(10);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_CONSTANTS_349(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 48) {
                nextStates.set(175);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_CONSTANTS_350(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 68 || ch == 100) {
                nextStates.set(111);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_CONSTANTS_351(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if ((ch == 83 || ch == 115) && validTypes.contains((Object)QConstants.TokenType.T_DATETIMEINTERVAL)) {
                return QConstants.TokenType.T_DATETIMEINTERVAL;
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_CONSTANTS_352(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 43 || ch == 45) {
                nextStates.set(56);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_CONSTANTS_353(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 39 && validTypes.contains((Object)QConstants.TokenType.T_DURATION)) {
                return QConstants.TokenType.T_DURATION;
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_CONSTANTS_354(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 80 || ch == 112) {
                nextStates.set(133);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_CONSTANTS_355(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch >= 49 && ch <= 57) {
                nextStates.set(346);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_CONSTANTS_356(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch >= 48 && ch <= 57) {
                nextStates.set(14);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_CONSTANTS_357(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 43 || ch == 45) {
                nextStates.set(77);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_CONSTANTS_358(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 47) {
                nextStates.set(17);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_CONSTANTS_359(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch >= 49 && ch <= 57) {
                nextStates.set(338);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_CONSTANTS_360(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch >= 48 && ch <= 57) {
                nextStates.set(324);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_CONSTANTS_361(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch >= 48 && ch <= 57) {
                nextStates.set(286);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_CONSTANTS_362(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 49) {
                nextStates.set(203);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_CONSTANTS_363(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 48) {
                nextStates.set(189);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_CONSTANTS_364(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 43 || ch == 45) {
                nextStates.set(74);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_CONSTANTS_365(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 44) {
                nextStates.set(442);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_CONSTANTS_366(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 50) {
                nextStates.set(217);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_CONSTANTS_367(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch >= 49 && ch <= 57) {
                nextStates.set(321);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_CONSTANTS_368(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 49) {
                nextStates.set(224);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_CONSTANTS_369(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 43 || ch == 45) {
                nextStates.set(126);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_CONSTANTS_370(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 43 || ch == 45) {
                nextStates.set(101);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_CONSTANTS_371(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 49) {
                nextStates.set(178);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_CONSTANTS_372(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch >= 48 && ch <= 57) {
                nextStates.set(476);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_CONSTANTS_373(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch >= 48 && ch <= 57) {
                nextStates.set(117);
                if (validTypes.contains((Object)QConstants.TokenType.T_DOUBLE)) {
                    return QConstants.TokenType.T_DOUBLE;
                }
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_CONSTANTS_374(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 72 || ch == 104) {
                nextStates.set(156);
                if (validTypes.contains((Object)QConstants.TokenType.T_DATETIMEINTERVAL)) {
                    return QConstants.TokenType.T_DATETIMEINTERVAL;
                }
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_CONSTANTS_375(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch >= 48 && ch <= 57) {
                nextStates.set(121);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_CONSTANTS_376(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 43 || ch == 45) {
                nextStates.set(152);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_CONSTANTS_377(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch >= 49 && ch <= 57) {
                nextStates.set(316);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_CONSTANTS_378(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch >= 49 && ch <= 57) {
                nextStates.set(440);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_CONSTANTS_379(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch >= 48 && ch <= 57) {
                nextStates.set(277);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_CONSTANTS_380(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch >= 49 && ch <= 57) {
                nextStates.set(340);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_CONSTANTS_381(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 48) {
                nextStates.set(244);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_CONSTANTS_382(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch >= 48 && ch <= 57) {
                nextStates.set(122);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_CONSTANTS_383(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 70 || ch == 102) {
                nextStates.set(182);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_CONSTANTS_384(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 45) {
                nextStates.set(282);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_CONSTANTS_385(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 77 || ch == 109) {
                nextStates.set(19);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_CONSTANTS_386(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch >= 49 && ch <= 57) {
                nextStates.set(477);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_CONSTANTS_387(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch >= 48 && ch <= 57) {
                nextStates.set(143);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_CONSTANTS_388(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 43 || ch == 45) {
                nextStates.set(139);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_CONSTANTS_389(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 83 || ch == 115) {
                nextStates.set(353);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_CONSTANTS_390(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 44) {
                nextStates.set(258);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_CONSTANTS_391(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 50) {
                nextStates.set(205);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_CONSTANTS_392(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 89 || ch == 121) {
                nextStates.set(4);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_CONSTANTS_393(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 87 || ch == 119) {
                nextStates.set(134);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_CONSTANTS_394(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 46) {
                nextStates.set(258);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_CONSTANTS_395(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 43 || ch == 45) {
                nextStates.set(55);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_CONSTANTS_396(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch >= 48 && ch <= 57) {
                nextStates.set(153);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_CONSTANTS_397(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 43 || ch == 45) {
                nextStates.set(140);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_CONSTANTS_398(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 43 || ch == 45) {
                nextStates.set(23);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_CONSTANTS_399(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch >= 48 && ch <= 57) {
                nextStates.set(454);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_CONSTANTS_400(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 49) {
                nextStates.set(168);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_CONSTANTS_401(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch >= 48 && ch <= 57) {
                nextStates.set(89);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_CONSTANTS_402(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 87 || ch == 119) {
                nextStates.set(88);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_CONSTANTS_403(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 48) {
                nextStates.set(249);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_CONSTANTS_404(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch >= 48 && ch <= 57) {
                nextStates.set(104);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_CONSTANTS_405(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch >= 48 && ch <= 50) {
                nextStates.set(220);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_CONSTANTS_406(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch >= 49 && ch <= 57) {
                nextStates.set(498);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_CONSTANTS_407(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 43 || ch == 45) {
                nextStates.set(39);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_CONSTANTS_408(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 43 || ch == 45) {
                nextStates.set(34);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_CONSTANTS_409(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch >= 49 && ch <= 57) {
                nextStates.set(445);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_CONSTANTS_410(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch >= 49 && ch <= 57) {
                nextStates.set(335);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_CONSTANTS_411(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 90 || ch == 122) {
                nextStates.set(358);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_CONSTANTS_412(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch >= 48 && ch <= 57) {
                nextStates.set(389);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_CONSTANTS_413(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 49) {
                nextStates.set(204);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_CONSTANTS_414(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 48) {
                nextStates.set(225);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_CONSTANTS_415(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 46) {
                nextStates.set(442);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_CONSTANTS_416(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch >= 48 && ch <= 57) {
                nextStates.set(345);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_CONSTANTS_417(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 43 || ch == 45) {
                nextStates.set(93);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_CONSTANTS_418(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 48) {
                nextStates.set(266);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_CONSTANTS_419(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 49) {
                nextStates.set(246);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_CONSTANTS_420(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch >= 49 && ch <= 57) {
                nextStates.set(356);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_CONSTANTS_421(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 51) {
                nextStates.set(198);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_CONSTANTS_422(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch >= 48 && ch <= 57) {
                nextStates.set(13);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_CONSTANTS_423(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch >= 48 && ch <= 57) {
                nextStates.set(3);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_CONSTANTS_424(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 80 || ch == 112) {
                nextStates.set(41);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_CONSTANTS_425(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch >= 48 && ch <= 57) {
                nextStates.set(154);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_CONSTANTS_426(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 49) {
                nextStates.set(264);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_CONSTANTS_427(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 72 || ch == 104) {
                nextStates.set(82);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_CONSTANTS_428(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch >= 48 && ch <= 57) {
                nextStates.set(67);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_CONSTANTS_429(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 43 || ch == 45) {
                nextStates.set(127);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_CONSTANTS_430(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch >= 48 && ch <= 57) {
                nextStates.set(123);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_CONSTANTS_431(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch >= 48 && ch <= 57) {
                nextStates.set(61);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_CONSTANTS_432(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch >= 48 && ch <= 57) {
                nextStates.set(463);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_CONSTANTS_433(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 46) {
                nextStates.set(299);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_CONSTANTS_434(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch >= 48 && ch <= 57) {
                nextStates.set(60);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_CONSTANTS_435(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 89 || ch == 121) {
                nextStates.set(128);
                if (validTypes.contains((Object)QConstants.TokenType.T_DATETIMEINTERVAL)) {
                    return QConstants.TokenType.T_DATETIMEINTERVAL;
                }
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_CONSTANTS_436(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch >= 48 && ch <= 57) {
                nextStates.set(16);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_CONSTANTS_437(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch >= 48 && ch <= 57) {
                nextStates.set(318);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_CONSTANTS_438(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 49) {
                nextStates.set(260);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_CONSTANTS_439(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch >= 48 && ch <= 57) {
                nextStates.set(130);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_CONSTANTS_440(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch >= 48 && ch <= 57) {
                nextStates.set(147);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_CONSTANTS_441(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch >= 49 && ch <= 57) {
                nextStates.set(382);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_CONSTANTS_442(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch >= 48 && ch <= 57) {
                nextStates.set(28);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_CONSTANTS_443(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch >= 48 && ch <= 50) {
                nextStates.set(250);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_CONSTANTS_444(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 48) {
                nextStates.set(229);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_CONSTANTS_445(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch >= 48 && ch <= 57) {
                nextStates.set(21);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_CONSTANTS_446(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch >= 49 && ch <= 57) {
                nextStates.set(425);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_CONSTANTS_447(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch >= 0 && ch <= 38 || ch >= 40) {
                nextStates.set(31);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_CONSTANTS_448(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 50) {
                nextStates.set(206);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_CONSTANTS_449(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 46) {
                nextStates.set(124);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_CONSTANTS_450(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 48) {
                nextStates.set(181);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_CONSTANTS_451(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch >= 48 && ch <= 57) {
                nextStates.set(24);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_CONSTANTS_452(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 43 || ch == 45) {
                nextStates.set(47);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_CONSTANTS_453(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch >= 48 && ch <= 57 && validTypes.contains((Object)QConstants.TokenType.T_LONG)) {
                return QConstants.TokenType.T_LONG;
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_CONSTANTS_454(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 72 || ch == 104) {
                nextStates.set(9);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_CONSTANTS_455(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 50) {
                nextStates.set(216);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_CONSTANTS_456(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 51) {
                nextStates.set(186);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_CONSTANTS_457(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch >= 49 && ch <= 57) {
                nextStates.set(245);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_CONSTANTS_458(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 43 || ch == 45) {
                nextStates.set(424);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_CONSTANTS_459(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 58) {
                nextStates.set(162);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_CONSTANTS_460(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch >= 48 && ch <= 50) {
                nextStates.set(240);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_CONSTANTS_461(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch >= 48 && ch <= 57) {
                nextStates.set(351);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_CONSTANTS_462(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 69 || ch == 101) {
                nextStates.set(118);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_CONSTANTS_463(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 83 || ch == 115) {
                nextStates.set(358);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_CONSTANTS_464(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 49) {
                nextStates.set(234);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_CONSTANTS_465(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch >= 49 && ch <= 57) {
                nextStates.set(467);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_CONSTANTS_466(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 77 || ch == 109) {
                nextStates.set(135);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_CONSTANTS_467(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch >= 48 && ch <= 57) {
                nextStates.set(1);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_CONSTANTS_468(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 43 || ch == 45) {
                nextStates.set(327);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_CONSTANTS_469(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 43 || ch == 45) {
                nextStates.set(58);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_CONSTANTS_470(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch >= 49 && ch <= 57) {
                nextStates.set(434);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_CONSTANTS_471(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch >= 48 && ch <= 57) {
                nextStates.set(292);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_CONSTANTS_472(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch >= 48 && ch <= 57) {
                nextStates.set(435);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_CONSTANTS_473(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch >= 49 && ch <= 57) {
                nextStates.set(423);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_CONSTANTS_474(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 43 || ch == 45) {
                nextStates.set(115);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_CONSTANTS_475(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch >= 49 && ch <= 57) {
                nextStates.set(339);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_CONSTANTS_476(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 45) {
                nextStates.set(151);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_CONSTANTS_477(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch >= 48 && ch <= 57) {
                nextStates.set(125);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_CONSTANTS_478(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch >= 0 && ch <= 38 || ch >= 40) {
                nextStates.set(18);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_CONSTANTS_479(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 49) {
                nextStates.set(196);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_CONSTANTS_480(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 49) {
                nextStates.set(221);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_CONSTANTS_481(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 43 || ch == 45) {
                nextStates.set(51);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_CONSTANTS_482(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 43 || ch == 45) {
                nextStates.set(64);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_CONSTANTS_483(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 50) {
                nextStates.set(210);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_CONSTANTS_484(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch >= 49 && ch <= 57) {
                nextStates.set(439);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_CONSTANTS_485(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 43 || ch == 45) {
                nextStates.set(132);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_CONSTANTS_486(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 43 || ch == 45) {
                nextStates.set(96);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_CONSTANTS_487(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch >= 48 && ch <= 57) {
                nextStates.set(374);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_CONSTANTS_488(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch >= 48 && ch <= 57) {
                nextStates.set(392);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_CONSTANTS_489(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 45) {
                nextStates.set(76);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_CONSTANTS_490(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch >= 49 && ch <= 57) {
                nextStates.set(436);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_CONSTANTS_491(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch >= 49 && ch <= 57) {
                nextStates.set(396);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_CONSTANTS_492(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch >= 48 && ch <= 57) {
                nextStates.set(85);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_CONSTANTS_493(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch >= 49 && ch <= 57) {
                nextStates.set(375);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_CONSTANTS_494(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch >= 49 && ch <= 57) {
                nextStates.set(431);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_CONSTANTS_495(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 43 || ch == 45) {
                nextStates.set(35);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_CONSTANTS_496(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 43 || ch == 45) {
                nextStates.set(92);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_CONSTANTS_497(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch >= 49 && ch <= 57) {
                nextStates.set(401);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_CONSTANTS_498(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch >= 48 && ch <= 57) {
                nextStates.set(157);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_CONSTANTS_499(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 84 || ch == 116) {
                nextStates.set(95);
                if (validTypes.contains((Object)QConstants.TokenType.T_DATETIMEINTERVAL)) {
                    return QConstants.TokenType.T_DATETIMEINTERVAL;
                }
            }
            return null;
        }

        private static void NFA_FUNCTIONS_init() {
            NfaFunction[] functions = new NfaFunction[]{LS_CONSTANTS::NFA_COMPOSITE_LS_CONSTANTS_0, LS_CONSTANTS::NFA_COMPOSITE_LS_CONSTANTS_1, LS_CONSTANTS::NFA_COMPOSITE_LS_CONSTANTS_2, LS_CONSTANTS::NFA_COMPOSITE_LS_CONSTANTS_3, LS_CONSTANTS::NFA_COMPOSITE_LS_CONSTANTS_4, LS_CONSTANTS::NFA_COMPOSITE_LS_CONSTANTS_5, LS_CONSTANTS::NFA_COMPOSITE_LS_CONSTANTS_6, LS_CONSTANTS::NFA_COMPOSITE_LS_CONSTANTS_7, LS_CONSTANTS::NFA_COMPOSITE_LS_CONSTANTS_8, LS_CONSTANTS::NFA_COMPOSITE_LS_CONSTANTS_9, LS_CONSTANTS::NFA_COMPOSITE_LS_CONSTANTS_10, LS_CONSTANTS::NFA_COMPOSITE_LS_CONSTANTS_11, LS_CONSTANTS::NFA_COMPOSITE_LS_CONSTANTS_12, LS_CONSTANTS::NFA_COMPOSITE_LS_CONSTANTS_13, LS_CONSTANTS::NFA_COMPOSITE_LS_CONSTANTS_14, LS_CONSTANTS::NFA_COMPOSITE_LS_CONSTANTS_15, LS_CONSTANTS::NFA_COMPOSITE_LS_CONSTANTS_16, LS_CONSTANTS::NFA_COMPOSITE_LS_CONSTANTS_17, LS_CONSTANTS::NFA_COMPOSITE_LS_CONSTANTS_18, LS_CONSTANTS::NFA_COMPOSITE_LS_CONSTANTS_19, LS_CONSTANTS::NFA_COMPOSITE_LS_CONSTANTS_20, LS_CONSTANTS::NFA_COMPOSITE_LS_CONSTANTS_21, LS_CONSTANTS::NFA_COMPOSITE_LS_CONSTANTS_22, LS_CONSTANTS::NFA_COMPOSITE_LS_CONSTANTS_23, LS_CONSTANTS::NFA_COMPOSITE_LS_CONSTANTS_24, LS_CONSTANTS::NFA_COMPOSITE_LS_CONSTANTS_25, LS_CONSTANTS::NFA_COMPOSITE_LS_CONSTANTS_26, LS_CONSTANTS::NFA_COMPOSITE_LS_CONSTANTS_27, LS_CONSTANTS::NFA_COMPOSITE_LS_CONSTANTS_28, LS_CONSTANTS::NFA_COMPOSITE_LS_CONSTANTS_29, LS_CONSTANTS::NFA_COMPOSITE_LS_CONSTANTS_30, LS_CONSTANTS::NFA_COMPOSITE_LS_CONSTANTS_31, LS_CONSTANTS::NFA_COMPOSITE_LS_CONSTANTS_32, LS_CONSTANTS::NFA_COMPOSITE_LS_CONSTANTS_33, LS_CONSTANTS::NFA_COMPOSITE_LS_CONSTANTS_34, LS_CONSTANTS::NFA_COMPOSITE_LS_CONSTANTS_35, LS_CONSTANTS::NFA_COMPOSITE_LS_CONSTANTS_36, LS_CONSTANTS::NFA_COMPOSITE_LS_CONSTANTS_37, LS_CONSTANTS::NFA_COMPOSITE_LS_CONSTANTS_38, LS_CONSTANTS::NFA_COMPOSITE_LS_CONSTANTS_39, LS_CONSTANTS::NFA_COMPOSITE_LS_CONSTANTS_40, LS_CONSTANTS::NFA_COMPOSITE_LS_CONSTANTS_41, LS_CONSTANTS::NFA_COMPOSITE_LS_CONSTANTS_42, LS_CONSTANTS::NFA_COMPOSITE_LS_CONSTANTS_43, LS_CONSTANTS::NFA_COMPOSITE_LS_CONSTANTS_44, LS_CONSTANTS::NFA_COMPOSITE_LS_CONSTANTS_45, LS_CONSTANTS::NFA_COMPOSITE_LS_CONSTANTS_46, LS_CONSTANTS::NFA_COMPOSITE_LS_CONSTANTS_47, LS_CONSTANTS::NFA_COMPOSITE_LS_CONSTANTS_48, LS_CONSTANTS::NFA_COMPOSITE_LS_CONSTANTS_49, LS_CONSTANTS::NFA_COMPOSITE_LS_CONSTANTS_50, LS_CONSTANTS::NFA_COMPOSITE_LS_CONSTANTS_51, LS_CONSTANTS::NFA_COMPOSITE_LS_CONSTANTS_52, LS_CONSTANTS::NFA_COMPOSITE_LS_CONSTANTS_53, LS_CONSTANTS::NFA_COMPOSITE_LS_CONSTANTS_54, LS_CONSTANTS::NFA_COMPOSITE_LS_CONSTANTS_55, LS_CONSTANTS::NFA_COMPOSITE_LS_CONSTANTS_56, LS_CONSTANTS::NFA_COMPOSITE_LS_CONSTANTS_57, LS_CONSTANTS::NFA_COMPOSITE_LS_CONSTANTS_58, LS_CONSTANTS::NFA_COMPOSITE_LS_CONSTANTS_59, LS_CONSTANTS::NFA_COMPOSITE_LS_CONSTANTS_60, LS_CONSTANTS::NFA_COMPOSITE_LS_CONSTANTS_61, LS_CONSTANTS::NFA_COMPOSITE_LS_CONSTANTS_62, LS_CONSTANTS::NFA_COMPOSITE_LS_CONSTANTS_63, LS_CONSTANTS::NFA_COMPOSITE_LS_CONSTANTS_64, LS_CONSTANTS::NFA_COMPOSITE_LS_CONSTANTS_65, LS_CONSTANTS::NFA_COMPOSITE_LS_CONSTANTS_66, LS_CONSTANTS::NFA_COMPOSITE_LS_CONSTANTS_67, LS_CONSTANTS::NFA_COMPOSITE_LS_CONSTANTS_68, LS_CONSTANTS::NFA_COMPOSITE_LS_CONSTANTS_69, LS_CONSTANTS::NFA_COMPOSITE_LS_CONSTANTS_70, LS_CONSTANTS::NFA_COMPOSITE_LS_CONSTANTS_71, LS_CONSTANTS::NFA_COMPOSITE_LS_CONSTANTS_72, LS_CONSTANTS::NFA_COMPOSITE_LS_CONSTANTS_73, LS_CONSTANTS::NFA_COMPOSITE_LS_CONSTANTS_74, LS_CONSTANTS::NFA_COMPOSITE_LS_CONSTANTS_75, LS_CONSTANTS::NFA_COMPOSITE_LS_CONSTANTS_76, LS_CONSTANTS::NFA_COMPOSITE_LS_CONSTANTS_77, LS_CONSTANTS::NFA_COMPOSITE_LS_CONSTANTS_78, LS_CONSTANTS::NFA_COMPOSITE_LS_CONSTANTS_79, LS_CONSTANTS::NFA_COMPOSITE_LS_CONSTANTS_80, LS_CONSTANTS::NFA_COMPOSITE_LS_CONSTANTS_81, LS_CONSTANTS::NFA_COMPOSITE_LS_CONSTANTS_82, LS_CONSTANTS::NFA_COMPOSITE_LS_CONSTANTS_83, LS_CONSTANTS::NFA_COMPOSITE_LS_CONSTANTS_84, LS_CONSTANTS::NFA_COMPOSITE_LS_CONSTANTS_85, LS_CONSTANTS::NFA_COMPOSITE_LS_CONSTANTS_86, LS_CONSTANTS::NFA_COMPOSITE_LS_CONSTANTS_87, LS_CONSTANTS::NFA_COMPOSITE_LS_CONSTANTS_88, LS_CONSTANTS::NFA_COMPOSITE_LS_CONSTANTS_89, LS_CONSTANTS::NFA_COMPOSITE_LS_CONSTANTS_90, LS_CONSTANTS::NFA_COMPOSITE_LS_CONSTANTS_91, LS_CONSTANTS::NFA_COMPOSITE_LS_CONSTANTS_92, LS_CONSTANTS::NFA_COMPOSITE_LS_CONSTANTS_93, LS_CONSTANTS::NFA_COMPOSITE_LS_CONSTANTS_94, LS_CONSTANTS::NFA_COMPOSITE_LS_CONSTANTS_95, LS_CONSTANTS::NFA_COMPOSITE_LS_CONSTANTS_96, LS_CONSTANTS::NFA_COMPOSITE_LS_CONSTANTS_97, LS_CONSTANTS::NFA_COMPOSITE_LS_CONSTANTS_98, LS_CONSTANTS::NFA_COMPOSITE_LS_CONSTANTS_99, LS_CONSTANTS::NFA_COMPOSITE_LS_CONSTANTS_100, LS_CONSTANTS::NFA_COMPOSITE_LS_CONSTANTS_101, LS_CONSTANTS::NFA_COMPOSITE_LS_CONSTANTS_102, LS_CONSTANTS::NFA_COMPOSITE_LS_CONSTANTS_103, LS_CONSTANTS::NFA_COMPOSITE_LS_CONSTANTS_104, LS_CONSTANTS::NFA_COMPOSITE_LS_CONSTANTS_105, LS_CONSTANTS::NFA_COMPOSITE_LS_CONSTANTS_106, LS_CONSTANTS::NFA_COMPOSITE_LS_CONSTANTS_107, LS_CONSTANTS::NFA_COMPOSITE_LS_CONSTANTS_108, LS_CONSTANTS::NFA_COMPOSITE_LS_CONSTANTS_109, LS_CONSTANTS::NFA_COMPOSITE_LS_CONSTANTS_110, LS_CONSTANTS::NFA_COMPOSITE_LS_CONSTANTS_111, LS_CONSTANTS::NFA_COMPOSITE_LS_CONSTANTS_112, LS_CONSTANTS::NFA_COMPOSITE_LS_CONSTANTS_113, LS_CONSTANTS::NFA_COMPOSITE_LS_CONSTANTS_114, LS_CONSTANTS::NFA_COMPOSITE_LS_CONSTANTS_115, LS_CONSTANTS::NFA_COMPOSITE_LS_CONSTANTS_116, LS_CONSTANTS::NFA_COMPOSITE_LS_CONSTANTS_117, LS_CONSTANTS::NFA_COMPOSITE_LS_CONSTANTS_118, LS_CONSTANTS::NFA_COMPOSITE_LS_CONSTANTS_119, LS_CONSTANTS::NFA_COMPOSITE_LS_CONSTANTS_120, LS_CONSTANTS::NFA_COMPOSITE_LS_CONSTANTS_121, LS_CONSTANTS::NFA_COMPOSITE_LS_CONSTANTS_122, LS_CONSTANTS::NFA_COMPOSITE_LS_CONSTANTS_123, LS_CONSTANTS::NFA_COMPOSITE_LS_CONSTANTS_124, LS_CONSTANTS::NFA_COMPOSITE_LS_CONSTANTS_125, LS_CONSTANTS::NFA_COMPOSITE_LS_CONSTANTS_126, LS_CONSTANTS::NFA_COMPOSITE_LS_CONSTANTS_127, LS_CONSTANTS::NFA_COMPOSITE_LS_CONSTANTS_128, LS_CONSTANTS::NFA_COMPOSITE_LS_CONSTANTS_129, LS_CONSTANTS::NFA_COMPOSITE_LS_CONSTANTS_130, LS_CONSTANTS::NFA_COMPOSITE_LS_CONSTANTS_131, LS_CONSTANTS::NFA_COMPOSITE_LS_CONSTANTS_132, LS_CONSTANTS::NFA_COMPOSITE_LS_CONSTANTS_133, LS_CONSTANTS::NFA_COMPOSITE_LS_CONSTANTS_134, LS_CONSTANTS::NFA_COMPOSITE_LS_CONSTANTS_135, LS_CONSTANTS::NFA_COMPOSITE_LS_CONSTANTS_136, LS_CONSTANTS::NFA_COMPOSITE_LS_CONSTANTS_137, LS_CONSTANTS::NFA_COMPOSITE_LS_CONSTANTS_138, LS_CONSTANTS::NFA_COMPOSITE_LS_CONSTANTS_139, LS_CONSTANTS::NFA_COMPOSITE_LS_CONSTANTS_140, LS_CONSTANTS::NFA_COMPOSITE_LS_CONSTANTS_141, LS_CONSTANTS::NFA_COMPOSITE_LS_CONSTANTS_142, LS_CONSTANTS::NFA_COMPOSITE_LS_CONSTANTS_143, LS_CONSTANTS::NFA_COMPOSITE_LS_CONSTANTS_144, LS_CONSTANTS::NFA_COMPOSITE_LS_CONSTANTS_145, LS_CONSTANTS::NFA_COMPOSITE_LS_CONSTANTS_146, LS_CONSTANTS::NFA_COMPOSITE_LS_CONSTANTS_147, LS_CONSTANTS::NFA_COMPOSITE_LS_CONSTANTS_148, LS_CONSTANTS::NFA_COMPOSITE_LS_CONSTANTS_149, LS_CONSTANTS::NFA_COMPOSITE_LS_CONSTANTS_150, LS_CONSTANTS::NFA_COMPOSITE_LS_CONSTANTS_151, LS_CONSTANTS::NFA_COMPOSITE_LS_CONSTANTS_152, LS_CONSTANTS::NFA_COMPOSITE_LS_CONSTANTS_153, LS_CONSTANTS::NFA_COMPOSITE_LS_CONSTANTS_154, LS_CONSTANTS::NFA_COMPOSITE_LS_CONSTANTS_155, LS_CONSTANTS::NFA_COMPOSITE_LS_CONSTANTS_156, LS_CONSTANTS::NFA_COMPOSITE_LS_CONSTANTS_157, LS_CONSTANTS::NFA_LS_CONSTANTS_158, LS_CONSTANTS::NFA_LS_CONSTANTS_159, LS_CONSTANTS::NFA_LS_CONSTANTS_160, LS_CONSTANTS::NFA_LS_CONSTANTS_161, LS_CONSTANTS::NFA_LS_CONSTANTS_162, LS_CONSTANTS::NFA_LS_CONSTANTS_163, LS_CONSTANTS::NFA_LS_CONSTANTS_164, LS_CONSTANTS::NFA_LS_CONSTANTS_165, LS_CONSTANTS::NFA_LS_CONSTANTS_166, LS_CONSTANTS::NFA_LS_CONSTANTS_167, LS_CONSTANTS::NFA_LS_CONSTANTS_168, LS_CONSTANTS::NFA_LS_CONSTANTS_169, LS_CONSTANTS::NFA_LS_CONSTANTS_170, LS_CONSTANTS::NFA_LS_CONSTANTS_171, LS_CONSTANTS::NFA_LS_CONSTANTS_172, LS_CONSTANTS::NFA_LS_CONSTANTS_173, LS_CONSTANTS::NFA_LS_CONSTANTS_174, LS_CONSTANTS::NFA_LS_CONSTANTS_175, LS_CONSTANTS::NFA_LS_CONSTANTS_176, LS_CONSTANTS::NFA_LS_CONSTANTS_177, LS_CONSTANTS::NFA_LS_CONSTANTS_178, LS_CONSTANTS::NFA_LS_CONSTANTS_179, LS_CONSTANTS::NFA_LS_CONSTANTS_180, LS_CONSTANTS::NFA_LS_CONSTANTS_181, LS_CONSTANTS::NFA_LS_CONSTANTS_182, LS_CONSTANTS::NFA_LS_CONSTANTS_183, LS_CONSTANTS::NFA_LS_CONSTANTS_184, LS_CONSTANTS::NFA_LS_CONSTANTS_185, LS_CONSTANTS::NFA_LS_CONSTANTS_186, LS_CONSTANTS::NFA_LS_CONSTANTS_187, LS_CONSTANTS::NFA_LS_CONSTANTS_188, LS_CONSTANTS::NFA_LS_CONSTANTS_189, LS_CONSTANTS::NFA_LS_CONSTANTS_190, LS_CONSTANTS::NFA_LS_CONSTANTS_191, LS_CONSTANTS::NFA_LS_CONSTANTS_192, LS_CONSTANTS::NFA_LS_CONSTANTS_193, LS_CONSTANTS::NFA_LS_CONSTANTS_194, LS_CONSTANTS::NFA_LS_CONSTANTS_195, LS_CONSTANTS::NFA_LS_CONSTANTS_196, LS_CONSTANTS::NFA_LS_CONSTANTS_197, LS_CONSTANTS::NFA_LS_CONSTANTS_198, LS_CONSTANTS::NFA_LS_CONSTANTS_199, LS_CONSTANTS::NFA_LS_CONSTANTS_200, LS_CONSTANTS::NFA_LS_CONSTANTS_201, LS_CONSTANTS::NFA_LS_CONSTANTS_202, LS_CONSTANTS::NFA_LS_CONSTANTS_203, LS_CONSTANTS::NFA_LS_CONSTANTS_204, LS_CONSTANTS::NFA_LS_CONSTANTS_205, LS_CONSTANTS::NFA_LS_CONSTANTS_206, LS_CONSTANTS::NFA_LS_CONSTANTS_207, LS_CONSTANTS::NFA_LS_CONSTANTS_208, LS_CONSTANTS::NFA_LS_CONSTANTS_209, LS_CONSTANTS::NFA_LS_CONSTANTS_210, LS_CONSTANTS::NFA_LS_CONSTANTS_211, LS_CONSTANTS::NFA_LS_CONSTANTS_212, LS_CONSTANTS::NFA_LS_CONSTANTS_213, LS_CONSTANTS::NFA_LS_CONSTANTS_214, LS_CONSTANTS::NFA_LS_CONSTANTS_215, LS_CONSTANTS::NFA_LS_CONSTANTS_216, LS_CONSTANTS::NFA_LS_CONSTANTS_217, LS_CONSTANTS::NFA_LS_CONSTANTS_218, LS_CONSTANTS::NFA_LS_CONSTANTS_219, LS_CONSTANTS::NFA_LS_CONSTANTS_220, LS_CONSTANTS::NFA_LS_CONSTANTS_221, LS_CONSTANTS::NFA_LS_CONSTANTS_222, LS_CONSTANTS::NFA_LS_CONSTANTS_223, LS_CONSTANTS::NFA_LS_CONSTANTS_224, LS_CONSTANTS::NFA_LS_CONSTANTS_225, LS_CONSTANTS::NFA_LS_CONSTANTS_226, LS_CONSTANTS::NFA_LS_CONSTANTS_227, LS_CONSTANTS::NFA_LS_CONSTANTS_228, LS_CONSTANTS::NFA_LS_CONSTANTS_229, LS_CONSTANTS::NFA_LS_CONSTANTS_230, LS_CONSTANTS::NFA_LS_CONSTANTS_231, LS_CONSTANTS::NFA_LS_CONSTANTS_232, LS_CONSTANTS::NFA_LS_CONSTANTS_233, LS_CONSTANTS::NFA_LS_CONSTANTS_234, LS_CONSTANTS::NFA_LS_CONSTANTS_235, LS_CONSTANTS::NFA_LS_CONSTANTS_236, LS_CONSTANTS::NFA_LS_CONSTANTS_237, LS_CONSTANTS::NFA_LS_CONSTANTS_238, LS_CONSTANTS::NFA_LS_CONSTANTS_239, LS_CONSTANTS::NFA_LS_CONSTANTS_240, LS_CONSTANTS::NFA_LS_CONSTANTS_241, LS_CONSTANTS::NFA_LS_CONSTANTS_242, LS_CONSTANTS::NFA_LS_CONSTANTS_243, LS_CONSTANTS::NFA_LS_CONSTANTS_244, LS_CONSTANTS::NFA_LS_CONSTANTS_245, LS_CONSTANTS::NFA_LS_CONSTANTS_246, LS_CONSTANTS::NFA_LS_CONSTANTS_247, LS_CONSTANTS::NFA_LS_CONSTANTS_248, LS_CONSTANTS::NFA_LS_CONSTANTS_249, LS_CONSTANTS::NFA_LS_CONSTANTS_250, LS_CONSTANTS::NFA_LS_CONSTANTS_251, LS_CONSTANTS::NFA_LS_CONSTANTS_252, LS_CONSTANTS::NFA_LS_CONSTANTS_253, LS_CONSTANTS::NFA_LS_CONSTANTS_254, LS_CONSTANTS::NFA_LS_CONSTANTS_255, LS_CONSTANTS::NFA_LS_CONSTANTS_256, LS_CONSTANTS::NFA_LS_CONSTANTS_257, LS_CONSTANTS::NFA_LS_CONSTANTS_258, LS_CONSTANTS::NFA_LS_CONSTANTS_259, LS_CONSTANTS::NFA_LS_CONSTANTS_260, LS_CONSTANTS::NFA_LS_CONSTANTS_261, LS_CONSTANTS::NFA_LS_CONSTANTS_262, LS_CONSTANTS::NFA_LS_CONSTANTS_263, LS_CONSTANTS::NFA_LS_CONSTANTS_264, LS_CONSTANTS::NFA_LS_CONSTANTS_265, LS_CONSTANTS::NFA_LS_CONSTANTS_266, LS_CONSTANTS::NFA_LS_CONSTANTS_267, LS_CONSTANTS::NFA_LS_CONSTANTS_268, LS_CONSTANTS::NFA_LS_CONSTANTS_269, LS_CONSTANTS::NFA_LS_CONSTANTS_270, LS_CONSTANTS::NFA_LS_CONSTANTS_271, LS_CONSTANTS::NFA_LS_CONSTANTS_272, LS_CONSTANTS::NFA_LS_CONSTANTS_273, LS_CONSTANTS::NFA_LS_CONSTANTS_274, LS_CONSTANTS::NFA_LS_CONSTANTS_275, LS_CONSTANTS::NFA_LS_CONSTANTS_276, LS_CONSTANTS::NFA_LS_CONSTANTS_277, LS_CONSTANTS::NFA_LS_CONSTANTS_278, LS_CONSTANTS::NFA_LS_CONSTANTS_279, LS_CONSTANTS::NFA_LS_CONSTANTS_280, LS_CONSTANTS::NFA_LS_CONSTANTS_281, LS_CONSTANTS::NFA_LS_CONSTANTS_282, LS_CONSTANTS::NFA_LS_CONSTANTS_283, LS_CONSTANTS::NFA_LS_CONSTANTS_284, LS_CONSTANTS::NFA_LS_CONSTANTS_285, LS_CONSTANTS::NFA_LS_CONSTANTS_286, LS_CONSTANTS::NFA_LS_CONSTANTS_287, LS_CONSTANTS::NFA_LS_CONSTANTS_288, LS_CONSTANTS::NFA_LS_CONSTANTS_289, LS_CONSTANTS::NFA_LS_CONSTANTS_290, LS_CONSTANTS::NFA_LS_CONSTANTS_291, LS_CONSTANTS::NFA_LS_CONSTANTS_292, LS_CONSTANTS::NFA_LS_CONSTANTS_293, LS_CONSTANTS::NFA_LS_CONSTANTS_294, LS_CONSTANTS::NFA_LS_CONSTANTS_295, LS_CONSTANTS::NFA_LS_CONSTANTS_296, LS_CONSTANTS::NFA_LS_CONSTANTS_297, LS_CONSTANTS::NFA_LS_CONSTANTS_298, LS_CONSTANTS::NFA_LS_CONSTANTS_299, LS_CONSTANTS::NFA_LS_CONSTANTS_300, LS_CONSTANTS::NFA_LS_CONSTANTS_301, LS_CONSTANTS::NFA_LS_CONSTANTS_302, LS_CONSTANTS::NFA_LS_CONSTANTS_303, LS_CONSTANTS::NFA_LS_CONSTANTS_304, LS_CONSTANTS::NFA_LS_CONSTANTS_305, LS_CONSTANTS::NFA_LS_CONSTANTS_306, LS_CONSTANTS::NFA_LS_CONSTANTS_307, LS_CONSTANTS::NFA_LS_CONSTANTS_308, LS_CONSTANTS::NFA_LS_CONSTANTS_309, LS_CONSTANTS::NFA_LS_CONSTANTS_310, LS_CONSTANTS::NFA_LS_CONSTANTS_311, LS_CONSTANTS::NFA_LS_CONSTANTS_312, LS_CONSTANTS::NFA_LS_CONSTANTS_313, LS_CONSTANTS::NFA_LS_CONSTANTS_314, LS_CONSTANTS::NFA_LS_CONSTANTS_315, LS_CONSTANTS::NFA_LS_CONSTANTS_316, LS_CONSTANTS::NFA_LS_CONSTANTS_317, LS_CONSTANTS::NFA_LS_CONSTANTS_318, LS_CONSTANTS::NFA_LS_CONSTANTS_319, LS_CONSTANTS::NFA_LS_CONSTANTS_320, LS_CONSTANTS::NFA_LS_CONSTANTS_321, LS_CONSTANTS::NFA_LS_CONSTANTS_322, LS_CONSTANTS::NFA_LS_CONSTANTS_323, LS_CONSTANTS::NFA_LS_CONSTANTS_324, LS_CONSTANTS::NFA_LS_CONSTANTS_325, LS_CONSTANTS::NFA_LS_CONSTANTS_326, LS_CONSTANTS::NFA_LS_CONSTANTS_327, LS_CONSTANTS::NFA_LS_CONSTANTS_328, LS_CONSTANTS::NFA_LS_CONSTANTS_329, LS_CONSTANTS::NFA_LS_CONSTANTS_330, LS_CONSTANTS::NFA_LS_CONSTANTS_331, LS_CONSTANTS::NFA_LS_CONSTANTS_332, LS_CONSTANTS::NFA_LS_CONSTANTS_333, LS_CONSTANTS::NFA_LS_CONSTANTS_334, LS_CONSTANTS::NFA_LS_CONSTANTS_335, LS_CONSTANTS::NFA_LS_CONSTANTS_336, LS_CONSTANTS::NFA_LS_CONSTANTS_337, LS_CONSTANTS::NFA_LS_CONSTANTS_338, LS_CONSTANTS::NFA_LS_CONSTANTS_339, LS_CONSTANTS::NFA_LS_CONSTANTS_340, LS_CONSTANTS::NFA_LS_CONSTANTS_341, LS_CONSTANTS::NFA_LS_CONSTANTS_342, LS_CONSTANTS::NFA_LS_CONSTANTS_343, LS_CONSTANTS::NFA_LS_CONSTANTS_344, LS_CONSTANTS::NFA_LS_CONSTANTS_345, LS_CONSTANTS::NFA_LS_CONSTANTS_346, LS_CONSTANTS::NFA_LS_CONSTANTS_347, LS_CONSTANTS::NFA_LS_CONSTANTS_348, LS_CONSTANTS::NFA_LS_CONSTANTS_349, LS_CONSTANTS::NFA_LS_CONSTANTS_350, LS_CONSTANTS::NFA_LS_CONSTANTS_351, LS_CONSTANTS::NFA_LS_CONSTANTS_352, LS_CONSTANTS::NFA_LS_CONSTANTS_353, LS_CONSTANTS::NFA_LS_CONSTANTS_354, LS_CONSTANTS::NFA_LS_CONSTANTS_355, LS_CONSTANTS::NFA_LS_CONSTANTS_356, LS_CONSTANTS::NFA_LS_CONSTANTS_357, LS_CONSTANTS::NFA_LS_CONSTANTS_358, LS_CONSTANTS::NFA_LS_CONSTANTS_359, LS_CONSTANTS::NFA_LS_CONSTANTS_360, LS_CONSTANTS::NFA_LS_CONSTANTS_361, LS_CONSTANTS::NFA_LS_CONSTANTS_362, LS_CONSTANTS::NFA_LS_CONSTANTS_363, LS_CONSTANTS::NFA_LS_CONSTANTS_364, LS_CONSTANTS::NFA_LS_CONSTANTS_365, LS_CONSTANTS::NFA_LS_CONSTANTS_366, LS_CONSTANTS::NFA_LS_CONSTANTS_367, LS_CONSTANTS::NFA_LS_CONSTANTS_368, LS_CONSTANTS::NFA_LS_CONSTANTS_369, LS_CONSTANTS::NFA_LS_CONSTANTS_370, LS_CONSTANTS::NFA_LS_CONSTANTS_371, LS_CONSTANTS::NFA_LS_CONSTANTS_372, LS_CONSTANTS::NFA_LS_CONSTANTS_373, LS_CONSTANTS::NFA_LS_CONSTANTS_374, LS_CONSTANTS::NFA_LS_CONSTANTS_375, LS_CONSTANTS::NFA_LS_CONSTANTS_376, LS_CONSTANTS::NFA_LS_CONSTANTS_377, LS_CONSTANTS::NFA_LS_CONSTANTS_378, LS_CONSTANTS::NFA_LS_CONSTANTS_379, LS_CONSTANTS::NFA_LS_CONSTANTS_380, LS_CONSTANTS::NFA_LS_CONSTANTS_381, LS_CONSTANTS::NFA_LS_CONSTANTS_382, LS_CONSTANTS::NFA_LS_CONSTANTS_383, LS_CONSTANTS::NFA_LS_CONSTANTS_384, LS_CONSTANTS::NFA_LS_CONSTANTS_385, LS_CONSTANTS::NFA_LS_CONSTANTS_386, LS_CONSTANTS::NFA_LS_CONSTANTS_387, LS_CONSTANTS::NFA_LS_CONSTANTS_388, LS_CONSTANTS::NFA_LS_CONSTANTS_389, LS_CONSTANTS::NFA_LS_CONSTANTS_390, LS_CONSTANTS::NFA_LS_CONSTANTS_391, LS_CONSTANTS::NFA_LS_CONSTANTS_392, LS_CONSTANTS::NFA_LS_CONSTANTS_393, LS_CONSTANTS::NFA_LS_CONSTANTS_394, LS_CONSTANTS::NFA_LS_CONSTANTS_395, LS_CONSTANTS::NFA_LS_CONSTANTS_396, LS_CONSTANTS::NFA_LS_CONSTANTS_397, LS_CONSTANTS::NFA_LS_CONSTANTS_398, LS_CONSTANTS::NFA_LS_CONSTANTS_399, LS_CONSTANTS::NFA_LS_CONSTANTS_400, LS_CONSTANTS::NFA_LS_CONSTANTS_401, LS_CONSTANTS::NFA_LS_CONSTANTS_402, LS_CONSTANTS::NFA_LS_CONSTANTS_403, LS_CONSTANTS::NFA_LS_CONSTANTS_404, LS_CONSTANTS::NFA_LS_CONSTANTS_405, LS_CONSTANTS::NFA_LS_CONSTANTS_406, LS_CONSTANTS::NFA_LS_CONSTANTS_407, LS_CONSTANTS::NFA_LS_CONSTANTS_408, LS_CONSTANTS::NFA_LS_CONSTANTS_409, LS_CONSTANTS::NFA_LS_CONSTANTS_410, LS_CONSTANTS::NFA_LS_CONSTANTS_411, LS_CONSTANTS::NFA_LS_CONSTANTS_412, LS_CONSTANTS::NFA_LS_CONSTANTS_413, LS_CONSTANTS::NFA_LS_CONSTANTS_414, LS_CONSTANTS::NFA_LS_CONSTANTS_415, LS_CONSTANTS::NFA_LS_CONSTANTS_416, LS_CONSTANTS::NFA_LS_CONSTANTS_417, LS_CONSTANTS::NFA_LS_CONSTANTS_418, LS_CONSTANTS::NFA_LS_CONSTANTS_419, LS_CONSTANTS::NFA_LS_CONSTANTS_420, LS_CONSTANTS::NFA_LS_CONSTANTS_421, LS_CONSTANTS::NFA_LS_CONSTANTS_422, LS_CONSTANTS::NFA_LS_CONSTANTS_423, LS_CONSTANTS::NFA_LS_CONSTANTS_424, LS_CONSTANTS::NFA_LS_CONSTANTS_425, LS_CONSTANTS::NFA_LS_CONSTANTS_426, LS_CONSTANTS::NFA_LS_CONSTANTS_427, LS_CONSTANTS::NFA_LS_CONSTANTS_428, LS_CONSTANTS::NFA_LS_CONSTANTS_429, LS_CONSTANTS::NFA_LS_CONSTANTS_430, LS_CONSTANTS::NFA_LS_CONSTANTS_431, LS_CONSTANTS::NFA_LS_CONSTANTS_432, LS_CONSTANTS::NFA_LS_CONSTANTS_433, LS_CONSTANTS::NFA_LS_CONSTANTS_434, LS_CONSTANTS::NFA_LS_CONSTANTS_435, LS_CONSTANTS::NFA_LS_CONSTANTS_436, LS_CONSTANTS::NFA_LS_CONSTANTS_437, LS_CONSTANTS::NFA_LS_CONSTANTS_438, LS_CONSTANTS::NFA_LS_CONSTANTS_439, LS_CONSTANTS::NFA_LS_CONSTANTS_440, LS_CONSTANTS::NFA_LS_CONSTANTS_441, LS_CONSTANTS::NFA_LS_CONSTANTS_442, LS_CONSTANTS::NFA_LS_CONSTANTS_443, LS_CONSTANTS::NFA_LS_CONSTANTS_444, LS_CONSTANTS::NFA_LS_CONSTANTS_445, LS_CONSTANTS::NFA_LS_CONSTANTS_446, LS_CONSTANTS::NFA_LS_CONSTANTS_447, LS_CONSTANTS::NFA_LS_CONSTANTS_448, LS_CONSTANTS::NFA_LS_CONSTANTS_449, LS_CONSTANTS::NFA_LS_CONSTANTS_450, LS_CONSTANTS::NFA_LS_CONSTANTS_451, LS_CONSTANTS::NFA_LS_CONSTANTS_452, LS_CONSTANTS::NFA_LS_CONSTANTS_453, LS_CONSTANTS::NFA_LS_CONSTANTS_454, LS_CONSTANTS::NFA_LS_CONSTANTS_455, LS_CONSTANTS::NFA_LS_CONSTANTS_456, LS_CONSTANTS::NFA_LS_CONSTANTS_457, LS_CONSTANTS::NFA_LS_CONSTANTS_458, LS_CONSTANTS::NFA_LS_CONSTANTS_459, LS_CONSTANTS::NFA_LS_CONSTANTS_460, LS_CONSTANTS::NFA_LS_CONSTANTS_461, LS_CONSTANTS::NFA_LS_CONSTANTS_462, LS_CONSTANTS::NFA_LS_CONSTANTS_463, LS_CONSTANTS::NFA_LS_CONSTANTS_464, LS_CONSTANTS::NFA_LS_CONSTANTS_465, LS_CONSTANTS::NFA_LS_CONSTANTS_466, LS_CONSTANTS::NFA_LS_CONSTANTS_467, LS_CONSTANTS::NFA_LS_CONSTANTS_468, LS_CONSTANTS::NFA_LS_CONSTANTS_469, LS_CONSTANTS::NFA_LS_CONSTANTS_470, LS_CONSTANTS::NFA_LS_CONSTANTS_471, LS_CONSTANTS::NFA_LS_CONSTANTS_472, LS_CONSTANTS::NFA_LS_CONSTANTS_473, LS_CONSTANTS::NFA_LS_CONSTANTS_474, LS_CONSTANTS::NFA_LS_CONSTANTS_475, LS_CONSTANTS::NFA_LS_CONSTANTS_476, LS_CONSTANTS::NFA_LS_CONSTANTS_477, LS_CONSTANTS::NFA_LS_CONSTANTS_478, LS_CONSTANTS::NFA_LS_CONSTANTS_479, LS_CONSTANTS::NFA_LS_CONSTANTS_480, LS_CONSTANTS::NFA_LS_CONSTANTS_481, LS_CONSTANTS::NFA_LS_CONSTANTS_482, LS_CONSTANTS::NFA_LS_CONSTANTS_483, LS_CONSTANTS::NFA_LS_CONSTANTS_484, LS_CONSTANTS::NFA_LS_CONSTANTS_485, LS_CONSTANTS::NFA_LS_CONSTANTS_486, LS_CONSTANTS::NFA_LS_CONSTANTS_487, LS_CONSTANTS::NFA_LS_CONSTANTS_488, LS_CONSTANTS::NFA_LS_CONSTANTS_489, LS_CONSTANTS::NFA_LS_CONSTANTS_490, LS_CONSTANTS::NFA_LS_CONSTANTS_491, LS_CONSTANTS::NFA_LS_CONSTANTS_492, LS_CONSTANTS::NFA_LS_CONSTANTS_493, LS_CONSTANTS::NFA_LS_CONSTANTS_494, LS_CONSTANTS::NFA_LS_CONSTANTS_495, LS_CONSTANTS::NFA_LS_CONSTANTS_496, LS_CONSTANTS::NFA_LS_CONSTANTS_497, LS_CONSTANTS::NFA_LS_CONSTANTS_498, LS_CONSTANTS::NFA_LS_CONSTANTS_499};
            functionTableMap.put(QConstants.LexicalState.LS_CONSTANTS, functions);
        }
    }

    private static class LS_PLAIN_PATH {
        private LS_PLAIN_PATH() {
        }

        static QConstants.TokenType NFA_COMPOSITE_LS_PLAIN_PATH_0(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            QConstants.TokenType type = null;
            if (ch == 91) {
                nextStates.set(3);
            } else if (ch == 45 || ch == 46 || ch >= 48 && ch <= 57 || ch >= 64 && ch <= 90 || ch == 95 || ch >= 97 && ch <= 122) {
                nextStates.set(7);
                if (validTypes.contains((Object)QConstants.TokenType.T_CHARSEQ)) {
                    type = QConstants.TokenType.T_CHARSEQ;
                }
            } else if (ch == 47) {
                if (validTypes.contains((Object)QConstants.TokenType.T_PATH_SEPARATOR)) {
                    type = QConstants.TokenType.T_PATH_SEPARATOR;
                }
            } else if (ch == 9) {
                if (validTypes.contains((Object)QConstants.TokenType._TOKEN_4)) {
                    type = QConstants.TokenType._TOKEN_4;
                }
            } else if (ch == 13) {
                if (validTypes.contains((Object)QConstants.TokenType._TOKEN_3)) {
                    type = QConstants.TokenType._TOKEN_3;
                }
            } else if (ch == 10) {
                if (validTypes.contains((Object)QConstants.TokenType._TOKEN_2)) {
                    type = QConstants.TokenType._TOKEN_2;
                }
            } else if (ch == 32 && validTypes.contains((Object)QConstants.TokenType._TOKEN_1)) {
                type = QConstants.TokenType._TOKEN_1;
            }
            return type;
        }

        static QConstants.TokenType NFA_COMPOSITE_LS_PLAIN_PATH_1(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            QConstants.TokenType type = null;
            if (ch >= 48 && ch <= 57) {
                nextStates.set(1);
            } else if (ch == 93 && validTypes.contains((Object)QConstants.TokenType.T_ARRAYINDEX)) {
                type = QConstants.TokenType.T_ARRAYINDEX;
            }
            return type;
        }

        static QConstants.TokenType NFA_COMPOSITE_LS_PLAIN_PATH_2(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            QConstants.TokenType type = null;
            if (ch >= 48 && ch <= 57) {
                nextStates.set(15);
            }
            if (ch >= 49 && ch <= 57) {
                nextStates.set(13);
            }
            return type;
        }

        static QConstants.TokenType NFA_COMPOSITE_LS_PLAIN_PATH_3(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            QConstants.TokenType type = null;
            if (ch == 43 || ch == 45) {
                nextStates.set(2);
            } else if (ch >= 48 && ch <= 57) {
                nextStates.set(15);
            }
            if (ch >= 49 && ch <= 57) {
                nextStates.set(13);
            }
            return type;
        }

        static QConstants.TokenType NFA_LS_PLAIN_PATH_4(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 47 && validTypes.contains((Object)QConstants.TokenType.T_PATH_SEPARATOR)) {
                return QConstants.TokenType.T_PATH_SEPARATOR;
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_PLAIN_PATH_5(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 10 && validTypes.contains((Object)QConstants.TokenType._TOKEN_2)) {
                return QConstants.TokenType._TOKEN_2;
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_PLAIN_PATH_6(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 9 && validTypes.contains((Object)QConstants.TokenType._TOKEN_4)) {
                return QConstants.TokenType._TOKEN_4;
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_PLAIN_PATH_7(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 45 || ch == 46 || ch >= 48 && ch <= 57 || ch >= 64 && ch <= 90 || ch == 95 || ch >= 97 && ch <= 122) {
                nextStates.set(7);
                if (validTypes.contains((Object)QConstants.TokenType.T_CHARSEQ)) {
                    return QConstants.TokenType.T_CHARSEQ;
                }
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_PLAIN_PATH_8(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 32 && validTypes.contains((Object)QConstants.TokenType._TOKEN_1)) {
                return QConstants.TokenType._TOKEN_1;
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_PLAIN_PATH_9(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 13 && validTypes.contains((Object)QConstants.TokenType._TOKEN_3)) {
                return QConstants.TokenType._TOKEN_3;
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_PLAIN_PATH_10(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 91) {
                nextStates.set(3);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_PLAIN_PATH_11(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch >= 48 && ch <= 57) {
                nextStates.set(15);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_PLAIN_PATH_12(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch >= 49 && ch <= 57) {
                nextStates.set(13);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_PLAIN_PATH_13(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch >= 48 && ch <= 57) {
                nextStates.set(1);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_PLAIN_PATH_14(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 43 || ch == 45) {
                nextStates.set(2);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_PLAIN_PATH_15(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 93 && validTypes.contains((Object)QConstants.TokenType.T_ARRAYINDEX)) {
                return QConstants.TokenType.T_ARRAYINDEX;
            }
            return null;
        }

        private static void NFA_FUNCTIONS_init() {
            NfaFunction[] functions = new NfaFunction[]{LS_PLAIN_PATH::NFA_COMPOSITE_LS_PLAIN_PATH_0, LS_PLAIN_PATH::NFA_COMPOSITE_LS_PLAIN_PATH_1, LS_PLAIN_PATH::NFA_COMPOSITE_LS_PLAIN_PATH_2, LS_PLAIN_PATH::NFA_COMPOSITE_LS_PLAIN_PATH_3, LS_PLAIN_PATH::NFA_LS_PLAIN_PATH_4, LS_PLAIN_PATH::NFA_LS_PLAIN_PATH_5, LS_PLAIN_PATH::NFA_LS_PLAIN_PATH_6, LS_PLAIN_PATH::NFA_LS_PLAIN_PATH_7, LS_PLAIN_PATH::NFA_LS_PLAIN_PATH_8, LS_PLAIN_PATH::NFA_LS_PLAIN_PATH_9, LS_PLAIN_PATH::NFA_LS_PLAIN_PATH_10, LS_PLAIN_PATH::NFA_LS_PLAIN_PATH_11, LS_PLAIN_PATH::NFA_LS_PLAIN_PATH_12, LS_PLAIN_PATH::NFA_LS_PLAIN_PATH_13, LS_PLAIN_PATH::NFA_LS_PLAIN_PATH_14, LS_PLAIN_PATH::NFA_LS_PLAIN_PATH_15};
            functionTableMap.put(QConstants.LexicalState.LS_PLAIN_PATH, functions);
        }
    }

    private static class LS_ORDERBYS {
        private LS_ORDERBYS() {
        }

        static QConstants.TokenType NFA_COMPOSITE_LS_ORDERBYS_0(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            QConstants.TokenType type = null;
            if (ch == 44) {
                if (validTypes.contains((Object)QConstants.TokenType.T_VALUE_SEPARATOR)) {
                    type = QConstants.TokenType.T_VALUE_SEPARATOR;
                }
            } else if (ch == 9) {
                if (validTypes.contains((Object)QConstants.TokenType._TOKEN_4)) {
                    type = QConstants.TokenType._TOKEN_4;
                }
            } else if (ch == 13) {
                if (validTypes.contains((Object)QConstants.TokenType._TOKEN_3)) {
                    type = QConstants.TokenType._TOKEN_3;
                }
            } else if (ch == 10) {
                if (validTypes.contains((Object)QConstants.TokenType._TOKEN_2)) {
                    type = QConstants.TokenType._TOKEN_2;
                }
            } else if (ch == 32 && validTypes.contains((Object)QConstants.TokenType._TOKEN_1)) {
                type = QConstants.TokenType._TOKEN_1;
            }
            return type;
        }

        static QConstants.TokenType NFA_LS_ORDERBYS_1(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 32 && validTypes.contains((Object)QConstants.TokenType._TOKEN_1)) {
                return QConstants.TokenType._TOKEN_1;
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_ORDERBYS_2(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 9 && validTypes.contains((Object)QConstants.TokenType._TOKEN_4)) {
                return QConstants.TokenType._TOKEN_4;
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_ORDERBYS_3(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 10 && validTypes.contains((Object)QConstants.TokenType._TOKEN_2)) {
                return QConstants.TokenType._TOKEN_2;
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_ORDERBYS_4(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 44 && validTypes.contains((Object)QConstants.TokenType.T_VALUE_SEPARATOR)) {
                return QConstants.TokenType.T_VALUE_SEPARATOR;
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_ORDERBYS_5(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 13 && validTypes.contains((Object)QConstants.TokenType._TOKEN_3)) {
                return QConstants.TokenType._TOKEN_3;
            }
            return null;
        }

        private static void NFA_FUNCTIONS_init() {
            NfaFunction[] functions = new NfaFunction[]{LS_ORDERBYS::NFA_COMPOSITE_LS_ORDERBYS_0, LS_ORDERBYS::NFA_LS_ORDERBYS_1, LS_ORDERBYS::NFA_LS_ORDERBYS_2, LS_ORDERBYS::NFA_LS_ORDERBYS_3, LS_ORDERBYS::NFA_LS_ORDERBYS_4, LS_ORDERBYS::NFA_LS_ORDERBYS_5};
            functionTableMap.put(QConstants.LexicalState.LS_ORDERBYS, functions);
        }
    }

    private static class LS_ORDERBY {
        private LS_ORDERBY() {
        }

        static QConstants.TokenType NFA_COMPOSITE_LS_ORDERBY_0(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            QConstants.TokenType type = null;
            if (ch == 65 || ch == 97) {
                nextStates.set(9);
            } else if (ch == 68 || ch == 100) {
                nextStates.set(4);
            } else if (ch == 9) {
                if (validTypes.contains((Object)QConstants.TokenType._TOKEN_4)) {
                    type = QConstants.TokenType._TOKEN_4;
                }
            } else if (ch == 13) {
                if (validTypes.contains((Object)QConstants.TokenType._TOKEN_3)) {
                    type = QConstants.TokenType._TOKEN_3;
                }
            } else if (ch == 10) {
                if (validTypes.contains((Object)QConstants.TokenType._TOKEN_2)) {
                    type = QConstants.TokenType._TOKEN_2;
                }
            } else if (ch == 32 && validTypes.contains((Object)QConstants.TokenType._TOKEN_1)) {
                type = QConstants.TokenType._TOKEN_1;
            }
            return type;
        }

        static QConstants.TokenType NFA_LS_ORDERBY_1(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 65 || ch == 97) {
                nextStates.set(9);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_ORDERBY_2(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 9 && validTypes.contains((Object)QConstants.TokenType._TOKEN_4)) {
                return QConstants.TokenType._TOKEN_4;
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_ORDERBY_3(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 13 && validTypes.contains((Object)QConstants.TokenType._TOKEN_3)) {
                return QConstants.TokenType._TOKEN_3;
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_ORDERBY_4(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 69 || ch == 101) {
                nextStates.set(10);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_ORDERBY_5(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 68 || ch == 100) {
                nextStates.set(4);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_ORDERBY_6(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if ((ch == 67 || ch == 99) && validTypes.contains((Object)QConstants.TokenType.T_O_ASC)) {
                return QConstants.TokenType.T_O_ASC;
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_ORDERBY_7(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if ((ch == 67 || ch == 99) && validTypes.contains((Object)QConstants.TokenType.T_O_DESC)) {
                return QConstants.TokenType.T_O_DESC;
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_ORDERBY_8(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 10 && validTypes.contains((Object)QConstants.TokenType._TOKEN_2)) {
                return QConstants.TokenType._TOKEN_2;
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_ORDERBY_9(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 83 || ch == 115) {
                nextStates.set(6);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_ORDERBY_10(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 83 || ch == 115) {
                nextStates.set(7);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_ORDERBY_11(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 32 && validTypes.contains((Object)QConstants.TokenType._TOKEN_1)) {
                return QConstants.TokenType._TOKEN_1;
            }
            return null;
        }

        private static void NFA_FUNCTIONS_init() {
            NfaFunction[] functions = new NfaFunction[]{LS_ORDERBY::NFA_COMPOSITE_LS_ORDERBY_0, LS_ORDERBY::NFA_LS_ORDERBY_1, LS_ORDERBY::NFA_LS_ORDERBY_2, LS_ORDERBY::NFA_LS_ORDERBY_3, LS_ORDERBY::NFA_LS_ORDERBY_4, LS_ORDERBY::NFA_LS_ORDERBY_5, LS_ORDERBY::NFA_LS_ORDERBY_6, LS_ORDERBY::NFA_LS_ORDERBY_7, LS_ORDERBY::NFA_LS_ORDERBY_8, LS_ORDERBY::NFA_LS_ORDERBY_9, LS_ORDERBY::NFA_LS_ORDERBY_10, LS_ORDERBY::NFA_LS_ORDERBY_11};
            functionTableMap.put(QConstants.LexicalState.LS_ORDERBY, functions);
        }
    }

    private static class LS_ANYSTRING {
        private LS_ANYSTRING() {
        }

        static QConstants.TokenType NFA_LS_ANYSTRING_0(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch >= 0 && ch <= 37 || ch >= 39) {
                nextStates.set(0);
                if (validTypes.contains((Object)QConstants.TokenType.T_STRING)) {
                    return QConstants.TokenType.T_STRING;
                }
            }
            return null;
        }

        private static void NFA_FUNCTIONS_init() {
            NfaFunction[] functions = new NfaFunction[]{LS_ANYSTRING::NFA_LS_ANYSTRING_0};
            functionTableMap.put(QConstants.LexicalState.LS_ANYSTRING, functions);
        }
    }

    private static class LS_FORMAT {
        private LS_FORMAT() {
        }

        static QConstants.TokenType NFA_LS_FORMAT_0(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 37 || ch >= 45 && ch <= 59 || ch == 61 || ch >= 64 && ch <= 90 || ch == 95 || ch >= 97 && ch <= 122) {
                nextStates.set(0);
                if (validTypes.contains((Object)QConstants.TokenType.T_CHARSEQ_FORMAT)) {
                    return QConstants.TokenType.T_CHARSEQ_FORMAT;
                }
            }
            return null;
        }

        private static void NFA_FUNCTIONS_init() {
            NfaFunction[] functions = new NfaFunction[]{LS_FORMAT::NFA_LS_FORMAT_0};
            functionTableMap.put(QConstants.LexicalState.LS_FORMAT, functions);
        }
    }

    private static class LS_METADATA {
        private LS_METADATA() {
        }

        static QConstants.TokenType NFA_LS_METADATA_0(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch >= 48 && ch <= 57 || ch >= 65 && ch <= 90 || ch >= 97 && ch <= 122) {
                nextStates.set(0);
                if (validTypes.contains((Object)QConstants.TokenType.T_CHARSEQ_METADATA)) {
                    return QConstants.TokenType.T_CHARSEQ_METADATA;
                }
            }
            return null;
        }

        private static void NFA_FUNCTIONS_init() {
            NfaFunction[] functions = new NfaFunction[]{LS_METADATA::NFA_LS_METADATA_0};
            functionTableMap.put(QConstants.LexicalState.LS_METADATA, functions);
        }
    }

    private static class LS_COUNT {
        private LS_COUNT() {
        }

        static QConstants.TokenType NFA_COMPOSITE_LS_COUNT_0(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            QConstants.TokenType type = null;
            if (ch == 70 || ch == 102) {
                nextStates.set(6);
            } else if (ch == 84 || ch == 116) {
                nextStates.set(8);
            }
            return type;
        }

        static QConstants.TokenType NFA_LS_COUNT_1(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 85 || ch == 117) {
                nextStates.set(7);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_COUNT_2(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 70 || ch == 102) {
                nextStates.set(6);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_COUNT_3(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if ((ch == 69 || ch == 101) && validTypes.contains((Object)QConstants.TokenType.T_BOOL)) {
                return QConstants.TokenType.T_BOOL;
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_COUNT_4(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 84 || ch == 116) {
                nextStates.set(8);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_COUNT_5(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 83 || ch == 115) {
                nextStates.set(3);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_COUNT_6(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 65 || ch == 97) {
                nextStates.set(9);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_COUNT_7(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if ((ch == 69 || ch == 101) && validTypes.contains((Object)QConstants.TokenType.T_BOOL)) {
                return QConstants.TokenType.T_BOOL;
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_COUNT_8(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 82 || ch == 114) {
                nextStates.set(1);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_COUNT_9(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 76 || ch == 108) {
                nextStates.set(5);
            }
            return null;
        }

        private static void NFA_FUNCTIONS_init() {
            NfaFunction[] functions = new NfaFunction[]{LS_COUNT::NFA_COMPOSITE_LS_COUNT_0, LS_COUNT::NFA_LS_COUNT_1, LS_COUNT::NFA_LS_COUNT_2, LS_COUNT::NFA_LS_COUNT_3, LS_COUNT::NFA_LS_COUNT_4, LS_COUNT::NFA_LS_COUNT_5, LS_COUNT::NFA_LS_COUNT_6, LS_COUNT::NFA_LS_COUNT_7, LS_COUNT::NFA_LS_COUNT_8, LS_COUNT::NFA_LS_COUNT_9};
            functionTableMap.put(QConstants.LexicalState.LS_COUNT, functions);
        }
    }

    private static class LS_TOP {
        private LS_TOP() {
        }

        static QConstants.TokenType NFA_COMPOSITE_LS_TOP_0(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            QConstants.TokenType type = null;
            if (ch == 43 || ch == 45) {
                nextStates.set(1);
            } else if (ch >= 49 && ch <= 57) {
                nextStates.set(3);
            }
            if (ch >= 48 && ch <= 57 && validTypes.contains((Object)QConstants.TokenType.T_LONG)) {
                type = QConstants.TokenType.T_LONG;
            }
            return type;
        }

        static QConstants.TokenType NFA_COMPOSITE_LS_TOP_1(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            QConstants.TokenType type = null;
            if (ch >= 49 && ch <= 57) {
                nextStates.set(3);
            }
            if (ch >= 48 && ch <= 57 && validTypes.contains((Object)QConstants.TokenType.T_LONG)) {
                type = QConstants.TokenType.T_LONG;
            }
            return type;
        }

        static QConstants.TokenType NFA_LS_TOP_2(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 43 || ch == 45) {
                nextStates.set(1);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_TOP_3(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch >= 48 && ch <= 57) {
                nextStates.set(3);
                if (validTypes.contains((Object)QConstants.TokenType.T_LONG)) {
                    return QConstants.TokenType.T_LONG;
                }
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_TOP_4(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch >= 49 && ch <= 57) {
                nextStates.set(3);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_TOP_5(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch >= 48 && ch <= 57 && validTypes.contains((Object)QConstants.TokenType.T_LONG)) {
                return QConstants.TokenType.T_LONG;
            }
            return null;
        }

        private static void NFA_FUNCTIONS_init() {
            NfaFunction[] functions = new NfaFunction[]{LS_TOP::NFA_COMPOSITE_LS_TOP_0, LS_TOP::NFA_COMPOSITE_LS_TOP_1, LS_TOP::NFA_LS_TOP_2, LS_TOP::NFA_LS_TOP_3, LS_TOP::NFA_LS_TOP_4, LS_TOP::NFA_LS_TOP_5};
            functionTableMap.put(QConstants.LexicalState.LS_TOP, functions);
        }
    }

    private static class LS_SKIP {
        private LS_SKIP() {
        }

        static QConstants.TokenType NFA_COMPOSITE_LS_SKIP_0(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            QConstants.TokenType type = null;
            if (ch == 43 || ch == 45) {
                nextStates.set(1);
            } else if (ch >= 49 && ch <= 57) {
                nextStates.set(2);
            }
            if (ch >= 48 && ch <= 57 && validTypes.contains((Object)QConstants.TokenType.T_LONG)) {
                type = QConstants.TokenType.T_LONG;
            }
            return type;
        }

        static QConstants.TokenType NFA_COMPOSITE_LS_SKIP_1(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            QConstants.TokenType type = null;
            if (ch >= 49 && ch <= 57) {
                nextStates.set(2);
            }
            if (ch >= 48 && ch <= 57 && validTypes.contains((Object)QConstants.TokenType.T_LONG)) {
                type = QConstants.TokenType.T_LONG;
            }
            return type;
        }

        static QConstants.TokenType NFA_LS_SKIP_2(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch >= 48 && ch <= 57) {
                nextStates.set(2);
                if (validTypes.contains((Object)QConstants.TokenType.T_LONG)) {
                    return QConstants.TokenType.T_LONG;
                }
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_SKIP_3(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 43 || ch == 45) {
                nextStates.set(1);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_SKIP_4(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch >= 48 && ch <= 57 && validTypes.contains((Object)QConstants.TokenType.T_LONG)) {
                return QConstants.TokenType.T_LONG;
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_SKIP_5(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch >= 49 && ch <= 57) {
                nextStates.set(2);
            }
            return null;
        }

        private static void NFA_FUNCTIONS_init() {
            NfaFunction[] functions = new NfaFunction[]{LS_SKIP::NFA_COMPOSITE_LS_SKIP_0, LS_SKIP::NFA_COMPOSITE_LS_SKIP_1, LS_SKIP::NFA_LS_SKIP_2, LS_SKIP::NFA_LS_SKIP_3, LS_SKIP::NFA_LS_SKIP_4, LS_SKIP::NFA_LS_SKIP_5};
            functionTableMap.put(QConstants.LexicalState.LS_SKIP, functions);
        }
    }

    private static class LS_EXPAND {
        private LS_EXPAND() {
        }

        static QConstants.TokenType NFA_COMPOSITE_LS_EXPAND_0(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            QConstants.TokenType type = null;
            if (ch == 41) {
                if (validTypes.contains((Object)QConstants.TokenType.T_RB)) {
                    type = QConstants.TokenType.T_RB;
                }
            } else if (ch == 40) {
                if (validTypes.contains((Object)QConstants.TokenType.T_LB)) {
                    type = QConstants.TokenType.T_LB;
                }
            } else if (ch == 44 && validTypes.contains((Object)QConstants.TokenType.T_VALUE_SEPARATOR)) {
                type = QConstants.TokenType.T_VALUE_SEPARATOR;
            }
            return type;
        }

        static QConstants.TokenType NFA_LS_EXPAND_1(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 40 && validTypes.contains((Object)QConstants.TokenType.T_LB)) {
                return QConstants.TokenType.T_LB;
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_EXPAND_2(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 41 && validTypes.contains((Object)QConstants.TokenType.T_RB)) {
                return QConstants.TokenType.T_RB;
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_EXPAND_3(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 44 && validTypes.contains((Object)QConstants.TokenType.T_VALUE_SEPARATOR)) {
                return QConstants.TokenType.T_VALUE_SEPARATOR;
            }
            return null;
        }

        private static void NFA_FUNCTIONS_init() {
            NfaFunction[] functions = new NfaFunction[]{LS_EXPAND::NFA_COMPOSITE_LS_EXPAND_0, LS_EXPAND::NFA_LS_EXPAND_1, LS_EXPAND::NFA_LS_EXPAND_2, LS_EXPAND::NFA_LS_EXPAND_3};
            functionTableMap.put(QConstants.LexicalState.LS_EXPAND, functions);
        }
    }

    private static class LS_SELECT {
        private LS_SELECT() {
        }

        static QConstants.TokenType NFA_COMPOSITE_LS_SELECT_0(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            QConstants.TokenType type = null;
            if (ch == 68 || ch == 100) {
                nextStates.set(8);
            } else if (ch == 44 && validTypes.contains((Object)QConstants.TokenType.T_VALUE_SEPARATOR)) {
                type = QConstants.TokenType.T_VALUE_SEPARATOR;
            }
            return type;
        }

        static QConstants.TokenType NFA_LS_SELECT_1(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 78 || ch == 110) {
                nextStates.set(5);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_SELECT_2(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 83 || ch == 115) {
                nextStates.set(9);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_SELECT_3(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 58 && validTypes.contains((Object)QConstants.TokenType.T_DISTINCT)) {
                return QConstants.TokenType.T_DISTINCT;
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_SELECT_4(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 73 || ch == 105) {
                nextStates.set(1);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_SELECT_5(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 67 || ch == 99) {
                nextStates.set(7);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_SELECT_6(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 44 && validTypes.contains((Object)QConstants.TokenType.T_VALUE_SEPARATOR)) {
                return QConstants.TokenType.T_VALUE_SEPARATOR;
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_SELECT_7(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 84 || ch == 116) {
                nextStates.set(3);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_SELECT_8(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 73 || ch == 105) {
                nextStates.set(2);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_SELECT_9(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 84 || ch == 116) {
                nextStates.set(4);
            }
            return null;
        }

        static QConstants.TokenType NFA_LS_SELECT_10(int ch, BitSet nextStates, EnumSet<QConstants.TokenType> validTypes) {
            if (ch == 68 || ch == 100) {
                nextStates.set(8);
            }
            return null;
        }

        private static void NFA_FUNCTIONS_init() {
            NfaFunction[] functions = new NfaFunction[]{LS_SELECT::NFA_COMPOSITE_LS_SELECT_0, LS_SELECT::NFA_LS_SELECT_1, LS_SELECT::NFA_LS_SELECT_2, LS_SELECT::NFA_LS_SELECT_3, LS_SELECT::NFA_LS_SELECT_4, LS_SELECT::NFA_LS_SELECT_5, LS_SELECT::NFA_LS_SELECT_6, LS_SELECT::NFA_LS_SELECT_7, LS_SELECT::NFA_LS_SELECT_8, LS_SELECT::NFA_LS_SELECT_9, LS_SELECT::NFA_LS_SELECT_10};
            functionTableMap.put(QConstants.LexicalState.LS_SELECT, functions);
        }
    }
}

