/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.frostserver.util.queryparser;

import de.fraunhofer.iosb.ilt.frostserver.util.queryparser.InvalidToken;
import de.fraunhofer.iosb.ilt.frostserver.util.queryparser.QConstants;
import de.fraunhofer.iosb.ilt.frostserver.util.queryparser.QNfaData;
import de.fraunhofer.iosb.ilt.frostserver.util.queryparser.Token;
import java.io.Reader;
import java.util.Arrays;
import java.util.BitSet;
import java.util.EnumSet;

public class QLexer
implements QConstants {
    static final int DEFAULT_TAB_SIZE = 1;
    private int tabSize = 1;
    final Token DUMMY_START_TOKEN = new Token();
    private static final Token IGNORED = new Token();
    private static final Token SKIPPED = new Token();
    private CharSequence content;
    private String inputSource = "input";
    private int[] lineOffsets;
    private int startingLine;
    private int startingColumn;
    private int bufferPosition;
    private BitSet tokenOffsets;
    private BitSet needToCalculateColumns = new BitSet();
    private Token[] tokenLocationTable;
    private BitSet nextStates = new BitSet(500);
    private BitSet currentStates = new BitSet(500);
    EnumSet<QConstants.TokenType> activeTokenTypes = EnumSet.allOf(QConstants.TokenType.class);
    static final EnumSet<QConstants.TokenType> regularTokens;
    private static final EnumSet<QConstants.TokenType> unparsedTokens;
    static final EnumSet<QConstants.TokenType> skippedTokens;
    private static final EnumSet<QConstants.TokenType> moreTokens;
    QConstants.LexicalState lexicalState = QConstants.LexicalState.values()[0];

    public void setTabSize(int tabSize) {
        this.tabSize = tabSize;
    }

    public String getInputSource() {
        return this.inputSource;
    }

    public void setInputSource(String inputSource) {
        this.inputSource = inputSource;
    }

    public QLexer(CharSequence input) {
        this("input", input);
    }

    public QLexer(String inputSource, CharSequence input) {
        this(inputSource, input, QConstants.LexicalState.DEFAULT, 1, 1);
    }

    public QLexer(String inputSource, CharSequence input, QConstants.LexicalState lexState, int startingLine, int startingColumn) {
        this.inputSource = inputSource;
        this.content = QLexer.mungeContent(input, true, true, false, false);
        this.inputSource = inputSource;
        this.createLineOffsetsTable();
        this.tokenLocationTable = new Token[this.content.length() + 1];
        this.tokenOffsets = new BitSet(this.content.length() + 1);
        this.startingLine = startingLine;
        this.startingColumn = startingColumn;
        this.switchTo(lexState);
    }

    public QLexer(Reader reader) {
        this("input", reader, QConstants.LexicalState.DEFAULT, 1, 1);
    }

    public QLexer(String inputSource, Reader reader) {
        this(inputSource, reader, QConstants.LexicalState.DEFAULT, 1, 1);
    }

    public QLexer(String inputSource, Reader reader, QConstants.LexicalState lexState, int line, int column) {
        this(inputSource, QConstants.readToEnd(reader), lexState, line, column);
        this.switchTo(lexState);
    }

    private Token getNextToken() {
        InvalidToken invalidToken = null;
        Token token = this.nextToken();
        while (token instanceof InvalidToken) {
            if (invalidToken == null) {
                invalidToken = (InvalidToken)token;
            } else {
                invalidToken.setEndOffset(token.getEndOffset());
            }
            token = this.nextToken();
        }
        if (invalidToken != null) {
            this.cacheToken(invalidToken);
        }
        this.cacheToken(token);
        return invalidToken != null ? invalidToken : token;
    }

    public Token getNextToken(Token tok) {
        if (tok == null) {
            return this.getNextToken();
        }
        Token cachedToken = tok.nextCachedToken();
        if (cachedToken != null && !this.activeTokenTypes.contains((Object)cachedToken.getType())) {
            this.reset(tok);
            cachedToken = null;
        }
        return cachedToken != null ? cachedToken : this.getNextToken(tok.getEndOffset());
    }

    public Token getNextToken(int offset) {
        this.goTo(offset);
        return this.getNextToken();
    }

    private final Token nextToken() {
        Token matchedToken = null;
        boolean inMore = false;
        int tokenBeginOffset = this.bufferPosition;
        int firstChar = 0;
        while (matchedToken == null) {
            int curChar;
            int codeUnitsRead = 0;
            int matchedPos = 0;
            QConstants.TokenType matchedType = null;
            boolean reachedEnd = false;
            if (inMore) {
                curChar = this.readChar();
                if (curChar == -1) {
                    reachedEnd = true;
                }
            } else {
                tokenBeginOffset = this.bufferPosition;
                firstChar = curChar = this.readChar();
                if (curChar == -1) {
                    matchedType = QConstants.TokenType.EOF;
                    reachedEnd = true;
                }
            }
            QNfaData.NfaFunction[] nfaFunctions = QNfaData.getFunctionTableMap(this.lexicalState);
            if (!reachedEnd) {
                do {
                    QConstants.TokenType newType = null;
                    if (codeUnitsRead > 0) {
                        BitSet temp = this.currentStates;
                        this.currentStates = this.nextStates;
                        this.nextStates = temp;
                        int retval = this.readChar();
                        if (retval >= 0) {
                            curChar = retval;
                        } else {
                            reachedEnd = true;
                            break;
                        }
                    }
                    this.nextStates.clear();
                    if (codeUnitsRead == 0) {
                        QConstants.TokenType returnedType = nfaFunctions[0].apply(curChar, this.nextStates, this.activeTokenTypes);
                        if (returnedType != null && (newType == null || returnedType.ordinal() < newType.ordinal())) {
                            newType = returnedType;
                        }
                    } else {
                        int nextActive = this.currentStates.nextSetBit(0);
                        while (nextActive != -1) {
                            QConstants.TokenType returnedType = nfaFunctions[nextActive].apply(curChar, this.nextStates, this.activeTokenTypes);
                            if (returnedType != null && (newType == null || returnedType.ordinal() < newType.ordinal())) {
                                newType = returnedType;
                            }
                            nextActive = this.currentStates.nextSetBit(nextActive + 1);
                        }
                    }
                    ++codeUnitsRead;
                    if (curChar > 65535) {
                        ++codeUnitsRead;
                    }
                    if (newType == null) continue;
                    matchedType = newType;
                    inMore = moreTokens.contains((Object)matchedType);
                    matchedPos = codeUnitsRead;
                } while (!this.nextStates.isEmpty());
            }
            if (matchedType == null) {
                this.bufferPosition = tokenBeginOffset + 1;
                if (firstChar > 65535) {
                    ++this.bufferPosition;
                }
                return new InvalidToken(this, tokenBeginOffset, this.bufferPosition);
            }
            this.bufferPosition -= codeUnitsRead - matchedPos;
            if (skippedTokens.contains((Object)matchedType)) {
                for (int i = tokenBeginOffset; i < this.bufferPosition; ++i) {
                    if (this.tokenLocationTable[i] == IGNORED) continue;
                    this.tokenLocationTable[i] = SKIPPED;
                }
                continue;
            }
            if (!regularTokens.contains((Object)matchedType) && !unparsedTokens.contains((Object)matchedType)) continue;
            matchedToken = Token.newToken(matchedType, this, tokenBeginOffset, this.bufferPosition);
            matchedToken.setUnparsed(!regularTokens.contains((Object)matchedType));
        }
        return matchedToken;
    }

    public boolean switchTo(QConstants.LexicalState lexState) {
        if (this.lexicalState != lexState) {
            this.lexicalState = lexState;
            return true;
        }
        return false;
    }

    void reset(Token t, QConstants.LexicalState state) {
        this.goTo(t.getEndOffset());
        this.uncacheTokens(t);
        if (state != null) {
            this.switchTo(state);
        }
    }

    void reset(Token t) {
        this.reset(t, null);
    }

    private void goTo(int offset) {
        while (offset < this.content.length() && this.tokenLocationTable[offset] == IGNORED) {
            ++offset;
        }
        this.bufferPosition = offset;
    }

    private int readChar() {
        char nextChar;
        char ch;
        while (this.tokenLocationTable[this.bufferPosition] == IGNORED && this.bufferPosition < this.content.length()) {
            ++this.bufferPosition;
        }
        if (this.bufferPosition >= this.content.length()) {
            return -1;
        }
        if (Character.isHighSurrogate(ch = this.content.charAt(this.bufferPosition++)) && this.bufferPosition < this.content.length() && Character.isLowSurrogate(nextChar = this.content.charAt(this.bufferPosition))) {
            ++this.bufferPosition;
            return Character.toCodePoint(ch, nextChar);
        }
        return ch;
    }

    private void setParsedLines(BitSet parsedLines, boolean reversed) {
        for (int i = 0; i < this.lineOffsets.length; ++i) {
            boolean turnOffLine;
            boolean bl = turnOffLine = !parsedLines.get(i + 1);
            if (reversed) {
                boolean bl2 = turnOffLine = !turnOffLine;
            }
            if (!turnOffLine) continue;
            int lineOffset = this.lineOffsets[i];
            int nextLineOffset = i < this.lineOffsets.length - 1 ? this.lineOffsets[i + 1] : this.content.length();
            for (int offset = lineOffset; offset < nextLineOffset; ++offset) {
                this.tokenLocationTable[offset] = IGNORED;
            }
        }
    }

    public void setParsedLines(BitSet parsedLines) {
        this.setParsedLines(parsedLines, false);
    }

    public void setUnparsedLines(BitSet unparsedLines) {
        this.setParsedLines(unparsedLines, true);
    }

    int getLineFromOffset(int pos) {
        if (pos >= this.content.length()) {
            if (this.content.charAt(this.content.length() - 1) == '\n') {
                return this.startingLine + this.lineOffsets.length;
            }
            return this.startingLine + this.lineOffsets.length - 1;
        }
        int bsearchResult = Arrays.binarySearch(this.lineOffsets, pos);
        if (bsearchResult >= 0) {
            return this.startingLine + bsearchResult;
        }
        return this.startingLine - (bsearchResult + 2);
    }

    int getCodePointColumnFromOffset(int pos) {
        if (pos >= this.content.length()) {
            return 1;
        }
        if (pos == 0) {
            return this.startingColumn;
        }
        int line = this.getLineFromOffset(pos) - this.startingLine;
        int lineStart = this.lineOffsets[line];
        int startColumnAdjustment = line > 0 ? 1 : this.startingColumn;
        int unadjustedColumn = pos - lineStart + startColumnAdjustment;
        if (!this.needToCalculateColumns.get(line)) {
            return unadjustedColumn;
        }
        if (Character.isLowSurrogate(this.content.charAt(pos))) {
            --pos;
        }
        int result = startColumnAdjustment;
        for (int i = lineStart; i < pos; ++i) {
            char ch = this.content.charAt(i);
            if (ch == '\t') {
                result += this.tabSize - (result - 1) % this.tabSize;
                continue;
            }
            if (Character.isHighSurrogate(ch)) {
                ++result;
                ++i;
                continue;
            }
            ++result;
        }
        return result;
    }

    String getText(int startOffset, int endOffset) {
        StringBuilder buf = new StringBuilder();
        for (int offset = startOffset; offset < endOffset; ++offset) {
            if (this.tokenLocationTable[offset] == IGNORED) continue;
            buf.append(this.content.charAt(offset));
        }
        return buf.toString();
    }

    void cacheToken(Token tok) {
        if (tok.isInserted()) {
            Token next = tok.nextCachedToken();
            if (next != null) {
                this.cacheToken(next);
            }
            return;
        }
        int offset = tok.getBeginOffset();
        if (this.tokenLocationTable[offset] != IGNORED) {
            this.tokenOffsets.set(offset);
            this.tokenLocationTable[offset] = tok;
        }
    }

    void uncacheTokens(Token lastToken) {
        int endOffset = lastToken.getEndOffset();
        if (endOffset < this.tokenOffsets.length()) {
            this.tokenOffsets.clear(lastToken.getEndOffset(), this.tokenOffsets.length());
        }
        lastToken.unsetAppendedToken();
    }

    Token nextCachedToken(int offset) {
        int nextOffset = this.tokenOffsets.nextSetBit(offset);
        return nextOffset != -1 ? this.tokenLocationTable[nextOffset] : null;
    }

    Token previousCachedToken(int offset) {
        int prevOffset = this.tokenOffsets.previousSetBit(offset - 1);
        return prevOffset == -1 ? null : this.tokenLocationTable[prevOffset];
    }

    private void createLineOffsetsTable() {
        if (this.content.length() == 0) {
            this.lineOffsets = new int[0];
        }
        int lineCount = 0;
        int length = this.content.length();
        for (int i = 0; i < length; ++i) {
            char ch = this.content.charAt(i);
            if (ch == '\t' || Character.isHighSurrogate(ch)) {
                this.needToCalculateColumns.set(lineCount);
            }
            if (ch != '\n') continue;
            ++lineCount;
        }
        if (this.content.charAt(length - 1) != '\n') {
            ++lineCount;
        }
        int[] lineOffsets = new int[lineCount];
        lineOffsets[0] = 0;
        int index = 1;
        for (int i = 0; i < length; ++i) {
            char ch = this.content.charAt(i);
            if (ch != '\n') continue;
            if (i + 1 == length) break;
            lineOffsets[index++] = i + 1;
        }
        this.lineOffsets = lineOffsets;
    }

    private static String mungeContent(CharSequence content, boolean preserveTabs, boolean preserveLines, boolean javaUnicodeEscape, boolean ensureFinalEndline) {
        if (preserveTabs && preserveLines && !javaUnicodeEscape) {
            if (ensureFinalEndline) {
                if (content.length() == 0) {
                    content = "\n";
                } else {
                    char lastChar = content.charAt(content.length() - 1);
                    if (lastChar != '\n' && lastChar != '\r') {
                        if (content instanceof StringBuilder) {
                            ((StringBuilder)content).append('\n');
                        } else {
                            StringBuilder buf = new StringBuilder(content);
                            buf.append('\n');
                            content = buf.toString();
                        }
                    }
                }
            }
            return content.toString();
        }
        StringBuilder buf = new StringBuilder();
        int col = 0;
        int index = 0;
        int contentLength = content.length();
        while (index < contentLength) {
            int i;
            char ch;
            if ((ch = content.charAt(index++)) == '\n') {
                buf.append(ch);
                col = 0;
                continue;
            }
            if (javaUnicodeEscape && ch == '\\' && index < contentLength && content.charAt(index) == 'u') {
                int numPrecedingSlashes = 0;
                for (i = index - 1; i >= 0 && content.charAt(i) == '\\'; --i) {
                    ++numPrecedingSlashes;
                }
                if (numPrecedingSlashes % 2 == 0) {
                    buf.append('\\');
                    ++col;
                    continue;
                }
                int numConsecutiveUs = 0;
                for (int i2 = index; i2 < contentLength && content.charAt(i2) == 'u'; ++i2) {
                    ++numConsecutiveUs;
                }
                String fourHexDigits = content.subSequence(index + numConsecutiveUs, index + numConsecutiveUs + 4).toString();
                buf.append((char)Integer.parseInt(fourHexDigits, 16));
                index += numConsecutiveUs + 4;
                ++col;
                continue;
            }
            if (!preserveLines && ch == '\r') {
                buf.append('\n');
                col = 0;
                if (index >= contentLength || content.charAt(index) != '\n') continue;
                ++index;
                continue;
            }
            if (ch == '\t' && !preserveTabs) {
                int spacesToAdd = 1 - col % 1;
                for (i = 0; i < spacesToAdd; ++i) {
                    buf.append(' ');
                    ++col;
                }
                continue;
            }
            buf.append(ch);
            if (Character.isLowSurrogate(ch)) continue;
            ++col;
        }
        if (ensureFinalEndline) {
            if (buf.length() == 0) {
                return "\n";
            }
            char lastChar = buf.charAt(buf.length() - 1);
            if (lastChar != '\n' && lastChar != '\r') {
                buf.append('\n');
            }
        }
        return buf.toString();
    }

    static {
        IGNORED.setUnparsed(true);
        SKIPPED.setUnparsed(true);
        regularTokens = EnumSet.of(QConstants.TokenType.EOF, new QConstants.TokenType[]{QConstants.TokenType.T_O_ID, QConstants.TokenType.T_STRING, QConstants.TokenType.T_OPTIONS_SEPARATOR, QConstants.TokenType.T_O_FORMAT, QConstants.TokenType.T_O_METADATA, QConstants.TokenType.T_O_SKIPFILTER, QConstants.TokenType.T_O_COUNT, QConstants.TokenType.T_O_TOP, QConstants.TokenType.T_O_SKIP, QConstants.TokenType.T_O_SELECT, QConstants.TokenType.T_O_FILTER, QConstants.TokenType.T_O_EXPAND, QConstants.TokenType.T_O_ORDERBY, QConstants.TokenType.T_SUBQUERY_OPTIONS_SEPARATOR, QConstants.TokenType.T_CHARSEQ_FORMAT, QConstants.TokenType.T_CHARSEQ_METADATA, QConstants.TokenType.T_BOOL, QConstants.TokenType.T_LONG, QConstants.TokenType.T_VALUE_SEPARATOR, QConstants.TokenType.T_DISTINCT, QConstants.TokenType.T_ARRAYINDEX, QConstants.TokenType.T_PATH_SEPARATOR, QConstants.TokenType.T_O_ASC, QConstants.TokenType.T_O_DESC, QConstants.TokenType.T_CHARSEQ, QConstants.TokenType.T_LB, QConstants.TokenType.T_RB, QConstants.TokenType.T_QO_EQ, QConstants.TokenType.T_QO_NE, QConstants.TokenType.T_QO_GT, QConstants.TokenType.T_QO_GE, QConstants.TokenType.T_QO_LT, QConstants.TokenType.T_QO_LE, QConstants.TokenType.T_QO_IN, QConstants.TokenType.T_QO_AND, QConstants.TokenType.T_QO_NOT, QConstants.TokenType.T_QO_OR, QConstants.TokenType.T_QO_ADD, QConstants.TokenType.T_QO_SUB, QConstants.TokenType.T_QO_MUL, QConstants.TokenType.T_QO_DIV, QConstants.TokenType.T_QO_MOD, QConstants.TokenType.T_QF_SUBSTRINGOF, QConstants.TokenType.T_QF_ENDSWITH, QConstants.TokenType.T_QF_STARTSWITH, QConstants.TokenType.T_QF_LENGTH, QConstants.TokenType.T_QF_INDEXOF, QConstants.TokenType.T_QF_SUBSTRING, QConstants.TokenType.T_QF_TOLOWER, QConstants.TokenType.T_QF_TOUPPER, QConstants.TokenType.T_QF_TRIM, QConstants.TokenType.T_QF_CONCAT, QConstants.TokenType.T_QF_YEAR, QConstants.TokenType.T_QF_MONTH, QConstants.TokenType.T_QF_DAY, QConstants.TokenType.T_QF_HOUR, QConstants.TokenType.T_QF_MINUTE, QConstants.TokenType.T_QF_SECOND, QConstants.TokenType.T_QF_FRACTIONALSECONDS, QConstants.TokenType.T_QF_DATE, QConstants.TokenType.T_QF_TIME, QConstants.TokenType.T_QF_TOTALOFFSETMINUTES, QConstants.TokenType.T_QF_NOW, QConstants.TokenType.T_QF_MINDATETIME, QConstants.TokenType.T_QF_MAXDATETIME, QConstants.TokenType.T_QF_BEFORE, QConstants.TokenType.T_QF_AFTER, QConstants.TokenType.T_QF_MEETS, QConstants.TokenType.T_QF_DURING, QConstants.TokenType.T_QF_OVERLAPS, QConstants.TokenType.T_QF_STARTS, QConstants.TokenType.T_QF_FINISHES, QConstants.TokenType.T_QF_ROUND, QConstants.TokenType.T_QF_FLOOR, QConstants.TokenType.T_QF_CEILING, QConstants.TokenType.T_QF_GEO_DISTANCE, QConstants.TokenType.T_QF_GEO_LENGTH, QConstants.TokenType.T_QF_GEO_INTERSECTS, QConstants.TokenType.T_QF_ST_EQUALS, QConstants.TokenType.T_QF_ST_DISJOINT, QConstants.TokenType.T_QF_ST_TOUCHES, QConstants.TokenType.T_QF_ST_WITHIN, QConstants.TokenType.T_QF_ST_OVERLAPS, QConstants.TokenType.T_QF_ST_CROSSES, QConstants.TokenType.T_QF_ST_INTERSECTS, QConstants.TokenType.T_QF_ST_CONTAINS, QConstants.TokenType.T_QF_ST_RELATE, QConstants.TokenType.T_QF_PRINCIPAL_NAME, QConstants.TokenType.T_STR_LIT, QConstants.TokenType.T_GEO_STR_LIT, QConstants.TokenType.T_DURATION, QConstants.TokenType.T_DATE, QConstants.TokenType.T_TIME, QConstants.TokenType.T_DATETIME, QConstants.TokenType.T_DATETIMEINTERVAL, QConstants.TokenType.T_DOUBLE, QConstants.TokenType.T_NULL});
        unparsedTokens = EnumSet.noneOf(QConstants.TokenType.class);
        skippedTokens = EnumSet.of(QConstants.TokenType._TOKEN_1, QConstants.TokenType._TOKEN_2, QConstants.TokenType._TOKEN_3, QConstants.TokenType._TOKEN_4);
        moreTokens = EnumSet.noneOf(QConstants.TokenType.class);
    }
}

