/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.frostserver.util.pathparser;

import de.fraunhofer.iosb.ilt.frostserver.util.pathparser.InvalidToken;
import de.fraunhofer.iosb.ilt.frostserver.util.pathparser.Node;
import de.fraunhofer.iosb.ilt.frostserver.util.pathparser.PConstants;
import de.fraunhofer.iosb.ilt.frostserver.util.pathparser.PLexer;
import de.fraunhofer.iosb.ilt.frostserver.util.pathparser.nodes.T_ARRAYINDEX;
import de.fraunhofer.iosb.ilt.frostserver.util.pathparser.nodes.T_DOUBLE;
import de.fraunhofer.iosb.ilt.frostserver.util.pathparser.nodes.T_LB;
import de.fraunhofer.iosb.ilt.frostserver.util.pathparser.nodes.T_LONG;
import de.fraunhofer.iosb.ilt.frostserver.util.pathparser.nodes.T_NAME;
import de.fraunhofer.iosb.ilt.frostserver.util.pathparser.nodes.T_PATH_SEPARATOR;
import de.fraunhofer.iosb.ilt.frostserver.util.pathparser.nodes.T_RB;
import de.fraunhofer.iosb.ilt.frostserver.util.pathparser.nodes.T_REF;
import de.fraunhofer.iosb.ilt.frostserver.util.pathparser.nodes.T_STR_LIT;
import de.fraunhofer.iosb.ilt.frostserver.util.pathparser.nodes.T_VALUE;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

public class Token
implements PConstants,
Node {
    private PConstants.TokenType type;
    private PLexer tokenSource;
    private int beginOffset;
    private int endOffset;
    private boolean unparsed;
    private Node parent;
    private String image;
    private Token prependedToken;
    private Token appendedToken;
    private boolean inserted;

    public void setImage(String image) {
        this.image = image;
    }

    public boolean isInserted() {
        return this.inserted;
    }

    public void preInsert(Token prependedToken) {
        if (prependedToken == this.prependedToken) {
            return;
        }
        prependedToken.appendedToken = this;
        Token existingPreviousToken = this.previousCachedToken();
        if (existingPreviousToken != null) {
            existingPreviousToken.appendedToken = prependedToken;
            prependedToken.prependedToken = existingPreviousToken;
        }
        prependedToken.inserted = true;
        prependedToken.beginOffset = prependedToken.endOffset = this.beginOffset;
        this.prependedToken = prependedToken;
    }

    void unsetAppendedToken() {
        this.appendedToken = null;
    }

    public Token(PConstants.TokenType type, String image, PLexer tokenSource) {
        this.type = type;
        this.image = image;
        this.tokenSource = tokenSource;
    }

    public static Token newToken(PConstants.TokenType type, String image, PLexer tokenSource) {
        Token result = Token.newToken(type, tokenSource, 0, 0);
        result.setImage(image);
        return result;
    }

    @Override
    public void setBeginOffset(int beginOffset) {
        this.beginOffset = beginOffset;
    }

    @Override
    public void setEndOffset(int endOffset) {
        this.endOffset = endOffset;
    }

    @Override
    public PLexer getTokenSource() {
        PLexer flm = this.tokenSource;
        if (flm == null) {
            if (this.prependedToken != null) {
                flm = this.prependedToken.getTokenSource();
            }
            if (flm == null && this.appendedToken != null) {
                flm = this.appendedToken.getTokenSource();
            }
        }
        return flm;
    }

    @Override
    public void setTokenSource(PLexer tokenSource) {
        this.tokenSource = tokenSource;
    }

    public PConstants.TokenType getType() {
        return this.type;
    }

    protected void setType(PConstants.TokenType type) {
        this.type = type;
    }

    public boolean isVirtual() {
        return this.type == PConstants.TokenType.EOF;
    }

    public boolean isSkipped() {
        return false;
    }

    @Override
    public int getBeginOffset() {
        return this.beginOffset;
    }

    @Override
    public int getEndOffset() {
        return this.endOffset;
    }

    public String getImage() {
        return this.image != null ? this.image : this.getSource();
    }

    public final Token getNext() {
        return this.getNextParsedToken();
    }

    public final Token getPrevious() {
        Token result;
        for (result = this.previousCachedToken(); result != null && result.isUnparsed(); result = result.previousCachedToken()) {
        }
        return result;
    }

    private Token getNextParsedToken() {
        Token result;
        for (result = this.nextCachedToken(); result != null && result.isUnparsed(); result = result.nextCachedToken()) {
        }
        return result;
    }

    public Token nextCachedToken() {
        if (this.appendedToken != null) {
            return this.appendedToken;
        }
        PLexer tokenSource = this.getTokenSource();
        return tokenSource != null ? tokenSource.nextCachedToken(this.getEndOffset()) : null;
    }

    public Token previousCachedToken() {
        if (this.prependedToken != null) {
            return this.prependedToken;
        }
        if (this.getTokenSource() == null) {
            return null;
        }
        return this.getTokenSource().previousCachedToken(this.getBeginOffset());
    }

    Token getPreviousToken() {
        return this.previousCachedToken();
    }

    public Token replaceType(PConstants.TokenType type) {
        Token result = Token.newToken(type, this.getTokenSource(), this.getBeginOffset(), this.getEndOffset());
        result.prependedToken = this.prependedToken;
        result.appendedToken = this.appendedToken;
        result.inserted = this.inserted;
        if (result.appendedToken != null) {
            result.appendedToken.prependedToken = result;
        }
        if (result.prependedToken != null) {
            result.prependedToken.appendedToken = result;
        }
        if (!result.inserted) {
            this.getTokenSource().cacheToken(result);
        }
        return result;
    }

    @Override
    public String getSource() {
        if (this.type == PConstants.TokenType.EOF) {
            return "";
        }
        PLexer flm = this.getTokenSource();
        return flm == null ? null : flm.getText(this.getBeginOffset(), this.getEndOffset());
    }

    protected Token() {
    }

    public Token(PConstants.TokenType type, PLexer tokenSource, int beginOffset, int endOffset) {
        this.type = type;
        this.tokenSource = tokenSource;
        this.beginOffset = beginOffset;
        this.endOffset = endOffset;
    }

    @Override
    public boolean isUnparsed() {
        return this.unparsed;
    }

    @Override
    public void setUnparsed(boolean unparsed) {
        this.unparsed = unparsed;
    }

    @Override
    public void clearChildren() {
    }

    public String getNormalizedText() {
        if (this.getType() == PConstants.TokenType.EOF) {
            return "EOF";
        }
        return this.getImage();
    }

    public String toString() {
        return this.getNormalizedText();
    }

    public Iterator<Token> precedingTokens() {
        return new Iterator<Token>(){
            Token currentPoint;
            {
                this.currentPoint = Token.this;
            }

            @Override
            public boolean hasNext() {
                return this.currentPoint.previousCachedToken() != null;
            }

            @Override
            public Token next() {
                Token previous = this.currentPoint.previousCachedToken();
                if (previous == null) {
                    throw new NoSuchElementException("No previous token!");
                }
                this.currentPoint = previous;
                return this.currentPoint;
            }
        };
    }

    public List<Token> precedingUnparsedTokens() {
        ArrayList<Token> result = new ArrayList<Token>();
        for (Token t = this.previousCachedToken(); t != null && t.isUnparsed(); t = t.previousCachedToken()) {
            result.add(t);
        }
        Collections.reverse(result);
        return result;
    }

    public Iterator<Token> followingTokens() {
        return new Iterator<Token>(){
            Token currentPoint;
            {
                this.currentPoint = Token.this;
            }

            @Override
            public boolean hasNext() {
                return this.currentPoint.nextCachedToken() != null;
            }

            @Override
            public Token next() {
                Token next = this.currentPoint.nextCachedToken();
                if (next == null) {
                    throw new NoSuchElementException("No next token!");
                }
                this.currentPoint = next;
                return this.currentPoint;
            }
        };
    }

    @Override
    public void copyLocationInfo(Node from) {
        Node.super.copyLocationInfo(from);
        if (from instanceof Token) {
            Token otherTok = (Token)from;
            this.appendedToken = otherTok.appendedToken;
            this.prependedToken = otherTok.prependedToken;
        }
        this.setTokenSource(from.getTokenSource());
    }

    @Override
    public void copyLocationInfo(Node start, Node end) {
        Node.super.copyLocationInfo(start, end);
        if (start instanceof Token) {
            this.prependedToken = ((Token)start).prependedToken;
        }
        if (end instanceof Token) {
            Token endToken = (Token)end;
            this.appendedToken = endToken.appendedToken;
        }
    }

    public static Token newToken(PConstants.TokenType type, PLexer tokenSource, int beginOffset, int endOffset) {
        switch (type) {
            case T_PATH_SEPARATOR: {
                return new T_PATH_SEPARATOR(PConstants.TokenType.T_PATH_SEPARATOR, tokenSource, beginOffset, endOffset);
            }
            case T_VALUE: {
                return new T_VALUE(PConstants.TokenType.T_VALUE, tokenSource, beginOffset, endOffset);
            }
            case T_REF: {
                return new T_REF(PConstants.TokenType.T_REF, tokenSource, beginOffset, endOffset);
            }
            case T_LB: {
                return new T_LB(PConstants.TokenType.T_LB, tokenSource, beginOffset, endOffset);
            }
            case T_RB: {
                return new T_RB(PConstants.TokenType.T_RB, tokenSource, beginOffset, endOffset);
            }
            case T_NAME: {
                return new T_NAME(PConstants.TokenType.T_NAME, tokenSource, beginOffset, endOffset);
            }
            case T_LONG: {
                return new T_LONG(PConstants.TokenType.T_LONG, tokenSource, beginOffset, endOffset);
            }
            case T_DOUBLE: {
                return new T_DOUBLE(PConstants.TokenType.T_DOUBLE, tokenSource, beginOffset, endOffset);
            }
            case T_STR_LIT: {
                return new T_STR_LIT(PConstants.TokenType.T_STR_LIT, tokenSource, beginOffset, endOffset);
            }
            case T_ARRAYINDEX: {
                return new T_ARRAYINDEX(PConstants.TokenType.T_ARRAYINDEX, tokenSource, beginOffset, endOffset);
            }
            case INVALID: {
                return new InvalidToken(tokenSource, beginOffset, endOffset);
            }
        }
        return new Token(type, tokenSource, beginOffset, endOffset);
    }

    @Override
    public String getLocation() {
        return this.getInputSource() + ":" + this.getBeginLine() + ":" + this.getBeginColumn();
    }

    @Override
    public void setChild(int i, Node n) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void addChild(Node n) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void addChild(int i, Node n) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Node removeChild(int i) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final int indexOf(Node n) {
        return -1;
    }

    @Override
    public Node getParent() {
        return this.parent;
    }

    @Override
    public void setParent(Node parent) {
        this.parent = parent;
    }

    @Override
    public final int getChildCount() {
        return 0;
    }

    @Override
    public final Node getChild(int i) {
        return null;
    }

    @Override
    public final List<Node> children() {
        return Collections.emptyList();
    }
}

