/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.frostserver.util.queryparser;

import java.io.IOException;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;

public interface QConstants {
    public static final int BUF_SIZE = 65536;

    public static String displayChar(int ch) {
        if (ch == 39) {
            return "'\\''";
        }
        if (ch == 92) {
            return "'\\\\'";
        }
        if (ch == 9) {
            return "'\\t'";
        }
        if (ch == 13) {
            return "'\\r'";
        }
        if (ch == 10) {
            return "'\\n'";
        }
        if (ch == 12) {
            return "'\\f'";
        }
        if (ch == 32) {
            return "' '";
        }
        if (ch < 128 && !Character.isWhitespace(ch) && !Character.isISOControl(ch)) {
            return "'" + (char)ch + "'";
        }
        if (ch < 10) {
            return "" + ch;
        }
        return "0x" + Integer.toHexString(ch);
    }

    public static String addEscapes(String str) {
        StringBuilder retval = new StringBuilder();
        block10: for (int ch : str.codePoints().toArray()) {
            switch (ch) {
                case 8: {
                    retval.append("\\b");
                    continue block10;
                }
                case 9: {
                    retval.append("\\t");
                    continue block10;
                }
                case 10: {
                    retval.append("\\n");
                    continue block10;
                }
                case 12: {
                    retval.append("\\f");
                    continue block10;
                }
                case 13: {
                    retval.append("\\r");
                    continue block10;
                }
                case 34: {
                    retval.append("\\\"");
                    continue block10;
                }
                case 39: {
                    retval.append("\\'");
                    continue block10;
                }
                case 92: {
                    retval.append("\\\\");
                    continue block10;
                }
                default: {
                    if (Character.isISOControl(ch)) {
                        String s = "0000" + Integer.toString(ch, 16);
                        retval.append("\\u" + s.substring(s.length() - 4, s.length()));
                        continue block10;
                    }
                    retval.appendCodePoint(ch);
                    continue block10;
                }
            }
        }
        return retval.toString();
    }

    public static String readToEnd(Reader reader) {
        try {
            return QConstants.readFully(reader);
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    public static String readFully(Reader reader) throws IOException {
        char[] block = new char[65536];
        int charsRead = reader.read(block);
        if (charsRead < 0) {
            throw new IOException("No input");
        }
        if (charsRead < 65536) {
            char[] result = new char[charsRead];
            System.arraycopy(block, 0, result, 0, charsRead);
            reader.close();
            return new String(block, 0, charsRead);
        }
        StringBuilder buf = new StringBuilder();
        buf.append(block);
        do {
            if ((charsRead = reader.read(block)) <= 0) continue;
            buf.append(block, 0, charsRead);
        } while (charsRead == 65536);
        reader.close();
        return buf.toString();
    }

    public static String stringFromBytes(byte[] bytes, Charset charset) {
        int arrayLength = bytes.length;
        if (charset == null) {
            int fourthByte;
            int firstByte = arrayLength > 0 ? Byte.toUnsignedInt(bytes[0]) : 1;
            int secondByte = arrayLength > 1 ? Byte.toUnsignedInt(bytes[1]) : 1;
            int thirdByte = arrayLength > 2 ? Byte.toUnsignedInt(bytes[2]) : 1;
            int n = fourthByte = arrayLength > 3 ? Byte.toUnsignedInt(bytes[3]) : 1;
            if (firstByte == 239 && secondByte == 187 && thirdByte == 191) {
                return new String(bytes, 3, bytes.length - 3, Charset.forName("UTF-8"));
            }
            if (firstByte == 0 && secondByte == 0 && thirdByte == 254 && fourthByte == 255) {
                return new String(bytes, 4, bytes.length - 4, Charset.forName("UTF-32BE"));
            }
            if (firstByte == 255 && secondByte == 254 && thirdByte == 0 && fourthByte == 0) {
                return new String(bytes, 4, bytes.length - 4, Charset.forName("UTF-32LE"));
            }
            if (firstByte == 254 && secondByte == 255) {
                return new String(bytes, 2, bytes.length - 2, Charset.forName("UTF-16BE"));
            }
            if (firstByte == 255 && secondByte == 254) {
                return new String(bytes, 2, bytes.length - 2, Charset.forName("UTF-16LE"));
            }
            charset = StandardCharsets.UTF_8;
        }
        return new String(bytes, charset);
    }

    public static String stringFromBytes(byte[] bytes) {
        return QConstants.stringFromBytes(bytes, null);
    }

    public static enum LexicalState {
        DEFAULT,
        LS_REF,
        LS_QUERY,
        LS_SUBQUERY,
        LS_FILTER,
        LS_CONSTANTS,
        LS_PLAIN_PATH,
        LS_ORDERBYS,
        LS_ORDERBY,
        LS_ANYSTRING,
        LS_FORMAT,
        LS_METADATA,
        LS_COUNT,
        LS_TOP,
        LS_SKIP,
        LS_EXPAND,
        LS_SELECT;

    }

    public static enum TokenType {
        EOF,
        _TOKEN_1,
        _TOKEN_2,
        _TOKEN_3,
        _TOKEN_4,
        T_O_ID,
        T_STRING,
        T_OPTIONS_SEPARATOR,
        T_O_FORMAT,
        T_O_METADATA,
        T_O_SKIPFILTER,
        T_O_COUNT,
        T_O_TOP,
        T_O_SKIP,
        T_O_SELECT,
        T_O_FILTER,
        T_O_EXPAND,
        T_O_ORDERBY,
        T_SUBQUERY_OPTIONS_SEPARATOR,
        T_CHARSEQ_FORMAT,
        T_CHARSEQ_METADATA,
        T_BOOL,
        T_LONG,
        T_VALUE_SEPARATOR,
        T_DISTINCT,
        T_ARRAYINDEX,
        T_PATH_SEPARATOR,
        T_O_ASC,
        T_O_DESC,
        T_CHARSEQ,
        T_LB,
        T_RB,
        T_QO_EQ,
        T_QO_NE,
        T_QO_GT,
        T_QO_GE,
        T_QO_LT,
        T_QO_LE,
        T_QO_IN,
        T_QO_AND,
        T_QO_NOT,
        T_QO_OR,
        T_QO_ADD,
        T_QO_SUB,
        T_QO_MUL,
        T_QO_DIV,
        T_QO_MOD,
        T_QF_SUBSTRINGOF,
        T_QF_ENDSWITH,
        T_QF_STARTSWITH,
        T_QF_LENGTH,
        T_QF_INDEXOF,
        T_QF_SUBSTRING,
        T_QF_TOLOWER,
        T_QF_TOUPPER,
        T_QF_TRIM,
        T_QF_CONCAT,
        T_QF_YEAR,
        T_QF_MONTH,
        T_QF_DAY,
        T_QF_HOUR,
        T_QF_MINUTE,
        T_QF_SECOND,
        T_QF_FRACTIONALSECONDS,
        T_QF_DATE,
        T_QF_TIME,
        T_QF_TOTALOFFSETMINUTES,
        T_QF_NOW,
        T_QF_MINDATETIME,
        T_QF_MAXDATETIME,
        T_QF_BEFORE,
        T_QF_AFTER,
        T_QF_MEETS,
        T_QF_DURING,
        T_QF_OVERLAPS,
        T_QF_STARTS,
        T_QF_FINISHES,
        T_QF_ROUND,
        T_QF_FLOOR,
        T_QF_CEILING,
        T_QF_GEO_DISTANCE,
        T_QF_GEO_LENGTH,
        T_QF_GEO_INTERSECTS,
        T_QF_ST_EQUALS,
        T_QF_ST_DISJOINT,
        T_QF_ST_TOUCHES,
        T_QF_ST_WITHIN,
        T_QF_ST_OVERLAPS,
        T_QF_ST_CROSSES,
        T_QF_ST_INTERSECTS,
        T_QF_ST_CONTAINS,
        T_QF_ST_RELATE,
        T_QF_PRINCIPAL_NAME,
        T_STR_LIT,
        T_GEO_STR_LIT,
        T_DURATION,
        T_DATE,
        T_TIME,
        T_DATETIME,
        T_DATETIMEINTERVAL,
        T_DOUBLE,
        T_NULL,
        INVALID;

    }
}

