/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.frostserver.util.pathparser;

import de.fraunhofer.iosb.ilt.frostserver.util.pathparser.Node;
import de.fraunhofer.iosb.ilt.frostserver.util.pathparser.PLexer;
import de.fraunhofer.iosb.ilt.frostserver.util.pathparser.Token;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class BaseNode
implements Node {
    private PLexer tokenSource;
    private static Class listClass = ArrayList.class;
    protected Node parent;
    protected List<Node> children = this.newList();
    private int beginOffset;
    private int endOffset;
    private boolean unparsed;

    @Override
    public PLexer getTokenSource() {
        if (this.tokenSource == null) {
            for (Node child : this.children()) {
                this.tokenSource = child.getTokenSource();
                if (this.tokenSource == null) continue;
                break;
            }
        }
        return this.tokenSource;
    }

    @Override
    public void setTokenSource(PLexer tokenSource) {
        this.tokenSource = tokenSource;
    }

    public static void setListClass(Class<? extends List> listClass) {
        BaseNode.listClass = listClass;
    }

    private List<Node> newList() {
        try {
            return (List)listClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean isUnparsed() {
        return this.unparsed;
    }

    @Override
    public void setUnparsed(boolean unparsed) {
        this.unparsed = unparsed;
    }

    @Override
    public void setParent(Node n) {
        this.parent = n;
    }

    @Override
    public Node getParent() {
        return this.parent;
    }

    @Override
    public void addChild(Node n) {
        this.children.add(n);
        n.setParent(this);
    }

    @Override
    public void addChild(int i, Node n) {
        this.children.add(i, n);
        n.setParent(this);
    }

    @Override
    public Node getChild(int i) {
        return this.children.get(i);
    }

    @Override
    public void setChild(int i, Node n) {
        this.children.set(i, n);
        n.setParent(this);
    }

    @Override
    public Node removeChild(int i) {
        return this.children.remove(i);
    }

    @Override
    public void clearChildren() {
        this.children.clear();
    }

    @Override
    public int getChildCount() {
        return this.children.size();
    }

    @Override
    public List<Node> children() {
        return Collections.unmodifiableList(this.children);
    }

    @Override
    public int getBeginOffset() {
        return this.beginOffset;
    }

    @Override
    public void setBeginOffset(int beginOffset) {
        this.beginOffset = beginOffset;
    }

    @Override
    public int getEndOffset() {
        return this.endOffset;
    }

    @Override
    public void setEndOffset(int endOffset) {
        this.endOffset = endOffset;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        for (Token t : this.getRealTokens()) {
            buf.append(t);
        }
        return buf.toString();
    }
}

