/* Generated by: JavaCC 21 Parser Generator. WParser.java */
package de.fraunhofer.iosb.ilt.frostserver.util.wktparser;

import java.util.Arrays;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Map;
import java.util.concurrent.CancellationException;
import java.io.*;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.charset.Charset;
import de.fraunhofer.iosb.ilt.frostserver.util.wktparser.nodes.Start;
import de.fraunhofer.iosb.ilt.frostserver.util.wktparser.nodes.WktPoint;
import de.fraunhofer.iosb.ilt.frostserver.util.wktparser.nodes.WktMultiPoint;
import de.fraunhofer.iosb.ilt.frostserver.util.wktparser.nodes.WktLineString;
import de.fraunhofer.iosb.ilt.frostserver.util.wktparser.nodes.WktPolygon;
import de.fraunhofer.iosb.ilt.frostserver.util.wktparser.nodes.LinearRing;
import de.fraunhofer.iosb.ilt.frostserver.util.wktparser.nodes.Coords2;
import de.fraunhofer.iosb.ilt.frostserver.util.wktparser.nodes.Coords3;
import static de.fraunhofer.iosb.ilt.frostserver.util.wktparser.WConstants.TokenType.*;
@SuppressWarnings("unused")
public class WParser implements WConstants {
    static final int UNLIMITED= Integer.MAX_VALUE;
    // The last token successfully "consumed"
    Token lastConsumedToken;
    private TokenType nextTokenType;
    private Token currentLookaheadToken;
    private boolean scanToEnd;
    private String currentlyParsedProduction, currentLookaheadProduction;
    private boolean cancelled;
    public void cancel() {
        cancelled= true;
    }

    public boolean isCancelled() {
        return cancelled;
    }

    /** Generated Lexer. */
    public WLexer token_source;
    public void setInputSource(String inputSource) {
        token_source.setInputSource(inputSource);
    }

    String getInputSource() {
        return token_source.getInputSource();
    }

    //=================================
    // Generated constructors
    //=================================
    public WParser(String inputSource, CharSequence content) {
        this(new WLexer(inputSource, content));
    }

    public WParser(CharSequence content) {
        this("input", content);
    }

    /**
   * @param inputSource just the name of the input source (typically the filename) that 
   * will be used in error messages and so on.
   * @param path The location (typically the filename) from which to get the input to parse
   */
    public WParser(String inputSource, Path path) throws IOException {
        this(inputSource, WConstants.stringFromBytes(Files.readAllBytes(path)));
    }

    public WParser(String inputSource, Path path, Charset charset) throws IOException {
        this(inputSource, WConstants.stringFromBytes(Files.readAllBytes(path), charset));
    }

    /**
   * @param path The location (typically the filename) from which to get the input to parse
   */
    public WParser(Path path) throws IOException {
        this(path.toString(), path);
    }

    /**
   * @Deprecated Use the constructor that takes a #java.nio.files.Path or just 
   * a String (i.e. CharSequence) directly.
   */
    public WParser(java.io.InputStream stream) {
        this(new InputStreamReader(stream));
    }

    /**
   * @Deprecated Use the constructor that takes a #java.nio.files.Path or just 
   * a String (i.e. CharSequence) directly.
   */
    public WParser(Reader reader) {
        this(new WLexer("input", reader));
    }

    /** Constructor with user supplied Lexer. */
    public WParser(WLexer lexer) {
        token_source= lexer;
        lastConsumedToken= lexer.DUMMY_START_TOKEN;
        lastConsumedToken.setTokenSource(lexer);
    }

    // If the next token is cached, it returns that
    // Otherwise, it goes to the token_source, i.e. the Lexer.
    final private Token nextToken(final Token tok) {
        Token result= token_source.getNextToken(tok);
        while (result.isUnparsed()) {
            result= token_source.getNextToken(result);
        }
        nextTokenType= null;
        return result;
    }

    /**
   * @return the next Token off the stream. This is the same as #getToken(1)
   */
    final public Token getNextToken() {
        return getToken(1);
    }

    /**
 * @param index how many tokens to look ahead
 * @return the specific regular (i.e. parsed) Token index ahead/behind in the stream. 
 * If we are in a lookahead, it looks ahead from the currentLookaheadToken
 * Otherwise, it is the lastConsumedToken. If you pass in a negative
 * number it goes backward.
 */
    final public Token getToken(final int index) {
        Token t= currentLookaheadToken== null?lastConsumedToken:
        currentLookaheadToken;
        for (int i= 0; i<index; i++) {
            t= nextToken(t);
        }
        for (int i= 0; i> index; i--) {
            t= t.getPrevious();
            if (t== null) break;
        }
        return t;
    }

    private final TokenType nextTokenType() {
        if (nextTokenType== null) {
            nextTokenType= nextToken(lastConsumedToken).getType();
        }
        return nextTokenType;
    }

    boolean activateTokenTypes(TokenType...types) {
        boolean result= false;
        for (TokenType tt : types) {
            result|=token_source.activeTokenTypes.add(tt);
        }
        token_source.reset(getToken(0));
        nextTokenType= null;
        return result;
    }

    boolean deactivateTokenTypes(TokenType...types) {
        boolean result= false;
        for (TokenType tt : types) {
            result|=token_source.activeTokenTypes.remove(tt);
        }
        token_source.reset(getToken(0));
        nextTokenType= null;
        return result;
    }

    private static HashMap<TokenType[], EnumSet<TokenType> > enumSetCache= new HashMap<> ();
    private static EnumSet<TokenType> tokenTypeSet(TokenType first, TokenType...rest) {
        TokenType[] key= new TokenType[1+rest.length];
        key[0]= first;
        if (rest.length> 0) {
            System.arraycopy(rest, 0, key, 1, rest.length);
        }
        Arrays.sort(key);
        if (enumSetCache.containsKey(key)) {
            return enumSetCache.get(key);
        }
        EnumSet<TokenType> result= (rest.length== 0)?EnumSet.of(first):
        EnumSet.of(first, rest);
        enumSetCache.put(key, result);
        return result;
    }

    // src/main/congocc/wktParser.ccc:48:1
    final public Start Start() throws ParseException {
        if (cancelled) throw new CancellationException();
        String prevProduction= currentlyParsedProduction;
        this.currentlyParsedProduction= "Start";
        Start Start1= null;
        if (buildTree) {
            Start1= new Start();
            openNodeScope(Start1);
        }
        ParseException parseException1= null;
        int callStackSize2= parsingStack.size();
        try {
            if (false) throw new ParseException("Never happens!");
            if (nextTokenType()== POINT) {
                // Code for NonTerminal specified at:
                // src/main/congocc/wktParser.ccc:49:5
                pushOntoCallStack("Start", "src/main/congocc/wktParser.ccc", 49, 5);
                try {
                    PointWithData();
                }
                finally {
                    popCallStack();
                }
            }
            else if (nextTokenType()== MULTIPOINT) {
                // Code for NonTerminal specified at:
                // src/main/congocc/wktParser.ccc:50:5
                pushOntoCallStack("Start", "src/main/congocc/wktParser.ccc", 50, 5);
                try {
                    MultiPointWithData();
                }
                finally {
                    popCallStack();
                }
            }
            else if (nextTokenType()== LINESTRING) {
                // Code for NonTerminal specified at:
                // src/main/congocc/wktParser.ccc:51:5
                pushOntoCallStack("Start", "src/main/congocc/wktParser.ccc", 51, 5);
                try {
                    LineStringWithData();
                }
                finally {
                    popCallStack();
                }
            }
            else if (nextTokenType()== POLYGON) {
                // Code for NonTerminal specified at:
                // src/main/congocc/wktParser.ccc:52:5
                pushOntoCallStack("Start", "src/main/congocc/wktParser.ccc", 52, 5);
                try {
                    PolygonWithData();
                }
                finally {
                    popCallStack();
                }
            }
            else  {
                pushOntoCallStack("Start", "src/main/congocc/wktParser.ccc", 49, 5);
                throw new ParseException(this, first_set$wktParser_ccc$49$5, parsingStack);
            }
            // Code for EndOfFile specified at:
            // src/main/congocc/wktParser.ccc:53:5
            consumeToken(EOF);
            // Code for CodeBlock specified at:
            // src/main/congocc/wktParser.ccc:54:3
            return Start1;
        }
        catch(ParseException e) {
            parseException1= e;
            throw e;
        }
        finally {
            restoreCallStack(callStackSize2);
            if (Start1!=null) {
                if (parseException1== null) {
                    closeNodeScope(Start1, nodeArity()> 1);
                }
                else  {
                    clearNodeScope();
                }
            }
            this.currentlyParsedProduction= prevProduction;
        }
    }

    // src/main/congocc/wktParser.ccc:57:1
    final public void PointWithData() throws ParseException {
        if (cancelled) throw new CancellationException();
        String prevProduction= currentlyParsedProduction;
        this.currentlyParsedProduction= "PointWithData";
        WktPoint PointWithData2= null;
        if (buildTree) {
            PointWithData2= new WktPoint();
            openNodeScope(PointWithData2);
        }
        ParseException parseException38= null;
        int callStackSize39= parsingStack.size();
        try {
            if (false) throw new ParseException("Never happens!");
            // Code for RegexpRef specified at:
            // src/main/congocc/wktParser.ccc:58:3
            consumeToken(POINT);
            if (nextTokenType()== ZoM) {
                // Code for RegexpRef specified at:
                // src/main/congocc/wktParser.ccc:59:5
                consumeToken(ZoM);
                // Code for RegexpRef specified at:
                // src/main/congocc/wktParser.ccc:59:11
                consumeToken(LB);
                // Code for NonTerminal specified at:
                // src/main/congocc/wktParser.ccc:59:16
                pushOntoCallStack("PointWithData", "src/main/congocc/wktParser.ccc", 59, 16);
                try {
                    Coords3();
                }
                finally {
                    popCallStack();
                }
                // Code for RegexpRef specified at:
                // src/main/congocc/wktParser.ccc:59:24
                consumeToken(RB);
            }
            else if (nextTokenType()== LB) {
                // Code for RegexpRef specified at:
                // src/main/congocc/wktParser.ccc:60:11
                consumeToken(LB);
                // Code for NonTerminal specified at:
                // src/main/congocc/wktParser.ccc:60:16
                pushOntoCallStack("PointWithData", "src/main/congocc/wktParser.ccc", 60, 16);
                try {
                    Coords2();
                }
                finally {
                    popCallStack();
                }
                // Code for RegexpRef specified at:
                // src/main/congocc/wktParser.ccc:60:24
                consumeToken(RB);
            }
            else  {
                pushOntoCallStack("PointWithData", "src/main/congocc/wktParser.ccc", 59, 5);
                throw new ParseException(this, first_set$wktParser_ccc$59$5, parsingStack);
            }
        }
        catch(ParseException e) {
            parseException38= e;
            throw e;
        }
        finally {
            restoreCallStack(callStackSize39);
            if (PointWithData2!=null) {
                if (parseException38== null) {
                    closeNodeScope(PointWithData2, true);
                }
                else  {
                    clearNodeScope();
                }
            }
            this.currentlyParsedProduction= prevProduction;
        }
    }

    // src/main/congocc/wktParser.ccc:64:1
    final public void MultiPointWithData() throws ParseException {
        if (cancelled) throw new CancellationException();
        String prevProduction= currentlyParsedProduction;
        this.currentlyParsedProduction= "MultiPointWithData";
        WktMultiPoint MultiPointWithData3= null;
        if (buildTree) {
            MultiPointWithData3= new WktMultiPoint();
            openNodeScope(MultiPointWithData3);
        }
        ParseException parseException75= null;
        int callStackSize76= parsingStack.size();
        try {
            if (false) throw new ParseException("Never happens!");
            // Code for RegexpRef specified at:
            // src/main/congocc/wktParser.ccc:65:3
            consumeToken(MULTIPOINT);
            if (nextTokenType()== ZoM) {
                // Code for RegexpRef specified at:
                // src/main/congocc/wktParser.ccc:66:5
                consumeToken(ZoM);
                // Code for RegexpRef specified at:
                // src/main/congocc/wktParser.ccc:66:11
                consumeToken(LB);
                // Code for RegexpRef specified at:
                // src/main/congocc/wktParser.ccc:66:16
                consumeToken(LB);
                // Code for NonTerminal specified at:
                // src/main/congocc/wktParser.ccc:66:21
                pushOntoCallStack("MultiPointWithData", "src/main/congocc/wktParser.ccc", 66, 21);
                try {
                    Coords3();
                }
                finally {
                    popCallStack();
                }
                // Code for RegexpRef specified at:
                // src/main/congocc/wktParser.ccc:66:29
                consumeToken(RB);
                // Code for ZeroOrMore specified at:
                // src/main/congocc/wktParser.ccc:66:34
                while (true) {
                    if (!(nextTokenType()== COMMA)) break;
                    // Code for RegexpRef specified at:
                    // src/main/congocc/wktParser.ccc:66:35
                    consumeToken(COMMA);
                    // Code for RegexpRef specified at:
                    // src/main/congocc/wktParser.ccc:66:43
                    consumeToken(LB);
                    // Code for NonTerminal specified at:
                    // src/main/congocc/wktParser.ccc:66:48
                    pushOntoCallStack("MultiPointWithData", "src/main/congocc/wktParser.ccc", 66, 48);
                    try {
                        Coords3();
                    }
                    finally {
                        popCallStack();
                    }
                    // Code for RegexpRef specified at:
                    // src/main/congocc/wktParser.ccc:66:56
                    consumeToken(RB);
                }
                // Code for RegexpRef specified at:
                // src/main/congocc/wktParser.ccc:66:63
                consumeToken(RB);
            }
            else if (nextTokenType()== LB) {
                // Code for RegexpRef specified at:
                // src/main/congocc/wktParser.ccc:67:11
                consumeToken(LB);
                // Code for RegexpRef specified at:
                // src/main/congocc/wktParser.ccc:67:16
                consumeToken(LB);
                // Code for NonTerminal specified at:
                // src/main/congocc/wktParser.ccc:67:21
                pushOntoCallStack("MultiPointWithData", "src/main/congocc/wktParser.ccc", 67, 21);
                try {
                    Coords2();
                }
                finally {
                    popCallStack();
                }
                // Code for RegexpRef specified at:
                // src/main/congocc/wktParser.ccc:67:29
                consumeToken(RB);
                // Code for ZeroOrMore specified at:
                // src/main/congocc/wktParser.ccc:67:34
                while (true) {
                    if (!(nextTokenType()== COMMA)) break;
                    // Code for RegexpRef specified at:
                    // src/main/congocc/wktParser.ccc:67:35
                    consumeToken(COMMA);
                    // Code for RegexpRef specified at:
                    // src/main/congocc/wktParser.ccc:67:43
                    consumeToken(LB);
                    // Code for NonTerminal specified at:
                    // src/main/congocc/wktParser.ccc:67:48
                    pushOntoCallStack("MultiPointWithData", "src/main/congocc/wktParser.ccc", 67, 48);
                    try {
                        Coords2();
                    }
                    finally {
                        popCallStack();
                    }
                    // Code for RegexpRef specified at:
                    // src/main/congocc/wktParser.ccc:67:56
                    consumeToken(RB);
                }
                // Code for RegexpRef specified at:
                // src/main/congocc/wktParser.ccc:67:63
                consumeToken(RB);
            }
            else  {
                pushOntoCallStack("MultiPointWithData", "src/main/congocc/wktParser.ccc", 66, 5);
                throw new ParseException(this, first_set$wktParser_ccc$66$5, parsingStack);
            }
        }
        catch(ParseException e) {
            parseException75= e;
            throw e;
        }
        finally {
            restoreCallStack(callStackSize76);
            if (MultiPointWithData3!=null) {
                if (parseException75== null) {
                    closeNodeScope(MultiPointWithData3, true);
                }
                else  {
                    clearNodeScope();
                }
            }
            this.currentlyParsedProduction= prevProduction;
        }
    }

    // src/main/congocc/wktParser.ccc:71:1
    final public void LineStringWithData() throws ParseException {
        if (cancelled) throw new CancellationException();
        String prevProduction= currentlyParsedProduction;
        this.currentlyParsedProduction= "LineStringWithData";
        WktLineString LineStringWithData4= null;
        if (buildTree) {
            LineStringWithData4= new WktLineString();
            openNodeScope(LineStringWithData4);
        }
        ParseException parseException160= null;
        int callStackSize161= parsingStack.size();
        try {
            if (false) throw new ParseException("Never happens!");
            // Code for RegexpRef specified at:
            // src/main/congocc/wktParser.ccc:72:3
            consumeToken(LINESTRING);
            if (nextTokenType()== ZoM) {
                // Code for RegexpRef specified at:
                // src/main/congocc/wktParser.ccc:73:5
                consumeToken(ZoM);
                // Code for RegexpRef specified at:
                // src/main/congocc/wktParser.ccc:73:11
                consumeToken(LB);
                // Code for NonTerminal specified at:
                // src/main/congocc/wktParser.ccc:73:16
                pushOntoCallStack("LineStringWithData", "src/main/congocc/wktParser.ccc", 73, 16);
                try {
                    Coords3List();
                }
                finally {
                    popCallStack();
                }
                // Code for RegexpRef specified at:
                // src/main/congocc/wktParser.ccc:73:28
                consumeToken(RB);
            }
            else if (nextTokenType()== LB) {
                // Code for RegexpRef specified at:
                // src/main/congocc/wktParser.ccc:74:11
                consumeToken(LB);
                // Code for NonTerminal specified at:
                // src/main/congocc/wktParser.ccc:74:16
                pushOntoCallStack("LineStringWithData", "src/main/congocc/wktParser.ccc", 74, 16);
                try {
                    Coords2List();
                }
                finally {
                    popCallStack();
                }
                // Code for RegexpRef specified at:
                // src/main/congocc/wktParser.ccc:74:28
                consumeToken(RB);
            }
            else  {
                pushOntoCallStack("LineStringWithData", "src/main/congocc/wktParser.ccc", 73, 5);
                throw new ParseException(this, first_set$wktParser_ccc$73$5, parsingStack);
            }
        }
        catch(ParseException e) {
            parseException160= e;
            throw e;
        }
        finally {
            restoreCallStack(callStackSize161);
            if (LineStringWithData4!=null) {
                if (parseException160== null) {
                    closeNodeScope(LineStringWithData4, true);
                }
                else  {
                    clearNodeScope();
                }
            }
            this.currentlyParsedProduction= prevProduction;
        }
    }

    // src/main/congocc/wktParser.ccc:78:1
    final public void PolygonWithData() throws ParseException {
        if (cancelled) throw new CancellationException();
        String prevProduction= currentlyParsedProduction;
        this.currentlyParsedProduction= "PolygonWithData";
        WktPolygon PolygonWithData5= null;
        if (buildTree) {
            PolygonWithData5= new WktPolygon();
            openNodeScope(PolygonWithData5);
        }
        ParseException parseException197= null;
        int callStackSize198= parsingStack.size();
        try {
            if (false) throw new ParseException("Never happens!");
            // Code for RegexpRef specified at:
            // src/main/congocc/wktParser.ccc:79:3
            consumeToken(POLYGON);
            if (nextTokenType()== ZoM) {
                // Code for RegexpRef specified at:
                // src/main/congocc/wktParser.ccc:80:5
                consumeToken(ZoM);
                // Code for RegexpRef specified at:
                // src/main/congocc/wktParser.ccc:80:11
                consumeToken(LB);
                // Code for NonTerminal specified at:
                // src/main/congocc/wktParser.ccc:80:16
                pushOntoCallStack("PolygonWithData", "src/main/congocc/wktParser.ccc", 80, 16);
                try {
                    LinearRing3();
                }
                finally {
                    popCallStack();
                }
                // Code for ZeroOrMore specified at:
                // src/main/congocc/wktParser.ccc:80:28
                while (true) {
                    if (!(nextTokenType()== COMMA)) break;
                    // Code for RegexpRef specified at:
                    // src/main/congocc/wktParser.ccc:80:30
                    consumeToken(COMMA);
                    // Code for NonTerminal specified at:
                    // src/main/congocc/wktParser.ccc:80:38
                    pushOntoCallStack("PolygonWithData", "src/main/congocc/wktParser.ccc", 80, 38);
                    try {
                        LinearRing3();
                    }
                    finally {
                        popCallStack();
                    }
                }
                // Code for RegexpRef specified at:
                // src/main/congocc/wktParser.ccc:80:53
                consumeToken(RB);
            }
            else if (nextTokenType()== LB) {
                // Code for RegexpRef specified at:
                // src/main/congocc/wktParser.ccc:81:11
                consumeToken(LB);
                // Code for NonTerminal specified at:
                // src/main/congocc/wktParser.ccc:81:16
                pushOntoCallStack("PolygonWithData", "src/main/congocc/wktParser.ccc", 81, 16);
                try {
                    LinearRing2();
                }
                finally {
                    popCallStack();
                }
                // Code for ZeroOrMore specified at:
                // src/main/congocc/wktParser.ccc:81:28
                while (true) {
                    if (!(nextTokenType()== COMMA)) break;
                    // Code for RegexpRef specified at:
                    // src/main/congocc/wktParser.ccc:81:30
                    consumeToken(COMMA);
                    // Code for NonTerminal specified at:
                    // src/main/congocc/wktParser.ccc:81:38
                    pushOntoCallStack("PolygonWithData", "src/main/congocc/wktParser.ccc", 81, 38);
                    try {
                        LinearRing2();
                    }
                    finally {
                        popCallStack();
                    }
                }
                // Code for RegexpRef specified at:
                // src/main/congocc/wktParser.ccc:81:53
                consumeToken(RB);
            }
            else  {
                pushOntoCallStack("PolygonWithData", "src/main/congocc/wktParser.ccc", 80, 5);
                throw new ParseException(this, first_set$wktParser_ccc$80$5, parsingStack);
            }
        }
        catch(ParseException e) {
            parseException197= e;
            throw e;
        }
        finally {
            restoreCallStack(callStackSize198);
            if (PolygonWithData5!=null) {
                if (parseException197== null) {
                    closeNodeScope(PolygonWithData5, true);
                }
                else  {
                    clearNodeScope();
                }
            }
            this.currentlyParsedProduction= prevProduction;
        }
    }

    // src/main/congocc/wktParser.ccc:86:1
    final public void LinearRing2() throws ParseException {
        if (cancelled) throw new CancellationException();
        String prevProduction= currentlyParsedProduction;
        this.currentlyParsedProduction= "LinearRing2";
        LinearRing LinearRing26= null;
        if (buildTree) {
            LinearRing26= new LinearRing();
            openNodeScope(LinearRing26);
        }
        ParseException parseException258= null;
        int callStackSize259= parsingStack.size();
        try {
            if (false) throw new ParseException("Never happens!");
            // Code for RegexpRef specified at:
            // src/main/congocc/wktParser.ccc:87:3
            consumeToken(LB);
            // Code for NonTerminal specified at:
            // src/main/congocc/wktParser.ccc:87:8
            pushOntoCallStack("LinearRing2", "src/main/congocc/wktParser.ccc", 87, 8);
            try {
                Coords2List();
            }
            finally {
                popCallStack();
            }
            // Code for RegexpRef specified at:
            // src/main/congocc/wktParser.ccc:87:20
            consumeToken(RB);
        }
        catch(ParseException e) {
            parseException258= e;
            throw e;
        }
        finally {
            restoreCallStack(callStackSize259);
            if (LinearRing26!=null) {
                if (parseException258== null) {
                    closeNodeScope(LinearRing26, true);
                }
                else  {
                    clearNodeScope();
                }
            }
            this.currentlyParsedProduction= prevProduction;
        }
    }

    // src/main/congocc/wktParser.ccc:90:1
    final public void LinearRing3() throws ParseException {
        if (cancelled) throw new CancellationException();
        String prevProduction= currentlyParsedProduction;
        this.currentlyParsedProduction= "LinearRing3";
        LinearRing LinearRing37= null;
        if (buildTree) {
            LinearRing37= new LinearRing();
            openNodeScope(LinearRing37);
        }
        ParseException parseException270= null;
        int callStackSize271= parsingStack.size();
        try {
            if (false) throw new ParseException("Never happens!");
            // Code for RegexpRef specified at:
            // src/main/congocc/wktParser.ccc:91:3
            consumeToken(LB);
            // Code for NonTerminal specified at:
            // src/main/congocc/wktParser.ccc:91:8
            pushOntoCallStack("LinearRing3", "src/main/congocc/wktParser.ccc", 91, 8);
            try {
                Coords3List();
            }
            finally {
                popCallStack();
            }
            // Code for RegexpRef specified at:
            // src/main/congocc/wktParser.ccc:91:20
            consumeToken(RB);
        }
        catch(ParseException e) {
            parseException270= e;
            throw e;
        }
        finally {
            restoreCallStack(callStackSize271);
            if (LinearRing37!=null) {
                if (parseException270== null) {
                    closeNodeScope(LinearRing37, true);
                }
                else  {
                    clearNodeScope();
                }
            }
            this.currentlyParsedProduction= prevProduction;
        }
    }

    // src/main/congocc/wktParser.ccc:94:1
    final public void Coords2() throws ParseException {
        if (cancelled) throw new CancellationException();
        String prevProduction= currentlyParsedProduction;
        this.currentlyParsedProduction= "Coords2";
        Coords2 Coords28= null;
        if (buildTree) {
            Coords28= new Coords2();
            openNodeScope(Coords28);
        }
        ParseException parseException282= null;
        int callStackSize283= parsingStack.size();
        try {
            if (false) throw new ParseException("Never happens!");
            // Code for RegexpRef specified at:
            // src/main/congocc/wktParser.ccc:95:3
            consumeToken(DOUBLE);
            // Code for RegexpRef specified at:
            // src/main/congocc/wktParser.ccc:95:12
            consumeToken(DOUBLE);
        }
        catch(ParseException e) {
            parseException282= e;
            throw e;
        }
        finally {
            restoreCallStack(callStackSize283);
            if (Coords28!=null) {
                if (parseException282== null) {
                    closeNodeScope(Coords28, true);
                }
                else  {
                    clearNodeScope();
                }
            }
            this.currentlyParsedProduction= prevProduction;
        }
    }

    // src/main/congocc/wktParser.ccc:98:1
    final public void Coords3() throws ParseException {
        if (cancelled) throw new CancellationException();
        String prevProduction= currentlyParsedProduction;
        this.currentlyParsedProduction= "Coords3";
        Coords3 Coords39= null;
        if (buildTree) {
            Coords39= new Coords3();
            openNodeScope(Coords39);
        }
        ParseException parseException291= null;
        int callStackSize292= parsingStack.size();
        try {
            if (false) throw new ParseException("Never happens!");
            // Code for RegexpRef specified at:
            // src/main/congocc/wktParser.ccc:99:3
            consumeToken(DOUBLE);
            // Code for RegexpRef specified at:
            // src/main/congocc/wktParser.ccc:99:12
            consumeToken(DOUBLE);
            // Code for RegexpRef specified at:
            // src/main/congocc/wktParser.ccc:99:21
            consumeToken(DOUBLE);
        }
        catch(ParseException e) {
            parseException291= e;
            throw e;
        }
        finally {
            restoreCallStack(callStackSize292);
            if (Coords39!=null) {
                if (parseException291== null) {
                    closeNodeScope(Coords39, true);
                }
                else  {
                    clearNodeScope();
                }
            }
            this.currentlyParsedProduction= prevProduction;
        }
    }

    // src/main/congocc/wktParser.ccc:102:1
    final public void Coords2List() throws ParseException {
        if (cancelled) throw new CancellationException();
        String prevProduction= currentlyParsedProduction;
        this.currentlyParsedProduction= "Coords2List";
        // Code for NonTerminal specified at:
        // src/main/congocc/wktParser.ccc:103:3
        pushOntoCallStack("Coords2List", "src/main/congocc/wktParser.ccc", 103, 3);
        try {
            Coords2();
        }
        finally {
            popCallStack();
        }
        // Code for ZeroOrMore specified at:
        // src/main/congocc/wktParser.ccc:103:11
        while (true) {
            if (!(nextTokenType()== COMMA)) break;
            // Code for RegexpRef specified at:
            // src/main/congocc/wktParser.ccc:103:13
            consumeToken(COMMA);
            // Code for NonTerminal specified at:
            // src/main/congocc/wktParser.ccc:103:21
            pushOntoCallStack("Coords2List", "src/main/congocc/wktParser.ccc", 103, 21);
            try {
                Coords2();
            }
            finally {
                popCallStack();
            }
        }
    }

    // src/main/congocc/wktParser.ccc:105:1
    final public void Coords3List() throws ParseException {
        if (cancelled) throw new CancellationException();
        String prevProduction= currentlyParsedProduction;
        this.currentlyParsedProduction= "Coords3List";
        // Code for NonTerminal specified at:
        // src/main/congocc/wktParser.ccc:106:3
        pushOntoCallStack("Coords3List", "src/main/congocc/wktParser.ccc", 106, 3);
        try {
            Coords3();
        }
        finally {
            popCallStack();
        }
        // Code for ZeroOrMore specified at:
        // src/main/congocc/wktParser.ccc:106:11
        while (true) {
            if (!(nextTokenType()== COMMA)) break;
            // Code for RegexpRef specified at:
            // src/main/congocc/wktParser.ccc:106:13
            consumeToken(COMMA);
            // Code for NonTerminal specified at:
            // src/main/congocc/wktParser.ccc:106:21
            pushOntoCallStack("Coords3List", "src/main/congocc/wktParser.ccc", 106, 21);
            try {
                Coords3();
            }
            finally {
                popCallStack();
            }
        }
    }

    static private final EnumSet<TokenType> first_set$wktParser_ccc$49$5= tokenTypeSet(POINT, MULTIPOINT, LINESTRING, POLYGON);
    static private final EnumSet<TokenType> first_set$wktParser_ccc$59$5= tokenTypeSet(LB, ZoM);
    static private final EnumSet<TokenType> first_set$wktParser_ccc$66$5= tokenTypeSet(LB, ZoM);
    static private final EnumSet<TokenType> first_set$wktParser_ccc$73$5= tokenTypeSet(LB, ZoM);
    static private final EnumSet<TokenType> first_set$wktParser_ccc$80$5= tokenTypeSet(LB, ZoM);
    ArrayList<NonTerminalCall> parsingStack= new ArrayList<> ();
    private ArrayList<NonTerminalCall> lookaheadStack= new ArrayList<> ();
    /**
 * Inner class that represents entering a grammar production
 */
    class NonTerminalCall {
        final String sourceFile;
        final String productionName;
        final int line, column;
        // We actually only use this when we're working with the LookaheadStack
        final boolean scanToEnd;
        NonTerminalCall(String sourceFile, String productionName, int line, int column) {
            this.sourceFile= sourceFile;
            this.productionName= productionName;
            this.line= line;
            this.column= column;
            this.scanToEnd= WParser.this.scanToEnd;
        }

        final WLexer getTokenSource() {
            return WParser.this.token_source;
        }

        StackTraceElement createStackTraceElement() {
            return new StackTraceElement("WParser", productionName, sourceFile, line);
        }

        void dump(PrintStream ps) {
            ps.println(productionName+":"+line+":"+column);
        }

    }
    private final void pushOntoCallStack(String methodName, String fileName, int line, int column) {
        parsingStack.add(new NonTerminalCall(fileName, methodName, line, column));
    }

    private final void popCallStack() {
        NonTerminalCall ntc= parsingStack.remove(parsingStack.size()-1);
        this.currentlyParsedProduction= ntc.productionName;
    }

    private final void restoreCallStack(int prevSize) {
        while (parsingStack.size()> prevSize) {
            popCallStack();
        }
    }

    void dumpLookaheadStack(PrintStream ps) {
        ListIterator<NonTerminalCall> it= lookaheadStack.listIterator(lookaheadStack.size());
        while (it.hasPrevious()) {
            it.previous().dump(ps);
        }
    }

    void dumpCallStack(PrintStream ps) {
        ListIterator<NonTerminalCall> it= parsingStack.listIterator(parsingStack.size());
        while (it.hasPrevious()) {
            it.previous().dump(ps);
        }
    }

    void dumpLookaheadCallStack(PrintStream ps) {
        ps.println("Current Parser Production is: "+currentlyParsedProduction);
        ps.println("Current Lookahead Production is: "+currentLookaheadProduction);
        ps.println("---Lookahead Stack---");
        dumpLookaheadStack(ps);
        ps.println("---Call Stack---");
        dumpCallStack(ps);
    }

    public boolean isParserTolerant() {
        return false;
    }

    public void setParserTolerant(boolean tolerantParsing) {
        if (tolerantParsing) {
            throw new UnsupportedOperationException("This parser was not built with that feature!");
        }
    }

    private Token consumeToken(TokenType expectedType) throws ParseException {
        Token oldToken= lastConsumedToken;
        Token nextToken= nextToken(lastConsumedToken);
        if (nextToken.getType()!=expectedType) {
            nextToken= handleUnexpectedTokenType(expectedType, nextToken);
        }
        this.lastConsumedToken= nextToken;
        this.nextTokenType= null;
        if (buildTree&&tokensAreNodes) {
            pushNode(lastConsumedToken);
        }
        return lastConsumedToken;
    }

    private Token handleUnexpectedTokenType(TokenType expectedType, Token nextToken) throws ParseException {
        throw new ParseException(nextToken, EnumSet.of(expectedType), parsingStack);
    }

    private class ParseState {
        Token lastConsumed;
        ArrayList<NonTerminalCall> parsingStack;
        NodeScope nodeScope;
        ParseState() {
            this.lastConsumed= WParser.this.lastConsumedToken;
            @SuppressWarnings("unchecked")
            ArrayList<NonTerminalCall> parsingStack= (ArrayList<NonTerminalCall> ) WParser.this.parsingStack.clone();
            this.parsingStack= parsingStack;
            this.nodeScope= (NodeScope) currentNodeScope.clone();
        }

    }
    private boolean buildTree= true;
    private boolean tokensAreNodes= true;
    private boolean unparsedTokensAreNodes= false;
    public boolean isTreeBuildingEnabled() {
        return buildTree;
    }

    public void setUnparsedTokensAreNodes(boolean unparsedTokensAreNodes) {
        this.unparsedTokensAreNodes= unparsedTokensAreNodes;
    }

    public void setTokensAreNodes(boolean tokensAreNodes) {
        this.tokensAreNodes= tokensAreNodes;
    }

    NodeScope currentNodeScope= new NodeScope();
    /** 
         * @return the root node of the AST. It only makes sense to call
         * this after a successful parse. 
         */
    public Node rootNode() {
        return currentNodeScope.rootNode();
    }

    /**
     * push a node onto the top of the node stack
     * @param n the node to push
     */
    public void pushNode(Node n) {
        currentNodeScope.add(n);
    }

    /** 
     * @return the node on the top of the stack, and remove it from the
     * stack.  
     */
    public Node popNode() {
        return currentNodeScope.pop();
    }

    /** 
     * @return the node currently on the top of the tree-building stack. 
     */
    public Node peekNode() {
        return currentNodeScope.peek();
    }

    /**
     * Puts the node on the top of the stack. However, unlike pushNode()
     * it replaces the node that is currently on the top of the stack.
     * This is effectively equivalent to popNode() followed by pushNode(n)
     * @param n the node to poke
     */
    public void pokeNode(Node n) {
        currentNodeScope.poke(n);
    }

    /** 
     * @return the number of Nodes on the tree-building stack in the current node
         * scope. 
         */
    public int nodeArity() {
        return currentNodeScope.size();
    }

    private void clearNodeScope() {
        currentNodeScope.clear();
    }

    private void openNodeScope(Node n) {
        new NodeScope();
        if (n!=null) {
            Token next= nextToken(lastConsumedToken);
            n.setTokenSource(lastConsumedToken.getTokenSource());
            n.setBeginOffset(next.getBeginOffset());
            n.open();
        }
    }

    /* A definite node is constructed from a specified number of
         * children.  That number of nodes are popped from the stack and
         * made the children of the definite node.  Then the definite node
         * is pushed on to the stack.
         */
    private void closeNodeScope(Node n, int num) {
        n.setEndOffset(lastConsumedToken.getEndOffset());
        currentNodeScope.close();
        ArrayList<Node> nodes= new ArrayList<Node> ();
        for (int i= 0; i<num; i++) {
            nodes.add(popNode());
        }
        Collections.reverse(nodes);
        for (Node child : nodes) {
            // FIXME deal with the UNPARSED_TOKENS_ARE_NODES case
            n.addChild(child);
        }
        n.close();
        pushNode(n);
    }

    /**
         * A conditional node is constructed if the condition is true.  All
         * the nodes that have been pushed since the node was opened are
         * made children of the conditional node, which is then pushed
         * on to the stack.  If the condition is false the node is not
         * constructed and they are left on the stack. 
         */
    private void closeNodeScope(Node n, boolean condition) {
        if (n!=null&&condition) {
            n.setEndOffset(lastConsumedToken.getEndOffset());
            int a= nodeArity();
            currentNodeScope.close();
            ArrayList<Node> nodes= new ArrayList<Node> ();
            while (a--> 0) {
                nodes.add(popNode());
            }
            Collections.reverse(nodes);
            for (Node child : nodes) {
                if (unparsedTokensAreNodes&&child instanceof Token) {
                    Token tok= (Token) child;
                    while (tok.previousCachedToken()!=null&&tok.previousCachedToken().isUnparsed()) {
                        tok= tok.previousCachedToken();
                    }
                    while (tok.isUnparsed()) {
                        n.addChild(tok);
                        tok= tok.nextCachedToken();
                    }
                }
                n.addChild(child);
            }
            n.close();
            pushNode(n);
        }
        else  {
            currentNodeScope.close();
        }
    }

    public boolean getBuildTree() {
        return buildTree;
    }

    public void setBuildTree(boolean buildTree) {
        this.buildTree= buildTree;
    }

    /**
     * Just a kludge so that existing jjtree-based code that uses
     * parser.jjtree.foo can work without change.
     */
    WParser jjtree= this;
    @SuppressWarnings("serial")
    class NodeScope extends ArrayList<Node>  {
        NodeScope parentScope;
        NodeScope() {
            this.parentScope= WParser.this.currentNodeScope;
            WParser.this.currentNodeScope= this;
        }

        boolean isRootScope() {
            return parentScope== null;
        }

        Node rootNode() {
            NodeScope ns= this;
            while (ns.parentScope!=null) {
                ns= ns.parentScope;
            }
            return ns.isEmpty()?null:
            ns.get(0);
        }

        Node peek() {
            return isEmpty()?parentScope.peek():
            get(size()-1);
        }

        Node pop() {
            return isEmpty()?parentScope.pop():
            remove(size()-1);
        }

        void poke(Node n) {
            if (isEmpty()) {
                parentScope.poke(n);
            }
            else  {
                set(size()-1, n);
            }
        }

        void close() {
            parentScope.addAll(this);
            WParser.this.currentNodeScope= parentScope;
        }

        int nestingLevel() {
            int result= 0;
            NodeScope parent= this;
            while (parent.parentScope!=null) {
                result++;
                parent= parent.parentScope;
            }
            return result;
        }

        public NodeScope clone() {
            NodeScope clone= (NodeScope) super.clone();
            if (parentScope!=null) {
                clone.parentScope= (NodeScope) parentScope.clone();
            }
            return clone;
        }

    }
}
