/* Generated by: JavaCC 21 Parser Generator. Token.java */
package de.fraunhofer.iosb.ilt.frostserver.util.queryparser;

import de.fraunhofer.iosb.ilt.frostserver.util.queryparser.nodes.*;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
public class Token implements QConstants, Node {
    private TokenType type;
    private QLexer tokenSource;
    private int beginOffset, endOffset;
    private boolean unparsed;
    private Node parent;
    private String image;
    public void setImage(String image) {
        this.image= image;
    }

    private Token prependedToken, appendedToken;
    private boolean inserted;
    public boolean isInserted() {
        return inserted;
    }

    public void preInsert(Token prependedToken) {
        if (prependedToken== this.prependedToken) return;
        prependedToken.appendedToken= this;
        Token existingPreviousToken= this.previousCachedToken();
        if (existingPreviousToken!=null) {
            existingPreviousToken.appendedToken= prependedToken;
            prependedToken.prependedToken= existingPreviousToken;
        }
        prependedToken.inserted= true;
        prependedToken.beginOffset= prependedToken.endOffset= this.beginOffset;
        this.prependedToken= prependedToken;
    }

    void unsetAppendedToken() {
        this.appendedToken= null;
    }

    /**
     * @param type the #TokenType of the token being constructed
     * @param image the String content of the token
     * @param tokenSource the object that vended this token.
     */
    public Token(TokenType type, String image, QLexer tokenSource) {
        this.type= type;
        this.image= image;
        this.tokenSource= tokenSource;
    }

    public static Token newToken(TokenType type, String image, QLexer tokenSource) {
        Token result= newToken(type, tokenSource, 0, 0);
        result.setImage(image);
        return result;
    }

    /**
     * It would be extremely rare that an application
     * programmer would use this method. It needs to
     * be public because it is part of the de.fraunhofer.iosb.ilt.frostserver.util.queryparser.Node interface.
     */
    public void setBeginOffset(int beginOffset) {
        this.beginOffset= beginOffset;
    }

    /**
     * It would be extremely rare that an application
     * programmer would use this method. It needs to
     * be public because it is part of the de.fraunhofer.iosb.ilt.frostserver.util.queryparser.Node interface.
     */
    public void setEndOffset(int endOffset) {
        this.endOffset= endOffset;
    }

    /**
     * @return the QLexer object that handles 
     * location info for the tokens. 
     */
    public QLexer getTokenSource() {
        QLexer flm= this.tokenSource;
        // If this is null and we have chained tokens,
        // we try to get it from there! (Why not?)
        if (flm== null) {
            if (prependedToken!=null) {
                flm= prependedToken.getTokenSource();
            }
            if (flm== null&&appendedToken!=null) {
                flm= appendedToken.getTokenSource();
            }
        }
        return flm;
    }

    /**
     * It should be exceedingly rare that an application
     * programmer needs to use this method.
     */
    public void setTokenSource(QLexer tokenSource) {
        this.tokenSource= tokenSource;
    }

    /**
     * Return the TokenType of this Token object
     */
    public TokenType getType() {
        return type;
    }

    protected void setType(TokenType type) {
        this.type= type;
    }

    /**
     * @return whether this Token represent actual input or was it inserted somehow?
     */
    public boolean isVirtual() {
        return type== TokenType.EOF;
    }

    /**
     * @return Did we skip this token in parsing?
     */
    public boolean isSkipped() {
        return false;
    }

    public int getBeginOffset() {
        return beginOffset;
    }

    public int getEndOffset() {
        return endOffset;
    }

    /**
     * @return the string image of the token.
     */
    public String getImage() {
        return image!=null?image:
        getSource();
    }

    /**
     * @return the next _cached_ regular (i.e. parsed) token
     * or null
     */
    public final Token getNext() {
        return getNextParsedToken();
    }

    /**
     * @return the previous regular (i.e. parsed) token
     * or null
     */
    public final Token getPrevious() {
        Token result= previousCachedToken();
        while (result!=null&&result.isUnparsed()) {
            result= result.previousCachedToken();
        }
        return result;
    }

    /**
     * @return the next regular (i.e. parsed) token
     */
    private Token getNextParsedToken() {
        Token result= nextCachedToken();
        while (result!=null&&result.isUnparsed()) {
            result= result.nextCachedToken();
        }
        return result;
    }

    /**
     * @return the next token of any sort (parsed or unparsed or invalid)
     */
    public Token nextCachedToken() {
        if (appendedToken!=null) return appendedToken;
        QLexer tokenSource= getTokenSource();
        return tokenSource!=null?tokenSource.nextCachedToken(getEndOffset()):
        null;
    }

    public Token previousCachedToken() {
        if (prependedToken!=null) return prependedToken;
        if (getTokenSource()== null) return null;
        return getTokenSource().previousCachedToken(getBeginOffset());
    }

    Token getPreviousToken() {
        return previousCachedToken();
    }

    public Token replaceType(TokenType type) {
        Token result= newToken(type, getTokenSource(), getBeginOffset(), getEndOffset());
        result.prependedToken= this.prependedToken;
        result.appendedToken= this.appendedToken;
        result.inserted= this.inserted;
        if (result.appendedToken!=null) {
            result.appendedToken.prependedToken= result;
        }
        if (result.prependedToken!=null) {
            result.prependedToken.appendedToken= result;
        }
        if (!result.inserted) {
            getTokenSource().cacheToken(result);
        }
        return result;
    }

    public String getSource() {
        if (type== TokenType.EOF) return"";
        QLexer flm= getTokenSource();
        return flm== null?null:
        flm.getText(getBeginOffset(), getEndOffset());
    }

    protected Token() {
    }

    public Token(TokenType type, QLexer tokenSource, int beginOffset, int endOffset) {
        this.type= type;
        this.tokenSource= tokenSource;
        this.beginOffset= beginOffset;
        this.endOffset= endOffset;
    }

    public boolean isUnparsed() {
        return unparsed;
    }

    public void setUnparsed(boolean unparsed) {
        this.unparsed= unparsed;
    }

    public void clearChildren() {
    }

    public String getNormalizedText() {
        if (getType()== TokenType.EOF) {
            return"EOF";
        }
        return getImage();
    }

    public String toString() {
        return getNormalizedText();
    }

    /**
     * @return An iterator of the tokens preceding this one.
     */
    public Iterator<Token> precedingTokens() {
        return new Iterator<Token> () {
            Token currentPoint= Token.this;
            public boolean hasNext() {
                return currentPoint.previousCachedToken()!=null;
            }

            public Token next() {
                Token previous= currentPoint.previousCachedToken();
                if (previous== null) throw new java.util.NoSuchElementException("No previous token!");
                return currentPoint= previous;
            }

        }
        ;
    }

    /**
     * @return a list of the unparsed tokens preceding this one in the order they appear in the input
     */
    public List<Token> precedingUnparsedTokens() {
        List<Token> result= new ArrayList<> ();
        Token t= this.previousCachedToken();
        while (t!=null&&t.isUnparsed()) {
            result.add(t);
            t= t.previousCachedToken();
        }
        Collections.reverse(result);
        return result;
    }

    /**
     * @return An iterator of the (cached) tokens that follow this one.
     */
    public Iterator<Token> followingTokens() {
        return new java.util.Iterator<Token> () {
            Token currentPoint= Token.this;
            public boolean hasNext() {
                return currentPoint.nextCachedToken()!=null;
            }

            public Token next() {
                Token next= currentPoint.nextCachedToken();
                if (next== null) throw new java.util.NoSuchElementException("No next token!");
                return currentPoint= next;
            }

        }
        ;
    }

    /**
     * Copy the location info from a Node
     */
    public void copyLocationInfo(Node from) {
        Node.super.copyLocationInfo(from);
        if (from instanceof Token) {
            Token otherTok= (Token) from;
            appendedToken= otherTok.appendedToken;
            prependedToken= otherTok.prependedToken;
        }
        setTokenSource(from.getTokenSource());
    }

    public void copyLocationInfo(Node start, Node end) {
        Node.super.copyLocationInfo(start, end);
        if (start instanceof Token) {
            prependedToken= ((Token) start).prependedToken;
        }
        if (end instanceof Token) {
            Token endToken= (Token) end;
            appendedToken= endToken.appendedToken;
        }
    }

    public static Token newToken(TokenType type, QLexer tokenSource, int beginOffset, int endOffset) {
        switch(type) {
            case T_O_ID:
            return new T_O_ID(TokenType.T_O_ID, tokenSource, beginOffset, endOffset);
            case T_STRING:
            return new T_STRING(TokenType.T_STRING, tokenSource, beginOffset, endOffset);
            case T_OPTIONS_SEPARATOR:
            return new T_OPTIONS_SEPARATOR(TokenType.T_OPTIONS_SEPARATOR, tokenSource, beginOffset, endOffset);
            case T_O_FORMAT:
            return new T_O_FORMAT(TokenType.T_O_FORMAT, tokenSource, beginOffset, endOffset);
            case T_O_METADATA:
            return new T_O_METADATA(TokenType.T_O_METADATA, tokenSource, beginOffset, endOffset);
            case T_O_SKIPFILTER:
            return new T_O_SKIPFILTER(TokenType.T_O_SKIPFILTER, tokenSource, beginOffset, endOffset);
            case T_O_COUNT:
            return new T_O_COUNT(TokenType.T_O_COUNT, tokenSource, beginOffset, endOffset);
            case T_O_TOP:
            return new T_O_TOP(TokenType.T_O_TOP, tokenSource, beginOffset, endOffset);
            case T_O_SKIP:
            return new T_O_SKIP(TokenType.T_O_SKIP, tokenSource, beginOffset, endOffset);
            case T_O_SELECT:
            return new T_O_SELECT(TokenType.T_O_SELECT, tokenSource, beginOffset, endOffset);
            case T_O_FILTER:
            return new T_O_FILTER(TokenType.T_O_FILTER, tokenSource, beginOffset, endOffset);
            case T_O_EXPAND:
            return new T_O_EXPAND(TokenType.T_O_EXPAND, tokenSource, beginOffset, endOffset);
            case T_O_ORDERBY:
            return new T_O_ORDERBY(TokenType.T_O_ORDERBY, tokenSource, beginOffset, endOffset);
            case T_SUBQUERY_OPTIONS_SEPARATOR:
            return new T_SUBQUERY_OPTIONS_SEPARATOR(TokenType.T_SUBQUERY_OPTIONS_SEPARATOR, tokenSource, beginOffset, endOffset);
            case T_CHARSEQ_FORMAT:
            return new T_CHARSEQ_FORMAT(TokenType.T_CHARSEQ_FORMAT, tokenSource, beginOffset, endOffset);
            case T_CHARSEQ_METADATA:
            return new T_CHARSEQ_METADATA(TokenType.T_CHARSEQ_METADATA, tokenSource, beginOffset, endOffset);
            case T_BOOL:
            return new T_BOOL(TokenType.T_BOOL, tokenSource, beginOffset, endOffset);
            case T_LONG:
            return new T_LONG(TokenType.T_LONG, tokenSource, beginOffset, endOffset);
            case T_VALUE_SEPARATOR:
            return new T_VALUE_SEPARATOR(TokenType.T_VALUE_SEPARATOR, tokenSource, beginOffset, endOffset);
            case T_DISTINCT:
            return new T_DISTINCT(TokenType.T_DISTINCT, tokenSource, beginOffset, endOffset);
            case T_ARRAYINDEX:
            return new T_ARRAYINDEX(TokenType.T_ARRAYINDEX, tokenSource, beginOffset, endOffset);
            case T_PATH_SEPARATOR:
            return new T_PATH_SEPARATOR(TokenType.T_PATH_SEPARATOR, tokenSource, beginOffset, endOffset);
            case T_O_ASC:
            return new T_O_ASC(TokenType.T_O_ASC, tokenSource, beginOffset, endOffset);
            case T_O_DESC:
            return new T_O_DESC(TokenType.T_O_DESC, tokenSource, beginOffset, endOffset);
            case T_CHARSEQ:
            return new T_CHARSEQ(TokenType.T_CHARSEQ, tokenSource, beginOffset, endOffset);
            case T_LB:
            return new T_LB(TokenType.T_LB, tokenSource, beginOffset, endOffset);
            case T_RB:
            return new T_RB(TokenType.T_RB, tokenSource, beginOffset, endOffset);
            case T_QO_EQ:
            return new T_QO_EQ(TokenType.T_QO_EQ, tokenSource, beginOffset, endOffset);
            case T_QO_NE:
            return new T_QO_NE(TokenType.T_QO_NE, tokenSource, beginOffset, endOffset);
            case T_QO_GT:
            return new T_QO_GT(TokenType.T_QO_GT, tokenSource, beginOffset, endOffset);
            case T_QO_GE:
            return new T_QO_GE(TokenType.T_QO_GE, tokenSource, beginOffset, endOffset);
            case T_QO_LT:
            return new T_QO_LT(TokenType.T_QO_LT, tokenSource, beginOffset, endOffset);
            case T_QO_LE:
            return new T_QO_LE(TokenType.T_QO_LE, tokenSource, beginOffset, endOffset);
            case T_QO_AND:
            return new T_QO_AND(TokenType.T_QO_AND, tokenSource, beginOffset, endOffset);
            case T_QO_NOT:
            return new T_QO_NOT(TokenType.T_QO_NOT, tokenSource, beginOffset, endOffset);
            case T_QO_OR:
            return new T_QO_OR(TokenType.T_QO_OR, tokenSource, beginOffset, endOffset);
            case T_QO_ADD:
            return new T_QO_ADD(TokenType.T_QO_ADD, tokenSource, beginOffset, endOffset);
            case T_QO_SUB:
            return new T_QO_SUB(TokenType.T_QO_SUB, tokenSource, beginOffset, endOffset);
            case T_QO_MUL:
            return new T_QO_MUL(TokenType.T_QO_MUL, tokenSource, beginOffset, endOffset);
            case T_QO_DIV:
            return new T_QO_DIV(TokenType.T_QO_DIV, tokenSource, beginOffset, endOffset);
            case T_QO_MOD:
            return new T_QO_MOD(TokenType.T_QO_MOD, tokenSource, beginOffset, endOffset);
            case T_QF_SUBSTRINGOF:
            return new T_QF_SUBSTRINGOF(TokenType.T_QF_SUBSTRINGOF, tokenSource, beginOffset, endOffset);
            case T_QF_ENDSWITH:
            return new T_QF_ENDSWITH(TokenType.T_QF_ENDSWITH, tokenSource, beginOffset, endOffset);
            case T_QF_STARTSWITH:
            return new T_QF_STARTSWITH(TokenType.T_QF_STARTSWITH, tokenSource, beginOffset, endOffset);
            case T_QF_LENGTH:
            return new T_QF_LENGTH(TokenType.T_QF_LENGTH, tokenSource, beginOffset, endOffset);
            case T_QF_INDEXOF:
            return new T_QF_INDEXOF(TokenType.T_QF_INDEXOF, tokenSource, beginOffset, endOffset);
            case T_QF_SUBSTRING:
            return new T_QF_SUBSTRING(TokenType.T_QF_SUBSTRING, tokenSource, beginOffset, endOffset);
            case T_QF_TOLOWER:
            return new T_QF_TOLOWER(TokenType.T_QF_TOLOWER, tokenSource, beginOffset, endOffset);
            case T_QF_TOUPPER:
            return new T_QF_TOUPPER(TokenType.T_QF_TOUPPER, tokenSource, beginOffset, endOffset);
            case T_QF_TRIM:
            return new T_QF_TRIM(TokenType.T_QF_TRIM, tokenSource, beginOffset, endOffset);
            case T_QF_CONCAT:
            return new T_QF_CONCAT(TokenType.T_QF_CONCAT, tokenSource, beginOffset, endOffset);
            case T_QF_YEAR:
            return new T_QF_YEAR(TokenType.T_QF_YEAR, tokenSource, beginOffset, endOffset);
            case T_QF_MONTH:
            return new T_QF_MONTH(TokenType.T_QF_MONTH, tokenSource, beginOffset, endOffset);
            case T_QF_DAY:
            return new T_QF_DAY(TokenType.T_QF_DAY, tokenSource, beginOffset, endOffset);
            case T_QF_HOUR:
            return new T_QF_HOUR(TokenType.T_QF_HOUR, tokenSource, beginOffset, endOffset);
            case T_QF_MINUTE:
            return new T_QF_MINUTE(TokenType.T_QF_MINUTE, tokenSource, beginOffset, endOffset);
            case T_QF_SECOND:
            return new T_QF_SECOND(TokenType.T_QF_SECOND, tokenSource, beginOffset, endOffset);
            case T_QF_FRACTIONALSECONDS:
            return new T_QF_FRACTIONALSECONDS(TokenType.T_QF_FRACTIONALSECONDS, tokenSource, beginOffset, endOffset);
            case T_QF_DATE:
            return new T_QF_DATE(TokenType.T_QF_DATE, tokenSource, beginOffset, endOffset);
            case T_QF_TIME:
            return new T_QF_TIME(TokenType.T_QF_TIME, tokenSource, beginOffset, endOffset);
            case T_QF_TOTALOFFSETMINUTES:
            return new T_QF_TOTALOFFSETMINUTES(TokenType.T_QF_TOTALOFFSETMINUTES, tokenSource, beginOffset, endOffset);
            case T_QF_NOW:
            return new T_QF_NOW(TokenType.T_QF_NOW, tokenSource, beginOffset, endOffset);
            case T_QF_MINDATETIME:
            return new T_QF_MINDATETIME(TokenType.T_QF_MINDATETIME, tokenSource, beginOffset, endOffset);
            case T_QF_MAXDATETIME:
            return new T_QF_MAXDATETIME(TokenType.T_QF_MAXDATETIME, tokenSource, beginOffset, endOffset);
            case T_QF_BEFORE:
            return new T_QF_BEFORE(TokenType.T_QF_BEFORE, tokenSource, beginOffset, endOffset);
            case T_QF_AFTER:
            return new T_QF_AFTER(TokenType.T_QF_AFTER, tokenSource, beginOffset, endOffset);
            case T_QF_MEETS:
            return new T_QF_MEETS(TokenType.T_QF_MEETS, tokenSource, beginOffset, endOffset);
            case T_QF_DURING:
            return new T_QF_DURING(TokenType.T_QF_DURING, tokenSource, beginOffset, endOffset);
            case T_QF_OVERLAPS:
            return new T_QF_OVERLAPS(TokenType.T_QF_OVERLAPS, tokenSource, beginOffset, endOffset);
            case T_QF_STARTS:
            return new T_QF_STARTS(TokenType.T_QF_STARTS, tokenSource, beginOffset, endOffset);
            case T_QF_FINISHES:
            return new T_QF_FINISHES(TokenType.T_QF_FINISHES, tokenSource, beginOffset, endOffset);
            case T_QF_ROUND:
            return new T_QF_ROUND(TokenType.T_QF_ROUND, tokenSource, beginOffset, endOffset);
            case T_QF_FLOOR:
            return new T_QF_FLOOR(TokenType.T_QF_FLOOR, tokenSource, beginOffset, endOffset);
            case T_QF_CEILING:
            return new T_QF_CEILING(TokenType.T_QF_CEILING, tokenSource, beginOffset, endOffset);
            case T_QF_GEO_DISTANCE:
            return new T_QF_GEO_DISTANCE(TokenType.T_QF_GEO_DISTANCE, tokenSource, beginOffset, endOffset);
            case T_QF_GEO_LENGTH:
            return new T_QF_GEO_LENGTH(TokenType.T_QF_GEO_LENGTH, tokenSource, beginOffset, endOffset);
            case T_QF_GEO_INTERSECTS:
            return new T_QF_GEO_INTERSECTS(TokenType.T_QF_GEO_INTERSECTS, tokenSource, beginOffset, endOffset);
            case T_QF_ST_EQUALS:
            return new T_QF_ST_EQUALS(TokenType.T_QF_ST_EQUALS, tokenSource, beginOffset, endOffset);
            case T_QF_ST_DISJOINT:
            return new T_QF_ST_DISJOINT(TokenType.T_QF_ST_DISJOINT, tokenSource, beginOffset, endOffset);
            case T_QF_ST_TOUCHES:
            return new T_QF_ST_TOUCHES(TokenType.T_QF_ST_TOUCHES, tokenSource, beginOffset, endOffset);
            case T_QF_ST_WITHIN:
            return new T_QF_ST_WITHIN(TokenType.T_QF_ST_WITHIN, tokenSource, beginOffset, endOffset);
            case T_QF_ST_OVERLAPS:
            return new T_QF_ST_OVERLAPS(TokenType.T_QF_ST_OVERLAPS, tokenSource, beginOffset, endOffset);
            case T_QF_ST_CROSSES:
            return new T_QF_ST_CROSSES(TokenType.T_QF_ST_CROSSES, tokenSource, beginOffset, endOffset);
            case T_QF_ST_INTERSECTS:
            return new T_QF_ST_INTERSECTS(TokenType.T_QF_ST_INTERSECTS, tokenSource, beginOffset, endOffset);
            case T_QF_ST_CONTAINS:
            return new T_QF_ST_CONTAINS(TokenType.T_QF_ST_CONTAINS, tokenSource, beginOffset, endOffset);
            case T_QF_ST_RELATE:
            return new T_QF_ST_RELATE(TokenType.T_QF_ST_RELATE, tokenSource, beginOffset, endOffset);
            case T_STR_LIT:
            return new T_STR_LIT(TokenType.T_STR_LIT, tokenSource, beginOffset, endOffset);
            case T_GEO_STR_LIT:
            return new T_GEO_STR_LIT(TokenType.T_GEO_STR_LIT, tokenSource, beginOffset, endOffset);
            case T_DURATION:
            return new T_DURATION(TokenType.T_DURATION, tokenSource, beginOffset, endOffset);
            case T_DATE:
            return new T_DATE(TokenType.T_DATE, tokenSource, beginOffset, endOffset);
            case T_TIME:
            return new T_TIME(TokenType.T_TIME, tokenSource, beginOffset, endOffset);
            case T_DATETIME:
            return new T_DATETIME(TokenType.T_DATETIME, tokenSource, beginOffset, endOffset);
            case T_DATETIMEINTERVAL:
            return new T_DATETIMEINTERVAL(TokenType.T_DATETIMEINTERVAL, tokenSource, beginOffset, endOffset);
            case T_DOUBLE:
            return new T_DOUBLE(TokenType.T_DOUBLE, tokenSource, beginOffset, endOffset);
            case T_NULL:
            return new T_NULL(TokenType.T_NULL, tokenSource, beginOffset, endOffset);
            case INVALID:
            return new InvalidToken(tokenSource, beginOffset, endOffset);
            default:
            return new Token(type, tokenSource, beginOffset, endOffset);
        }
    }

    public String getLocation() {
        return getInputSource()+":"+getBeginLine()+":"+getBeginColumn();
    }

    public void setChild(int i, Node n) {
        throw new UnsupportedOperationException();
    }

    public void addChild(Node n) {
        throw new UnsupportedOperationException();
    }

    public void addChild(int i, Node n) {
        throw new UnsupportedOperationException();
    }

    public Node removeChild(int i) {
        throw new UnsupportedOperationException();
    }

    public final int indexOf(Node n) {
        return-1;
    }

    public Node getParent() {
        return parent;
    }

    public void setParent(Node parent) {
        this.parent= parent;
    }

    public final int getChildCount() {
        return 0;
    }

    public final Node getChild(int i) {
        return null;
    }

    public final List<Node> children() {
        return java.util.Collections.emptyList();
    }

}
