/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.frostserver.util.wktparser;

import de.fraunhofer.iosb.ilt.frostserver.util.wktparser.Token;
import de.fraunhofer.iosb.ilt.frostserver.util.wktparser.WConstants;
import de.fraunhofer.iosb.ilt.frostserver.util.wktparser.WLexer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;

public interface Node
extends Comparable<Node> {
    default public void open() {
    }

    default public void close() {
    }

    default public String getInputSource() {
        WLexer tokenSource = this.getTokenSource();
        return tokenSource == null ? "input" : tokenSource.getInputSource();
    }

    default public boolean hasChildNodes() {
        return this.getChildCount() > 0;
    }

    public void setParent(Node var1);

    public Node getParent();

    public void addChild(Node var1);

    public void addChild(int var1, Node var2);

    public Node getChild(int var1);

    public void setChild(int var1, Node var2);

    public Node removeChild(int var1);

    default public boolean removeChild(Node n) {
        int index = this.indexOf(n);
        if (index == -1) {
            return false;
        }
        this.removeChild(index);
        return true;
    }

    default public boolean replaceChild(Node current, Node replacement) {
        int index = this.indexOf(current);
        if (index == -1) {
            return false;
        }
        this.setChild(index, replacement);
        return true;
    }

    default public boolean prependChild(Node where, Node inserted) {
        int index = this.indexOf(where);
        if (index == -1) {
            return false;
        }
        this.addChild(index, inserted);
        return true;
    }

    default public boolean appendChild(Node where, Node inserted) {
        int index = this.indexOf(where);
        if (index == -1) {
            return false;
        }
        this.addChild(index + 1, inserted);
        return true;
    }

    default public int indexOf(Node child) {
        for (int i = 0; i < this.getChildCount(); ++i) {
            if (child != this.getChild(i)) continue;
            return i;
        }
        return -1;
    }

    default public Node previousSibling() {
        Node parent = this.getParent();
        if (parent == null) {
            return null;
        }
        int idx = parent.indexOf(this);
        if (idx <= 0) {
            return null;
        }
        return parent.getChild(idx - 1);
    }

    default public Node nextSibling() {
        Node parent = this.getParent();
        if (parent == null) {
            return null;
        }
        int idx = parent.indexOf(this);
        if (idx >= parent.getChildCount() - 1) {
            return null;
        }
        return parent.getChild(idx + 1);
    }

    @Override
    default public int compareTo(Node n) {
        if (this == n) {
            return 0;
        }
        int diff = this.getBeginLine() - n.getBeginLine();
        if (diff != 0) {
            return diff;
        }
        diff = this.getBeginColumn() - n.getBeginColumn();
        if (diff != 0) {
            return diff;
        }
        diff = n.getEndLine() - this.getEndLine();
        if (diff != 0) {
            return diff;
        }
        return n.getEndColumn() - this.getEndColumn();
    }

    public void clearChildren();

    public int getChildCount();

    default public List<Node> children(boolean includeUnparsedTokens) {
        ArrayList<Node> result = new ArrayList<Node>();
        for (int i = 0; i < this.getChildCount(); ++i) {
            Token tok;
            Node child = this.getChild(i);
            if (includeUnparsedTokens && child instanceof Token && !(tok = (Token)child).isUnparsed()) {
                result.addAll(tok.precedingUnparsedTokens());
            }
            result.add(child);
        }
        return result;
    }

    default public List<Node> children() {
        return this.children(false);
    }

    default public List<Token> getAllTokens(boolean includeCommentTokens) {
        ArrayList<Token> result = new ArrayList<Token>();
        ListIterator<Node> it = this.iterator();
        while (it.hasNext()) {
            Node child = (Node)it.next();
            if (child instanceof Token) {
                Token token = (Token)child;
                if (token.isUnparsed()) continue;
                if (includeCommentTokens) {
                    ArrayList<Token> comments = null;
                    for (Token prev = token.previousCachedToken(); prev != null && prev.isUnparsed(); prev = prev.previousCachedToken()) {
                        if (comments == null) {
                            comments = new ArrayList<Token>();
                        }
                        comments.add(prev);
                    }
                    if (comments != null) {
                        Collections.reverse(comments);
                        result.addAll(comments);
                    }
                }
                result.add(token);
                continue;
            }
            if (child.getChildCount() <= 0) continue;
            result.addAll(child.getAllTokens(includeCommentTokens));
        }
        return result;
    }

    default public List<Token> getRealTokens() {
        return this.descendants(Token.class, t -> !t.isUnparsed());
    }

    public WLexer getTokenSource();

    public void setTokenSource(WLexer var1);

    default public String getSource() {
        WLexer tokenSource = this.getTokenSource();
        return tokenSource == null ? null : tokenSource.getText(this.getBeginOffset(), this.getEndOffset());
    }

    default public int getBeginLine() {
        WLexer tokenSource = this.getTokenSource();
        return tokenSource == null ? 0 : tokenSource.getLineFromOffset(this.getBeginOffset());
    }

    default public int getEndLine() {
        WLexer tokenSource = this.getTokenSource();
        return tokenSource == null ? 0 : tokenSource.getLineFromOffset(this.getEndOffset() - 1);
    }

    default public int getBeginColumn() {
        WLexer tokenSource = this.getTokenSource();
        return tokenSource == null ? 0 : tokenSource.getCodePointColumnFromOffset(this.getBeginOffset());
    }

    default public int getEndColumn() {
        WLexer tokenSource = this.getTokenSource();
        return tokenSource == null ? 0 : tokenSource.getCodePointColumnFromOffset(this.getEndOffset() - 1);
    }

    public int getBeginOffset();

    public int getEndOffset();

    public void setBeginOffset(int var1);

    public void setEndOffset(int var1);

    default public String getLocation() {
        return this.getInputSource() + ":" + this.getBeginLine() + ":" + this.getBeginColumn();
    }

    default public boolean isUnparsed() {
        return false;
    }

    public void setUnparsed(boolean var1);

    default public <T extends Node> T firstChildOfType(Class<T> clazz) {
        for (int i = 0; i < this.getChildCount(); ++i) {
            Node child = this.getChild(i);
            if (!clazz.isInstance(child)) continue;
            return (T)((Node)clazz.cast(child));
        }
        return null;
    }

    default public <T extends Node> T firstChildOfType(Class<T> clazz, Predicate<T> pred) {
        for (int i = 0; i < this.getChildCount(); ++i) {
            Node t;
            Node child = this.getChild(i);
            if (!clazz.isInstance(child) || !pred.test(t = (Node)clazz.cast(child))) continue;
            return (T)t;
        }
        return null;
    }

    default public Token firstDescendantOfType(WConstants.TokenType type) {
        for (int i = 0; i < this.getChildCount(); ++i) {
            Token tok;
            Node child = this.getChild(i);
            if (!(child instanceof Token ? (tok = (Token)child).getType() == type : (tok = child.firstDescendantOfType(type)) != null)) continue;
            return tok;
        }
        return null;
    }

    default public Token firstChildOfType(WConstants.TokenType tokenType) {
        for (int i = 0; i < this.getChildCount(); ++i) {
            Token tok;
            Node child = this.getChild(i);
            if (!(child instanceof Token) || (tok = (Token)child).getType() != tokenType) continue;
            return tok;
        }
        return null;
    }

    default public <T extends Node> T firstDescendantOfType(Class<T> clazz) {
        for (int i = 0; i < this.getChildCount(); ++i) {
            Node child = this.getChild(i);
            if (clazz.isInstance(child)) {
                return (T)((Node)clazz.cast(child));
            }
            T descendant = child.firstDescendantOfType(clazz);
            if (descendant == null) continue;
            return descendant;
        }
        return null;
    }

    default public <T extends Node> List<T> childrenOfType(Class<T> clazz) {
        ArrayList<Node> result = new ArrayList<Node>();
        for (int i = 0; i < this.getChildCount(); ++i) {
            Node child = this.getChild(i);
            if (!clazz.isInstance(child)) continue;
            result.add((Node)clazz.cast(child));
        }
        return result;
    }

    default public <T extends Node> List<T> descendantsOfType(Class<T> clazz) {
        ArrayList<Node> result = new ArrayList<Node>();
        for (int i = 0; i < this.getChildCount(); ++i) {
            Node child = this.getChild(i);
            if (clazz.isInstance(child)) {
                result.add((Node)clazz.cast(child));
            }
            result.addAll(child.descendantsOfType(clazz));
        }
        return result;
    }

    default public <T extends Node> T firstAncestorOfType(Class<T> clazz) {
        Node parent = this;
        while (parent != null) {
            if (!clazz.isInstance(parent = parent.getParent())) continue;
            return (T)((Node)clazz.cast(parent));
        }
        return null;
    }

    default public WConstants.TokenType getTokenType() {
        return this instanceof Token ? ((Token)this).getType() : null;
    }

    default public Token getFirstToken() {
        Node first = this.getFirstChild();
        if (first == null) {
            return null;
        }
        if (first instanceof Token) {
            Token tok = (Token)first;
            while (tok.previousCachedToken() != null && tok.previousCachedToken().isUnparsed()) {
                tok = tok.previousCachedToken();
            }
            return tok;
        }
        return first.getFirstToken();
    }

    default public Token getLastToken() {
        Node last = this.getLastChild();
        if (last == null) {
            return null;
        }
        if (last instanceof Token) {
            return (Token)last;
        }
        return last.getLastToken();
    }

    default public void copyLocationInfo(Node from) {
        this.setTokenSource(from.getTokenSource());
        this.setBeginOffset(from.getBeginOffset());
        this.setEndOffset(from.getEndOffset());
        this.setTokenSource(from.getTokenSource());
    }

    default public void copyLocationInfo(Node start, Node end) {
        this.setTokenSource(start.getTokenSource());
        if (this.getTokenSource() == null) {
            this.setTokenSource(end.getTokenSource());
        }
        this.setBeginOffset(start.getBeginOffset());
        this.setEndOffset(end.getEndOffset());
    }

    default public void replace(Node toBeReplaced) {
        this.copyLocationInfo(toBeReplaced);
        Node parent = toBeReplaced.getParent();
        if (parent != null) {
            int index = parent.indexOf(toBeReplaced);
            parent.setChild(index, this);
        }
    }

    default public Node getFirstChild() {
        return this.getChildCount() > 0 ? this.getChild(0) : null;
    }

    default public Node getLastChild() {
        int count = this.getChildCount();
        return count > 0 ? this.getChild(count - 1) : null;
    }

    default public Node getRoot() {
        Node parent = this;
        while (parent.getParent() != null) {
            parent = parent.getParent();
        }
        return parent;
    }

    public static List<Token> getTokens(Node node) {
        ArrayList<Token> result = new ArrayList<Token>();
        for (Node child : node.children()) {
            if (child instanceof Token) {
                result.add((Token)child);
                continue;
            }
            result.addAll(Node.getTokens(child));
        }
        return result;
    }

    public static List<Token> getRealTokens(Node n) {
        ArrayList<Token> result = new ArrayList<Token>();
        for (Token token : Node.getTokens(n)) {
            if (token.isUnparsed()) continue;
            result.add(token);
        }
        return result;
    }

    default public List<Node> descendants() {
        return this.descendants(Node.class, null);
    }

    default public List<Node> descendants(Predicate<? super Node> predicate) {
        return this.descendants(Node.class, predicate);
    }

    default public <T extends Node> List<T> descendants(Class<T> clazz) {
        return this.descendants(clazz, null);
    }

    default public <T extends Node> List<T> descendants(Class<T> clazz, Predicate<? super T> predicate) {
        ArrayList<Node> result = new ArrayList<Node>();
        for (Node child : this.children()) {
            if (clazz.isInstance(child)) {
                Node t = (Node)clazz.cast(child);
                if (predicate == null || predicate.test(t)) {
                    result.add(t);
                }
            }
            result.addAll(child.descendants(clazz, predicate));
        }
        return result;
    }

    default public void dump(String prefix) {
        String output;
        String string = output = this instanceof Token ? this.toString().trim() : this.getClass().getSimpleName();
        if (output.length() > 0) {
            System.out.println(prefix + output);
        }
        ListIterator<Node> it = this.iterator();
        while (it.hasNext()) {
            Node child = (Node)it.next();
            child.dump(prefix + "  ");
        }
    }

    default public void dump() {
        this.dump("");
    }

    default public ListIterator<Node> iterator() {
        return new ListIterator<Node>(){
            private int current = -1;
            private boolean justModified;

            @Override
            public boolean hasNext() {
                return this.current + 1 < Node.this.getChildCount();
            }

            @Override
            public Node next() {
                this.justModified = false;
                return Node.this.getChild(++this.current);
            }

            @Override
            public Node previous() {
                this.justModified = false;
                return Node.this.getChild(--this.current);
            }

            @Override
            public void remove() {
                if (this.justModified) {
                    throw new IllegalStateException();
                }
                Node.this.removeChild(this.current);
                --this.current;
                this.justModified = true;
            }

            @Override
            public void add(Node n) {
                if (this.justModified) {
                    throw new IllegalStateException();
                }
                Node.this.addChild(this.current + 1, n);
                this.justModified = true;
            }

            @Override
            public boolean hasPrevious() {
                return this.current > 0;
            }

            @Override
            public int nextIndex() {
                return this.current + 1;
            }

            @Override
            public int previousIndex() {
                return this.current;
            }

            @Override
            public void set(Node n) {
                Node.this.setChild(this.current, n);
            }
        };
    }

    public static abstract class Visitor {
        private static Map<Class<? extends Visitor>, Map<Class<? extends Node>, Method>> mapLookup;
        private static final Method DUMMY_METHOD;
        private Map<Class<? extends Node>, Method> methodCache = mapLookup.get(this.getClass());
        protected boolean visitUnparsedTokens;

        public Visitor() {
            if (this.methodCache == null) {
                this.methodCache = new ConcurrentHashMap<Class<? extends Node>, Method>();
                mapLookup.put(this.getClass(), this.methodCache);
            }
        }

        private Method getVisitMethod(Node node) {
            Class<?> nodeClass = node.getClass();
            Method method = this.methodCache.get(nodeClass);
            if (method == null) {
                this.methodCache.put(nodeClass, this.getVisitMethodImpl(nodeClass));
            }
            return this.methodCache.get(nodeClass);
        }

        private Method getVisitMethodImpl(Class<?> nodeClass) {
            if (nodeClass == null || !Node.class.isAssignableFrom(nodeClass)) {
                return DUMMY_METHOD;
            }
            try {
                Method m = this.getClass().getDeclaredMethod("visit", nodeClass);
                if (!Modifier.isPublic(nodeClass.getModifiers()) || !Modifier.isPublic(m.getModifiers())) {
                    m.setAccessible(true);
                }
                return m;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                for (Class<?> interf : nodeClass.getInterfaces()) {
                    if (!Node.class.isAssignableFrom(interf) || Node.class.equals(interf)) continue;
                    try {
                        Method m = this.getClass().getDeclaredMethod("visit", interf);
                        if (!Modifier.isPublic(interf.getModifiers()) || !Modifier.isPublic(m.getModifiers())) {
                            m.setAccessible(true);
                        }
                        return m;
                    }
                    catch (NoSuchMethodException noSuchMethodException2) {
                        // empty catch block
                    }
                }
                return this.getVisitMethodImpl(nodeClass.getSuperclass());
            }
        }

        public final void visit(Node node) {
            Method visitMethod = this.getVisitMethod(node);
            if (visitMethod == DUMMY_METHOD) {
                this.recurse(node);
            } else {
                try {
                    visitMethod.invoke((Object)this, node);
                }
                catch (InvocationTargetException ite) {
                    Throwable cause = ite.getCause();
                    if (cause instanceof RuntimeException) {
                        throw (RuntimeException)cause;
                    }
                    throw new RuntimeException(ite);
                }
                catch (IllegalAccessException iae) {
                    throw new RuntimeException(iae);
                }
            }
        }

        public final void recurse(Node node) {
            for (Node child : node.children(this.visitUnparsedTokens)) {
                this.visit(child);
            }
        }

        static {
            try {
                DUMMY_METHOD = Object.class.getMethod("toString", new Class[0]);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            mapLookup = Collections.synchronizedMap(new HashMap());
        }
    }
}

