/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.frostserver.util.pathparser;

import de.fraunhofer.iosb.ilt.frostserver.util.pathparser.Node;
import de.fraunhofer.iosb.ilt.frostserver.util.pathparser.PConstants;
import de.fraunhofer.iosb.ilt.frostserver.util.pathparser.PLexer;
import de.fraunhofer.iosb.ilt.frostserver.util.pathparser.ParseException;
import de.fraunhofer.iosb.ilt.frostserver.util.pathparser.Token;
import de.fraunhofer.iosb.ilt.frostserver.util.pathparser.nodes.P_EntityId;
import de.fraunhofer.iosb.ilt.frostserver.util.pathparser.nodes.P_PathElement;
import de.fraunhofer.iosb.ilt.frostserver.util.pathparser.nodes.Start;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.ListIterator;
import java.util.concurrent.CancellationException;

public class PParser
implements PConstants {
    static final int UNLIMITED = Integer.MAX_VALUE;
    Token lastConsumedToken;
    private PConstants.TokenType nextTokenType;
    private Token currentLookaheadToken;
    private boolean scanToEnd;
    private String currentlyParsedProduction;
    private String currentLookaheadProduction;
    private boolean cancelled;
    public PLexer token_source;
    private static HashMap<PConstants.TokenType[], EnumSet<PConstants.TokenType>> enumSetCache = new HashMap();
    private static final EnumSet<PConstants.TokenType> first_set$pathParser_ccc$52$14 = PParser.tokenTypeSet(PConstants.TokenType.T_LONG, PConstants.TokenType.T_STR_LIT);
    ArrayList<NonTerminalCall> parsingStack = new ArrayList();
    private ArrayList<NonTerminalCall> lookaheadStack = new ArrayList();
    private boolean buildTree = true;
    private boolean tokensAreNodes = true;
    private boolean unparsedTokensAreNodes = false;
    NodeScope currentNodeScope = new NodeScope();
    PParser jjtree = this;

    public void cancel() {
        this.cancelled = true;
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    public void setInputSource(String inputSource) {
        this.token_source.setInputSource(inputSource);
    }

    String getInputSource() {
        return this.token_source.getInputSource();
    }

    public PParser(String inputSource, CharSequence content) {
        this(new PLexer(inputSource, content));
    }

    public PParser(CharSequence content) {
        this("input", content);
    }

    public PParser(String inputSource, Path path) throws IOException {
        this(inputSource, PConstants.stringFromBytes(Files.readAllBytes(path)));
    }

    public PParser(String inputSource, Path path, Charset charset) throws IOException {
        this(inputSource, PConstants.stringFromBytes(Files.readAllBytes(path), charset));
    }

    public PParser(Path path) throws IOException {
        this(path.toString(), path);
    }

    public PParser(InputStream stream) {
        this(new InputStreamReader(stream));
    }

    public PParser(Reader reader) {
        this(new PLexer("input", reader));
    }

    public PParser(PLexer lexer) {
        this.token_source = lexer;
        this.lastConsumedToken = lexer.DUMMY_START_TOKEN;
        this.lastConsumedToken.setTokenSource(lexer);
    }

    private final Token nextToken(Token tok) {
        Token result = this.token_source.getNextToken(tok);
        while (result.isUnparsed()) {
            result = this.token_source.getNextToken(result);
        }
        this.nextTokenType = null;
        return result;
    }

    public final Token getNextToken() {
        return this.getToken(1);
    }

    public final Token getToken(int index) {
        int i;
        Token t = this.currentLookaheadToken == null ? this.lastConsumedToken : this.currentLookaheadToken;
        for (i = 0; i < index; ++i) {
            t = this.nextToken(t);
        }
        for (i = 0; i > index && (t = t.getPrevious()) != null; --i) {
        }
        return t;
    }

    private final PConstants.TokenType nextTokenType() {
        if (this.nextTokenType == null) {
            this.nextTokenType = this.nextToken(this.lastConsumedToken).getType();
        }
        return this.nextTokenType;
    }

    boolean activateTokenTypes(PConstants.TokenType ... types) {
        boolean result = false;
        for (PConstants.TokenType tt : types) {
            result |= this.token_source.activeTokenTypes.add(tt);
        }
        this.token_source.reset(this.getToken(0));
        this.nextTokenType = null;
        return result;
    }

    boolean deactivateTokenTypes(PConstants.TokenType ... types) {
        boolean result = false;
        for (PConstants.TokenType tt : types) {
            result |= this.token_source.activeTokenTypes.remove((Object)tt);
        }
        this.token_source.reset(this.getToken(0));
        this.nextTokenType = null;
        return result;
    }

    private static EnumSet<PConstants.TokenType> tokenTypeSet(PConstants.TokenType first, PConstants.TokenType ... rest) {
        PConstants.TokenType[] key = new PConstants.TokenType[1 + rest.length];
        key[0] = first;
        if (rest.length > 0) {
            System.arraycopy(rest, 0, key, 1, rest.length);
        }
        Arrays.sort((Object[])key);
        if (enumSetCache.containsKey(key)) {
            return enumSetCache.get(key);
        }
        EnumSet<PConstants.TokenType> result = rest.length == 0 ? EnumSet.of(first) : EnumSet.of(first, rest);
        enumSetCache.put(key, result);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Start Start() throws ParseException {
        if (this.cancelled) {
            throw new CancellationException();
        }
        String prevProduction = this.currentlyParsedProduction;
        this.currentlyParsedProduction = "Start";
        Start Start1 = null;
        if (this.buildTree) {
            Start1 = new Start();
            this.openNodeScope(Start1);
        }
        ParseException parseException1 = null;
        int callStackSize2 = this.parsingStack.size();
        try {
            this.consumeToken(PConstants.TokenType.T_PATH_SEPARATOR);
            this.pushOntoCallStack("Start", "src/main/congocc/pathParser.ccc", 44, 22);
            try {
                this.P_PathElement();
            }
            finally {
                this.popCallStack();
            }
            while (this.nextTokenType() == PConstants.TokenType.T_PATH_SEPARATOR) {
                this.consumeToken(PConstants.TokenType.T_PATH_SEPARATOR);
                this.pushOntoCallStack("Start", "src/main/congocc/pathParser.ccc", 44, 56);
                try {
                    this.P_PathElement();
                }
                finally {
                    this.popCallStack();
                }
            }
            if (this.nextTokenType() == PConstants.TokenType.T_REF) {
                this.consumeToken(PConstants.TokenType.T_REF);
            } else if (this.nextTokenType() == PConstants.TokenType.T_VALUE) {
                this.consumeToken(PConstants.TokenType.T_VALUE);
            }
            this.consumeToken(PConstants.TokenType.EOF);
            Start start = Start1;
            this.restoreCallStack(callStackSize2);
            if (Start1 != null) {
                if (parseException1 == null) {
                    this.closeNodeScope((Node)Start1, this.nodeArity() > 1);
                } else {
                    this.clearNodeScope();
                }
            }
            this.currentlyParsedProduction = prevProduction;
            return start;
        }
        catch (ParseException e) {
            try {
                parseException1 = e;
                throw e;
            }
            catch (Throwable throwable) {
                this.restoreCallStack(callStackSize2);
                if (Start1 != null) {
                    if (parseException1 == null) {
                        this.closeNodeScope((Node)Start1, this.nodeArity() > 1);
                    } else {
                        this.clearNodeScope();
                    }
                }
                this.currentlyParsedProduction = prevProduction;
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void P_PathElement() throws ParseException {
        if (this.cancelled) {
            throw new CancellationException();
        }
        String prevProduction = this.currentlyParsedProduction;
        this.currentlyParsedProduction = "P_PathElement";
        P_PathElement P_PathElement2 = null;
        if (this.buildTree) {
            P_PathElement2 = new P_PathElement();
            this.openNodeScope(P_PathElement2);
        }
        ParseException parseException46 = null;
        int callStackSize47 = this.parsingStack.size();
        try {
            this.consumeToken(PConstants.TokenType.T_NAME);
            if (this.nextTokenType() == PConstants.TokenType.T_ARRAYINDEX) {
                this.pushOntoCallStack("P_PathElement", "src/main/congocc/pathParser.ccc", 48, 14);
                try {
                    this.P_ArrayIndex();
                }
                finally {
                    this.popCallStack();
                }
            }
            if (this.nextTokenType() == PConstants.TokenType.T_LB) {
                this.pushOntoCallStack("P_PathElement", "src/main/congocc/pathParser.ccc", 48, 29);
                try {
                    this.P_EntityId();
                }
                finally {
                    this.popCallStack();
                }
            }
            this.restoreCallStack(callStackSize47);
            if (P_PathElement2 != null) {
                if (parseException46 == null) {
                    this.closeNodeScope((Node)P_PathElement2, this.nodeArity() > 1);
                } else {
                    this.clearNodeScope();
                }
            }
            this.currentlyParsedProduction = prevProduction;
        }
        catch (ParseException e) {
            try {
                parseException46 = e;
                throw e;
            }
            catch (Throwable throwable) {
                this.restoreCallStack(callStackSize47);
                if (P_PathElement2 != null) {
                    if (parseException46 == null) {
                        this.closeNodeScope((Node)P_PathElement2, this.nodeArity() > 1);
                    } else {
                        this.clearNodeScope();
                    }
                }
                this.currentlyParsedProduction = prevProduction;
                throw throwable;
            }
        }
    }

    public final void P_EntityId() throws ParseException {
        if (this.cancelled) {
            throw new CancellationException();
        }
        String prevProduction = this.currentlyParsedProduction;
        this.currentlyParsedProduction = "P_EntityId";
        P_EntityId P_EntityId3 = null;
        if (this.buildTree) {
            P_EntityId3 = new P_EntityId();
            this.openNodeScope(P_EntityId3);
        }
        ParseException parseException70 = null;
        int callStackSize71 = this.parsingStack.size();
        try {
            this.consumeToken(PConstants.TokenType.T_LB);
            if (this.nextTokenType() == PConstants.TokenType.T_LONG) {
                this.consumeToken(PConstants.TokenType.T_LONG);
            } else if (this.nextTokenType() == PConstants.TokenType.T_STR_LIT) {
                this.consumeToken(PConstants.TokenType.T_STR_LIT);
            } else {
                this.pushOntoCallStack("P_EntityId", "src/main/congocc/pathParser.ccc", 52, 14);
                throw new ParseException(this, first_set$pathParser_ccc$52$14, this.parsingStack);
            }
            this.consumeToken(PConstants.TokenType.T_RB);
        }
        catch (ParseException e) {
            parseException70 = e;
            throw e;
        }
        finally {
            this.restoreCallStack(callStackSize71);
            if (P_EntityId3 != null) {
                if (parseException70 == null) {
                    this.closeNodeScope((Node)P_EntityId3, true);
                } else {
                    this.clearNodeScope();
                }
            }
            this.currentlyParsedProduction = prevProduction;
        }
    }

    public final void P_ArrayIndex() throws ParseException {
        if (this.cancelled) {
            throw new CancellationException();
        }
        String prevProduction = this.currentlyParsedProduction;
        this.currentlyParsedProduction = "P_ArrayIndex";
        this.consumeToken(PConstants.TokenType.T_ARRAYINDEX);
        while (this.nextTokenType() == PConstants.TokenType.T_ARRAYINDEX) {
            this.consumeToken(PConstants.TokenType.T_ARRAYINDEX);
        }
    }

    private final void pushOntoCallStack(String methodName, String fileName, int line, int column) {
        this.parsingStack.add(new NonTerminalCall(fileName, methodName, line, column));
    }

    private final void popCallStack() {
        NonTerminalCall ntc = this.parsingStack.remove(this.parsingStack.size() - 1);
        this.currentlyParsedProduction = ntc.productionName;
    }

    private final void restoreCallStack(int prevSize) {
        while (this.parsingStack.size() > prevSize) {
            this.popCallStack();
        }
    }

    void dumpLookaheadStack(PrintStream ps) {
        ListIterator<NonTerminalCall> it = this.lookaheadStack.listIterator(this.lookaheadStack.size());
        while (it.hasPrevious()) {
            it.previous().dump(ps);
        }
    }

    void dumpCallStack(PrintStream ps) {
        ListIterator<NonTerminalCall> it = this.parsingStack.listIterator(this.parsingStack.size());
        while (it.hasPrevious()) {
            it.previous().dump(ps);
        }
    }

    void dumpLookaheadCallStack(PrintStream ps) {
        ps.println("Current Parser Production is: " + this.currentlyParsedProduction);
        ps.println("Current Lookahead Production is: " + this.currentLookaheadProduction);
        ps.println("---Lookahead Stack---");
        this.dumpLookaheadStack(ps);
        ps.println("---Call Stack---");
        this.dumpCallStack(ps);
    }

    public boolean isParserTolerant() {
        return false;
    }

    public void setParserTolerant(boolean tolerantParsing) {
        if (tolerantParsing) {
            throw new UnsupportedOperationException("This parser was not built with that feature!");
        }
    }

    private Token consumeToken(PConstants.TokenType expectedType) throws ParseException {
        Token oldToken = this.lastConsumedToken;
        Token nextToken = this.nextToken(this.lastConsumedToken);
        if (nextToken.getType() != expectedType) {
            nextToken = this.handleUnexpectedTokenType(expectedType, nextToken);
        }
        this.lastConsumedToken = nextToken;
        this.nextTokenType = null;
        if (this.buildTree && this.tokensAreNodes) {
            this.pushNode(this.lastConsumedToken);
        }
        return this.lastConsumedToken;
    }

    private Token handleUnexpectedTokenType(PConstants.TokenType expectedType, Token nextToken) throws ParseException {
        throw new ParseException(nextToken, EnumSet.of(expectedType), this.parsingStack);
    }

    public boolean isTreeBuildingEnabled() {
        return this.buildTree;
    }

    public void setUnparsedTokensAreNodes(boolean unparsedTokensAreNodes) {
        this.unparsedTokensAreNodes = unparsedTokensAreNodes;
    }

    public void setTokensAreNodes(boolean tokensAreNodes) {
        this.tokensAreNodes = tokensAreNodes;
    }

    public Node rootNode() {
        return this.currentNodeScope.rootNode();
    }

    public void pushNode(Node n) {
        this.currentNodeScope.add(n);
    }

    public Node popNode() {
        return this.currentNodeScope.pop();
    }

    public Node peekNode() {
        return this.currentNodeScope.peek();
    }

    public void pokeNode(Node n) {
        this.currentNodeScope.poke(n);
    }

    public int nodeArity() {
        return this.currentNodeScope.size();
    }

    private void clearNodeScope() {
        this.currentNodeScope.clear();
    }

    private void openNodeScope(Node n) {
        new NodeScope();
        if (n != null) {
            Token next = this.nextToken(this.lastConsumedToken);
            n.setTokenSource(this.lastConsumedToken.getTokenSource());
            n.setBeginOffset(next.getBeginOffset());
            n.open();
        }
    }

    private void closeNodeScope(Node n, int num) {
        n.setEndOffset(this.lastConsumedToken.getEndOffset());
        this.currentNodeScope.close();
        ArrayList<Node> nodes = new ArrayList<Node>();
        for (int i = 0; i < num; ++i) {
            nodes.add(this.popNode());
        }
        Collections.reverse(nodes);
        for (Node child : nodes) {
            n.addChild(child);
        }
        n.close();
        this.pushNode(n);
    }

    private void closeNodeScope(Node n, boolean condition) {
        if (n != null && condition) {
            n.setEndOffset(this.lastConsumedToken.getEndOffset());
            int a = this.nodeArity();
            this.currentNodeScope.close();
            ArrayList<Node> nodes = new ArrayList<Node>();
            while (a-- > 0) {
                nodes.add(this.popNode());
            }
            Collections.reverse(nodes);
            for (Node child : nodes) {
                if (this.unparsedTokensAreNodes && child instanceof Token) {
                    Token tok = (Token)child;
                    while (tok.previousCachedToken() != null && tok.previousCachedToken().isUnparsed()) {
                        tok = tok.previousCachedToken();
                    }
                    while (tok.isUnparsed()) {
                        n.addChild(tok);
                        tok = tok.nextCachedToken();
                    }
                }
                n.addChild(child);
            }
            n.close();
            this.pushNode(n);
        } else {
            this.currentNodeScope.close();
        }
    }

    public boolean getBuildTree() {
        return this.buildTree;
    }

    public void setBuildTree(boolean buildTree) {
        this.buildTree = buildTree;
    }

    class NodeScope
    extends ArrayList<Node> {
        NodeScope parentScope;

        NodeScope() {
            this.parentScope = PParser.this.currentNodeScope;
            PParser.this.currentNodeScope = this;
        }

        boolean isRootScope() {
            return this.parentScope == null;
        }

        Node rootNode() {
            NodeScope ns = this;
            while (ns.parentScope != null) {
                ns = ns.parentScope;
            }
            return ns.isEmpty() ? null : (Node)ns.get(0);
        }

        Node peek() {
            return this.isEmpty() ? this.parentScope.peek() : (Node)this.get(this.size() - 1);
        }

        Node pop() {
            return this.isEmpty() ? this.parentScope.pop() : (Node)this.remove(this.size() - 1);
        }

        void poke(Node n) {
            if (this.isEmpty()) {
                this.parentScope.poke(n);
            } else {
                this.set(this.size() - 1, n);
            }
        }

        void close() {
            this.parentScope.addAll(this);
            PParser.this.currentNodeScope = this.parentScope;
        }

        int nestingLevel() {
            int result = 0;
            NodeScope parent = this;
            while (parent.parentScope != null) {
                ++result;
                parent = parent.parentScope;
            }
            return result;
        }

        @Override
        public NodeScope clone() {
            NodeScope clone = (NodeScope)super.clone();
            if (this.parentScope != null) {
                clone.parentScope = this.parentScope.clone();
            }
            return clone;
        }
    }

    class NonTerminalCall {
        final String sourceFile;
        final String productionName;
        final int line;
        final int column;
        final boolean scanToEnd;

        NonTerminalCall(String sourceFile, String productionName, int line, int column) {
            this.sourceFile = sourceFile;
            this.productionName = productionName;
            this.line = line;
            this.column = column;
            this.scanToEnd = PParser.this.scanToEnd;
        }

        final PLexer getTokenSource() {
            return PParser.this.token_source;
        }

        StackTraceElement createStackTraceElement() {
            return new StackTraceElement("PParser", this.productionName, this.sourceFile, this.line);
        }

        void dump(PrintStream ps) {
            ps.println(this.productionName + ":" + this.line + ":" + this.column);
        }
    }

    private class ParseState {
        Token lastConsumed;
        ArrayList<NonTerminalCall> parsingStack;
        NodeScope nodeScope;

        ParseState() {
            ArrayList parsingStack;
            this.lastConsumed = PParser.this.lastConsumedToken;
            this.parsingStack = parsingStack = (ArrayList)PParser.this.parsingStack.clone();
            this.nodeScope = PParser.this.currentNodeScope.clone();
        }
    }
}

