/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.frostserver.util.pathparser;

import java.io.IOException;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;

public interface PConstants {
    public static final int BUF_SIZE = 65536;

    public static String displayChar(int ch) {
        if (ch == 39) {
            return "'\\''";
        }
        if (ch == 92) {
            return "'\\\\'";
        }
        if (ch == 9) {
            return "'\\t'";
        }
        if (ch == 13) {
            return "'\\r'";
        }
        if (ch == 10) {
            return "'\\n'";
        }
        if (ch == 12) {
            return "'\\f'";
        }
        if (ch == 32) {
            return "' '";
        }
        if (ch < 128 && !Character.isWhitespace(ch) && !Character.isISOControl(ch)) {
            return "'" + (char)ch + "'";
        }
        if (ch < 10) {
            return "" + ch;
        }
        return "0x" + Integer.toHexString(ch);
    }

    public static String addEscapes(String str) {
        StringBuilder retval = new StringBuilder();
        block10: for (int ch : str.codePoints().toArray()) {
            switch (ch) {
                case 8: {
                    retval.append("\\b");
                    continue block10;
                }
                case 9: {
                    retval.append("\\t");
                    continue block10;
                }
                case 10: {
                    retval.append("\\n");
                    continue block10;
                }
                case 12: {
                    retval.append("\\f");
                    continue block10;
                }
                case 13: {
                    retval.append("\\r");
                    continue block10;
                }
                case 34: {
                    retval.append("\\\"");
                    continue block10;
                }
                case 39: {
                    retval.append("\\'");
                    continue block10;
                }
                case 92: {
                    retval.append("\\\\");
                    continue block10;
                }
                default: {
                    if (Character.isISOControl(ch)) {
                        String s = "0000" + Integer.toString(ch, 16);
                        retval.append("\\u" + s.substring(s.length() - 4, s.length()));
                        continue block10;
                    }
                    retval.appendCodePoint(ch);
                    continue block10;
                }
            }
        }
        return retval.toString();
    }

    public static String readToEnd(Reader reader) {
        try {
            return PConstants.readFully(reader);
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    public static String readFully(Reader reader) throws IOException {
        char[] block = new char[65536];
        int charsRead = reader.read(block);
        if (charsRead < 0) {
            throw new IOException("No input");
        }
        if (charsRead < 65536) {
            char[] result = new char[charsRead];
            System.arraycopy(block, 0, result, 0, charsRead);
            reader.close();
            return new String(block, 0, charsRead);
        }
        StringBuilder buf = new StringBuilder();
        buf.append(block);
        do {
            if ((charsRead = reader.read(block)) <= 0) continue;
            buf.append(block, 0, charsRead);
        } while (charsRead == 65536);
        reader.close();
        return buf.toString();
    }

    public static String stringFromBytes(byte[] bytes, Charset charset) {
        int arrayLength = bytes.length;
        if (charset == null) {
            int fourthByte;
            int firstByte = arrayLength > 0 ? Byte.toUnsignedInt(bytes[0]) : 1;
            int secondByte = arrayLength > 1 ? Byte.toUnsignedInt(bytes[1]) : 1;
            int thirdByte = arrayLength > 2 ? Byte.toUnsignedInt(bytes[2]) : 1;
            int n = fourthByte = arrayLength > 3 ? Byte.toUnsignedInt(bytes[3]) : 1;
            if (firstByte == 239 && secondByte == 187 && thirdByte == 191) {
                return new String(bytes, 3, bytes.length - 3, Charset.forName("UTF-8"));
            }
            if (firstByte == 0 && secondByte == 0 && thirdByte == 254 && fourthByte == 255) {
                return new String(bytes, 4, bytes.length - 4, Charset.forName("UTF-32BE"));
            }
            if (firstByte == 255 && secondByte == 254 && thirdByte == 0 && fourthByte == 0) {
                return new String(bytes, 4, bytes.length - 4, Charset.forName("UTF-32LE"));
            }
            if (firstByte == 254 && secondByte == 255) {
                return new String(bytes, 2, bytes.length - 2, Charset.forName("UTF-16BE"));
            }
            if (firstByte == 255 && secondByte == 254) {
                return new String(bytes, 2, bytes.length - 2, Charset.forName("UTF-16LE"));
            }
            charset = StandardCharsets.UTF_8;
        }
        return new String(bytes, charset);
    }

    public static String stringFromBytes(byte[] bytes) {
        return PConstants.stringFromBytes(bytes, null);
    }

    public static enum LexicalState {
        DEFAULT;

    }

    public static enum TokenType {
        EOF,
        _TOKEN_1,
        _TOKEN_2,
        _TOKEN_3,
        _TOKEN_4,
        T_PATH_SEPARATOR,
        T_VALUE,
        T_REF,
        T_LB,
        T_RB,
        T_NAME,
        T_LONG,
        T_DOUBLE,
        T_STR_LIT,
        T_ARRAYINDEX,
        INVALID;

    }
}

