/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.frostserver.util;

import de.fraunhofer.iosb.ilt.frostserver.util.SimpleJsonMapper;
import java.io.IOException;
import org.geojson.GeoJsonObject;
import org.geojson.Point;

public class GeoHelper {
    private GeoHelper() {
    }

    public static <T extends Number> Point getPoint(T ... values) {
        if (values == null || values.length < 2 || values.length > 3) {
            throw new IllegalArgumentException("values must have a length of 2 or 3.");
        }
        if (values.length == 2) {
            return new Point(((Number)values[0]).doubleValue(), ((Number)values[1]).doubleValue());
        }
        return new Point(((Number)values[0]).doubleValue(), ((Number)values[1]).doubleValue(), ((Number)values[2]).doubleValue());
    }

    public static GeoJsonObject parseGeoJson(String geoJsonString) throws IOException {
        return (GeoJsonObject)SimpleJsonMapper.getSimpleObjectMapper().readValue(geoJsonString, GeoJsonObject.class);
    }
}

