/* Generated by: JavaCC 21 Parser Generator. QNfaData.java */
package de.fraunhofer.iosb.ilt.frostserver.util.queryparser;

import static de.fraunhofer.iosb.ilt.frostserver.util.queryparser.QConstants.TokenType.*;
import java.util.Arrays;
import java.util.BitSet;
import java.util.EnumSet;
import java.util.EnumMap;
/**
 * Holder class for the data used by QLexer
 * to do the NFA thang
 */
class QNfaData implements QConstants {
    // The functional interface that represents 
    // the acceptance method of an NFA state
    static interface NfaFunction {
        TokenType apply(int ch, BitSet bs, EnumSet<TokenType> validTypes);
    }
    // A lookup of the NFA function tables for the respective lexical states.
    private static final EnumMap<LexicalState, NfaFunction[]> functionTableMap= new EnumMap<> (LexicalState.class);
    // This data holder class is never instantiated
    private QNfaData() {
    }

    /**
   * @param the lexical state
   * @return the table of function pointers that implement the lexical state
   */
    static final NfaFunction[] getFunctionTableMap(LexicalState lexicalState) {
        return functionTableMap.get(lexicalState);
    }

    // Initialize the various NFA method tables
    static {
        DEFAULT.NFA_FUNCTIONS_init();
        LS_REF.NFA_FUNCTIONS_init();
        LS_QUERY.NFA_FUNCTIONS_init();
        LS_SUBQUERY.NFA_FUNCTIONS_init();
        LS_FILTER.NFA_FUNCTIONS_init();
        LS_CONSTANTS.NFA_FUNCTIONS_init();
        LS_PLAIN_PATH.NFA_FUNCTIONS_init();
        LS_ORDERBYS.NFA_FUNCTIONS_init();
        LS_ORDERBY.NFA_FUNCTIONS_init();
        LS_ANYSTRING.NFA_FUNCTIONS_init();
        LS_FORMAT.NFA_FUNCTIONS_init();
        LS_METADATA.NFA_FUNCTIONS_init();
        LS_COUNT.NFA_FUNCTIONS_init();
        LS_TOP.NFA_FUNCTIONS_init();
        LS_SKIP.NFA_FUNCTIONS_init();
        LS_EXPAND.NFA_FUNCTIONS_init();
        LS_SELECT.NFA_FUNCTIONS_init();
    }
    /**
  * Holder class for NFA code related to DEFAULT lexical state
  */
    private static class DEFAULT {
        static TokenType NFA_COMPOSITE_0(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            TokenType type= null;
            if (ch== '\t') {
                if (validTypes.contains(_TOKEN_4)) type= _TOKEN_4;
            }
            else if (ch== '\r') {
                if (validTypes.contains(_TOKEN_3)) type= _TOKEN_3;
            }
            else if (ch== '\n') {
                if (validTypes.contains(_TOKEN_2)) type= _TOKEN_2;
            }
            else if (ch== ' ') {
                if (validTypes.contains(_TOKEN_1)) type= _TOKEN_1;
            }
            return type;
        }

        static TokenType NFA_1(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch== '\t') {
                if (validTypes.contains(_TOKEN_4)) return _TOKEN_4;
            }
            return null;
        }

        static TokenType NFA_2(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch== '\n') {
                if (validTypes.contains(_TOKEN_2)) return _TOKEN_2;
            }
            return null;
        }

        static TokenType NFA_3(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch== '\r') {
                if (validTypes.contains(_TOKEN_3)) return _TOKEN_3;
            }
            return null;
        }

        static TokenType NFA_4(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch== ' ') {
                if (validTypes.contains(_TOKEN_1)) return _TOKEN_1;
            }
            return null;
        }

        static private void NFA_FUNCTIONS_init() {
            NfaFunction[] functions= new NfaFunction[5];
            functions[0]= DEFAULT::NFA_COMPOSITE_0;
            functions[1]= DEFAULT::NFA_1;
            functions[2]= DEFAULT::NFA_2;
            functions[3]= DEFAULT::NFA_3;
            functions[4]= DEFAULT::NFA_4;
            functionTableMap.put(LexicalState.DEFAULT, functions);
        }

    }
    /**
  * Holder class for NFA code related to LS_REF lexical state
  */
    private static class LS_REF {
        static TokenType NFA_COMPOSITE_LS_REF_0(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            TokenType type= null;
            if (ch== '$') {
                nextStates.set(7);
            }
            else if (ch== '\t') {
                if (validTypes.contains(_TOKEN_4)) type= _TOKEN_4;
            }
            else if (ch== '\r') {
                if (validTypes.contains(_TOKEN_3)) type= _TOKEN_3;
            }
            else if (ch== '\n') {
                if (validTypes.contains(_TOKEN_2)) type= _TOKEN_2;
            }
            else if (ch== ' ') {
                if (validTypes.contains(_TOKEN_1)) type= _TOKEN_1;
            }
            return type;
        }

        static TokenType NFA_LS_REF_1(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch== '\t') {
                if (validTypes.contains(_TOKEN_4)) return _TOKEN_4;
            }
            return null;
        }

        static TokenType NFA_LS_REF_2(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch== '\n') {
                if (validTypes.contains(_TOKEN_2)) return _TOKEN_2;
            }
            return null;
        }

        static TokenType NFA_LS_REF_3(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch== '\r') {
                if (validTypes.contains(_TOKEN_3)) return _TOKEN_3;
            }
            return null;
        }

        static TokenType NFA_LS_REF_4(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'D')||(ch== 'd')) {
                nextStates.set(8);
            }
            return null;
        }

        static TokenType NFA_LS_REF_5(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch== ' ') {
                if (validTypes.contains(_TOKEN_1)) return _TOKEN_1;
            }
            return null;
        }

        static TokenType NFA_LS_REF_6(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch== '$') {
                nextStates.set(7);
            }
            return null;
        }

        static TokenType NFA_LS_REF_7(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'I')||(ch== 'i')) {
                nextStates.set(4);
            }
            return null;
        }

        static TokenType NFA_LS_REF_8(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch== '=') {
                if (validTypes.contains(T_O_ID)) return T_O_ID;
            }
            return null;
        }

        static private void NFA_FUNCTIONS_init() {
            NfaFunction[] functions= new NfaFunction[9];
            functions[0]= LS_REF::NFA_COMPOSITE_LS_REF_0;
            functions[1]= LS_REF::NFA_LS_REF_1;
            functions[2]= LS_REF::NFA_LS_REF_2;
            functions[3]= LS_REF::NFA_LS_REF_3;
            functions[4]= LS_REF::NFA_LS_REF_4;
            functions[5]= LS_REF::NFA_LS_REF_5;
            functions[6]= LS_REF::NFA_LS_REF_6;
            functions[7]= LS_REF::NFA_LS_REF_7;
            functions[8]= LS_REF::NFA_LS_REF_8;
            functionTableMap.put(LexicalState.LS_REF, functions);
        }

    }
    /**
  * Holder class for NFA code related to LS_QUERY lexical state
  */
    private static class LS_QUERY {
        static TokenType NFA_COMPOSITE_LS_QUERY_0(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            TokenType type= null;
            if (ch== '$') {
                nextStates.set(79);
                nextStates.set(58);
                nextStates.set(33);
                nextStates.set(92);
                nextStates.set(84);
                nextStates.set(69);
                nextStates.set(41);
                nextStates.set(1);
                nextStates.set(62);
                nextStates.set(77);
            }
            else if (ch== '&') {
                if (validTypes.contains(T_OPTIONS_SEPARATOR)) type= T_OPTIONS_SEPARATOR;
            }
            else if (ch== '\t') {
                if (validTypes.contains(_TOKEN_4)) type= _TOKEN_4;
            }
            else if (ch== '\r') {
                if (validTypes.contains(_TOKEN_3)) type= _TOKEN_3;
            }
            else if (ch== '\n') {
                if (validTypes.contains(_TOKEN_2)) type= _TOKEN_2;
            }
            else if (ch== ' ') {
                if (validTypes.contains(_TOKEN_1)) type= _TOKEN_1;
            }
            return type;
        }

        static TokenType NFA_COMPOSITE_LS_QUERY_1(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            TokenType type= null;
            if ((ch== 'F')||(ch== 'f')) {
                nextStates.set(25);
            }
            else if ((ch== 'R')||(ch== 'r')) {
                nextStates.set(10);
            }
            return type;
        }

        static TokenType NFA_LS_QUERY_2(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'T')||(ch== 't')) {
                nextStates.set(36);
            }
            return null;
        }

        static TokenType NFA_LS_QUERY_3(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch== '$') {
                nextStates.set(79);
            }
            return null;
        }

        static TokenType NFA_LS_QUERY_4(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'L')||(ch== 'l')) {
                nextStates.set(30);
            }
            return null;
        }

        static TokenType NFA_LS_QUERY_5(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'D')||(ch== 'd')) {
                nextStates.set(39);
            }
            return null;
        }

        static TokenType NFA_LS_QUERY_6(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'R')||(ch== 'r')) {
                nextStates.set(59);
            }
            return null;
        }

        static TokenType NFA_LS_QUERY_7(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'T')||(ch== 't')) {
                nextStates.set(23);
            }
            return null;
        }

        static TokenType NFA_LS_QUERY_8(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch== '$') {
                nextStates.set(92);
            }
            return null;
        }

        static TokenType NFA_LS_QUERY_9(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'K')||(ch== 'k')) {
                nextStates.set(18);
            }
            return null;
        }

        static TokenType NFA_LS_QUERY_10(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'E')||(ch== 'e')) {
                nextStates.set(52);
            }
            return null;
        }

        static TokenType NFA_LS_QUERY_11(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'O')||(ch== 'o')) {
                nextStates.set(76);
            }
            return null;
        }

        static TokenType NFA_LS_QUERY_12(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'R')||(ch== 'r')) {
                nextStates.set(5);
            }
            return null;
        }

        static TokenType NFA_LS_QUERY_13(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'E')||(ch== 'e')) {
                nextStates.set(85);
            }
            return null;
        }

        static TokenType NFA_LS_QUERY_14(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'R')||(ch== 'r')) {
                nextStates.set(53);
            }
            return null;
        }

        static TokenType NFA_LS_QUERY_15(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'L')||(ch== 'l')) {
                nextStates.set(57);
            }
            return null;
        }

        static TokenType NFA_LS_QUERY_16(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'M')||(ch== 'm')) {
                nextStates.set(21);
            }
            return null;
        }

        static TokenType NFA_LS_QUERY_17(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch== '=') {
                if (validTypes.contains(T_O_EXPAND)) return T_O_EXPAND;
            }
            return null;
        }

        static TokenType NFA_LS_QUERY_18(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'I')||(ch== 'i')) {
                nextStates.set(73);
            }
            return null;
        }

        static TokenType NFA_LS_QUERY_19(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'T')||(ch== 't')) {
                nextStates.set(94);
            }
            return null;
        }

        static TokenType NFA_LS_QUERY_20(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'D')||(ch== 'd')) {
                nextStates.set(17);
            }
            return null;
        }

        static TokenType NFA_LS_QUERY_21(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'E')||(ch== 'e')) {
                nextStates.set(2);
            }
            return null;
        }

        static TokenType NFA_LS_QUERY_22(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch== '$') {
                nextStates.set(58);
            }
            return null;
        }

        static TokenType NFA_LS_QUERY_23(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch== '=') {
                if (validTypes.contains(T_O_FORMAT)) return T_O_FORMAT;
            }
            return null;
        }

        static TokenType NFA_LS_QUERY_24(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch== '=') {
                if (validTypes.contains(T_O_SKIP)) return T_O_SKIP;
            }
            return null;
        }

        static TokenType NFA_LS_QUERY_25(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'O')||(ch== 'o')) {
                nextStates.set(78);
            }
            return null;
        }

        static TokenType NFA_LS_QUERY_26(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'L')||(ch== 'l')) {
                nextStates.set(54);
            }
            return null;
        }

        static TokenType NFA_LS_QUERY_27(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch== '=') {
                if (validTypes.contains(T_O_SKIPFILTER)) return T_O_SKIPFILTER;
            }
            return null;
        }

        static TokenType NFA_LS_QUERY_28(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'K')||(ch== 'k')) {
                nextStates.set(46);
            }
            return null;
        }

        static TokenType NFA_LS_QUERY_29(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'M')||(ch== 'm')) {
                nextStates.set(31);
            }
            return null;
        }

        static TokenType NFA_LS_QUERY_30(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'E')||(ch== 'e')) {
                nextStates.set(70);
            }
            return null;
        }

        static TokenType NFA_LS_QUERY_31(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'A')||(ch== 'a')) {
                nextStates.set(7);
            }
            return null;
        }

        static TokenType NFA_LS_QUERY_32(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch== '\r') {
                if (validTypes.contains(_TOKEN_3)) return _TOKEN_3;
            }
            return null;
        }

        static TokenType NFA_LS_QUERY_33(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'F')||(ch== 'f')) {
                nextStates.set(35);
            }
            return null;
        }

        static TokenType NFA_LS_QUERY_34(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch== '$') {
                nextStates.set(41);
            }
            return null;
        }

        static TokenType NFA_LS_QUERY_35(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'I')||(ch== 'i')) {
                nextStates.set(15);
            }
            return null;
        }

        static TokenType NFA_LS_QUERY_36(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'A')||(ch== 'a')) {
                nextStates.set(86);
            }
            return null;
        }

        static TokenType NFA_LS_QUERY_37(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch== '$') {
                nextStates.set(77);
            }
            return null;
        }

        static TokenType NFA_LS_QUERY_38(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch== '=') {
                if (validTypes.contains(T_O_COUNT)) return T_O_COUNT;
            }
            return null;
        }

        static TokenType NFA_LS_QUERY_39(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'E')||(ch== 'e')) {
                nextStates.set(6);
            }
            return null;
        }

        static TokenType NFA_LS_QUERY_40(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'A')||(ch== 'a')) {
                nextStates.set(63);
            }
            return null;
        }

        static TokenType NFA_LS_QUERY_41(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'S')||(ch== 's')) {
                nextStates.set(90);
            }
            return null;
        }

        static TokenType NFA_LS_QUERY_42(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'A')||(ch== 'a')) {
                nextStates.set(56);
            }
            return null;
        }

        static TokenType NFA_LS_QUERY_43(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'I')||(ch== 'i')) {
                nextStates.set(68);
            }
            return null;
        }

        static TokenType NFA_LS_QUERY_44(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'E')||(ch== 'e')) {
                nextStates.set(14);
            }
            return null;
        }

        static TokenType NFA_LS_QUERY_45(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'N')||(ch== 'n')) {
                nextStates.set(49);
            }
            return null;
        }

        static TokenType NFA_LS_QUERY_46(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'I')||(ch== 'i')) {
                nextStates.set(64);
            }
            return null;
        }

        static TokenType NFA_LS_QUERY_47(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch== '=') {
                if (validTypes.contains(T_O_TOP)) return T_O_TOP;
            }
            return null;
        }

        static TokenType NFA_LS_QUERY_48(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch== '&') {
                if (validTypes.contains(T_OPTIONS_SEPARATOR)) return T_OPTIONS_SEPARATOR;
            }
            return null;
        }

        static TokenType NFA_LS_QUERY_49(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'T')||(ch== 't')) {
                nextStates.set(38);
            }
            return null;
        }

        static TokenType NFA_LS_QUERY_50(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'P')||(ch== 'p')) {
                nextStates.set(40);
            }
            return null;
        }

        static TokenType NFA_LS_QUERY_51(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'U')||(ch== 'u')) {
                nextStates.set(88);
            }
            return null;
        }

        static TokenType NFA_LS_QUERY_52(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'S')||(ch== 's')) {
                nextStates.set(72);
            }
            return null;
        }

        static TokenType NFA_LS_QUERY_53(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch== '=') {
                if (validTypes.contains(T_O_FILTER)) return T_O_FILTER;
            }
            return null;
        }

        static TokenType NFA_LS_QUERY_54(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'T')||(ch== 't')) {
                nextStates.set(98);
            }
            return null;
        }

        static TokenType NFA_LS_QUERY_55(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'T')||(ch== 't')) {
                nextStates.set(42);
            }
            return null;
        }

        static TokenType NFA_LS_QUERY_56(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch== '=') {
                if (validTypes.contains(T_O_METADATA)) return T_O_METADATA;
            }
            return null;
        }

        static TokenType NFA_LS_QUERY_57(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'T')||(ch== 't')) {
                nextStates.set(44);
            }
            return null;
        }

        static TokenType NFA_LS_QUERY_58(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'O')||(ch== 'o')) {
                nextStates.set(12);
            }
            return null;
        }

        static TokenType NFA_LS_QUERY_59(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'B')||(ch== 'b')) {
                nextStates.set(89);
            }
            return null;
        }

        static TokenType NFA_LS_QUERY_60(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch== '$') {
                nextStates.set(33);
            }
            return null;
        }

        static TokenType NFA_LS_QUERY_61(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'T')||(ch== 't')) {
                nextStates.set(16);
            }
            return null;
        }

        static TokenType NFA_LS_QUERY_62(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'T')||(ch== 't')) {
                nextStates.set(11);
            }
            return null;
        }

        static TokenType NFA_LS_QUERY_63(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'N')||(ch== 'n')) {
                nextStates.set(20);
            }
            return null;
        }

        static TokenType NFA_LS_QUERY_64(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'P')||(ch== 'p')) {
                nextStates.set(24);
            }
            return null;
        }

        static TokenType NFA_LS_QUERY_65(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch== '$') {
                nextStates.set(69);
            }
            return null;
        }

        static TokenType NFA_LS_QUERY_66(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'E')||(ch== 'e')) {
                nextStates.set(82);
            }
            return null;
        }

        static TokenType NFA_LS_QUERY_67(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch== '$') {
                nextStates.set(1);
            }
            return null;
        }

        static TokenType NFA_LS_QUERY_68(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'L')||(ch== 'l')) {
                nextStates.set(95);
            }
            return null;
        }

        static TokenType NFA_LS_QUERY_69(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'S')||(ch== 's')) {
                nextStates.set(9);
            }
            return null;
        }

        static TokenType NFA_LS_QUERY_70(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'C')||(ch== 'c')) {
                nextStates.set(19);
            }
            return null;
        }

        static TokenType NFA_LS_QUERY_71(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'O')||(ch== 'o')) {
                nextStates.set(91);
            }
            return null;
        }

        static TokenType NFA_LS_QUERY_72(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'U')||(ch== 'u')) {
                nextStates.set(26);
            }
            return null;
        }

        static TokenType NFA_LS_QUERY_73(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'P')||(ch== 'p')) {
                nextStates.set(80);
            }
            return null;
        }

        static TokenType NFA_LS_QUERY_74(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch== '\n') {
                if (validTypes.contains(_TOKEN_2)) return _TOKEN_2;
            }
            return null;
        }

        static TokenType NFA_LS_QUERY_75(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch== '=') {
                if (validTypes.contains(T_O_ORDERBY)) return T_O_ORDERBY;
            }
            return null;
        }

        static TokenType NFA_LS_QUERY_76(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'P')||(ch== 'p')) {
                nextStates.set(47);
            }
            return null;
        }

        static TokenType NFA_LS_QUERY_77(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'E')||(ch== 'e')) {
                nextStates.set(93);
            }
            return null;
        }

        static TokenType NFA_LS_QUERY_78(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'R')||(ch== 'r')) {
                nextStates.set(29);
            }
            return null;
        }

        static TokenType NFA_LS_QUERY_79(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'C')||(ch== 'c')) {
                nextStates.set(71);
            }
            return null;
        }

        static TokenType NFA_LS_QUERY_80(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'F')||(ch== 'f')) {
                nextStates.set(43);
            }
            return null;
        }

        static TokenType NFA_LS_QUERY_81(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch== '$') {
                nextStates.set(62);
            }
            return null;
        }

        static TokenType NFA_LS_QUERY_82(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'R')||(ch== 'r')) {
                nextStates.set(27);
            }
            return null;
        }

        static TokenType NFA_LS_QUERY_83(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch== '$') {
                nextStates.set(84);
            }
            return null;
        }

        static TokenType NFA_LS_QUERY_84(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'S')||(ch== 's')) {
                nextStates.set(28);
            }
            return null;
        }

        static TokenType NFA_LS_QUERY_85(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'S')||(ch== 's')) {
                nextStates.set(51);
            }
            return null;
        }

        static TokenType NFA_LS_QUERY_86(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'D')||(ch== 'd')) {
                nextStates.set(87);
            }
            return null;
        }

        static TokenType NFA_LS_QUERY_87(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'A')||(ch== 'a')) {
                nextStates.set(55);
            }
            return null;
        }

        static TokenType NFA_LS_QUERY_88(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'L')||(ch== 'l')) {
                nextStates.set(61);
            }
            return null;
        }

        static TokenType NFA_LS_QUERY_89(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'Y')||(ch== 'y')) {
                nextStates.set(75);
            }
            return null;
        }

        static TokenType NFA_LS_QUERY_90(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'E')||(ch== 'e')) {
                nextStates.set(4);
            }
            return null;
        }

        static TokenType NFA_LS_QUERY_91(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'U')||(ch== 'u')) {
                nextStates.set(45);
            }
            return null;
        }

        static TokenType NFA_LS_QUERY_92(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'R')||(ch== 'r')) {
                nextStates.set(13);
            }
            return null;
        }

        static TokenType NFA_LS_QUERY_93(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'X')||(ch== 'x')) {
                nextStates.set(50);
            }
            return null;
        }

        static TokenType NFA_LS_QUERY_94(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch== '=') {
                if (validTypes.contains(T_O_SELECT)) return T_O_SELECT;
            }
            return null;
        }

        static TokenType NFA_LS_QUERY_95(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'T')||(ch== 't')) {
                nextStates.set(66);
            }
            return null;
        }

        static TokenType NFA_LS_QUERY_96(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch== ' ') {
                if (validTypes.contains(_TOKEN_1)) return _TOKEN_1;
            }
            return null;
        }

        static TokenType NFA_LS_QUERY_97(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch== '\t') {
                if (validTypes.contains(_TOKEN_4)) return _TOKEN_4;
            }
            return null;
        }

        static TokenType NFA_LS_QUERY_98(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'F')||(ch== 'f')) {
                nextStates.set(25);
            }
            return null;
        }

        static TokenType NFA_LS_QUERY_99(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'R')||(ch== 'r')) {
                nextStates.set(10);
            }
            return null;
        }

        static private void NFA_FUNCTIONS_init() {
            NfaFunction[] functions= new NfaFunction[100];
            functions[0]= LS_QUERY::NFA_COMPOSITE_LS_QUERY_0;
            functions[1]= LS_QUERY::NFA_COMPOSITE_LS_QUERY_1;
            functions[2]= LS_QUERY::NFA_LS_QUERY_2;
            functions[3]= LS_QUERY::NFA_LS_QUERY_3;
            functions[4]= LS_QUERY::NFA_LS_QUERY_4;
            functions[5]= LS_QUERY::NFA_LS_QUERY_5;
            functions[6]= LS_QUERY::NFA_LS_QUERY_6;
            functions[7]= LS_QUERY::NFA_LS_QUERY_7;
            functions[8]= LS_QUERY::NFA_LS_QUERY_8;
            functions[9]= LS_QUERY::NFA_LS_QUERY_9;
            functions[10]= LS_QUERY::NFA_LS_QUERY_10;
            functions[11]= LS_QUERY::NFA_LS_QUERY_11;
            functions[12]= LS_QUERY::NFA_LS_QUERY_12;
            functions[13]= LS_QUERY::NFA_LS_QUERY_13;
            functions[14]= LS_QUERY::NFA_LS_QUERY_14;
            functions[15]= LS_QUERY::NFA_LS_QUERY_15;
            functions[16]= LS_QUERY::NFA_LS_QUERY_16;
            functions[17]= LS_QUERY::NFA_LS_QUERY_17;
            functions[18]= LS_QUERY::NFA_LS_QUERY_18;
            functions[19]= LS_QUERY::NFA_LS_QUERY_19;
            functions[20]= LS_QUERY::NFA_LS_QUERY_20;
            functions[21]= LS_QUERY::NFA_LS_QUERY_21;
            functions[22]= LS_QUERY::NFA_LS_QUERY_22;
            functions[23]= LS_QUERY::NFA_LS_QUERY_23;
            functions[24]= LS_QUERY::NFA_LS_QUERY_24;
            functions[25]= LS_QUERY::NFA_LS_QUERY_25;
            functions[26]= LS_QUERY::NFA_LS_QUERY_26;
            functions[27]= LS_QUERY::NFA_LS_QUERY_27;
            functions[28]= LS_QUERY::NFA_LS_QUERY_28;
            functions[29]= LS_QUERY::NFA_LS_QUERY_29;
            functions[30]= LS_QUERY::NFA_LS_QUERY_30;
            functions[31]= LS_QUERY::NFA_LS_QUERY_31;
            functions[32]= LS_QUERY::NFA_LS_QUERY_32;
            functions[33]= LS_QUERY::NFA_LS_QUERY_33;
            functions[34]= LS_QUERY::NFA_LS_QUERY_34;
            functions[35]= LS_QUERY::NFA_LS_QUERY_35;
            functions[36]= LS_QUERY::NFA_LS_QUERY_36;
            functions[37]= LS_QUERY::NFA_LS_QUERY_37;
            functions[38]= LS_QUERY::NFA_LS_QUERY_38;
            functions[39]= LS_QUERY::NFA_LS_QUERY_39;
            functions[40]= LS_QUERY::NFA_LS_QUERY_40;
            functions[41]= LS_QUERY::NFA_LS_QUERY_41;
            functions[42]= LS_QUERY::NFA_LS_QUERY_42;
            functions[43]= LS_QUERY::NFA_LS_QUERY_43;
            functions[44]= LS_QUERY::NFA_LS_QUERY_44;
            functions[45]= LS_QUERY::NFA_LS_QUERY_45;
            functions[46]= LS_QUERY::NFA_LS_QUERY_46;
            functions[47]= LS_QUERY::NFA_LS_QUERY_47;
            functions[48]= LS_QUERY::NFA_LS_QUERY_48;
            functions[49]= LS_QUERY::NFA_LS_QUERY_49;
            functions[50]= LS_QUERY::NFA_LS_QUERY_50;
            functions[51]= LS_QUERY::NFA_LS_QUERY_51;
            functions[52]= LS_QUERY::NFA_LS_QUERY_52;
            functions[53]= LS_QUERY::NFA_LS_QUERY_53;
            functions[54]= LS_QUERY::NFA_LS_QUERY_54;
            functions[55]= LS_QUERY::NFA_LS_QUERY_55;
            functions[56]= LS_QUERY::NFA_LS_QUERY_56;
            functions[57]= LS_QUERY::NFA_LS_QUERY_57;
            functions[58]= LS_QUERY::NFA_LS_QUERY_58;
            functions[59]= LS_QUERY::NFA_LS_QUERY_59;
            functions[60]= LS_QUERY::NFA_LS_QUERY_60;
            functions[61]= LS_QUERY::NFA_LS_QUERY_61;
            functions[62]= LS_QUERY::NFA_LS_QUERY_62;
            functions[63]= LS_QUERY::NFA_LS_QUERY_63;
            functions[64]= LS_QUERY::NFA_LS_QUERY_64;
            functions[65]= LS_QUERY::NFA_LS_QUERY_65;
            functions[66]= LS_QUERY::NFA_LS_QUERY_66;
            functions[67]= LS_QUERY::NFA_LS_QUERY_67;
            functions[68]= LS_QUERY::NFA_LS_QUERY_68;
            functions[69]= LS_QUERY::NFA_LS_QUERY_69;
            functions[70]= LS_QUERY::NFA_LS_QUERY_70;
            functions[71]= LS_QUERY::NFA_LS_QUERY_71;
            functions[72]= LS_QUERY::NFA_LS_QUERY_72;
            functions[73]= LS_QUERY::NFA_LS_QUERY_73;
            functions[74]= LS_QUERY::NFA_LS_QUERY_74;
            functions[75]= LS_QUERY::NFA_LS_QUERY_75;
            functions[76]= LS_QUERY::NFA_LS_QUERY_76;
            functions[77]= LS_QUERY::NFA_LS_QUERY_77;
            functions[78]= LS_QUERY::NFA_LS_QUERY_78;
            functions[79]= LS_QUERY::NFA_LS_QUERY_79;
            functions[80]= LS_QUERY::NFA_LS_QUERY_80;
            functions[81]= LS_QUERY::NFA_LS_QUERY_81;
            functions[82]= LS_QUERY::NFA_LS_QUERY_82;
            functions[83]= LS_QUERY::NFA_LS_QUERY_83;
            functions[84]= LS_QUERY::NFA_LS_QUERY_84;
            functions[85]= LS_QUERY::NFA_LS_QUERY_85;
            functions[86]= LS_QUERY::NFA_LS_QUERY_86;
            functions[87]= LS_QUERY::NFA_LS_QUERY_87;
            functions[88]= LS_QUERY::NFA_LS_QUERY_88;
            functions[89]= LS_QUERY::NFA_LS_QUERY_89;
            functions[90]= LS_QUERY::NFA_LS_QUERY_90;
            functions[91]= LS_QUERY::NFA_LS_QUERY_91;
            functions[92]= LS_QUERY::NFA_LS_QUERY_92;
            functions[93]= LS_QUERY::NFA_LS_QUERY_93;
            functions[94]= LS_QUERY::NFA_LS_QUERY_94;
            functions[95]= LS_QUERY::NFA_LS_QUERY_95;
            functions[96]= LS_QUERY::NFA_LS_QUERY_96;
            functions[97]= LS_QUERY::NFA_LS_QUERY_97;
            functions[98]= LS_QUERY::NFA_LS_QUERY_98;
            functions[99]= LS_QUERY::NFA_LS_QUERY_99;
            functionTableMap.put(LexicalState.LS_QUERY, functions);
        }

    }
    /**
  * Holder class for NFA code related to LS_SUBQUERY lexical state
  */
    private static class LS_SUBQUERY {
        static TokenType NFA_COMPOSITE_LS_SUBQUERY_0(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            TokenType type= null;
            if (ch== '$') {
                nextStates.set(32);
                nextStates.set(53);
                nextStates.set(37);
                nextStates.set(33);
                nextStates.set(2);
                nextStates.set(44);
                nextStates.set(39);
            }
            else if (ch== ';') {
                if (validTypes.contains(T_SUBQUERY_OPTIONS_SEPARATOR)) type= T_SUBQUERY_OPTIONS_SEPARATOR;
            }
            else if (ch== '\t') {
                if (validTypes.contains(_TOKEN_4)) type= _TOKEN_4;
            }
            else if (ch== '\r') {
                if (validTypes.contains(_TOKEN_3)) type= _TOKEN_3;
            }
            else if (ch== '\n') {
                if (validTypes.contains(_TOKEN_2)) type= _TOKEN_2;
            }
            else if (ch== ' ') {
                if (validTypes.contains(_TOKEN_1)) type= _TOKEN_1;
            }
            return type;
        }

        static TokenType NFA_LS_SUBQUERY_1(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'T')||(ch== 't')) {
                nextStates.set(25);
            }
            return null;
        }

        static TokenType NFA_LS_SUBQUERY_2(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'T')||(ch== 't')) {
                nextStates.set(19);
            }
            return null;
        }

        static TokenType NFA_LS_SUBQUERY_3(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'R')||(ch== 'r')) {
                nextStates.set(24);
            }
            return null;
        }

        static TokenType NFA_LS_SUBQUERY_4(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch== '=') {
                if (validTypes.contains(T_O_SKIP)) return T_O_SKIP;
            }
            return null;
        }

        static TokenType NFA_LS_SUBQUERY_5(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'E')||(ch== 'e')) {
                nextStates.set(50);
            }
            return null;
        }

        static TokenType NFA_LS_SUBQUERY_6(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'R')||(ch== 'r')) {
                nextStates.set(55);
            }
            return null;
        }

        static TokenType NFA_LS_SUBQUERY_7(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch== '\n') {
                if (validTypes.contains(_TOKEN_2)) return _TOKEN_2;
            }
            return null;
        }

        static TokenType NFA_LS_SUBQUERY_8(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'A')||(ch== 'a')) {
                nextStates.set(27);
            }
            return null;
        }

        static TokenType NFA_LS_SUBQUERY_9(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'E')||(ch== 'e')) {
                nextStates.set(45);
            }
            return null;
        }

        static TokenType NFA_LS_SUBQUERY_10(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'Y')||(ch== 'y')) {
                nextStates.set(29);
            }
            return null;
        }

        static TokenType NFA_LS_SUBQUERY_11(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'U')||(ch== 'u')) {
                nextStates.set(17);
            }
            return null;
        }

        static TokenType NFA_LS_SUBQUERY_12(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch== '$') {
                nextStates.set(33);
            }
            return null;
        }

        static TokenType NFA_LS_SUBQUERY_13(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'P')||(ch== 'p')) {
                nextStates.set(4);
            }
            return null;
        }

        static TokenType NFA_LS_SUBQUERY_14(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'E')||(ch== 'e')) {
                nextStates.set(3);
            }
            return null;
        }

        static TokenType NFA_LS_SUBQUERY_15(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'D')||(ch== 'd')) {
                nextStates.set(48);
            }
            return null;
        }

        static TokenType NFA_LS_SUBQUERY_16(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch== '\t') {
                if (validTypes.contains(_TOKEN_4)) return _TOKEN_4;
            }
            return null;
        }

        static TokenType NFA_LS_SUBQUERY_17(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'N')||(ch== 'n')) {
                nextStates.set(1);
            }
            return null;
        }

        static TokenType NFA_LS_SUBQUERY_18(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch== '$') {
                nextStates.set(2);
            }
            return null;
        }

        static TokenType NFA_LS_SUBQUERY_19(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'O')||(ch== 'o')) {
                nextStates.set(21);
            }
            return null;
        }

        static TokenType NFA_LS_SUBQUERY_20(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch== '\r') {
                if (validTypes.contains(_TOKEN_3)) return _TOKEN_3;
            }
            return null;
        }

        static TokenType NFA_LS_SUBQUERY_21(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'P')||(ch== 'p')) {
                nextStates.set(51);
            }
            return null;
        }

        static TokenType NFA_LS_SUBQUERY_22(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'B')||(ch== 'b')) {
                nextStates.set(10);
            }
            return null;
        }

        static TokenType NFA_LS_SUBQUERY_23(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'L')||(ch== 'l')) {
                nextStates.set(43);
            }
            return null;
        }

        static TokenType NFA_LS_SUBQUERY_24(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch== '=') {
                if (validTypes.contains(T_O_FILTER)) return T_O_FILTER;
            }
            return null;
        }

        static TokenType NFA_LS_SUBQUERY_25(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch== '=') {
                if (validTypes.contains(T_O_COUNT)) return T_O_COUNT;
            }
            return null;
        }

        static TokenType NFA_LS_SUBQUERY_26(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'X')||(ch== 'x')) {
                nextStates.set(31);
            }
            return null;
        }

        static TokenType NFA_LS_SUBQUERY_27(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'N')||(ch== 'n')) {
                nextStates.set(15);
            }
            return null;
        }

        static TokenType NFA_LS_SUBQUERY_28(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'C')||(ch== 'c')) {
                nextStates.set(56);
            }
            return null;
        }

        static TokenType NFA_LS_SUBQUERY_29(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch== '=') {
                if (validTypes.contains(T_O_ORDERBY)) return T_O_ORDERBY;
            }
            return null;
        }

        static TokenType NFA_LS_SUBQUERY_30(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch== '$') {
                nextStates.set(32);
            }
            return null;
        }

        static TokenType NFA_LS_SUBQUERY_31(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'P')||(ch== 'p')) {
                nextStates.set(8);
            }
            return null;
        }

        static TokenType NFA_LS_SUBQUERY_32(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'S')||(ch== 's')) {
                nextStates.set(5);
            }
            return null;
        }

        static TokenType NFA_LS_SUBQUERY_33(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'O')||(ch== 'o')) {
                nextStates.set(6);
            }
            return null;
        }

        static TokenType NFA_LS_SUBQUERY_34(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'I')||(ch== 'i')) {
                nextStates.set(23);
            }
            return null;
        }

        static TokenType NFA_LS_SUBQUERY_35(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch== '$') {
                nextStates.set(37);
            }
            return null;
        }

        static TokenType NFA_LS_SUBQUERY_36(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch== '=') {
                if (validTypes.contains(T_O_SELECT)) return T_O_SELECT;
            }
            return null;
        }

        static TokenType NFA_LS_SUBQUERY_37(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'S')||(ch== 's')) {
                nextStates.set(41);
            }
            return null;
        }

        static TokenType NFA_LS_SUBQUERY_38(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch== '$') {
                nextStates.set(39);
            }
            return null;
        }

        static TokenType NFA_LS_SUBQUERY_39(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'E')||(ch== 'e')) {
                nextStates.set(26);
            }
            return null;
        }

        static TokenType NFA_LS_SUBQUERY_40(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'E')||(ch== 'e')) {
                nextStates.set(28);
            }
            return null;
        }

        static TokenType NFA_LS_SUBQUERY_41(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'K')||(ch== 'k')) {
                nextStates.set(42);
            }
            return null;
        }

        static TokenType NFA_LS_SUBQUERY_42(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'I')||(ch== 'i')) {
                nextStates.set(13);
            }
            return null;
        }

        static TokenType NFA_LS_SUBQUERY_43(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'T')||(ch== 't')) {
                nextStates.set(14);
            }
            return null;
        }

        static TokenType NFA_LS_SUBQUERY_44(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'F')||(ch== 'f')) {
                nextStates.set(34);
            }
            return null;
        }

        static TokenType NFA_LS_SUBQUERY_45(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'R')||(ch== 'r')) {
                nextStates.set(22);
            }
            return null;
        }

        static TokenType NFA_LS_SUBQUERY_46(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch== '$') {
                nextStates.set(53);
            }
            return null;
        }

        static TokenType NFA_LS_SUBQUERY_47(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch== ';') {
                if (validTypes.contains(T_SUBQUERY_OPTIONS_SEPARATOR)) return T_SUBQUERY_OPTIONS_SEPARATOR;
            }
            return null;
        }

        static TokenType NFA_LS_SUBQUERY_48(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch== '=') {
                if (validTypes.contains(T_O_EXPAND)) return T_O_EXPAND;
            }
            return null;
        }

        static TokenType NFA_LS_SUBQUERY_49(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch== ' ') {
                if (validTypes.contains(_TOKEN_1)) return _TOKEN_1;
            }
            return null;
        }

        static TokenType NFA_LS_SUBQUERY_50(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'L')||(ch== 'l')) {
                nextStates.set(40);
            }
            return null;
        }

        static TokenType NFA_LS_SUBQUERY_51(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch== '=') {
                if (validTypes.contains(T_O_TOP)) return T_O_TOP;
            }
            return null;
        }

        static TokenType NFA_LS_SUBQUERY_52(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'O')||(ch== 'o')) {
                nextStates.set(11);
            }
            return null;
        }

        static TokenType NFA_LS_SUBQUERY_53(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'C')||(ch== 'c')) {
                nextStates.set(52);
            }
            return null;
        }

        static TokenType NFA_LS_SUBQUERY_54(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch== '$') {
                nextStates.set(44);
            }
            return null;
        }

        static TokenType NFA_LS_SUBQUERY_55(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'D')||(ch== 'd')) {
                nextStates.set(9);
            }
            return null;
        }

        static TokenType NFA_LS_SUBQUERY_56(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'T')||(ch== 't')) {
                nextStates.set(36);
            }
            return null;
        }

        static private void NFA_FUNCTIONS_init() {
            NfaFunction[] functions= new NfaFunction[57];
            functions[0]= LS_SUBQUERY::NFA_COMPOSITE_LS_SUBQUERY_0;
            functions[1]= LS_SUBQUERY::NFA_LS_SUBQUERY_1;
            functions[2]= LS_SUBQUERY::NFA_LS_SUBQUERY_2;
            functions[3]= LS_SUBQUERY::NFA_LS_SUBQUERY_3;
            functions[4]= LS_SUBQUERY::NFA_LS_SUBQUERY_4;
            functions[5]= LS_SUBQUERY::NFA_LS_SUBQUERY_5;
            functions[6]= LS_SUBQUERY::NFA_LS_SUBQUERY_6;
            functions[7]= LS_SUBQUERY::NFA_LS_SUBQUERY_7;
            functions[8]= LS_SUBQUERY::NFA_LS_SUBQUERY_8;
            functions[9]= LS_SUBQUERY::NFA_LS_SUBQUERY_9;
            functions[10]= LS_SUBQUERY::NFA_LS_SUBQUERY_10;
            functions[11]= LS_SUBQUERY::NFA_LS_SUBQUERY_11;
            functions[12]= LS_SUBQUERY::NFA_LS_SUBQUERY_12;
            functions[13]= LS_SUBQUERY::NFA_LS_SUBQUERY_13;
            functions[14]= LS_SUBQUERY::NFA_LS_SUBQUERY_14;
            functions[15]= LS_SUBQUERY::NFA_LS_SUBQUERY_15;
            functions[16]= LS_SUBQUERY::NFA_LS_SUBQUERY_16;
            functions[17]= LS_SUBQUERY::NFA_LS_SUBQUERY_17;
            functions[18]= LS_SUBQUERY::NFA_LS_SUBQUERY_18;
            functions[19]= LS_SUBQUERY::NFA_LS_SUBQUERY_19;
            functions[20]= LS_SUBQUERY::NFA_LS_SUBQUERY_20;
            functions[21]= LS_SUBQUERY::NFA_LS_SUBQUERY_21;
            functions[22]= LS_SUBQUERY::NFA_LS_SUBQUERY_22;
            functions[23]= LS_SUBQUERY::NFA_LS_SUBQUERY_23;
            functions[24]= LS_SUBQUERY::NFA_LS_SUBQUERY_24;
            functions[25]= LS_SUBQUERY::NFA_LS_SUBQUERY_25;
            functions[26]= LS_SUBQUERY::NFA_LS_SUBQUERY_26;
            functions[27]= LS_SUBQUERY::NFA_LS_SUBQUERY_27;
            functions[28]= LS_SUBQUERY::NFA_LS_SUBQUERY_28;
            functions[29]= LS_SUBQUERY::NFA_LS_SUBQUERY_29;
            functions[30]= LS_SUBQUERY::NFA_LS_SUBQUERY_30;
            functions[31]= LS_SUBQUERY::NFA_LS_SUBQUERY_31;
            functions[32]= LS_SUBQUERY::NFA_LS_SUBQUERY_32;
            functions[33]= LS_SUBQUERY::NFA_LS_SUBQUERY_33;
            functions[34]= LS_SUBQUERY::NFA_LS_SUBQUERY_34;
            functions[35]= LS_SUBQUERY::NFA_LS_SUBQUERY_35;
            functions[36]= LS_SUBQUERY::NFA_LS_SUBQUERY_36;
            functions[37]= LS_SUBQUERY::NFA_LS_SUBQUERY_37;
            functions[38]= LS_SUBQUERY::NFA_LS_SUBQUERY_38;
            functions[39]= LS_SUBQUERY::NFA_LS_SUBQUERY_39;
            functions[40]= LS_SUBQUERY::NFA_LS_SUBQUERY_40;
            functions[41]= LS_SUBQUERY::NFA_LS_SUBQUERY_41;
            functions[42]= LS_SUBQUERY::NFA_LS_SUBQUERY_42;
            functions[43]= LS_SUBQUERY::NFA_LS_SUBQUERY_43;
            functions[44]= LS_SUBQUERY::NFA_LS_SUBQUERY_44;
            functions[45]= LS_SUBQUERY::NFA_LS_SUBQUERY_45;
            functions[46]= LS_SUBQUERY::NFA_LS_SUBQUERY_46;
            functions[47]= LS_SUBQUERY::NFA_LS_SUBQUERY_47;
            functions[48]= LS_SUBQUERY::NFA_LS_SUBQUERY_48;
            functions[49]= LS_SUBQUERY::NFA_LS_SUBQUERY_49;
            functions[50]= LS_SUBQUERY::NFA_LS_SUBQUERY_50;
            functions[51]= LS_SUBQUERY::NFA_LS_SUBQUERY_51;
            functions[52]= LS_SUBQUERY::NFA_LS_SUBQUERY_52;
            functions[53]= LS_SUBQUERY::NFA_LS_SUBQUERY_53;
            functions[54]= LS_SUBQUERY::NFA_LS_SUBQUERY_54;
            functions[55]= LS_SUBQUERY::NFA_LS_SUBQUERY_55;
            functions[56]= LS_SUBQUERY::NFA_LS_SUBQUERY_56;
            functionTableMap.put(LexicalState.LS_SUBQUERY, functions);
        }

    }
    /**
  * Holder class for NFA code related to LS_FILTER lexical state
  */
    private static class LS_FILTER {
        static TokenType NFA_COMPOSITE_LS_FILTER_0(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            TokenType type= null;
            if ((ch== 'A')||(ch== 'a')) {
                nextStates.set(195);
                nextStates.set(88);
                nextStates.set(317);
            }
            else if ((ch== 'B')||(ch== 'b')) {
                nextStates.set(68);
            }
            else if ((ch== 'C')||(ch== 'c')) {
                nextStates.set(439);
                nextStates.set(54);
            }
            else if ((ch== 'D')||(ch== 'd')) {
                nextStates.set(21);
                nextStates.set(110);
                nextStates.set(339);
                nextStates.set(47);
            }
            else if ((ch== 'E')||(ch== 'e')) {
                nextStates.set(416);
                nextStates.set(38);
            }
            else if ((ch== 'F')||(ch== 'f')) {
                nextStates.set(247);
                nextStates.set(222);
                nextStates.set(152);
            }
            else if ((ch== 'G')||(ch== 'g')) {
                nextStates.set(217);
                nextStates.set(70);
                nextStates.set(220);
                nextStates.set(276);
                nextStates.set(248);
            }
            else if ((ch== 'H')||(ch== 'h')) {
                nextStates.set(372);
            }
            else if ((ch== 'I')||(ch== 'i')) {
                nextStates.set(169);
            }
            else if ((ch== 'L')||(ch== 'l')) {
                nextStates.set(221);
                nextStates.set(328);
                nextStates.set(57);
            }
            else if ((ch== 'M')||(ch== 'm')) {
                nextStates.set(386);
                nextStates.set(307);
                nextStates.set(83);
                nextStates.set(77);
                nextStates.set(111);
                nextStates.set(286);
                nextStates.set(63);
            }
            else if ((ch== 'N')||(ch== 'n')) {
                nextStates.set(106);
                nextStates.set(156);
                nextStates.set(398);
            }
            else if ((ch== 'O')||(ch== 'o')) {
                nextStates.set(177);
                nextStates.set(94);
            }
            else if ((ch== 'R')||(ch== 'r')) {
                nextStates.set(25);
            }
            else if ((ch== 'S')||(ch== 's')) {
                nextStates.set(359);
                nextStates.set(209);
                nextStates.set(114);
                nextStates.set(425);
                nextStates.set(230);
                nextStates.set(229);
                nextStates.set(211);
                nextStates.set(134);
                nextStates.set(107);
                nextStates.set(289);
                nextStates.set(271);
                nextStates.set(422);
                nextStates.set(338);
                nextStates.set(117);
                nextStates.set(254);
            }
            else if ((ch== 'T')||(ch== 't')) {
                nextStates.set(232);
                nextStates.set(74);
                nextStates.set(366);
                nextStates.set(260);
                nextStates.set(417);
            }
            else if ((ch== 'Y')||(ch== 'y')) {
                nextStates.set(162);
            }
            else if (ch== ')') {
                if (validTypes.contains(T_RB)) type= T_RB;
            }
            else if (ch== '(') {
                if (validTypes.contains(T_LB)) type= T_LB;
            }
            else if (ch== ',') {
                if (validTypes.contains(T_VALUE_SEPARATOR)) type= T_VALUE_SEPARATOR;
            }
            else if (ch== '\t') {
                if (validTypes.contains(_TOKEN_4)) type= _TOKEN_4;
            }
            else if (ch== '\r') {
                if (validTypes.contains(_TOKEN_3)) type= _TOKEN_3;
            }
            else if (ch== '\n') {
                if (validTypes.contains(_TOKEN_2)) type= _TOKEN_2;
            }
            else if (ch== ' ') {
                if (validTypes.contains(_TOKEN_1)) type= _TOKEN_1;
            }
            return type;
        }

        static TokenType NFA_LS_FILTER_1(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'A')||(ch== 'a')) {
                nextStates.set(316);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_2(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'T')||(ch== 't')) {
                nextStates.set(437);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_3(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'R')||(ch== 'r')) {
                nextStates.set(367);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_4(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'U')||(ch== 'u')) {
                nextStates.set(409);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_5(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'T')||(ch== 't')) {
                nextStates.set(85);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_6(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'I')||(ch== 'i')) {
                nextStates.set(39);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_7(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'E')||(ch== 'e')) {
                nextStates.set(196);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_8(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'S')||(ch== 's')) {
                nextStates.set(359);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_9(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'S')||(ch== 's')) {
                nextStates.set(114);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_10(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'I')||(ch== 'i')) {
                nextStates.set(121);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_11(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'A')||(ch== 'a')) {
                nextStates.set(16);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_12(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'H')||(ch== 'h')) {
                nextStates.set(245);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_13(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'T')||(ch== 't')) {
                nextStates.set(389);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_14(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'L')||(ch== 'l')) {
                nextStates.set(95);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_15(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'I')||(ch== 'i')) {
                nextStates.set(59);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_16(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'R')||(ch== 'r')) {
                nextStates.set(80);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_17(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch== '_') {
                nextStates.set(384);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_18(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'X')||(ch== 'x')) {
                nextStates.set(321);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_19(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch== '\r') {
                if (validTypes.contains(_TOKEN_3)) return _TOKEN_3;
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_20(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'E')||(ch== 'e')) {
                nextStates.set(382);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_21(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'A')||(ch== 'a')) {
                nextStates.set(100);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_22(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'P')||(ch== 'p')) {
                nextStates.set(170);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_23(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'L')||(ch== 'l')) {
                nextStates.set(264);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_24(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'O')||(ch== 'o')) {
                nextStates.set(325);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_25(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'O')||(ch== 'o')) {
                nextStates.set(84);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_26(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'T')||(ch== 't')) {
                nextStates.set(12);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_27(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'T')||(ch== 't')) {
                nextStates.set(74);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_28(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'T')||(ch== 't')) {
                nextStates.set(293);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_29(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'R')||(ch== 'r')) {
                nextStates.set(294);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_30(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'O')||(ch== 'o')) {
                nextStates.set(201);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_31(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'S')||(ch== 's')) {
                nextStates.set(107);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_32(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'W')||(ch== 'w')) {
                nextStates.set(10);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_33(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'P')||(ch== 'p')) {
                nextStates.set(45);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_34(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'G')||(ch== 'g')) {
                nextStates.set(28);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_35(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'T')||(ch== 't')) {
                nextStates.set(133);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_36(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'A')||(ch== 'a')) {
                nextStates.set(5);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_37(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'T')||(ch== 't')) {
                nextStates.set(139);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_38(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'Q')||(ch== 'q')) {
                if (validTypes.contains(T_QO_EQ)) return T_QO_EQ;
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_39(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'L')||(ch== 'l')) {
                nextStates.set(15);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_40(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'A')||(ch== 'a')) {
                nextStates.set(288);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_41(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'S')||(ch== 's')) {
                nextStates.set(422);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_42(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'N')||(ch== 'n')) {
                nextStates.set(34);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_43(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'S')||(ch== 's')) {
                nextStates.set(310);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_44(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'A')||(ch== 'a')) {
                nextStates.set(23);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_45(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'S')||(ch== 's')) {
                nextStates.set(432);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_46(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'H')||(ch== 'h')) {
                nextStates.set(376);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_47(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'I')||(ch== 'i')) {
                nextStates.set(91);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_48(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'E')||(ch== 'e')) {
                nextStates.set(237);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_49(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch== '(') {
                if (validTypes.contains(T_QF_SUBSTRINGOF)) return T_QF_SUBSTRINGOF;
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_50(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch== '(') {
                if (validTypes.contains(T_QF_NOW)) return T_QF_NOW;
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_51(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'S')||(ch== 's')) {
                nextStates.set(373);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_52(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'U')||(ch== 'u')) {
                nextStates.set(178);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_53(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch== '(') {
                if (validTypes.contains(T_QF_MONTH)) return T_QF_MONTH;
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_54(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'E')||(ch== 'e')) {
                nextStates.set(6);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_55(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'S')||(ch== 's')) {
                nextStates.set(298);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_56(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'G')||(ch== 'g')) {
                nextStates.set(217);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_57(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'E')||(ch== 'e')) {
                nextStates.set(42);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_58(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'E')||(ch== 'e')) {
                nextStates.set(137);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_59(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'N')||(ch== 'n')) {
                nextStates.set(149);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_60(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'N')||(ch== 'n')) {
                nextStates.set(219);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_61(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'G')||(ch== 'g')) {
                nextStates.set(346);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_62(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'R')||(ch== 'r')) {
                nextStates.set(406);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_63(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'A')||(ch== 'a')) {
                nextStates.set(18);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_64(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'L')||(ch== 'l')) {
                if (validTypes.contains(T_QO_MUL)) return T_QO_MUL;
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_65(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'S')||(ch== 's')) {
                nextStates.set(313);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_66(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'P')||(ch== 'p')) {
                nextStates.set(20);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_67(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch== '(') {
                if (validTypes.contains(T_QF_TOUPPER)) return T_QF_TOUPPER;
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_68(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'E')||(ch== 'e')) {
                nextStates.set(86);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_69(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch== '(') {
                if (validTypes.contains(T_QF_BEFORE)) return T_QF_BEFORE;
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_70(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'E')||(ch== 'e')) {
                if (validTypes.contains(T_QO_GE)) return T_QO_GE;
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_71(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'R')||(ch== 'r')) {
                nextStates.set(159);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_72(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'T')||(ch== 't')) {
                nextStates.set(141);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_73(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch== '(') {
                if (validTypes.contains(T_QF_ST_EQUALS)) return T_QF_ST_EQUALS;
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_74(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'O')||(ch== 'o')) {
                nextStates.set(131);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_75(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'T')||(ch== 't')) {
                nextStates.set(396);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_76(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'B')||(ch== 'b')) {
                if (validTypes.contains(T_QO_SUB)) return T_QO_SUB;
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_77(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'O')||(ch== 'o')) {
                nextStates.set(96);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_78(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'N')||(ch== 'n')) {
                nextStates.set(61);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_79(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'S')||(ch== 's')) {
                nextStates.set(134);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_80(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'T')||(ch== 't')) {
                nextStates.set(240);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_81(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch== '(') {
                if (validTypes.contains(T_QF_MINUTE)) return T_QF_MINUTE;
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_82(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'T')||(ch== 't')) {
                nextStates.set(7);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_83(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'U')||(ch== 'u')) {
                nextStates.set(64);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_84(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'U')||(ch== 'u')) {
                nextStates.set(153);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_85(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'E')||(ch== 'e')) {
                nextStates.set(330);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_86(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'F')||(ch== 'f')) {
                nextStates.set(443);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_87(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'T')||(ch== 't')) {
                nextStates.set(30);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_88(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'N')||(ch== 'n')) {
                nextStates.set(335);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_89(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'E')||(ch== 'e')) {
                nextStates.set(38);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_90(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'I')||(ch== 'i')) {
                nextStates.set(383);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_91(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'V')||(ch== 'v')) {
                if (validTypes.contains(T_QO_DIV)) return T_QO_DIV;
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_92(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'V')||(ch== 'v')) {
                nextStates.set(108);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_93(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'F')||(ch== 'f')) {
                nextStates.set(247);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_94(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'V')||(ch== 'v')) {
                nextStates.set(186);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_95(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'A')||(ch== 'a')) {
                nextStates.set(189);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_96(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'D')||(ch== 'd')) {
                if (validTypes.contains(T_QO_MOD)) return T_QO_MOD;
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_97(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'H')||(ch== 'h')) {
                nextStates.set(53);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_98(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'N')||(ch== 'n')) {
                nextStates.set(1);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_99(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'A')||(ch== 'a')) {
                nextStates.set(364);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_100(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'Y')||(ch== 'y')) {
                nextStates.set(395);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_101(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'A')||(ch== 'a')) {
                nextStates.set(214);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_102(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'M')||(ch== 'm')) {
                nextStates.set(380);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_103(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch== '(') {
                if (validTypes.contains(T_QF_SUBSTRING)) return T_QF_SUBSTRING;
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_104(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'E')||(ch== 'e')) {
                nextStates.set(228);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_105(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'N')||(ch== 'n')) {
                nextStates.set(4);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_106(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'O')||(ch== 'o')) {
                nextStates.set(428);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_107(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'T')||(ch== 't')) {
                nextStates.set(407);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_108(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'E')||(ch== 'e')) {
                nextStates.set(333);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_109(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'O')||(ch== 'o')) {
                nextStates.set(181);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_110(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'U')||(ch== 'u')) {
                nextStates.set(29);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_111(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'I')||(ch== 'i')) {
                nextStates.set(105);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_112(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'T')||(ch== 't')) {
                nextStates.set(99);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_113(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'I')||(ch== 'i')) {
                nextStates.set(169);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_114(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'U')||(ch== 'u')) {
                nextStates.set(368);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_115(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'E')||(ch== 'e')) {
                nextStates.set(267);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_116(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'S')||(ch== 's')) {
                nextStates.set(379);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_117(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'U')||(ch== 'u')) {
                nextStates.set(76);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_118(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'I')||(ch== 'i')) {
                nextStates.set(423);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_119(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch== '(') {
                if (validTypes.contains(T_QF_TOTALOFFSETMINUTES)) return T_QF_TOTALOFFSETMINUTES;
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_120(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch== '(') {
                if (validTypes.contains(T_QF_STARTSWITH)) return T_QF_STARTSWITH;
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_121(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'T')||(ch== 't')) {
                nextStates.set(46);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_122(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'H')||(ch== 'h')) {
                nextStates.set(192);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_123(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'G')||(ch== 'g')) {
                nextStates.set(70);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_124(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'T')||(ch== 't')) {
                if (validTypes.contains(T_QO_NOT)) return T_QO_NOT;
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_125(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'N')||(ch== 'n')) {
                nextStates.set(357);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_126(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'I')||(ch== 'i')) {
                nextStates.set(102);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_127(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'S')||(ch== 's')) {
                nextStates.set(425);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_128(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'S')||(ch== 's')) {
                nextStates.set(112);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_129(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'A')||(ch== 'a')) {
                nextStates.set(88);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_130(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'S')||(ch== 's')) {
                nextStates.set(211);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_131(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'T')||(ch== 't')) {
                nextStates.set(101);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_132(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'L')||(ch== 'l')) {
                nextStates.set(168);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_133(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'H')||(ch== 'h')) {
                nextStates.set(120);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_134(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'T')||(ch== 't')) {
                nextStates.set(11);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_135(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'S')||(ch== 's')) {
                nextStates.set(387);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_136(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'U')||(ch== 'u')) {
                nextStates.set(44);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_137(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch== '(') {
                if (validTypes.contains(T_QF_TIME)) return T_QF_TIME;
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_138(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'H')||(ch== 'h')) {
                nextStates.set(372);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_139(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'M')||(ch== 'm')) {
                nextStates.set(393);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_140(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'O')||(ch== 'o')) {
                nextStates.set(436);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_141(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'E')||(ch== 'e')) {
                nextStates.set(269);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_142(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'R')||(ch== 'r')) {
                nextStates.set(446);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_143(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'A')||(ch== 'a')) {
                nextStates.set(317);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_144(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'S')||(ch== 's')) {
                nextStates.set(2);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_145(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'L')||(ch== 'l')) {
                nextStates.set(328);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_146(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'T')||(ch== 't')) {
                nextStates.set(366);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_147(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch== '_') {
                nextStates.set(48);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_148(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'H')||(ch== 'h')) {
                nextStates.set(353);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_149(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'G')||(ch== 'g')) {
                nextStates.set(202);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_150(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'T')||(ch== 't')) {
                nextStates.set(320);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_151(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'S')||(ch== 's')) {
                nextStates.set(206);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_152(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'I')||(ch== 'i')) {
                nextStates.set(160);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_153(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'N')||(ch== 'n')) {
                nextStates.set(265);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_154(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'O')||(ch== 'o')) {
                nextStates.set(365);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_155(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch== '(') {
                if (validTypes.contains(T_QF_ST_INTERSECTS)) return T_QF_ST_INTERSECTS;
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_156(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'E')||(ch== 'e')) {
                if (validTypes.contains(T_QO_NE)) return T_QO_NE;
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_157(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'T')||(ch== 't')) {
                nextStates.set(417);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_158(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'N')||(ch== 'n')) {
                nextStates.set(216);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_159(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch== '(') {
                if (validTypes.contains(T_QF_YEAR)) return T_QF_YEAR;
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_160(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'N')||(ch== 'n')) {
                nextStates.set(302);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_161(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'G')||(ch== 'g')) {
                nextStates.set(276);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_162(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'E')||(ch== 'e')) {
                nextStates.set(421);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_163(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'T')||(ch== 't')) {
                nextStates.set(172);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_164(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch== '(') {
                if (validTypes.contains(T_QF_CONCAT)) return T_QF_CONCAT;
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_165(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'D')||(ch== 'd')) {
                nextStates.set(440);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_166(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'F')||(ch== 'f')) {
                nextStates.set(152);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_167(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'U')||(ch== 'u')) {
                nextStates.set(3);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_168(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'E')||(ch== 'e')) {
                nextStates.set(158);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_169(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'N')||(ch== 'n')) {
                nextStates.set(442);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_170(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'S')||(ch== 's')) {
                nextStates.set(252);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_171(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'O')||(ch== 'o')) {
                nextStates.set(243);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_172(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'A')||(ch== 'a')) {
                nextStates.set(445);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_173(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'A')||(ch== 'a')) {
                nextStates.set(33);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_174(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'S')||(ch== 's')) {
                nextStates.set(254);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_175(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'C')||(ch== 'c')) {
                nextStates.set(54);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_176(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'Y')||(ch== 'y')) {
                nextStates.set(162);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_177(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'R')||(ch== 'r')) {
                if (validTypes.contains(T_QO_OR)) return T_QO_OR;
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_178(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'P')||(ch== 'p')) {
                nextStates.set(66);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_179(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'T')||(ch== 't')) {
                nextStates.set(309);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_180(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'N')||(ch== 'n')) {
                nextStates.set(106);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_181(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch== '.') {
                nextStates.set(132);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_182(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'N')||(ch== 'n')) {
                nextStates.set(371);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_183(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'E')||(ch== 'e')) {
                nextStates.set(207);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_184(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'A')||(ch== 'a')) {
                nextStates.set(444);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_185(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'C')||(ch== 'c')) {
                nextStates.set(205);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_186(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'E')||(ch== 'e')) {
                nextStates.set(187);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_187(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'R')||(ch== 'r')) {
                nextStates.set(213);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_188(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'A')||(ch== 'a')) {
                nextStates.set(195);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_189(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'T')||(ch== 't')) {
                nextStates.set(197);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_190(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'C')||(ch== 'c')) {
                nextStates.set(24);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_191(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'S')||(ch== 's')) {
                nextStates.set(401);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_192(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'E')||(ch== 'e')) {
                nextStates.set(43);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_193(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch== '\t') {
                if (validTypes.contains(_TOKEN_4)) return _TOKEN_4;
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_194(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'E')||(ch== 'e')) {
                nextStates.set(81);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_195(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'F')||(ch== 'f')) {
                nextStates.set(236);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_196(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'R')||(ch== 'r')) {
                nextStates.set(65);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_197(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'E')||(ch== 'e')) {
                nextStates.set(291);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_198(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'N')||(ch== 'n')) {
                nextStates.set(391);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_199(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'O')||(ch== 'o')) {
                nextStates.set(257);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_200(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'N')||(ch== 'n')) {
                nextStates.set(226);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_201(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'U')||(ch== 'u')) {
                nextStates.set(185);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_202(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch== '(') {
                if (validTypes.contains(T_QF_CEILING)) return T_QF_CEILING;
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_203(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch== '_') {
                nextStates.set(292);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_204(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch== '(') {
                if (validTypes.contains(T_QF_FLOOR)) return T_QF_FLOOR;
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_205(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'H')||(ch== 'h')) {
                nextStates.set(351);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_206(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'J')||(ch== 'j')) {
                nextStates.set(405);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_207(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch== '(') {
                if (validTypes.contains(T_QF_DATE)) return T_QF_DATE;
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_208(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'A')||(ch== 'a')) {
                nextStates.set(22);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_209(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'T')||(ch== 't')) {
                nextStates.set(17);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_210(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'N')||(ch== 'n')) {
                nextStates.set(156);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_211(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'T')||(ch== 't')) {
                nextStates.set(400);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_212(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'M')||(ch== 'm')) {
                nextStates.set(111);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_213(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'L')||(ch== 'l')) {
                nextStates.set(173);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_214(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'L')||(ch== 'l')) {
                nextStates.set(296);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_215(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'W')||(ch== 'w')) {
                nextStates.set(435);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_216(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'G')||(ch== 'g')) {
                nextStates.set(26);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_217(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'E')||(ch== 'e')) {
                nextStates.set(109);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_218(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'M')||(ch== 'm')) {
                nextStates.set(386);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_219(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'G')||(ch== 'g')) {
                nextStates.set(103);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_220(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'E')||(ch== 'e')) {
                nextStates.set(140);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_221(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'E')||(ch== 'e')) {
                if (validTypes.contains(T_QO_LE)) return T_QO_LE;
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_222(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'L')||(ch== 'l')) {
                nextStates.set(154);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_223(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'R')||(ch== 'r')) {
                nextStates.set(402);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_224(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch== '(') {
                if (validTypes.contains(T_QF_ROUND)) return T_QF_ROUND;
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_225(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'E')||(ch== 'e')) {
                nextStates.set(37);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_226(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'D')||(ch== 'd')) {
                nextStates.set(135);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_227(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'S')||(ch== 's')) {
                nextStates.set(209);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_228(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'X')||(ch== 'x')) {
                nextStates.set(381);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_229(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'T')||(ch== 't')) {
                nextStates.set(360);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_230(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'T')||(ch== 't')) {
                nextStates.set(203);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_231(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch== ' ') {
                if (validTypes.contains(_TOKEN_1)) return _TOKEN_1;
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_232(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'I')||(ch== 'i')) {
                nextStates.set(354);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_233(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'S')||(ch== 's')) {
                nextStates.set(238);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_234(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'M')||(ch== 'm')) {
                nextStates.set(307);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_235(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'L')||(ch== 'l')) {
                nextStates.set(221);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_236(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'T')||(ch== 't')) {
                nextStates.set(244);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_237(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'Q')||(ch== 'q')) {
                nextStates.set(136);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_238(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch== '(') {
                if (validTypes.contains(T_QF_ST_CROSSES)) return T_QF_ST_CROSSES;
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_239(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'S')||(ch== 's')) {
                nextStates.set(230);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_240(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'S')||(ch== 's')) {
                nextStates.set(362);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_241(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'S')||(ch== 's')) {
                nextStates.set(229);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_242(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'T')||(ch== 't')) {
                nextStates.set(148);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_243(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch== '.') {
                nextStates.set(341);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_244(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'E')||(ch== 'e')) {
                nextStates.set(223);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_245(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch== '(') {
                if (validTypes.contains(T_QF_GEO_LENGTH)) return T_QF_GEO_LENGTH;
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_246(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch== '(') {
                if (validTypes.contains(T_QF_ST_TOUCHES)) return T_QF_ST_TOUCHES;
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_247(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'R')||(ch== 'r')) {
                nextStates.set(40);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_248(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'T')||(ch== 't')) {
                if (validTypes.contains(T_QO_GT)) return T_QO_GT;
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_249(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'D')||(ch== 'd')) {
                nextStates.set(110);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_250(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'F')||(ch== 'f')) {
                nextStates.set(323);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_251(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'R')||(ch== 'r')) {
                nextStates.set(345);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_252(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch== '(') {
                if (validTypes.contains(T_QF_ST_OVERLAPS)) return T_QF_ST_OVERLAPS;
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_253(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'N')||(ch== 'n')) {
                nextStates.set(304);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_254(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'T')||(ch== 't')) {
                nextStates.set(312);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_255(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'I')||(ch== 'i')) {
                nextStates.set(198);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_256(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'D')||(ch== 'd')) {
                nextStates.set(281);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_257(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'W')||(ch== 'w')) {
                nextStates.set(377);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_258(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'F')||(ch== 'f')) {
                nextStates.set(250);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_259(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'C')||(ch== 'c')) {
                nextStates.set(184);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_260(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'R')||(ch== 'r')) {
                nextStates.set(90);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_261(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'T')||(ch== 't')) {
                nextStates.set(260);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_262(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'R')||(ch== 'r')) {
                nextStates.set(255);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_263(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'B')||(ch== 'b')) {
                nextStates.set(144);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_264(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'S')||(ch== 's')) {
                nextStates.set(73);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_265(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'D')||(ch== 'd')) {
                nextStates.set(224);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_266(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch== '(') {
                if (validTypes.contains(T_QF_GEO_DISTANCE)) return T_QF_GEO_DISTANCE;
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_267(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'C')||(ch== 'c')) {
                nextStates.set(314);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_268(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'C')||(ch== 'c')) {
                nextStates.set(75);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_269(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'S')||(ch== 's')) {
                nextStates.set(119);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_270(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'C')||(ch== 'c')) {
                nextStates.set(439);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_271(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'E')||(ch== 'e')) {
                nextStates.set(447);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_272(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'M')||(ch== 'm')) {
                nextStates.set(286);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_273(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'F')||(ch== 'f')) {
                nextStates.set(222);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_274(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'O')||(ch== 'o')) {
                nextStates.set(177);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_275(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'S')||(ch== 's')) {
                nextStates.set(115);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_276(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'E')||(ch== 'e')) {
                nextStates.set(171);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_277(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'E')||(ch== 'e')) {
                nextStates.set(14);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_278(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch== ')') {
                if (validTypes.contains(T_RB)) return T_RB;
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_279(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'D')||(ch== 'd')) {
                nextStates.set(339);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_280(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'N')||(ch== 'n')) {
                nextStates.set(398);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_281(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'S')||(ch== 's')) {
                nextStates.set(215);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_282(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'O')||(ch== 'o')) {
                nextStates.set(98);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_283(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'L')||(ch== 'l')) {
                nextStates.set(199);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_284(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'I')||(ch== 'i')) {
                nextStates.set(151);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_285(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'S')||(ch== 's')) {
                nextStates.set(117);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_286(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'I')||(ch== 'i')) {
                nextStates.set(125);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_287(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'R')||(ch== 'r')) {
                nextStates.set(433);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_288(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'C')||(ch== 'c')) {
                nextStates.set(150);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_289(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'T')||(ch== 't')) {
                nextStates.set(147);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_290(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch== '_') {
                nextStates.set(430);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_291(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch== '(') {
                if (validTypes.contains(T_QF_ST_RELATE)) return T_QF_ST_RELATE;
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_292(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'O')||(ch== 'o')) {
                nextStates.set(92);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_293(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'H')||(ch== 'h')) {
                nextStates.set(418);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_294(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'I')||(ch== 'i')) {
                nextStates.set(78);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_295(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'B')||(ch== 'b')) {
                nextStates.set(68);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_296(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'O')||(ch== 'o')) {
                nextStates.set(258);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_297(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'E')||(ch== 'e')) {
                nextStates.set(266);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_298(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'W')||(ch== 'w')) {
                nextStates.set(361);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_299(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'S')||(ch== 's')) {
                nextStates.set(122);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_300(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'S')||(ch== 's')) {
                nextStates.set(155);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_301(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'T')||(ch== 't')) {
                nextStates.set(232);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_302(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'I')||(ch== 'i')) {
                nextStates.set(299);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_303(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'O')||(ch== 'o')) {
                nextStates.set(419);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_304(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'T')||(ch== 't')) {
                nextStates.set(404);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_305(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch== ',') {
                if (validTypes.contains(T_VALUE_SEPARATOR)) return T_VALUE_SEPARATOR;
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_306(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'F')||(ch== 'f')) {
                nextStates.set(49);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_307(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'O')||(ch== 'o')) {
                nextStates.set(358);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_308(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'L')||(ch== 'l')) {
                nextStates.set(208);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_309(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'E')||(ch== 'e')) {
                nextStates.set(326);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_310(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch== '(') {
                if (validTypes.contains(T_QF_FINISHES)) return T_QF_FINISHES;
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_311(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'M')||(ch== 'm')) {
                nextStates.set(77);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_312(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch== '_') {
                nextStates.set(87);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_313(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'E')||(ch== 'e')) {
                nextStates.set(268);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_314(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'O')||(ch== 'o')) {
                nextStates.set(200);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_315(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'R')||(ch== 'r')) {
                nextStates.set(318);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_316(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'L')||(ch== 'l')) {
                nextStates.set(275);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_317(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'D')||(ch== 'd')) {
                nextStates.set(336);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_318(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'T')||(ch== 't')) {
                nextStates.set(55);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_319(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'C')||(ch== 'c')) {
                nextStates.set(348);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_320(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'I')||(ch== 'i')) {
                nextStates.set(282);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_321(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'D')||(ch== 'd')) {
                nextStates.set(394);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_322(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'E')||(ch== 'e')) {
                nextStates.set(375);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_323(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'S')||(ch== 's')) {
                nextStates.set(225);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_324(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'S')||(ch== 's')) {
                nextStates.set(116);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_325(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'N')||(ch== 'n')) {
                nextStates.set(163);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_326(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'T')||(ch== 't')) {
                nextStates.set(126);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_327(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'L')||(ch== 'l')) {
                nextStates.set(57);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_328(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'T')||(ch== 't')) {
                if (validTypes.contains(T_QO_LT)) return T_QO_LT;
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_329(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'S')||(ch== 's')) {
                nextStates.set(271);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_330(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'T')||(ch== 't')) {
                nextStates.set(426);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_331(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'O')||(ch== 'o')) {
                nextStates.set(94);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_332(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'I')||(ch== 'i')) {
                nextStates.set(128);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_333(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'R')||(ch== 'r')) {
                nextStates.set(308);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_334(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'D')||(ch== 'd')) {
                nextStates.set(47);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_335(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'D')||(ch== 'd')) {
                if (validTypes.contains(T_QO_AND)) return T_QO_AND;
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_336(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'D')||(ch== 'd')) {
                if (validTypes.contains(T_QO_ADD)) return T_QO_ADD;
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_337(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'C')||(ch== 'c')) {
                nextStates.set(142);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_338(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'U')||(ch== 'u')) {
                nextStates.set(263);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_339(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'A')||(ch== 'a')) {
                nextStates.set(342);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_340(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'C')||(ch== 'c')) {
                nextStates.set(297);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_341(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'I')||(ch== 'i')) {
                nextStates.set(390);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_342(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'T')||(ch== 't')) {
                nextStates.set(183);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_343(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'R')||(ch== 'r')) {
                nextStates.set(204);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_344(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'E')||(ch== 'e')) {
                nextStates.set(416);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_345(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch== '(') {
                if (validTypes.contains(T_QF_TOLOWER)) return T_QF_TOLOWER;
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_346(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch== '(') {
                if (validTypes.contains(T_QF_DURING)) return T_QF_DURING;
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_347(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'D')||(ch== 'd')) {
                nextStates.set(21);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_348(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'T')||(ch== 't')) {
                nextStates.set(300);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_349(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'A')||(ch== 'a')) {
                nextStates.set(315);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_350(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch== '(') {
                if (validTypes.contains(T_LB)) return T_LB;
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_351(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'E')||(ch== 'e')) {
                nextStates.set(352);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_352(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'S')||(ch== 's')) {
                nextStates.set(246);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_353(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch== '(') {
                if (validTypes.contains(T_QF_ENDSWITH)) return T_QF_ENDSWITH;
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_354(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'M')||(ch== 'm')) {
                nextStates.set(58);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_355(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch== '(') {
                if (validTypes.contains(T_QF_ST_WITHIN)) return T_QF_ST_WITHIN;
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_356(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'E')||(ch== 'e')) {
                nextStates.set(319);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_357(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'D')||(ch== 'd')) {
                nextStates.set(36);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_358(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'N')||(ch== 'n')) {
                nextStates.set(413);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_359(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'T')||(ch== 't')) {
                nextStates.set(374);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_360(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch== '_') {
                nextStates.set(118);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_361(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'I')||(ch== 'i')) {
                nextStates.set(35);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_362(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch== '(') {
                if (validTypes.contains(T_QF_STARTS)) return T_QF_STARTS;
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_363(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'I')||(ch== 'i')) {
                nextStates.set(60);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_364(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'N')||(ch== 'n')) {
                nextStates.set(340);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_365(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'O')||(ch== 'o')) {
                nextStates.set(343);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_366(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'O')||(ch== 'o')) {
                nextStates.set(52);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_367(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch== '(') {
                if (validTypes.contains(T_QF_HOUR)) return T_QF_HOUR;
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_368(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'B')||(ch== 'b')) {
                nextStates.set(420);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_369(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'E')||(ch== 'e')) {
                nextStates.set(441);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_370(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'N')||(ch== 'n')) {
                nextStates.set(355);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_371(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'U')||(ch== 'u')) {
                nextStates.set(72);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_372(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'O')||(ch== 'o')) {
                nextStates.set(167);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_373(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch== '(') {
                if (validTypes.contains(T_QF_MEETS)) return T_QF_MEETS;
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_374(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch== '_') {
                nextStates.set(32);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_375(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'T')||(ch== 't')) {
                nextStates.set(51);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_376(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'I')||(ch== 'i')) {
                nextStates.set(370);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_377(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'E')||(ch== 'e')) {
                nextStates.set(251);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_378(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'N')||(ch== 'n')) {
                nextStates.set(191);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_379(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'E')||(ch== 'e')) {
                nextStates.set(233);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_380(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'E')||(ch== 'e')) {
                nextStates.set(438);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_381(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'O')||(ch== 'o')) {
                nextStates.set(385);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_382(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'R')||(ch== 'r')) {
                nextStates.set(67);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_383(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'M')||(ch== 'm')) {
                nextStates.set(399);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_384(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'D')||(ch== 'd')) {
                nextStates.set(284);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_385(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'F')||(ch== 'f')) {
                nextStates.set(424);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_386(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'E')||(ch== 'e')) {
                nextStates.set(322);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_387(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch== '(') {
                if (validTypes.contains(T_QF_FRACTIONALSECONDS)) return T_QF_FRACTIONALSECONDS;
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_388(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'G')||(ch== 'g')) {
                nextStates.set(248);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_389(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'E')||(ch== 'e')) {
                nextStates.set(62);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_390(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'N')||(ch== 'n')) {
                nextStates.set(82);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_391(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'G')||(ch== 'g')) {
                nextStates.set(429);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_392(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'N')||(ch== 'n')) {
                nextStates.set(259);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_393(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'I')||(ch== 'i')) {
                nextStates.set(182);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_394(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'A')||(ch== 'a')) {
                nextStates.set(179);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_395(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch== '(') {
                if (validTypes.contains(T_QF_DAY)) return T_QF_DAY;
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_396(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'S')||(ch== 's')) {
                nextStates.set(410);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_397(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'M')||(ch== 'm')) {
                nextStates.set(369);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_398(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'O')||(ch== 'o')) {
                nextStates.set(124);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_399(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch== '(') {
                if (validTypes.contains(T_QF_TRIM)) return T_QF_TRIM;
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_400(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch== '_') {
                nextStates.set(337);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_401(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch== '(') {
                if (validTypes.contains(T_QF_ST_CONTAINS)) return T_QF_ST_CONTAINS;
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_402(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch== '(') {
                if (validTypes.contains(T_QF_AFTER)) return T_QF_AFTER;
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_403(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'G')||(ch== 'g')) {
                nextStates.set(220);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_404(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch== '(') {
                if (validTypes.contains(T_QF_ST_DISJOINT)) return T_QF_ST_DISJOINT;
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_405(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'O')||(ch== 'o')) {
                nextStates.set(412);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_406(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'S')||(ch== 's')) {
                nextStates.set(356);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_407(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch== '_') {
                nextStates.set(190);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_408(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'R')||(ch== 'r')) {
                nextStates.set(25);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_409(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'T')||(ch== 't')) {
                nextStates.set(194);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_410(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch== '(') {
                if (validTypes.contains(T_QF_GEO_INTERSECTS)) return T_QF_GEO_INTERSECTS;
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_411(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'M')||(ch== 'm')) {
                nextStates.set(83);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_412(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'I')||(ch== 'i')) {
                nextStates.set(253);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_413(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'T')||(ch== 't')) {
                nextStates.set(97);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_414(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'T')||(ch== 't')) {
                nextStates.set(262);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_415(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'D')||(ch== 'd')) {
                nextStates.set(332);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_416(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'N')||(ch== 'n')) {
                nextStates.set(256);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_417(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'O')||(ch== 'o')) {
                nextStates.set(283);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_418(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch== '(') {
                if (validTypes.contains(T_QF_LENGTH)) return T_QF_LENGTH;
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_419(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'N')||(ch== 'n')) {
                nextStates.set(165);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_420(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'S')||(ch== 's')) {
                nextStates.set(414);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_421(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'A')||(ch== 'a')) {
                nextStates.set(71);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_422(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'T')||(ch== 't')) {
                nextStates.set(349);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_423(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'N')||(ch== 'n')) {
                nextStates.set(13);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_424(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch== '(') {
                if (validTypes.contains(T_QF_INDEXOF)) return T_QF_INDEXOF;
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_425(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'T')||(ch== 't')) {
                nextStates.set(290);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_426(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'I')||(ch== 'i')) {
                nextStates.set(397);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_427(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch== '\n') {
                if (validTypes.contains(_TOKEN_2)) return _TOKEN_2;
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_428(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'W')||(ch== 'w')) {
                nextStates.set(50);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_429(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'O')||(ch== 'o')) {
                nextStates.set(306);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_430(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'R')||(ch== 'r')) {
                nextStates.set(277);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_431(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'S')||(ch== 's')) {
                nextStates.set(289);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_432(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch== '(') {
                if (validTypes.contains(T_QF_OVERLAPS)) return T_QF_OVERLAPS;
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_433(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'E')||(ch== 'e')) {
                nextStates.set(69);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_434(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'S')||(ch== 's')) {
                nextStates.set(338);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_435(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'I')||(ch== 'i')) {
                nextStates.set(242);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_436(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch== '.') {
                nextStates.set(415);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_437(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'R')||(ch== 'r')) {
                nextStates.set(363);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_438(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch== '(') {
                if (validTypes.contains(T_QF_MAXDATETIME)) return T_QF_MAXDATETIME;
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_439(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'O')||(ch== 'o')) {
                nextStates.set(392);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_440(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch== '(') {
                if (validTypes.contains(T_QF_SECOND)) return T_QF_SECOND;
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_441(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch== '(') {
                if (validTypes.contains(T_QF_MINDATETIME)) return T_QF_MINDATETIME;
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_442(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'D')||(ch== 'd')) {
                nextStates.set(104);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_443(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'O')||(ch== 'o')) {
                nextStates.set(287);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_444(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'T')||(ch== 't')) {
                nextStates.set(164);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_445(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'I')||(ch== 'i')) {
                nextStates.set(378);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_446(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'O')||(ch== 'o')) {
                nextStates.set(324);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_447(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'C')||(ch== 'c')) {
                nextStates.set(303);
            }
            return null;
        }

        static TokenType NFA_LS_FILTER_448(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'M')||(ch== 'm')) {
                nextStates.set(63);
            }
            return null;
        }

        static private void NFA_FUNCTIONS_init() {
            NfaFunction[] functions= new NfaFunction[449];
            functions[0]= LS_FILTER::NFA_COMPOSITE_LS_FILTER_0;
            functions[1]= LS_FILTER::NFA_LS_FILTER_1;
            functions[2]= LS_FILTER::NFA_LS_FILTER_2;
            functions[3]= LS_FILTER::NFA_LS_FILTER_3;
            functions[4]= LS_FILTER::NFA_LS_FILTER_4;
            functions[5]= LS_FILTER::NFA_LS_FILTER_5;
            functions[6]= LS_FILTER::NFA_LS_FILTER_6;
            functions[7]= LS_FILTER::NFA_LS_FILTER_7;
            functions[8]= LS_FILTER::NFA_LS_FILTER_8;
            functions[9]= LS_FILTER::NFA_LS_FILTER_9;
            functions[10]= LS_FILTER::NFA_LS_FILTER_10;
            functions[11]= LS_FILTER::NFA_LS_FILTER_11;
            functions[12]= LS_FILTER::NFA_LS_FILTER_12;
            functions[13]= LS_FILTER::NFA_LS_FILTER_13;
            functions[14]= LS_FILTER::NFA_LS_FILTER_14;
            functions[15]= LS_FILTER::NFA_LS_FILTER_15;
            functions[16]= LS_FILTER::NFA_LS_FILTER_16;
            functions[17]= LS_FILTER::NFA_LS_FILTER_17;
            functions[18]= LS_FILTER::NFA_LS_FILTER_18;
            functions[19]= LS_FILTER::NFA_LS_FILTER_19;
            functions[20]= LS_FILTER::NFA_LS_FILTER_20;
            functions[21]= LS_FILTER::NFA_LS_FILTER_21;
            functions[22]= LS_FILTER::NFA_LS_FILTER_22;
            functions[23]= LS_FILTER::NFA_LS_FILTER_23;
            functions[24]= LS_FILTER::NFA_LS_FILTER_24;
            functions[25]= LS_FILTER::NFA_LS_FILTER_25;
            functions[26]= LS_FILTER::NFA_LS_FILTER_26;
            functions[27]= LS_FILTER::NFA_LS_FILTER_27;
            functions[28]= LS_FILTER::NFA_LS_FILTER_28;
            functions[29]= LS_FILTER::NFA_LS_FILTER_29;
            functions[30]= LS_FILTER::NFA_LS_FILTER_30;
            functions[31]= LS_FILTER::NFA_LS_FILTER_31;
            functions[32]= LS_FILTER::NFA_LS_FILTER_32;
            functions[33]= LS_FILTER::NFA_LS_FILTER_33;
            functions[34]= LS_FILTER::NFA_LS_FILTER_34;
            functions[35]= LS_FILTER::NFA_LS_FILTER_35;
            functions[36]= LS_FILTER::NFA_LS_FILTER_36;
            functions[37]= LS_FILTER::NFA_LS_FILTER_37;
            functions[38]= LS_FILTER::NFA_LS_FILTER_38;
            functions[39]= LS_FILTER::NFA_LS_FILTER_39;
            functions[40]= LS_FILTER::NFA_LS_FILTER_40;
            functions[41]= LS_FILTER::NFA_LS_FILTER_41;
            functions[42]= LS_FILTER::NFA_LS_FILTER_42;
            functions[43]= LS_FILTER::NFA_LS_FILTER_43;
            functions[44]= LS_FILTER::NFA_LS_FILTER_44;
            functions[45]= LS_FILTER::NFA_LS_FILTER_45;
            functions[46]= LS_FILTER::NFA_LS_FILTER_46;
            functions[47]= LS_FILTER::NFA_LS_FILTER_47;
            functions[48]= LS_FILTER::NFA_LS_FILTER_48;
            functions[49]= LS_FILTER::NFA_LS_FILTER_49;
            functions[50]= LS_FILTER::NFA_LS_FILTER_50;
            functions[51]= LS_FILTER::NFA_LS_FILTER_51;
            functions[52]= LS_FILTER::NFA_LS_FILTER_52;
            functions[53]= LS_FILTER::NFA_LS_FILTER_53;
            functions[54]= LS_FILTER::NFA_LS_FILTER_54;
            functions[55]= LS_FILTER::NFA_LS_FILTER_55;
            functions[56]= LS_FILTER::NFA_LS_FILTER_56;
            functions[57]= LS_FILTER::NFA_LS_FILTER_57;
            functions[58]= LS_FILTER::NFA_LS_FILTER_58;
            functions[59]= LS_FILTER::NFA_LS_FILTER_59;
            functions[60]= LS_FILTER::NFA_LS_FILTER_60;
            functions[61]= LS_FILTER::NFA_LS_FILTER_61;
            functions[62]= LS_FILTER::NFA_LS_FILTER_62;
            functions[63]= LS_FILTER::NFA_LS_FILTER_63;
            functions[64]= LS_FILTER::NFA_LS_FILTER_64;
            functions[65]= LS_FILTER::NFA_LS_FILTER_65;
            functions[66]= LS_FILTER::NFA_LS_FILTER_66;
            functions[67]= LS_FILTER::NFA_LS_FILTER_67;
            functions[68]= LS_FILTER::NFA_LS_FILTER_68;
            functions[69]= LS_FILTER::NFA_LS_FILTER_69;
            functions[70]= LS_FILTER::NFA_LS_FILTER_70;
            functions[71]= LS_FILTER::NFA_LS_FILTER_71;
            functions[72]= LS_FILTER::NFA_LS_FILTER_72;
            functions[73]= LS_FILTER::NFA_LS_FILTER_73;
            functions[74]= LS_FILTER::NFA_LS_FILTER_74;
            functions[75]= LS_FILTER::NFA_LS_FILTER_75;
            functions[76]= LS_FILTER::NFA_LS_FILTER_76;
            functions[77]= LS_FILTER::NFA_LS_FILTER_77;
            functions[78]= LS_FILTER::NFA_LS_FILTER_78;
            functions[79]= LS_FILTER::NFA_LS_FILTER_79;
            functions[80]= LS_FILTER::NFA_LS_FILTER_80;
            functions[81]= LS_FILTER::NFA_LS_FILTER_81;
            functions[82]= LS_FILTER::NFA_LS_FILTER_82;
            functions[83]= LS_FILTER::NFA_LS_FILTER_83;
            functions[84]= LS_FILTER::NFA_LS_FILTER_84;
            functions[85]= LS_FILTER::NFA_LS_FILTER_85;
            functions[86]= LS_FILTER::NFA_LS_FILTER_86;
            functions[87]= LS_FILTER::NFA_LS_FILTER_87;
            functions[88]= LS_FILTER::NFA_LS_FILTER_88;
            functions[89]= LS_FILTER::NFA_LS_FILTER_89;
            functions[90]= LS_FILTER::NFA_LS_FILTER_90;
            functions[91]= LS_FILTER::NFA_LS_FILTER_91;
            functions[92]= LS_FILTER::NFA_LS_FILTER_92;
            functions[93]= LS_FILTER::NFA_LS_FILTER_93;
            functions[94]= LS_FILTER::NFA_LS_FILTER_94;
            functions[95]= LS_FILTER::NFA_LS_FILTER_95;
            functions[96]= LS_FILTER::NFA_LS_FILTER_96;
            functions[97]= LS_FILTER::NFA_LS_FILTER_97;
            functions[98]= LS_FILTER::NFA_LS_FILTER_98;
            functions[99]= LS_FILTER::NFA_LS_FILTER_99;
            functions[100]= LS_FILTER::NFA_LS_FILTER_100;
            functions[101]= LS_FILTER::NFA_LS_FILTER_101;
            functions[102]= LS_FILTER::NFA_LS_FILTER_102;
            functions[103]= LS_FILTER::NFA_LS_FILTER_103;
            functions[104]= LS_FILTER::NFA_LS_FILTER_104;
            functions[105]= LS_FILTER::NFA_LS_FILTER_105;
            functions[106]= LS_FILTER::NFA_LS_FILTER_106;
            functions[107]= LS_FILTER::NFA_LS_FILTER_107;
            functions[108]= LS_FILTER::NFA_LS_FILTER_108;
            functions[109]= LS_FILTER::NFA_LS_FILTER_109;
            functions[110]= LS_FILTER::NFA_LS_FILTER_110;
            functions[111]= LS_FILTER::NFA_LS_FILTER_111;
            functions[112]= LS_FILTER::NFA_LS_FILTER_112;
            functions[113]= LS_FILTER::NFA_LS_FILTER_113;
            functions[114]= LS_FILTER::NFA_LS_FILTER_114;
            functions[115]= LS_FILTER::NFA_LS_FILTER_115;
            functions[116]= LS_FILTER::NFA_LS_FILTER_116;
            functions[117]= LS_FILTER::NFA_LS_FILTER_117;
            functions[118]= LS_FILTER::NFA_LS_FILTER_118;
            functions[119]= LS_FILTER::NFA_LS_FILTER_119;
            functions[120]= LS_FILTER::NFA_LS_FILTER_120;
            functions[121]= LS_FILTER::NFA_LS_FILTER_121;
            functions[122]= LS_FILTER::NFA_LS_FILTER_122;
            functions[123]= LS_FILTER::NFA_LS_FILTER_123;
            functions[124]= LS_FILTER::NFA_LS_FILTER_124;
            functions[125]= LS_FILTER::NFA_LS_FILTER_125;
            functions[126]= LS_FILTER::NFA_LS_FILTER_126;
            functions[127]= LS_FILTER::NFA_LS_FILTER_127;
            functions[128]= LS_FILTER::NFA_LS_FILTER_128;
            functions[129]= LS_FILTER::NFA_LS_FILTER_129;
            functions[130]= LS_FILTER::NFA_LS_FILTER_130;
            functions[131]= LS_FILTER::NFA_LS_FILTER_131;
            functions[132]= LS_FILTER::NFA_LS_FILTER_132;
            functions[133]= LS_FILTER::NFA_LS_FILTER_133;
            functions[134]= LS_FILTER::NFA_LS_FILTER_134;
            functions[135]= LS_FILTER::NFA_LS_FILTER_135;
            functions[136]= LS_FILTER::NFA_LS_FILTER_136;
            functions[137]= LS_FILTER::NFA_LS_FILTER_137;
            functions[138]= LS_FILTER::NFA_LS_FILTER_138;
            functions[139]= LS_FILTER::NFA_LS_FILTER_139;
            functions[140]= LS_FILTER::NFA_LS_FILTER_140;
            functions[141]= LS_FILTER::NFA_LS_FILTER_141;
            functions[142]= LS_FILTER::NFA_LS_FILTER_142;
            functions[143]= LS_FILTER::NFA_LS_FILTER_143;
            functions[144]= LS_FILTER::NFA_LS_FILTER_144;
            functions[145]= LS_FILTER::NFA_LS_FILTER_145;
            functions[146]= LS_FILTER::NFA_LS_FILTER_146;
            functions[147]= LS_FILTER::NFA_LS_FILTER_147;
            functions[148]= LS_FILTER::NFA_LS_FILTER_148;
            functions[149]= LS_FILTER::NFA_LS_FILTER_149;
            functions[150]= LS_FILTER::NFA_LS_FILTER_150;
            functions[151]= LS_FILTER::NFA_LS_FILTER_151;
            functions[152]= LS_FILTER::NFA_LS_FILTER_152;
            functions[153]= LS_FILTER::NFA_LS_FILTER_153;
            functions[154]= LS_FILTER::NFA_LS_FILTER_154;
            functions[155]= LS_FILTER::NFA_LS_FILTER_155;
            functions[156]= LS_FILTER::NFA_LS_FILTER_156;
            functions[157]= LS_FILTER::NFA_LS_FILTER_157;
            functions[158]= LS_FILTER::NFA_LS_FILTER_158;
            functions[159]= LS_FILTER::NFA_LS_FILTER_159;
            functions[160]= LS_FILTER::NFA_LS_FILTER_160;
            functions[161]= LS_FILTER::NFA_LS_FILTER_161;
            functions[162]= LS_FILTER::NFA_LS_FILTER_162;
            functions[163]= LS_FILTER::NFA_LS_FILTER_163;
            functions[164]= LS_FILTER::NFA_LS_FILTER_164;
            functions[165]= LS_FILTER::NFA_LS_FILTER_165;
            functions[166]= LS_FILTER::NFA_LS_FILTER_166;
            functions[167]= LS_FILTER::NFA_LS_FILTER_167;
            functions[168]= LS_FILTER::NFA_LS_FILTER_168;
            functions[169]= LS_FILTER::NFA_LS_FILTER_169;
            functions[170]= LS_FILTER::NFA_LS_FILTER_170;
            functions[171]= LS_FILTER::NFA_LS_FILTER_171;
            functions[172]= LS_FILTER::NFA_LS_FILTER_172;
            functions[173]= LS_FILTER::NFA_LS_FILTER_173;
            functions[174]= LS_FILTER::NFA_LS_FILTER_174;
            functions[175]= LS_FILTER::NFA_LS_FILTER_175;
            functions[176]= LS_FILTER::NFA_LS_FILTER_176;
            functions[177]= LS_FILTER::NFA_LS_FILTER_177;
            functions[178]= LS_FILTER::NFA_LS_FILTER_178;
            functions[179]= LS_FILTER::NFA_LS_FILTER_179;
            functions[180]= LS_FILTER::NFA_LS_FILTER_180;
            functions[181]= LS_FILTER::NFA_LS_FILTER_181;
            functions[182]= LS_FILTER::NFA_LS_FILTER_182;
            functions[183]= LS_FILTER::NFA_LS_FILTER_183;
            functions[184]= LS_FILTER::NFA_LS_FILTER_184;
            functions[185]= LS_FILTER::NFA_LS_FILTER_185;
            functions[186]= LS_FILTER::NFA_LS_FILTER_186;
            functions[187]= LS_FILTER::NFA_LS_FILTER_187;
            functions[188]= LS_FILTER::NFA_LS_FILTER_188;
            functions[189]= LS_FILTER::NFA_LS_FILTER_189;
            functions[190]= LS_FILTER::NFA_LS_FILTER_190;
            functions[191]= LS_FILTER::NFA_LS_FILTER_191;
            functions[192]= LS_FILTER::NFA_LS_FILTER_192;
            functions[193]= LS_FILTER::NFA_LS_FILTER_193;
            functions[194]= LS_FILTER::NFA_LS_FILTER_194;
            functions[195]= LS_FILTER::NFA_LS_FILTER_195;
            functions[196]= LS_FILTER::NFA_LS_FILTER_196;
            functions[197]= LS_FILTER::NFA_LS_FILTER_197;
            functions[198]= LS_FILTER::NFA_LS_FILTER_198;
            functions[199]= LS_FILTER::NFA_LS_FILTER_199;
            functions[200]= LS_FILTER::NFA_LS_FILTER_200;
            functions[201]= LS_FILTER::NFA_LS_FILTER_201;
            functions[202]= LS_FILTER::NFA_LS_FILTER_202;
            functions[203]= LS_FILTER::NFA_LS_FILTER_203;
            functions[204]= LS_FILTER::NFA_LS_FILTER_204;
            functions[205]= LS_FILTER::NFA_LS_FILTER_205;
            functions[206]= LS_FILTER::NFA_LS_FILTER_206;
            functions[207]= LS_FILTER::NFA_LS_FILTER_207;
            functions[208]= LS_FILTER::NFA_LS_FILTER_208;
            functions[209]= LS_FILTER::NFA_LS_FILTER_209;
            functions[210]= LS_FILTER::NFA_LS_FILTER_210;
            functions[211]= LS_FILTER::NFA_LS_FILTER_211;
            functions[212]= LS_FILTER::NFA_LS_FILTER_212;
            functions[213]= LS_FILTER::NFA_LS_FILTER_213;
            functions[214]= LS_FILTER::NFA_LS_FILTER_214;
            functions[215]= LS_FILTER::NFA_LS_FILTER_215;
            functions[216]= LS_FILTER::NFA_LS_FILTER_216;
            functions[217]= LS_FILTER::NFA_LS_FILTER_217;
            functions[218]= LS_FILTER::NFA_LS_FILTER_218;
            functions[219]= LS_FILTER::NFA_LS_FILTER_219;
            functions[220]= LS_FILTER::NFA_LS_FILTER_220;
            functions[221]= LS_FILTER::NFA_LS_FILTER_221;
            functions[222]= LS_FILTER::NFA_LS_FILTER_222;
            functions[223]= LS_FILTER::NFA_LS_FILTER_223;
            functions[224]= LS_FILTER::NFA_LS_FILTER_224;
            functions[225]= LS_FILTER::NFA_LS_FILTER_225;
            functions[226]= LS_FILTER::NFA_LS_FILTER_226;
            functions[227]= LS_FILTER::NFA_LS_FILTER_227;
            functions[228]= LS_FILTER::NFA_LS_FILTER_228;
            functions[229]= LS_FILTER::NFA_LS_FILTER_229;
            functions[230]= LS_FILTER::NFA_LS_FILTER_230;
            functions[231]= LS_FILTER::NFA_LS_FILTER_231;
            functions[232]= LS_FILTER::NFA_LS_FILTER_232;
            functions[233]= LS_FILTER::NFA_LS_FILTER_233;
            functions[234]= LS_FILTER::NFA_LS_FILTER_234;
            functions[235]= LS_FILTER::NFA_LS_FILTER_235;
            functions[236]= LS_FILTER::NFA_LS_FILTER_236;
            functions[237]= LS_FILTER::NFA_LS_FILTER_237;
            functions[238]= LS_FILTER::NFA_LS_FILTER_238;
            functions[239]= LS_FILTER::NFA_LS_FILTER_239;
            functions[240]= LS_FILTER::NFA_LS_FILTER_240;
            functions[241]= LS_FILTER::NFA_LS_FILTER_241;
            functions[242]= LS_FILTER::NFA_LS_FILTER_242;
            functions[243]= LS_FILTER::NFA_LS_FILTER_243;
            functions[244]= LS_FILTER::NFA_LS_FILTER_244;
            functions[245]= LS_FILTER::NFA_LS_FILTER_245;
            functions[246]= LS_FILTER::NFA_LS_FILTER_246;
            functions[247]= LS_FILTER::NFA_LS_FILTER_247;
            functions[248]= LS_FILTER::NFA_LS_FILTER_248;
            functions[249]= LS_FILTER::NFA_LS_FILTER_249;
            functions[250]= LS_FILTER::NFA_LS_FILTER_250;
            functions[251]= LS_FILTER::NFA_LS_FILTER_251;
            functions[252]= LS_FILTER::NFA_LS_FILTER_252;
            functions[253]= LS_FILTER::NFA_LS_FILTER_253;
            functions[254]= LS_FILTER::NFA_LS_FILTER_254;
            functions[255]= LS_FILTER::NFA_LS_FILTER_255;
            functions[256]= LS_FILTER::NFA_LS_FILTER_256;
            functions[257]= LS_FILTER::NFA_LS_FILTER_257;
            functions[258]= LS_FILTER::NFA_LS_FILTER_258;
            functions[259]= LS_FILTER::NFA_LS_FILTER_259;
            functions[260]= LS_FILTER::NFA_LS_FILTER_260;
            functions[261]= LS_FILTER::NFA_LS_FILTER_261;
            functions[262]= LS_FILTER::NFA_LS_FILTER_262;
            functions[263]= LS_FILTER::NFA_LS_FILTER_263;
            functions[264]= LS_FILTER::NFA_LS_FILTER_264;
            functions[265]= LS_FILTER::NFA_LS_FILTER_265;
            functions[266]= LS_FILTER::NFA_LS_FILTER_266;
            functions[267]= LS_FILTER::NFA_LS_FILTER_267;
            functions[268]= LS_FILTER::NFA_LS_FILTER_268;
            functions[269]= LS_FILTER::NFA_LS_FILTER_269;
            functions[270]= LS_FILTER::NFA_LS_FILTER_270;
            functions[271]= LS_FILTER::NFA_LS_FILTER_271;
            functions[272]= LS_FILTER::NFA_LS_FILTER_272;
            functions[273]= LS_FILTER::NFA_LS_FILTER_273;
            functions[274]= LS_FILTER::NFA_LS_FILTER_274;
            functions[275]= LS_FILTER::NFA_LS_FILTER_275;
            functions[276]= LS_FILTER::NFA_LS_FILTER_276;
            functions[277]= LS_FILTER::NFA_LS_FILTER_277;
            functions[278]= LS_FILTER::NFA_LS_FILTER_278;
            functions[279]= LS_FILTER::NFA_LS_FILTER_279;
            functions[280]= LS_FILTER::NFA_LS_FILTER_280;
            functions[281]= LS_FILTER::NFA_LS_FILTER_281;
            functions[282]= LS_FILTER::NFA_LS_FILTER_282;
            functions[283]= LS_FILTER::NFA_LS_FILTER_283;
            functions[284]= LS_FILTER::NFA_LS_FILTER_284;
            functions[285]= LS_FILTER::NFA_LS_FILTER_285;
            functions[286]= LS_FILTER::NFA_LS_FILTER_286;
            functions[287]= LS_FILTER::NFA_LS_FILTER_287;
            functions[288]= LS_FILTER::NFA_LS_FILTER_288;
            functions[289]= LS_FILTER::NFA_LS_FILTER_289;
            functions[290]= LS_FILTER::NFA_LS_FILTER_290;
            functions[291]= LS_FILTER::NFA_LS_FILTER_291;
            functions[292]= LS_FILTER::NFA_LS_FILTER_292;
            functions[293]= LS_FILTER::NFA_LS_FILTER_293;
            functions[294]= LS_FILTER::NFA_LS_FILTER_294;
            functions[295]= LS_FILTER::NFA_LS_FILTER_295;
            functions[296]= LS_FILTER::NFA_LS_FILTER_296;
            functions[297]= LS_FILTER::NFA_LS_FILTER_297;
            functions[298]= LS_FILTER::NFA_LS_FILTER_298;
            functions[299]= LS_FILTER::NFA_LS_FILTER_299;
            functions[300]= LS_FILTER::NFA_LS_FILTER_300;
            functions[301]= LS_FILTER::NFA_LS_FILTER_301;
            functions[302]= LS_FILTER::NFA_LS_FILTER_302;
            functions[303]= LS_FILTER::NFA_LS_FILTER_303;
            functions[304]= LS_FILTER::NFA_LS_FILTER_304;
            functions[305]= LS_FILTER::NFA_LS_FILTER_305;
            functions[306]= LS_FILTER::NFA_LS_FILTER_306;
            functions[307]= LS_FILTER::NFA_LS_FILTER_307;
            functions[308]= LS_FILTER::NFA_LS_FILTER_308;
            functions[309]= LS_FILTER::NFA_LS_FILTER_309;
            functions[310]= LS_FILTER::NFA_LS_FILTER_310;
            functions[311]= LS_FILTER::NFA_LS_FILTER_311;
            functions[312]= LS_FILTER::NFA_LS_FILTER_312;
            functions[313]= LS_FILTER::NFA_LS_FILTER_313;
            functions[314]= LS_FILTER::NFA_LS_FILTER_314;
            functions[315]= LS_FILTER::NFA_LS_FILTER_315;
            functions[316]= LS_FILTER::NFA_LS_FILTER_316;
            functions[317]= LS_FILTER::NFA_LS_FILTER_317;
            functions[318]= LS_FILTER::NFA_LS_FILTER_318;
            functions[319]= LS_FILTER::NFA_LS_FILTER_319;
            functions[320]= LS_FILTER::NFA_LS_FILTER_320;
            functions[321]= LS_FILTER::NFA_LS_FILTER_321;
            functions[322]= LS_FILTER::NFA_LS_FILTER_322;
            functions[323]= LS_FILTER::NFA_LS_FILTER_323;
            functions[324]= LS_FILTER::NFA_LS_FILTER_324;
            functions[325]= LS_FILTER::NFA_LS_FILTER_325;
            functions[326]= LS_FILTER::NFA_LS_FILTER_326;
            functions[327]= LS_FILTER::NFA_LS_FILTER_327;
            functions[328]= LS_FILTER::NFA_LS_FILTER_328;
            functions[329]= LS_FILTER::NFA_LS_FILTER_329;
            functions[330]= LS_FILTER::NFA_LS_FILTER_330;
            functions[331]= LS_FILTER::NFA_LS_FILTER_331;
            functions[332]= LS_FILTER::NFA_LS_FILTER_332;
            functions[333]= LS_FILTER::NFA_LS_FILTER_333;
            functions[334]= LS_FILTER::NFA_LS_FILTER_334;
            functions[335]= LS_FILTER::NFA_LS_FILTER_335;
            functions[336]= LS_FILTER::NFA_LS_FILTER_336;
            functions[337]= LS_FILTER::NFA_LS_FILTER_337;
            functions[338]= LS_FILTER::NFA_LS_FILTER_338;
            functions[339]= LS_FILTER::NFA_LS_FILTER_339;
            functions[340]= LS_FILTER::NFA_LS_FILTER_340;
            functions[341]= LS_FILTER::NFA_LS_FILTER_341;
            functions[342]= LS_FILTER::NFA_LS_FILTER_342;
            functions[343]= LS_FILTER::NFA_LS_FILTER_343;
            functions[344]= LS_FILTER::NFA_LS_FILTER_344;
            functions[345]= LS_FILTER::NFA_LS_FILTER_345;
            functions[346]= LS_FILTER::NFA_LS_FILTER_346;
            functions[347]= LS_FILTER::NFA_LS_FILTER_347;
            functions[348]= LS_FILTER::NFA_LS_FILTER_348;
            functions[349]= LS_FILTER::NFA_LS_FILTER_349;
            functions[350]= LS_FILTER::NFA_LS_FILTER_350;
            functions[351]= LS_FILTER::NFA_LS_FILTER_351;
            functions[352]= LS_FILTER::NFA_LS_FILTER_352;
            functions[353]= LS_FILTER::NFA_LS_FILTER_353;
            functions[354]= LS_FILTER::NFA_LS_FILTER_354;
            functions[355]= LS_FILTER::NFA_LS_FILTER_355;
            functions[356]= LS_FILTER::NFA_LS_FILTER_356;
            functions[357]= LS_FILTER::NFA_LS_FILTER_357;
            functions[358]= LS_FILTER::NFA_LS_FILTER_358;
            functions[359]= LS_FILTER::NFA_LS_FILTER_359;
            functions[360]= LS_FILTER::NFA_LS_FILTER_360;
            functions[361]= LS_FILTER::NFA_LS_FILTER_361;
            functions[362]= LS_FILTER::NFA_LS_FILTER_362;
            functions[363]= LS_FILTER::NFA_LS_FILTER_363;
            functions[364]= LS_FILTER::NFA_LS_FILTER_364;
            functions[365]= LS_FILTER::NFA_LS_FILTER_365;
            functions[366]= LS_FILTER::NFA_LS_FILTER_366;
            functions[367]= LS_FILTER::NFA_LS_FILTER_367;
            functions[368]= LS_FILTER::NFA_LS_FILTER_368;
            functions[369]= LS_FILTER::NFA_LS_FILTER_369;
            functions[370]= LS_FILTER::NFA_LS_FILTER_370;
            functions[371]= LS_FILTER::NFA_LS_FILTER_371;
            functions[372]= LS_FILTER::NFA_LS_FILTER_372;
            functions[373]= LS_FILTER::NFA_LS_FILTER_373;
            functions[374]= LS_FILTER::NFA_LS_FILTER_374;
            functions[375]= LS_FILTER::NFA_LS_FILTER_375;
            functions[376]= LS_FILTER::NFA_LS_FILTER_376;
            functions[377]= LS_FILTER::NFA_LS_FILTER_377;
            functions[378]= LS_FILTER::NFA_LS_FILTER_378;
            functions[379]= LS_FILTER::NFA_LS_FILTER_379;
            functions[380]= LS_FILTER::NFA_LS_FILTER_380;
            functions[381]= LS_FILTER::NFA_LS_FILTER_381;
            functions[382]= LS_FILTER::NFA_LS_FILTER_382;
            functions[383]= LS_FILTER::NFA_LS_FILTER_383;
            functions[384]= LS_FILTER::NFA_LS_FILTER_384;
            functions[385]= LS_FILTER::NFA_LS_FILTER_385;
            functions[386]= LS_FILTER::NFA_LS_FILTER_386;
            functions[387]= LS_FILTER::NFA_LS_FILTER_387;
            functions[388]= LS_FILTER::NFA_LS_FILTER_388;
            functions[389]= LS_FILTER::NFA_LS_FILTER_389;
            functions[390]= LS_FILTER::NFA_LS_FILTER_390;
            functions[391]= LS_FILTER::NFA_LS_FILTER_391;
            functions[392]= LS_FILTER::NFA_LS_FILTER_392;
            functions[393]= LS_FILTER::NFA_LS_FILTER_393;
            functions[394]= LS_FILTER::NFA_LS_FILTER_394;
            functions[395]= LS_FILTER::NFA_LS_FILTER_395;
            functions[396]= LS_FILTER::NFA_LS_FILTER_396;
            functions[397]= LS_FILTER::NFA_LS_FILTER_397;
            functions[398]= LS_FILTER::NFA_LS_FILTER_398;
            functions[399]= LS_FILTER::NFA_LS_FILTER_399;
            functions[400]= LS_FILTER::NFA_LS_FILTER_400;
            functions[401]= LS_FILTER::NFA_LS_FILTER_401;
            functions[402]= LS_FILTER::NFA_LS_FILTER_402;
            functions[403]= LS_FILTER::NFA_LS_FILTER_403;
            functions[404]= LS_FILTER::NFA_LS_FILTER_404;
            functions[405]= LS_FILTER::NFA_LS_FILTER_405;
            functions[406]= LS_FILTER::NFA_LS_FILTER_406;
            functions[407]= LS_FILTER::NFA_LS_FILTER_407;
            functions[408]= LS_FILTER::NFA_LS_FILTER_408;
            functions[409]= LS_FILTER::NFA_LS_FILTER_409;
            functions[410]= LS_FILTER::NFA_LS_FILTER_410;
            functions[411]= LS_FILTER::NFA_LS_FILTER_411;
            functions[412]= LS_FILTER::NFA_LS_FILTER_412;
            functions[413]= LS_FILTER::NFA_LS_FILTER_413;
            functions[414]= LS_FILTER::NFA_LS_FILTER_414;
            functions[415]= LS_FILTER::NFA_LS_FILTER_415;
            functions[416]= LS_FILTER::NFA_LS_FILTER_416;
            functions[417]= LS_FILTER::NFA_LS_FILTER_417;
            functions[418]= LS_FILTER::NFA_LS_FILTER_418;
            functions[419]= LS_FILTER::NFA_LS_FILTER_419;
            functions[420]= LS_FILTER::NFA_LS_FILTER_420;
            functions[421]= LS_FILTER::NFA_LS_FILTER_421;
            functions[422]= LS_FILTER::NFA_LS_FILTER_422;
            functions[423]= LS_FILTER::NFA_LS_FILTER_423;
            functions[424]= LS_FILTER::NFA_LS_FILTER_424;
            functions[425]= LS_FILTER::NFA_LS_FILTER_425;
            functions[426]= LS_FILTER::NFA_LS_FILTER_426;
            functions[427]= LS_FILTER::NFA_LS_FILTER_427;
            functions[428]= LS_FILTER::NFA_LS_FILTER_428;
            functions[429]= LS_FILTER::NFA_LS_FILTER_429;
            functions[430]= LS_FILTER::NFA_LS_FILTER_430;
            functions[431]= LS_FILTER::NFA_LS_FILTER_431;
            functions[432]= LS_FILTER::NFA_LS_FILTER_432;
            functions[433]= LS_FILTER::NFA_LS_FILTER_433;
            functions[434]= LS_FILTER::NFA_LS_FILTER_434;
            functions[435]= LS_FILTER::NFA_LS_FILTER_435;
            functions[436]= LS_FILTER::NFA_LS_FILTER_436;
            functions[437]= LS_FILTER::NFA_LS_FILTER_437;
            functions[438]= LS_FILTER::NFA_LS_FILTER_438;
            functions[439]= LS_FILTER::NFA_LS_FILTER_439;
            functions[440]= LS_FILTER::NFA_LS_FILTER_440;
            functions[441]= LS_FILTER::NFA_LS_FILTER_441;
            functions[442]= LS_FILTER::NFA_LS_FILTER_442;
            functions[443]= LS_FILTER::NFA_LS_FILTER_443;
            functions[444]= LS_FILTER::NFA_LS_FILTER_444;
            functions[445]= LS_FILTER::NFA_LS_FILTER_445;
            functions[446]= LS_FILTER::NFA_LS_FILTER_446;
            functions[447]= LS_FILTER::NFA_LS_FILTER_447;
            functions[448]= LS_FILTER::NFA_LS_FILTER_448;
            functionTableMap.put(LexicalState.LS_FILTER, functions);
        }

    }
    /**
  * Holder class for NFA code related to LS_CONSTANTS lexical state
  */
    private static class LS_CONSTANTS {
        static TokenType NFA_COMPOSITE_LS_CONSTANTS_0(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            TokenType type= null;
            if (ch== '\'') {
                nextStates.set(24);
            }
            else if ((ch== '+')||(ch== '-')) {
                nextStates.set(289);
                nextStates.set(112);
                nextStates.set(14);
                nextStates.set(72);
                nextStates.set(123);
                nextStates.set(3);
            }
            else if (ch== '0') {
                nextStates.set(203);
            }
            if (ch>='0'&&ch<='9') {
                nextStates.set(474);
                nextStates.set(383);
                nextStates.set(447);
            }
            if (ch== '1') {
                nextStates.set(240);
            }
            if (ch>='1'&&ch<='9') {
                nextStates.set(339);
                nextStates.set(385);
                nextStates.set(483);
                nextStates.set(201);
                nextStates.set(378);
            }
            if (ch== '2') {
                nextStates.set(216);
            }
            else if ((ch== 'D')||(ch== 'd')) {
                nextStates.set(254);
            }
            else if ((ch== 'F')||(ch== 'f')) {
                nextStates.set(176);
            }
            else if ((ch== 'G')||(ch== 'g')) {
                nextStates.set(247);
            }
            else if ((ch== 'P')||(ch== 'p')) {
                nextStates.set(107);
            }
            else if ((ch== 'T')||(ch== 't')) {
                nextStates.set(182);
            }
            if (ch>='0'&&ch<='9') {
                nextStates.set(95);
                if (validTypes.contains(T_LONG)) type= T_LONG;
            }
            else if (ch== '\t') {
                if (validTypes.contains(_TOKEN_4)) type= _TOKEN_4;
            }
            else if (ch== '\r') {
                if (validTypes.contains(_TOKEN_3)) type= _TOKEN_3;
            }
            else if (ch== '\n') {
                if (validTypes.contains(_TOKEN_2)) type= _TOKEN_2;
            }
            else if (ch== ' ') {
                if (validTypes.contains(_TOKEN_1)) type= _TOKEN_1;
            }
            return type;
        }

        static TokenType NFA_COMPOSITE_LS_CONSTANTS_1(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            TokenType type= null;
            if ((ch>=0x0&&ch<='&')||(ch>='(')) {
                nextStates.set(1);
            }
            else if (ch== '\'') {
                if (validTypes.contains(T_GEO_STR_LIT)) type= T_GEO_STR_LIT;
            }
            return type;
        }

        static TokenType NFA_COMPOSITE_LS_CONSTANTS_2(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            TokenType type= null;
            if (ch>='0'&&ch<='9') {
                nextStates.set(268);
            }
            if (ch>='1'&&ch<='9') {
                nextStates.set(416);
            }
            return type;
        }

        static TokenType NFA_COMPOSITE_LS_CONSTANTS_3(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            TokenType type= null;
            if (ch>='1'&&ch<='9') {
                nextStates.set(339);
            }
            if (ch>='0'&&ch<='9') {
                nextStates.set(95);
                if (validTypes.contains(T_DOUBLE)) type= T_DOUBLE;
            }
            return type;
        }

        static TokenType NFA_COMPOSITE_LS_CONSTANTS_4(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            TokenType type= null;
            if (ch>='0'&&ch<='9') {
                nextStates.set(4);
            }
            else if ((ch== 'H')||(ch== 'h')) {
                nextStates.set(127);
            }
            return type;
        }

        static TokenType NFA_COMPOSITE_LS_CONSTANTS_5(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            TokenType type= null;
            if ((ch== '+')||(ch== '-')) {
                nextStates.set(18);
                nextStates.set(27);
                nextStates.set(22);
            }
            else if (ch== '/') {
                nextStates.set(34);
            }
            else if (ch>='0'&&ch<='9') {
                nextStates.set(342);
                nextStates.set(317);
                nextStates.set(287);
            }
            if (ch>='1'&&ch<='9') {
                nextStates.set(311);
                nextStates.set(479);
                nextStates.set(477);
            }
            else if ((ch== 'T')||(ch== 't')) {
                nextStates.set(37);
            }
            return type;
        }

        static TokenType NFA_COMPOSITE_LS_CONSTANTS_6(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            TokenType type= null;
            if ((ch== '+')||(ch== '-')) {
                nextStates.set(99);
            }
            else if (ch== ',') {
                nextStates.set(434);
            }
            else if (ch== '.') {
                nextStates.set(434);
            }
            else if ((ch== 'Z')||(ch== 'z')) {
                if (validTypes.contains(T_DATETIMEINTERVAL)) type= T_DATETIMEINTERVAL;
            }
            return type;
        }

        static TokenType NFA_COMPOSITE_LS_CONSTANTS_7(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            TokenType type= null;
            if ((ch== '+')||(ch== '-')) {
                nextStates.set(113);
                nextStates.set(15);
                nextStates.set(36);
                nextStates.set(100);
            }
            else if (ch>='0'&&ch<='9') {
                nextStates.set(356);
                nextStates.set(467);
                nextStates.set(418);
                nextStates.set(409);
            }
            if (ch>='1'&&ch<='9') {
                nextStates.set(293);
                nextStates.set(344);
                nextStates.set(370);
                nextStates.set(273);
            }
            else if ((ch== 'T')||(ch== 't')) {
                nextStates.set(10);
            }
            else if (ch== '\'') {
                if (validTypes.contains(T_DURATION)) type= T_DURATION;
            }
            return type;
        }

        static TokenType NFA_COMPOSITE_LS_CONSTANTS_8(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            TokenType type= null;
            if ((ch== '+')||(ch== '-')) {
                nextStates.set(113);
                nextStates.set(36);
                nextStates.set(15);
            }
            else if (ch>='0'&&ch<='9') {
                nextStates.set(418);
                nextStates.set(356);
                nextStates.set(467);
            }
            if (ch>='1'&&ch<='9') {
                nextStates.set(344);
                nextStates.set(370);
                nextStates.set(273);
            }
            else if ((ch== 'T')||(ch== 't')) {
                nextStates.set(10);
            }
            else if (ch== '\'') {
                if (validTypes.contains(T_DURATION)) type= T_DURATION;
            }
            return type;
        }

        static TokenType NFA_COMPOSITE_LS_CONSTANTS_9(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            TokenType type= null;
            if ((ch== '+')||(ch== '-')) {
                nextStates.set(88);
                nextStates.set(47);
            }
            else if (ch>='0'&&ch<='9') {
                nextStates.set(481);
                nextStates.set(21);
            }
            if (ch>='1'&&ch<='9') {
                nextStates.set(459);
                nextStates.set(325);
            }
            return type;
        }

        static TokenType NFA_COMPOSITE_LS_CONSTANTS_10(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            TokenType type= null;
            if ((ch== '+')||(ch== '-')) {
                nextStates.set(91);
                nextStates.set(133);
                nextStates.set(153);
            }
            else if (ch>='0'&&ch<='9') {
                nextStates.set(490);
                nextStates.set(12);
                nextStates.set(326);
            }
            if (ch>='1'&&ch<='9') {
                nextStates.set(371);
                nextStates.set(280);
                nextStates.set(432);
            }
            else if (ch== '\'') {
                if (validTypes.contains(T_DURATION)) type= T_DURATION;
            }
            return type;
        }

        static TokenType NFA_COMPOSITE_LS_CONSTANTS_11(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            TokenType type= null;
            if (ch== '.') {
                nextStates.set(150);
            }
            else if (ch>='0'&&ch<='9') {
                nextStates.set(11);
            }
            else if ((ch== 'S')||(ch== 's')) {
                nextStates.set(375);
            }
            return type;
        }

        static TokenType NFA_COMPOSITE_LS_CONSTANTS_12(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            TokenType type= null;
            if (ch== '.') {
                nextStates.set(59);
            }
            else if ((ch== 'S')||(ch== 's')) {
                nextStates.set(455);
            }
            return type;
        }

        static TokenType NFA_COMPOSITE_LS_CONSTANTS_13(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            TokenType type= null;
            if (ch>='0'&&ch<='9') {
                nextStates.set(13);
            }
            else if ((ch== 'D')||(ch== 'd')) {
                nextStates.set(121);
            }
            return type;
        }

        static TokenType NFA_COMPOSITE_LS_CONSTANTS_14(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            TokenType type= null;
            if (ch>='0'&&ch<='9') {
                nextStates.set(383);
            }
            if (ch>='1'&&ch<='9') {
                nextStates.set(385);
            }
            return type;
        }

        static TokenType NFA_COMPOSITE_LS_CONSTANTS_15(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            TokenType type= null;
            if (ch>='0'&&ch<='9') {
                nextStates.set(418);
            }
            if (ch>='1'&&ch<='9') {
                nextStates.set(344);
            }
            return type;
        }

        static TokenType NFA_COMPOSITE_LS_CONSTANTS_16(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            TokenType type= null;
            if (ch== ',') {
                nextStates.set(253);
            }
            else if (ch== '.') {
                nextStates.set(253);
            }
            return type;
        }

        static TokenType NFA_COMPOSITE_LS_CONSTANTS_17(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            TokenType type= null;
            if (ch== ',') {
                nextStates.set(433);
            }
            else if (ch== '.') {
                nextStates.set(433);
            }
            return type;
        }

        static TokenType NFA_COMPOSITE_LS_CONSTANTS_18(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            TokenType type= null;
            if (ch>='0'&&ch<='9') {
                nextStates.set(287);
            }
            if (ch>='1'&&ch<='9') {
                nextStates.set(477);
            }
            return type;
        }

        static TokenType NFA_COMPOSITE_LS_CONSTANTS_19(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            TokenType type= null;
            if ((ch== '+')||(ch== '-')) {
                nextStates.set(99);
            }
            else if ((ch== 'Z')||(ch== 'z')) {
                if (validTypes.contains(T_DATETIMEINTERVAL)) type= T_DATETIMEINTERVAL;
            }
            return type;
        }

        static TokenType NFA_COMPOSITE_LS_CONSTANTS_20(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            TokenType type= null;
            if ((ch== '+')||(ch== '-')) {
                nextStates.set(99);
            }
            else if (ch== ':') {
                nextStates.set(214);
            }
            else if ((ch== 'Z')||(ch== 'z')) {
                if (validTypes.contains(T_DATETIMEINTERVAL)) type= T_DATETIMEINTERVAL;
            }
            return type;
        }

        static TokenType NFA_COMPOSITE_LS_CONSTANTS_21(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            TokenType type= null;
            if (ch== '.') {
                nextStates.set(76);
            }
            else if ((ch== 'S')||(ch== 's')) {
                if (validTypes.contains(T_DATETIMEINTERVAL)) type= T_DATETIMEINTERVAL;
            }
            return type;
        }

        static TokenType NFA_COMPOSITE_LS_CONSTANTS_22(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            TokenType type= null;
            if (ch>='0'&&ch<='9') {
                nextStates.set(342);
            }
            if (ch>='1'&&ch<='9') {
                nextStates.set(311);
            }
            return type;
        }

        static TokenType NFA_COMPOSITE_LS_CONSTANTS_23(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            TokenType type= null;
            if (ch>='0'&&ch<='9') {
                nextStates.set(147);
            }
            if (ch>='1'&&ch<='9') {
                nextStates.set(338);
            }
            return type;
        }

        static TokenType NFA_COMPOSITE_LS_CONSTANTS_24(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            TokenType type= null;
            if ((ch>=0x0&&ch<='&')||(ch>='(')) {
                nextStates.set(24);
            }
            else if (ch== '\'') {
                nextStates.set(233);
                if (validTypes.contains(T_STR_LIT)) type= T_STR_LIT;
            }
            return type;
        }

        static TokenType NFA_COMPOSITE_LS_CONSTANTS_25(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            TokenType type= null;
            if ((ch== '+')||(ch== '-')) {
                nextStates.set(22);
            }
            else if (ch>='0'&&ch<='9') {
                nextStates.set(342);
            }
            if (ch>='1'&&ch<='9') {
                nextStates.set(311);
            }
            return type;
        }

        static TokenType NFA_COMPOSITE_LS_CONSTANTS_26(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            TokenType type= null;
            if (ch== '.') {
                nextStates.set(353);
            }
            else if ((ch== 'E')||(ch== 'e')) {
                nextStates.set(139);
            }
            else if (ch>='0'&&ch<='9') {
                nextStates.set(26);
                if (validTypes.contains(T_DOUBLE)) type= T_DOUBLE;
            }
            return type;
        }

        static TokenType NFA_COMPOSITE_LS_CONSTANTS_27(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            TokenType type= null;
            if (ch>='0'&&ch<='9') {
                nextStates.set(317);
            }
            if (ch>='1'&&ch<='9') {
                nextStates.set(479);
            }
            return type;
        }

        static TokenType NFA_COMPOSITE_LS_CONSTANTS_28(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            TokenType type= null;
            if (ch== '.') {
                nextStates.set(59);
            }
            else if (ch>='0'&&ch<='9') {
                nextStates.set(28);
            }
            else if ((ch== 'S')||(ch== 's')) {
                nextStates.set(455);
            }
            return type;
        }

        static TokenType NFA_COMPOSITE_LS_CONSTANTS_29(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            TokenType type= null;
            if ((ch== '+')||(ch== '-')) {
                nextStates.set(51);
            }
            else if (ch>='0'&&ch<='9') {
                nextStates.set(341);
            }
            if (ch>='1'&&ch<='9') {
                nextStates.set(333);
            }
            return type;
        }

        static TokenType NFA_COMPOSITE_LS_CONSTANTS_30(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            TokenType type= null;
            if ((ch== '+')||(ch== '-')) {
                nextStates.set(62);
            }
            else if (ch>='0'&&ch<='9') {
                nextStates.set(398);
            }
            if (ch>='1'&&ch<='9') {
                nextStates.set(365);
            }
            return type;
        }

        static TokenType NFA_COMPOSITE_LS_CONSTANTS_31(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            TokenType type= null;
            if (ch== '0') {
                nextStates.set(246);
            }
            else if (ch== '1') {
                nextStates.set(161);
            }
            else if (ch== '2') {
                nextStates.set(198);
            }
            return type;
        }

        static TokenType NFA_COMPOSITE_LS_CONSTANTS_32(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            TokenType type= null;
            if ((ch== '+')||(ch== '-')) {
                nextStates.set(36);
            }
            else if (ch>='0'&&ch<='9') {
                nextStates.set(467);
            }
            if (ch>='1'&&ch<='9') {
                nextStates.set(370);
            }
            else if ((ch== 'T')||(ch== 't')) {
                nextStates.set(10);
            }
            else if (ch== '\'') {
                if (validTypes.contains(T_DURATION)) type= T_DURATION;
            }
            return type;
        }

        static TokenType NFA_COMPOSITE_LS_CONSTANTS_33(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            TokenType type= null;
            if (ch== ',') {
                nextStates.set(434);
            }
            else if (ch== '.') {
                nextStates.set(434);
            }
            return type;
        }

        static TokenType NFA_COMPOSITE_LS_CONSTANTS_34(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            TokenType type= null;
            if ((ch== '+')||(ch== '-')) {
                nextStates.set(136);
                nextStates.set(323);
            }
            else if (ch>='0'&&ch<='9') {
                nextStates.set(451);
            }
            if (ch>='1'&&ch<='9') {
                nextStates.set(436);
            }
            else if ((ch== 'P')||(ch== 'p')) {
                nextStates.set(65);
                if (validTypes.contains(T_DATETIMEINTERVAL)) type= T_DATETIMEINTERVAL;
            }
            return type;
        }

        static TokenType NFA_COMPOSITE_LS_CONSTANTS_35(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            TokenType type= null;
            if (ch== '0') {
                nextStates.set(185);
            }
            else if (ch== '1') {
                nextStates.set(164);
            }
            return type;
        }

        static TokenType NFA_COMPOSITE_LS_CONSTANTS_36(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            TokenType type= null;
            if (ch>='0'&&ch<='9') {
                nextStates.set(467);
            }
            if (ch>='1'&&ch<='9') {
                nextStates.set(370);
            }
            return type;
        }

        static TokenType NFA_COMPOSITE_LS_CONSTANTS_37(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            TokenType type= null;
            if ((ch== '+')||(ch== '-')) {
                nextStates.set(98);
                nextStates.set(40);
                nextStates.set(23);
            }
            else if (ch== '/') {
                nextStates.set(34);
            }
            else if (ch>='0'&&ch<='9') {
                nextStates.set(471);
                nextStates.set(147);
                nextStates.set(299);
            }
            if (ch>='1'&&ch<='9') {
                nextStates.set(469);
                nextStates.set(347);
                nextStates.set(338);
            }
            return type;
        }

        static TokenType NFA_COMPOSITE_LS_CONSTANTS_38(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            TokenType type= null;
            if (ch== '0') {
                nextStates.set(167);
            }
            else if (ch== '1') {
                nextStates.set(212);
            }
            else if (ch== '2') {
                nextStates.set(255);
            }
            return type;
        }

        static TokenType NFA_COMPOSITE_LS_CONSTANTS_39(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            TokenType type= null;
            if ((ch== '+')||(ch== '-')) {
                nextStates.set(153);
            }
            else if (ch>='0'&&ch<='9') {
                nextStates.set(326);
            }
            if (ch>='1'&&ch<='9') {
                nextStates.set(280);
            }
            return type;
        }

        static TokenType NFA_COMPOSITE_LS_CONSTANTS_40(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            TokenType type= null;
            if (ch>='0'&&ch<='9') {
                nextStates.set(471);
            }
            if (ch>='1'&&ch<='9') {
                nextStates.set(469);
            }
            return type;
        }

        static TokenType NFA_COMPOSITE_LS_CONSTANTS_41(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            TokenType type= null;
            if (ch== '0') {
                nextStates.set(218);
            }
            else if (ch== '1') {
                nextStates.set(199);
            }
            return type;
        }

        static TokenType NFA_COMPOSITE_LS_CONSTANTS_42(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            TokenType type= null;
            if ((ch== '+')||(ch== '-')) {
                nextStates.set(99);
            }
            else if (ch>='0'&&ch<='9') {
                nextStates.set(42);
            }
            else if ((ch== 'Z')||(ch== 'z')) {
                if (validTypes.contains(T_DATETIMEINTERVAL)) type= T_DATETIMEINTERVAL;
            }
            return type;
        }

        static TokenType NFA_COMPOSITE_LS_CONSTANTS_43(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            TokenType type= null;
            if (ch== '0') {
                nextStates.set(217);
            }
            else if (ch== '1') {
                nextStates.set(202);
            }
            else if (ch== '2') {
                nextStates.set(232);
            }
            return type;
        }

        static TokenType NFA_COMPOSITE_LS_CONSTANTS_44(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            TokenType type= null;
            if ((ch== '+')||(ch== '-')) {
                nextStates.set(91);
            }
            else if (ch>='0'&&ch<='9') {
                nextStates.set(490);
            }
            if (ch>='1'&&ch<='9') {
                nextStates.set(432);
            }
            return type;
        }

        static TokenType NFA_COMPOSITE_LS_CONSTANTS_45(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            TokenType type= null;
            if (ch== '0') {
                nextStates.set(234);
            }
            else if (ch== '1') {
                nextStates.set(242);
            }
            else if (ch== '2') {
                nextStates.set(239);
            }
            return type;
        }

        static TokenType NFA_COMPOSITE_LS_CONSTANTS_46(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            TokenType type= null;
            if (ch>='0'&&ch<='9') {
                nextStates.set(46);
            }
            else if ((ch== 'H')||(ch== 'h')) {
                nextStates.set(9);
                if (validTypes.contains(T_DATETIMEINTERVAL)) type= T_DATETIMEINTERVAL;
            }
            return type;
        }

        static TokenType NFA_COMPOSITE_LS_CONSTANTS_47(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            TokenType type= null;
            if (ch>='0'&&ch<='9') {
                nextStates.set(481);
            }
            if (ch>='1'&&ch<='9') {
                nextStates.set(325);
            }
            return type;
        }

        static TokenType NFA_COMPOSITE_LS_CONSTANTS_48(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            TokenType type= null;
            if (ch>='0'&&ch<='9') {
                nextStates.set(48);
            }
            else if ((ch== 'Y')||(ch== 'y')) {
                nextStates.set(8);
            }
            return type;
        }

        static TokenType NFA_COMPOSITE_LS_CONSTANTS_49(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            TokenType type= null;
            if (ch>='0'&&ch<='9') {
                nextStates.set(49);
            }
            else if ((ch== 'M')||(ch== 'm')) {
                nextStates.set(77);
            }
            return type;
        }

        static TokenType NFA_COMPOSITE_LS_CONSTANTS_50(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            TokenType type= null;
            if ((ch== '+')||(ch== '-')) {
                nextStates.set(113);
                nextStates.set(36);
            }
            else if (ch>='0'&&ch<='9') {
                nextStates.set(356);
                nextStates.set(467);
            }
            if (ch>='1'&&ch<='9') {
                nextStates.set(370);
                nextStates.set(273);
            }
            else if ((ch== 'T')||(ch== 't')) {
                nextStates.set(10);
            }
            else if (ch== '\'') {
                if (validTypes.contains(T_DURATION)) type= T_DURATION;
            }
            return type;
        }

        static TokenType NFA_COMPOSITE_LS_CONSTANTS_51(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            TokenType type= null;
            if (ch>='0'&&ch<='9') {
                nextStates.set(341);
            }
            if (ch>='1'&&ch<='9') {
                nextStates.set(333);
            }
            return type;
        }

        static TokenType NFA_COMPOSITE_LS_CONSTANTS_52(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            TokenType type= null;
            if ((ch== '+')||(ch== '-')) {
                nextStates.set(289);
                nextStates.set(72);
            }
            else if (ch>='0'&&ch<='9') {
                nextStates.set(447);
            }
            if (ch>='1'&&ch<='9') {
                nextStates.set(378);
            }
            else if ((ch== 'P')||(ch== 'p')) {
                nextStates.set(107);
            }
            return type;
        }

        static TokenType NFA_COMPOSITE_LS_CONSTANTS_53(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            TokenType type= null;
            if ((ch== '+')||(ch== '-')) {
                nextStates.set(137);
            }
            else if (ch>='0'&&ch<='9') {
                nextStates.set(349);
            }
            if (ch>='1'&&ch<='9') {
                nextStates.set(310);
            }
            return type;
        }

        static TokenType NFA_COMPOSITE_LS_CONSTANTS_54(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            TokenType type= null;
            if ((ch== '+')||(ch== '-')) {
                nextStates.set(100);
            }
            else if (ch>='0'&&ch<='9') {
                nextStates.set(409);
            }
            if (ch>='1'&&ch<='9') {
                nextStates.set(293);
            }
            return type;
        }

        static TokenType NFA_COMPOSITE_LS_CONSTANTS_55(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            TokenType type= null;
            if (ch== '-') {
                nextStates.set(130);
            }
            else if (ch>='0'&&ch<='9') {
                nextStates.set(55);
            }
            return type;
        }

        static TokenType NFA_COMPOSITE_LS_CONSTANTS_56(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            TokenType type= null;
            if ((ch== '+')||(ch== '-')) {
                nextStates.set(15);
            }
            else if (ch>='0'&&ch<='9') {
                nextStates.set(418);
            }
            if (ch>='1'&&ch<='9') {
                nextStates.set(344);
            }
            return type;
        }

        static TokenType NFA_COMPOSITE_LS_CONSTANTS_57(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            TokenType type= null;
            if (ch>='0'&&ch<='2') {
                nextStates.set(252);
            }
            else if (ch== '3') {
                nextStates.set(172);
            }
            return type;
        }

        static TokenType NFA_COMPOSITE_LS_CONSTANTS_58(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            TokenType type= null;
            if ((ch== 'F')||(ch== 'f')) {
                nextStates.set(176);
            }
            else if ((ch== 'T')||(ch== 't')) {
                nextStates.set(182);
            }
            return type;
        }

        static TokenType NFA_COMPOSITE_LS_CONSTANTS_59(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            TokenType type= null;
            if ((ch== '+')||(ch== '-')) {
                nextStates.set(141);
            }
            else if (ch>='0'&&ch<='9') {
                nextStates.set(355);
            }
            if (ch>='1'&&ch<='9') {
                nextStates.set(453);
            }
            return type;
        }

        static TokenType NFA_COMPOSITE_LS_CONSTANTS_60(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            TokenType type= null;
            if (ch>='0'&&ch<='9') {
                nextStates.set(406);
            }
            if (ch>='1'&&ch<='9') {
                nextStates.set(278);
            }
            return type;
        }

        static TokenType NFA_COMPOSITE_LS_CONSTANTS_61(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            TokenType type= null;
            if (ch>='0'&&ch<='9') {
                nextStates.set(61);
            }
            else if ((ch== 'S')||(ch== 's')) {
                nextStates.set(455);
            }
            return type;
        }

        static TokenType NFA_COMPOSITE_LS_CONSTANTS_62(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            TokenType type= null;
            if (ch>='0'&&ch<='9') {
                nextStates.set(398);
            }
            if (ch>='1'&&ch<='9') {
                nextStates.set(365);
            }
            return type;
        }

        static TokenType NFA_COMPOSITE_LS_CONSTANTS_63(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            TokenType type= null;
            if ((ch== '+')||(ch== '-')) {
                nextStates.set(133);
            }
            else if (ch>='0'&&ch<='9') {
                nextStates.set(12);
            }
            if (ch>='1'&&ch<='9') {
                nextStates.set(371);
            }
            return type;
        }

        static TokenType NFA_COMPOSITE_LS_CONSTANTS_64(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            TokenType type= null;
            if (ch== '0') {
                nextStates.set(237);
            }
            else if (ch== '1') {
                nextStates.set(260);
            }
            else if (ch== '2') {
                nextStates.set(174);
            }
            return type;
        }

        static TokenType NFA_COMPOSITE_LS_CONSTANTS_65(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            TokenType type= null;
            if ((ch== '+')||(ch== '-')) {
                nextStates.set(137);
                nextStates.set(51);
                nextStates.set(80);
                nextStates.set(62);
            }
            else if (ch>='0'&&ch<='9') {
                nextStates.set(398);
                nextStates.set(341);
                nextStates.set(349);
                nextStates.set(465);
            }
            if (ch>='1'&&ch<='9') {
                nextStates.set(333);
                nextStates.set(373);
                nextStates.set(310);
                nextStates.set(365);
            }
            else if ((ch== 'T')||(ch== 't')) {
                nextStates.set(120);
                if (validTypes.contains(T_DATETIMEINTERVAL)) type= T_DATETIMEINTERVAL;
            }
            return type;
        }

        static TokenType NFA_COMPOSITE_LS_CONSTANTS_66(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            TokenType type= null;
            if ((ch== '+')||(ch== '-')) {
                nextStates.set(133);
            }
            else if (ch>='0'&&ch<='9') {
                nextStates.set(12);
            }
            if (ch>='1'&&ch<='9') {
                nextStates.set(371);
            }
            else if (ch== '\'') {
                if (validTypes.contains(T_DURATION)) type= T_DURATION;
            }
            return type;
        }

        static TokenType NFA_COMPOSITE_LS_CONSTANTS_67(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            TokenType type= null;
            if ((ch== '+')||(ch== '-')) {
                nextStates.set(64);
            }
            else if (ch== ':') {
                nextStates.set(179);
            }
            else if ((ch== 'Z')||(ch== 'z')) {
                nextStates.set(375);
            }
            return type;
        }

        static TokenType NFA_COMPOSITE_LS_CONSTANTS_68(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            TokenType type= null;
            if (ch>='0'&&ch<='9') {
                nextStates.set(68);
            }
            else if ((ch== 'D')||(ch== 'd')) {
                nextStates.set(151);
            }
            return type;
        }

        static TokenType NFA_COMPOSITE_LS_CONSTANTS_69(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            TokenType type= null;
            if ((ch== '+')||(ch== '-')) {
                nextStates.set(123);
            }
            else if (ch>='1'&&ch<='9') {
                nextStates.set(201);
            }
            if (ch>='0'&&ch<='9') {
                if (validTypes.contains(T_LONG)) type= T_LONG;
            }
            return type;
        }

        static TokenType NFA_COMPOSITE_LS_CONSTANTS_70(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            TokenType type= null;
            if ((ch== '+')||(ch== '-')) {
                nextStates.set(80);
                nextStates.set(51);
            }
            else if (ch>='0'&&ch<='9') {
                nextStates.set(465);
                nextStates.set(341);
            }
            if (ch>='1'&&ch<='9') {
                nextStates.set(333);
                nextStates.set(373);
            }
            else if ((ch== 'T')||(ch== 't')) {
                nextStates.set(120);
                if (validTypes.contains(T_DATETIMEINTERVAL)) type= T_DATETIMEINTERVAL;
            }
            return type;
        }

        static TokenType NFA_COMPOSITE_LS_CONSTANTS_71(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            TokenType type= null;
            if ((ch== '+')||(ch== '-')) {
                nextStates.set(18);
                nextStates.set(27);
            }
            else if (ch== '/') {
                nextStates.set(34);
            }
            else if (ch>='0'&&ch<='9') {
                nextStates.set(317);
                nextStates.set(287);
            }
            if (ch>='1'&&ch<='9') {
                nextStates.set(479);
                nextStates.set(477);
            }
            else if ((ch== 'T')||(ch== 't')) {
                nextStates.set(37);
            }
            return type;
        }

        static TokenType NFA_COMPOSITE_LS_CONSTANTS_72(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            TokenType type= null;
            if (ch>='0'&&ch<='9') {
                nextStates.set(447);
            }
            if (ch>='1'&&ch<='9') {
                nextStates.set(378);
            }
            return type;
        }

        static TokenType NFA_COMPOSITE_LS_CONSTANTS_73(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            TokenType type= null;
            if (ch>='0'&&ch<='9') {
                nextStates.set(73);
            }
            else if ((ch== 'S')||(ch== 's')) {
                nextStates.set(375);
            }
            return type;
        }

        static TokenType NFA_COMPOSITE_LS_CONSTANTS_74(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            TokenType type= null;
            if (ch>='0'&&ch<='9') {
                nextStates.set(74);
            }
            else if ((ch== 'W')||(ch== 'w')) {
                nextStates.set(152);
            }
            return type;
        }

        static TokenType NFA_COMPOSITE_LS_CONSTANTS_75(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            TokenType type= null;
            if (ch== ',') {
                nextStates.set(336);
            }
            else if (ch== '.') {
                nextStates.set(336);
            }
            return type;
        }

        static TokenType NFA_COMPOSITE_LS_CONSTANTS_76(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            TokenType type= null;
            if ((ch== '+')||(ch== '-')) {
                nextStates.set(143);
            }
            else if (ch>='0'&&ch<='9') {
                nextStates.set(358);
            }
            if (ch>='1'&&ch<='9') {
                nextStates.set(360);
            }
            return type;
        }

        static TokenType NFA_COMPOSITE_LS_CONSTANTS_77(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            TokenType type= null;
            if ((ch== '+')||(ch== '-')) {
                nextStates.set(23);
            }
            else if (ch== '/') {
                nextStates.set(34);
            }
            else if (ch>='0'&&ch<='9') {
                nextStates.set(147);
            }
            if (ch>='1'&&ch<='9') {
                nextStates.set(338);
            }
            return type;
        }

        static TokenType NFA_COMPOSITE_LS_CONSTANTS_78(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            TokenType type= null;
            if (ch== '.') {
                nextStates.set(76);
            }
            else if (ch>='0'&&ch<='9') {
                nextStates.set(78);
            }
            else if ((ch== 'S')||(ch== 's')) {
                if (validTypes.contains(T_DATETIMEINTERVAL)) type= T_DATETIMEINTERVAL;
            }
            return type;
        }

        static TokenType NFA_COMPOSITE_LS_CONSTANTS_79(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            TokenType type= null;
            if (ch== '0') {
                nextStates.set(203);
            }
            else if (ch== '1') {
                nextStates.set(240);
            }
            else if (ch== '2') {
                nextStates.set(216);
            }
            return type;
        }

        static TokenType NFA_COMPOSITE_LS_CONSTANTS_80(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            TokenType type= null;
            if (ch>='0'&&ch<='9') {
                nextStates.set(465);
            }
            if (ch>='1'&&ch<='9') {
                nextStates.set(373);
            }
            return type;
        }

        static TokenType NFA_COMPOSITE_LS_CONSTANTS_81(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            TokenType type= null;
            if ((ch== '+')||(ch== '-')) {
                nextStates.set(27);
            }
            else if (ch>='0'&&ch<='9') {
                nextStates.set(317);
            }
            if (ch>='1'&&ch<='9') {
                nextStates.set(479);
            }
            return type;
        }

        static TokenType NFA_COMPOSITE_LS_CONSTANTS_82(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            TokenType type= null;
            if ((ch== '+')||(ch== '-')) {
                nextStates.set(23);
            }
            else if (ch>='0'&&ch<='9') {
                nextStates.set(147);
            }
            if (ch>='1'&&ch<='9') {
                nextStates.set(338);
            }
            return type;
        }

        static TokenType NFA_COMPOSITE_LS_CONSTANTS_83(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            TokenType type= null;
            if ((ch== '+')||(ch== '-')) {
                nextStates.set(2);
            }
            else if (ch>='0'&&ch<='9') {
                nextStates.set(268);
            }
            if (ch>='1'&&ch<='9') {
                nextStates.set(416);
            }
            return type;
        }

        static TokenType NFA_COMPOSITE_LS_CONSTANTS_84(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            TokenType type= null;
            if (ch>='0'&&ch<='9') {
                nextStates.set(84);
            }
            else if ((ch== 'S')||(ch== 's')) {
                if (validTypes.contains(T_DATETIMEINTERVAL)) type= T_DATETIMEINTERVAL;
            }
            return type;
        }

        static TokenType NFA_COMPOSITE_LS_CONSTANTS_85(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            TokenType type= null;
            if ((ch>=0x0&&ch<='&')||(ch>='(')) {
                nextStates.set(24);
            }
            else if (ch== '\'') {
                nextStates.set(233);
            }
            return type;
        }

        static TokenType NFA_COMPOSITE_LS_CONSTANTS_86(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            TokenType type= null;
            if ((ch== '+')||(ch== '-')) {
                nextStates.set(289);
            }
            else if ((ch== 'P')||(ch== 'p')) {
                nextStates.set(107);
            }
            return type;
        }

        static TokenType NFA_COMPOSITE_LS_CONSTANTS_87(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            TokenType type= null;
            if ((ch== '+')||(ch== '-')) {
                nextStates.set(323);
            }
            else if ((ch== 'P')||(ch== 'p')) {
                nextStates.set(65);
                if (validTypes.contains(T_DATETIMEINTERVAL)) type= T_DATETIMEINTERVAL;
            }
            return type;
        }

        static TokenType NFA_COMPOSITE_LS_CONSTANTS_88(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            TokenType type= null;
            if (ch>='0'&&ch<='9') {
                nextStates.set(21);
            }
            if (ch>='1'&&ch<='9') {
                nextStates.set(459);
            }
            return type;
        }

        static TokenType NFA_COMPOSITE_LS_CONSTANTS_89(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            TokenType type= null;
            if (ch== '0') {
                nextStates.set(244);
            }
            else if (ch== '1') {
                nextStates.set(219);
            }
            return type;
        }

        static TokenType NFA_COMPOSITE_LS_CONSTANTS_90(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            TokenType type= null;
            if ((ch== '+')||(ch== '-')) {
                nextStates.set(18);
            }
            else if (ch>='0'&&ch<='9') {
                nextStates.set(287);
            }
            if (ch>='1'&&ch<='9') {
                nextStates.set(477);
            }
            return type;
        }

        static TokenType NFA_COMPOSITE_LS_CONSTANTS_91(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            TokenType type= null;
            if (ch>='0'&&ch<='9') {
                nextStates.set(490);
            }
            if (ch>='1'&&ch<='9') {
                nextStates.set(432);
            }
            return type;
        }

        static TokenType NFA_COMPOSITE_LS_CONSTANTS_92(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            TokenType type= null;
            if (ch>='0'&&ch<='2') {
                nextStates.set(257);
            }
            else if (ch== '3') {
                nextStates.set(171);
            }
            return type;
        }

        static TokenType NFA_COMPOSITE_LS_CONSTANTS_93(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            TokenType type= null;
            if ((ch== '+')||(ch== '-')) {
                nextStates.set(31);
            }
            else if (ch>='0'&&ch<='9') {
                nextStates.set(93);
            }
            else if ((ch== 'Z')||(ch== 'z')) {
                if (validTypes.contains(T_DATETIME)) type= T_DATETIME;
            }
            return type;
        }

        static TokenType NFA_COMPOSITE_LS_CONSTANTS_94(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            TokenType type= null;
            if ((ch== '+')||(ch== '-')) {
                nextStates.set(98);
            }
            else if (ch>='0'&&ch<='9') {
                nextStates.set(299);
            }
            if (ch>='1'&&ch<='9') {
                nextStates.set(347);
            }
            return type;
        }

        static TokenType NFA_COMPOSITE_LS_CONSTANTS_95(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            TokenType type= null;
            if (ch== '.') {
                nextStates.set(353);
            }
            else if ((ch== 'E')||(ch== 'e')) {
                nextStates.set(139);
            }
            return type;
        }

        static TokenType NFA_COMPOSITE_LS_CONSTANTS_96(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            TokenType type= null;
            if ((ch== '+')||(ch== '-')) {
                nextStates.set(3);
            }
            else if (ch>='1'&&ch<='9') {
                nextStates.set(339);
            }
            if (ch>='0'&&ch<='9') {
                nextStates.set(95);
                if (validTypes.contains(T_DOUBLE)) type= T_DOUBLE;
            }
            return type;
        }

        static TokenType NFA_COMPOSITE_LS_CONSTANTS_97(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            TokenType type= null;
            if (ch== '-') {
                nextStates.set(41);
            }
            else if (ch>='0'&&ch<='9') {
                nextStates.set(97);
            }
            return type;
        }

        static TokenType NFA_COMPOSITE_LS_CONSTANTS_98(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            TokenType type= null;
            if (ch>='0'&&ch<='9') {
                nextStates.set(299);
            }
            if (ch>='1'&&ch<='9') {
                nextStates.set(347);
            }
            return type;
        }

        static TokenType NFA_COMPOSITE_LS_CONSTANTS_99(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            TokenType type= null;
            if (ch== '0') {
                nextStates.set(238);
            }
            else if (ch== '1') {
                nextStates.set(188);
            }
            else if (ch== '2') {
                nextStates.set(245);
            }
            return type;
        }

        static TokenType NFA_COMPOSITE_LS_CONSTANTS_100(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            TokenType type= null;
            if (ch>='0'&&ch<='9') {
                nextStates.set(409);
            }
            if (ch>='1'&&ch<='9') {
                nextStates.set(293);
            }
            return type;
        }

        static TokenType NFA_COMPOSITE_LS_CONSTANTS_101(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            TokenType type= null;
            if ((ch== '+')||(ch== '-')) {
                nextStates.set(80);
            }
            else if (ch>='0'&&ch<='9') {
                nextStates.set(465);
            }
            if (ch>='1'&&ch<='9') {
                nextStates.set(373);
            }
            return type;
        }

        static TokenType NFA_COMPOSITE_LS_CONSTANTS_102(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            TokenType type= null;
            if ((ch== '+')||(ch== '-')) {
                nextStates.set(64);
            }
            else if ((ch== 'Z')||(ch== 'z')) {
                nextStates.set(375);
            }
            return type;
        }

        static TokenType NFA_COMPOSITE_LS_CONSTANTS_103(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            TokenType type= null;
            if (ch>='0'&&ch<='9') {
                nextStates.set(103);
            }
            else if ((ch== 'Y')||(ch== 'y')) {
                nextStates.set(5);
            }
            return type;
        }

        static TokenType NFA_COMPOSITE_LS_CONSTANTS_104(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            TokenType type= null;
            if (ch>='0'&&ch<='9') {
                nextStates.set(104);
            }
            else if ((ch== 'M')||(ch== 'm')) {
                nextStates.set(50);
            }
            return type;
        }

        static TokenType NFA_COMPOSITE_LS_CONSTANTS_105(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            TokenType type= null;
            if (ch>='0'&&ch<='2') {
                nextStates.set(200);
            }
            else if (ch== '3') {
                nextStates.set(195);
            }
            return type;
        }

        static TokenType NFA_COMPOSITE_LS_CONSTANTS_106(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            TokenType type= null;
            if ((ch== '+')||(ch== '-')) {
                nextStates.set(14);
            }
            else if (ch>='0'&&ch<='9') {
                nextStates.set(383);
            }
            if (ch>='1'&&ch<='9') {
                nextStates.set(385);
            }
            return type;
        }

        static TokenType NFA_COMPOSITE_LS_CONSTANTS_107(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            TokenType type= null;
            if ((ch== '+')||(ch== '-')) {
                nextStates.set(2);
                nextStates.set(18);
                nextStates.set(27);
                nextStates.set(22);
            }
            else if (ch== '/') {
                nextStates.set(34);
            }
            else if (ch>='0'&&ch<='9') {
                nextStates.set(342);
                nextStates.set(268);
                nextStates.set(317);
                nextStates.set(287);
            }
            if (ch>='1'&&ch<='9') {
                nextStates.set(479);
                nextStates.set(477);
                nextStates.set(416);
                nextStates.set(311);
            }
            else if ((ch== 'T')||(ch== 't')) {
                nextStates.set(37);
            }
            return type;
        }

        static TokenType NFA_COMPOSITE_LS_CONSTANTS_108(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            TokenType type= null;
            if ((ch== '+')||(ch== '-')) {
                nextStates.set(88);
            }
            else if (ch>='0'&&ch<='9') {
                nextStates.set(21);
            }
            if (ch>='1'&&ch<='9') {
                nextStates.set(459);
            }
            return type;
        }

        static TokenType NFA_COMPOSITE_LS_CONSTANTS_109(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            TokenType type= null;
            if (ch>='0'&&ch<='9') {
                nextStates.set(457);
            }
            if (ch>='1'&&ch<='9') {
                nextStates.set(430);
            }
            return type;
        }

        static TokenType NFA_COMPOSITE_LS_CONSTANTS_110(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            TokenType type= null;
            if (ch>='0'&&ch<='9') {
                nextStates.set(110);
            }
            else if ((ch== 'Y')||(ch== 'y')) {
                nextStates.set(144);
                if (validTypes.contains(T_DATETIMEINTERVAL)) type= T_DATETIMEINTERVAL;
            }
            return type;
        }

        static TokenType NFA_COMPOSITE_LS_CONSTANTS_111(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            TokenType type= null;
            if ((ch== '+')||(ch== '-')) {
                nextStates.set(31);
            }
            else if (ch== ':') {
                nextStates.set(236);
            }
            else if ((ch== 'Z')||(ch== 'z')) {
                if (validTypes.contains(T_DATETIME)) type= T_DATETIME;
            }
            return type;
        }

        static TokenType NFA_COMPOSITE_LS_CONSTANTS_112(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            TokenType type= null;
            if (ch>='0'&&ch<='9') {
                nextStates.set(474);
            }
            if (ch>='1'&&ch<='9') {
                nextStates.set(483);
            }
            return type;
        }

        static TokenType NFA_COMPOSITE_LS_CONSTANTS_113(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            TokenType type= null;
            if (ch>='0'&&ch<='9') {
                nextStates.set(356);
            }
            if (ch>='1'&&ch<='9') {
                nextStates.set(273);
            }
            return type;
        }

        static TokenType NFA_COMPOSITE_LS_CONSTANTS_114(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            TokenType type= null;
            if (ch>='0'&&ch<='9') {
                nextStates.set(114);
            }
            else if ((ch== 'W')||(ch== 'w')) {
                nextStates.set(140);
                if (validTypes.contains(T_DATETIMEINTERVAL)) type= T_DATETIMEINTERVAL;
            }
            return type;
        }

        static TokenType NFA_COMPOSITE_LS_CONSTANTS_115(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            TokenType type= null;
            if ((ch== '+')||(ch== '-')) {
                nextStates.set(113);
            }
            else if (ch>='0'&&ch<='9') {
                nextStates.set(356);
            }
            if (ch>='1'&&ch<='9') {
                nextStates.set(273);
            }
            return type;
        }

        static TokenType NFA_COMPOSITE_LS_CONSTANTS_116(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            TokenType type= null;
            if (ch>='0'&&ch<='9') {
                nextStates.set(116);
            }
            else if ((ch== 'H')||(ch== 'h')) {
                nextStates.set(146);
            }
            return type;
        }

        static TokenType NFA_COMPOSITE_LS_CONSTANTS_117(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            TokenType type= null;
            if (ch>='0'&&ch<='9') {
                nextStates.set(117);
            }
            else if ((ch== 'M')||(ch== 'm')) {
                nextStates.set(71);
            }
            return type;
        }

        static TokenType NFA_COMPOSITE_LS_CONSTANTS_118(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            TokenType type= null;
            if ((ch== '+')||(ch== '-')) {
                nextStates.set(31);
            }
            else if (ch== ',') {
                nextStates.set(433);
            }
            else if (ch== '.') {
                nextStates.set(433);
            }
            else if ((ch== 'Z')||(ch== 'z')) {
                if (validTypes.contains(T_DATETIME)) type= T_DATETIME;
            }
            return type;
        }

        static TokenType NFA_COMPOSITE_LS_CONSTANTS_119(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            TokenType type= null;
            if ((ch== '+')||(ch== '-')) {
                nextStates.set(64);
            }
            else if (ch>='0'&&ch<='9') {
                nextStates.set(119);
            }
            else if ((ch== 'Z')||(ch== 'z')) {
                nextStates.set(375);
            }
            return type;
        }

        static TokenType NFA_COMPOSITE_LS_CONSTANTS_120(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            TokenType type= null;
            if ((ch== '+')||(ch== '-')) {
                nextStates.set(88);
                nextStates.set(47);
                nextStates.set(60);
            }
            else if (ch>='0'&&ch<='9') {
                nextStates.set(481);
                nextStates.set(406);
                nextStates.set(21);
            }
            if (ch>='1'&&ch<='9') {
                nextStates.set(459);
                nextStates.set(278);
                nextStates.set(325);
            }
            return type;
        }

        static TokenType NFA_COMPOSITE_LS_CONSTANTS_121(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            TokenType type= null;
            if ((ch== 'T')||(ch== 't')) {
                nextStates.set(10);
            }
            else if (ch== '\'') {
                if (validTypes.contains(T_DURATION)) type= T_DURATION;
            }
            return type;
        }

        static TokenType NFA_COMPOSITE_LS_CONSTANTS_122(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            TokenType type= null;
            if ((ch== '+')||(ch== '-')) {
                nextStates.set(40);
            }
            else if (ch>='0'&&ch<='9') {
                nextStates.set(471);
            }
            if (ch>='1'&&ch<='9') {
                nextStates.set(469);
            }
            return type;
        }

        static TokenType NFA_COMPOSITE_LS_CONSTANTS_123(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            TokenType type= null;
            if (ch>='1'&&ch<='9') {
                nextStates.set(201);
            }
            if (ch>='0'&&ch<='9') {
                if (validTypes.contains(T_LONG)) type= T_LONG;
            }
            return type;
        }

        static TokenType NFA_COMPOSITE_LS_CONSTANTS_124(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            TokenType type= null;
            if (ch== '-') {
                nextStates.set(35);
            }
            else if (ch>='0'&&ch<='9') {
                nextStates.set(124);
            }
            return type;
        }

        static TokenType NFA_COMPOSITE_LS_CONSTANTS_125(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            TokenType type= null;
            if ((ch== '+')||(ch== '-')) {
                nextStates.set(112);
            }
            else if (ch>='0'&&ch<='9') {
                nextStates.set(474);
            }
            if (ch>='1'&&ch<='9') {
                nextStates.set(483);
            }
            return type;
        }

        static TokenType NFA_COMPOSITE_LS_CONSTANTS_126(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            TokenType type= null;
            if ((ch== 'E')||(ch== 'e')) {
                nextStates.set(139);
            }
            else if (ch>='0'&&ch<='9') {
                nextStates.set(126);
                if (validTypes.contains(T_DOUBLE)) type= T_DOUBLE;
            }
            return type;
        }

        static TokenType NFA_COMPOSITE_LS_CONSTANTS_127(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            TokenType type= null;
            if ((ch== '+')||(ch== '-')) {
                nextStates.set(91);
                nextStates.set(133);
            }
            else if (ch>='0'&&ch<='9') {
                nextStates.set(490);
                nextStates.set(12);
            }
            if (ch>='1'&&ch<='9') {
                nextStates.set(371);
                nextStates.set(432);
            }
            else if (ch== '\'') {
                if (validTypes.contains(T_DURATION)) type= T_DURATION;
            }
            return type;
        }

        static TokenType NFA_COMPOSITE_LS_CONSTANTS_128(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            TokenType type= null;
            if (ch>='0'&&ch<='9') {
                nextStates.set(128);
            }
            else if ((ch== 'M')||(ch== 'm')) {
                nextStates.set(70);
                if (validTypes.contains(T_DATETIMEINTERVAL)) type= T_DATETIMEINTERVAL;
            }
            return type;
        }

        static TokenType NFA_COMPOSITE_LS_CONSTANTS_129(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            TokenType type= null;
            if (ch>='0'&&ch<='9') {
                nextStates.set(129);
            }
            else if ((ch== 'M')||(ch== 'm')) {
                nextStates.set(108);
                if (validTypes.contains(T_DATETIMEINTERVAL)) type= T_DATETIMEINTERVAL;
            }
            return type;
        }

        static TokenType NFA_COMPOSITE_LS_CONSTANTS_130(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            TokenType type= null;
            if (ch== '0') {
                nextStates.set(194);
            }
            else if (ch== '1') {
                nextStates.set(168);
            }
            return type;
        }

        static TokenType NFA_COMPOSITE_LS_CONSTANTS_131(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            TokenType type= null;
            if (ch== '-') {
                nextStates.set(89);
            }
            else if (ch>='0'&&ch<='9') {
                nextStates.set(131);
            }
            return type;
        }

        static TokenType NFA_COMPOSITE_LS_CONSTANTS_132(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            TokenType type= null;
            if (ch>='0'&&ch<='9') {
                nextStates.set(132);
            }
            else if ((ch== 'W')||(ch== 'w')) {
                nextStates.set(32);
            }
            return type;
        }

        static TokenType NFA_COMPOSITE_LS_CONSTANTS_133(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            TokenType type= null;
            if (ch>='0'&&ch<='9') {
                nextStates.set(12);
            }
            if (ch>='1'&&ch<='9') {
                nextStates.set(371);
            }
            return type;
        }

        static TokenType NFA_COMPOSITE_LS_CONSTANTS_134(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            TokenType type= null;
            if (ch>='0'&&ch<='2') {
                nextStates.set(186);
            }
            else if (ch== '3') {
                nextStates.set(189);
            }
            return type;
        }

        static TokenType NFA_COMPOSITE_LS_CONSTANTS_135(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            TokenType type= null;
            if ((ch== '+')||(ch== '-')) {
                nextStates.set(64);
            }
            else if (ch== ',') {
                nextStates.set(336);
            }
            else if (ch== '.') {
                nextStates.set(336);
            }
            else if ((ch== 'Z')||(ch== 'z')) {
                nextStates.set(375);
            }
            return type;
        }

        static TokenType NFA_COMPOSITE_LS_CONSTANTS_136(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            TokenType type= null;
            if (ch>='0'&&ch<='9') {
                nextStates.set(451);
            }
            if (ch>='1'&&ch<='9') {
                nextStates.set(436);
            }
            return type;
        }

        static TokenType NFA_COMPOSITE_LS_CONSTANTS_137(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            TokenType type= null;
            if (ch>='0'&&ch<='9') {
                nextStates.set(349);
            }
            if (ch>='1'&&ch<='9') {
                nextStates.set(310);
            }
            return type;
        }

        static TokenType NFA_COMPOSITE_LS_CONSTANTS_138(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            TokenType type= null;
            if ((ch== '+')||(ch== '-')) {
                nextStates.set(47);
            }
            else if (ch>='0'&&ch<='9') {
                nextStates.set(481);
            }
            if (ch>='1'&&ch<='9') {
                nextStates.set(325);
            }
            return type;
        }

        static TokenType NFA_COMPOSITE_LS_CONSTANTS_139(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            TokenType type= null;
            if (ch== '-') {
                nextStates.set(462);
            }
            else if (ch>='0'&&ch<='9') {
                nextStates.set(462);
                if (validTypes.contains(T_DOUBLE)) type= T_DOUBLE;
            }
            return type;
        }

        static TokenType NFA_COMPOSITE_LS_CONSTANTS_140(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            TokenType type= null;
            if ((ch== '+')||(ch== '-')) {
                nextStates.set(51);
            }
            else if (ch>='0'&&ch<='9') {
                nextStates.set(341);
            }
            if (ch>='1'&&ch<='9') {
                nextStates.set(333);
            }
            else if ((ch== 'T')||(ch== 't')) {
                nextStates.set(120);
                if (validTypes.contains(T_DATETIMEINTERVAL)) type= T_DATETIMEINTERVAL;
            }
            return type;
        }

        static TokenType NFA_COMPOSITE_LS_CONSTANTS_141(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            TokenType type= null;
            if (ch>='0'&&ch<='9') {
                nextStates.set(355);
            }
            if (ch>='1'&&ch<='9') {
                nextStates.set(453);
            }
            return type;
        }

        static TokenType NFA_COMPOSITE_LS_CONSTANTS_142(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            TokenType type= null;
            if (ch>='0'&&ch<='9') {
                nextStates.set(142);
            }
            else if ((ch== 'M')||(ch== 'm')) {
                nextStates.set(66);
            }
            return type;
        }

        static TokenType NFA_COMPOSITE_LS_CONSTANTS_143(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            TokenType type= null;
            if (ch>='0'&&ch<='9') {
                nextStates.set(358);
            }
            if (ch>='1'&&ch<='9') {
                nextStates.set(360);
            }
            return type;
        }

        static TokenType NFA_COMPOSITE_LS_CONSTANTS_144(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            TokenType type= null;
            if ((ch== '+')||(ch== '-')) {
                nextStates.set(80);
                nextStates.set(62);
                nextStates.set(51);
            }
            else if (ch>='0'&&ch<='9') {
                nextStates.set(398);
                nextStates.set(465);
                nextStates.set(341);
            }
            if (ch>='1'&&ch<='9') {
                nextStates.set(333);
                nextStates.set(373);
                nextStates.set(365);
            }
            else if ((ch== 'T')||(ch== 't')) {
                nextStates.set(120);
                if (validTypes.contains(T_DATETIMEINTERVAL)) type= T_DATETIMEINTERVAL;
            }
            return type;
        }

        static TokenType NFA_COMPOSITE_LS_CONSTANTS_145(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            TokenType type= null;
            if ((ch== '+')||(ch== '-')) {
                nextStates.set(60);
            }
            else if (ch>='0'&&ch<='9') {
                nextStates.set(406);
            }
            if (ch>='1'&&ch<='9') {
                nextStates.set(278);
            }
            return type;
        }

        static TokenType NFA_COMPOSITE_LS_CONSTANTS_146(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            TokenType type= null;
            if ((ch== '+')||(ch== '-')) {
                nextStates.set(40);
                nextStates.set(23);
            }
            else if (ch== '/') {
                nextStates.set(34);
            }
            else if (ch>='0'&&ch<='9') {
                nextStates.set(471);
                nextStates.set(147);
            }
            if (ch>='1'&&ch<='9') {
                nextStates.set(469);
                nextStates.set(338);
            }
            return type;
        }

        static TokenType NFA_COMPOSITE_LS_CONSTANTS_147(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            TokenType type= null;
            if (ch== '.') {
                nextStates.set(150);
            }
            else if ((ch== 'S')||(ch== 's')) {
                nextStates.set(375);
            }
            return type;
        }

        static TokenType NFA_COMPOSITE_LS_CONSTANTS_148(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            TokenType type= null;
            if ((ch== '+')||(ch== '-')) {
                nextStates.set(31);
            }
            else if ((ch== 'Z')||(ch== 'z')) {
                if (validTypes.contains(T_DATETIME)) type= T_DATETIME;
            }
            return type;
        }

        static TokenType NFA_COMPOSITE_LS_CONSTANTS_149(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            TokenType type= null;
            if ((ch== '+')||(ch== '-')) {
                nextStates.set(72);
            }
            else if (ch>='0'&&ch<='9') {
                nextStates.set(447);
            }
            if (ch>='1'&&ch<='9') {
                nextStates.set(378);
            }
            return type;
        }

        static TokenType NFA_COMPOSITE_LS_CONSTANTS_150(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            TokenType type= null;
            if ((ch== '+')||(ch== '-')) {
                nextStates.set(109);
            }
            else if (ch>='0'&&ch<='9') {
                nextStates.set(457);
            }
            if (ch>='1'&&ch<='9') {
                nextStates.set(430);
            }
            return type;
        }

        static TokenType NFA_COMPOSITE_LS_CONSTANTS_151(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            TokenType type= null;
            if (ch== '/') {
                nextStates.set(34);
            }
            else if ((ch== 'T')||(ch== 't')) {
                nextStates.set(37);
            }
            return type;
        }

        static TokenType NFA_COMPOSITE_LS_CONSTANTS_152(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            TokenType type= null;
            if ((ch== '+')||(ch== '-')) {
                nextStates.set(27);
            }
            else if (ch== '/') {
                nextStates.set(34);
            }
            else if (ch>='0'&&ch<='9') {
                nextStates.set(317);
            }
            if (ch>='1'&&ch<='9') {
                nextStates.set(479);
            }
            else if ((ch== 'T')||(ch== 't')) {
                nextStates.set(37);
            }
            return type;
        }

        static TokenType NFA_COMPOSITE_LS_CONSTANTS_153(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            TokenType type= null;
            if (ch>='0'&&ch<='9') {
                nextStates.set(326);
            }
            if (ch>='1'&&ch<='9') {
                nextStates.set(280);
            }
            return type;
        }

        static TokenType NFA_COMPOSITE_LS_CONSTANTS_154(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            TokenType type= null;
            if ((ch== '+')||(ch== '-')) {
                nextStates.set(136);
            }
            else if (ch>='0'&&ch<='9') {
                nextStates.set(451);
            }
            if (ch>='1'&&ch<='9') {
                nextStates.set(436);
            }
            return type;
        }

        static TokenType NFA_COMPOSITE_LS_CONSTANTS_155(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            TokenType type= null;
            if (ch>='0'&&ch<='9') {
                nextStates.set(155);
            }
            else if ((ch== 'D')||(ch== 'd')) {
                nextStates.set(435);
                if (validTypes.contains(T_DATETIMEINTERVAL)) type= T_DATETIMEINTERVAL;
            }
            return type;
        }

        static TokenType NFA_COMPOSITE_LS_CONSTANTS_156(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            TokenType type= null;
            if ((ch== '+')||(ch== '-')) {
                nextStates.set(36);
            }
            else if (ch>='0'&&ch<='9') {
                nextStates.set(467);
            }
            if (ch>='1'&&ch<='9') {
                nextStates.set(370);
            }
            return type;
        }

        static TokenType NFA_COMPOSITE_LS_CONSTANTS_157(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            TokenType type= null;
            if ((ch== '+')||(ch== '-')) {
                nextStates.set(417);
            }
            else if ((ch== 'P')||(ch== 'p')) {
                nextStates.set(7);
            }
            return type;
        }

        static TokenType NFA_LS_CONSTANTS_158(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'D')||(ch== 'd')) {
                nextStates.set(254);
            }
            return null;
        }

        static TokenType NFA_LS_CONSTANTS_159(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'N')||(ch== 'n')) {
                nextStates.set(243);
            }
            return null;
        }

        static TokenType NFA_LS_CONSTANTS_160(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch>='0'&&ch<='9') {
                nextStates.set(205);
                if (validTypes.contains(T_TIME)) return T_TIME;
            }
            return null;
        }

        static TokenType NFA_LS_CONSTANTS_161(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch>='0'&&ch<='9') {
                nextStates.set(248);
            }
            return null;
        }

        static TokenType NFA_LS_CONSTANTS_162(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch== '-') {
                nextStates.set(92);
            }
            return null;
        }

        static TokenType NFA_LS_CONSTANTS_163(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch== ':') {
                nextStates.set(227);
            }
            return null;
        }

        static TokenType NFA_LS_CONSTANTS_164(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch>='0'&&ch<='2') {
                nextStates.set(184);
            }
            return null;
        }

        static TokenType NFA_LS_CONSTANTS_165(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch>='0'&&ch<='5') {
                nextStates.set(241);
            }
            return null;
        }

        static TokenType NFA_LS_CONSTANTS_166(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch>='0'&&ch<='9') {
                nextStates.set(375);
            }
            return null;
        }

        static TokenType NFA_LS_CONSTANTS_167(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch>='0'&&ch<='9') {
                nextStates.set(163);
            }
            return null;
        }

        static TokenType NFA_LS_CONSTANTS_168(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch>='0'&&ch<='2') {
                nextStates.set(162);
            }
            return null;
        }

        static TokenType NFA_LS_CONSTANTS_169(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch>='0'&&ch<='5') {
                nextStates.set(160);
            }
            return null;
        }

        static TokenType NFA_LS_CONSTANTS_170(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'I')||(ch== 'i')) {
                nextStates.set(222);
            }
            return null;
        }

        static TokenType NFA_LS_CONSTANTS_171(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch== '0'||ch== '1') {
                nextStates.set(180);
            }
            return null;
        }

        static TokenType NFA_LS_CONSTANTS_172(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch== '0'||ch== '1') {
                if (validTypes.contains(T_DATE)) return T_DATE;
            }
            return null;
        }

        static TokenType NFA_LS_CONSTANTS_173(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch== '\t') {
                if (validTypes.contains(_TOKEN_4)) return _TOKEN_4;
            }
            return null;
        }

        static TokenType NFA_LS_CONSTANTS_174(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch>='0'&&ch<='3') {
                nextStates.set(175);
            }
            return null;
        }

        static TokenType NFA_LS_CONSTANTS_175(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch== ':') {
                nextStates.set(265);
            }
            return null;
        }

        static TokenType NFA_LS_CONSTANTS_176(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'A')||(ch== 'a')) {
                nextStates.set(178);
            }
            return null;
        }

        static TokenType NFA_LS_CONSTANTS_177(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'R')||(ch== 'r')) {
                nextStates.set(249);
            }
            return null;
        }

        static TokenType NFA_LS_CONSTANTS_178(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'L')||(ch== 'l')) {
                nextStates.set(228);
            }
            return null;
        }

        static TokenType NFA_LS_CONSTANTS_179(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch>='0'&&ch<='5') {
                nextStates.set(224);
            }
            return null;
        }

        static TokenType NFA_LS_CONSTANTS_180(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'T')||(ch== 't')) {
                nextStates.set(43);
            }
            return null;
        }

        static TokenType NFA_LS_CONSTANTS_181(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'T')||(ch== 't')) {
                nextStates.set(38);
            }
            return null;
        }

        static TokenType NFA_LS_CONSTANTS_182(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'R')||(ch== 'r')) {
                nextStates.set(225);
            }
            return null;
        }

        static TokenType NFA_LS_CONSTANTS_183(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'A')||(ch== 'a')) {
                nextStates.set(215);
            }
            return null;
        }

        static TokenType NFA_LS_CONSTANTS_184(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch== '-') {
                nextStates.set(57);
            }
            return null;
        }

        static TokenType NFA_LS_CONSTANTS_185(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch>='0'&&ch<='9') {
                nextStates.set(184);
            }
            return null;
        }

        static TokenType NFA_LS_CONSTANTS_186(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch>='0'&&ch<='9') {
                nextStates.set(256);
            }
            return null;
        }

        static TokenType NFA_LS_CONSTANTS_187(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'H')||(ch== 'h')) {
                nextStates.set(207);
            }
            return null;
        }

        static TokenType NFA_LS_CONSTANTS_188(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch>='0'&&ch<='9') {
                nextStates.set(226);
            }
            return null;
        }

        static TokenType NFA_LS_CONSTANTS_189(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch== '0'||ch== '1') {
                nextStates.set(256);
            }
            return null;
        }

        static TokenType NFA_LS_CONSTANTS_190(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch>='0'&&ch<='9') {
                nextStates.set(111);
            }
            return null;
        }

        static TokenType NFA_LS_CONSTANTS_191(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch>='0'&&ch<='5') {
                nextStates.set(190);
            }
            return null;
        }

        static TokenType NFA_LS_CONSTANTS_192(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'G')||(ch== 'g')) {
                nextStates.set(247);
            }
            return null;
        }

        static TokenType NFA_LS_CONSTANTS_193(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch== ':') {
                nextStates.set(169);
            }
            return null;
        }

        static TokenType NFA_LS_CONSTANTS_194(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch>='0'&&ch<='9') {
                nextStates.set(162);
            }
            return null;
        }

        static TokenType NFA_LS_CONSTANTS_195(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch== '0'||ch== '1') {
                nextStates.set(181);
            }
            return null;
        }

        static TokenType NFA_LS_CONSTANTS_196(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch== '\n') {
                if (validTypes.contains(_TOKEN_2)) return _TOKEN_2;
            }
            return null;
        }

        static TokenType NFA_LS_CONSTANTS_197(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch== '\'') {
                nextStates.set(24);
            }
            return null;
        }

        static TokenType NFA_LS_CONSTANTS_198(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch>='0'&&ch<='3') {
                nextStates.set(248);
            }
            return null;
        }

        static TokenType NFA_LS_CONSTANTS_199(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch>='0'&&ch<='2') {
                nextStates.set(229);
            }
            return null;
        }

        static TokenType NFA_LS_CONSTANTS_200(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch>='0'&&ch<='9') {
                nextStates.set(181);
            }
            return null;
        }

        static TokenType NFA_LS_CONSTANTS_201(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch>='0'&&ch<='9') {
                nextStates.set(201);
                if (validTypes.contains(T_LONG)) return T_LONG;
            }
            return null;
        }

        static TokenType NFA_LS_CONSTANTS_202(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch>='0'&&ch<='9') {
                nextStates.set(261);
            }
            return null;
        }

        static TokenType NFA_LS_CONSTANTS_203(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch>='0'&&ch<='9') {
                nextStates.set(193);
            }
            return null;
        }

        static TokenType NFA_LS_CONSTANTS_204(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'R')||(ch== 'r')) {
                nextStates.set(183);
            }
            return null;
        }

        static TokenType NFA_LS_CONSTANTS_205(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch== ':') {
                nextStates.set(211);
            }
            return null;
        }

        static TokenType NFA_LS_CONSTANTS_206(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'O')||(ch== 'o')) {
                nextStates.set(263);
            }
            return null;
        }

        static TokenType NFA_LS_CONSTANTS_207(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'Y')||(ch== 'y')) {
                nextStates.set(220);
            }
            return null;
        }

        static TokenType NFA_LS_CONSTANTS_208(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch== ' ') {
                if (validTypes.contains(_TOKEN_1)) return _TOKEN_1;
            }
            return null;
        }

        static TokenType NFA_LS_CONSTANTS_209(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch>='0'&&ch<='9') {
                if (validTypes.contains(T_DATETIMEINTERVAL)) return T_DATETIMEINTERVAL;
            }
            return null;
        }

        static TokenType NFA_LS_CONSTANTS_210(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch>='0'&&ch<='9') {
                if (validTypes.contains(T_DATETIME)) return T_DATETIME;
            }
            return null;
        }

        static TokenType NFA_LS_CONSTANTS_211(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch>='0'&&ch<='5') {
                nextStates.set(230);
            }
            return null;
        }

        static TokenType NFA_LS_CONSTANTS_212(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch>='0'&&ch<='9') {
                nextStates.set(163);
            }
            return null;
        }

        static TokenType NFA_LS_CONSTANTS_213(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch>='0'&&ch<='5') {
                nextStates.set(210);
            }
            return null;
        }

        static TokenType NFA_LS_CONSTANTS_214(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch>='0'&&ch<='5') {
                nextStates.set(221);
            }
            return null;
        }

        static TokenType NFA_LS_CONSTANTS_215(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'T')||(ch== 't')) {
                nextStates.set(170);
            }
            return null;
        }

        static TokenType NFA_LS_CONSTANTS_216(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch>='0'&&ch<='3') {
                nextStates.set(193);
            }
            return null;
        }

        static TokenType NFA_LS_CONSTANTS_217(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch>='0'&&ch<='9') {
                nextStates.set(261);
            }
            return null;
        }

        static TokenType NFA_LS_CONSTANTS_218(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch>='0'&&ch<='9') {
                nextStates.set(229);
            }
            return null;
        }

        static TokenType NFA_LS_CONSTANTS_219(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch>='0'&&ch<='2') {
                nextStates.set(262);
            }
            return null;
        }

        static TokenType NFA_LS_CONSTANTS_220(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch== '\'') {
                nextStates.set(1);
            }
            return null;
        }

        static TokenType NFA_LS_CONSTANTS_221(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch>='0'&&ch<='9') {
                nextStates.set(6);
            }
            return null;
        }

        static TokenType NFA_LS_CONSTANTS_222(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'O')||(ch== 'o')) {
                nextStates.set(159);
            }
            return null;
        }

        static TokenType NFA_LS_CONSTANTS_223(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch>='0'&&ch<='9') {
                nextStates.set(67);
            }
            return null;
        }

        static TokenType NFA_LS_CONSTANTS_224(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch>='0'&&ch<='9') {
                nextStates.set(135);
            }
            return null;
        }

        static TokenType NFA_LS_CONSTANTS_225(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'U')||(ch== 'u')) {
                nextStates.set(250);
            }
            return null;
        }

        static TokenType NFA_LS_CONSTANTS_226(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch== ':') {
                nextStates.set(258);
            }
            return null;
        }

        static TokenType NFA_LS_CONSTANTS_227(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch>='0'&&ch<='5') {
                nextStates.set(223);
            }
            return null;
        }

        static TokenType NFA_LS_CONSTANTS_228(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'S')||(ch== 's')) {
                nextStates.set(231);
            }
            return null;
        }

        static TokenType NFA_LS_CONSTANTS_229(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch== '-') {
                nextStates.set(105);
            }
            return null;
        }

        static TokenType NFA_LS_CONSTANTS_230(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch>='0'&&ch<='9') {
                nextStates.set(16);
                if (validTypes.contains(T_TIME)) return T_TIME;
            }
            return null;
        }

        static TokenType NFA_LS_CONSTANTS_231(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'E')||(ch== 'e')) {
                if (validTypes.contains(T_BOOL)) return T_BOOL;
            }
            return null;
        }

        static TokenType NFA_LS_CONSTANTS_232(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch>='0'&&ch<='3') {
                nextStates.set(261);
            }
            return null;
        }

        static TokenType NFA_LS_CONSTANTS_233(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch== '\'') {
                nextStates.set(24);
            }
            return null;
        }

        static TokenType NFA_LS_CONSTANTS_234(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch>='0'&&ch<='9') {
                nextStates.set(235);
            }
            return null;
        }

        static TokenType NFA_LS_CONSTANTS_235(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch== ':') {
                nextStates.set(165);
            }
            return null;
        }

        static TokenType NFA_LS_CONSTANTS_236(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch>='0'&&ch<='5') {
                nextStates.set(259);
            }
            return null;
        }

        static TokenType NFA_LS_CONSTANTS_237(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch>='0'&&ch<='9') {
                nextStates.set(175);
            }
            return null;
        }

        static TokenType NFA_LS_CONSTANTS_238(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch>='0'&&ch<='9') {
                nextStates.set(226);
            }
            return null;
        }

        static TokenType NFA_LS_CONSTANTS_239(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch>='0'&&ch<='3') {
                nextStates.set(235);
            }
            return null;
        }

        static TokenType NFA_LS_CONSTANTS_240(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch>='0'&&ch<='9') {
                nextStates.set(193);
            }
            return null;
        }

        static TokenType NFA_LS_CONSTANTS_241(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch>='0'&&ch<='9') {
                nextStates.set(20);
            }
            return null;
        }

        static TokenType NFA_LS_CONSTANTS_242(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch>='0'&&ch<='9') {
                nextStates.set(235);
            }
            return null;
        }

        static TokenType NFA_LS_CONSTANTS_243(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch== '\'') {
                nextStates.set(157);
            }
            return null;
        }

        static TokenType NFA_LS_CONSTANTS_244(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch>='0'&&ch<='9') {
                nextStates.set(262);
            }
            return null;
        }

        static TokenType NFA_LS_CONSTANTS_245(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch>='0'&&ch<='3') {
                nextStates.set(226);
            }
            return null;
        }

        static TokenType NFA_LS_CONSTANTS_246(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch>='0'&&ch<='9') {
                nextStates.set(248);
            }
            return null;
        }

        static TokenType NFA_LS_CONSTANTS_247(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'E')||(ch== 'e')) {
                nextStates.set(206);
            }
            return null;
        }

        static TokenType NFA_LS_CONSTANTS_248(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch== ':') {
                nextStates.set(213);
            }
            return null;
        }

        static TokenType NFA_LS_CONSTANTS_249(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'A')||(ch== 'a')) {
                nextStates.set(251);
            }
            return null;
        }

        static TokenType NFA_LS_CONSTANTS_250(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'E')||(ch== 'e')) {
                if (validTypes.contains(T_BOOL)) return T_BOOL;
            }
            return null;
        }

        static TokenType NFA_LS_CONSTANTS_251(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'P')||(ch== 'p')) {
                nextStates.set(187);
            }
            return null;
        }

        static TokenType NFA_LS_CONSTANTS_252(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch>='0'&&ch<='9') {
                if (validTypes.contains(T_DATE)) return T_DATE;
            }
            return null;
        }

        static TokenType NFA_LS_CONSTANTS_253(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch>='0'&&ch<='9') {
                nextStates.set(253);
                if (validTypes.contains(T_TIME)) return T_TIME;
            }
            return null;
        }

        static TokenType NFA_LS_CONSTANTS_254(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'U')||(ch== 'u')) {
                nextStates.set(204);
            }
            return null;
        }

        static TokenType NFA_LS_CONSTANTS_255(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch>='0'&&ch<='3') {
                nextStates.set(163);
            }
            return null;
        }

        static TokenType NFA_LS_CONSTANTS_256(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'T')||(ch== 't')) {
                nextStates.set(45);
            }
            return null;
        }

        static TokenType NFA_LS_CONSTANTS_257(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch>='0'&&ch<='9') {
                nextStates.set(180);
            }
            return null;
        }

        static TokenType NFA_LS_CONSTANTS_258(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch>='0'&&ch<='5') {
                nextStates.set(209);
            }
            return null;
        }

        static TokenType NFA_LS_CONSTANTS_259(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch>='0'&&ch<='9') {
                nextStates.set(118);
            }
            return null;
        }

        static TokenType NFA_LS_CONSTANTS_260(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch>='0'&&ch<='9') {
                nextStates.set(175);
            }
            return null;
        }

        static TokenType NFA_LS_CONSTANTS_261(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch== ':') {
                nextStates.set(191);
            }
            return null;
        }

        static TokenType NFA_LS_CONSTANTS_262(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch== '-') {
                nextStates.set(134);
            }
            return null;
        }

        static TokenType NFA_LS_CONSTANTS_263(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'G')||(ch== 'g')) {
                nextStates.set(177);
            }
            return null;
        }

        static TokenType NFA_LS_CONSTANTS_264(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch== '\r') {
                if (validTypes.contains(_TOKEN_3)) return _TOKEN_3;
            }
            return null;
        }

        static TokenType NFA_LS_CONSTANTS_265(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch>='0'&&ch<='5') {
                nextStates.set(166);
            }
            return null;
        }

        static TokenType NFA_LS_CONSTANTS_266(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch== '0') {
                nextStates.set(238);
            }
            return null;
        }

        static TokenType NFA_LS_CONSTANTS_267(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch>='0'&&ch<='9') {
                nextStates.set(356);
            }
            return null;
        }

        static TokenType NFA_LS_CONSTANTS_268(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'Y')||(ch== 'y')) {
                nextStates.set(5);
            }
            return null;
        }

        static TokenType NFA_LS_CONSTANTS_269(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== '+')||(ch== '-')) {
                nextStates.set(31);
            }
            return null;
        }

        static TokenType NFA_LS_CONSTANTS_270(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== '+')||(ch== '-')) {
                nextStates.set(18);
            }
            return null;
        }

        static TokenType NFA_LS_CONSTANTS_271(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== '+')||(ch== '-')) {
                nextStates.set(99);
            }
            return null;
        }

        static TokenType NFA_LS_CONSTANTS_272(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch== '\'') {
                nextStates.set(233);
            }
            return null;
        }

        static TokenType NFA_LS_CONSTANTS_273(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch>='0'&&ch<='9') {
                nextStates.set(132);
            }
            return null;
        }

        static TokenType NFA_LS_CONSTANTS_274(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch== '1') {
                nextStates.set(219);
            }
            return null;
        }

        static TokenType NFA_LS_CONSTANTS_275(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== '+')||(ch== '-')) {
                nextStates.set(91);
            }
            return null;
        }

        static TokenType NFA_LS_CONSTANTS_276(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch>='0'&&ch<='9') {
                nextStates.set(457);
            }
            return null;
        }

        static TokenType NFA_LS_CONSTANTS_277(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch>='0'&&ch<='9') {
                nextStates.set(317);
            }
            return null;
        }

        static TokenType NFA_LS_CONSTANTS_278(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch>='0'&&ch<='9') {
                nextStates.set(46);
            }
            return null;
        }

        static TokenType NFA_LS_CONSTANTS_279(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch>='0'&&ch<='9') {
                if (validTypes.contains(T_LONG)) return T_LONG;
            }
            return null;
        }

        static TokenType NFA_LS_CONSTANTS_280(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch>='0'&&ch<='9') {
                nextStates.set(4);
            }
            return null;
        }

        static TokenType NFA_LS_CONSTANTS_281(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch>='1'&&ch<='9') {
                nextStates.set(293);
            }
            return null;
        }

        static TokenType NFA_LS_CONSTANTS_282(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch>='1'&&ch<='9') {
                nextStates.set(371);
            }
            return null;
        }

        static TokenType NFA_LS_CONSTANTS_283(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch== '3') {
                nextStates.set(171);
            }
            return null;
        }

        static TokenType NFA_LS_CONSTANTS_284(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch>='1'&&ch<='9') {
                nextStates.set(344);
            }
            return null;
        }

        static TokenType NFA_LS_CONSTANTS_285(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch>='0'&&ch<='9') {
                nextStates.set(467);
            }
            return null;
        }

        static TokenType NFA_LS_CONSTANTS_286(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== '+')||(ch== '-')) {
                nextStates.set(60);
            }
            return null;
        }

        static TokenType NFA_LS_CONSTANTS_287(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'W')||(ch== 'w')) {
                nextStates.set(152);
            }
            return null;
        }

        static TokenType NFA_LS_CONSTANTS_288(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch>='0'&&ch<='9') {
                nextStates.set(471);
            }
            return null;
        }

        static TokenType NFA_LS_CONSTANTS_289(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'P')||(ch== 'p')) {
                nextStates.set(107);
            }
            return null;
        }

        static TokenType NFA_LS_CONSTANTS_290(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch== '.') {
                nextStates.set(253);
            }
            return null;
        }

        static TokenType NFA_LS_CONSTANTS_291(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'T')||(ch== 't')) {
                nextStates.set(182);
            }
            return null;
        }

        static TokenType NFA_LS_CONSTANTS_292(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch== '.') {
                nextStates.set(433);
            }
            return null;
        }

        static TokenType NFA_LS_CONSTANTS_293(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch>='0'&&ch<='9') {
                nextStates.set(48);
            }
            return null;
        }

        static TokenType NFA_LS_CONSTANTS_294(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch== '2') {
                nextStates.set(232);
            }
            return null;
        }

        static TokenType NFA_LS_CONSTANTS_295(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch>='1'&&ch<='9') {
                nextStates.set(333);
            }
            return null;
        }

        static TokenType NFA_LS_CONSTANTS_296(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch== '2') {
                nextStates.set(239);
            }
            return null;
        }

        static TokenType NFA_LS_CONSTANTS_297(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'T')||(ch== 't')) {
                nextStates.set(10);
            }
            return null;
        }

        static TokenType NFA_LS_CONSTANTS_298(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch== '2') {
                nextStates.set(174);
            }
            return null;
        }

        static TokenType NFA_LS_CONSTANTS_299(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'H')||(ch== 'h')) {
                nextStates.set(146);
            }
            return null;
        }

        static TokenType NFA_LS_CONSTANTS_300(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== '+')||(ch== '-')) {
                nextStates.set(109);
            }
            return null;
        }

        static TokenType NFA_LS_CONSTANTS_301(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch>='0'&&ch<='9') {
                nextStates.set(341);
            }
            return null;
        }

        static TokenType NFA_LS_CONSTANTS_302(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch>='0'&&ch<='2') {
                nextStates.set(200);
            }
            return null;
        }

        static TokenType NFA_LS_CONSTANTS_303(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch>='0'&&ch<='9') {
                nextStates.set(481);
            }
            return null;
        }

        static TokenType NFA_LS_CONSTANTS_304(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== '+')||(ch== '-')) {
                nextStates.set(112);
            }
            return null;
        }

        static TokenType NFA_LS_CONSTANTS_305(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch>='0'&&ch<='9') {
                nextStates.set(406);
            }
            return null;
        }

        static TokenType NFA_LS_CONSTANTS_306(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== '+')||(ch== '-')) {
                nextStates.set(143);
            }
            return null;
        }

        static TokenType NFA_LS_CONSTANTS_307(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch== '1') {
                nextStates.set(212);
            }
            return null;
        }

        static TokenType NFA_LS_CONSTANTS_308(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch== '1') {
                nextStates.set(161);
            }
            return null;
        }

        static TokenType NFA_LS_CONSTANTS_309(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch>='0'&&ch<='9') {
                nextStates.set(299);
            }
            return null;
        }

        static TokenType NFA_LS_CONSTANTS_310(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch>='0'&&ch<='9') {
                nextStates.set(110);
            }
            return null;
        }

        static TokenType NFA_LS_CONSTANTS_311(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch>='0'&&ch<='9') {
                nextStates.set(117);
            }
            return null;
        }

        static TokenType NFA_LS_CONSTANTS_312(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch== '.') {
                nextStates.set(76);
            }
            return null;
        }

        static TokenType NFA_LS_CONSTANTS_313(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== '+')||(ch== '-')) {
                nextStates.set(137);
            }
            return null;
        }

        static TokenType NFA_LS_CONSTANTS_314(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch>='1'&&ch<='9') {
                nextStates.set(479);
            }
            return null;
        }

        static TokenType NFA_LS_CONSTANTS_315(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch== '1') {
                nextStates.set(202);
            }
            return null;
        }

        static TokenType NFA_LS_CONSTANTS_316(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch== '.') {
                nextStates.set(150);
            }
            return null;
        }

        static TokenType NFA_LS_CONSTANTS_317(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'D')||(ch== 'd')) {
                nextStates.set(151);
            }
            return null;
        }

        static TokenType NFA_LS_CONSTANTS_318(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch== '3') {
                nextStates.set(189);
            }
            return null;
        }

        static TokenType NFA_LS_CONSTANTS_319(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== '+')||(ch== '-')) {
                nextStates.set(2);
            }
            return null;
        }

        static TokenType NFA_LS_CONSTANTS_320(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== '+')||(ch== '-')) {
                nextStates.set(72);
            }
            return null;
        }

        static TokenType NFA_LS_CONSTANTS_321(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch== ',') {
                nextStates.set(433);
            }
            return null;
        }

        static TokenType NFA_LS_CONSTANTS_322(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch>='1'&&ch<='9') {
                nextStates.set(378);
            }
            return null;
        }

        static TokenType NFA_LS_CONSTANTS_323(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'P')||(ch== 'p')) {
                nextStates.set(65);
                if (validTypes.contains(T_DATETIMEINTERVAL)) return T_DATETIMEINTERVAL;
            }
            return null;
        }

        static TokenType NFA_LS_CONSTANTS_324(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch>='1'&&ch<='9') {
                nextStates.set(311);
            }
            return null;
        }

        static TokenType NFA_LS_CONSTANTS_325(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch>='0'&&ch<='9') {
                nextStates.set(129);
            }
            return null;
        }

        static TokenType NFA_LS_CONSTANTS_326(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'H')||(ch== 'h')) {
                nextStates.set(127);
            }
            return null;
        }

        static TokenType NFA_LS_CONSTANTS_327(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch== '0') {
                nextStates.set(244);
            }
            return null;
        }

        static TokenType NFA_LS_CONSTANTS_328(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'T')||(ch== 't')) {
                nextStates.set(37);
            }
            return null;
        }

        static TokenType NFA_LS_CONSTANTS_329(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch>='1'&&ch<='9') {
                nextStates.set(436);
            }
            return null;
        }

        static TokenType NFA_LS_CONSTANTS_330(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch== '0') {
                nextStates.set(237);
            }
            return null;
        }

        static TokenType NFA_LS_CONSTANTS_331(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch>='1'&&ch<='9') {
                nextStates.set(360);
            }
            return null;
        }

        static TokenType NFA_LS_CONSTANTS_332(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== '+')||(ch== '-')) {
                nextStates.set(3);
            }
            return null;
        }

        static TokenType NFA_LS_CONSTANTS_333(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch>='0'&&ch<='9') {
                nextStates.set(155);
            }
            return null;
        }

        static TokenType NFA_LS_CONSTANTS_334(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'Z')||(ch== 'z')) {
                if (validTypes.contains(T_DATETIMEINTERVAL)) return T_DATETIMEINTERVAL;
            }
            return null;
        }

        static TokenType NFA_LS_CONSTANTS_335(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch== '1') {
                nextStates.set(199);
            }
            return null;
        }

        static TokenType NFA_LS_CONSTANTS_336(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch>='0'&&ch<='9') {
                nextStates.set(119);
            }
            return null;
        }

        static TokenType NFA_LS_CONSTANTS_337(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch>='1'&&ch<='9') {
                nextStates.set(370);
            }
            return null;
        }

        static TokenType NFA_LS_CONSTANTS_338(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch>='0'&&ch<='9') {
                nextStates.set(11);
            }
            return null;
        }

        static TokenType NFA_LS_CONSTANTS_339(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch>='0'&&ch<='9') {
                nextStates.set(26);
                if (validTypes.contains(T_DOUBLE)) return T_DOUBLE;
            }
            return null;
        }

        static TokenType NFA_LS_CONSTANTS_340(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== '+')||(ch== '-')) {
                nextStates.set(100);
            }
            return null;
        }

        static TokenType NFA_LS_CONSTANTS_341(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'D')||(ch== 'd')) {
                nextStates.set(435);
                if (validTypes.contains(T_DATETIMEINTERVAL)) return T_DATETIMEINTERVAL;
            }
            return null;
        }

        static TokenType NFA_LS_CONSTANTS_342(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'M')||(ch== 'm')) {
                nextStates.set(71);
            }
            return null;
        }

        static TokenType NFA_LS_CONSTANTS_343(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch>='1'&&ch<='9') {
                nextStates.set(338);
            }
            return null;
        }

        static TokenType NFA_LS_CONSTANTS_344(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch>='0'&&ch<='9') {
                nextStates.set(104);
            }
            return null;
        }

        static TokenType NFA_LS_CONSTANTS_345(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch== ':') {
                nextStates.set(214);
            }
            return null;
        }

        static TokenType NFA_LS_CONSTANTS_346(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'F')||(ch== 'f')) {
                nextStates.set(176);
            }
            return null;
        }

        static TokenType NFA_LS_CONSTANTS_347(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch>='0'&&ch<='9') {
                nextStates.set(116);
            }
            return null;
        }

        static TokenType NFA_LS_CONSTANTS_348(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch== ',') {
                nextStates.set(253);
            }
            return null;
        }

        static TokenType NFA_LS_CONSTANTS_349(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'Y')||(ch== 'y')) {
                nextStates.set(144);
                if (validTypes.contains(T_DATETIMEINTERVAL)) return T_DATETIMEINTERVAL;
            }
            return null;
        }

        static TokenType NFA_LS_CONSTANTS_350(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch== '0') {
                nextStates.set(203);
            }
            return null;
        }

        static TokenType NFA_LS_CONSTANTS_351(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch== '0') {
                nextStates.set(185);
            }
            return null;
        }

        static TokenType NFA_LS_CONSTANTS_352(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch>='1'&&ch<='9') {
                nextStates.set(339);
            }
            return null;
        }

        static TokenType NFA_LS_CONSTANTS_353(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch>='0'&&ch<='9') {
                nextStates.set(126);
                if (validTypes.contains(T_DOUBLE)) return T_DOUBLE;
            }
            return null;
        }

        static TokenType NFA_LS_CONSTANTS_354(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch== '2') {
                nextStates.set(255);
            }
            return null;
        }

        static TokenType NFA_LS_CONSTANTS_355(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'S')||(ch== 's')) {
                nextStates.set(455);
            }
            return null;
        }

        static TokenType NFA_LS_CONSTANTS_356(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'W')||(ch== 'w')) {
                nextStates.set(32);
            }
            return null;
        }

        static TokenType NFA_LS_CONSTANTS_357(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch>='0'&&ch<='9') {
                nextStates.set(474);
            }
            return null;
        }

        static TokenType NFA_LS_CONSTANTS_358(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'S')||(ch== 's')) {
                if (validTypes.contains(T_DATETIMEINTERVAL)) return T_DATETIMEINTERVAL;
            }
            return null;
        }

        static TokenType NFA_LS_CONSTANTS_359(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== '+')||(ch== '-')) {
                nextStates.set(40);
            }
            return null;
        }

        static TokenType NFA_LS_CONSTANTS_360(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch>='0'&&ch<='9') {
                nextStates.set(84);
            }
            return null;
        }

        static TokenType NFA_LS_CONSTANTS_361(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch>='0'&&ch<='9') {
                nextStates.set(383);
            }
            return null;
        }

        static TokenType NFA_LS_CONSTANTS_362(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== '+')||(ch== '-')) {
                nextStates.set(98);
            }
            return null;
        }

        static TokenType NFA_LS_CONSTANTS_363(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== '+')||(ch== '-')) {
                nextStates.set(289);
            }
            return null;
        }

        static TokenType NFA_LS_CONSTANTS_364(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch>='0'&&ch<='9') {
                nextStates.set(447);
            }
            return null;
        }

        static TokenType NFA_LS_CONSTANTS_365(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch>='0'&&ch<='9') {
                nextStates.set(128);
            }
            return null;
        }

        static TokenType NFA_LS_CONSTANTS_366(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch>='0'&&ch<='9') {
                nextStates.set(21);
            }
            return null;
        }

        static TokenType NFA_LS_CONSTANTS_367(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch>='0'&&ch<='9') {
                nextStates.set(465);
            }
            return null;
        }

        static TokenType NFA_LS_CONSTANTS_368(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch== '-') {
                nextStates.set(462);
            }
            return null;
        }

        static TokenType NFA_LS_CONSTANTS_369(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'Z')||(ch== 'z')) {
                if (validTypes.contains(T_DATETIME)) return T_DATETIME;
            }
            return null;
        }

        static TokenType NFA_LS_CONSTANTS_370(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch>='0'&&ch<='9') {
                nextStates.set(13);
            }
            return null;
        }

        static TokenType NFA_LS_CONSTANTS_371(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch>='0'&&ch<='9') {
                nextStates.set(28);
            }
            return null;
        }

        static TokenType NFA_LS_CONSTANTS_372(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch>='1'&&ch<='9') {
                nextStates.set(477);
            }
            return null;
        }

        static TokenType NFA_LS_CONSTANTS_373(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch>='0'&&ch<='9') {
                nextStates.set(114);
            }
            return null;
        }

        static TokenType NFA_LS_CONSTANTS_374(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== '+')||(ch== '-')) {
                nextStates.set(323);
            }
            return null;
        }

        static TokenType NFA_LS_CONSTANTS_375(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch== '/') {
                nextStates.set(34);
            }
            return null;
        }

        static TokenType NFA_LS_CONSTANTS_376(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch>='1'&&ch<='9') {
                nextStates.set(201);
            }
            return null;
        }

        static TokenType NFA_LS_CONSTANTS_377(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== '+')||(ch== '-')) {
                nextStates.set(15);
            }
            return null;
        }

        static TokenType NFA_LS_CONSTANTS_378(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch>='0'&&ch<='9') {
                nextStates.set(97);
            }
            return null;
        }

        static TokenType NFA_LS_CONSTANTS_379(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch>='1'&&ch<='9') {
                nextStates.set(278);
            }
            return null;
        }

        static TokenType NFA_LS_CONSTANTS_380(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch>='0'&&ch<='2') {
                nextStates.set(186);
            }
            return null;
        }

        static TokenType NFA_LS_CONSTANTS_381(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch>='0'&&ch<='9') {
                nextStates.set(358);
            }
            return null;
        }

        static TokenType NFA_LS_CONSTANTS_382(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch== '1') {
                nextStates.set(240);
            }
            return null;
        }

        static TokenType NFA_LS_CONSTANTS_383(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch== '-') {
                nextStates.set(130);
            }
            return null;
        }

        static TokenType NFA_LS_CONSTANTS_384(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== '+')||(ch== '-')) {
                nextStates.set(23);
            }
            return null;
        }

        static TokenType NFA_LS_CONSTANTS_385(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch>='0'&&ch<='9') {
                nextStates.set(55);
            }
            return null;
        }

        static TokenType NFA_LS_CONSTANTS_386(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'E')||(ch== 'e')) {
                nextStates.set(139);
            }
            return null;
        }

        static TokenType NFA_LS_CONSTANTS_387(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch== '0') {
                nextStates.set(218);
            }
            return null;
        }

        static TokenType NFA_LS_CONSTANTS_388(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== '+')||(ch== '-')) {
                nextStates.set(62);
            }
            return null;
        }

        static TokenType NFA_LS_CONSTANTS_389(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch>='1'&&ch<='9') {
                nextStates.set(469);
            }
            return null;
        }

        static TokenType NFA_LS_CONSTANTS_390(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch>='0'&&ch<='9') {
                nextStates.set(490);
            }
            return null;
        }

        static TokenType NFA_LS_CONSTANTS_391(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch== '0') {
                nextStates.set(167);
            }
            return null;
        }

        static TokenType NFA_LS_CONSTANTS_392(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== '+')||(ch== '-')) {
                nextStates.set(153);
            }
            return null;
        }

        static TokenType NFA_LS_CONSTANTS_393(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch>='1'&&ch<='9') {
                nextStates.set(310);
            }
            return null;
        }

        static TokenType NFA_LS_CONSTANTS_394(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== '+')||(ch== '-')) {
                nextStates.set(22);
            }
            return null;
        }

        static TokenType NFA_LS_CONSTANTS_395(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch== '2') {
                nextStates.set(216);
            }
            return null;
        }

        static TokenType NFA_LS_CONSTANTS_396(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch>='0'&&ch<='9') {
                nextStates.set(342);
            }
            return null;
        }

        static TokenType NFA_LS_CONSTANTS_397(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch>='1'&&ch<='9') {
                nextStates.set(385);
            }
            return null;
        }

        static TokenType NFA_LS_CONSTANTS_398(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'M')||(ch== 'm')) {
                nextStates.set(70);
                if (validTypes.contains(T_DATETIMEINTERVAL)) return T_DATETIMEINTERVAL;
            }
            return null;
        }

        static TokenType NFA_LS_CONSTANTS_399(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch== '0') {
                nextStates.set(246);
            }
            return null;
        }

        static TokenType NFA_LS_CONSTANTS_400(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch== '1') {
                nextStates.set(168);
            }
            return null;
        }

        static TokenType NFA_LS_CONSTANTS_401(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch>='0'&&ch<='9') {
                nextStates.set(398);
            }
            return null;
        }

        static TokenType NFA_LS_CONSTANTS_402(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch>='0'&&ch<='2') {
                nextStates.set(257);
            }
            return null;
        }

        static TokenType NFA_LS_CONSTANTS_403(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch== ',') {
                nextStates.set(336);
            }
            return null;
        }

        static TokenType NFA_LS_CONSTANTS_404(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch>='1'&&ch<='9') {
                nextStates.set(483);
            }
            return null;
        }

        static TokenType NFA_LS_CONSTANTS_405(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch>='1'&&ch<='9') {
                nextStates.set(416);
            }
            return null;
        }

        static TokenType NFA_LS_CONSTANTS_406(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'H')||(ch== 'h')) {
                nextStates.set(9);
                if (validTypes.contains(T_DATETIMEINTERVAL)) return T_DATETIMEINTERVAL;
            }
            return null;
        }

        static TokenType NFA_LS_CONSTANTS_407(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== '+')||(ch== '-')) {
                nextStates.set(51);
            }
            return null;
        }

        static TokenType NFA_LS_CONSTANTS_408(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch== ':') {
                nextStates.set(236);
            }
            return null;
        }

        static TokenType NFA_LS_CONSTANTS_409(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'Y')||(ch== 'y')) {
                nextStates.set(8);
            }
            return null;
        }

        static TokenType NFA_LS_CONSTANTS_410(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'Z')||(ch== 'z')) {
                nextStates.set(375);
            }
            return null;
        }

        static TokenType NFA_LS_CONSTANTS_411(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch>='1'&&ch<='9') {
                nextStates.set(373);
            }
            return null;
        }

        static TokenType NFA_LS_CONSTANTS_412(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch>='0'&&ch<='9') {
                nextStates.set(12);
            }
            return null;
        }

        static TokenType NFA_LS_CONSTANTS_413(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch== ':') {
                nextStates.set(179);
            }
            return null;
        }

        static TokenType NFA_LS_CONSTANTS_414(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch== '1') {
                nextStates.set(188);
            }
            return null;
        }

        static TokenType NFA_LS_CONSTANTS_415(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch>='1'&&ch<='9') {
                nextStates.set(273);
            }
            return null;
        }

        static TokenType NFA_LS_CONSTANTS_416(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch>='0'&&ch<='9') {
                nextStates.set(103);
            }
            return null;
        }

        static TokenType NFA_LS_CONSTANTS_417(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'P')||(ch== 'p')) {
                nextStates.set(7);
            }
            return null;
        }

        static TokenType NFA_LS_CONSTANTS_418(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'M')||(ch== 'm')) {
                nextStates.set(50);
            }
            return null;
        }

        static TokenType NFA_LS_CONSTANTS_419(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch>='1'&&ch<='9') {
                nextStates.set(347);
            }
            return null;
        }

        static TokenType NFA_LS_CONSTANTS_420(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== '+')||(ch== '-')) {
                nextStates.set(133);
            }
            return null;
        }

        static TokenType NFA_LS_CONSTANTS_421(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch== '2') {
                nextStates.set(245);
            }
            return null;
        }

        static TokenType NFA_LS_CONSTANTS_422(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch>='0'&&ch<='9') {
                nextStates.set(95);
                if (validTypes.contains(T_DOUBLE)) return T_DOUBLE;
            }
            return null;
        }

        static TokenType NFA_LS_CONSTANTS_423(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch>='0'&&ch<='9') {
                nextStates.set(418);
            }
            return null;
        }

        static TokenType NFA_LS_CONSTANTS_424(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch>='0'&&ch<='9') {
                nextStates.set(326);
            }
            return null;
        }

        static TokenType NFA_LS_CONSTANTS_425(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch>='1'&&ch<='9') {
                nextStates.set(453);
            }
            return null;
        }

        static TokenType NFA_LS_CONSTANTS_426(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch>='0'&&ch<='9') {
                nextStates.set(451);
            }
            return null;
        }

        static TokenType NFA_LS_CONSTANTS_427(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== '+')||(ch== '-')) {
                nextStates.set(88);
            }
            return null;
        }

        static TokenType NFA_LS_CONSTANTS_428(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch>='1'&&ch<='9') {
                nextStates.set(459);
            }
            return null;
        }

        static TokenType NFA_LS_CONSTANTS_429(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch== '\'') {
                if (validTypes.contains(T_GEO_STR_LIT)) return T_GEO_STR_LIT;
            }
            return null;
        }

        static TokenType NFA_LS_CONSTANTS_430(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch>='0'&&ch<='9') {
                nextStates.set(73);
            }
            return null;
        }

        static TokenType NFA_LS_CONSTANTS_431(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch>='0'&&ch<='9') {
                nextStates.set(349);
            }
            return null;
        }

        static TokenType NFA_LS_CONSTANTS_432(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch>='0'&&ch<='9') {
                nextStates.set(142);
            }
            return null;
        }

        static TokenType NFA_LS_CONSTANTS_433(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch>='0'&&ch<='9') {
                nextStates.set(93);
            }
            return null;
        }

        static TokenType NFA_LS_CONSTANTS_434(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch>='0'&&ch<='9') {
                nextStates.set(42);
            }
            return null;
        }

        static TokenType NFA_LS_CONSTANTS_435(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'T')||(ch== 't')) {
                nextStates.set(120);
                if (validTypes.contains(T_DATETIMEINTERVAL)) return T_DATETIMEINTERVAL;
            }
            return null;
        }

        static TokenType NFA_LS_CONSTANTS_436(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch>='0'&&ch<='9') {
                nextStates.set(131);
            }
            return null;
        }

        static TokenType NFA_LS_CONSTANTS_437(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch>='0'&&ch<='9') {
                nextStates.set(268);
            }
            return null;
        }

        static TokenType NFA_LS_CONSTANTS_438(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== '+')||(ch== '-')) {
                nextStates.set(113);
            }
            return null;
        }

        static TokenType NFA_LS_CONSTANTS_439(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch== '1') {
                nextStates.set(260);
            }
            return null;
        }

        static TokenType NFA_LS_CONSTANTS_440(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch== '2') {
                nextStates.set(198);
            }
            return null;
        }

        static TokenType NFA_LS_CONSTANTS_441(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch== '1') {
                nextStates.set(242);
            }
            return null;
        }

        static TokenType NFA_LS_CONSTANTS_442(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== '+')||(ch== '-')) {
                nextStates.set(64);
            }
            return null;
        }

        static TokenType NFA_LS_CONSTANTS_443(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== '+')||(ch== '-')) {
                nextStates.set(47);
            }
            return null;
        }

        static TokenType NFA_LS_CONSTANTS_444(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch>='1'&&ch<='9') {
                nextStates.set(280);
            }
            return null;
        }

        static TokenType NFA_LS_CONSTANTS_445(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch== '.') {
                nextStates.set(336);
            }
            return null;
        }

        static TokenType NFA_LS_CONSTANTS_446(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch>=0x0&&ch<='&')||(ch>='(')) {
                nextStates.set(24);
            }
            return null;
        }

        static TokenType NFA_LS_CONSTANTS_447(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch== '-') {
                nextStates.set(41);
            }
            return null;
        }

        static TokenType NFA_LS_CONSTANTS_448(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== '+')||(ch== '-')) {
                nextStates.set(27);
            }
            return null;
        }

        static TokenType NFA_LS_CONSTANTS_449(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch== '0') {
                nextStates.set(194);
            }
            return null;
        }

        static TokenType NFA_LS_CONSTANTS_450(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch== '0') {
                nextStates.set(234);
            }
            return null;
        }

        static TokenType NFA_LS_CONSTANTS_451(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch== '-') {
                nextStates.set(89);
            }
            return null;
        }

        static TokenType NFA_LS_CONSTANTS_452(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch== '.') {
                nextStates.set(59);
            }
            return null;
        }

        static TokenType NFA_LS_CONSTANTS_453(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch>='0'&&ch<='9') {
                nextStates.set(61);
            }
            return null;
        }

        static TokenType NFA_LS_CONSTANTS_454(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch>=0x0&&ch<='&')||(ch>='(')) {
                nextStates.set(1);
            }
            return null;
        }

        static TokenType NFA_LS_CONSTANTS_455(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch== '\'') {
                if (validTypes.contains(T_DURATION)) return T_DURATION;
            }
            return null;
        }

        static TokenType NFA_LS_CONSTANTS_456(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch== '1') {
                nextStates.set(164);
            }
            return null;
        }

        static TokenType NFA_LS_CONSTANTS_457(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'S')||(ch== 's')) {
                nextStates.set(375);
            }
            return null;
        }

        static TokenType NFA_LS_CONSTANTS_458(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== '+')||(ch== '-')) {
                nextStates.set(136);
            }
            return null;
        }

        static TokenType NFA_LS_CONSTANTS_459(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch>='0'&&ch<='9') {
                nextStates.set(78);
            }
            return null;
        }

        static TokenType NFA_LS_CONSTANTS_460(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch>='1'&&ch<='9') {
                nextStates.set(365);
            }
            return null;
        }

        static TokenType NFA_LS_CONSTANTS_461(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch>='0'&&ch<='9') {
                nextStates.set(355);
            }
            return null;
        }

        static TokenType NFA_LS_CONSTANTS_462(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch>='0'&&ch<='9') {
                nextStates.set(462);
                if (validTypes.contains(T_DOUBLE)) return T_DOUBLE;
            }
            return null;
        }

        static TokenType NFA_LS_CONSTANTS_463(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch== '\'') {
                if (validTypes.contains(T_STR_LIT)) return T_STR_LIT;
            }
            return null;
        }

        static TokenType NFA_LS_CONSTANTS_464(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch== '3') {
                nextStates.set(172);
            }
            return null;
        }

        static TokenType NFA_LS_CONSTANTS_465(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'W')||(ch== 'w')) {
                nextStates.set(140);
                if (validTypes.contains(T_DATETIMEINTERVAL)) return T_DATETIMEINTERVAL;
            }
            return null;
        }

        static TokenType NFA_LS_CONSTANTS_466(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch== '0') {
                nextStates.set(217);
            }
            return null;
        }

        static TokenType NFA_LS_CONSTANTS_467(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'D')||(ch== 'd')) {
                nextStates.set(121);
            }
            return null;
        }

        static TokenType NFA_LS_CONSTANTS_468(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch== '.') {
                nextStates.set(434);
            }
            return null;
        }

        static TokenType NFA_LS_CONSTANTS_469(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch>='0'&&ch<='9') {
                nextStates.set(49);
            }
            return null;
        }

        static TokenType NFA_LS_CONSTANTS_470(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch>='1'&&ch<='9') {
                nextStates.set(432);
            }
            return null;
        }

        static TokenType NFA_LS_CONSTANTS_471(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'M')||(ch== 'm')) {
                nextStates.set(77);
            }
            return null;
        }

        static TokenType NFA_LS_CONSTANTS_472(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch== '.') {
                nextStates.set(353);
            }
            return null;
        }

        static TokenType NFA_LS_CONSTANTS_473(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch>='1'&&ch<='9') {
                nextStates.set(325);
            }
            return null;
        }

        static TokenType NFA_LS_CONSTANTS_474(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch== '-') {
                nextStates.set(35);
            }
            return null;
        }

        static TokenType NFA_LS_CONSTANTS_475(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch== '3') {
                nextStates.set(195);
            }
            return null;
        }

        static TokenType NFA_LS_CONSTANTS_476(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== '+')||(ch== '-')) {
                nextStates.set(14);
            }
            return null;
        }

        static TokenType NFA_LS_CONSTANTS_477(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch>='0'&&ch<='9') {
                nextStates.set(74);
            }
            return null;
        }

        static TokenType NFA_LS_CONSTANTS_478(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== '+')||(ch== '-')) {
                nextStates.set(80);
            }
            return null;
        }

        static TokenType NFA_LS_CONSTANTS_479(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch>='0'&&ch<='9') {
                nextStates.set(68);
            }
            return null;
        }

        static TokenType NFA_LS_CONSTANTS_480(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch>='1'&&ch<='9') {
                nextStates.set(430);
            }
            return null;
        }

        static TokenType NFA_LS_CONSTANTS_481(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'M')||(ch== 'm')) {
                nextStates.set(108);
                if (validTypes.contains(T_DATETIMEINTERVAL)) return T_DATETIMEINTERVAL;
            }
            return null;
        }

        static TokenType NFA_LS_CONSTANTS_482(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch== ',') {
                nextStates.set(434);
            }
            return null;
        }

        static TokenType NFA_LS_CONSTANTS_483(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch>='0'&&ch<='9') {
                nextStates.set(124);
            }
            return null;
        }

        static TokenType NFA_LS_CONSTANTS_484(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch>='0'&&ch<='9') {
                nextStates.set(287);
            }
            return null;
        }

        static TokenType NFA_LS_CONSTANTS_485(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== '+')||(ch== '-')) {
                nextStates.set(36);
            }
            return null;
        }

        static TokenType NFA_LS_CONSTANTS_486(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch>='0'&&ch<='9') {
                nextStates.set(147);
            }
            return null;
        }

        static TokenType NFA_LS_CONSTANTS_487(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== '+')||(ch== '-')) {
                nextStates.set(141);
            }
            return null;
        }

        static TokenType NFA_LS_CONSTANTS_488(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== '+')||(ch== '-')) {
                nextStates.set(417);
            }
            return null;
        }

        static TokenType NFA_LS_CONSTANTS_489(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch>='0'&&ch<='2') {
                nextStates.set(252);
            }
            return null;
        }

        static TokenType NFA_LS_CONSTANTS_490(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'M')||(ch== 'm')) {
                nextStates.set(66);
            }
            return null;
        }

        static TokenType NFA_LS_CONSTANTS_491(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== '+')||(ch== '-')) {
                nextStates.set(123);
            }
            return null;
        }

        static TokenType NFA_LS_CONSTANTS_492(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch>='0'&&ch<='9') {
                nextStates.set(409);
            }
            return null;
        }

        static private void NFA_FUNCTIONS_init() {
            NfaFunction[] functions= new NfaFunction[493];
            functions[0]= LS_CONSTANTS::NFA_COMPOSITE_LS_CONSTANTS_0;
            functions[1]= LS_CONSTANTS::NFA_COMPOSITE_LS_CONSTANTS_1;
            functions[2]= LS_CONSTANTS::NFA_COMPOSITE_LS_CONSTANTS_2;
            functions[3]= LS_CONSTANTS::NFA_COMPOSITE_LS_CONSTANTS_3;
            functions[4]= LS_CONSTANTS::NFA_COMPOSITE_LS_CONSTANTS_4;
            functions[5]= LS_CONSTANTS::NFA_COMPOSITE_LS_CONSTANTS_5;
            functions[6]= LS_CONSTANTS::NFA_COMPOSITE_LS_CONSTANTS_6;
            functions[7]= LS_CONSTANTS::NFA_COMPOSITE_LS_CONSTANTS_7;
            functions[8]= LS_CONSTANTS::NFA_COMPOSITE_LS_CONSTANTS_8;
            functions[9]= LS_CONSTANTS::NFA_COMPOSITE_LS_CONSTANTS_9;
            functions[10]= LS_CONSTANTS::NFA_COMPOSITE_LS_CONSTANTS_10;
            functions[11]= LS_CONSTANTS::NFA_COMPOSITE_LS_CONSTANTS_11;
            functions[12]= LS_CONSTANTS::NFA_COMPOSITE_LS_CONSTANTS_12;
            functions[13]= LS_CONSTANTS::NFA_COMPOSITE_LS_CONSTANTS_13;
            functions[14]= LS_CONSTANTS::NFA_COMPOSITE_LS_CONSTANTS_14;
            functions[15]= LS_CONSTANTS::NFA_COMPOSITE_LS_CONSTANTS_15;
            functions[16]= LS_CONSTANTS::NFA_COMPOSITE_LS_CONSTANTS_16;
            functions[17]= LS_CONSTANTS::NFA_COMPOSITE_LS_CONSTANTS_17;
            functions[18]= LS_CONSTANTS::NFA_COMPOSITE_LS_CONSTANTS_18;
            functions[19]= LS_CONSTANTS::NFA_COMPOSITE_LS_CONSTANTS_19;
            functions[20]= LS_CONSTANTS::NFA_COMPOSITE_LS_CONSTANTS_20;
            functions[21]= LS_CONSTANTS::NFA_COMPOSITE_LS_CONSTANTS_21;
            functions[22]= LS_CONSTANTS::NFA_COMPOSITE_LS_CONSTANTS_22;
            functions[23]= LS_CONSTANTS::NFA_COMPOSITE_LS_CONSTANTS_23;
            functions[24]= LS_CONSTANTS::NFA_COMPOSITE_LS_CONSTANTS_24;
            functions[25]= LS_CONSTANTS::NFA_COMPOSITE_LS_CONSTANTS_25;
            functions[26]= LS_CONSTANTS::NFA_COMPOSITE_LS_CONSTANTS_26;
            functions[27]= LS_CONSTANTS::NFA_COMPOSITE_LS_CONSTANTS_27;
            functions[28]= LS_CONSTANTS::NFA_COMPOSITE_LS_CONSTANTS_28;
            functions[29]= LS_CONSTANTS::NFA_COMPOSITE_LS_CONSTANTS_29;
            functions[30]= LS_CONSTANTS::NFA_COMPOSITE_LS_CONSTANTS_30;
            functions[31]= LS_CONSTANTS::NFA_COMPOSITE_LS_CONSTANTS_31;
            functions[32]= LS_CONSTANTS::NFA_COMPOSITE_LS_CONSTANTS_32;
            functions[33]= LS_CONSTANTS::NFA_COMPOSITE_LS_CONSTANTS_33;
            functions[34]= LS_CONSTANTS::NFA_COMPOSITE_LS_CONSTANTS_34;
            functions[35]= LS_CONSTANTS::NFA_COMPOSITE_LS_CONSTANTS_35;
            functions[36]= LS_CONSTANTS::NFA_COMPOSITE_LS_CONSTANTS_36;
            functions[37]= LS_CONSTANTS::NFA_COMPOSITE_LS_CONSTANTS_37;
            functions[38]= LS_CONSTANTS::NFA_COMPOSITE_LS_CONSTANTS_38;
            functions[39]= LS_CONSTANTS::NFA_COMPOSITE_LS_CONSTANTS_39;
            functions[40]= LS_CONSTANTS::NFA_COMPOSITE_LS_CONSTANTS_40;
            functions[41]= LS_CONSTANTS::NFA_COMPOSITE_LS_CONSTANTS_41;
            functions[42]= LS_CONSTANTS::NFA_COMPOSITE_LS_CONSTANTS_42;
            functions[43]= LS_CONSTANTS::NFA_COMPOSITE_LS_CONSTANTS_43;
            functions[44]= LS_CONSTANTS::NFA_COMPOSITE_LS_CONSTANTS_44;
            functions[45]= LS_CONSTANTS::NFA_COMPOSITE_LS_CONSTANTS_45;
            functions[46]= LS_CONSTANTS::NFA_COMPOSITE_LS_CONSTANTS_46;
            functions[47]= LS_CONSTANTS::NFA_COMPOSITE_LS_CONSTANTS_47;
            functions[48]= LS_CONSTANTS::NFA_COMPOSITE_LS_CONSTANTS_48;
            functions[49]= LS_CONSTANTS::NFA_COMPOSITE_LS_CONSTANTS_49;
            functions[50]= LS_CONSTANTS::NFA_COMPOSITE_LS_CONSTANTS_50;
            functions[51]= LS_CONSTANTS::NFA_COMPOSITE_LS_CONSTANTS_51;
            functions[52]= LS_CONSTANTS::NFA_COMPOSITE_LS_CONSTANTS_52;
            functions[53]= LS_CONSTANTS::NFA_COMPOSITE_LS_CONSTANTS_53;
            functions[54]= LS_CONSTANTS::NFA_COMPOSITE_LS_CONSTANTS_54;
            functions[55]= LS_CONSTANTS::NFA_COMPOSITE_LS_CONSTANTS_55;
            functions[56]= LS_CONSTANTS::NFA_COMPOSITE_LS_CONSTANTS_56;
            functions[57]= LS_CONSTANTS::NFA_COMPOSITE_LS_CONSTANTS_57;
            functions[58]= LS_CONSTANTS::NFA_COMPOSITE_LS_CONSTANTS_58;
            functions[59]= LS_CONSTANTS::NFA_COMPOSITE_LS_CONSTANTS_59;
            functions[60]= LS_CONSTANTS::NFA_COMPOSITE_LS_CONSTANTS_60;
            functions[61]= LS_CONSTANTS::NFA_COMPOSITE_LS_CONSTANTS_61;
            functions[62]= LS_CONSTANTS::NFA_COMPOSITE_LS_CONSTANTS_62;
            functions[63]= LS_CONSTANTS::NFA_COMPOSITE_LS_CONSTANTS_63;
            functions[64]= LS_CONSTANTS::NFA_COMPOSITE_LS_CONSTANTS_64;
            functions[65]= LS_CONSTANTS::NFA_COMPOSITE_LS_CONSTANTS_65;
            functions[66]= LS_CONSTANTS::NFA_COMPOSITE_LS_CONSTANTS_66;
            functions[67]= LS_CONSTANTS::NFA_COMPOSITE_LS_CONSTANTS_67;
            functions[68]= LS_CONSTANTS::NFA_COMPOSITE_LS_CONSTANTS_68;
            functions[69]= LS_CONSTANTS::NFA_COMPOSITE_LS_CONSTANTS_69;
            functions[70]= LS_CONSTANTS::NFA_COMPOSITE_LS_CONSTANTS_70;
            functions[71]= LS_CONSTANTS::NFA_COMPOSITE_LS_CONSTANTS_71;
            functions[72]= LS_CONSTANTS::NFA_COMPOSITE_LS_CONSTANTS_72;
            functions[73]= LS_CONSTANTS::NFA_COMPOSITE_LS_CONSTANTS_73;
            functions[74]= LS_CONSTANTS::NFA_COMPOSITE_LS_CONSTANTS_74;
            functions[75]= LS_CONSTANTS::NFA_COMPOSITE_LS_CONSTANTS_75;
            functions[76]= LS_CONSTANTS::NFA_COMPOSITE_LS_CONSTANTS_76;
            functions[77]= LS_CONSTANTS::NFA_COMPOSITE_LS_CONSTANTS_77;
            functions[78]= LS_CONSTANTS::NFA_COMPOSITE_LS_CONSTANTS_78;
            functions[79]= LS_CONSTANTS::NFA_COMPOSITE_LS_CONSTANTS_79;
            functions[80]= LS_CONSTANTS::NFA_COMPOSITE_LS_CONSTANTS_80;
            functions[81]= LS_CONSTANTS::NFA_COMPOSITE_LS_CONSTANTS_81;
            functions[82]= LS_CONSTANTS::NFA_COMPOSITE_LS_CONSTANTS_82;
            functions[83]= LS_CONSTANTS::NFA_COMPOSITE_LS_CONSTANTS_83;
            functions[84]= LS_CONSTANTS::NFA_COMPOSITE_LS_CONSTANTS_84;
            functions[85]= LS_CONSTANTS::NFA_COMPOSITE_LS_CONSTANTS_85;
            functions[86]= LS_CONSTANTS::NFA_COMPOSITE_LS_CONSTANTS_86;
            functions[87]= LS_CONSTANTS::NFA_COMPOSITE_LS_CONSTANTS_87;
            functions[88]= LS_CONSTANTS::NFA_COMPOSITE_LS_CONSTANTS_88;
            functions[89]= LS_CONSTANTS::NFA_COMPOSITE_LS_CONSTANTS_89;
            functions[90]= LS_CONSTANTS::NFA_COMPOSITE_LS_CONSTANTS_90;
            functions[91]= LS_CONSTANTS::NFA_COMPOSITE_LS_CONSTANTS_91;
            functions[92]= LS_CONSTANTS::NFA_COMPOSITE_LS_CONSTANTS_92;
            functions[93]= LS_CONSTANTS::NFA_COMPOSITE_LS_CONSTANTS_93;
            functions[94]= LS_CONSTANTS::NFA_COMPOSITE_LS_CONSTANTS_94;
            functions[95]= LS_CONSTANTS::NFA_COMPOSITE_LS_CONSTANTS_95;
            functions[96]= LS_CONSTANTS::NFA_COMPOSITE_LS_CONSTANTS_96;
            functions[97]= LS_CONSTANTS::NFA_COMPOSITE_LS_CONSTANTS_97;
            functions[98]= LS_CONSTANTS::NFA_COMPOSITE_LS_CONSTANTS_98;
            functions[99]= LS_CONSTANTS::NFA_COMPOSITE_LS_CONSTANTS_99;
            functions[100]= LS_CONSTANTS::NFA_COMPOSITE_LS_CONSTANTS_100;
            functions[101]= LS_CONSTANTS::NFA_COMPOSITE_LS_CONSTANTS_101;
            functions[102]= LS_CONSTANTS::NFA_COMPOSITE_LS_CONSTANTS_102;
            functions[103]= LS_CONSTANTS::NFA_COMPOSITE_LS_CONSTANTS_103;
            functions[104]= LS_CONSTANTS::NFA_COMPOSITE_LS_CONSTANTS_104;
            functions[105]= LS_CONSTANTS::NFA_COMPOSITE_LS_CONSTANTS_105;
            functions[106]= LS_CONSTANTS::NFA_COMPOSITE_LS_CONSTANTS_106;
            functions[107]= LS_CONSTANTS::NFA_COMPOSITE_LS_CONSTANTS_107;
            functions[108]= LS_CONSTANTS::NFA_COMPOSITE_LS_CONSTANTS_108;
            functions[109]= LS_CONSTANTS::NFA_COMPOSITE_LS_CONSTANTS_109;
            functions[110]= LS_CONSTANTS::NFA_COMPOSITE_LS_CONSTANTS_110;
            functions[111]= LS_CONSTANTS::NFA_COMPOSITE_LS_CONSTANTS_111;
            functions[112]= LS_CONSTANTS::NFA_COMPOSITE_LS_CONSTANTS_112;
            functions[113]= LS_CONSTANTS::NFA_COMPOSITE_LS_CONSTANTS_113;
            functions[114]= LS_CONSTANTS::NFA_COMPOSITE_LS_CONSTANTS_114;
            functions[115]= LS_CONSTANTS::NFA_COMPOSITE_LS_CONSTANTS_115;
            functions[116]= LS_CONSTANTS::NFA_COMPOSITE_LS_CONSTANTS_116;
            functions[117]= LS_CONSTANTS::NFA_COMPOSITE_LS_CONSTANTS_117;
            functions[118]= LS_CONSTANTS::NFA_COMPOSITE_LS_CONSTANTS_118;
            functions[119]= LS_CONSTANTS::NFA_COMPOSITE_LS_CONSTANTS_119;
            functions[120]= LS_CONSTANTS::NFA_COMPOSITE_LS_CONSTANTS_120;
            functions[121]= LS_CONSTANTS::NFA_COMPOSITE_LS_CONSTANTS_121;
            functions[122]= LS_CONSTANTS::NFA_COMPOSITE_LS_CONSTANTS_122;
            functions[123]= LS_CONSTANTS::NFA_COMPOSITE_LS_CONSTANTS_123;
            functions[124]= LS_CONSTANTS::NFA_COMPOSITE_LS_CONSTANTS_124;
            functions[125]= LS_CONSTANTS::NFA_COMPOSITE_LS_CONSTANTS_125;
            functions[126]= LS_CONSTANTS::NFA_COMPOSITE_LS_CONSTANTS_126;
            functions[127]= LS_CONSTANTS::NFA_COMPOSITE_LS_CONSTANTS_127;
            functions[128]= LS_CONSTANTS::NFA_COMPOSITE_LS_CONSTANTS_128;
            functions[129]= LS_CONSTANTS::NFA_COMPOSITE_LS_CONSTANTS_129;
            functions[130]= LS_CONSTANTS::NFA_COMPOSITE_LS_CONSTANTS_130;
            functions[131]= LS_CONSTANTS::NFA_COMPOSITE_LS_CONSTANTS_131;
            functions[132]= LS_CONSTANTS::NFA_COMPOSITE_LS_CONSTANTS_132;
            functions[133]= LS_CONSTANTS::NFA_COMPOSITE_LS_CONSTANTS_133;
            functions[134]= LS_CONSTANTS::NFA_COMPOSITE_LS_CONSTANTS_134;
            functions[135]= LS_CONSTANTS::NFA_COMPOSITE_LS_CONSTANTS_135;
            functions[136]= LS_CONSTANTS::NFA_COMPOSITE_LS_CONSTANTS_136;
            functions[137]= LS_CONSTANTS::NFA_COMPOSITE_LS_CONSTANTS_137;
            functions[138]= LS_CONSTANTS::NFA_COMPOSITE_LS_CONSTANTS_138;
            functions[139]= LS_CONSTANTS::NFA_COMPOSITE_LS_CONSTANTS_139;
            functions[140]= LS_CONSTANTS::NFA_COMPOSITE_LS_CONSTANTS_140;
            functions[141]= LS_CONSTANTS::NFA_COMPOSITE_LS_CONSTANTS_141;
            functions[142]= LS_CONSTANTS::NFA_COMPOSITE_LS_CONSTANTS_142;
            functions[143]= LS_CONSTANTS::NFA_COMPOSITE_LS_CONSTANTS_143;
            functions[144]= LS_CONSTANTS::NFA_COMPOSITE_LS_CONSTANTS_144;
            functions[145]= LS_CONSTANTS::NFA_COMPOSITE_LS_CONSTANTS_145;
            functions[146]= LS_CONSTANTS::NFA_COMPOSITE_LS_CONSTANTS_146;
            functions[147]= LS_CONSTANTS::NFA_COMPOSITE_LS_CONSTANTS_147;
            functions[148]= LS_CONSTANTS::NFA_COMPOSITE_LS_CONSTANTS_148;
            functions[149]= LS_CONSTANTS::NFA_COMPOSITE_LS_CONSTANTS_149;
            functions[150]= LS_CONSTANTS::NFA_COMPOSITE_LS_CONSTANTS_150;
            functions[151]= LS_CONSTANTS::NFA_COMPOSITE_LS_CONSTANTS_151;
            functions[152]= LS_CONSTANTS::NFA_COMPOSITE_LS_CONSTANTS_152;
            functions[153]= LS_CONSTANTS::NFA_COMPOSITE_LS_CONSTANTS_153;
            functions[154]= LS_CONSTANTS::NFA_COMPOSITE_LS_CONSTANTS_154;
            functions[155]= LS_CONSTANTS::NFA_COMPOSITE_LS_CONSTANTS_155;
            functions[156]= LS_CONSTANTS::NFA_COMPOSITE_LS_CONSTANTS_156;
            functions[157]= LS_CONSTANTS::NFA_COMPOSITE_LS_CONSTANTS_157;
            functions[158]= LS_CONSTANTS::NFA_LS_CONSTANTS_158;
            functions[159]= LS_CONSTANTS::NFA_LS_CONSTANTS_159;
            functions[160]= LS_CONSTANTS::NFA_LS_CONSTANTS_160;
            functions[161]= LS_CONSTANTS::NFA_LS_CONSTANTS_161;
            functions[162]= LS_CONSTANTS::NFA_LS_CONSTANTS_162;
            functions[163]= LS_CONSTANTS::NFA_LS_CONSTANTS_163;
            functions[164]= LS_CONSTANTS::NFA_LS_CONSTANTS_164;
            functions[165]= LS_CONSTANTS::NFA_LS_CONSTANTS_165;
            functions[166]= LS_CONSTANTS::NFA_LS_CONSTANTS_166;
            functions[167]= LS_CONSTANTS::NFA_LS_CONSTANTS_167;
            functions[168]= LS_CONSTANTS::NFA_LS_CONSTANTS_168;
            functions[169]= LS_CONSTANTS::NFA_LS_CONSTANTS_169;
            functions[170]= LS_CONSTANTS::NFA_LS_CONSTANTS_170;
            functions[171]= LS_CONSTANTS::NFA_LS_CONSTANTS_171;
            functions[172]= LS_CONSTANTS::NFA_LS_CONSTANTS_172;
            functions[173]= LS_CONSTANTS::NFA_LS_CONSTANTS_173;
            functions[174]= LS_CONSTANTS::NFA_LS_CONSTANTS_174;
            functions[175]= LS_CONSTANTS::NFA_LS_CONSTANTS_175;
            functions[176]= LS_CONSTANTS::NFA_LS_CONSTANTS_176;
            functions[177]= LS_CONSTANTS::NFA_LS_CONSTANTS_177;
            functions[178]= LS_CONSTANTS::NFA_LS_CONSTANTS_178;
            functions[179]= LS_CONSTANTS::NFA_LS_CONSTANTS_179;
            functions[180]= LS_CONSTANTS::NFA_LS_CONSTANTS_180;
            functions[181]= LS_CONSTANTS::NFA_LS_CONSTANTS_181;
            functions[182]= LS_CONSTANTS::NFA_LS_CONSTANTS_182;
            functions[183]= LS_CONSTANTS::NFA_LS_CONSTANTS_183;
            functions[184]= LS_CONSTANTS::NFA_LS_CONSTANTS_184;
            functions[185]= LS_CONSTANTS::NFA_LS_CONSTANTS_185;
            functions[186]= LS_CONSTANTS::NFA_LS_CONSTANTS_186;
            functions[187]= LS_CONSTANTS::NFA_LS_CONSTANTS_187;
            functions[188]= LS_CONSTANTS::NFA_LS_CONSTANTS_188;
            functions[189]= LS_CONSTANTS::NFA_LS_CONSTANTS_189;
            functions[190]= LS_CONSTANTS::NFA_LS_CONSTANTS_190;
            functions[191]= LS_CONSTANTS::NFA_LS_CONSTANTS_191;
            functions[192]= LS_CONSTANTS::NFA_LS_CONSTANTS_192;
            functions[193]= LS_CONSTANTS::NFA_LS_CONSTANTS_193;
            functions[194]= LS_CONSTANTS::NFA_LS_CONSTANTS_194;
            functions[195]= LS_CONSTANTS::NFA_LS_CONSTANTS_195;
            functions[196]= LS_CONSTANTS::NFA_LS_CONSTANTS_196;
            functions[197]= LS_CONSTANTS::NFA_LS_CONSTANTS_197;
            functions[198]= LS_CONSTANTS::NFA_LS_CONSTANTS_198;
            functions[199]= LS_CONSTANTS::NFA_LS_CONSTANTS_199;
            functions[200]= LS_CONSTANTS::NFA_LS_CONSTANTS_200;
            functions[201]= LS_CONSTANTS::NFA_LS_CONSTANTS_201;
            functions[202]= LS_CONSTANTS::NFA_LS_CONSTANTS_202;
            functions[203]= LS_CONSTANTS::NFA_LS_CONSTANTS_203;
            functions[204]= LS_CONSTANTS::NFA_LS_CONSTANTS_204;
            functions[205]= LS_CONSTANTS::NFA_LS_CONSTANTS_205;
            functions[206]= LS_CONSTANTS::NFA_LS_CONSTANTS_206;
            functions[207]= LS_CONSTANTS::NFA_LS_CONSTANTS_207;
            functions[208]= LS_CONSTANTS::NFA_LS_CONSTANTS_208;
            functions[209]= LS_CONSTANTS::NFA_LS_CONSTANTS_209;
            functions[210]= LS_CONSTANTS::NFA_LS_CONSTANTS_210;
            functions[211]= LS_CONSTANTS::NFA_LS_CONSTANTS_211;
            functions[212]= LS_CONSTANTS::NFA_LS_CONSTANTS_212;
            functions[213]= LS_CONSTANTS::NFA_LS_CONSTANTS_213;
            functions[214]= LS_CONSTANTS::NFA_LS_CONSTANTS_214;
            functions[215]= LS_CONSTANTS::NFA_LS_CONSTANTS_215;
            functions[216]= LS_CONSTANTS::NFA_LS_CONSTANTS_216;
            functions[217]= LS_CONSTANTS::NFA_LS_CONSTANTS_217;
            functions[218]= LS_CONSTANTS::NFA_LS_CONSTANTS_218;
            functions[219]= LS_CONSTANTS::NFA_LS_CONSTANTS_219;
            functions[220]= LS_CONSTANTS::NFA_LS_CONSTANTS_220;
            functions[221]= LS_CONSTANTS::NFA_LS_CONSTANTS_221;
            functions[222]= LS_CONSTANTS::NFA_LS_CONSTANTS_222;
            functions[223]= LS_CONSTANTS::NFA_LS_CONSTANTS_223;
            functions[224]= LS_CONSTANTS::NFA_LS_CONSTANTS_224;
            functions[225]= LS_CONSTANTS::NFA_LS_CONSTANTS_225;
            functions[226]= LS_CONSTANTS::NFA_LS_CONSTANTS_226;
            functions[227]= LS_CONSTANTS::NFA_LS_CONSTANTS_227;
            functions[228]= LS_CONSTANTS::NFA_LS_CONSTANTS_228;
            functions[229]= LS_CONSTANTS::NFA_LS_CONSTANTS_229;
            functions[230]= LS_CONSTANTS::NFA_LS_CONSTANTS_230;
            functions[231]= LS_CONSTANTS::NFA_LS_CONSTANTS_231;
            functions[232]= LS_CONSTANTS::NFA_LS_CONSTANTS_232;
            functions[233]= LS_CONSTANTS::NFA_LS_CONSTANTS_233;
            functions[234]= LS_CONSTANTS::NFA_LS_CONSTANTS_234;
            functions[235]= LS_CONSTANTS::NFA_LS_CONSTANTS_235;
            functions[236]= LS_CONSTANTS::NFA_LS_CONSTANTS_236;
            functions[237]= LS_CONSTANTS::NFA_LS_CONSTANTS_237;
            functions[238]= LS_CONSTANTS::NFA_LS_CONSTANTS_238;
            functions[239]= LS_CONSTANTS::NFA_LS_CONSTANTS_239;
            functions[240]= LS_CONSTANTS::NFA_LS_CONSTANTS_240;
            functions[241]= LS_CONSTANTS::NFA_LS_CONSTANTS_241;
            functions[242]= LS_CONSTANTS::NFA_LS_CONSTANTS_242;
            functions[243]= LS_CONSTANTS::NFA_LS_CONSTANTS_243;
            functions[244]= LS_CONSTANTS::NFA_LS_CONSTANTS_244;
            functions[245]= LS_CONSTANTS::NFA_LS_CONSTANTS_245;
            functions[246]= LS_CONSTANTS::NFA_LS_CONSTANTS_246;
            functions[247]= LS_CONSTANTS::NFA_LS_CONSTANTS_247;
            functions[248]= LS_CONSTANTS::NFA_LS_CONSTANTS_248;
            functions[249]= LS_CONSTANTS::NFA_LS_CONSTANTS_249;
            functions[250]= LS_CONSTANTS::NFA_LS_CONSTANTS_250;
            functions[251]= LS_CONSTANTS::NFA_LS_CONSTANTS_251;
            functions[252]= LS_CONSTANTS::NFA_LS_CONSTANTS_252;
            functions[253]= LS_CONSTANTS::NFA_LS_CONSTANTS_253;
            functions[254]= LS_CONSTANTS::NFA_LS_CONSTANTS_254;
            functions[255]= LS_CONSTANTS::NFA_LS_CONSTANTS_255;
            functions[256]= LS_CONSTANTS::NFA_LS_CONSTANTS_256;
            functions[257]= LS_CONSTANTS::NFA_LS_CONSTANTS_257;
            functions[258]= LS_CONSTANTS::NFA_LS_CONSTANTS_258;
            functions[259]= LS_CONSTANTS::NFA_LS_CONSTANTS_259;
            functions[260]= LS_CONSTANTS::NFA_LS_CONSTANTS_260;
            functions[261]= LS_CONSTANTS::NFA_LS_CONSTANTS_261;
            functions[262]= LS_CONSTANTS::NFA_LS_CONSTANTS_262;
            functions[263]= LS_CONSTANTS::NFA_LS_CONSTANTS_263;
            functions[264]= LS_CONSTANTS::NFA_LS_CONSTANTS_264;
            functions[265]= LS_CONSTANTS::NFA_LS_CONSTANTS_265;
            functions[266]= LS_CONSTANTS::NFA_LS_CONSTANTS_266;
            functions[267]= LS_CONSTANTS::NFA_LS_CONSTANTS_267;
            functions[268]= LS_CONSTANTS::NFA_LS_CONSTANTS_268;
            functions[269]= LS_CONSTANTS::NFA_LS_CONSTANTS_269;
            functions[270]= LS_CONSTANTS::NFA_LS_CONSTANTS_270;
            functions[271]= LS_CONSTANTS::NFA_LS_CONSTANTS_271;
            functions[272]= LS_CONSTANTS::NFA_LS_CONSTANTS_272;
            functions[273]= LS_CONSTANTS::NFA_LS_CONSTANTS_273;
            functions[274]= LS_CONSTANTS::NFA_LS_CONSTANTS_274;
            functions[275]= LS_CONSTANTS::NFA_LS_CONSTANTS_275;
            functions[276]= LS_CONSTANTS::NFA_LS_CONSTANTS_276;
            functions[277]= LS_CONSTANTS::NFA_LS_CONSTANTS_277;
            functions[278]= LS_CONSTANTS::NFA_LS_CONSTANTS_278;
            functions[279]= LS_CONSTANTS::NFA_LS_CONSTANTS_279;
            functions[280]= LS_CONSTANTS::NFA_LS_CONSTANTS_280;
            functions[281]= LS_CONSTANTS::NFA_LS_CONSTANTS_281;
            functions[282]= LS_CONSTANTS::NFA_LS_CONSTANTS_282;
            functions[283]= LS_CONSTANTS::NFA_LS_CONSTANTS_283;
            functions[284]= LS_CONSTANTS::NFA_LS_CONSTANTS_284;
            functions[285]= LS_CONSTANTS::NFA_LS_CONSTANTS_285;
            functions[286]= LS_CONSTANTS::NFA_LS_CONSTANTS_286;
            functions[287]= LS_CONSTANTS::NFA_LS_CONSTANTS_287;
            functions[288]= LS_CONSTANTS::NFA_LS_CONSTANTS_288;
            functions[289]= LS_CONSTANTS::NFA_LS_CONSTANTS_289;
            functions[290]= LS_CONSTANTS::NFA_LS_CONSTANTS_290;
            functions[291]= LS_CONSTANTS::NFA_LS_CONSTANTS_291;
            functions[292]= LS_CONSTANTS::NFA_LS_CONSTANTS_292;
            functions[293]= LS_CONSTANTS::NFA_LS_CONSTANTS_293;
            functions[294]= LS_CONSTANTS::NFA_LS_CONSTANTS_294;
            functions[295]= LS_CONSTANTS::NFA_LS_CONSTANTS_295;
            functions[296]= LS_CONSTANTS::NFA_LS_CONSTANTS_296;
            functions[297]= LS_CONSTANTS::NFA_LS_CONSTANTS_297;
            functions[298]= LS_CONSTANTS::NFA_LS_CONSTANTS_298;
            functions[299]= LS_CONSTANTS::NFA_LS_CONSTANTS_299;
            functions[300]= LS_CONSTANTS::NFA_LS_CONSTANTS_300;
            functions[301]= LS_CONSTANTS::NFA_LS_CONSTANTS_301;
            functions[302]= LS_CONSTANTS::NFA_LS_CONSTANTS_302;
            functions[303]= LS_CONSTANTS::NFA_LS_CONSTANTS_303;
            functions[304]= LS_CONSTANTS::NFA_LS_CONSTANTS_304;
            functions[305]= LS_CONSTANTS::NFA_LS_CONSTANTS_305;
            functions[306]= LS_CONSTANTS::NFA_LS_CONSTANTS_306;
            functions[307]= LS_CONSTANTS::NFA_LS_CONSTANTS_307;
            functions[308]= LS_CONSTANTS::NFA_LS_CONSTANTS_308;
            functions[309]= LS_CONSTANTS::NFA_LS_CONSTANTS_309;
            functions[310]= LS_CONSTANTS::NFA_LS_CONSTANTS_310;
            functions[311]= LS_CONSTANTS::NFA_LS_CONSTANTS_311;
            functions[312]= LS_CONSTANTS::NFA_LS_CONSTANTS_312;
            functions[313]= LS_CONSTANTS::NFA_LS_CONSTANTS_313;
            functions[314]= LS_CONSTANTS::NFA_LS_CONSTANTS_314;
            functions[315]= LS_CONSTANTS::NFA_LS_CONSTANTS_315;
            functions[316]= LS_CONSTANTS::NFA_LS_CONSTANTS_316;
            functions[317]= LS_CONSTANTS::NFA_LS_CONSTANTS_317;
            functions[318]= LS_CONSTANTS::NFA_LS_CONSTANTS_318;
            functions[319]= LS_CONSTANTS::NFA_LS_CONSTANTS_319;
            functions[320]= LS_CONSTANTS::NFA_LS_CONSTANTS_320;
            functions[321]= LS_CONSTANTS::NFA_LS_CONSTANTS_321;
            functions[322]= LS_CONSTANTS::NFA_LS_CONSTANTS_322;
            functions[323]= LS_CONSTANTS::NFA_LS_CONSTANTS_323;
            functions[324]= LS_CONSTANTS::NFA_LS_CONSTANTS_324;
            functions[325]= LS_CONSTANTS::NFA_LS_CONSTANTS_325;
            functions[326]= LS_CONSTANTS::NFA_LS_CONSTANTS_326;
            functions[327]= LS_CONSTANTS::NFA_LS_CONSTANTS_327;
            functions[328]= LS_CONSTANTS::NFA_LS_CONSTANTS_328;
            functions[329]= LS_CONSTANTS::NFA_LS_CONSTANTS_329;
            functions[330]= LS_CONSTANTS::NFA_LS_CONSTANTS_330;
            functions[331]= LS_CONSTANTS::NFA_LS_CONSTANTS_331;
            functions[332]= LS_CONSTANTS::NFA_LS_CONSTANTS_332;
            functions[333]= LS_CONSTANTS::NFA_LS_CONSTANTS_333;
            functions[334]= LS_CONSTANTS::NFA_LS_CONSTANTS_334;
            functions[335]= LS_CONSTANTS::NFA_LS_CONSTANTS_335;
            functions[336]= LS_CONSTANTS::NFA_LS_CONSTANTS_336;
            functions[337]= LS_CONSTANTS::NFA_LS_CONSTANTS_337;
            functions[338]= LS_CONSTANTS::NFA_LS_CONSTANTS_338;
            functions[339]= LS_CONSTANTS::NFA_LS_CONSTANTS_339;
            functions[340]= LS_CONSTANTS::NFA_LS_CONSTANTS_340;
            functions[341]= LS_CONSTANTS::NFA_LS_CONSTANTS_341;
            functions[342]= LS_CONSTANTS::NFA_LS_CONSTANTS_342;
            functions[343]= LS_CONSTANTS::NFA_LS_CONSTANTS_343;
            functions[344]= LS_CONSTANTS::NFA_LS_CONSTANTS_344;
            functions[345]= LS_CONSTANTS::NFA_LS_CONSTANTS_345;
            functions[346]= LS_CONSTANTS::NFA_LS_CONSTANTS_346;
            functions[347]= LS_CONSTANTS::NFA_LS_CONSTANTS_347;
            functions[348]= LS_CONSTANTS::NFA_LS_CONSTANTS_348;
            functions[349]= LS_CONSTANTS::NFA_LS_CONSTANTS_349;
            functions[350]= LS_CONSTANTS::NFA_LS_CONSTANTS_350;
            functions[351]= LS_CONSTANTS::NFA_LS_CONSTANTS_351;
            functions[352]= LS_CONSTANTS::NFA_LS_CONSTANTS_352;
            functions[353]= LS_CONSTANTS::NFA_LS_CONSTANTS_353;
            functions[354]= LS_CONSTANTS::NFA_LS_CONSTANTS_354;
            functions[355]= LS_CONSTANTS::NFA_LS_CONSTANTS_355;
            functions[356]= LS_CONSTANTS::NFA_LS_CONSTANTS_356;
            functions[357]= LS_CONSTANTS::NFA_LS_CONSTANTS_357;
            functions[358]= LS_CONSTANTS::NFA_LS_CONSTANTS_358;
            functions[359]= LS_CONSTANTS::NFA_LS_CONSTANTS_359;
            functions[360]= LS_CONSTANTS::NFA_LS_CONSTANTS_360;
            functions[361]= LS_CONSTANTS::NFA_LS_CONSTANTS_361;
            functions[362]= LS_CONSTANTS::NFA_LS_CONSTANTS_362;
            functions[363]= LS_CONSTANTS::NFA_LS_CONSTANTS_363;
            functions[364]= LS_CONSTANTS::NFA_LS_CONSTANTS_364;
            functions[365]= LS_CONSTANTS::NFA_LS_CONSTANTS_365;
            functions[366]= LS_CONSTANTS::NFA_LS_CONSTANTS_366;
            functions[367]= LS_CONSTANTS::NFA_LS_CONSTANTS_367;
            functions[368]= LS_CONSTANTS::NFA_LS_CONSTANTS_368;
            functions[369]= LS_CONSTANTS::NFA_LS_CONSTANTS_369;
            functions[370]= LS_CONSTANTS::NFA_LS_CONSTANTS_370;
            functions[371]= LS_CONSTANTS::NFA_LS_CONSTANTS_371;
            functions[372]= LS_CONSTANTS::NFA_LS_CONSTANTS_372;
            functions[373]= LS_CONSTANTS::NFA_LS_CONSTANTS_373;
            functions[374]= LS_CONSTANTS::NFA_LS_CONSTANTS_374;
            functions[375]= LS_CONSTANTS::NFA_LS_CONSTANTS_375;
            functions[376]= LS_CONSTANTS::NFA_LS_CONSTANTS_376;
            functions[377]= LS_CONSTANTS::NFA_LS_CONSTANTS_377;
            functions[378]= LS_CONSTANTS::NFA_LS_CONSTANTS_378;
            functions[379]= LS_CONSTANTS::NFA_LS_CONSTANTS_379;
            functions[380]= LS_CONSTANTS::NFA_LS_CONSTANTS_380;
            functions[381]= LS_CONSTANTS::NFA_LS_CONSTANTS_381;
            functions[382]= LS_CONSTANTS::NFA_LS_CONSTANTS_382;
            functions[383]= LS_CONSTANTS::NFA_LS_CONSTANTS_383;
            functions[384]= LS_CONSTANTS::NFA_LS_CONSTANTS_384;
            functions[385]= LS_CONSTANTS::NFA_LS_CONSTANTS_385;
            functions[386]= LS_CONSTANTS::NFA_LS_CONSTANTS_386;
            functions[387]= LS_CONSTANTS::NFA_LS_CONSTANTS_387;
            functions[388]= LS_CONSTANTS::NFA_LS_CONSTANTS_388;
            functions[389]= LS_CONSTANTS::NFA_LS_CONSTANTS_389;
            functions[390]= LS_CONSTANTS::NFA_LS_CONSTANTS_390;
            functions[391]= LS_CONSTANTS::NFA_LS_CONSTANTS_391;
            functions[392]= LS_CONSTANTS::NFA_LS_CONSTANTS_392;
            functions[393]= LS_CONSTANTS::NFA_LS_CONSTANTS_393;
            functions[394]= LS_CONSTANTS::NFA_LS_CONSTANTS_394;
            functions[395]= LS_CONSTANTS::NFA_LS_CONSTANTS_395;
            functions[396]= LS_CONSTANTS::NFA_LS_CONSTANTS_396;
            functions[397]= LS_CONSTANTS::NFA_LS_CONSTANTS_397;
            functions[398]= LS_CONSTANTS::NFA_LS_CONSTANTS_398;
            functions[399]= LS_CONSTANTS::NFA_LS_CONSTANTS_399;
            functions[400]= LS_CONSTANTS::NFA_LS_CONSTANTS_400;
            functions[401]= LS_CONSTANTS::NFA_LS_CONSTANTS_401;
            functions[402]= LS_CONSTANTS::NFA_LS_CONSTANTS_402;
            functions[403]= LS_CONSTANTS::NFA_LS_CONSTANTS_403;
            functions[404]= LS_CONSTANTS::NFA_LS_CONSTANTS_404;
            functions[405]= LS_CONSTANTS::NFA_LS_CONSTANTS_405;
            functions[406]= LS_CONSTANTS::NFA_LS_CONSTANTS_406;
            functions[407]= LS_CONSTANTS::NFA_LS_CONSTANTS_407;
            functions[408]= LS_CONSTANTS::NFA_LS_CONSTANTS_408;
            functions[409]= LS_CONSTANTS::NFA_LS_CONSTANTS_409;
            functions[410]= LS_CONSTANTS::NFA_LS_CONSTANTS_410;
            functions[411]= LS_CONSTANTS::NFA_LS_CONSTANTS_411;
            functions[412]= LS_CONSTANTS::NFA_LS_CONSTANTS_412;
            functions[413]= LS_CONSTANTS::NFA_LS_CONSTANTS_413;
            functions[414]= LS_CONSTANTS::NFA_LS_CONSTANTS_414;
            functions[415]= LS_CONSTANTS::NFA_LS_CONSTANTS_415;
            functions[416]= LS_CONSTANTS::NFA_LS_CONSTANTS_416;
            functions[417]= LS_CONSTANTS::NFA_LS_CONSTANTS_417;
            functions[418]= LS_CONSTANTS::NFA_LS_CONSTANTS_418;
            functions[419]= LS_CONSTANTS::NFA_LS_CONSTANTS_419;
            functions[420]= LS_CONSTANTS::NFA_LS_CONSTANTS_420;
            functions[421]= LS_CONSTANTS::NFA_LS_CONSTANTS_421;
            functions[422]= LS_CONSTANTS::NFA_LS_CONSTANTS_422;
            functions[423]= LS_CONSTANTS::NFA_LS_CONSTANTS_423;
            functions[424]= LS_CONSTANTS::NFA_LS_CONSTANTS_424;
            functions[425]= LS_CONSTANTS::NFA_LS_CONSTANTS_425;
            functions[426]= LS_CONSTANTS::NFA_LS_CONSTANTS_426;
            functions[427]= LS_CONSTANTS::NFA_LS_CONSTANTS_427;
            functions[428]= LS_CONSTANTS::NFA_LS_CONSTANTS_428;
            functions[429]= LS_CONSTANTS::NFA_LS_CONSTANTS_429;
            functions[430]= LS_CONSTANTS::NFA_LS_CONSTANTS_430;
            functions[431]= LS_CONSTANTS::NFA_LS_CONSTANTS_431;
            functions[432]= LS_CONSTANTS::NFA_LS_CONSTANTS_432;
            functions[433]= LS_CONSTANTS::NFA_LS_CONSTANTS_433;
            functions[434]= LS_CONSTANTS::NFA_LS_CONSTANTS_434;
            functions[435]= LS_CONSTANTS::NFA_LS_CONSTANTS_435;
            functions[436]= LS_CONSTANTS::NFA_LS_CONSTANTS_436;
            functions[437]= LS_CONSTANTS::NFA_LS_CONSTANTS_437;
            functions[438]= LS_CONSTANTS::NFA_LS_CONSTANTS_438;
            functions[439]= LS_CONSTANTS::NFA_LS_CONSTANTS_439;
            functions[440]= LS_CONSTANTS::NFA_LS_CONSTANTS_440;
            functions[441]= LS_CONSTANTS::NFA_LS_CONSTANTS_441;
            functions[442]= LS_CONSTANTS::NFA_LS_CONSTANTS_442;
            functions[443]= LS_CONSTANTS::NFA_LS_CONSTANTS_443;
            functions[444]= LS_CONSTANTS::NFA_LS_CONSTANTS_444;
            functions[445]= LS_CONSTANTS::NFA_LS_CONSTANTS_445;
            functions[446]= LS_CONSTANTS::NFA_LS_CONSTANTS_446;
            functions[447]= LS_CONSTANTS::NFA_LS_CONSTANTS_447;
            functions[448]= LS_CONSTANTS::NFA_LS_CONSTANTS_448;
            functions[449]= LS_CONSTANTS::NFA_LS_CONSTANTS_449;
            functions[450]= LS_CONSTANTS::NFA_LS_CONSTANTS_450;
            functions[451]= LS_CONSTANTS::NFA_LS_CONSTANTS_451;
            functions[452]= LS_CONSTANTS::NFA_LS_CONSTANTS_452;
            functions[453]= LS_CONSTANTS::NFA_LS_CONSTANTS_453;
            functions[454]= LS_CONSTANTS::NFA_LS_CONSTANTS_454;
            functions[455]= LS_CONSTANTS::NFA_LS_CONSTANTS_455;
            functions[456]= LS_CONSTANTS::NFA_LS_CONSTANTS_456;
            functions[457]= LS_CONSTANTS::NFA_LS_CONSTANTS_457;
            functions[458]= LS_CONSTANTS::NFA_LS_CONSTANTS_458;
            functions[459]= LS_CONSTANTS::NFA_LS_CONSTANTS_459;
            functions[460]= LS_CONSTANTS::NFA_LS_CONSTANTS_460;
            functions[461]= LS_CONSTANTS::NFA_LS_CONSTANTS_461;
            functions[462]= LS_CONSTANTS::NFA_LS_CONSTANTS_462;
            functions[463]= LS_CONSTANTS::NFA_LS_CONSTANTS_463;
            functions[464]= LS_CONSTANTS::NFA_LS_CONSTANTS_464;
            functions[465]= LS_CONSTANTS::NFA_LS_CONSTANTS_465;
            functions[466]= LS_CONSTANTS::NFA_LS_CONSTANTS_466;
            functions[467]= LS_CONSTANTS::NFA_LS_CONSTANTS_467;
            functions[468]= LS_CONSTANTS::NFA_LS_CONSTANTS_468;
            functions[469]= LS_CONSTANTS::NFA_LS_CONSTANTS_469;
            functions[470]= LS_CONSTANTS::NFA_LS_CONSTANTS_470;
            functions[471]= LS_CONSTANTS::NFA_LS_CONSTANTS_471;
            functions[472]= LS_CONSTANTS::NFA_LS_CONSTANTS_472;
            functions[473]= LS_CONSTANTS::NFA_LS_CONSTANTS_473;
            functions[474]= LS_CONSTANTS::NFA_LS_CONSTANTS_474;
            functions[475]= LS_CONSTANTS::NFA_LS_CONSTANTS_475;
            functions[476]= LS_CONSTANTS::NFA_LS_CONSTANTS_476;
            functions[477]= LS_CONSTANTS::NFA_LS_CONSTANTS_477;
            functions[478]= LS_CONSTANTS::NFA_LS_CONSTANTS_478;
            functions[479]= LS_CONSTANTS::NFA_LS_CONSTANTS_479;
            functions[480]= LS_CONSTANTS::NFA_LS_CONSTANTS_480;
            functions[481]= LS_CONSTANTS::NFA_LS_CONSTANTS_481;
            functions[482]= LS_CONSTANTS::NFA_LS_CONSTANTS_482;
            functions[483]= LS_CONSTANTS::NFA_LS_CONSTANTS_483;
            functions[484]= LS_CONSTANTS::NFA_LS_CONSTANTS_484;
            functions[485]= LS_CONSTANTS::NFA_LS_CONSTANTS_485;
            functions[486]= LS_CONSTANTS::NFA_LS_CONSTANTS_486;
            functions[487]= LS_CONSTANTS::NFA_LS_CONSTANTS_487;
            functions[488]= LS_CONSTANTS::NFA_LS_CONSTANTS_488;
            functions[489]= LS_CONSTANTS::NFA_LS_CONSTANTS_489;
            functions[490]= LS_CONSTANTS::NFA_LS_CONSTANTS_490;
            functions[491]= LS_CONSTANTS::NFA_LS_CONSTANTS_491;
            functions[492]= LS_CONSTANTS::NFA_LS_CONSTANTS_492;
            functionTableMap.put(LexicalState.LS_CONSTANTS, functions);
        }

    }
    /**
  * Holder class for NFA code related to LS_PLAIN_PATH lexical state
  */
    private static class LS_PLAIN_PATH {
        static TokenType NFA_COMPOSITE_LS_PLAIN_PATH_0(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            TokenType type= null;
            if (ch== '[') {
                nextStates.set(1);
            }
            else if ((ch== '-'||ch== '.')||((ch>='0'&&ch<='9')||((ch>='@'&&ch<='Z')||((ch== '_')||(ch>='a'&&ch<='z'))))) {
                nextStates.set(5);
                if (validTypes.contains(T_CHARSEQ)) type= T_CHARSEQ;
            }
            else if (ch== '/') {
                if (validTypes.contains(T_PATH_SEPARATOR)) type= T_PATH_SEPARATOR;
            }
            else if (ch== '\t') {
                if (validTypes.contains(_TOKEN_4)) type= _TOKEN_4;
            }
            else if (ch== '\r') {
                if (validTypes.contains(_TOKEN_3)) type= _TOKEN_3;
            }
            else if (ch== '\n') {
                if (validTypes.contains(_TOKEN_2)) type= _TOKEN_2;
            }
            else if (ch== ' ') {
                if (validTypes.contains(_TOKEN_1)) type= _TOKEN_1;
            }
            return type;
        }

        static TokenType NFA_COMPOSITE_LS_PLAIN_PATH_1(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            TokenType type= null;
            if ((ch== '+')||(ch== '-')) {
                nextStates.set(2);
            }
            else if (ch>='0'&&ch<='9') {
                nextStates.set(13);
            }
            if (ch>='1'&&ch<='9') {
                nextStates.set(15);
            }
            return type;
        }

        static TokenType NFA_COMPOSITE_LS_PLAIN_PATH_2(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            TokenType type= null;
            if (ch>='0'&&ch<='9') {
                nextStates.set(13);
            }
            if (ch>='1'&&ch<='9') {
                nextStates.set(15);
            }
            return type;
        }

        static TokenType NFA_COMPOSITE_LS_PLAIN_PATH_3(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            TokenType type= null;
            if (ch>='0'&&ch<='9') {
                nextStates.set(3);
            }
            else if (ch== ']') {
                if (validTypes.contains(T_ARRAYINDEX)) type= T_ARRAYINDEX;
            }
            return type;
        }

        static TokenType NFA_LS_PLAIN_PATH_4(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch== '\n') {
                if (validTypes.contains(_TOKEN_2)) return _TOKEN_2;
            }
            return null;
        }

        static TokenType NFA_LS_PLAIN_PATH_5(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== '-'||ch== '.')||((ch>='0'&&ch<='9')||((ch>='@'&&ch<='Z')||((ch== '_')||(ch>='a'&&ch<='z'))))) {
                nextStates.set(5);
                if (validTypes.contains(T_CHARSEQ)) return T_CHARSEQ;
            }
            return null;
        }

        static TokenType NFA_LS_PLAIN_PATH_6(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch== ' ') {
                if (validTypes.contains(_TOKEN_1)) return _TOKEN_1;
            }
            return null;
        }

        static TokenType NFA_LS_PLAIN_PATH_7(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch== '\t') {
                if (validTypes.contains(_TOKEN_4)) return _TOKEN_4;
            }
            return null;
        }

        static TokenType NFA_LS_PLAIN_PATH_8(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch== '[') {
                nextStates.set(1);
            }
            return null;
        }

        static TokenType NFA_LS_PLAIN_PATH_9(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch== '\r') {
                if (validTypes.contains(_TOKEN_3)) return _TOKEN_3;
            }
            return null;
        }

        static TokenType NFA_LS_PLAIN_PATH_10(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch== '/') {
                if (validTypes.contains(T_PATH_SEPARATOR)) return T_PATH_SEPARATOR;
            }
            return null;
        }

        static TokenType NFA_LS_PLAIN_PATH_11(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch>='0'&&ch<='9') {
                nextStates.set(13);
            }
            return null;
        }

        static TokenType NFA_LS_PLAIN_PATH_12(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch>='1'&&ch<='9') {
                nextStates.set(15);
            }
            return null;
        }

        static TokenType NFA_LS_PLAIN_PATH_13(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch== ']') {
                if (validTypes.contains(T_ARRAYINDEX)) return T_ARRAYINDEX;
            }
            return null;
        }

        static TokenType NFA_LS_PLAIN_PATH_14(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== '+')||(ch== '-')) {
                nextStates.set(2);
            }
            return null;
        }

        static TokenType NFA_LS_PLAIN_PATH_15(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch>='0'&&ch<='9') {
                nextStates.set(3);
            }
            return null;
        }

        static private void NFA_FUNCTIONS_init() {
            NfaFunction[] functions= new NfaFunction[16];
            functions[0]= LS_PLAIN_PATH::NFA_COMPOSITE_LS_PLAIN_PATH_0;
            functions[1]= LS_PLAIN_PATH::NFA_COMPOSITE_LS_PLAIN_PATH_1;
            functions[2]= LS_PLAIN_PATH::NFA_COMPOSITE_LS_PLAIN_PATH_2;
            functions[3]= LS_PLAIN_PATH::NFA_COMPOSITE_LS_PLAIN_PATH_3;
            functions[4]= LS_PLAIN_PATH::NFA_LS_PLAIN_PATH_4;
            functions[5]= LS_PLAIN_PATH::NFA_LS_PLAIN_PATH_5;
            functions[6]= LS_PLAIN_PATH::NFA_LS_PLAIN_PATH_6;
            functions[7]= LS_PLAIN_PATH::NFA_LS_PLAIN_PATH_7;
            functions[8]= LS_PLAIN_PATH::NFA_LS_PLAIN_PATH_8;
            functions[9]= LS_PLAIN_PATH::NFA_LS_PLAIN_PATH_9;
            functions[10]= LS_PLAIN_PATH::NFA_LS_PLAIN_PATH_10;
            functions[11]= LS_PLAIN_PATH::NFA_LS_PLAIN_PATH_11;
            functions[12]= LS_PLAIN_PATH::NFA_LS_PLAIN_PATH_12;
            functions[13]= LS_PLAIN_PATH::NFA_LS_PLAIN_PATH_13;
            functions[14]= LS_PLAIN_PATH::NFA_LS_PLAIN_PATH_14;
            functions[15]= LS_PLAIN_PATH::NFA_LS_PLAIN_PATH_15;
            functionTableMap.put(LexicalState.LS_PLAIN_PATH, functions);
        }

    }
    /**
  * Holder class for NFA code related to LS_ORDERBYS lexical state
  */
    private static class LS_ORDERBYS {
        static TokenType NFA_COMPOSITE_LS_ORDERBYS_0(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            TokenType type= null;
            if (ch== ',') {
                if (validTypes.contains(T_VALUE_SEPARATOR)) type= T_VALUE_SEPARATOR;
            }
            else if (ch== '\t') {
                if (validTypes.contains(_TOKEN_4)) type= _TOKEN_4;
            }
            else if (ch== '\r') {
                if (validTypes.contains(_TOKEN_3)) type= _TOKEN_3;
            }
            else if (ch== '\n') {
                if (validTypes.contains(_TOKEN_2)) type= _TOKEN_2;
            }
            else if (ch== ' ') {
                if (validTypes.contains(_TOKEN_1)) type= _TOKEN_1;
            }
            return type;
        }

        static TokenType NFA_LS_ORDERBYS_1(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch== '\r') {
                if (validTypes.contains(_TOKEN_3)) return _TOKEN_3;
            }
            return null;
        }

        static TokenType NFA_LS_ORDERBYS_2(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch== ',') {
                if (validTypes.contains(T_VALUE_SEPARATOR)) return T_VALUE_SEPARATOR;
            }
            return null;
        }

        static TokenType NFA_LS_ORDERBYS_3(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch== '\n') {
                if (validTypes.contains(_TOKEN_2)) return _TOKEN_2;
            }
            return null;
        }

        static TokenType NFA_LS_ORDERBYS_4(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch== '\t') {
                if (validTypes.contains(_TOKEN_4)) return _TOKEN_4;
            }
            return null;
        }

        static TokenType NFA_LS_ORDERBYS_5(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch== ' ') {
                if (validTypes.contains(_TOKEN_1)) return _TOKEN_1;
            }
            return null;
        }

        static private void NFA_FUNCTIONS_init() {
            NfaFunction[] functions= new NfaFunction[6];
            functions[0]= LS_ORDERBYS::NFA_COMPOSITE_LS_ORDERBYS_0;
            functions[1]= LS_ORDERBYS::NFA_LS_ORDERBYS_1;
            functions[2]= LS_ORDERBYS::NFA_LS_ORDERBYS_2;
            functions[3]= LS_ORDERBYS::NFA_LS_ORDERBYS_3;
            functions[4]= LS_ORDERBYS::NFA_LS_ORDERBYS_4;
            functions[5]= LS_ORDERBYS::NFA_LS_ORDERBYS_5;
            functionTableMap.put(LexicalState.LS_ORDERBYS, functions);
        }

    }
    /**
  * Holder class for NFA code related to LS_ORDERBY lexical state
  */
    private static class LS_ORDERBY {
        static TokenType NFA_COMPOSITE_LS_ORDERBY_0(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            TokenType type= null;
            if ((ch== 'A')||(ch== 'a')) {
                nextStates.set(8);
            }
            else if ((ch== 'D')||(ch== 'd')) {
                nextStates.set(11);
            }
            else if (ch== '\t') {
                if (validTypes.contains(_TOKEN_4)) type= _TOKEN_4;
            }
            else if (ch== '\r') {
                if (validTypes.contains(_TOKEN_3)) type= _TOKEN_3;
            }
            else if (ch== '\n') {
                if (validTypes.contains(_TOKEN_2)) type= _TOKEN_2;
            }
            else if (ch== ' ') {
                if (validTypes.contains(_TOKEN_1)) type= _TOKEN_1;
            }
            return type;
        }

        static TokenType NFA_LS_ORDERBY_1(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'C')||(ch== 'c')) {
                if (validTypes.contains(T_O_ASC)) return T_O_ASC;
            }
            return null;
        }

        static TokenType NFA_LS_ORDERBY_2(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'A')||(ch== 'a')) {
                nextStates.set(8);
            }
            return null;
        }

        static TokenType NFA_LS_ORDERBY_3(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'D')||(ch== 'd')) {
                nextStates.set(11);
            }
            return null;
        }

        static TokenType NFA_LS_ORDERBY_4(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch== '\n') {
                if (validTypes.contains(_TOKEN_2)) return _TOKEN_2;
            }
            return null;
        }

        static TokenType NFA_LS_ORDERBY_5(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'S')||(ch== 's')) {
                nextStates.set(7);
            }
            return null;
        }

        static TokenType NFA_LS_ORDERBY_6(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch== '\t') {
                if (validTypes.contains(_TOKEN_4)) return _TOKEN_4;
            }
            return null;
        }

        static TokenType NFA_LS_ORDERBY_7(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'C')||(ch== 'c')) {
                if (validTypes.contains(T_O_DESC)) return T_O_DESC;
            }
            return null;
        }

        static TokenType NFA_LS_ORDERBY_8(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'S')||(ch== 's')) {
                nextStates.set(1);
            }
            return null;
        }

        static TokenType NFA_LS_ORDERBY_9(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch== ' ') {
                if (validTypes.contains(_TOKEN_1)) return _TOKEN_1;
            }
            return null;
        }

        static TokenType NFA_LS_ORDERBY_10(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch== '\r') {
                if (validTypes.contains(_TOKEN_3)) return _TOKEN_3;
            }
            return null;
        }

        static TokenType NFA_LS_ORDERBY_11(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'E')||(ch== 'e')) {
                nextStates.set(5);
            }
            return null;
        }

        static private void NFA_FUNCTIONS_init() {
            NfaFunction[] functions= new NfaFunction[12];
            functions[0]= LS_ORDERBY::NFA_COMPOSITE_LS_ORDERBY_0;
            functions[1]= LS_ORDERBY::NFA_LS_ORDERBY_1;
            functions[2]= LS_ORDERBY::NFA_LS_ORDERBY_2;
            functions[3]= LS_ORDERBY::NFA_LS_ORDERBY_3;
            functions[4]= LS_ORDERBY::NFA_LS_ORDERBY_4;
            functions[5]= LS_ORDERBY::NFA_LS_ORDERBY_5;
            functions[6]= LS_ORDERBY::NFA_LS_ORDERBY_6;
            functions[7]= LS_ORDERBY::NFA_LS_ORDERBY_7;
            functions[8]= LS_ORDERBY::NFA_LS_ORDERBY_8;
            functions[9]= LS_ORDERBY::NFA_LS_ORDERBY_9;
            functions[10]= LS_ORDERBY::NFA_LS_ORDERBY_10;
            functions[11]= LS_ORDERBY::NFA_LS_ORDERBY_11;
            functionTableMap.put(LexicalState.LS_ORDERBY, functions);
        }

    }
    /**
  * Holder class for NFA code related to LS_ANYSTRING lexical state
  */
    private static class LS_ANYSTRING {
        static TokenType NFA_LS_ANYSTRING_0(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch>=0x0&&ch<='%')||(ch>='\'')) {
                nextStates.set(0);
                if (validTypes.contains(T_STRING)) return T_STRING;
            }
            return null;
        }

        static private void NFA_FUNCTIONS_init() {
            NfaFunction[] functions= new NfaFunction[1];
            functions[0]= LS_ANYSTRING::NFA_LS_ANYSTRING_0;
            functionTableMap.put(LexicalState.LS_ANYSTRING, functions);
        }

    }
    /**
  * Holder class for NFA code related to LS_FORMAT lexical state
  */
    private static class LS_FORMAT {
        static TokenType NFA_LS_FORMAT_0(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== '%')||((ch>='-'&&ch<=';')||((ch== '=')||((ch>='@'&&ch<='Z')||((ch== '_')||(ch>='a'&&ch<='z')))))) {
                nextStates.set(0);
                if (validTypes.contains(T_CHARSEQ_FORMAT)) return T_CHARSEQ_FORMAT;
            }
            return null;
        }

        static private void NFA_FUNCTIONS_init() {
            NfaFunction[] functions= new NfaFunction[1];
            functions[0]= LS_FORMAT::NFA_LS_FORMAT_0;
            functionTableMap.put(LexicalState.LS_FORMAT, functions);
        }

    }
    /**
  * Holder class for NFA code related to LS_METADATA lexical state
  */
    private static class LS_METADATA {
        static TokenType NFA_LS_METADATA_0(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch>='0'&&ch<='9')||((ch>='A'&&ch<='Z')||(ch>='a'&&ch<='z'))) {
                nextStates.set(0);
                if (validTypes.contains(T_CHARSEQ_METADATA)) return T_CHARSEQ_METADATA;
            }
            return null;
        }

        static private void NFA_FUNCTIONS_init() {
            NfaFunction[] functions= new NfaFunction[1];
            functions[0]= LS_METADATA::NFA_LS_METADATA_0;
            functionTableMap.put(LexicalState.LS_METADATA, functions);
        }

    }
    /**
  * Holder class for NFA code related to LS_COUNT lexical state
  */
    private static class LS_COUNT {
        static TokenType NFA_COMPOSITE_LS_COUNT_0(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            TokenType type= null;
            if ((ch== 'F')||(ch== 'f')) {
                nextStates.set(2);
            }
            else if ((ch== 'T')||(ch== 't')) {
                nextStates.set(5);
            }
            return type;
        }

        static TokenType NFA_LS_COUNT_1(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'E')||(ch== 'e')) {
                if (validTypes.contains(T_BOOL)) return T_BOOL;
            }
            return null;
        }

        static TokenType NFA_LS_COUNT_2(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'A')||(ch== 'a')) {
                nextStates.set(8);
            }
            return null;
        }

        static TokenType NFA_LS_COUNT_3(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'U')||(ch== 'u')) {
                nextStates.set(1);
            }
            return null;
        }

        static TokenType NFA_LS_COUNT_4(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'F')||(ch== 'f')) {
                nextStates.set(2);
            }
            return null;
        }

        static TokenType NFA_LS_COUNT_5(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'R')||(ch== 'r')) {
                nextStates.set(3);
            }
            return null;
        }

        static TokenType NFA_LS_COUNT_6(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'S')||(ch== 's')) {
                nextStates.set(9);
            }
            return null;
        }

        static TokenType NFA_LS_COUNT_7(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'T')||(ch== 't')) {
                nextStates.set(5);
            }
            return null;
        }

        static TokenType NFA_LS_COUNT_8(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'L')||(ch== 'l')) {
                nextStates.set(6);
            }
            return null;
        }

        static TokenType NFA_LS_COUNT_9(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'E')||(ch== 'e')) {
                if (validTypes.contains(T_BOOL)) return T_BOOL;
            }
            return null;
        }

        static private void NFA_FUNCTIONS_init() {
            NfaFunction[] functions= new NfaFunction[10];
            functions[0]= LS_COUNT::NFA_COMPOSITE_LS_COUNT_0;
            functions[1]= LS_COUNT::NFA_LS_COUNT_1;
            functions[2]= LS_COUNT::NFA_LS_COUNT_2;
            functions[3]= LS_COUNT::NFA_LS_COUNT_3;
            functions[4]= LS_COUNT::NFA_LS_COUNT_4;
            functions[5]= LS_COUNT::NFA_LS_COUNT_5;
            functions[6]= LS_COUNT::NFA_LS_COUNT_6;
            functions[7]= LS_COUNT::NFA_LS_COUNT_7;
            functions[8]= LS_COUNT::NFA_LS_COUNT_8;
            functions[9]= LS_COUNT::NFA_LS_COUNT_9;
            functionTableMap.put(LexicalState.LS_COUNT, functions);
        }

    }
    /**
  * Holder class for NFA code related to LS_TOP lexical state
  */
    private static class LS_TOP {
        static TokenType NFA_COMPOSITE_LS_TOP_0(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            TokenType type= null;
            if ((ch== '+')||(ch== '-')) {
                nextStates.set(1);
            }
            else if (ch>='1'&&ch<='9') {
                nextStates.set(2);
            }
            if (ch>='0'&&ch<='9') {
                if (validTypes.contains(T_LONG)) type= T_LONG;
            }
            return type;
        }

        static TokenType NFA_COMPOSITE_LS_TOP_1(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            TokenType type= null;
            if (ch>='1'&&ch<='9') {
                nextStates.set(2);
            }
            if (ch>='0'&&ch<='9') {
                if (validTypes.contains(T_LONG)) type= T_LONG;
            }
            return type;
        }

        static TokenType NFA_LS_TOP_2(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch>='0'&&ch<='9') {
                nextStates.set(2);
                if (validTypes.contains(T_LONG)) return T_LONG;
            }
            return null;
        }

        static TokenType NFA_LS_TOP_3(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== '+')||(ch== '-')) {
                nextStates.set(1);
            }
            return null;
        }

        static TokenType NFA_LS_TOP_4(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch>='1'&&ch<='9') {
                nextStates.set(2);
            }
            return null;
        }

        static TokenType NFA_LS_TOP_5(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch>='0'&&ch<='9') {
                if (validTypes.contains(T_LONG)) return T_LONG;
            }
            return null;
        }

        static private void NFA_FUNCTIONS_init() {
            NfaFunction[] functions= new NfaFunction[6];
            functions[0]= LS_TOP::NFA_COMPOSITE_LS_TOP_0;
            functions[1]= LS_TOP::NFA_COMPOSITE_LS_TOP_1;
            functions[2]= LS_TOP::NFA_LS_TOP_2;
            functions[3]= LS_TOP::NFA_LS_TOP_3;
            functions[4]= LS_TOP::NFA_LS_TOP_4;
            functions[5]= LS_TOP::NFA_LS_TOP_5;
            functionTableMap.put(LexicalState.LS_TOP, functions);
        }

    }
    /**
  * Holder class for NFA code related to LS_SKIP lexical state
  */
    private static class LS_SKIP {
        static TokenType NFA_COMPOSITE_LS_SKIP_0(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            TokenType type= null;
            if ((ch== '+')||(ch== '-')) {
                nextStates.set(1);
            }
            else if (ch>='1'&&ch<='9') {
                nextStates.set(2);
            }
            if (ch>='0'&&ch<='9') {
                if (validTypes.contains(T_LONG)) type= T_LONG;
            }
            return type;
        }

        static TokenType NFA_COMPOSITE_LS_SKIP_1(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            TokenType type= null;
            if (ch>='1'&&ch<='9') {
                nextStates.set(2);
            }
            if (ch>='0'&&ch<='9') {
                if (validTypes.contains(T_LONG)) type= T_LONG;
            }
            return type;
        }

        static TokenType NFA_LS_SKIP_2(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch>='0'&&ch<='9') {
                nextStates.set(2);
                if (validTypes.contains(T_LONG)) return T_LONG;
            }
            return null;
        }

        static TokenType NFA_LS_SKIP_3(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== '+')||(ch== '-')) {
                nextStates.set(1);
            }
            return null;
        }

        static TokenType NFA_LS_SKIP_4(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch>='1'&&ch<='9') {
                nextStates.set(2);
            }
            return null;
        }

        static TokenType NFA_LS_SKIP_5(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch>='0'&&ch<='9') {
                if (validTypes.contains(T_LONG)) return T_LONG;
            }
            return null;
        }

        static private void NFA_FUNCTIONS_init() {
            NfaFunction[] functions= new NfaFunction[6];
            functions[0]= LS_SKIP::NFA_COMPOSITE_LS_SKIP_0;
            functions[1]= LS_SKIP::NFA_COMPOSITE_LS_SKIP_1;
            functions[2]= LS_SKIP::NFA_LS_SKIP_2;
            functions[3]= LS_SKIP::NFA_LS_SKIP_3;
            functions[4]= LS_SKIP::NFA_LS_SKIP_4;
            functions[5]= LS_SKIP::NFA_LS_SKIP_5;
            functionTableMap.put(LexicalState.LS_SKIP, functions);
        }

    }
    /**
  * Holder class for NFA code related to LS_EXPAND lexical state
  */
    private static class LS_EXPAND {
        static TokenType NFA_COMPOSITE_LS_EXPAND_0(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            TokenType type= null;
            if (ch== ')') {
                if (validTypes.contains(T_RB)) type= T_RB;
            }
            else if (ch== '(') {
                if (validTypes.contains(T_LB)) type= T_LB;
            }
            else if (ch== ',') {
                if (validTypes.contains(T_VALUE_SEPARATOR)) type= T_VALUE_SEPARATOR;
            }
            return type;
        }

        static TokenType NFA_LS_EXPAND_1(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch== '(') {
                if (validTypes.contains(T_LB)) return T_LB;
            }
            return null;
        }

        static TokenType NFA_LS_EXPAND_2(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch== ')') {
                if (validTypes.contains(T_RB)) return T_RB;
            }
            return null;
        }

        static TokenType NFA_LS_EXPAND_3(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch== ',') {
                if (validTypes.contains(T_VALUE_SEPARATOR)) return T_VALUE_SEPARATOR;
            }
            return null;
        }

        static private void NFA_FUNCTIONS_init() {
            NfaFunction[] functions= new NfaFunction[4];
            functions[0]= LS_EXPAND::NFA_COMPOSITE_LS_EXPAND_0;
            functions[1]= LS_EXPAND::NFA_LS_EXPAND_1;
            functions[2]= LS_EXPAND::NFA_LS_EXPAND_2;
            functions[3]= LS_EXPAND::NFA_LS_EXPAND_3;
            functionTableMap.put(LexicalState.LS_EXPAND, functions);
        }

    }
    /**
  * Holder class for NFA code related to LS_SELECT lexical state
  */
    private static class LS_SELECT {
        static TokenType NFA_COMPOSITE_LS_SELECT_0(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            TokenType type= null;
            if ((ch== 'D')||(ch== 'd')) {
                nextStates.set(5);
            }
            else if (ch== ',') {
                if (validTypes.contains(T_VALUE_SEPARATOR)) type= T_VALUE_SEPARATOR;
            }
            return type;
        }

        static TokenType NFA_LS_SELECT_1(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'C')||(ch== 'c')) {
                nextStates.set(9);
            }
            return null;
        }

        static TokenType NFA_LS_SELECT_2(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'I')||(ch== 'i')) {
                nextStates.set(8);
            }
            return null;
        }

        static TokenType NFA_LS_SELECT_3(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'S')||(ch== 's')) {
                nextStates.set(7);
            }
            return null;
        }

        static TokenType NFA_LS_SELECT_4(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'D')||(ch== 'd')) {
                nextStates.set(5);
            }
            return null;
        }

        static TokenType NFA_LS_SELECT_5(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'I')||(ch== 'i')) {
                nextStates.set(3);
            }
            return null;
        }

        static TokenType NFA_LS_SELECT_6(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch== ',') {
                if (validTypes.contains(T_VALUE_SEPARATOR)) return T_VALUE_SEPARATOR;
            }
            return null;
        }

        static TokenType NFA_LS_SELECT_7(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'T')||(ch== 't')) {
                nextStates.set(2);
            }
            return null;
        }

        static TokenType NFA_LS_SELECT_8(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'N')||(ch== 'n')) {
                nextStates.set(1);
            }
            return null;
        }

        static TokenType NFA_LS_SELECT_9(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if ((ch== 'T')||(ch== 't')) {
                nextStates.set(10);
            }
            return null;
        }

        static TokenType NFA_LS_SELECT_10(int ch, BitSet nextStates, EnumSet<TokenType> validTypes) {
            if (ch== ':') {
                if (validTypes.contains(T_DISTINCT)) return T_DISTINCT;
            }
            return null;
        }

        static private void NFA_FUNCTIONS_init() {
            NfaFunction[] functions= new NfaFunction[11];
            functions[0]= LS_SELECT::NFA_COMPOSITE_LS_SELECT_0;
            functions[1]= LS_SELECT::NFA_LS_SELECT_1;
            functions[2]= LS_SELECT::NFA_LS_SELECT_2;
            functions[3]= LS_SELECT::NFA_LS_SELECT_3;
            functions[4]= LS_SELECT::NFA_LS_SELECT_4;
            functions[5]= LS_SELECT::NFA_LS_SELECT_5;
            functions[6]= LS_SELECT::NFA_LS_SELECT_6;
            functions[7]= LS_SELECT::NFA_LS_SELECT_7;
            functions[8]= LS_SELECT::NFA_LS_SELECT_8;
            functions[9]= LS_SELECT::NFA_LS_SELECT_9;
            functions[10]= LS_SELECT::NFA_LS_SELECT_10;
            functionTableMap.put(LexicalState.LS_SELECT, functions);
        }

    }
}
