/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.frostserver.util;

import de.fraunhofer.iosb.ilt.frostserver.util.SimpleJsonMapper;
import java.io.IOException;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.geojson.GeoJsonObject;
import org.geojson.LineString;
import org.geojson.LngLatAlt;
import org.geojson.Point;
import org.geojson.Polygon;

public class GeoHelper {
    private static final String NUMBER_REGEX = "[+-]?[0-9]*(\\.[0-9]+)?";
    private static final String POINT_2D_REGEX = "[+-]?[0-9]*(\\.[0-9]+)? [+-]?[0-9]*(\\.[0-9]+)?";
    private static final String POINT_3D_REGEX = "[+-]?[0-9]*(\\.[0-9]+)? [+-]?[0-9]*(\\.[0-9]+)? [+-]?[0-9]*(\\.[0-9]+)?";
    private static final String LIST_POINT_2D_REGEX = "[+-]?[0-9]*(\\.[0-9]+)? [+-]?[0-9]*(\\.[0-9]+)?(?:,[+-]?[0-9]*(\\.[0-9]+)? [+-]?[0-9]*(\\.[0-9]+)?)*";
    private static final String LIST_POINT_3D_REGEX = "[+-]?[0-9]*(\\.[0-9]+)? [+-]?[0-9]*(\\.[0-9]+)? [+-]?[0-9]*(\\.[0-9]+)?(?:,[+-]?[0-9]*(\\.[0-9]+)? [+-]?[0-9]*(\\.[0-9]+)? [+-]?[0-9]*(\\.[0-9]+)?)*";
    private static final String LIST_LIST_POINT_2D_REGEX = "[(][+-]?[0-9]*(\\.[0-9]+)? [+-]?[0-9]*(\\.[0-9]+)?(?:,[+-]?[0-9]*(\\.[0-9]+)? [+-]?[0-9]*(\\.[0-9]+)?)*[)](?:,[(][+-]?[0-9]*(\\.[0-9]+)? [+-]?[0-9]*(\\.[0-9]+)?(?:,[+-]?[0-9]*(\\.[0-9]+)? [+-]?[0-9]*(\\.[0-9]+)?)*[)])*";
    private static final String LIST_LIST_POINT_3D_REGEX = "[(][+-]?[0-9]*(\\.[0-9]+)? [+-]?[0-9]*(\\.[0-9]+)? [+-]?[0-9]*(\\.[0-9]+)?(?:,[+-]?[0-9]*(\\.[0-9]+)? [+-]?[0-9]*(\\.[0-9]+)? [+-]?[0-9]*(\\.[0-9]+)?)*[)](?:,[(][+-]?[0-9]*(\\.[0-9]+)? [+-]?[0-9]*(\\.[0-9]+)? [+-]?[0-9]*(\\.[0-9]+)?(?:,[+-]?[0-9]*(\\.[0-9]+)? [+-]?[0-9]*(\\.[0-9]+)? [+-]?[0-9]*(\\.[0-9]+)?)*[)])*";
    private static final String WKT_POINT_REGEX = "POINT[(]([+-]?[0-9]*(\\.[0-9]+)? [+-]?[0-9]*(\\.[0-9]+)?|[+-]?[0-9]*(\\.[0-9]+)? [+-]?[0-9]*(\\.[0-9]+)? [+-]?[0-9]*(\\.[0-9]+)?)[)]";
    private static final String WKT_LINE_REGEX = "LINESTRING[(]([+-]?[0-9]*(\\.[0-9]+)? [+-]?[0-9]*(\\.[0-9]+)?(?:,[+-]?[0-9]*(\\.[0-9]+)? [+-]?[0-9]*(\\.[0-9]+)?)*|[+-]?[0-9]*(\\.[0-9]+)? [+-]?[0-9]*(\\.[0-9]+)? [+-]?[0-9]*(\\.[0-9]+)?(?:,[+-]?[0-9]*(\\.[0-9]+)? [+-]?[0-9]*(\\.[0-9]+)? [+-]?[0-9]*(\\.[0-9]+)?)*)[)]";
    private static final String WKT_POLYGON_REGEX = "POLYGON( Z)?[(]([(][+-]?[0-9]*(\\.[0-9]+)? [+-]?[0-9]*(\\.[0-9]+)?(?:,[+-]?[0-9]*(\\.[0-9]+)? [+-]?[0-9]*(\\.[0-9]+)?)*[)](?:,[(][+-]?[0-9]*(\\.[0-9]+)? [+-]?[0-9]*(\\.[0-9]+)?(?:,[+-]?[0-9]*(\\.[0-9]+)? [+-]?[0-9]*(\\.[0-9]+)?)*[)])*|[(][+-]?[0-9]*(\\.[0-9]+)? [+-]?[0-9]*(\\.[0-9]+)? [+-]?[0-9]*(\\.[0-9]+)?(?:,[+-]?[0-9]*(\\.[0-9]+)? [+-]?[0-9]*(\\.[0-9]+)? [+-]?[0-9]*(\\.[0-9]+)?)*[)](?:,[(][+-]?[0-9]*(\\.[0-9]+)? [+-]?[0-9]*(\\.[0-9]+)? [+-]?[0-9]*(\\.[0-9]+)?(?:,[+-]?[0-9]*(\\.[0-9]+)? [+-]?[0-9]*(\\.[0-9]+)? [+-]?[0-9]*(\\.[0-9]+)?)*[)])*)[)]";
    public static final Pattern WKT_POINT_PATTERN = Pattern.compile("POINT[(]([+-]?[0-9]*(\\.[0-9]+)? [+-]?[0-9]*(\\.[0-9]+)?|[+-]?[0-9]*(\\.[0-9]+)? [+-]?[0-9]*(\\.[0-9]+)? [+-]?[0-9]*(\\.[0-9]+)?)[)]", 2);
    public static final Pattern WKT_LINE_PATTERN = Pattern.compile("LINESTRING[(]([+-]?[0-9]*(\\.[0-9]+)? [+-]?[0-9]*(\\.[0-9]+)?(?:,[+-]?[0-9]*(\\.[0-9]+)? [+-]?[0-9]*(\\.[0-9]+)?)*|[+-]?[0-9]*(\\.[0-9]+)? [+-]?[0-9]*(\\.[0-9]+)? [+-]?[0-9]*(\\.[0-9]+)?(?:,[+-]?[0-9]*(\\.[0-9]+)? [+-]?[0-9]*(\\.[0-9]+)? [+-]?[0-9]*(\\.[0-9]+)?)*)[)]", 2);
    public static final Pattern WKT_POLYGON_PATTERN = Pattern.compile("POLYGON( Z)?[(]([(][+-]?[0-9]*(\\.[0-9]+)? [+-]?[0-9]*(\\.[0-9]+)?(?:,[+-]?[0-9]*(\\.[0-9]+)? [+-]?[0-9]*(\\.[0-9]+)?)*[)](?:,[(][+-]?[0-9]*(\\.[0-9]+)? [+-]?[0-9]*(\\.[0-9]+)?(?:,[+-]?[0-9]*(\\.[0-9]+)? [+-]?[0-9]*(\\.[0-9]+)?)*[)])*|[(][+-]?[0-9]*(\\.[0-9]+)? [+-]?[0-9]*(\\.[0-9]+)? [+-]?[0-9]*(\\.[0-9]+)?(?:,[+-]?[0-9]*(\\.[0-9]+)? [+-]?[0-9]*(\\.[0-9]+)? [+-]?[0-9]*(\\.[0-9]+)?)*[)](?:,[(][+-]?[0-9]*(\\.[0-9]+)? [+-]?[0-9]*(\\.[0-9]+)? [+-]?[0-9]*(\\.[0-9]+)?(?:,[+-]?[0-9]*(\\.[0-9]+)? [+-]?[0-9]*(\\.[0-9]+)? [+-]?[0-9]*(\\.[0-9]+)?)*[)])*)[)]", 2);
    private static final String DOES_NOT_MATCH_PATTERN = "' does not match pattern '";

    private GeoHelper() {
    }

    public static Point parsePoint(String value) {
        Matcher matcher = WKT_POINT_PATTERN.matcher(value = GeoHelper.cleanInput(value));
        if (matcher.matches()) {
            String[] coordinates = matcher.group(1).split(" ");
            if (coordinates.length < 2 || coordinates.length > 3) {
                throw new IllegalArgumentException("only 2d or 3d points are supported");
            }
            if (coordinates.length == 2) {
                return new Point(Double.parseDouble(coordinates[0]), Double.parseDouble(coordinates[1]));
            }
            return new Point(Double.parseDouble(coordinates[0]), Double.parseDouble(coordinates[1]), Double.parseDouble(coordinates[2]));
        }
        throw new IllegalArgumentException("'" + value + DOES_NOT_MATCH_PATTERN + WKT_POINT_PATTERN.pattern() + "'");
    }

    public static LineString parseLine(String value) {
        Matcher matcher = WKT_LINE_PATTERN.matcher(value = GeoHelper.cleanInput(value));
        if (matcher.matches()) {
            String[] points = matcher.group(1).split(" ?, ?");
            return new LineString((LngLatAlt[])Arrays.asList(points).stream().map(x -> Arrays.asList(x.split(" "))).map(x -> x.stream().map(Double::parseDouble)).map(x -> GeoHelper.getPoint((Number[])((Double[])x.toArray(Double[]::new))).getCoordinates()).toArray(LngLatAlt[]::new));
        }
        throw new IllegalArgumentException("'" + value + DOES_NOT_MATCH_PATTERN + WKT_LINE_PATTERN.pattern() + "'");
    }

    private static String cleanInput(String value) {
        return value.trim().replaceAll("\\s+", " ").replaceAll(" ?([,()]) ?", "$1");
    }

    private static LngLatAlt[] stringListToPoints(String value) {
        return (LngLatAlt[])Arrays.asList(value.split(" ?, ?")).stream().map(x -> Arrays.asList(x.split(" "))).map(x -> x.stream().map(Double::parseDouble)).map(x -> GeoHelper.getPoint((Number[])((Double[])x.toArray(Double[]::new))).getCoordinates()).toArray(LngLatAlt[]::new);
    }

    public static Polygon parsePolygon(String value) {
        Matcher matcher = WKT_POLYGON_PATTERN.matcher(value = GeoHelper.cleanInput(value));
        if (matcher.matches()) {
            String group = matcher.group(2);
            String[] rings = group.trim().substring(1, group.length() - 1).split("[)] ?, ?[(]");
            Polygon result = new Polygon(GeoHelper.stringListToPoints(rings[0]));
            for (int i = 1; i < rings.length; ++i) {
                result.addInteriorRing(GeoHelper.stringListToPoints(rings[i]));
            }
            return result;
        }
        throw new IllegalArgumentException("'" + value + DOES_NOT_MATCH_PATTERN + WKT_POLYGON_PATTERN.pattern() + "'");
    }

    public static GeoJsonObject parseWkt(String value) {
        try {
            return GeoHelper.parsePoint(value);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            try {
                return GeoHelper.parseLine(value);
            }
            catch (IllegalArgumentException illegalArgumentException2) {
                try {
                    return GeoHelper.parsePolygon(value);
                }
                catch (IllegalArgumentException illegalArgumentException3) {
                    throw new IllegalArgumentException("unknown WKT string format '" + value + "'");
                }
            }
        }
    }

    public static <T extends Number> Point getPoint(T ... values) {
        if (values == null || values.length < 2 || values.length > 3) {
            throw new IllegalArgumentException("values must have a length of 2 or 3.");
        }
        if (values.length == 2) {
            return new Point(((Number)values[0]).doubleValue(), ((Number)values[1]).doubleValue());
        }
        return new Point(((Number)values[0]).doubleValue(), ((Number)values[1]).doubleValue(), ((Number)values[2]).doubleValue());
    }

    public static GeoJsonObject parseGeoJson(String geoJsonString) throws IOException {
        return (GeoJsonObject)SimpleJsonMapper.getSimpleObjectMapper().readValue(geoJsonString, GeoJsonObject.class);
    }
}

