/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.frostserver.util;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StringHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(StringHelper.class);
    private static final String UTF8_NOT_SUPPORTED = "UTF-8 not supported?";
    public static final Charset UTF8 = StandardCharsets.UTF_8;

    private StringHelper() {
    }

    public static String capitalize(String string) {
        return string.substring(0, 1).toUpperCase() + string.substring(1);
    }

    public static String deCapitalize(String string) {
        return string.substring(0, 1).toLowerCase() + string.substring(1);
    }

    public static boolean isNullOrEmpty(String string) {
        return string == null || string.isEmpty();
    }

    public static String cleanForLogging(String string) {
        return string.replaceAll("[\\n\\r\\t]", "_nrt_");
    }

    public static String escapeForStringConstant(String in) {
        return in.replace("'", "''");
    }

    public static String urlEncode(String input) {
        try {
            return URLEncoder.encode(input, UTF8.name());
        }
        catch (UnsupportedEncodingException exc) {
            LOGGER.error(UTF8_NOT_SUPPORTED);
            throw new IllegalStateException(UTF8_NOT_SUPPORTED, exc);
        }
    }

    public static String urlDecode(String input) {
        try {
            return URLDecoder.decode(input, UTF8.name());
        }
        catch (UnsupportedEncodingException exc) {
            LOGGER.error(UTF8_NOT_SUPPORTED);
            throw new IllegalStateException(UTF8_NOT_SUPPORTED, exc);
        }
    }

    public static String urlEncode(String string, boolean notSlashes) {
        if (notSlashes) {
            return StringHelper.urlEncodeNotSlashes(string);
        }
        return StringHelper.urlEncode(string);
    }

    public static String urlEncodeNotSlashes(String string) {
        CharSequence[] split = string.split("/");
        for (int i = 0; i < split.length; ++i) {
            split[i] = StringHelper.urlEncode((String)split[i]);
        }
        return String.join((CharSequence)"/", split);
    }
}

