/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.frostserver.util;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CollectionsHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(CollectionsHelper.class);

    private CollectionsHelper() {
    }

    public static void setOn(Map<String, Object> map, List<String> path, Object value) {
        CollectionsHelper.setOn(map, path, 0, value);
    }

    public static void setOn(Map<String, Object> map, List<String> path, int idx, Object value) {
        String key = path.get(idx);
        if (idx == path.size() - 1) {
            map.put(key, value);
            return;
        }
        Object subEntry = map.computeIfAbsent(key, t -> new HashMap());
        if (subEntry instanceof Map) {
            CollectionsHelper.setOn((Map)subEntry, path, idx + 1, value);
            return;
        }
        if (subEntry instanceof List) {
            return;
        }
        throw new IllegalArgumentException("Element at path index " + idx + " is not a map or list.");
    }

    public static Object getFrom(List<Object> list, List<String> path) {
        return CollectionsHelper.getFrom(list, path);
    }

    public static Object getFrom(Map<String, Object> map, List<String> path) {
        return CollectionsHelper.getFrom(map, path);
    }

    private static Object getFrom(Object mapOrList, List<String> path) {
        Object currentEntry = mapOrList;
        int last = path.size();
        for (int idx = 0; idx < last; ++idx) {
            String key = path.get(idx);
            if (currentEntry instanceof Map) {
                currentEntry = ((Map)currentEntry).get(key);
                continue;
            }
            if (!(currentEntry instanceof List)) continue;
            try {
                currentEntry = ((List)currentEntry).get(Integer.parseInt(key));
                continue;
            }
            catch (IndexOutOfBoundsException | NumberFormatException ex) {
                LOGGER.warn("Failed to get {} from {}.", new Object[]{key, currentEntry, ex});
                return null;
            }
        }
        return currentEntry;
    }
}

