/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.meta.postgres;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.jooq.Field;
import org.jooq.Record;
import org.jooq.Select;
import org.jooq.TableLike;
import org.jooq.TableOptions;
import org.jooq.impl.DSL;
import org.jooq.meta.AbstractTableDefinition;
import org.jooq.meta.ColumnDefinition;
import org.jooq.meta.DataTypeDefinition;
import org.jooq.meta.DefaultColumnDefinition;
import org.jooq.meta.DefaultDataTypeDefinition;
import org.jooq.meta.ParameterDefinition;
import org.jooq.meta.SchemaDefinition;
import org.jooq.meta.postgres.PostgresDatabase;
import org.jooq.meta.postgres.PostgresRoutineDefinition;
import org.jooq.meta.postgres.information_schema.Tables;
import org.jooq.meta.postgres.information_schema.tables.Columns;
import org.jooq.meta.postgres.information_schema.tables.Parameters;
import org.jooq.meta.postgres.information_schema.tables.Routines;
import org.jooq.meta.postgres.pg_catalog.tables.PgAttribute;
import org.jooq.meta.postgres.pg_catalog.tables.PgClass;
import org.jooq.meta.postgres.pg_catalog.tables.PgProc;
import org.jooq.meta.postgres.pg_catalog.tables.PgType;
import org.jooq.tools.StringUtils;

public class PostgresTableValuedFunction
extends AbstractTableDefinition {
    private final PostgresRoutineDefinition routine;
    private final String specificName;

    public PostgresTableValuedFunction(SchemaDefinition schema, String name, String specificName, String comment) {
        this(schema, name, specificName, comment, null);
    }

    public PostgresTableValuedFunction(SchemaDefinition schema, String name, String specificName, String comment, String source) {
        this(schema, name, specificName, comment, source, null, null);
    }

    public PostgresTableValuedFunction(SchemaDefinition schema, String name, String specificName, String comment, String source, SchemaDefinition referencedSchema, String referencedName) {
        super(schema, name, comment, TableOptions.TableType.FUNCTION, source, referencedSchema, referencedName);
        this.routine = new PostgresRoutineDefinition(schema.getDatabase(), schema.getInputName(), name, specificName);
        this.specificName = specificName;
    }

    @Override
    public List<ColumnDefinition> getElements0() throws SQLException {
        ArrayList<ColumnDefinition> result = new ArrayList<ColumnDefinition>();
        PostgresDatabase db = (PostgresDatabase)this.getDatabase();
        Routines r = Tables.ROUTINES.as("r");
        Parameters p = Tables.PARAMETERS.as("p");
        Columns c = Tables.COLUMNS.as("c");
        Columns x = Tables.COLUMNS.as("x");
        PgClass pg_c = org.jooq.meta.postgres.pg_catalog.Tables.PG_CLASS.as("pgc");
        PgAttribute pg_a = org.jooq.meta.postgres.pg_catalog.Tables.PG_ATTRIBUTE.as("pga");
        PgProc pg_p = org.jooq.meta.postgres.pg_catalog.Tables.PG_PROC.as("pgp");
        PgType pg_t = org.jooq.meta.postgres.pg_catalog.Tables.PG_TYPE.as("pgt");
        Field<Integer> pPrecision = PostgresRoutineDefinition.pNumericPrecision(p);
        Field cPrecision = DSL.nvl(c.DATETIME_PRECISION, c.NUMERIC_PRECISION);
        Field rPrecision = DSL.nvl(r.DATETIME_PRECISION, r.NUMERIC_PRECISION);
        for (Record record : this.create().select(p.PARAMETER_NAME, DSL.rowNumber().over(DSL.partitionBy(p.SPECIFIC_NAME).orderBy(p.ORDINAL_POSITION)).as(p.ORDINAL_POSITION), DSL.when(p.DATA_TYPE.eq(DSL.inline("ARRAY")), DSL.substring(p.UDT_NAME, DSL.inline(2)).concat(" ARRAY")).else_(p.DATA_TYPE).as(p.DATA_TYPE), p.CHARACTER_MAXIMUM_LENGTH, pPrecision.as(p.NUMERIC_PRECISION), p.NUMERIC_SCALE, DSL.inline("true").as(c.IS_NULLABLE), (db.is94() ? p.PARAMETER_DEFAULT : DSL.inline((String)null)).as(c.COLUMN_DEFAULT), p.UDT_SCHEMA, DSL.when(p.DATA_TYPE.eq(DSL.inline("ARRAY")), DSL.substring(p.UDT_NAME, DSL.inline(2))).else_(p.UDT_NAME).as(p.UDT_NAME)).from((TableLike<?>)r).join(p).on(DSL.row(r.SPECIFIC_CATALOG, r.SPECIFIC_SCHEMA, r.SPECIFIC_NAME).eq(p.SPECIFIC_CATALOG, p.SPECIFIC_SCHEMA, p.SPECIFIC_NAME)).join(pg_p).on(pg_p.PRONAME.concat("_").concat(pg_p.OID).eq(r.SPECIFIC_NAME)).and(pg_p.pgNamespace().NSPNAME.eq(r.SPECIFIC_SCHEMA)).where(r.SPECIFIC_NAME.eq(this.specificName)).and(p.PARAMETER_MODE.ne("IN")).and(pg_p.PRORETSET).unionAll((Select)DSL.select(DSL.coalesce(c.COLUMN_NAME, this.getName()).as(c.COLUMN_NAME), DSL.coalesce(c.ORDINAL_POSITION, new Field[]{DSL.inline(1)}).as(c.ORDINAL_POSITION), db.arrayDataType(x.DATA_TYPE, x.UDT_NAME, pg_a.ATTNDIMS).as(c.DATA_TYPE), DSL.coalesce(c.CHARACTER_MAXIMUM_LENGTH, new Field[]{r.CHARACTER_MAXIMUM_LENGTH}).as(c.CHARACTER_MAXIMUM_LENGTH), DSL.coalesce(cPrecision, rPrecision).as(c.NUMERIC_PRECISION), DSL.coalesce(c.NUMERIC_SCALE, new Field[]{r.NUMERIC_SCALE}).as(c.NUMERIC_SCALE), DSL.coalesce(c.IS_NULLABLE, new Field[]{DSL.inline("true")}).as(c.IS_NULLABLE), DSL.coalesce(c.COLUMN_DEFAULT, new Field[]{DSL.inline((String)null)}).as(c.COLUMN_DEFAULT), DSL.coalesce(c.UDT_SCHEMA, new Field[]{DSL.inline((String)null)}).as(c.UDT_SCHEMA), db.arrayUdtName(x.DATA_TYPE, x.UDT_NAME).as(c.UDT_NAME)).from((TableLike<?>)r).join(pg_p).on(pg_p.PRONAME.concat("_").concat(pg_p.OID).eq(r.SPECIFIC_NAME)).and(pg_p.pgNamespace().NSPNAME.eq(r.SPECIFIC_SCHEMA)).leftJoin(c).on(DSL.row(r.TYPE_UDT_CATALOG, r.TYPE_UDT_SCHEMA, r.TYPE_UDT_NAME).eq(c.TABLE_CATALOG, c.TABLE_SCHEMA, c.TABLE_NAME)).leftJoin(pg_c).on(c.TABLE_NAME.eq(pg_c.RELNAME)).and(pg_c.pgNamespace().NSPNAME.eq(r.SPECIFIC_SCHEMA)).leftJoin(pg_a).on(pg_c.OID.eq(pg_a.ATTRELID)).and(c.COLUMN_NAME.eq(pg_a.ATTNAME)).crossApply(DSL.select(DSL.coalesce(c.DATA_TYPE, new Field[]{r.DATA_TYPE}).as(x.DATA_TYPE), DSL.coalesce(c.UDT_NAME, new Field[]{r.UDT_NAME, DSL.field(DSL.select(pg_t.TYPNAME).from((TableLike<?>)pg_t).where(pg_t.OID.eq(pg_p.PRORETTYPE)))}).as(x.UDT_NAME)).asTable(x)).where(r.SPECIFIC_NAME.eq(this.specificName)).and(DSL.row(r.SPECIFIC_CATALOG, r.SPECIFIC_SCHEMA, r.SPECIFIC_NAME).notIn(DSL.select(p.SPECIFIC_CATALOG, p.SPECIFIC_SCHEMA, p.SPECIFIC_NAME).from((TableLike<?>)p).where(p.PARAMETER_MODE.eq("OUT")))).and(pg_p.PRORETSET)).orderBy(2)) {
            SchemaDefinition typeSchema = null;
            String schemaName = (String)record.get(p.UDT_SCHEMA);
            if (schemaName != null) {
                typeSchema = this.getDatabase().getSchema(schemaName);
            }
            DefaultDataTypeDefinition type = new DefaultDataTypeDefinition(this.getDatabase(), typeSchema, (String)record.get(p.DATA_TYPE), (Number)record.get(p.CHARACTER_MAXIMUM_LENGTH), (Number)record.get(p.NUMERIC_PRECISION), (Number)record.get(p.NUMERIC_SCALE), record.get(c.IS_NULLABLE, Boolean.TYPE), (String)record.get(c.COLUMN_DEFAULT), DSL.name((String)record.get(p.UDT_SCHEMA), (String)record.get(p.UDT_NAME)));
            result.add(new DefaultColumnDefinition(this.getDatabase().getTable(this.getSchema(), this.getName()), (String)record.get(p.PARAMETER_NAME), result.size() + 1, (DataTypeDefinition)type, StringUtils.defaultString((String)record.get(c.COLUMN_DEFAULT)).startsWith("nextval"), null));
        }
        return result;
    }

    @Override
    protected List<ParameterDefinition> getParameters0() {
        return this.routine.getInParameters();
    }
}

