/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.meta.postgres;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.jooq.Condition;
import org.jooq.Field;
import org.jooq.LikeEscapeStep;
import org.jooq.Param;
import org.jooq.Record;
import org.jooq.TableField;
import org.jooq.TableLike;
import org.jooq.TableOptions;
import org.jooq.impl.DSL;
import org.jooq.impl.QOM;
import org.jooq.impl.SQLDataType;
import org.jooq.meta.AbstractTableDefinition;
import org.jooq.meta.ColumnDefinition;
import org.jooq.meta.DataTypeDefinition;
import org.jooq.meta.DefaultColumnDefinition;
import org.jooq.meta.DefaultDataTypeDefinition;
import org.jooq.meta.SchemaDefinition;
import org.jooq.meta.postgres.PostgresDatabase;
import org.jooq.meta.postgres.information_schema.Tables;

public class PostgresTableDefinition
extends AbstractTableDefinition {
    public PostgresTableDefinition(SchemaDefinition schema, String name, String comment) {
        super(schema, name, comment);
    }

    public PostgresTableDefinition(SchemaDefinition schema, String name, String comment, TableOptions.TableType tableType, String source) {
        super(schema, name, comment, tableType, source);
    }

    @Override
    public List<ColumnDefinition> getElements0() throws SQLException {
        ArrayList<ColumnDefinition> result = new ArrayList<ColumnDefinition>();
        PostgresDatabase database = (PostgresDatabase)this.getDatabase();
        Field<String> dataType = DSL.when((Condition)Tables.COLUMNS.INTERVAL_TYPE.like(DSL.any(new Field[]{DSL.inline("%YEAR%"), DSL.inline("%MONTH%")})), DSL.inline("INTERVAL YEAR TO MONTH")).when((Condition)Tables.COLUMNS.INTERVAL_TYPE.like(DSL.any(new Field[]{DSL.inline("%DAY%"), DSL.inline("%HOUR%"), DSL.inline("%MINUTE%"), DSL.inline("%SECOND%")})), (Field<String>)DSL.inline("INTERVAL DAY TO SECOND")).when(Tables.COLUMNS.DATA_TYPE.eq(DSL.inline("USER-DEFINED")).and(Tables.COLUMNS.UDT_NAME.eq(DSL.inline("geometry"))), (Field<String>)DSL.inline("geometry")).when(Tables.COLUMNS.DATA_TYPE.eq(DSL.inline("ARRAY")), DSL.concat(DSL.substring(org.jooq.meta.postgres.pg_catalog.Tables.PG_TYPE.TYPNAME, DSL.inline(2)), DSL.repeat(DSL.inline(" ARRAY"), DSL.greatest(DSL.inline(1), new Field[]{org.jooq.meta.postgres.pg_catalog.Tables.PG_ATTRIBUTE.ATTNDIMS})))).else_(Tables.COLUMNS.DATA_TYPE);
        TableField<Record, String> udtSchema = Tables.COLUMNS.UDT_SCHEMA;
        Field length = DSL.nvl(Tables.COLUMNS.CHARACTER_MAXIMUM_LENGTH, DSL.when(Tables.COLUMNS.UDT_NAME.in(new Field[]{DSL.inline("_varchar"), DSL.inline("_bpchar"), DSL.inline("_char")}), org.jooq.meta.postgres.pg_catalog.Tables.PG_ATTRIBUTE.ATTTYPMOD.sub(DSL.inline(4))));
        Field precision = DSL.coalesce(Tables.COLUMNS.DATETIME_PRECISION, new Field[]{Tables.COLUMNS.NUMERIC_PRECISION, DSL.when(Tables.COLUMNS.UDT_NAME.in(new Field[]{DSL.inline("_time"), DSL.inline("_timetz"), DSL.inline("_timestamp"), DSL.inline("_timestamptz")}).and(org.jooq.meta.postgres.pg_catalog.Tables.PG_ATTRIBUTE.ATTTYPMOD.ge(DSL.inline(0))), org.jooq.meta.postgres.pg_catalog.Tables.PG_ATTRIBUTE.ATTTYPMOD).when(Tables.COLUMNS.UDT_NAME.eq(DSL.inline("_numeric")), DSL.nullif(org.jooq.meta.postgres.pg_catalog.Tables.PG_ATTRIBUTE.ATTTYPMOD, DSL.inline(-1)).sub(DSL.inline(4)).shr(DSL.inline(16)).bitAnd(DSL.inline(65535)))});
        Field<Integer> scale = DSL.nvl(Tables.COLUMNS.NUMERIC_SCALE, DSL.when(Tables.COLUMNS.UDT_NAME.eq(DSL.inline("_numeric")), DSL.nullif(org.jooq.meta.postgres.pg_catalog.Tables.PG_ATTRIBUTE.ATTTYPMOD, DSL.inline(-1)).sub(DSL.inline(4)).bitAnd(DSL.inline(65535))));
        Param<String> serialColumnDefault = DSL.inline("nextval('%_seq'::regclass)");
        TableField<Record, String> generationExpression = Tables.COLUMNS.GENERATION_EXPRESSION;
        Field<Object> attgenerated = database.is12() ? org.jooq.meta.postgres.pg_catalog.Tables.PG_ATTRIBUTE.ATTGENERATED : DSL.inline("s");
        LikeEscapeStep isSerial = DSL.lower(Tables.COLUMNS.COLUMN_DEFAULT).likeIgnoreCase(serialColumnDefault);
        Condition isIdentity10 = Tables.COLUMNS.IS_IDENTITY.eq(DSL.inline("YES"));
        LikeEscapeStep isIdentity = database.is10() ? isIdentity10.or(DSL.count().filterWhere(isIdentity10).over().eq(DSL.inline(0)).and(isSerial)) : isSerial;
        for (Record record : this.create().select(Tables.COLUMNS.COLUMN_NAME, Tables.COLUMNS.ORDINAL_POSITION, dataType.as(Tables.COLUMNS.DATA_TYPE), length.as(Tables.COLUMNS.CHARACTER_MAXIMUM_LENGTH), precision.as(Tables.COLUMNS.NUMERIC_PRECISION), scale.as(Tables.COLUMNS.NUMERIC_SCALE), DSL.when((Condition)isIdentity, DSL.inline("YES")).as(Tables.COLUMNS.IS_IDENTITY), Tables.COLUMNS.IS_NULLABLE, generationExpression.as(Tables.COLUMNS.GENERATION_EXPRESSION), attgenerated.as(org.jooq.meta.postgres.pg_catalog.Tables.PG_ATTRIBUTE.ATTGENERATED), DSL.when((Condition)isIdentity, DSL.inline(null, String.class)).else_(Tables.COLUMNS.COLUMN_DEFAULT).as(Tables.COLUMNS.COLUMN_DEFAULT), DSL.coalesce(Tables.COLUMNS.DOMAIN_SCHEMA, new Field[]{udtSchema}).as(Tables.COLUMNS.UDT_SCHEMA), DSL.coalesce(Tables.COLUMNS.DOMAIN_NAME, new Field[]{DSL.when(Tables.COLUMNS.DATA_TYPE.eq(DSL.inline("ARRAY")), DSL.substring(org.jooq.meta.postgres.pg_catalog.Tables.PG_TYPE.TYPNAME, DSL.inline(2))).else_(Tables.COLUMNS.UDT_NAME)}).as(Tables.COLUMNS.UDT_NAME), org.jooq.meta.postgres.pg_catalog.Tables.PG_DESCRIPTION.DESCRIPTION).from((TableLike<?>)Tables.COLUMNS).join(org.jooq.meta.postgres.pg_catalog.Tables.PG_ATTRIBUTE).on(org.jooq.meta.postgres.pg_catalog.Tables.PG_ATTRIBUTE.ATTNAME.eq(Tables.COLUMNS.COLUMN_NAME)).and(org.jooq.meta.postgres.pg_catalog.Tables.PG_ATTRIBUTE.pgClass().RELNAME.eq(Tables.COLUMNS.TABLE_NAME)).and(org.jooq.meta.postgres.pg_catalog.Tables.PG_ATTRIBUTE.pgClass().pgNamespace().NSPNAME.eq(Tables.COLUMNS.TABLE_SCHEMA)).join(org.jooq.meta.postgres.pg_catalog.Tables.PG_TYPE).on(org.jooq.meta.postgres.pg_catalog.Tables.PG_ATTRIBUTE.ATTTYPID.eq(org.jooq.meta.postgres.pg_catalog.Tables.PG_TYPE.OID)).leftJoin(org.jooq.meta.postgres.pg_catalog.Tables.PG_DESCRIPTION).on(org.jooq.meta.postgres.pg_catalog.Tables.PG_DESCRIPTION.OBJOID.eq(org.jooq.meta.postgres.pg_catalog.Tables.PG_ATTRIBUTE.ATTRELID)).and(org.jooq.meta.postgres.pg_catalog.Tables.PG_DESCRIPTION.CLASSOID.eq(DSL.field("'pg_class'::regclass", SQLDataType.BIGINT))).and(org.jooq.meta.postgres.pg_catalog.Tables.PG_DESCRIPTION.OBJSUBID.eq(Tables.COLUMNS.ORDINAL_POSITION)).where(Tables.COLUMNS.TABLE_SCHEMA.equal(this.getSchema().getName())).and(Tables.COLUMNS.TABLE_NAME.equal(this.getName())).orderBy(Tables.COLUMNS.ORDINAL_POSITION)) {
            SchemaDefinition typeSchema = null;
            String schemaName = (String)record.get(Tables.COLUMNS.UDT_SCHEMA);
            if (schemaName != null) {
                typeSchema = this.getDatabase().getSchema(schemaName);
            }
            DefaultDataTypeDefinition type = new DefaultDataTypeDefinition(this.getDatabase(), typeSchema, (String)record.get(Tables.COLUMNS.DATA_TYPE), (Number)record.get(Tables.COLUMNS.CHARACTER_MAXIMUM_LENGTH), (Number)record.get(Tables.COLUMNS.NUMERIC_PRECISION), (Number)record.get(Tables.COLUMNS.NUMERIC_SCALE), record.get(Tables.COLUMNS.IS_NULLABLE, Boolean.TYPE), (String)record.get(Tables.COLUMNS.COLUMN_DEFAULT), DSL.name((String)record.get(Tables.COLUMNS.UDT_SCHEMA), (String)record.get(Tables.COLUMNS.UDT_NAME))).generatedAlwaysAs((String)record.get(Tables.COLUMNS.GENERATION_EXPRESSION)).generationOption("s".equals(record.get(org.jooq.meta.postgres.pg_catalog.Tables.PG_ATTRIBUTE.ATTGENERATED)) ? QOM.GenerationOption.STORED : ("v".equals(record.get(org.jooq.meta.postgres.pg_catalog.Tables.PG_ATTRIBUTE.ATTGENERATED)) ? QOM.GenerationOption.VIRTUAL : null));
            DefaultColumnDefinition column = new DefaultColumnDefinition(this.getDatabase().getTable(this.getSchema(), this.getName()), (String)record.get(Tables.COLUMNS.COLUMN_NAME), (int)record.get(Tables.COLUMNS.ORDINAL_POSITION, Integer.TYPE), (DataTypeDefinition)type, record.get(Tables.COLUMNS.IS_IDENTITY, Boolean.TYPE), (String)record.get(org.jooq.meta.postgres.pg_catalog.Tables.PG_DESCRIPTION.DESCRIPTION));
            result.add(column);
        }
        return result;
    }
}

