/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.meta.postgres;

import java.sql.SQLException;
import java.util.Arrays;
import org.jooq.Field;
import org.jooq.Record;
import org.jooq.SelectField;
import org.jooq.TableLike;
import org.jooq.WindowFinalStep;
import org.jooq.impl.DSL;
import org.jooq.meta.AbstractRoutineDefinition;
import org.jooq.meta.Database;
import org.jooq.meta.DefaultDataTypeDefinition;
import org.jooq.meta.DefaultParameterDefinition;
import org.jooq.meta.InOutDefinition;
import org.jooq.meta.SchemaDefinition;
import org.jooq.meta.postgres.PostgresDatabase;
import org.jooq.meta.postgres.information_schema.Tables;
import org.jooq.meta.postgres.information_schema.tables.Parameters;
import org.jooq.tools.StringUtils;

public class PostgresRoutineDefinition
extends AbstractRoutineDefinition {
    private final String specificName;
    private final boolean isProcedure;

    public PostgresRoutineDefinition(Database database, Record record) {
        super(database.getSchema((String)record.get(Tables.ROUTINES.ROUTINE_SCHEMA)), null, (String)record.get(Tables.ROUTINES.ROUTINE_NAME), null, record.get("overload", String.class), record.get("is_agg", Boolean.TYPE));
        String dataType = record.get("data_type", String.class);
        if (dataType != null && !Arrays.asList("void").contains(dataType)) {
            SchemaDefinition typeSchema = null;
            String schemaName = (String)record.get(Tables.ROUTINES.TYPE_UDT_SCHEMA);
            if (schemaName != null) {
                typeSchema = this.getDatabase().getSchema(schemaName);
            }
            DefaultDataTypeDefinition type = new DefaultDataTypeDefinition(this.getDatabase(), typeSchema == null ? database.getSchema((String)record.get(Tables.ROUTINES.ROUTINE_SCHEMA)) : typeSchema, dataType, (Number)record.get(Tables.ROUTINES.CHARACTER_MAXIMUM_LENGTH), (Number)record.get(Tables.ROUTINES.NUMERIC_PRECISION), (Number)record.get(Tables.ROUTINES.NUMERIC_SCALE), null, (String)null, DSL.name((String)record.get(Tables.ROUTINES.TYPE_UDT_SCHEMA), (String)record.get(Tables.ROUTINES.TYPE_UDT_NAME)));
            this.returnValue = new DefaultParameterDefinition(this, "RETURN_VALUE", -1, type);
        }
        this.specificName = (String)record.get(Tables.ROUTINES.SPECIFIC_NAME);
        this.isProcedure = "PROCEDURE".equalsIgnoreCase((String)record.get(Tables.ROUTINES.ROUTINE_TYPE));
    }

    PostgresRoutineDefinition(Database database, String schema, String name, String specificName) {
        super(database.getSchema(schema), null, name, null, null);
        this.specificName = specificName;
        this.isProcedure = false;
    }

    @Override
    protected void init0() throws SQLException {
        Parameters p = Tables.PARAMETERS.as("p");
        WindowFinalStep count = DSL.count().filterWhere(p.PARAMETER_NAME.ne(DSL.inline(""))).over(DSL.partitionBy(p.SPECIFIC_NAME, p.PARAMETER_NAME));
        SelectField c = count.as("c");
        for (Record record : this.create().select(p.PARAMETER_NAME, DSL.when(p.DATA_TYPE.eq(DSL.inline("USER-DEFINED")).and(p.UDT_NAME.eq(DSL.inline("geometry"))), DSL.inline("geometry")).when(p.DATA_TYPE.eq(DSL.inline("ARRAY")), DSL.substring(p.UDT_NAME, DSL.inline(2)).concat(DSL.inline(" ARRAY"))).else_(p.DATA_TYPE).as(p.DATA_TYPE), p.CHARACTER_MAXIMUM_LENGTH, PostgresRoutineDefinition.pNumericPrecision(p).as(p.NUMERIC_PRECISION), p.NUMERIC_SCALE, p.UDT_SCHEMA, DSL.when(p.DATA_TYPE.eq(DSL.inline("ARRAY")), DSL.substring(p.UDT_NAME, DSL.inline(2))).else_(p.UDT_NAME).as(p.UDT_NAME), p.ORDINAL_POSITION, p.PARAMETER_MODE, ((PostgresDatabase)this.getDatabase()).is94() ? p.PARAMETER_DEFAULT : DSL.inline((String)null).as(p.PARAMETER_DEFAULT), c).from((TableLike<?>)p).where(p.SPECIFIC_SCHEMA.equal(this.getSchema().getName())).and(p.SPECIFIC_NAME.equal(this.specificName)).orderBy(p.ORDINAL_POSITION.asc())) {
            String parameterName = (String)record.get(p.PARAMETER_NAME);
            String inOut = (String)record.get(p.PARAMETER_MODE);
            SchemaDefinition typeSchema = null;
            String schemaName = (String)record.get(p.UDT_SCHEMA);
            if (schemaName != null) {
                typeSchema = this.getDatabase().getSchema(schemaName);
            }
            DefaultDataTypeDefinition type = new DefaultDataTypeDefinition(this.getDatabase(), typeSchema, (String)record.get(p.DATA_TYPE), (Number)record.get(p.CHARACTER_MAXIMUM_LENGTH), (Number)record.get(p.NUMERIC_PRECISION), (Number)record.get(p.NUMERIC_SCALE), null, (String)record.get(p.PARAMETER_DEFAULT), DSL.name((String)record.get(p.UDT_SCHEMA), (String)record.get(p.UDT_NAME)));
            DefaultParameterDefinition parameter = new DefaultParameterDefinition(this, parameterName, (Integer)record.get(p.ORDINAL_POSITION), type, record.get(p.PARAMETER_DEFAULT) != null, StringUtils.isBlank(parameterName), "", (Integer)record.get(c) > 1 ? record.get(p.ORDINAL_POSITION, String.class) : null);
            this.addParameter(InOutDefinition.getFromString(inOut), parameter);
        }
    }

    static Field<Integer> pNumericPrecision(Parameters p) {
        return DSL.when(p.NUMERIC_PRECISION.isNull().and(p.DATA_TYPE.in(new Field[]{DSL.inline("time"), DSL.inline("timetz"), DSL.inline("time without time zone"), DSL.inline("time with time zone"), DSL.inline("timestamp"), DSL.inline("timestamptz"), DSL.inline("timestamp without time zone"), DSL.inline("timestamp with time zone")})), DSL.inline(6)).else_(p.NUMERIC_PRECISION);
    }

    public boolean isProcedure() {
        return this.isProcedure;
    }
}

