/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.meta.hsqldb;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.jooq.Condition;
import org.jooq.Field;
import org.jooq.Record;
import org.jooq.TableLike;
import org.jooq.TableOptions;
import org.jooq.impl.DSL;
import org.jooq.meta.AbstractTableDefinition;
import org.jooq.meta.ColumnDefinition;
import org.jooq.meta.DataTypeDefinition;
import org.jooq.meta.DefaultColumnDefinition;
import org.jooq.meta.DefaultDataTypeDefinition;
import org.jooq.meta.SchemaDefinition;
import org.jooq.meta.hsqldb.information_schema.Tables;

public class HSQLDBTableDefinition
extends AbstractTableDefinition {
    public HSQLDBTableDefinition(SchemaDefinition schema, String name, String comment) {
        super(schema, name, comment);
    }

    public HSQLDBTableDefinition(SchemaDefinition schema, String name, String comment, TableOptions.TableType tableType, String source) {
        super(schema, name, comment, tableType, source);
    }

    @Override
    public List<ColumnDefinition> getElements0() throws SQLException {
        ArrayList<ColumnDefinition> result = new ArrayList<ColumnDefinition>();
        for (Record record : this.create().select(Tables.COLUMNS.COLUMN_NAME, Tables.COLUMNS.ORDINAL_POSITION, DSL.nvl(Tables.ELEMENT_TYPES.COLLECTION_TYPE_IDENTIFIER, DSL.when((Condition)Tables.COLUMNS.INTERVAL_TYPE.like(DSL.any(new Field[]{DSL.inline("%YEAR%"), DSL.inline("%MONTH%")})), DSL.inline("INTERVAL YEAR TO MONTH")).when((Condition)Tables.COLUMNS.INTERVAL_TYPE.like(DSL.any(new Field[]{DSL.inline("%DAY%"), DSL.inline("%HOUR%"), DSL.inline("%MINUTE%"), DSL.inline("%SECOND%")})), (Field<String>)DSL.inline("INTERVAL DAY TO SECOND")).else_(Tables.COLUMNS.DATA_TYPE)).as(Tables.COLUMNS.DATA_TYPE), Tables.COLUMNS.IDENTITY_GENERATION, Tables.COLUMNS.IS_NULLABLE, Tables.COLUMNS.COLUMN_DEFAULT, Tables.COLUMNS.GENERATION_EXPRESSION, DSL.nvl(Tables.ELEMENT_TYPES.CHARACTER_MAXIMUM_LENGTH, Tables.COLUMNS.CHARACTER_MAXIMUM_LENGTH).as(Tables.COLUMNS.CHARACTER_MAXIMUM_LENGTH), DSL.coalesce(Tables.ELEMENT_TYPES.DATETIME_PRECISION, new Field[]{Tables.ELEMENT_TYPES.NUMERIC_PRECISION, Tables.COLUMNS.DATETIME_PRECISION, Tables.COLUMNS.NUMERIC_PRECISION}).as(Tables.COLUMNS.NUMERIC_PRECISION), DSL.nvl(Tables.ELEMENT_TYPES.NUMERIC_SCALE, Tables.COLUMNS.NUMERIC_SCALE).as(Tables.COLUMNS.NUMERIC_SCALE), DSL.coalesce(Tables.COLUMNS.DOMAIN_SCHEMA, new Field[]{Tables.COLUMNS.UDT_SCHEMA}).as(Tables.COLUMNS.UDT_SCHEMA), DSL.coalesce(Tables.COLUMNS.DOMAIN_NAME, new Field[]{Tables.COLUMNS.UDT_NAME}).as(Tables.COLUMNS.UDT_NAME), Tables.SYSTEM_COLUMNS.REMARKS).from((TableLike<?>)Tables.COLUMNS).leftOuterJoin(Tables.SYSTEM_COLUMNS).on(Tables.COLUMNS.TABLE_CATALOG.eq(Tables.SYSTEM_COLUMNS.TABLE_CAT)).and(Tables.COLUMNS.TABLE_SCHEMA.eq(Tables.SYSTEM_COLUMNS.TABLE_SCHEM)).and(Tables.COLUMNS.TABLE_NAME.eq(Tables.SYSTEM_COLUMNS.TABLE_NAME)).and(Tables.COLUMNS.COLUMN_NAME.eq(Tables.SYSTEM_COLUMNS.COLUMN_NAME)).leftOuterJoin(Tables.ELEMENT_TYPES).on(Tables.COLUMNS.TABLE_SCHEMA.equal(Tables.ELEMENT_TYPES.OBJECT_SCHEMA)).and(Tables.COLUMNS.TABLE_NAME.equal(Tables.ELEMENT_TYPES.OBJECT_NAME)).and(Tables.COLUMNS.DTD_IDENTIFIER.equal(Tables.ELEMENT_TYPES.COLLECTION_TYPE_IDENTIFIER)).where(Tables.COLUMNS.TABLE_SCHEMA.equal(this.getSchema().getName())).and(Tables.COLUMNS.TABLE_NAME.equal(this.getName())).orderBy(Tables.COLUMNS.ORDINAL_POSITION)) {
            String generated = (String)record.get(Tables.COLUMNS.GENERATION_EXPRESSION);
            DefaultDataTypeDefinition type = new DefaultDataTypeDefinition(this.getDatabase(), this.getSchema(), (String)record.get(Tables.COLUMNS.DATA_TYPE), (Number)record.get(Tables.COLUMNS.CHARACTER_MAXIMUM_LENGTH), (Number)record.get(Tables.COLUMNS.NUMERIC_PRECISION), (Number)record.get(Tables.COLUMNS.NUMERIC_SCALE), record.get(Tables.COLUMNS.IS_NULLABLE, Boolean.TYPE), generated != null ? null : (String)record.get(Tables.COLUMNS.COLUMN_DEFAULT), DSL.name((String)record.get(Tables.COLUMNS.UDT_SCHEMA), (String)record.get(Tables.COLUMNS.UDT_NAME))).generatedAlwaysAs(generated);
            result.add(new DefaultColumnDefinition(this.getDatabase().getTable(this.getSchema(), this.getName()), (String)record.get(Tables.COLUMNS.COLUMN_NAME), result.size() + 1, (DataTypeDefinition)type, null != record.get(Tables.COLUMNS.IDENTITY_GENERATION), (String)record.get(Tables.SYSTEM_COLUMNS.REMARKS)));
        }
        return result;
    }
}

