/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.meta.hsqldb;

import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jooq.Condition;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.Name;
import org.jooq.Record;
import org.jooq.Record12;
import org.jooq.Record4;
import org.jooq.Record5;
import org.jooq.Record6;
import org.jooq.Records;
import org.jooq.Result;
import org.jooq.ResultQuery;
import org.jooq.SQLDialect;
import org.jooq.Select;
import org.jooq.SortOrder;
import org.jooq.Table;
import org.jooq.TableLike;
import org.jooq.TableOptions;
import org.jooq.impl.DSL;
import org.jooq.impl.SQLDataType;
import org.jooq.meta.AbstractDatabase;
import org.jooq.meta.AbstractIndexDefinition;
import org.jooq.meta.ArrayDefinition;
import org.jooq.meta.CatalogDefinition;
import org.jooq.meta.Database;
import org.jooq.meta.DefaultCheckConstraintDefinition;
import org.jooq.meta.DefaultDataTypeDefinition;
import org.jooq.meta.DefaultDomainDefinition;
import org.jooq.meta.DefaultIndexColumnDefinition;
import org.jooq.meta.DefaultRelations;
import org.jooq.meta.DefaultSequenceDefinition;
import org.jooq.meta.DomainDefinition;
import org.jooq.meta.EnumDefinition;
import org.jooq.meta.IndexColumnDefinition;
import org.jooq.meta.IndexDefinition;
import org.jooq.meta.PackageDefinition;
import org.jooq.meta.ResultQueryDatabase;
import org.jooq.meta.RoutineDefinition;
import org.jooq.meta.SchemaDefinition;
import org.jooq.meta.SequenceDefinition;
import org.jooq.meta.TableDefinition;
import org.jooq.meta.UDTDefinition;
import org.jooq.meta.XMLSchemaCollectionDefinition;
import org.jooq.meta.hsqldb.HSQLDBRoutineDefinition;
import org.jooq.meta.hsqldb.HSQLDBTableDefinition;
import org.jooq.meta.hsqldb.HSQLDBTableValuedFunction;
import org.jooq.meta.hsqldb.information_schema.Tables;
import org.jooq.meta.hsqldb.information_schema.tables.CheckConstraints;
import org.jooq.meta.hsqldb.information_schema.tables.Columns;
import org.jooq.meta.hsqldb.information_schema.tables.DomainConstraints;
import org.jooq.meta.hsqldb.information_schema.tables.Domains;
import org.jooq.meta.hsqldb.information_schema.tables.KeyColumnUsage;
import org.jooq.tools.JooqLogger;
import org.jooq.tools.StringUtils;

public class HSQLDBDatabase
extends AbstractDatabase
implements ResultQueryDatabase {
    @Override
    protected DSLContext create0() {
        return DSL.using(this.getConnection(), SQLDialect.HSQLDB);
    }

    @Override
    protected List<IndexDefinition> getIndexes0() throws SQLException {
        ArrayList<IndexDefinition> result = new ArrayList<IndexDefinition>();
        Map<Record, Result<Record>> indexes = this.create().select(Tables.SYSTEM_INDEXINFO.TABLE_SCHEM, Tables.SYSTEM_INDEXINFO.TABLE_NAME, Tables.SYSTEM_INDEXINFO.INDEX_NAME, Tables.SYSTEM_INDEXINFO.NON_UNIQUE, Tables.SYSTEM_INDEXINFO.COLUMN_NAME, Tables.SYSTEM_INDEXINFO.ORDINAL_POSITION, Tables.SYSTEM_INDEXINFO.ASC_OR_DESC).from((TableLike<?>)Tables.SYSTEM_INDEXINFO).where(Tables.SYSTEM_INDEXINFO.TABLE_SCHEM.in((Collection<?>)this.getInputSchemata())).and(this.getIncludeSystemIndexes() ? DSL.noCondition() : Tables.SYSTEM_INDEXINFO.INDEX_NAME.notLike("SYS!_IDX!_%", '!')).orderBy(Tables.SYSTEM_INDEXINFO.TABLE_SCHEM, Tables.SYSTEM_INDEXINFO.TABLE_NAME, Tables.SYSTEM_INDEXINFO.INDEX_NAME, Tables.SYSTEM_INDEXINFO.ORDINAL_POSITION).fetchGroups(new Field[]{Tables.SYSTEM_INDEXINFO.TABLE_SCHEM, Tables.SYSTEM_INDEXINFO.TABLE_NAME, Tables.SYSTEM_INDEXINFO.INDEX_NAME, Tables.SYSTEM_INDEXINFO.NON_UNIQUE}, new Field[]{Tables.SYSTEM_INDEXINFO.COLUMN_NAME, Tables.SYSTEM_INDEXINFO.ORDINAL_POSITION, Tables.SYSTEM_INDEXINFO.ASC_OR_DESC});
        block0: for (Map.Entry<Record, Result<Record>> entry : indexes.entrySet()) {
            Record index = entry.getKey();
            final Result<Record> cols = entry.getValue();
            SchemaDefinition tableSchema = this.getSchema((String)index.get(Tables.SYSTEM_INDEXINFO.TABLE_SCHEM));
            if (tableSchema == null) continue;
            String indexName = (String)index.get(Tables.SYSTEM_INDEXINFO.INDEX_NAME);
            String tableName = (String)index.get(Tables.SYSTEM_INDEXINFO.TABLE_NAME);
            final TableDefinition table = this.getTable(tableSchema, tableName);
            if (table == null) continue;
            boolean unique = index.get(Tables.SYSTEM_INDEXINFO.NON_UNIQUE, Boolean.TYPE) == false;
            for (Record column : cols) {
                if (table.getColumn((String)column.get(Tables.SYSTEM_INDEXINFO.COLUMN_NAME)) != null) continue;
                continue block0;
            }
            result.add(new AbstractIndexDefinition(tableSchema, indexName, table, unique){
                List<IndexColumnDefinition> indexColumns;
                {
                    super(schema, name, table2, unique);
                    this.indexColumns = new ArrayList<IndexColumnDefinition>();
                    for (Record column : cols) {
                        this.indexColumns.add(new DefaultIndexColumnDefinition(this, table.getColumn((String)column.get(Tables.SYSTEM_INDEXINFO.COLUMN_NAME)), "D".equals(column.get(Tables.SYSTEM_INDEXINFO.ASC_OR_DESC)) ? SortOrder.DESC : SortOrder.ASC, column.get(Tables.SYSTEM_INDEXINFO.ORDINAL_POSITION, Integer.TYPE)));
                    }
                }

                @Override
                protected List<IndexColumnDefinition> getIndexColumns0() {
                    return this.indexColumns;
                }
            });
        }
        return result;
    }

    @Override
    protected void loadPrimaryKeys(DefaultRelations relations2) throws SQLException {
        for (Record record : this.primaryKeys(this.getInputSchemata())) {
            SchemaDefinition schema = this.getSchema((String)record.get(Tables.KEY_COLUMN_USAGE.TABLE_SCHEMA));
            String key = (String)record.get(Tables.KEY_COLUMN_USAGE.CONSTRAINT_NAME);
            String tableName = (String)record.get(Tables.KEY_COLUMN_USAGE.TABLE_NAME);
            String columnName = (String)record.get(Tables.KEY_COLUMN_USAGE.COLUMN_NAME);
            TableDefinition table = this.getTable(schema, tableName);
            if (table == null) continue;
            relations2.addPrimaryKey(key, table, table.getColumn(columnName));
        }
    }

    @Override
    protected void loadUniqueKeys(DefaultRelations relations2) throws SQLException {
        for (Record record : this.uniqueKeys(this.getInputSchemata())) {
            SchemaDefinition schema = this.getSchema((String)record.get(Tables.KEY_COLUMN_USAGE.TABLE_SCHEMA));
            String key = (String)record.get(Tables.KEY_COLUMN_USAGE.CONSTRAINT_NAME);
            String tableName = (String)record.get(Tables.KEY_COLUMN_USAGE.TABLE_NAME);
            String columnName = (String)record.get(Tables.KEY_COLUMN_USAGE.COLUMN_NAME);
            TableDefinition table = this.getTable(schema, tableName);
            if (table == null) continue;
            relations2.addUniqueKey(key, table, table.getColumn(columnName));
        }
    }

    @Override
    public ResultQuery<Record6<String, String, String, String, String, Integer>> primaryKeys(List<String> schemas) {
        return this.keys(schemas, "PRIMARY KEY");
    }

    @Override
    public ResultQuery<Record6<String, String, String, String, String, Integer>> uniqueKeys(List<String> schemas) {
        return this.keys(schemas, "UNIQUE");
    }

    private ResultQuery<Record6<String, String, String, String, String, Integer>> keys(List<String> schemas, String constraintType) {
        return this.create().select(Tables.KEY_COLUMN_USAGE.TABLE_CATALOG, Tables.KEY_COLUMN_USAGE.TABLE_SCHEMA, Tables.KEY_COLUMN_USAGE.TABLE_NAME, Tables.KEY_COLUMN_USAGE.CONSTRAINT_NAME, Tables.KEY_COLUMN_USAGE.COLUMN_NAME, Tables.KEY_COLUMN_USAGE.ORDINAL_POSITION.coerce(SQLDataType.INTEGER)).from((TableLike<?>)Tables.KEY_COLUMN_USAGE).where(Tables.KEY_COLUMN_USAGE.tableConstraints().CONSTRAINT_TYPE.eq(DSL.inline(constraintType))).and(Tables.KEY_COLUMN_USAGE.tableConstraints().TABLE_SCHEMA.in((Collection<?>)schemas)).orderBy(Tables.KEY_COLUMN_USAGE.TABLE_SCHEMA.asc(), Tables.KEY_COLUMN_USAGE.TABLE_NAME.asc(), Tables.KEY_COLUMN_USAGE.CONSTRAINT_NAME.asc(), Tables.KEY_COLUMN_USAGE.ORDINAL_POSITION.asc());
    }

    @Override
    protected void loadForeignKeys(DefaultRelations relations2) throws SQLException {
        KeyColumnUsage fkKcu = Tables.KEY_COLUMN_USAGE.as("fk_kcu");
        KeyColumnUsage pkKcu = Tables.KEY_COLUMN_USAGE.as("pk_kcu");
        Result result = this.create().select(Tables.REFERENTIAL_CONSTRAINTS.UNIQUE_CONSTRAINT_NAME, Tables.REFERENTIAL_CONSTRAINTS.UNIQUE_CONSTRAINT_SCHEMA, Tables.TABLE_CONSTRAINTS.TABLE_NAME, fkKcu.CONSTRAINT_NAME, fkKcu.TABLE_SCHEMA, fkKcu.TABLE_NAME, fkKcu.COLUMN_NAME, pkKcu.COLUMN_NAME).from((TableLike<?>)Tables.REFERENTIAL_CONSTRAINTS).join(fkKcu).on(fkKcu.CONSTRAINT_SCHEMA.equal(Tables.REFERENTIAL_CONSTRAINTS.CONSTRAINT_SCHEMA)).and(fkKcu.CONSTRAINT_NAME.equal(Tables.REFERENTIAL_CONSTRAINTS.CONSTRAINT_NAME)).join(Tables.TABLE_CONSTRAINTS).on(Tables.TABLE_CONSTRAINTS.CONSTRAINT_SCHEMA.eq(Tables.REFERENTIAL_CONSTRAINTS.UNIQUE_CONSTRAINT_SCHEMA)).and(Tables.TABLE_CONSTRAINTS.CONSTRAINT_NAME.eq(Tables.REFERENTIAL_CONSTRAINTS.UNIQUE_CONSTRAINT_NAME)).join(pkKcu).on(pkKcu.CONSTRAINT_SCHEMA.eq(Tables.TABLE_CONSTRAINTS.CONSTRAINT_SCHEMA)).and(pkKcu.CONSTRAINT_NAME.eq(Tables.TABLE_CONSTRAINTS.CONSTRAINT_NAME)).and(pkKcu.ORDINAL_POSITION.eq(fkKcu.POSITION_IN_UNIQUE_CONSTRAINT)).where(fkKcu.TABLE_SCHEMA.in((Collection<?>)this.getInputSchemata())).orderBy(fkKcu.TABLE_SCHEMA.asc(), fkKcu.TABLE_NAME.asc(), fkKcu.CONSTRAINT_NAME.asc(), fkKcu.ORDINAL_POSITION.asc()).fetch();
        for (Record record : result) {
            SchemaDefinition foreignKeySchema = this.getSchema((String)record.get(fkKcu.TABLE_SCHEMA));
            SchemaDefinition uniqueKeySchema = this.getSchema((String)record.get(Tables.REFERENTIAL_CONSTRAINTS.UNIQUE_CONSTRAINT_SCHEMA));
            String foreignKey = (String)record.get(fkKcu.CONSTRAINT_NAME);
            String foreignKeyTableName = (String)record.get(fkKcu.TABLE_NAME);
            String foreignKeyColumn = (String)record.get(fkKcu.COLUMN_NAME);
            String uniqueKey = (String)record.get(Tables.REFERENTIAL_CONSTRAINTS.UNIQUE_CONSTRAINT_NAME);
            String uniqueKeyTableName = (String)record.get(Tables.TABLE_CONSTRAINTS.TABLE_NAME);
            String uniqueKeyColumn = (String)record.get(pkKcu.COLUMN_NAME);
            TableDefinition foreignKeyTable = this.getTable(foreignKeySchema, foreignKeyTableName);
            TableDefinition uniqueKeyTable = this.getTable(uniqueKeySchema, uniqueKeyTableName);
            if (foreignKeyTable == null || uniqueKeyTable == null) continue;
            relations2.addForeignKey(foreignKey, foreignKeyTable, foreignKeyTable.getColumn(foreignKeyColumn), uniqueKey, uniqueKeyTable, uniqueKeyTable.getColumn(uniqueKeyColumn), true);
        }
    }

    @Override
    protected void loadCheckConstraints(DefaultRelations relations2) throws SQLException {
        CheckConstraints cc = Tables.CHECK_CONSTRAINTS.as("cc");
        Columns c = Tables.COLUMNS.as("c");
        Field<String> constraintName = DSL.field(DSL.name(cc.CONSTRAINT_NAME.getName()), String.class);
        for (Record record : this.create().select(cc.tableConstraints().TABLE_SCHEMA, cc.tableConstraints().TABLE_NAME, constraintName, cc.CHECK_CLAUSE).from((TableLike<?>)cc).where(cc.tableConstraints().TABLE_SCHEMA.in((Collection<?>)this.getInputSchemata())).and(this.getIncludeSystemCheckConstraints() ? DSL.noCondition() : cc.tableConstraints().CONSTRAINT_NAME.notLike("SYS!_CT!_%", '!').or(cc.CHECK_CLAUSE.notIn(DSL.select(c.TABLE_SCHEMA.concat(DSL.inline('.')).concat(c.TABLE_NAME).concat(DSL.inline('.')).concat(c.COLUMN_NAME).concat(DSL.inline(" IS NOT NULL"))).from((TableLike<?>)c).where(c.TABLE_SCHEMA.eq(cc.tableConstraints().TABLE_SCHEMA)).and(c.TABLE_NAME.eq(cc.tableConstraints().TABLE_NAME)))))) {
            SchemaDefinition schema = this.getSchema((String)record.get(cc.tableConstraints().TABLE_SCHEMA));
            TableDefinition table = this.getTable(schema, (String)record.get(cc.tableConstraints().TABLE_NAME));
            if (table == null) continue;
            relations2.addCheckConstraint(table, new DefaultCheckConstraintDefinition(schema, table, record.get(constraintName), (String)record.get(cc.CHECK_CLAUSE)));
        }
    }

    @Override
    protected List<CatalogDefinition> getCatalogs0() throws SQLException {
        ArrayList<CatalogDefinition> result = new ArrayList<CatalogDefinition>();
        result.add(new CatalogDefinition((Database)this, "", ""));
        return result;
    }

    @Override
    protected List<SchemaDefinition> getSchemata0() throws SQLException {
        return this.create().select(Tables.SCHEMATA.SCHEMA_NAME).from((TableLike<?>)Tables.SCHEMATA).fetch(Records.mapping(s2 -> new SchemaDefinition((Database)this, (String)s2, "")));
    }

    @Override
    public ResultQuery<Record4<String, String, String, String>> sources(List<String> schemas) {
        return this.create().select(Tables.VIEWS.TABLE_CATALOG, Tables.VIEWS.TABLE_SCHEMA, Tables.VIEWS.TABLE_NAME, Tables.VIEWS.VIEW_DEFINITION).from((TableLike<?>)Tables.VIEWS).where(Tables.VIEWS.TABLE_SCHEMA.in((Collection<?>)schemas)).orderBy(Tables.VIEWS.TABLE_SCHEMA, Tables.VIEWS.TABLE_NAME);
    }

    @Override
    public ResultQuery<Record5<String, String, String, String, String>> comments(List<String> schemas) {
        Table c = DSL.select(Tables.SYSTEM_TABLES.TABLE_CAT, Tables.SYSTEM_TABLES.TABLE_SCHEM, Tables.SYSTEM_TABLES.TABLE_NAME, DSL.inline(null, SQLDataType.VARCHAR).as(Tables.COLUMNS.COLUMN_NAME), Tables.SYSTEM_TABLES.REMARKS).from((TableLike<?>)Tables.SYSTEM_TABLES).where(Tables.SYSTEM_TABLES.REMARKS.isNotNull()).unionAll((Select)DSL.select(Tables.COLUMNS.TABLE_CATALOG, Tables.COLUMNS.TABLE_SCHEMA, Tables.COLUMNS.TABLE_NAME, Tables.COLUMNS.COLUMN_NAME, Tables.SYSTEM_COLUMNS.REMARKS).from((TableLike<?>)Tables.COLUMNS).join(Tables.SYSTEM_COLUMNS).on(Tables.COLUMNS.TABLE_CATALOG.eq(Tables.SYSTEM_COLUMNS.TABLE_CAT)).and(Tables.COLUMNS.TABLE_SCHEMA.eq(Tables.SYSTEM_COLUMNS.TABLE_SCHEM)).and(Tables.COLUMNS.TABLE_NAME.eq(Tables.SYSTEM_COLUMNS.TABLE_NAME)).and(Tables.COLUMNS.COLUMN_NAME.eq(Tables.SYSTEM_COLUMNS.COLUMN_NAME)).where(Tables.SYSTEM_COLUMNS.REMARKS.isNotNull())).asTable("c");
        return this.create().select(c.field(Tables.SYSTEM_TABLES.TABLE_CAT), c.field(Tables.SYSTEM_TABLES.TABLE_SCHEM), c.field(Tables.SYSTEM_TABLES.TABLE_NAME), c.field(Tables.COLUMNS.COLUMN_NAME), c.field(Tables.SYSTEM_TABLES.REMARKS)).from((TableLike<?>)c).where(c.field(Tables.SYSTEM_TABLES.TABLE_SCHEM).in((Collection<?>)schemas)).orderBy(1, 2, 3, 4);
    }

    @Override
    public ResultQuery<Record12<String, String, String, String, Integer, Integer, Long, Long, BigDecimal, BigDecimal, Boolean, Long>> sequences(List<String> schemas) {
        return this.create().select(DSL.inline(null, SQLDataType.VARCHAR).as("catalog"), Tables.SEQUENCES.SEQUENCE_SCHEMA, Tables.SEQUENCES.SEQUENCE_NAME, Tables.SEQUENCES.DATA_TYPE, Tables.SEQUENCES.NUMERIC_PRECISION.coerce(SQLDataType.INTEGER), Tables.SEQUENCES.NUMERIC_SCALE.coerce(SQLDataType.INTEGER), Tables.SEQUENCES.START_WITH.coerce(SQLDataType.BIGINT), Tables.SEQUENCES.INCREMENT.coerce(SQLDataType.BIGINT), Tables.SEQUENCES.MINIMUM_VALUE.coerce(SQLDataType.NUMERIC), Tables.SEQUENCES.MAXIMUM_VALUE.coerce(SQLDataType.NUMERIC), DSL.decode(Tables.SEQUENCES.CYCLE_OPTION, DSL.inline("YES"), DSL.inline(true), DSL.inline(false)).as(Tables.SEQUENCES.CYCLE_OPTION), DSL.inline(null, SQLDataType.BIGINT).as("cache")).from((TableLike<?>)Tables.SEQUENCES).where(Tables.SEQUENCES.SEQUENCE_SCHEMA.in((Collection<?>)schemas)).orderBy(Tables.SEQUENCES.SEQUENCE_SCHEMA, Tables.SEQUENCES.SEQUENCE_NAME);
    }

    @Override
    protected List<SequenceDefinition> getSequences0() throws SQLException {
        ArrayList<SequenceDefinition> result = new ArrayList<SequenceDefinition>();
        for (Record record : this.sequences(this.getInputSchemata())) {
            SchemaDefinition schema = this.getSchema((String)record.get(Tables.SEQUENCES.SEQUENCE_SCHEMA));
            DefaultDataTypeDefinition type = new DefaultDataTypeDefinition(this, schema, (String)record.get(Tables.SEQUENCES.DATA_TYPE));
            result.add(new DefaultSequenceDefinition(schema, (String)record.get(Tables.SEQUENCES.SEQUENCE_NAME), type));
        }
        return result;
    }

    @Override
    public ResultQuery<Record6<String, String, String, String, String, Integer>> enums(List<String> schemas) {
        return null;
    }

    @Override
    protected List<TableDefinition> getTables0() throws SQLException {
        ArrayList<TableDefinition> result = new ArrayList<TableDefinition>();
        for (Record record : this.create().select(Tables.SYSTEM_TABLES.TABLE_SCHEM, Tables.SYSTEM_TABLES.TABLE_NAME, DSL.inline("").as(Tables.ROUTINES.SPECIFIC_NAME), Tables.SYSTEM_TABLES.REMARKS, DSL.trim(DSL.when(Tables.SYSTEM_TABLES.TABLE_TYPE.eq(DSL.inline("VIEW")), DSL.inline(TableOptions.TableType.VIEW.name())).else_(DSL.inline(TableOptions.TableType.TABLE.name()))).as("table_type"), DSL.when((Condition)DSL.lower(Tables.VIEWS.VIEW_DEFINITION).like(DSL.inline("create%")), Tables.VIEWS.VIEW_DEFINITION).else_(DSL.inline("create view \"").concat(Tables.SYSTEM_TABLES.TABLE_NAME).concat("\" as ").concat(Tables.VIEWS.VIEW_DEFINITION)).as(Tables.VIEWS.VIEW_DEFINITION)).from((TableLike<?>)Tables.SYSTEM_TABLES).leftJoin(Tables.VIEWS).on(Tables.SYSTEM_TABLES.TABLE_SCHEM.eq(Tables.VIEWS.TABLE_SCHEMA)).and(Tables.SYSTEM_TABLES.TABLE_NAME.eq(Tables.VIEWS.TABLE_NAME)).where(Tables.SYSTEM_TABLES.TABLE_SCHEM.in((Collection<?>)this.getInputSchemata())).unionAll((Select)(this.tableValuedFunctions() ? DSL.select(Tables.ROUTINES.ROUTINE_SCHEMA, Tables.ROUTINES.ROUTINE_NAME, Tables.ROUTINES.SPECIFIC_NAME, DSL.inline(""), DSL.inline(TableOptions.TableType.FUNCTION.name()), Tables.ROUTINES.ROUTINE_DEFINITION).from((TableLike<?>)Tables.ROUTINES).where(Tables.ROUTINES.ROUTINE_SCHEMA.in((Collection<?>)this.getInputSchemata())).and(Tables.ROUTINES.ROUTINE_TYPE.eq(DSL.inline("FUNCTION"))).and(Tables.ROUTINES.DATA_TYPE.startsWith(DSL.inline("ROW("))) : DSL.select(DSL.inline(""), DSL.inline(""), DSL.inline(""), DSL.inline(""), DSL.inline(TableOptions.TableType.FUNCTION.name()), DSL.inline("")).where((Condition)DSL.falseCondition()))).orderBy(Tables.SYSTEM_TABLES.TABLE_SCHEM, Tables.SYSTEM_TABLES.TABLE_NAME).fetch()) {
            SchemaDefinition schema = this.getSchema((String)record.get(Tables.SYSTEM_TABLES.TABLE_SCHEM));
            String name = (String)record.get(Tables.SYSTEM_TABLES.TABLE_NAME);
            String specificName = (String)record.get(Tables.ROUTINES.SPECIFIC_NAME);
            String comment = (String)record.get(Tables.SYSTEM_TABLES.REMARKS);
            TableOptions.TableType tableType = record.get("table_type", TableOptions.TableType.class);
            String source = (String)record.get(Tables.VIEWS.VIEW_DEFINITION);
            if (tableType == TableOptions.TableType.FUNCTION) {
                result.add(new HSQLDBTableValuedFunction(schema, name, specificName, comment, source));
                continue;
            }
            result.add(new HSQLDBTableDefinition(schema, name, comment, tableType, source));
        }
        return result;
    }

    @Override
    protected List<EnumDefinition> getEnums0() throws SQLException {
        ArrayList<EnumDefinition> result = new ArrayList<EnumDefinition>();
        return result;
    }

    @Override
    protected List<DomainDefinition> getDomains0() throws SQLException {
        LinkedHashMap<Name, DefaultDomainDefinition> result = new LinkedHashMap<Name, DefaultDomainDefinition>();
        Domains d = Tables.DOMAINS.as("d");
        DomainConstraints dc = Tables.DOMAIN_CONSTRAINTS.as("dc");
        for (Record record : this.create().select(d.DOMAIN_SCHEMA, d.DOMAIN_NAME, d.DATA_TYPE, d.CHARACTER_MAXIMUM_LENGTH, DSL.coalesce(d.NUMERIC_PRECISION, new Field[]{d.DATETIME_PRECISION}).as(d.NUMERIC_PRECISION), d.NUMERIC_SCALE, d.DOMAIN_DEFAULT, dc.checkConstraints().CHECK_CLAUSE).from((TableLike<?>)d).leftJoin(dc).on(d.DOMAIN_CATALOG.eq(dc.DOMAIN_CATALOG)).and(d.DOMAIN_SCHEMA.eq(dc.DOMAIN_SCHEMA)).and(d.DOMAIN_NAME.eq(dc.DOMAIN_NAME)).where(d.DOMAIN_SCHEMA.in((Collection<?>)this.getInputSchemata())).orderBy(d.DOMAIN_SCHEMA, d.DOMAIN_NAME, dc.checkConstraints().CONSTRAINT_NAME)) {
            String schemaName = (String)record.get(d.DOMAIN_SCHEMA);
            String domainName = (String)record.get(d.DOMAIN_NAME);
            String check = (String)record.get(dc.checkConstraints().CHECK_CLAUSE);
            DefaultDomainDefinition domain = result.computeIfAbsent(DSL.name(schemaName, domainName), k -> {
                SchemaDefinition schema = this.getSchema(schemaName);
                DefaultDataTypeDefinition baseType = new DefaultDataTypeDefinition(this, schema, (String)record.get(d.DATA_TYPE), (Number)record.get(d.CHARACTER_MAXIMUM_LENGTH), (Number)record.get(d.NUMERIC_PRECISION), (Number)record.get(d.NUMERIC_SCALE), true, (String)record.get(d.DOMAIN_DEFAULT));
                return new DefaultDomainDefinition(schema, domainName, baseType);
            });
            if (StringUtils.isBlank(check)) continue;
            domain.addCheckClause(check);
        }
        return new ArrayList<DomainDefinition>(result.values());
    }

    @Override
    protected List<XMLSchemaCollectionDefinition> getXMLSchemaCollections0() throws SQLException {
        ArrayList<XMLSchemaCollectionDefinition> result = new ArrayList<XMLSchemaCollectionDefinition>();
        return result;
    }

    @Override
    protected List<UDTDefinition> getUDTs0() throws SQLException {
        ArrayList<UDTDefinition> result = new ArrayList<UDTDefinition>();
        return result;
    }

    @Override
    protected List<ArrayDefinition> getArrays0() throws SQLException {
        ArrayList<ArrayDefinition> result = new ArrayList<ArrayDefinition>();
        return result;
    }

    @Override
    protected List<RoutineDefinition> getRoutines0() throws SQLException {
        ArrayList<RoutineDefinition> result = new ArrayList<RoutineDefinition>();
        for (Record record : this.create().select(Tables.ROUTINES.ROUTINE_SCHEMA, Tables.ROUTINES.ROUTINE_NAME, Tables.ROUTINES.SPECIFIC_NAME, DSL.nvl(Tables.ELEMENT_TYPES.COLLECTION_TYPE_IDENTIFIER, Tables.ROUTINES.DATA_TYPE).as("datatype"), Tables.ROUTINES.NUMERIC_PRECISION, Tables.ROUTINES.NUMERIC_SCALE, Tables.ROUTINES.ROUTINE_DEFINITION.likeRegex(".*(?i:(\\w+\\s+)+aggregate\\s+function).*").as("aggregate")).from((TableLike<?>)Tables.ROUTINES).leftOuterJoin(Tables.ELEMENT_TYPES).on(Tables.ROUTINES.ROUTINE_SCHEMA.equal(Tables.ELEMENT_TYPES.OBJECT_SCHEMA)).and(Tables.ROUTINES.ROUTINE_NAME.equal(Tables.ELEMENT_TYPES.OBJECT_NAME)).and(Tables.ROUTINES.DTD_IDENTIFIER.equal(Tables.ELEMENT_TYPES.COLLECTION_TYPE_IDENTIFIER)).where(Tables.ROUTINES.ROUTINE_SCHEMA.in((Collection<?>)this.getInputSchemata())).and(this.tableValuedFunctions() ? Tables.ROUTINES.DATA_TYPE.isNull().or(Tables.ROUTINES.DATA_TYPE.notLike(DSL.inline("ROW(%"))) : DSL.noCondition()).orderBy(Tables.ROUTINES.ROUTINE_SCHEMA, Tables.ROUTINES.ROUTINE_NAME).fetch()) {
            String datatype = record.get("datatype", String.class);
            if (datatype != null && datatype.toUpperCase().startsWith("ROW")) {
                JooqLogger.getLogger(this.getClass()).info("A row : " + datatype);
                datatype = "ROW";
            }
            result.add(new HSQLDBRoutineDefinition(this.getSchema((String)record.get(Tables.ROUTINES.ROUTINE_SCHEMA)), (String)record.get(Tables.ROUTINES.ROUTINE_NAME), (String)record.get(Tables.ROUTINES.SPECIFIC_NAME), datatype, (Number)record.get(Tables.ROUTINES.NUMERIC_PRECISION), (Number)record.get(Tables.ROUTINES.NUMERIC_SCALE), record.get("aggregate", Boolean.TYPE)));
        }
        return result;
    }

    @Override
    protected List<PackageDefinition> getPackages0() throws SQLException {
        ArrayList<PackageDefinition> result = new ArrayList<PackageDefinition>();
        return result;
    }
}

