/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.meta.duckdb;

import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.jooq.DSLContext;
import org.jooq.QueryPart;
import org.jooq.Record;
import org.jooq.Record12;
import org.jooq.Record4;
import org.jooq.Record5;
import org.jooq.Record6;
import org.jooq.Records;
import org.jooq.ResultQuery;
import org.jooq.SQLDialect;
import org.jooq.Select;
import org.jooq.TableOptions;
import org.jooq.conf.RenderMapping;
import org.jooq.impl.DSL;
import org.jooq.impl.SQLDataType;
import org.jooq.meta.AbstractDatabase;
import org.jooq.meta.ArrayDefinition;
import org.jooq.meta.CatalogDefinition;
import org.jooq.meta.Database;
import org.jooq.meta.DefaultDataTypeDefinition;
import org.jooq.meta.DefaultRelations;
import org.jooq.meta.DefaultSequenceDefinition;
import org.jooq.meta.DomainDefinition;
import org.jooq.meta.EnumDefinition;
import org.jooq.meta.IndexDefinition;
import org.jooq.meta.PackageDefinition;
import org.jooq.meta.ResultQueryDatabase;
import org.jooq.meta.RoutineDefinition;
import org.jooq.meta.SchemaDefinition;
import org.jooq.meta.SequenceDefinition;
import org.jooq.meta.TableDefinition;
import org.jooq.meta.UDTDefinition;
import org.jooq.meta.XMLSchemaCollectionDefinition;
import org.jooq.meta.duckdb.DuckDBTableDefinition;
import org.jooq.meta.duckdb.DuckDBUDTDefinition;
import org.jooq.meta.duckdb.system.main.Tables;

public class DuckDBDatabase
extends AbstractDatabase
implements ResultQueryDatabase {
    @Override
    protected DSLContext create0() {
        DSLContext ctx = DSL.using(this.getConnection(), SQLDialect.DUCKDB);
        ctx.settings().setRenderMapping(new RenderMapping().withDefaultCatalog(Tables.DUCKDB_TABLES.getCatalog().getName()).withDefaultSchema(Tables.DUCKDB_TABLES.getSchema().getName()));
        return ctx;
    }

    @Override
    protected List<IndexDefinition> getIndexes0() throws SQLException {
        ArrayList<IndexDefinition> result = new ArrayList<IndexDefinition>();
        return result;
    }

    @Override
    protected void loadPrimaryKeys(DefaultRelations relations2) throws SQLException {
        for (Record record : this.primaryKeys(this.getInputSchemata())) {
            CatalogDefinition catalog = this.getCatalog((String)record.get(Tables.DUCKDB_CONSTRAINTS.DATABASE_NAME));
            if (catalog == null) continue;
            SchemaDefinition schema = catalog.getSchema((String)record.get(Tables.DUCKDB_CONSTRAINTS.SCHEMA_NAME));
            String key = (String)record.get(Tables.DUCKDB_CONSTRAINTS.CONSTRAINT_TEXT);
            String tableName = (String)record.get(Tables.DUCKDB_CONSTRAINTS.TABLE_NAME);
            String columnName = record.get(Tables.DUCKDB_CONSTRAINTS.CONSTRAINT_COLUMN_NAMES, String.class);
            TableDefinition table = this.getTable(schema, tableName);
            if (table == null) continue;
            relations2.addPrimaryKey(key, table, table.getColumn(columnName));
        }
    }

    @Override
    protected void loadUniqueKeys(DefaultRelations relations2) throws SQLException {
        for (Record record : this.uniqueKeys(this.getInputSchemata())) {
            CatalogDefinition catalog = this.getCatalog((String)record.get(Tables.DUCKDB_CONSTRAINTS.DATABASE_NAME));
            if (catalog == null) continue;
            SchemaDefinition schema = catalog.getSchema((String)record.get(Tables.DUCKDB_CONSTRAINTS.SCHEMA_NAME));
            String key = (String)record.get(Tables.DUCKDB_CONSTRAINTS.CONSTRAINT_TEXT);
            String tableName = (String)record.get(Tables.DUCKDB_CONSTRAINTS.TABLE_NAME);
            String columnName = record.get(Tables.DUCKDB_CONSTRAINTS.CONSTRAINT_COLUMN_NAMES, String.class);
            TableDefinition table = this.getTable(schema, tableName);
            if (table == null) continue;
            relations2.addUniqueKey(key, table, table.getColumn(columnName));
        }
    }

    @Override
    public ResultQuery<Record6<String, String, String, String, String, Integer>> primaryKeys(List<String> schemas) {
        return this.keys(schemas, "PRIMARY KEY");
    }

    @Override
    public ResultQuery<Record6<String, String, String, String, String, Integer>> uniqueKeys(List<String> schemas) {
        return this.keys(schemas, "UNIQUE");
    }

    private ResultQuery<Record6<String, String, String, String, String, Integer>> keys(List<String> schemas, String constraintType) {
        return this.create().select(Tables.DUCKDB_CONSTRAINTS.DATABASE_NAME, Tables.DUCKDB_CONSTRAINTS.SCHEMA_NAME, Tables.DUCKDB_CONSTRAINTS.TABLE_NAME, Tables.DUCKDB_CONSTRAINTS.DATABASE_NAME.concat(DSL.inline("__")).concat(Tables.DUCKDB_CONSTRAINTS.SCHEMA_NAME).concat(DSL.inline("__")).concat(Tables.DUCKDB_CONSTRAINTS.TABLE_NAME).concat(DSL.inline("__")).concat(Tables.DUCKDB_CONSTRAINTS.CONSTRAINT_TEXT).as(Tables.DUCKDB_CONSTRAINTS.CONSTRAINT_TEXT), DSL.field("unnest({0})", SQLDataType.VARCHAR, new QueryPart[]{Tables.DUCKDB_CONSTRAINTS.CONSTRAINT_COLUMN_NAMES}).as(Tables.DUCKDB_CONSTRAINTS.CONSTRAINT_COLUMN_NAMES), DSL.field("unnest({0})", SQLDataType.INTEGER, new QueryPart[]{Tables.DUCKDB_CONSTRAINTS.CONSTRAINT_COLUMN_INDEXES}).as(Tables.DUCKDB_CONSTRAINTS.CONSTRAINT_COLUMN_INDEXES)).from("{0}()", Tables.DUCKDB_CONSTRAINTS).where(Tables.DUCKDB_CONSTRAINTS.CONSTRAINT_TYPE.eq(DSL.inline(constraintType))).and(Tables.DUCKDB_CONSTRAINTS.SCHEMA_NAME.in((Collection<?>)schemas));
    }

    @Override
    protected void loadForeignKeys(DefaultRelations relations2) throws SQLException {
    }

    @Override
    protected void loadCheckConstraints(DefaultRelations relations2) throws SQLException {
    }

    @Override
    protected List<CatalogDefinition> getCatalogs0() throws SQLException {
        return this.create().select(Tables.DUCKDB_DATABASES.DATABASE_NAME).from("{0}()", Tables.DUCKDB_DATABASES).fetch(Records.mapping(c -> new CatalogDefinition((Database)this, (String)c, "")));
    }

    @Override
    protected List<SchemaDefinition> getSchemata0() throws SQLException {
        return this.create().select(Tables.DUCKDB_SCHEMAS.DATABASE_NAME, Tables.DUCKDB_SCHEMAS.SCHEMA_NAME).from("{0}()", Tables.DUCKDB_SCHEMAS).where(Tables.DUCKDB_SCHEMAS.DATABASE_NAME.in((Collection<?>)this.getInputCatalogs())).fetch(Records.mapping((c, s2) -> new SchemaDefinition((Database)this, (String)s2, "", this.getCatalog((String)c))));
    }

    @Override
    public ResultQuery<Record4<String, String, String, String>> sources(List<String> schemas) {
        return this.create().select(Tables.DUCKDB_VIEWS.DATABASE_NAME, Tables.DUCKDB_VIEWS.SCHEMA_NAME, Tables.DUCKDB_VIEWS.VIEW_NAME, Tables.DUCKDB_VIEWS.SQL).from("{0}()", Tables.DUCKDB_VIEWS).where(Tables.DUCKDB_VIEWS.SCHEMA_NAME.in((Collection<?>)schemas));
    }

    @Override
    public ResultQuery<Record5<String, String, String, String, String>> comments(List<String> schemas) {
        return null;
    }

    @Override
    public ResultQuery<Record12<String, String, String, String, Integer, Integer, Long, Long, BigDecimal, BigDecimal, Boolean, Long>> sequences(List<String> schemas) {
        return this.create().resultQuery("select\n  database_name,\n  schema_name,\n  sequence_name,\n  'bigint' as data_type,\n  0 as precision,\n  0 as scale,\n  start_value,\n  increment_by,\n  min_value,\n  max_value,\n  cycle,\n  0 as cache\nfrom duckdb_sequences()\nwhere sequence_name in ({0})\n", DSL.list(schemas.stream().map(DSL::val).collect(Collectors.toList()))).coerce(DSL.field("database_name", SQLDataType.VARCHAR), DSL.field("schema_name", SQLDataType.VARCHAR), DSL.field("sequence_name", SQLDataType.VARCHAR), DSL.field("data_type", SQLDataType.VARCHAR), DSL.field("precision", SQLDataType.INTEGER), DSL.field("scale", SQLDataType.INTEGER), DSL.field("start_value", SQLDataType.BIGINT), DSL.field("increment_by", SQLDataType.BIGINT), DSL.field("min_value", SQLDataType.NUMERIC), DSL.field("max_value", SQLDataType.NUMERIC), DSL.field("cycle", SQLDataType.BOOLEAN), DSL.field("cache", SQLDataType.BIGINT));
    }

    @Override
    protected List<SequenceDefinition> getSequences0() throws SQLException {
        ArrayList<SequenceDefinition> result = new ArrayList<SequenceDefinition>();
        for (Record record : this.sequences(this.getInputSchemata())) {
            SchemaDefinition schema;
            CatalogDefinition catalog = this.getCatalog(record.get("database_name", String.class));
            if (catalog == null || (schema = this.getSchema(record.get("schema_name", String.class))) == null) continue;
            DefaultDataTypeDefinition type = new DefaultDataTypeDefinition(this, schema, "BIGINT");
            result.add(new DefaultSequenceDefinition(schema, record.get("sequence_name", String.class), type));
        }
        return result;
    }

    @Override
    protected List<TableDefinition> getTables0() throws SQLException {
        ArrayList<TableDefinition> result = new ArrayList<TableDefinition>();
        for (Record record : this.create().select(Tables.DUCKDB_TABLES.DATABASE_NAME, Tables.DUCKDB_TABLES.SCHEMA_NAME, Tables.DUCKDB_TABLES.TABLE_NAME, DSL.inline(TableOptions.TableType.TABLE.name()).as("table_type")).from("{0}()", Tables.DUCKDB_TABLES).where(DSL.row(Tables.DUCKDB_TABLES.DATABASE_NAME, Tables.DUCKDB_TABLES.SCHEMA_NAME).in(this.getInputCatalogsAndSchemata().stream().map(e -> DSL.row((String)e.getKey(), (String)e.getValue())).collect(Collectors.toList()))).unionAll((Select)DSL.select(Tables.DUCKDB_VIEWS.DATABASE_NAME, Tables.DUCKDB_VIEWS.SCHEMA_NAME, Tables.DUCKDB_VIEWS.VIEW_NAME, DSL.inline(TableOptions.TableType.VIEW.name()).as("table_type")).from("{0}()", Tables.DUCKDB_VIEWS).where(DSL.row(Tables.DUCKDB_VIEWS.DATABASE_NAME, Tables.DUCKDB_VIEWS.SCHEMA_NAME).in(this.getInputCatalogsAndSchemata().stream().map(e -> DSL.row((String)e.getKey(), (String)e.getValue())).collect(Collectors.toList())))).orderBy(1, 2, 3)) {
            CatalogDefinition catalog = this.getCatalog((String)record.get(Tables.DUCKDB_TABLES.DATABASE_NAME));
            SchemaDefinition schema = catalog.getSchema((String)record.get(Tables.DUCKDB_TABLES.SCHEMA_NAME));
            String name = (String)record.get(Tables.DUCKDB_TABLES.TABLE_NAME);
            TableOptions.TableType tableType = record.get("table_type", TableOptions.TableType.class);
            result.add(new DuckDBTableDefinition(schema, name, "", tableType, null));
        }
        return result;
    }

    @Override
    protected List<EnumDefinition> getEnums0() throws SQLException {
        ArrayList<EnumDefinition> result = new ArrayList<EnumDefinition>();
        return result;
    }

    @Override
    public ResultQuery<Record6<String, String, String, String, String, Integer>> enums(List<String> schemas) {
        return null;
    }

    @Override
    protected List<DomainDefinition> getDomains0() throws SQLException {
        ArrayList<DomainDefinition> result = new ArrayList<DomainDefinition>();
        return result;
    }

    @Override
    protected List<XMLSchemaCollectionDefinition> getXMLSchemaCollections0() throws SQLException {
        ArrayList<XMLSchemaCollectionDefinition> result = new ArrayList<XMLSchemaCollectionDefinition>();
        return result;
    }

    @Override
    protected List<UDTDefinition> getUDTs0() throws SQLException {
        ArrayList<UDTDefinition> result = new ArrayList<UDTDefinition>();
        for (Record r : this.create().select(Tables.DUCKDB_TYPES.SCHEMA_NAME, Tables.DUCKDB_TYPES.TYPE_NAME).from("{0}()", Tables.DUCKDB_TYPES).where(Tables.DUCKDB_TYPES.SCHEMA_NAME.in((Collection<?>)this.getInputSchemata())).and(Tables.DUCKDB_TYPES.LOGICAL_TYPE.eq(DSL.inline("STRUCT"))).andNot(Tables.DUCKDB_TYPES.INTERNAL)) {
            SchemaDefinition schema = this.getSchema((String)r.get(Tables.DUCKDB_TYPES.SCHEMA_NAME));
            if (schema == null) continue;
            result.add(new DuckDBUDTDefinition(schema, (String)r.get(Tables.DUCKDB_TYPES.TYPE_NAME), ""));
        }
        return result;
    }

    @Override
    protected List<ArrayDefinition> getArrays0() throws SQLException {
        ArrayList<ArrayDefinition> result = new ArrayList<ArrayDefinition>();
        return result;
    }

    @Override
    protected List<RoutineDefinition> getRoutines0() throws SQLException {
        ArrayList<RoutineDefinition> result = new ArrayList<RoutineDefinition>();
        return result;
    }

    @Override
    protected List<PackageDefinition> getPackages0() throws SQLException {
        ArrayList<PackageDefinition> result = new ArrayList<PackageDefinition>();
        return result;
    }
}

