/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.meta.derby;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.jooq.Record;
import org.jooq.TableLike;
import org.jooq.TableOptions;
import org.jooq.impl.DSL;
import org.jooq.impl.SQLDataType;
import org.jooq.meta.AbstractTableDefinition;
import org.jooq.meta.ColumnDefinition;
import org.jooq.meta.DataTypeDefinition;
import org.jooq.meta.DefaultColumnDefinition;
import org.jooq.meta.DefaultDataTypeDefinition;
import org.jooq.meta.SchemaDefinition;
import org.jooq.meta.derby.sys.Tables;

public class DerbyTableDefinition
extends AbstractTableDefinition {
    private final String tableid;

    public DerbyTableDefinition(SchemaDefinition schema, String name, String tableid, TableOptions.TableType tableType, String source) {
        super(schema, name, "", tableType, source);
        this.tableid = tableid;
    }

    @Override
    public List<ColumnDefinition> getElements0() throws SQLException {
        ArrayList<ColumnDefinition> result = new ArrayList<ColumnDefinition>();
        for (Record record : this.create().select(Tables.SYSCOLUMNS.COLUMNNAME, Tables.SYSCOLUMNS.COLUMNNUMBER, Tables.SYSCOLUMNS.COLUMNDATATYPE, DSL.when(Tables.SYSCOLUMNS.AUTOINCREMENTINC.isNull(), Tables.SYSCOLUMNS.COLUMNDEFAULT).as(Tables.SYSCOLUMNS.COLUMNDEFAULT), Tables.SYSCOLUMNS.AUTOINCREMENTINC).from((TableLike<?>)Tables.SYSCOLUMNS).where(Tables.SYSCOLUMNS.REFERENCEID.cast(SQLDataType.VARCHAR(32672)).equal(DSL.inline(this.tableid))).orderBy(Tables.SYSCOLUMNS.COLUMNNUMBER)) {
            String columnDataType = record.get(Tables.SYSCOLUMNS.COLUMNDATATYPE, String.class);
            String typeName = this.parseTypeName(columnDataType);
            Number precision = "TIMESTAMP".equalsIgnoreCase(typeName) ? (Number)9 : (Number)this.parsePrecision(columnDataType);
            Number scale = this.parseScale(columnDataType);
            String defaultValue = (String)record.get(Tables.SYSCOLUMNS.COLUMNDEFAULT);
            boolean generated = defaultValue != null && defaultValue.toUpperCase().startsWith("GENERATED ALWAYS AS");
            DefaultDataTypeDefinition type = new DefaultDataTypeDefinition(this.getDatabase(), this.getSchema(), typeName, precision, precision, scale, !this.parseNotNull(columnDataType), generated ? null : defaultValue).generatedAlwaysAs(generated ? defaultValue.replaceAll("(?i:GENERATED\\s+ALWAYS\\s+AS\\s*\\(\\s*(.*?)\\s*\\)\\s*)", "$1") : null);
            result.add(new DefaultColumnDefinition(this.getDatabase().getTable(this.getSchema(), this.getName()), (String)record.get(Tables.SYSCOLUMNS.COLUMNNAME), result.size() + 1, (DataTypeDefinition)type, null != record.get(Tables.SYSCOLUMNS.AUTOINCREMENTINC), null));
        }
        return result;
    }
}

