/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.meta;

import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.jooq.Log;
import org.jooq.tools.JooqLogger;

public class BufferedLog
implements Log {
    private static final Queue<Message> messages = new ConcurrentLinkedQueue<Message>();
    private final JooqLogger delegate;

    public static BufferedLog getLogger(Class<?> type) {
        return new BufferedLog(JooqLogger.getLogger(type));
    }

    BufferedLog(JooqLogger delegate) {
        this.delegate = delegate;
    }

    public static synchronized void flush() {
        JooqLogger delegate = JooqLogger.getLogger(BufferedLog.class);
        if (!messages.isEmpty()) {
            delegate.warn("Buffered warning and error messages:");
            delegate.warn("------------------------------------");
        }
        for (Message m4 : messages) {
            switch (m4.level) {
                case DEBUG: {
                    delegate.debug(m4.message, m4.details, m4.throwable);
                    break;
                }
                case TRACE: {
                    delegate.trace(m4.message, m4.details, m4.throwable);
                    break;
                }
                case INFO: {
                    delegate.info(m4.message, m4.details, m4.throwable);
                    break;
                }
                case WARN: {
                    delegate.warn(m4.message, m4.details, m4.throwable);
                    break;
                }
                case ERROR: 
                case FATAL: {
                    delegate.error(m4.message, m4.details, m4.throwable);
                }
            }
        }
        messages.clear();
    }

    static Message message(Log.Level level, Object message) {
        return new Message(level, message, null, null);
    }

    static Message message(Log.Level level, Object message, Object details) {
        return new Message(level, message, details, null);
    }

    static Message message(Log.Level level, Object message, Throwable throwable) {
        return new Message(level, message, null, throwable);
    }

    static Message message(Log.Level level, Object message, Object details, Throwable throwable) {
        return new Message(level, message, details, throwable);
    }

    @Override
    public boolean isTraceEnabled() {
        return this.delegate.isTraceEnabled();
    }

    @Override
    public void trace(Object message) {
        this.delegate.trace(message);
    }

    @Override
    public void trace(Object message, Object details) {
        this.delegate.trace(message, details);
    }

    @Override
    public void trace(Object message, Throwable throwable) {
        this.delegate.trace(message, throwable);
    }

    @Override
    public void trace(Object message, Object details, Throwable throwable) {
        this.delegate.trace(message, details, throwable);
    }

    @Override
    public boolean isDebugEnabled() {
        return this.delegate.isDebugEnabled();
    }

    @Override
    public void debug(Object message) {
        this.delegate.debug(message);
    }

    @Override
    public void debug(Object message, Object details) {
        this.delegate.debug(message, details);
    }

    @Override
    public void debug(Object message, Throwable throwable) {
        this.delegate.debug(message, throwable);
    }

    @Override
    public void debug(Object message, Object details, Throwable throwable) {
        this.delegate.debug(message, details, throwable);
    }

    @Override
    public boolean isInfoEnabled() {
        return this.delegate.isInfoEnabled();
    }

    @Override
    public void info(Object message) {
        this.delegate.info(message);
    }

    @Override
    public void info(Object message, Object details) {
        this.delegate.info(message, details);
    }

    @Override
    public void info(Object message, Throwable throwable) {
        this.delegate.info(message, throwable);
    }

    @Override
    public void info(Object message, Object details, Throwable throwable) {
        this.delegate.info(message, details, throwable);
    }

    @Override
    public boolean isWarnEnabled() {
        return this.delegate.isWarnEnabled();
    }

    @Override
    public void warn(Object message) {
        this.delegate.warn(message);
        messages.add(BufferedLog.message(Log.Level.WARN, message));
    }

    @Override
    public void warn(Object message, Object details) {
        this.delegate.warn(message, details);
        messages.add(BufferedLog.message(Log.Level.WARN, message, details));
    }

    @Override
    public void warn(Object message, Throwable throwable) {
        this.delegate.warn(message, throwable);
        messages.add(BufferedLog.message(Log.Level.WARN, message, throwable));
    }

    @Override
    public void warn(Object message, Object details, Throwable throwable) {
        this.delegate.warn(message, details, throwable);
        messages.add(BufferedLog.message(Log.Level.WARN, message, details, throwable));
    }

    @Override
    public boolean isErrorEnabled() {
        return this.delegate.isErrorEnabled();
    }

    @Override
    public void error(Object message) {
        this.delegate.error(message);
        messages.add(BufferedLog.message(Log.Level.ERROR, message));
    }

    @Override
    public void error(Object message, Object details) {
        this.delegate.error(message, details);
        messages.add(BufferedLog.message(Log.Level.ERROR, message, details));
    }

    @Override
    public void error(Object message, Throwable throwable) {
        this.delegate.error(message, throwable);
        messages.add(BufferedLog.message(Log.Level.ERROR, message, throwable));
    }

    @Override
    public void error(Object message, Object details, Throwable throwable) {
        this.delegate.error(message, details, throwable);
        messages.add(BufferedLog.message(Log.Level.ERROR, message, details, throwable));
    }

    @Override
    public void log(Log.Level level, Object message) {
        this.delegate.log(level, message);
        messages.add(BufferedLog.message(Log.Level.ERROR, message));
    }

    @Override
    public void log(Log.Level level, Object message, Object details) {
        this.delegate.log(level, message, details);
        messages.add(BufferedLog.message(Log.Level.ERROR, message, details));
    }

    @Override
    public void log(Log.Level level, Object message, Throwable throwable) {
        this.delegate.log(level, message, throwable);
        messages.add(BufferedLog.message(Log.Level.ERROR, message, throwable));
    }

    @Override
    public void log(Log.Level level, Object message, Object details, Throwable throwable) {
        this.delegate.log(level, message, details, throwable);
        messages.add(BufferedLog.message(Log.Level.ERROR, message, details, throwable));
    }

    private static class Message {
        final Log.Level level;
        final Object message;
        final Object details;
        final Throwable throwable;

        Message(Log.Level level, Object message, Object details, Throwable throwable) {
            this.level = level;
            this.message = message;
            this.details = details;
            this.throwable = throwable;
        }
    }
}

