/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.meta;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jooq.Converter;
import org.jooq.DataType;
import org.jooq.Name;
import org.jooq.exception.SQLDialectNotSupportedException;
import org.jooq.impl.AutoConverter;
import org.jooq.impl.DateAsTimestampBinding;
import org.jooq.impl.DefaultDataType;
import org.jooq.impl.EnumConverter;
import org.jooq.impl.LocalDateAsLocalDateTimeBinding;
import org.jooq.impl.SQLDataType;
import org.jooq.impl.XMLtoJAXBConverter;
import org.jooq.meta.AbstractDefinition;
import org.jooq.meta.DataTypeDefinition;
import org.jooq.meta.Database;
import org.jooq.meta.DefaultDataTypeDefinition;
import org.jooq.meta.DefaultJavaTypeResolver;
import org.jooq.meta.Definition;
import org.jooq.meta.DomainDefinition;
import org.jooq.meta.IndexDefinition;
import org.jooq.meta.JavaTypeResolver;
import org.jooq.meta.RoutineDefinition;
import org.jooq.meta.TableDefinition;
import org.jooq.meta.TypedElementDefinition;
import org.jooq.meta.UDTDefinition;
import org.jooq.meta.jaxb.CustomType;
import org.jooq.meta.jaxb.ForcedType;
import org.jooq.meta.jaxb.LambdaConverter;
import org.jooq.tools.Convert;
import org.jooq.tools.JooqLogger;
import org.jooq.tools.StringUtils;

public abstract class AbstractTypedElementDefinition<T extends Definition>
extends AbstractDefinition
implements TypedElementDefinition<T> {
    private static final JooqLogger log = JooqLogger.getLogger(AbstractTypedElementDefinition.class);
    private static final Pattern LENGTH_PRECISION_SCALE_PATTERN = Pattern.compile("[\\w\\s]+(?:\\(\\s*?(\\d+)\\s*?\\)|\\(\\s*?(\\d+)\\s*?,\\s*?(\\d+)\\s*?\\))");
    private final T container;
    private final DataTypeDefinition definedType;
    private transient DataTypeDefinition type;

    public AbstractTypedElementDefinition(T container, String name, int position, DataTypeDefinition definedType, String comment) {
        this(container, name, position, definedType, comment, null);
    }

    public AbstractTypedElementDefinition(T container, String name, int position, DataTypeDefinition definedType, String comment, String overload) {
        super(container.getDatabase(), container.getSchema(), AbstractTypedElementDefinition.protectName(container, name, position), comment, overload);
        this.container = container;
        this.definedType = definedType;
    }

    private static final String protectName(Definition container, String name, int position) {
        if (name == null) {
            if (container instanceof TableDefinition) {
                log.info((Object)"Missing name", "Table " + String.valueOf(container) + " holds a column without a name at position " + position);
            } else if (container instanceof UDTDefinition) {
                log.info((Object)"Missing name", "UDT " + String.valueOf(container) + " holds an attribute without a name at position " + position);
            } else if (container instanceof IndexDefinition) {
                log.info((Object)"Missing name", "Index " + String.valueOf(container) + " holds a column without a name at position " + position);
            } else if (container instanceof RoutineDefinition) {
                log.info((Object)"Missing name", "Routine " + String.valueOf(container) + " holds a parameter without a name at position " + position);
            } else {
                log.info((Object)"Missing name", "Object " + String.valueOf(container) + " holds an element without a name at position " + position);
            }
            return "_" + position;
        }
        return name;
    }

    @Override
    public final T getContainer() {
        return this.container;
    }

    @Override
    public List<Definition> getDefinitionPath() {
        ArrayList<Definition> result = new ArrayList<Definition>();
        result.addAll(this.getContainer().getDefinitionPath());
        result.add(this);
        return result;
    }

    @Override
    public DataTypeDefinition getType() {
        if (this.type == null) {
            this.type = AbstractTypedElementDefinition.mapDefinedType(this.container, this, this.definedType, new DefaultJavaTypeResolver());
        }
        return this.type;
    }

    @Override
    public DataTypeDefinition getType(JavaTypeResolver resolver) {
        return AbstractTypedElementDefinition.mapDefinedType(this.container, this, this.definedType, resolver);
    }

    @Override
    public DataTypeDefinition getDefinedType() {
        return this.definedType;
    }

    public static final DataType<?> getDataType(Database db, String t2, int p, int s2) {
        if ("OFFSETDATETIME".equalsIgnoreCase(t2)) {
            return SQLDataType.OFFSETDATETIME.precision(p);
        }
        if ("OFFSETTIME".equalsIgnoreCase(t2)) {
            return SQLDataType.OFFSETTIME.precision(p);
        }
        if ("LOCALDATE".equalsIgnoreCase(t2)) {
            return SQLDataType.LOCALDATE;
        }
        if ("LOCALDATETIME".equalsIgnoreCase(t2)) {
            return SQLDataType.LOCALDATETIME.precision(p);
        }
        if ("LOCALTIME".equalsIgnoreCase(t2)) {
            return SQLDataType.LOCALTIME.precision(p);
        }
        if (db.getForceIntegerTypesOnZeroScaleDecimals()) {
            return DefaultDataType.getDataType(db.getDialect(), t2, p, s2);
        }
        DataType<?> result = DefaultDataType.getDataType(db.getDialect(), t2);
        if (result.getType() == BigDecimal.class && s2 == 0) {
            DefaultDataType.getDataType(db.getDialect(), BigInteger.class);
        }
        return result;
    }

    public static final DataTypeDefinition mapDefinedType(Definition container, Definition child, DataTypeDefinition definedType, JavaTypeResolver resolver) {
        if (resolver == null) {
            return AbstractTypedElementDefinition.mapDefinedType0(container, child, definedType, resolver);
        }
        return resolver.resolveDefinedType(() -> AbstractTypedElementDefinition.mapDefinedType0(container, child, definedType, resolver));
    }

    static final DataTypeDefinition mapDefinedType0(Definition container, Definition child, DataTypeDefinition definedType, JavaTypeResolver resolver) {
        ForcedType forcedType;
        if (resolver == null) {
            resolver = new DefaultJavaTypeResolver();
        }
        DataTypeDefinition result = definedType;
        Database db = container.getDatabase();
        log.debug((Object)"Type mapping", String.valueOf(child) + " with type " + definedType.getType());
        if (db.dateAsTimestamp()) {
            DataType<?> dataType = null;
            try {
                dataType = AbstractTypedElementDefinition.getDataType(db, result.getType(), 0, 0);
            }
            catch (SQLDialectNotSupportedException sQLDialectNotSupportedException) {
                // empty catch block
            }
            if (dataType != null && SQLDataType.DATE.equals(dataType.getSQLDataType())) {
                DataType<?> forcedDataType = AbstractTypedElementDefinition.getDataType(db, SQLDataType.TIMESTAMP.getTypeName(), 0, 0);
                String binding = DateAsTimestampBinding.class.getName();
                if (db.javaTimeTypes()) {
                    binding = LocalDateAsLocalDateTimeBinding.class.getName();
                }
                result = new DefaultDataTypeDefinition(db, child.getSchema(), forcedDataType.getTypeName(), 0, 0, 0, result.isNullable(), result.getDefaultValue(), result.isIdentity(), null, null, binding, null);
            }
        }
        if ((forcedType = db.getConfiguredForcedType(child, definedType)) != null) {
            CustomType customType;
            int s2;
            int p;
            int l;
            String g2;
            boolean r;
            boolean i;
            String d;
            boolean n;
            Object binding;
            Object converter;
            String generator;
            String name;
            String uType;
            block40: {
                uType = forcedType.getUserType();
                name = forcedType.getName();
                generator = forcedType.getGenerator();
                converter = null;
                binding = result.getBinding();
                n = result.isNullable();
                d = result.getDefaultValue();
                i = result.isIdentity();
                r = result.isReadonly();
                g2 = result.getGeneratedAlwaysAs();
                l = 0;
                p = 0;
                s2 = 0;
                customType = AbstractTypedElementDefinition.customType(db, forcedType);
                if (name != null) {
                    DataType<?> forcedDataType = null;
                    Matcher matcher = LENGTH_PRECISION_SCALE_PATTERN.matcher(name);
                    if (matcher.find()) {
                        if (!StringUtils.isEmpty(matcher.group(1))) {
                            l = p = Convert.convert((Object)matcher.group(1), Integer.TYPE).intValue();
                        } else {
                            p = Convert.convert((Object)matcher.group(2), Integer.TYPE);
                            s2 = Convert.convert((Object)matcher.group(3), Integer.TYPE);
                        }
                    }
                    try {
                        forcedDataType = AbstractTypedElementDefinition.getDataType(db, name, p, s2);
                        if (forcedDataType != null) {
                            result = new DefaultDataTypeDefinition(db, child.getSchema(), name, l, p, s2, n, r, g2, d, i, null, generator, (String)converter, (String)binding, null);
                        }
                    }
                    catch (SQLDialectNotSupportedException e) {
                        if (db.getConfiguredCustomTypes().isEmpty()) break block40;
                        if (customType != null) {
                            db.markUsed(forcedType);
                        }
                        log.warn("Bad configuration for <forcedType/> " + forcedType.getName() + ". No matching <customType/> found, and no matching SQLDataType found: " + String.valueOf(forcedType));
                    }
                }
            }
            if (customType != null) {
                String tType;
                uType = !StringUtils.isBlank(customType.getType()) ? customType.getType() : customType.getName();
                name = customType.getName();
                if (generator == null) {
                    generator = customType.getGenerator();
                }
                if (Boolean.TRUE.equals(customType.isAutoConverter()) || AutoConverter.class.getName().equals(customType.getConverter())) {
                    tType = AbstractTypedElementDefinition.tType(db, resolver, result);
                    converter = resolver.constructorCall(AutoConverter.class.getName() + "<" + resolver.ref(tType) + ", " + resolver.ref(uType) + ">") + "(" + resolver.classLiteral(tType) + ", " + resolver.classLiteral(uType) + ")";
                } else if (Boolean.TRUE.equals(customType.isEnumConverter()) || EnumConverter.class.getName().equals(customType.getConverter())) {
                    tType = AbstractTypedElementDefinition.tType(db, resolver, result);
                    converter = resolver.constructorCall(EnumConverter.class.getName() + "<" + resolver.ref(tType) + ", " + resolver.ref(uType) + ">") + "(" + resolver.classLiteral(tType) + ", " + resolver.classLiteral(uType) + ")";
                } else if (Boolean.TRUE.equals(customType.isXmlConverter()) || XMLtoJAXBConverter.class.getName().equals(customType.getConverter())) {
                    converter = resolver.constructorCall(XMLtoJAXBConverter.class.getName() + "<" + resolver.ref(uType) + ">") + "(" + resolver.classLiteral(uType) + ")";
                } else if (Boolean.TRUE.equals(customType.isJsonConverter())) {
                    converter = AbstractTypedElementDefinition.tType(db, resolver, result).endsWith("JSONB") ? resolver.constructorCall("org.jooq.jackson.extensions.converters.JSONBtoJacksonConverter<" + resolver.ref(uType) + ">") + "(" + resolver.classLiteral(uType) + ")" : resolver.constructorCall("org.jooq.jackson.extensions.converters.JSONtoJacksonConverter<" + resolver.ref(uType) + ">") + "(" + resolver.classLiteral(uType) + ")";
                } else if ("org.jooq.jackson.extensions.converters.JSONtoJacksonConverter".equals(customType.getConverter())) {
                    converter = resolver.constructorCall("org.jooq.jackson.extensions.converters.JSONtoJacksonConverter<" + resolver.ref(uType) + ">") + "(" + resolver.classLiteral(uType) + ")";
                } else if ("org.jooq.jackson.extensions.converters.JSONBtoJacksonConverter".equals(customType.getConverter())) {
                    converter = resolver.constructorCall("org.jooq.jackson.extensions.converters.JSONBtoJacksonConverter<" + resolver.ref(uType) + ">") + "(" + resolver.classLiteral(uType) + ")";
                } else if (customType.getLambdaConverter() != null) {
                    LambdaConverter c = customType.getLambdaConverter();
                    String tType2 = AbstractTypedElementDefinition.tType(db, resolver, result);
                    converter = resolver.ref(Converter.class) + ".of" + (!Boolean.FALSE.equals(c.isNullable()) ? "Nullable" : "") + "(" + resolver.classLiteral(tType2) + ", " + resolver.classLiteral(uType) + ", " + c.getFrom() + ", " + c.getTo() + ")";
                } else if (!StringUtils.isBlank(customType.getConverter())) {
                    if (Boolean.TRUE.equals(customType.isGenericConverter())) {
                        tType = AbstractTypedElementDefinition.tType(db, resolver, result);
                        converter = resolver.constructorCall(customType.getConverter() + "<" + resolver.ref(tType) + ", " + resolver.ref(uType) + ">") + "(" + resolver.classLiteral(tType) + ", " + resolver.classLiteral(uType) + ")";
                    } else {
                        converter = customType.getConverter();
                    }
                }
                if (!StringUtils.isBlank(customType.getBinding())) {
                    if (Boolean.TRUE.equals(customType.isGenericBinding())) {
                        tType = AbstractTypedElementDefinition.tType(db, resolver, result);
                        binding = resolver.constructorCall(customType.getBinding() + "<" + resolver.ref(tType) + ", " + resolver.ref(uType) + ">") + "(" + resolver.classLiteral(tType) + ", " + resolver.classLiteral(uType) + ")";
                    } else {
                        binding = customType.getBinding();
                    }
                }
            }
            if (name != null || uType != null) {
                db.markUsed(forcedType);
                log.info((Object)"Forcing type", String.valueOf(child) + " to " + String.valueOf(forcedType));
                if (customType != null) {
                    l = result.getLength();
                    p = result.getPrecision();
                    s2 = result.getScale();
                    String t2 = result.getType();
                    Name u = result.getQualifiedUserType();
                    result = new DefaultDataTypeDefinition(db, definedType.getSchema(), t2, l, p, s2, n, r, g2, d, i, u, generator, (String)converter, (String)binding, uType);
                }
            }
            if (generator != null) {
                db.markUsed(forcedType);
                ((DefaultDataTypeDefinition)result).generator(generator);
            }
        }
        return result;
    }

    private static final String tType(Database db, JavaTypeResolver resolver, DataTypeDefinition definedType) {
        if (resolver != null) {
            return resolver.resolve(definedType);
        }
        try {
            return AbstractTypedElementDefinition.getDataType(db, definedType.getType(), definedType.getPrecision(), definedType.getScale()).getType().getName();
        }
        catch (SQLDialectNotSupportedException ignore) {
            return Object.class.getName();
        }
    }

    public static final CustomType customType(Database db, ForcedType forcedType) {
        String name = forcedType.getName();
        if (StringUtils.isBlank(forcedType.getUserType())) {
            if (name != null) {
                for (CustomType type : db.getConfiguredCustomTypes()) {
                    if (!name.equals(type.getName())) continue;
                    return type;
                }
            }
        } else {
            return new CustomType().withBinding(forcedType.getBinding()).withGenericBinding(forcedType.isGenericBinding()).withAutoConverter(forcedType.isAutoConverter()).withGenericConverter(forcedType.isGenericConverter()).withEnumConverter(forcedType.isEnumConverter()).withXmlConverter(forcedType.isXmlConverter()).withJsonConverter(forcedType.isJsonConverter()).withLambdaConverter(forcedType.getLambdaConverter()).withVisibilityModifier(forcedType.getVisibilityModifier()).withGenerator(forcedType.getGenerator()).withAuditInsertTimestamp(forcedType.isAuditInsertTimestamp()).withAuditInsertUser(forcedType.isAuditInsertUser()).withAuditUpdateTimestamp(forcedType.isAuditUpdateTimestamp()).withAuditUpdateUser(forcedType.isAuditUpdateUser()).withConverter(forcedType.getConverter()).withName(name).withType(forcedType.getUserType());
        }
        return null;
    }

    @Override
    public final DomainDefinition getDomain() {
        return this.getDatabase().getDomain(this.getSchema(), this.getDefinedType().getQualifiedUserType());
    }
}

