/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import org.jooq.Catalog;
import org.jooq.Condition;
import org.jooq.Configuration;
import org.jooq.ConstraintEnforcementStep;
import org.jooq.DSLContext;
import org.jooq.DataType;
import org.jooq.Field;
import org.jooq.ForeignKey;
import org.jooq.Index;
import org.jooq.Meta;
import org.jooq.Name;
import org.jooq.OrderField;
import org.jooq.Record;
import org.jooq.Result;
import org.jooq.SQLDialect;
import org.jooq.Schema;
import org.jooq.Sequence;
import org.jooq.SortField;
import org.jooq.Table;
import org.jooq.TableField;
import org.jooq.TableOptions;
import org.jooq.UniqueKey;
import org.jooq.conf.ParseUnknownFunctions;
import org.jooq.exception.DataAccessException;
import org.jooq.exception.DataDefinitionException;
import org.jooq.exception.DataTypeException;
import org.jooq.exception.SQLDialectNotSupportedException;
import org.jooq.impl.AbstractKey;
import org.jooq.impl.AbstractMeta;
import org.jooq.impl.AbstractNamed;
import org.jooq.impl.CatalogImpl;
import org.jooq.impl.DSL;
import org.jooq.impl.DefaultDataType;
import org.jooq.impl.FilteredMeta;
import org.jooq.impl.IndexImpl;
import org.jooq.impl.Internal;
import org.jooq.impl.MetaSQL;
import org.jooq.impl.ParserException;
import org.jooq.impl.ReferenceImpl;
import org.jooq.impl.SQLDataType;
import org.jooq.impl.SchemaImpl;
import org.jooq.impl.TableImpl;
import org.jooq.impl.ThrowingBiFunction;
import org.jooq.impl.ThrowingFunction;
import org.jooq.impl.Tools;
import org.jooq.tools.JooqLogger;
import org.jooq.tools.StringUtils;

final class MetaImpl
extends AbstractMeta {
    private static final JooqLogger log = JooqLogger.getLogger(MetaImpl.class);
    private static final Set<SQLDialect> INVERSE_SCHEMA_CATALOG = SQLDialect.supportedBy(SQLDialect.MARIADB, SQLDialect.MYSQL);
    private static final Set<SQLDialect> CURRENT_TIMESTAMP_COLUMN_DEFAULT = SQLDialect.supportedBy(SQLDialect.MARIADB, SQLDialect.MYSQL);
    private static final Set<SQLDialect> EXPRESSION_COLUMN_DEFAULT = SQLDialect.supportedBy(SQLDialect.DERBY, SQLDialect.FIREBIRD, SQLDialect.H2, SQLDialect.HSQLDB, SQLDialect.IGNITE, SQLDialect.MARIADB, SQLDialect.POSTGRES, SQLDialect.SQLITE, SQLDialect.YUGABYTEDB);
    private static final Set<SQLDialect> NO_SUPPORT_SCHEMAS = SQLDialect.supportedBy(SQLDialect.FIREBIRD, SQLDialect.SQLITE);
    private static final Set<SQLDialect> NO_SUPPORT_INDEXES = SQLDialect.supportedBy(SQLDialect.TRINO);
    private static final Pattern P_SYSINDEX_DERBY = Pattern.compile("^(?i:SQL\\d{10,}).*$");
    private static final Pattern P_SYSINDEX_H2 = Pattern.compile("^(?i:PRIMARY_KEY_|UK_INDEX_|FK_INDEX_).*$");
    private static final Pattern P_SYSINDEX_HSQLDB = Pattern.compile("^(?i:SYS_IDX_).*$");
    private static final Pattern P_SYSINDEX_SQLITE = Pattern.compile("^(?i:sqlite_autoindex_).*$");
    private final DatabaseMetaData databaseMetaData;
    private final boolean inverseSchemaCatalog;
    private static final Class<?>[] GET_COLUMNS_SHORT = new Class[]{String.class, String.class, String.class, String.class, Integer.TYPE, String.class, Integer.TYPE, String.class, Integer.TYPE, Integer.TYPE, Integer.TYPE, String.class, String.class};
    private static final Class<?>[] GET_COLUMNS_EXTENDED = new Class[]{String.class, String.class, String.class, String.class, Integer.TYPE, String.class, Integer.TYPE, String.class, Integer.TYPE, Integer.TYPE, Integer.TYPE, String.class, String.class, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, String.class, String.class, String.class, String.class, String.class, String.class};

    MetaImpl(Configuration configuration, DatabaseMetaData databaseMetaData) {
        this(configuration, databaseMetaData, null, null);
    }

    private MetaImpl(Configuration configuration, DatabaseMetaData databaseMetaData, Predicate<? super Catalog> catalogFilter, Predicate<? super Schema> schemaFilter) {
        super(configuration, catalogFilter, schemaFilter);
        this.databaseMetaData = databaseMetaData;
        this.inverseSchemaCatalog = INVERSE_SCHEMA_CATALOG.contains((Object)this.dialect());
    }

    @Override
    final AbstractMeta filtered0(Predicate<? super Catalog> catalogFilter, Predicate<? super Schema> schemaFilter) {
        return new MetaImpl(this.configuration(), this.databaseMetaData, FilteredMeta.and(this.catalogFilter, catalogFilter), FilteredMeta.and(this.schemaFilter, schemaFilter));
    }

    final boolean hasCatalog(Catalog catalog) {
        return catalog != null && !StringUtils.isEmpty(catalog.getName());
    }

    final <R> R catalogSchema(Catalog catalog, Schema schema, ThrowingBiFunction<String, String, R, SQLException> function) throws SQLException {
        return this.catalogSchema(catalog != null ? catalog.getName() : null, schema != null ? schema.getName() : null, function);
    }

    final <R> R catalogSchema(String catalog, String schema, ThrowingBiFunction<String, String, R, SQLException> function) throws SQLException {
        String c = StringUtils.defaultIfEmpty(catalog, null);
        String s2 = StringUtils.defaultIfEmpty(schema, null);
        if (this.inverseSchemaCatalog) {
            return function.apply(s2, c);
        }
        return function.apply(c, s2);
    }

    private final <R> R meta(Supplier<String> errorMessage, ThrowingFunction<DatabaseMetaData, R, SQLException> function) {
        if (this.databaseMetaData == null) {
            return (R)this.dsl().connectionResult(connection -> MetaImpl.meta0(errorMessage, function, connection.getMetaData()));
        }
        return MetaImpl.meta0(errorMessage, function, this.databaseMetaData);
    }

    private static final <R> R meta0(Supplier<String> errorMessage, ThrowingFunction<DatabaseMetaData, R, SQLException> function, DatabaseMetaData databaseMetaData) {
        try {
            return function.apply(databaseMetaData);
        }
        catch (SQLException e) {
            String m4 = errorMessage.get();
            if (StringUtils.isEmpty(m4)) {
                throw new DataAccessException("Error querying DatabaseMetaData", e);
            }
            throw new DataAccessException("Error querying DatabaseMetaData: " + m4, e);
        }
    }

    private static final <T, E extends Exception> T withCatalog(Catalog catalog, DSLContext ctx, ThrowingFunction<DSLContext, T, E> supplier) throws E {
        T t2;
        Object previous = null;
        Exception e = null;
        try {
            t2 = supplier.apply(ctx);
        }
        catch (Exception x) {
            e = x;
            throw x;
        }
        return t2;
    }

    @Override
    final List<Catalog> getCatalogs0() {
        ArrayList<Catalog> result = new ArrayList<Catalog>();
        if (result.isEmpty()) {
            result.add(new MetaCatalog(""));
        }
        return result;
    }

    final Table<?> lookupTable(Schema schema, String tableName) {
        switch (this.family()) {
            case SQLITE: {
                return AbstractNamed.findIgnoreCase(tableName, schema.getTables());
            }
        }
        return schema.getTable(tableName);
    }

    @Override
    final List<Schema> getSchemas0() {
        return Tools.flatMap(this.getCatalogs(), c -> c.getSchemas());
    }

    @Override
    final List<Table<?>> getTables0() {
        return Tools.flatMap(this.getSchemas(), s2 -> s2.getTables());
    }

    @Override
    final List<UniqueKey<?>> getPrimaryKeys0() {
        ArrayList result = new ArrayList();
        for (Table<?> table : this.getTables()) {
            UniqueKey<?> pk = table.getPrimaryKey();
            if (pk == null) continue;
            result.add(pk);
        }
        return result;
    }

    private static final TableOptions tableOption(DSLContext ctx, MetaSchema schema, String tableName, TableOptions.TableType tableType) {
        String sql = MetaSQL.M_SOURCES(ctx.dialect());
        if (sql != null) {
            if (tableType == TableOptions.TableType.MATERIALIZED_VIEW) {
                return TableOptions.materializedView(schema.source(tableType, tableName));
            }
            if (tableType == TableOptions.TableType.VIEW) {
                return TableOptions.view(schema.source(tableType, tableName));
            }
        }
        return TableOptions.of(tableType);
    }

    @Override
    public String toString() {
        return "MetaImpl";
    }

    private final class MetaCatalog
    extends CatalogImpl {
        MetaCatalog(String name) {
            super(name);
        }

        @Override
        public final List<Schema> getSchemas() {
            ArrayList<Schema> result = new ArrayList<Schema>();
            boolean empty = false;
            if (!MetaImpl.this.inverseSchemaCatalog) {
                Schemas schemas = MetaImpl.this.meta(() -> "Error while fetching schemas for catalog: " + String.valueOf(this), meta -> new Schemas(MetaImpl.this.dsl().fetch(meta.getSchemas(), SQLDataType.VARCHAR), false));
                for (String name : schemas.schemas().getValues(0, String.class)) {
                    result.add(new MetaSchema(name, this, false));
                }
                empty = schemas.empty();
            } else {
                Result schemas = MetaImpl.this.meta(() -> "Error while fetching catalogs", meta -> MetaImpl.this.dsl().fetch(meta.getCatalogs(), SQLDataType.VARCHAR));
                for (String name : schemas.getValues(0, String.class)) {
                    result.add(new MetaSchema(name, this, false));
                }
            }
            if (result.isEmpty()) {
                result.add(new MetaSchema("", this, empty));
            }
            return result;
        }
    }

    private final class MetaSchema
    extends SchemaImpl {
        private final boolean empty;
        private volatile transient Map<Name, Result<Record>> columnCache;
        private volatile transient Map<Name, Result<Record>> ukCache;
        private volatile transient Map<Name, Result<Record>> sequenceCache;
        private volatile transient Map<Name, String> sourceCache;
        private volatile transient Map<Name, String> commentCache;

        MetaSchema(String name, Catalog catalog, boolean empty) {
            super(name, catalog);
            this.empty = empty;
        }

        @Override
        public final synchronized List<Table<?>> getTables() {
            if (this.empty) {
                return Collections.emptyList();
            }
            Result tables = MetaImpl.this.meta(() -> "Error while fetching tables for schema: " + String.valueOf(this), meta -> {
                String[] types = switch (MetaImpl.this.family()) {
                    case SQLDialect.POSTGRES, SQLDialect.YUGABYTEDB -> new String[]{"FOREIGN TABLE", "MATERIALIZED VIEW", "PARTITIONED TABLE", "SYSTEM_TABLE", "SYSTEM TABLE", "SYSTEM_VIEW", "SYSTEM VIEW", "TABLE", "TEMPORARY TABLE", "TEMPORARY VIEW", "VIEW"};
                    case SQLDialect.SQLITE -> new String[]{"TABLE", "VIEW"};
                    default -> null;
                };
                try (ResultSet rs = MetaImpl.this.catalogSchema(this.getCatalog(), this, (c, s2) -> meta.getTables((String)c, (String)s2, "%", types));){
                    Result<Record> result = MetaImpl.this.dsl().fetch(rs, SQLDataType.VARCHAR, SQLDataType.VARCHAR, SQLDataType.VARCHAR, SQLDataType.VARCHAR, SQLDataType.VARCHAR);
                    return result;
                }
            });
            return Tools.map(tables, table -> {
                String catalog = table.get(0, String.class);
                String schema = table.get(1, String.class);
                String name = table.get(2, String.class);
                String type = table.get(3, String.class);
                String remarks = table.get(4, String.class);
                TableOptions.TableType tableType = "VIEW".equals(type) ? TableOptions.TableType.VIEW : ("TEMPORARY VIEW".equals(type) ? TableOptions.TableType.VIEW : ("SYSTEM_VIEW".equals(type) || "SYSTEM VIEW".equals(type) ? TableOptions.TableType.VIEW : ("GLOBAL TEMPORARY".equals(type) ? TableOptions.TableType.TEMPORARY : ("LOCAL TEMPORARY".equals(type) ? TableOptions.TableType.TEMPORARY : ("TEMPORARY".equals(type) ? TableOptions.TableType.TEMPORARY : ("MATERIALIZED VIEW".equals(type) ? TableOptions.TableType.MATERIALIZED_VIEW : TableOptions.TableType.TABLE))))));
                switch (MetaImpl.this.dsl().family()) {
                    case MYSQL: 
                    case MARIADB: {
                        if (tableType != TableOptions.TableType.VIEW) break;
                        remarks = null;
                    }
                }
                return new MetaTable(name, this, this.getColumns(catalog, schema, name), this.getUks(catalog, schema, name), remarks, tableType);
            });
        }

        private final Result<Record> getUks(String catalog, String schema, String table) {
            if (this.ukCache == null) {
                if (MetaImpl.this.family() == SQLDialect.SQLITE) {
                    this.initUksSQLite(catalog, schema);
                } else {
                    this.initUks(catalog, schema);
                }
            }
            if (this.ukCache != null) {
                return this.ukCache.get(DSL.name(catalog, schema, table));
            }
            return null;
        }

        private final void initUks(String catalog, String schema) {
            this.init0(c -> {
                this.ukCache = c;
            }, () -> this.ukCache, catalog, schema, MetaSQL::M_UNIQUE_KEYS, r -> r.field(0), r -> r.field(1), r -> r.field(2));
        }

        private final void init0(Consumer<? super Map<Name, Result<Record>>> cacheInit, Supplier<? extends Map<Name, Result<Record>>> cache, String catalog, String schema, Function<? super SQLDialect, ? extends String> sqlF, Function<? super Result<?>, ? extends Field<?>> objectCatalog, Function<? super Result<?>, ? extends Field<?>> objectSchema, Function<? super Result<?>, ? extends Field<?>> objectName) {
            String sql = sqlF.apply(MetaImpl.this.dialect());
            if (sql != null) {
                Result result = MetaImpl.this.meta(() -> "", meta -> MetaImpl.withCatalog(DSL.catalog(catalog), DSL.using(meta.getConnection(), MetaImpl.this.dialect()), ctx -> {
                    Object[] objectArray;
                    if (NO_SUPPORT_SCHEMAS.contains((Object)MetaImpl.this.dialect())) {
                        objectArray = Tools.EMPTY_OBJECT;
                    } else if (MetaImpl.this.inverseSchemaCatalog) {
                        Object[] objectArray2 = new Object[1];
                        objectArray = objectArray2;
                        objectArray2[0] = catalog;
                    } else {
                        Object[] objectArray3 = new Object[1];
                        objectArray = objectArray3;
                        objectArray3[0] = schema;
                    }
                    return ctx.resultQuery(sql, objectArray).fetch();
                }));
                Map groups = result.intoGroups(new Field[]{objectCatalog.apply(result), objectSchema.apply(result), objectName.apply(result)});
                cacheInit.accept(new LinkedHashMap());
                groups.forEach((k, v) -> ((Map)cache.get()).put(DSL.name(catalog == null ? null : k.get(0, String.class), k.get(1, String.class), k.get(2, String.class)), v));
            }
        }

        private final void initUksSQLite(String catalog, String schema) {
            this.ukCache = new LinkedHashMap<Name, Result<Record>>();
            Map<String, String> tables = MetaImpl.this.dsl().resultQuery("select m.tbl_name, m.sql\nfrom sqlite_master as m\nwhere m.type = 'table'\nand exists (\n  select 1\n  from pragma_index_list(m.name) as il\n  where il.origin = 'u'\n)\norder by m.tbl_name\n").fetchMap(DSL.field("tbl_name", SQLDataType.VARCHAR), DSL.field("sql", SQLDataType.VARCHAR));
            StringBuilder sb = new StringBuilder();
            for (String sql2 : tables.values()) {
                sb.append(sql2).append(';');
            }
            Meta m4 = null;
            try {
                m4 = MetaImpl.this.dsl().configuration().deriveSettings(s2 -> s2.withInterpreterDelayForeignKeyDeclarations(true)).dsl().meta(sb.toString());
            }
            catch (DataDefinitionException | ParserException e) {
                log.info((Object)("Cannot parse or interpret sql: " + sb.toString()), e);
            }
            Meta meta = m4;
            tables.forEach((table, sql) -> {
                try {
                    Field<String> fCatalogName = DSL.field("catalog_name", SQLDataType.VARCHAR);
                    Field<String> fSchemaName = DSL.field("schema_name", SQLDataType.VARCHAR);
                    Field<String> fTableName = DSL.field("table_name", SQLDataType.VARCHAR);
                    Field<String> fConstraintName = DSL.field("constraint_name", SQLDataType.VARCHAR);
                    Field<String> fColumnName = DSL.field("column_name", SQLDataType.VARCHAR);
                    Field<Integer> fSequenceNo = DSL.field("sequence_no", SQLDataType.INTEGER);
                    Field[] fields2 = new Field[]{fCatalogName, fSchemaName, fTableName, fConstraintName, fColumnName, fSequenceNo};
                    for (Table<?> t2 : (meta != null ? meta : MetaImpl.this.dsl().meta((String)sql)).getTables((String)table)) {
                        Result<Record> result = MetaImpl.this.dsl().newResult(fields2);
                        int keyNo = 0;
                        for (UniqueKey<?> uk : t2.getUniqueKeys()) {
                            int colNo = 0;
                            String ukName = StringUtils.isEmpty(uk.getName()) ? "uk_" + table + "_" + ++keyNo + "_" + Internal.hash(DSL.row(uk.getFields())) : uk.getName();
                            for (Field field : uk.getFields()) {
                                result.add(MetaImpl.this.dsl().newRecord(fCatalogName, fSchemaName, fTableName, fConstraintName, fColumnName, fSequenceNo).values(catalog, schema, (String)table, ukName, field.getName(), colNo++));
                            }
                        }
                        this.ukCache.put(DSL.name(catalog, schema, table), result);
                    }
                }
                catch (DataDefinitionException | ParserException e) {
                    log.info((Object)("Cannot parse or interpret sql for table " + table + ": " + sql), e);
                }
            });
        }

        private final Result<Record> getColumns(String catalog, String schema, String table) {
            if (this.columnCache == null && MetaImpl.this.family() != SQLDialect.SQLITE) {
                Result<Record> columns = this.getColumns0(catalog, schema, "%");
                Field<?> tableCat = columns.field(0);
                Field<?> tableSchem = columns.field(1);
                Field<?> tableName = columns.field(2);
                Map<Record, Result<Record>> groups = columns.intoGroups(new Field[]{tableCat, tableSchem, tableName});
                this.columnCache = new LinkedHashMap<Name, Result<Record>>();
                groups.forEach((k, v) -> this.columnCache.put(DSL.name((String)k.get(tableCat), (String)k.get(tableSchem), (String)k.get(tableName)), (Result<Record>)v));
            }
            if (this.columnCache != null) {
                return this.columnCache.get(DSL.name(catalog, schema, table));
            }
            return this.getColumns0(catalog, schema, table);
        }

        private final Result<Record> getColumns0(String catalog, String schema, String table) {
            return MetaImpl.this.meta(() -> "Error while fetching columns for table " + table + " in schema " + String.valueOf(this), meta -> {
                try (ResultSet rs = MetaImpl.this.catalogSchema(catalog, schema, (c, s2) -> meta.getColumns((String)c, (String)s2, table, "%"));){
                    Result<Record> result = rs.getMetaData().getColumnCount() < GET_COLUMNS_EXTENDED.length ? MetaImpl.this.dsl().fetch(rs, GET_COLUMNS_SHORT) : MetaImpl.this.dsl().fetch(rs, GET_COLUMNS_EXTENDED);
                    return result;
                }
            });
        }

        @Override
        public List<Sequence<?>> getSequences() {
            if (this.empty) {
                return Collections.emptyList();
            }
            Result<Record> result = this.getSequences0();
            return result != null ? Tools.map(result, r -> Internal.createSequence(r.get(2, String.class), this, DefaultDataType.getDataType(MetaImpl.this.family(), r.get(3, String.class), r.get(4, Integer.TYPE), r.get(5, Integer.TYPE), !Boolean.FALSE.equals(MetaImpl.this.settings().isForceIntegerTypesOnZeroScaleDecimals())), r.get(6, Long.class), r.get(7, Long.class), r.get(8, Long.class), r.get(9, Long.class), r.get(10, Boolean.TYPE), r.get(11, Long.class))) : new ArrayList();
        }

        private final Result<Record> getSequences0() {
            if (this.sequenceCache == null) {
                String sql;
                String string = sql = Boolean.TRUE.equals(MetaImpl.this.settings().isMetaIncludeSystemSequences()) ? MetaSQL.M_SEQUENCES_INCLUDING_SYSTEM_SEQUENCES(MetaImpl.this.dialect()) : MetaSQL.M_SEQUENCES(MetaImpl.this.dialect());
                if (sql != null) {
                    Result result = MetaImpl.this.meta(() -> "Error while fetching sequences for schema: " + String.valueOf(this), meta -> DSL.using(meta.getConnection(), MetaImpl.this.dialect()).resultQuery(sql, this.getName()).fetch());
                    Map groups = result.intoGroups(new Field[]{result.field(0), result.field(1)});
                    this.sequenceCache = new LinkedHashMap<Name, Result<Record>>();
                    groups.forEach((k, v) -> this.sequenceCache.put(DSL.name(k.get(0, String.class), k.get(1, String.class)), (Result<Record>)v));
                }
            }
            if (this.sequenceCache != null) {
                return this.sequenceCache.get(DSL.name(this.getCatalog().getName(), this.getName()));
            }
            return null;
        }

        final String source(TableOptions.TableType type, String tableName) {
            String sql;
            if (this.sourceCache == null && (sql = MetaSQL.M_SOURCES(MetaImpl.this.dialect())) != null) {
                Result result = MetaImpl.this.meta(() -> "Error while fetching sources for schema " + String.valueOf(this), meta -> MetaImpl.withCatalog(this.getCatalog(), DSL.using(meta.getConnection(), MetaImpl.this.dialect()), ctx -> ctx.resultQuery(this.patchSchema(sql), this.getName()).fetch()));
                Map groups = result.intoGroups(new Field[]{result.field(0), result.field(1), result.field(2)});
                this.sourceCache = new LinkedHashMap<Name, String>();
                groups.forEach((k, v) -> this.sourceCache.put(DSL.name(k.get(1, String.class), k.get(2, String.class)), Tools.apply(((Record)v.get(0)).get(3, String.class), s2 -> s2.toLowerCase().startsWith("create") ? s2 : (type == TableOptions.TableType.VIEW ? "create view " : "create materialized view ") + MetaImpl.this.dsl().render(DSL.name(k.get(2, String.class))) + " as " + s2)));
            }
            if (this.sourceCache != null) {
                return this.sourceCache.get(DSL.name(this.getName(), tableName));
            }
            return null;
        }

        final String comment(String tableName) {
            return this.comment(tableName, null);
        }

        final String comment(String tableName, String columnName) {
            String sql;
            if (this.commentCache == null && (sql = MetaSQL.M_COMMENTS(MetaImpl.this.dialect())) != null) {
                Result result = MetaImpl.this.meta(() -> "Error while fetching comments for schema: " + String.valueOf(this), meta -> MetaImpl.withCatalog(this.getCatalog(), DSL.using(meta.getConnection(), MetaImpl.this.dialect()), ctx -> ctx.resultQuery(sql, this.getName()).fetch()));
                Map groups = result.intoGroups(new Field[]{result.field(0), result.field(1), result.field(2), result.field(3)});
                this.commentCache = new LinkedHashMap<Name, String>();
                groups.forEach((k, v) -> this.commentCache.put(DSL.name(k.get(1, String.class), k.get(2, String.class), k.get(3, String.class)), ((Record)v.get(0)).get(4, String.class)));
            }
            if (this.commentCache != null) {
                return this.commentCache.get(DSL.name(this.getName(), tableName, columnName));
            }
            return null;
        }

        private final String patchSchema(String sql) {
            return sql;
        }
    }

    private final class MetaUniqueKey
    extends AbstractKey<Record>
    implements UniqueKey<Record> {
        private final boolean isPrimary;

        MetaUniqueKey(Table<Record> table, String name, TableField<Record, ?>[] fields2, boolean isPrimary) {
            super(table, name == null ? null : DSL.name(name), fields2, true);
            this.isPrimary = isPrimary;
        }

        @Override
        public final boolean isPrimary() {
            return this.isPrimary;
        }

        @Override
        public final List<ForeignKey<?, Record>> getReferences() {
            Result result = MetaImpl.this.meta(() -> "Error while fetching references for unique key: " + String.valueOf(this), meta -> {
                try (ResultSet rs = MetaImpl.this.catalogSchema(this.getTable().getCatalog(), this.getTable().getSchema(), (c, s2) -> meta.getExportedKeys((String)c, (String)s2, this.getTable().getName()));){
                    Result<Record> result = MetaImpl.this.dsl().fetch(rs, String.class, String.class, String.class, String.class, String.class, String.class, String.class, String.class, Short.class, Short.class, Short.class, String.class, String.class);
                    return result;
                }
            });
            Map groups = result.intoGroups(new Field[]{result.field(MetaImpl.this.inverseSchemaCatalog ? 5 : 4), result.field(MetaImpl.this.inverseSchemaCatalog ? 4 : 5), result.field(6), result.field(11), result.field(12)});
            HashMap<String, Schema> schemas = new HashMap<String, Schema>();
            for (Schema schema : MetaImpl.this.getSchemas()) {
                schemas.put(schema.getName(), schema);
            }
            ArrayList references = new ArrayList(groups.size());
            groups.forEach((k, v) -> {
                Schema schema = (Schema)schemas.get(StringUtils.defaultString(k.get(1, String.class)));
                Table<?> fkTable = MetaImpl.this.lookupTable(schema, k.get(2, String.class));
                references.add(new ReferenceImpl(fkTable, DSL.name(k.get(3, String.class)), Tools.map(v, f -> (TableField)fkTable.field(f.get(7, String.class)), TableField[]::new), this, Tools.map(v, f -> (TableField)this.getTable().field(f.get(3, String.class)), TableField[]::new), true));
            });
            return references;
        }

        @Override
        final ConstraintEnforcementStep constraint0() {
            if (this.isPrimary()) {
                return DSL.constraint(this.getName()).primaryKey(this.getFieldsArray());
            }
            return DSL.constraint(this.getName()).unique(this.getFieldsArray());
        }
    }

    private final class MetaTable
    extends TableImpl<Record> {
        private final MetaSchema schema;
        private final Result<Record> uks;

        MetaTable(String name, MetaSchema schema, Result<Record> columns, Result<Record> uks, String remarks, TableOptions.TableType tableType) {
            super(DSL.name(name), schema, null, null, null, null, null, DSL.comment(remarks != null ? remarks : schema.comment(name, null)), MetaImpl.tableOption(MetaImpl.this.dsl(), schema, name, tableType), null);
            this.schema = schema;
            this.uks = uks;
            if (columns != null) {
                this.initColumns(columns);
            }
        }

        @Override
        public final List<Index> getIndexes() {
            if (NO_SUPPORT_INDEXES.contains((Object)MetaImpl.this.dsl().dialect())) {
                return Collections.emptyList();
            }
            return Tools.ignoreNPE(() -> {
                Result<Record> result = this.removeSystemIndexes(MetaImpl.this.meta(() -> "Error while fetching indexes for table: " + String.valueOf(this), meta -> {
                    Result<Record> result;
                    block8: {
                        String tableName = this.getName();
                        ResultSet rs = MetaImpl.this.catalogSchema(this.getCatalog(), this.getSchema(), (c, s2) -> meta.getIndexInfo((String)c, (String)s2, tableName, false, true));
                        try {
                            result = MetaImpl.this.dsl().fetch(rs, String.class, String.class, String.class, Boolean.TYPE, String.class, String.class, Integer.TYPE, Integer.TYPE, String.class, String.class, Long.TYPE, Long.TYPE, String.class);
                            if (rs == null) break block8;
                        }
                        catch (Throwable throwable) {
                            try {
                                if (rs != null) {
                                    try {
                                        rs.close();
                                    }
                                    catch (Throwable throwable2) {
                                        throwable.addSuppressed(throwable2);
                                    }
                                }
                                throw throwable;
                            }
                            catch (SQLFeatureNotSupportedException e) {
                                log.debug((Object)("Cannot call DatabaseMetaData::getIndexInfo for table " + String.valueOf(this)), e);
                                return MetaImpl.this.dsl().newResult(Arrays.asList(DSL.field("TABLE_CAT", SQLDataType.VARCHAR), DSL.field("TABLE_SCHEM", SQLDataType.VARCHAR), DSL.field("TABLE_NAME", SQLDataType.VARCHAR), DSL.field("NON_UNIQUE", SQLDataType.BOOLEAN), DSL.field("INDEX_QUALIFIER", SQLDataType.VARCHAR), DSL.field("INDEX_NAME", SQLDataType.VARCHAR), DSL.field("TYPE", SQLDataType.INTEGER), DSL.field("ORDINAL_POSITION", SQLDataType.INTEGER), DSL.field("COLUMN_NAME", SQLDataType.SMALLINT), DSL.field("ASC_OR_DESC", SQLDataType.SMALLINT), DSL.field("CARDINALITY", SQLDataType.BIGINT), DSL.field("PAGES", SQLDataType.BIGINT), DSL.field("FILTER_CONDITION", SQLDataType.VARCHAR)));
                            }
                        }
                        rs.close();
                    }
                    return result;
                }));
                result.sortAsc(7).sortAsc(5);
                return this.createIndexes(result);
            }, () -> Collections.emptyList());
        }

        private final Result<Record> removeSystemIndexes(Result<Record> result) {
            if (Boolean.TRUE.equals(MetaImpl.this.settings().isMetaIncludeSystemIndexes())) {
                return result;
            }
            HashSet<String> constraints = new HashSet<String>();
            for (UniqueKey uniqueKey : this.getKeys()) {
                constraints.add(uniqueKey.getName());
            }
            for (ForeignKey foreignKey : this.getReferences()) {
                constraints.add(foreignKey.getName());
            }
            Iterator it = result.iterator();
            while (it.hasNext()) {
                String string = ((Record)it.next()).get(5, String.class);
                if (constraints.contains(string)) {
                    it.remove();
                    continue;
                }
                switch (MetaImpl.this.family()) {
                    case DERBY: {
                        if (!P_SYSINDEX_DERBY.matcher(string).matches()) break;
                        it.remove();
                        break;
                    }
                    case H2: {
                        if (!P_SYSINDEX_H2.matcher(string).matches()) break;
                        it.remove();
                        break;
                    }
                    case HSQLDB: {
                        if (!P_SYSINDEX_HSQLDB.matcher(string).matches()) break;
                        it.remove();
                        break;
                    }
                    case SQLITE: {
                        if (!P_SYSINDEX_SQLITE.matcher(string).matches()) break;
                        it.remove();
                    }
                }
            }
            return result;
        }

        @Override
        public final List<UniqueKey<Record>> getUniqueKeys() {
            ArrayList<UniqueKey<Record>> result = new ArrayList<UniqueKey<Record>>();
            if (this.uks != null) {
                Map<?, Result<Record>> groups = this.uks.intoGroups(this.uks.field(3));
                groups.forEach((k, v) -> {
                    v.sortAsc(5);
                    UniqueKey<Record> key = this.createUniqueKey((Result<Record>)v, 4, 3, false);
                    if (key != null) {
                        result.add(key);
                    }
                });
            }
            return result;
        }

        @Override
        public final UniqueKey<Record> getPrimaryKey() {
            Result result = MetaImpl.this.meta(() -> "Error while fetching primary key for table: " + String.valueOf(this), meta -> {
                try (ResultSet rs = MetaImpl.this.catalogSchema(this.getCatalog(), this.getSchema(), (c, s2) -> meta.getPrimaryKeys((String)c, (String)s2, this.getName()));){
                    Result<Record> result = MetaImpl.this.dsl().fetch(rs, String.class, String.class, String.class, String.class, Integer.TYPE, String.class);
                    return result;
                }
            });
            result.sortAsc(4);
            return this.createUniqueKey(result, 3, 5, true);
        }

        @Override
        public final List<ForeignKey<Record, ?>> getReferences() {
            Result result = MetaImpl.this.meta(() -> "Error while fetching references for table: " + String.valueOf(this), meta -> {
                Result<Record> result;
                block8: {
                    ResultSet rs = MetaImpl.this.catalogSchema(this.getCatalog(), this.getSchema(), (c, s2) -> meta.getImportedKeys((String)c, (String)s2, this.getName()));
                    try {
                        result = MetaImpl.this.dsl().fetch(rs, String.class, String.class, String.class, String.class, String.class, String.class, String.class, String.class, Short.class, Short.class, Short.class, String.class, String.class);
                        if (rs == null) break block8;
                    }
                    catch (Throwable throwable) {
                        try {
                            if (rs != null) {
                                try {
                                    rs.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        catch (SQLFeatureNotSupportedException e) {
                            log.debug((Object)("Cannot call DatabaseMetaData::getImportedKeys for table " + String.valueOf(this)), e);
                            return MetaImpl.this.dsl().newResult(Arrays.asList(DSL.field("PKTABLE_CAT", SQLDataType.VARCHAR), DSL.field("PKTABLE_SCHEM", SQLDataType.VARCHAR), DSL.field("PKTABLE_NAME", SQLDataType.VARCHAR), DSL.field("PKCOLUMN_NAME", SQLDataType.VARCHAR), DSL.field("FKTABLE_CAT", SQLDataType.VARCHAR), DSL.field("FKTABLE_SCHEM", SQLDataType.VARCHAR), DSL.field("FKTABLE_NAME", SQLDataType.VARCHAR), DSL.field("FKCOLUMN_NAME", SQLDataType.VARCHAR), DSL.field("KEY_SEQ", SQLDataType.SMALLINT), DSL.field("UPDATE_RULE", SQLDataType.SMALLINT), DSL.field("DELETE_RULE", SQLDataType.SMALLINT), DSL.field("FK_NAME", SQLDataType.VARCHAR), DSL.field("PK_NAME", SQLDataType.VARCHAR)));
                        }
                    }
                    rs.close();
                }
                return result;
            });
            Map groups = result.intoGroups(new Field[]{result.field(MetaImpl.this.inverseSchemaCatalog ? 1 : 0), result.field(MetaImpl.this.inverseSchemaCatalog ? 0 : 1), result.field(2), result.field(11), result.field(12)});
            HashMap<Name, Schema> schemas = new HashMap<Name, Schema>();
            for (Schema s2 : MetaImpl.this.getSchemas()) {
                schemas.put(s2.getQualifiedName(), s2);
            }
            ArrayList references = new ArrayList(groups.size());
            groups.forEach((k, v) -> {
                Table<Record> pkTable;
                Schema s2 = (Schema)schemas.get(MetaImpl.this.hasCatalog(this.getCatalog()) ? DSL.name(StringUtils.defaultString(k.get(0, String.class)), StringUtils.defaultString(k.get(1, String.class))) : DSL.name(StringUtils.defaultString(k.get(1, String.class))));
                if (s2 != null && (pkTable = MetaImpl.this.lookupTable(s2, k.get(2, String.class))) != null) {
                    String fkName = k.get(3, String.class);
                    String pkName = k.get(4, String.class);
                    TableField[] pkFields = new TableField[v.size()];
                    TableField[] fkFields = new TableField[v.size()];
                    for (int i = 0; i < v.size(); ++i) {
                        Record record = (Record)v.get(i);
                        String pkFieldName = record.get(3, String.class);
                        String fkFieldName = record.get(7, String.class);
                        pkFields[i] = (TableField)pkTable.field(pkFieldName);
                        fkFields[i] = (TableField)this.field(fkFieldName);
                        if (pkFields[i] == null && (pkFields[i] = this.lookup(pkTable, pkFieldName)) == null) {
                            return;
                        }
                        if (fkFields[i] != null || (fkFields[i] = this.lookup(this, fkFieldName)) != null) continue;
                        return;
                    }
                    references.add(new ReferenceImpl<Record, Record>(this, DSL.name(fkName), fkFields, new MetaUniqueKey(pkTable, pkName, pkFields, true), pkFields, true));
                }
            });
            return references;
        }

        private final TableField<Record, ?> lookup(Table<?> table, String fieldName) {
            for (Field<?> field : table.fields()) {
                if (!field.getName().equalsIgnoreCase(fieldName)) continue;
                return (TableField)field;
            }
            log.info("Could not look up key field : " + fieldName + " in table : " + String.valueOf(table));
            return null;
        }

        private final UniqueKey<Record> createUniqueKey(Result<Record> result, int columnName, int keyName, boolean isPrimary) {
            if (result.size() > 0) {
                TableField[] f = new TableField[result.size()];
                for (int i = 0; i < f.length; ++i) {
                    String name = ((Record)result.get(i)).get(columnName, String.class);
                    f[i] = (TableField)this.field(name);
                    if (f[i] == null && MetaImpl.this.family() == SQLDialect.SQLITE) {
                        for (Field<?> field : this.fields()) {
                            if (!field.getName().equalsIgnoreCase(name)) continue;
                            f[i] = (TableField)field;
                        }
                    }
                    if (f[i] != null) continue;
                    log.info("Cannot look up unique key column " + name + " in table: " + String.valueOf(this) + ". Consider reporting https://jooq.org/bug");
                    return null;
                }
                String indexName = ((Record)result.get(0)).get(keyName, String.class);
                return new MetaUniqueKey(this, indexName, f, isPrimary);
            }
            return null;
        }

        private final List<Index> createIndexes(Result<Record> result) {
            ArrayList<Index> indexes = new ArrayList<Index>();
            ArrayList<SortField<Object>> sortFields = new ArrayList<SortField<Object>>();
            String previousIndexName = null;
            Name name = null;
            Condition where = null;
            boolean unique = false;
            for (int i = 0; i < result.size(); ++i) {
                boolean desc;
                String columnName;
                Field<Object> field;
                Record record = (Record)result.get(i);
                String indexName = record.get(5, String.class);
                if (indexName == null) continue;
                if (!indexName.equals(previousIndexName)) {
                    previousIndexName = indexName;
                    sortFields.clear();
                    name = DSL.name(record.get(0, String.class), record.get(1, String.class), indexName);
                    String filter = record.get(12, String.class);
                    where = !StringUtils.isBlank(filter) ? DSL.condition(filter) : null;
                    boolean bl = unique = record.get(3, Boolean.TYPE) == false;
                }
                if ((field = this.field(columnName = record.get(8, String.class))) == null) {
                    field = DSL.field(columnName);
                }
                sortFields.add((desc = "D".equalsIgnoreCase(record.get(9, String.class))) ? field.desc() : field.asc());
                if (i + 1 != result.size() && ((Record)result.get(i + 1)).get(5, String.class).equals(previousIndexName)) continue;
                indexes.add(new IndexImpl(name, this, (OrderField[])sortFields.toArray(Tools.EMPTY_SORTFIELD), where, unique));
            }
            return indexes;
        }

        private final void initColumns(Result<Record> columns) {
            boolean hasAutoIncrement = false;
            for (Record column : columns) {
                DataType<Object> type;
                String columnName = column.get(3, String.class);
                String typeName = column.get(5, String.class);
                int precision = column.get(6, Integer.TYPE);
                int scale = column.get(8, Integer.TYPE);
                int nullable = column.get(10, Integer.TYPE);
                String remarks = column.get(11, String.class);
                String defaultValue = column.get(12, String.class);
                if ("null".equalsIgnoreCase(defaultValue)) {
                    defaultValue = null;
                }
                boolean isAutoIncrement = column.size() >= 23 ? column.get(22, Boolean.TYPE) : false;
                switch (MetaImpl.this.family()) {
                    case DERBY: {
                        if (defaultValue == null || !defaultValue.toUpperCase().startsWith("GENERATED ALWAYS AS")) break;
                        defaultValue = null;
                    }
                }
                try {
                    type = DefaultDataType.getDataType(MetaImpl.this.family(), typeName, precision, scale, !Boolean.FALSE.equals(MetaImpl.this.settings().isForceIntegerTypesOnZeroScaleDecimals()));
                }
                catch (SQLDialectNotSupportedException e) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"Unknown type", "Registering unknown data type: " + typeName + " for column " + columnName + " of table " + String.valueOf(this));
                    }
                    type = new DefaultDataType<Object>(MetaImpl.this.family(), Object.class, typeName);
                }
                if (isAutoIncrement) {
                    if (!hasAutoIncrement) {
                        hasAutoIncrement = isAutoIncrement;
                        type = type.identity(hasAutoIncrement);
                    } else {
                        log.info((Object)"Multiple identities", "jOOQ does not support tables with multiple identities. Identity is ignored on column " + columnName + " of table " + String.valueOf(this));
                    }
                }
                if (nullable == 0) {
                    type = type.nullable(false);
                }
                if (!isAutoIncrement && !StringUtils.isEmpty(defaultValue)) {
                    try {
                        if (EXPRESSION_COLUMN_DEFAULT.contains((Object)MetaImpl.this.dialect())) {
                            if (Boolean.FALSE.equals(MetaImpl.this.settings().isParseMetaDefaultExpressions())) {
                                type = type.defaultValue(DSL.field(defaultValue, type));
                            } else {
                                try {
                                    DSLContext ctx = MetaImpl.this.dsl().configuration().deriveSettings(s2 -> s2.withParseDialect(MetaImpl.this.dialect()).withParseUnknownFunctions(ParseUnknownFunctions.IGNORE)).dsl();
                                    type = type.defaultValue(ctx.parser().parseField(defaultValue));
                                }
                                catch (ParserException e) {
                                    log.info((Object)("Cannot parse default expression (to skip parsing, use Settings.parseMetaViewDefaultExpressions): " + defaultValue + " of column " + columnName + " in table " + String.valueOf(this)), e);
                                    type = type.defaultValue(DSL.field(defaultValue, type));
                                }
                            }
                        } else {
                            type = CURRENT_TIMESTAMP_COLUMN_DEFAULT.contains((Object)MetaImpl.this.dialect()) && "CURRENT_TIMESTAMP".equalsIgnoreCase(defaultValue) ? type.defaultValue(DSL.field(defaultValue, type)) : type.defaultValue(DSL.inline((Object)defaultValue, type));
                        }
                    }
                    catch (DataTypeException e) {
                        log.warn("Default value", "Could not load default value: " + defaultValue + " for type: " + String.valueOf(type) + " of column " + columnName + " in table " + String.valueOf(this), e);
                    }
                }
                MetaTable.createField(DSL.name(columnName), type, this, remarks != null ? remarks : this.schema.comment(this.getName(), columnName));
            }
        }
    }

    private record Schemas(Result<Record> schemas, boolean empty) {
    }
}

