/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jooq.Clause;
import org.jooq.Condition;
import org.jooq.Context;
import org.jooq.Field;
import org.jooq.ForeignKey;
import org.jooq.JoinType;
import org.jooq.Keyword;
import org.jooq.Name;
import org.jooq.Operator;
import org.jooq.QueryPart;
import org.jooq.Record;
import org.jooq.SQLDialect;
import org.jooq.Table;
import org.jooq.TableField;
import org.jooq.TableLike;
import org.jooq.TableOptions;
import org.jooq.conf.RenderOptionalKeyword;
import org.jooq.exception.DataAccessException;
import org.jooq.impl.AbstractJoinTable;
import org.jooq.impl.Alias;
import org.jooq.impl.ConditionProviderImpl;
import org.jooq.impl.CrossApply;
import org.jooq.impl.DSL;
import org.jooq.impl.FieldsImpl;
import org.jooq.impl.Keywords;
import org.jooq.impl.Names;
import org.jooq.impl.OuterApply;
import org.jooq.impl.QOM;
import org.jooq.impl.QueryPartList;
import org.jooq.impl.QueryPartListView;
import org.jooq.impl.RecordImplN;
import org.jooq.impl.TableAlias;
import org.jooq.impl.TableImpl;
import org.jooq.impl.Tools;

abstract class JoinTable<J extends JoinTable<J>>
extends AbstractJoinTable<J> {
    static final Clause[] CLAUSES = new Clause[]{Clause.TABLE, Clause.TABLE_JOIN};
    static final Set<SQLDialect> EMULATE_NATURAL_JOIN = SQLDialect.supportedBy(SQLDialect.CUBRID, SQLDialect.TRINO);
    static final Set<SQLDialect> EMULATE_NATURAL_OUTER_JOIN = SQLDialect.supportedBy(SQLDialect.CUBRID, SQLDialect.H2, SQLDialect.IGNITE, SQLDialect.TRINO);
    static final Set<SQLDialect> EMULATE_JOIN_USING = SQLDialect.supportedBy(SQLDialect.CUBRID, SQLDialect.IGNITE);
    static final Set<SQLDialect> EMULATE_APPLY = SQLDialect.supportedBy(SQLDialect.FIREBIRD, SQLDialect.POSTGRES, SQLDialect.TRINO, SQLDialect.YUGABYTEDB);
    final Table<?> lhs;
    final Table<?> rhs;
    final QueryPartList<Field<?>> lhsPartitionBy;
    final QueryPartList<Field<?>> rhsPartitionBy;
    final JoinType type;
    final QOM.JoinHint hint;
    final ConditionProviderImpl condition;
    final QueryPartList<Field<?>> using;

    JoinTable(TableLike<?> lhs, TableLike<?> rhs, JoinType type, QOM.JoinHint hint) {
        this(lhs, rhs, type, hint, Collections.emptyList());
    }

    JoinTable(TableLike<?> lhs, TableLike<?> rhs, JoinType type, QOM.JoinHint hint, Collection<? extends Field<?>> lhsPartitionBy) {
        super(TableOptions.expression(), Names.N_JOIN);
        this.lhs = lhs.asTable();
        this.rhs = rhs.asTable();
        this.lhsPartitionBy = new QueryPartList((Iterable<Field<?>>)lhsPartitionBy);
        this.rhsPartitionBy = new QueryPartList();
        this.type = type;
        this.hint = hint;
        this.condition = new ConditionProviderImpl();
        this.using = new QueryPartList();
    }

    @Deprecated
    final J transform(Table<?> newLhs, Table<?> newRhs) {
        return this.transform(newLhs, newRhs, this.condition);
    }

    @Deprecated
    final J transform(Table<?> newLhs, Table<?> newRhs, ConditionProviderImpl newCondition) {
        if (this.lhs == newLhs && this.rhs == newRhs && this.condition == newCondition) {
            return (J)this;
        }
        return this.construct(newLhs, this.lhsPartitionBy, this.rhsPartitionBy, newRhs, newCondition, this.using, this.hint);
    }

    @Override
    public final List<ForeignKey<Record, ?>> getReferences() {
        List<ForeignKey<?, ?>> lhsReferences = this.lhs.getReferences();
        List<ForeignKey<?, ?>> rhsReferences = this.rhs.getReferences();
        ArrayList result = new ArrayList(lhsReferences.size() + rhsReferences.size());
        result.addAll(lhsReferences);
        result.addAll(rhsReferences);
        return result;
    }

    @Override
    public final void accept(Context<?> ctx) {
        boolean path;
        boolean lpath = TableImpl.path(this.lhs) != null;
        boolean rpath = TableImpl.path(this.rhs) != null;
        boolean bl = path = lpath || rpath;
        if ((this instanceof CrossApply || this instanceof OuterApply) && rpath) {
            ctx.visit((QueryPart)this.$table2(DSL.selectFrom(this.rhs).asTable(this.rhs)));
        } else if (this.rhs instanceof QOM.Lateral && TableImpl.path((Table)((QOM.Lateral)this.rhs).$arg1()) != null) {
            ctx.visit((QueryPart)this.$table2(DSL.lateral(DSL.selectFrom((TableLike)((QOM.Lateral)this.rhs).$arg1()).asTable((Table)((QOM.Lateral)this.rhs).$arg1()))));
        } else if (this.type == JoinType.NATURAL_JOIN && path) {
            ctx.visit(this.lhs.join(this.rhs, JoinType.JOIN, this.hint).on(this.naturalCondition()));
        } else if (this.type == JoinType.NATURAL_LEFT_OUTER_JOIN && path) {
            ctx.visit(this.lhs.join(this.rhs, JoinType.LEFT_OUTER_JOIN, this.hint).on(this.naturalCondition()));
        } else if (this.type == JoinType.NATURAL_RIGHT_OUTER_JOIN && path) {
            ctx.visit(this.lhs.join(this.rhs, JoinType.RIGHT_OUTER_JOIN, this.hint).on(this.naturalCondition()));
        } else if (this.type == JoinType.NATURAL_FULL_OUTER_JOIN && path) {
            ctx.visit(this.lhs.join(this.rhs, JoinType.FULL_OUTER_JOIN, this.hint).on(this.naturalCondition()));
        } else if (!this.using.isEmpty() && path) {
            ctx.visit(this.lhs.join(this.rhs, this.type, this.hint).on(this.usingCondition()));
        } else if (this instanceof CrossApply && EMULATE_APPLY.contains((Object)ctx.dialect())) {
            ctx.visit(this.lhs.crossJoin(DSL.lateral(this.rhs)));
        } else if (this instanceof OuterApply && EMULATE_APPLY.contains((Object)ctx.dialect())) {
            ctx.visit(this.lhs.leftJoin(DSL.lateral(this.rhs)).on(DSL.noCondition()));
        } else {
            this.accept0(ctx);
        }
    }

    private final void accept0(Context<?> ctx) {
        JoinType translatedType = this.translateType(ctx);
        Clause translatedClause = this.translateClause(translatedType);
        Keyword keyword = this.translateKeyword(ctx, translatedType);
        this.toSQLTable(ctx, this.lhs);
        switch (translatedType) {
            case LEFT_SEMI_JOIN: 
            case LEFT_ANTI_JOIN: {
                if (!Boolean.TRUE.equals(ctx.data(Tools.BooleanDataKey.DATA_COLLECT_SEMI_ANTI_JOIN))) break;
                ArrayList<Condition> semiAntiJoinPredicates = (ArrayList<Condition>)ctx.data(Tools.SimpleDataKey.DATA_COLLECTED_SEMI_ANTI_JOIN);
                if (semiAntiJoinPredicates == null) {
                    semiAntiJoinPredicates = new ArrayList<Condition>();
                    ctx.data(Tools.SimpleDataKey.DATA_COLLECTED_SEMI_ANTI_JOIN, semiAntiJoinPredicates);
                }
                Condition c = ConditionProviderImpl.extractCondition(!this.using.isEmpty() ? this.usingCondition() : this.condition);
                switch (translatedType) {
                    case LEFT_SEMI_JOIN: {
                        semiAntiJoinPredicates.add(DSL.exists(DSL.selectOne().from((TableLike<?>)this.rhs).where(c)));
                        break;
                    }
                    case LEFT_ANTI_JOIN: {
                        semiAntiJoinPredicates.add(DSL.notExists(DSL.selectOne().from((TableLike<?>)this.rhs).where(c)));
                    }
                }
                return;
            }
        }
        ctx.formatIndentStart().formatSeparator().start(translatedClause).visit(keyword).sql(' ');
        this.toSQLTable(ctx, this.rhs);
        if (translatedType.qualified()) {
            ctx.formatIndentStart();
            this.toSQLJoinCondition(ctx);
            ctx.formatIndentEnd();
        }
        ctx.end(translatedClause).formatIndentEnd();
    }

    private final Keyword translateKeyword(Context<?> ctx, JoinType translatedType) {
        return switch (translatedType) {
            case JoinType.JOIN, JoinType.NATURAL_JOIN -> {
                if (ctx.settings().getRenderOptionalInnerKeyword() == RenderOptionalKeyword.ON) {
                    yield translatedType.toKeyword(true);
                }
                yield translatedType.toKeyword();
            }
            case JoinType.LEFT_OUTER_JOIN, JoinType.NATURAL_LEFT_OUTER_JOIN, JoinType.RIGHT_OUTER_JOIN, JoinType.NATURAL_RIGHT_OUTER_JOIN, JoinType.FULL_OUTER_JOIN, JoinType.NATURAL_FULL_OUTER_JOIN -> {
                if (ctx.settings().getRenderOptionalOuterKeyword() == RenderOptionalKeyword.OFF) {
                    yield translatedType.toKeyword(false);
                }
                yield translatedType.toKeyword();
            }
            default -> translatedType.toKeyword();
        };
    }

    private void toSQLTable(Context<?> ctx, Table<?> table) {
        boolean wrap;
        boolean bl = wrap = table instanceof JoinTable && table == this.rhs;
        if (wrap) {
            ctx.sqlIndentStart('(');
        }
        Tools.visitAutoAliased(ctx, table, Context::declareTables, (c, t2) -> c.visit((QueryPart)t2));
        if (wrap) {
            ctx.sqlIndentEnd(')');
        }
    }

    final Clause translateClause(JoinType translatedType) {
        switch (translatedType) {
            case JOIN: {
                return Clause.TABLE_JOIN_INNER;
            }
            case CROSS_JOIN: {
                return Clause.TABLE_JOIN_CROSS;
            }
            case NATURAL_JOIN: {
                return Clause.TABLE_JOIN_NATURAL;
            }
            case LEFT_OUTER_JOIN: {
                return Clause.TABLE_JOIN_OUTER_LEFT;
            }
            case RIGHT_OUTER_JOIN: {
                return Clause.TABLE_JOIN_OUTER_RIGHT;
            }
            case FULL_OUTER_JOIN: {
                return Clause.TABLE_JOIN_OUTER_FULL;
            }
            case NATURAL_LEFT_OUTER_JOIN: {
                return Clause.TABLE_JOIN_NATURAL_OUTER_LEFT;
            }
            case NATURAL_RIGHT_OUTER_JOIN: {
                return Clause.TABLE_JOIN_NATURAL_OUTER_RIGHT;
            }
            case NATURAL_FULL_OUTER_JOIN: {
                return Clause.TABLE_JOIN_NATURAL_OUTER_FULL;
            }
            case CROSS_APPLY: {
                return Clause.TABLE_JOIN_CROSS_APPLY;
            }
            case OUTER_APPLY: {
                return Clause.TABLE_JOIN_OUTER_APPLY;
            }
            case LEFT_SEMI_JOIN: {
                return Clause.TABLE_JOIN_SEMI_LEFT;
            }
            case LEFT_ANTI_JOIN: {
                return Clause.TABLE_JOIN_ANTI_LEFT;
            }
            case STRAIGHT_JOIN: {
                return Clause.TABLE_JOIN_STRAIGHT;
            }
        }
        throw new IllegalArgumentException("Bad join type: " + String.valueOf((Object)translatedType));
    }

    final JoinType translateType(Context<?> ctx) {
        if (this.emulateCrossJoin(ctx)) {
            return JoinType.JOIN;
        }
        if (this.emulateNaturalJoin(ctx)) {
            return JoinType.JOIN;
        }
        if (this.emulateNaturalLeftOuterJoin(ctx)) {
            return JoinType.LEFT_OUTER_JOIN;
        }
        if (this.emulateNaturalRightOuterJoin(ctx)) {
            return JoinType.RIGHT_OUTER_JOIN;
        }
        if (this.emulateNaturalFullOuterJoin(ctx)) {
            return JoinType.FULL_OUTER_JOIN;
        }
        return this.type;
    }

    private final boolean emulateCrossJoin(Context<?> ctx) {
        return false;
    }

    private final boolean emulateNaturalJoin(Context<?> ctx) {
        return this.type == JoinType.NATURAL_JOIN && EMULATE_NATURAL_JOIN.contains((Object)ctx.dialect());
    }

    private final boolean emulateNaturalLeftOuterJoin(Context<?> ctx) {
        return this.type == JoinType.NATURAL_LEFT_OUTER_JOIN && EMULATE_NATURAL_OUTER_JOIN.contains((Object)ctx.dialect());
    }

    private final boolean emulateNaturalRightOuterJoin(Context<?> ctx) {
        return this.type == JoinType.NATURAL_RIGHT_OUTER_JOIN && EMULATE_NATURAL_OUTER_JOIN.contains((Object)ctx.dialect());
    }

    private final boolean emulateNaturalFullOuterJoin(Context<?> ctx) {
        return this.type == JoinType.NATURAL_FULL_OUTER_JOIN && EMULATE_NATURAL_OUTER_JOIN.contains((Object)ctx.dialect());
    }

    private final void toSQLJoinCondition(Context<?> ctx) {
        if (!this.using.isEmpty()) {
            if (EMULATE_JOIN_USING.contains((Object)ctx.dialect())) {
                this.toSQLJoinCondition(ctx, this.usingCondition());
            } else {
                ctx.formatSeparator().start(Clause.TABLE_JOIN_USING).visit(Keywords.K_USING).sql(" (").visit(QueryPartListView.wrap(this.using).qualify(false)).sql(')').end(Clause.TABLE_JOIN_USING);
            }
        } else if (this.emulateNaturalJoin(ctx) || this.emulateNaturalLeftOuterJoin(ctx) || this.emulateNaturalRightOuterJoin(ctx) || this.emulateNaturalFullOuterJoin(ctx)) {
            this.toSQLJoinCondition(ctx, this.naturalCondition());
        } else if ((TableImpl.path(this.lhs) != null || TableImpl.path(this.rhs) != null) && ctx.data(Tools.BooleanDataKey.DATA_RENDER_IMPLICIT_JOIN) == null) {
            Condition condition;
            Condition condition2;
            TableImpl ti;
            Condition[] conditionArray = new Condition[3];
            Table<?> table = this.lhs;
            if (table instanceof TableImpl) {
                ti = (TableImpl)table;
                condition2 = this.pathConditionIfInCurrentScope(ctx, ti);
            } else {
                condition2 = DSL.noCondition();
            }
            conditionArray[0] = condition2;
            table = this.rhs;
            if (table instanceof TableImpl) {
                ti = (TableImpl)table;
                condition = this.pathConditionIfInCurrentScope(ctx, ti);
            } else {
                condition = DSL.noCondition();
            }
            conditionArray[1] = condition;
            conditionArray[2] = this.condition.getWhere();
            this.toSQLJoinCondition(ctx, DSL.and(conditionArray));
        } else {
            this.toSQLJoinCondition(ctx, this.condition);
        }
    }

    private final Condition pathConditionIfInCurrentScope(Context<?> ctx, TableImpl<?> ti) {
        return ctx.inCurrentScope(ti.path) ? ti.pathCondition() : DSL.noCondition();
    }

    final Condition naturalCondition() {
        ArrayList<Condition> conditions = new ArrayList<Condition>(this.using.size());
        for (Field<?> field : this.lhs.fields()) {
            Field<?> other = this.rhs.field(field);
            if (other == null) continue;
            conditions.add(field.eq(other));
        }
        return DSL.and(conditions);
    }

    final Condition usingCondition() {
        return DSL.and(Tools.map(this.using, f -> Tools.qualify(this.lhs, f).eq(Tools.qualify(this.rhs, f))));
    }

    private final void toSQLJoinCondition(Context<?> context, Condition c) {
        context.formatSeparator().start(Clause.TABLE_JOIN_ON).visit(Keywords.K_ON).sql(' ').visit(c).end(Clause.TABLE_JOIN_ON);
    }

    @Override
    public final Clause[] clauses(Context<?> ctx) {
        return CLAUSES;
    }

    @Override
    public final Table<Record> as(Name alias) {
        return new TableAlias<Record>(this, alias, true);
    }

    @Override
    public final Table<Record> as(Name alias, Name ... fieldAliases) {
        return new TableAlias<Record>(this, alias, fieldAliases, true);
    }

    @Override
    public final Class<? extends Record> getRecordType() {
        if (this.type == JoinType.LEFT_SEMI_JOIN || this.type == JoinType.LEFT_ANTI_JOIN) {
            return this.lhs.getRecordType();
        }
        return RecordImplN.class;
    }

    @Override
    final FieldsImpl<Record> fields0() {
        if (this.type == JoinType.LEFT_SEMI_JOIN || this.type == JoinType.LEFT_ANTI_JOIN) {
            return new FieldsImpl<Record>(this.lhs.asTable().fields());
        }
        Field<?>[] l = this.lhs.asTable().fields();
        Field<?>[] r = this.rhs.asTable().fields();
        Field[] all = new Field[l.length + r.length];
        System.arraycopy(l, 0, all, 0, l.length);
        System.arraycopy(r, 0, all, l.length, r.length);
        return new FieldsImpl<Record>(all);
    }

    @Override
    public final boolean declaresTables() {
        return true;
    }

    @Override
    final J partitionBy0(Collection<? extends Field<?>> fields2) {
        this.rhsPartitionBy.addAll((Collection<Field<?>>)fields2);
        return (J)this;
    }

    @Override
    public final J on(Condition conditions) {
        this.condition.addConditions(conditions);
        return (J)this;
    }

    @Override
    public final J on(Condition ... conditions) {
        this.condition.addConditions(conditions);
        return (J)this;
    }

    public final J onKey() throws DataAccessException {
        List<ForeignKey<?, ?>> leftToRight = this.lhs.getReferencesTo(this.rhs);
        List<ForeignKey<?, ?>> rightToLeft = this.rhs.getReferencesTo(this.lhs);
        if (leftToRight.size() == 1 && rightToLeft.size() == 0) {
            return this.onKey(leftToRight.get(0), this.lhs, this.rhs);
        }
        if (rightToLeft.size() == 1 && leftToRight.size() == 0) {
            return this.onKey(rightToLeft.get(0), this.rhs, this.lhs);
        }
        if (rightToLeft.isEmpty() && leftToRight.isEmpty()) {
            throw this.onKeyException(OnKeyExceptionReason.NOT_FOUND, null, null);
        }
        throw this.onKeyException(OnKeyExceptionReason.AMBIGUOUS, leftToRight, rightToLeft);
    }

    public final J onKey(TableField<?, ?> ... keyFields) throws DataAccessException {
        if (keyFields != null && keyFields.length > 0) {
            ArrayList unaliased = new ArrayList(Arrays.asList(keyFields));
            for (int i = 0; i < unaliased.size(); ++i) {
                TableField f = (TableField)unaliased.get(i);
                Alias alias = Tools.alias(f.getTable());
                if (alias == null) continue;
                unaliased.set(i, (TableField)alias.wrapped().field(f));
            }
            for (boolean unalias : new boolean[]{false, true}) {
                if (Tools.containsTable(this.lhs, keyFields[0].getTable(), unalias)) {
                    for (ForeignKey<?, ?> key : this.lhs.getReferences()) {
                        if (!key.getFields().containsAll(unaliased) || !unaliased.containsAll(key.getFields())) continue;
                        return this.onKey(key, this.lhs, this.rhs);
                    }
                    for (ForeignKey<?, ?> key : this.lhs.getReferences()) {
                        if (!key.getFields().containsAll(unaliased)) continue;
                        return this.onKey(key, this.lhs, this.rhs);
                    }
                    continue;
                }
                if (!Tools.containsTable(this.rhs, keyFields[0].getTable(), unalias)) continue;
                for (ForeignKey<?, ?> key : this.rhs.getReferences()) {
                    if (!key.getFields().containsAll(unaliased) || !unaliased.containsAll(key.getFields())) continue;
                    return this.onKey(key, this.rhs, this.lhs);
                }
                for (ForeignKey<?, ?> key : this.rhs.getReferences()) {
                    if (!key.getFields().containsAll(unaliased)) continue;
                    return this.onKey(key, this.rhs, this.lhs);
                }
            }
        }
        throw this.onKeyException(OnKeyExceptionReason.NOT_FOUND, null, null);
    }

    public final J onKey(ForeignKey<?, ?> key) {
        if (Tools.containsUnaliasedTable(this.lhs, key.getTable()) && Tools.containsUnaliasedTable(this.rhs, key.getKey().getTable())) {
            return this.onKey(key, this.lhs, this.rhs);
        }
        if (Tools.containsUnaliasedTable(this.rhs, key.getTable()) && Tools.containsUnaliasedTable(this.lhs, key.getKey().getTable())) {
            return this.onKey(key, this.rhs, this.lhs);
        }
        throw this.onKeyException(OnKeyExceptionReason.NOT_FOUND, null, null);
    }

    private final J onKey(ForeignKey<?, ?> key, Table<?> fk, Table<?> pk) {
        return (J)this.and(JoinTable.onKey0(key, fk, pk));
    }

    static final Condition onKey0(ForeignKey<?, ?> key, Table<?> fk, Table<?> pk) {
        Condition result = DSL.noCondition();
        TableField<R, ?>[] references = key.getFieldsArray();
        TableField<?, ?>[] referenced = key.getKeyFieldsArray();
        for (int i = 0; i < references.length; ++i) {
            Field f1 = fk.field(references[i]);
            Field f2 = pk.field(referenced[i]);
            result = result.and(f1.equal(f2));
        }
        return result;
    }

    private final DataAccessException onKeyException(OnKeyExceptionReason reason, List<?> leftToRight, List<?> rightToLeft) {
        switch (reason.ordinal()) {
            case 0: {
                return new DataAccessException("Key ambiguous between tables [" + String.valueOf(this.lhs) + "] and [" + String.valueOf(this.rhs) + "]. Found: " + String.valueOf(leftToRight) + " and " + String.valueOf(rightToLeft));
            }
        }
        return new DataAccessException("No matching Key found between tables [" + String.valueOf(this.lhs) + "] and [" + String.valueOf(this.rhs) + "]");
    }

    @Override
    public final J using(Collection<? extends Field<?>> fields2) {
        this.using.addAll((Collection<Field<?>>)fields2);
        return (J)this;
    }

    @Override
    public final J and(Condition c) {
        this.condition.addConditions(c);
        return (J)this;
    }

    @Override
    public final J or(Condition c) {
        this.condition.addConditions(Operator.OR, c);
        return (J)this;
    }

    abstract J construct(Table<?> var1, Collection<? extends Field<?>> var2, Collection<? extends Field<?>> var3, Table<?> var4, Condition var5, Collection<? extends Field<?>> var6, QOM.JoinHint var7);

    public final Table<?> $table1() {
        return this.lhs;
    }

    public final J $table1(Table<?> t1) {
        return this.construct(t1, this.$partitionBy1(), this.$partitionBy2(), this.$table2(), this.$on(), this.$using(), this.$hint());
    }

    public final QOM.UnmodifiableList<Field<?>> $partitionBy1() {
        return QOM.unmodifiable(this.lhsPartitionBy);
    }

    public final J $partitionBy1(Collection<? extends Field<?>> p1) {
        return this.construct(this.$table1(), p1, this.$partitionBy2(), this.$table2(), this.$on(), this.$using(), this.$hint());
    }

    public final QOM.UnmodifiableList<Field<?>> $partitionBy2() {
        return QOM.unmodifiable(this.rhsPartitionBy);
    }

    public final J $partitionBy2(Collection<? extends Field<?>> p2) {
        return this.construct(this.$table1(), this.$partitionBy1(), p2, this.$table2(), this.$on(), this.$using(), this.$hint());
    }

    public final Table<?> $table2() {
        return this.rhs;
    }

    public final J $table2(Table<?> t2) {
        return this.construct(this.$table1(), this.$partitionBy1(), this.$partitionBy2(), t2, this.$on(), this.$using(), this.$hint());
    }

    public final QOM.JoinHint $hint() {
        return this.hint;
    }

    public final J $hint(QOM.JoinHint newHint) {
        return this.construct(this.$table1(), this.$partitionBy1(), this.$partitionBy2(), this.$table2(), this.$on(), this.$using(), newHint);
    }

    public final Condition $on() {
        return this.condition.getWhereOrNull();
    }

    public final J $on(Condition o) {
        return this.construct(this.$table1(), this.$partitionBy1(), this.$partitionBy2(), this.$table2(), o, Collections.emptyList(), this.$hint());
    }

    public final QOM.UnmodifiableList<Field<?>> $using() {
        return QOM.unmodifiable(this.using);
    }

    public final J $using(Collection<? extends Field<?>> u) {
        return this.construct(this.$table1(), this.$partitionBy1(), this.$partitionBy2(), this.$table2(), null, u, this.$hint());
    }

    private static enum OnKeyExceptionReason {
        AMBIGUOUS,
        NOT_FOUND;

    }
}

