/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import java.sql.Timestamp;
import java.util.Arrays;
import java.util.List;
import org.jooq.Check;
import org.jooq.Condition;
import org.jooq.Field;
import org.jooq.Identity;
import org.jooq.Name;
import org.jooq.Table;
import org.jooq.TableField;
import org.jooq.TableOptions;
import org.jooq.UniqueKey;
import org.jooq.impl.DSL;
import org.jooq.impl.HistoryRecord;
import org.jooq.impl.HistoryResolution;
import org.jooq.impl.HistoryStatus;
import org.jooq.impl.Internal;
import org.jooq.impl.SQLDataType;
import org.jooq.impl.TableImpl;

class History
extends TableImpl<HistoryRecord> {
    private static final long serialVersionUID = 1L;
    static final History HISTORY = new History();
    final TableField<HistoryRecord, Integer> ID = History.createField(DSL.name("ID"), SQLDataType.INTEGER.nullable(false).identity(true), this, "The database version ID.");
    final TableField<HistoryRecord, Timestamp> MIGRATED_AT = History.createField(DSL.name("MIGRATED_AT"), SQLDataType.TIMESTAMP(6).nullable(false), this, "The date/time when the database version was migrated to.");
    final TableField<HistoryRecord, String> MIGRATED_FROM = History.createField(DSL.name("MIGRATED_FROM"), SQLDataType.VARCHAR(255).nullable(false), this, "The previous database version ID.");
    final TableField<HistoryRecord, String> MIGRATED_TO = History.createField(DSL.name("MIGRATED_TO"), SQLDataType.VARCHAR(255).nullable(false), this, "The current database version ID.");
    final TableField<HistoryRecord, String> MIGRATED_TO_TAGS = History.createField(DSL.name("MIGRATED_TO_TAGS"), SQLDataType.CLOB.nullable(false), this, "The current database version tags, if any, in JSON array format.");
    final TableField<HistoryRecord, Long> MIGRATION_TIME = History.createField(DSL.name("MIGRATION_TIME"), SQLDataType.BIGINT, this, "The time in milliseconds it took to migrate to this database version.");
    final TableField<HistoryRecord, String> JOOQ_VERSION = History.createField(DSL.name("JOOQ_VERSION"), SQLDataType.VARCHAR(50).nullable(false), this, "The jOOQ version used to migrate to this database version.");
    final TableField<HistoryRecord, String> SQL = History.createField(DSL.name("SQL"), SQLDataType.CLOB, this, "The SQL statements that were run to install this database version.");
    final TableField<HistoryRecord, Integer> SQL_COUNT = History.createField(DSL.name("SQL_COUNT"), SQLDataType.INTEGER.nullable(false), this, "The number of SQL statements that were run to install this database version.");
    final TableField<HistoryRecord, HistoryStatus> STATUS = History.createField(DSL.name("STATUS"), SQLDataType.VARCHAR(10).nullable(false).asEnumDataType(HistoryStatus.class), this, "The database version installation status.");
    final TableField<HistoryRecord, String> STATUS_MESSAGE = History.createField(DSL.name("STATUS_MESSAGE"), SQLDataType.CLOB, this, "Any info or error message explaining the status.");
    final TableField<HistoryRecord, HistoryResolution> RESOLUTION = History.createField(DSL.name("RESOLUTION"), SQLDataType.VARCHAR(10).asEnumDataType(HistoryResolution.class), this, "The error resolution, if any.");
    final TableField<HistoryRecord, String> RESOLUTION_MESSAGE = History.createField(DSL.name("RESOLUTION_MESSAGE"), SQLDataType.CLOB, this, "Any info or error message explaining the resolution.");

    @Override
    public Class<HistoryRecord> getRecordType() {
        return HistoryRecord.class;
    }

    private History(Name alias, Table<HistoryRecord> aliased) {
        this(alias, aliased, (Field[])null, null);
    }

    private History(Name alias, Table<HistoryRecord> aliased, Field<?>[] parameters, Condition where) {
        super(alias, null, aliased, parameters, DSL.comment("The migration history of jOOQ Migrations."), TableOptions.table(), where);
    }

    History(String alias) {
        this(DSL.name(alias), HISTORY);
    }

    History(Name alias) {
        this(alias, HISTORY);
    }

    History() {
        this(DSL.name("JOOQ_MIGRATION_HISTORY"), (Table<HistoryRecord>)null);
    }

    @Override
    public Identity<HistoryRecord, Integer> getIdentity() {
        return super.getIdentity();
    }

    @Override
    public UniqueKey<HistoryRecord> getPrimaryKey() {
        return Internal.createUniqueKey(HISTORY, DSL.name("JOOQ_MIGR_HIST_PK"), new TableField[]{History.HISTORY.ID}, true);
    }

    @Override
    public List<Check<HistoryRecord>> getChecks() {
        return Arrays.asList(Internal.createCheck(this, DSL.name("JOOQ_MIGR_HIST_CHK1"), "\"STATUS\" IN('STARTING', 'REVERTING', 'MIGRATING', 'SUCCESS', 'FAILURE')", true), Internal.createCheck(this, DSL.name("JOOQ_MIGR_HIST_CHK2"), "\"RESOLUTION\" IN('OPEN', 'RESOLVED', 'IGNORED')", true));
    }

    @Override
    public History as(String alias) {
        return new History(DSL.name(alias), this);
    }

    @Override
    public History as(Name alias) {
        return new History(alias, this);
    }

    public History as(Table<?> alias) {
        return new History(alias.getQualifiedName(), this);
    }
}

