/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.jooq.Clause;
import org.jooq.Condition;
import org.jooq.Context;
import org.jooq.Field;
import org.jooq.FieldOrRow;
import org.jooq.FieldOrRowOrSelect;
import org.jooq.QueryPart;
import org.jooq.Record;
import org.jooq.RenderContext;
import org.jooq.Row;
import org.jooq.SQLDialect;
import org.jooq.Select;
import org.jooq.Table;
import org.jooq.impl.AbstractQueryPartMap;
import org.jooq.impl.DSL;
import org.jooq.impl.FieldMapsForInsert;
import org.jooq.impl.Keywords;
import org.jooq.impl.NoField;
import org.jooq.impl.ProjectSingleScalarSubquery;
import org.jooq.impl.Tools;

final class FieldMapForUpdate
extends AbstractQueryPartMap<FieldOrRow, FieldOrRowOrSelect> {
    static final Set<SQLDialect> CASTS_NEEDED = SQLDialect.supportedBy(SQLDialect.POSTGRES, SQLDialect.TRINO, SQLDialect.YUGABYTEDB);
    static final Set<SQLDialect> NO_SUPPORT_QUALIFY = SQLDialect.supportedBy(SQLDialect.DUCKDB, SQLDialect.POSTGRES, SQLDialect.SQLITE, SQLDialect.YUGABYTEDB);
    static final Set<SQLDialect> EMULATE_RVE_SET_QUERY = SQLDialect.supportedBy(SQLDialect.CUBRID, SQLDialect.DERBY, SQLDialect.FIREBIRD, SQLDialect.IGNITE, SQLDialect.MARIADB, SQLDialect.MYSQL, SQLDialect.SQLITE);
    static final Set<SQLDialect> NO_SUPPORT_RVE_SET = SQLDialect.supportedBy(SQLDialect.CUBRID, SQLDialect.DERBY, SQLDialect.DUCKDB, SQLDialect.FIREBIRD, SQLDialect.IGNITE, SQLDialect.MARIADB, SQLDialect.MYSQL, SQLDialect.SQLITE);
    static final Set<SQLDialect> NO_SUPPORT_RVE_SET_IN_MERGE = SQLDialect.supportedBy(SQLDialect.CUBRID, SQLDialect.DERBY, SQLDialect.FIREBIRD, SQLDialect.IGNITE, SQLDialect.MARIADB, SQLDialect.MYSQL, SQLDialect.SQLITE);
    static final Set<SQLDialect> REQUIRE_RVE_ROW_CLAUSE = SQLDialect.supportedBy(SQLDialect.POSTGRES, SQLDialect.YUGABYTEDB);
    final Table<?> table;
    final SetClause setClause;
    final Clause assignmentClause;

    FieldMapForUpdate(FieldMapForUpdate um, SetClause setClause) {
        this(um.table, setClause, um.assignmentClause);
        this.putAll(um);
    }

    FieldMapForUpdate(Table<?> table, SetClause setClause, Clause assignmentClause) {
        this.table = table;
        this.setClause = setClause;
        this.assignmentClause = assignmentClause;
    }

    @Override
    public final void accept(Context<?> ctx) {
        if (this.size() > 0) {
            String separator = "";
            boolean supportsQualify = !NO_SUPPORT_QUALIFY.contains((Object)ctx.dialect()) && ctx.qualify();
            RenderContext.CastMode previous = ctx.castMode();
            if (!CASTS_NEEDED.contains((Object)ctx.dialect())) {
                ctx.castMode(RenderContext.CastMode.NEVER);
            }
            for (Map.Entry<FieldOrRow, FieldOrRowOrSelect> entry : Tools.flattenEntrySet(this.entrySet(), true)) {
                FieldOrRow key = entry.getKey();
                FieldOrRowOrSelect value = entry.getValue();
                separator = this.acceptAssignmentClause(ctx, supportsQualify, key, value, separator);
            }
            if (!CASTS_NEEDED.contains((Object)ctx.dialect())) {
                ctx.castMode(previous);
            }
        } else {
            ctx.sql("[ no fields are updated ]");
        }
    }

    private final String acceptAssignmentClause(Context<?> ctx, boolean supportsQualify, FieldOrRow key, FieldOrRowOrSelect value, String separator) {
        if (!"".equals(separator)) {
            ctx.sql(separator).formatSeparator();
        }
        if (this.assignmentClause != null) {
            ctx.start(this.assignmentClause);
        }
        if (key instanceof Row) {
            Select multiSelect;
            Row multiRow = (Row)key;
            Row multiValue = value instanceof Row ? (Row)value : null;
            Select select = multiSelect = value instanceof Select ? (Select)value : null;
            if (multiValue != null && (NO_SUPPORT_RVE_SET.contains((Object)ctx.dialect()) || NO_SUPPORT_RVE_SET_IN_MERGE.contains((Object)ctx.dialect()) && this.setClause == SetClause.MERGE)) {
                FieldMapForUpdate map = new FieldMapForUpdate(DSL.table(new Record[0]), this.setClause, null);
                for (int i = 0; i < multiRow.size(); ++i) {
                    Field<?> k = multiRow.field(i);
                    Field<?> v = multiValue.field(i);
                    map.put(k, FieldMapsForInsert.patchDefault(ctx, Tools.field(v, k), k));
                }
                ctx.visit(map);
            } else if (multiSelect != null && (EMULATE_RVE_SET_QUERY.contains((Object)ctx.dialect()) || NO_SUPPORT_RVE_SET_IN_MERGE.contains((Object)ctx.dialect()) && this.setClause == SetClause.MERGE)) {
                Row row = FieldMapForUpdate.removeReadonly(ctx, multiRow);
                int size = row.size();
                Select select2 = multiSelect;
                if (size == 1) {
                    FieldMapForUpdate.acceptStoreAssignment(ctx, false, row.field(0));
                    FieldMapForUpdate.visitSubquery(ctx, select2);
                } else {
                    for (int i = 0; i < size; ++i) {
                        FieldMapForUpdate mu = new FieldMapForUpdate(this.table, this.setClause, null);
                        separator = mu.acceptAssignmentClause(ctx, supportsQualify, row.field(i), new ProjectSingleScalarSubquery(select2, i), separator);
                    }
                }
            } else {
                Row row = FieldMapForUpdate.removeReadonly(ctx, multiRow);
                FieldMapForUpdate.acceptStoreAssignment(ctx, false, row);
                if (multiValue != null) {
                    if (REQUIRE_RVE_ROW_CLAUSE.contains((Object)ctx.dialect())) {
                        ctx.visit(Keywords.K_ROW).sql(" ");
                    }
                    ctx.visit(FieldMapForUpdate.removeReadonly(ctx, multiRow, multiValue));
                } else if (multiSelect != null) {
                    FieldMapForUpdate.visitSubquery(ctx, multiSelect);
                }
            }
        } else {
            FieldMapForUpdate.acceptStoreAssignment(ctx, supportsQualify, key);
            Condition condition = (Condition)ctx.data(Tools.SimpleDataKey.DATA_ON_DUPLICATE_KEY_WHERE);
            if (condition != null) {
                ctx.visit(DSL.when(condition, (Field)value).else_(key));
            } else {
                ctx.visit(FieldMapsForInsert.patchDefault(ctx, (Field)value, (Field)key));
            }
        }
        if (this.assignmentClause != null) {
            ctx.end(this.assignmentClause);
        }
        return ",";
    }

    private static final void acceptStoreAssignment(Context<?> ctx, boolean qualify, QueryPart target) {
        ctx.qualify(qualify, c1 -> c1.data(Tools.BooleanDataKey.DATA_STORE_ASSIGNMENT, true, c2 -> c2.visit(target))).sql(" = ");
    }

    private static final void visitSubquery(Context<?> ctx, Select<?> select) {
        Tools.visitSubquery(ctx, select);
    }

    static final Row removeReadonly(Context<?> ctx, Row row) {
        return FieldMapForUpdate.removeReadonly(ctx, row, row);
    }

    static final Row removeReadonly(Context<?> ctx, Row checkRow, Row removeRow) {
        return removeRow;
    }

    final void set(Map<?, ?> map) {
        map.forEach((k, v) -> {
            if (k instanceof Row) {
                Row r = (Row)k;
                this.put(r, (FieldOrRowOrSelect)v);
            } else {
                Field<?> field = Tools.tableField(this.table, k);
                this.put(field, Tools.field(v, field));
            }
        });
    }

    @Override
    public FieldOrRowOrSelect put(FieldOrRow key, FieldOrRowOrSelect value) {
        if (key instanceof NoField || value instanceof NoField) {
            return null;
        }
        return super.put(key, value);
    }

    @Override
    final Function<? super Map<FieldOrRow, FieldOrRowOrSelect>, ? extends AbstractQueryPartMap<FieldOrRow, FieldOrRowOrSelect>> $construct() {
        return m4 -> {
            FieldMapForUpdate r = new FieldMapForUpdate(this.table, this.setClause, this.assignmentClause);
            r.putAll(m4);
            return r;
        };
    }

    static enum SetClause {
        UPDATE,
        INSERT,
        MERGE;

    }
}

