/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import java.io.IOException;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jooq.Commit;
import org.jooq.Commits;
import org.jooq.Configuration;
import org.jooq.ContentType;
import org.jooq.File;
import org.jooq.Migrations;
import org.jooq.Tag;
import org.jooq.exception.DataMigrationVerificationException;
import org.jooq.impl.MigrationImpl;
import org.jooq.impl.Tools;
import org.jooq.migrations.xml.jaxb.ChangeType;
import org.jooq.migrations.xml.jaxb.CommitType;
import org.jooq.migrations.xml.jaxb.FileType;
import org.jooq.migrations.xml.jaxb.MigrationsType;
import org.jooq.migrations.xml.jaxb.ParentType;
import org.jooq.migrations.xml.jaxb.TagType;
import org.jooq.tools.JooqLogger;
import org.jooq.util.jaxb.tools.MiniJAXB;

final class CommitsImpl
implements Commits {
    private static final JooqLogger log = JooqLogger.getLogger(CommitsImpl.class);
    final Configuration configuration;
    final Migrations migrations;
    final Commit root;
    final Map<String, Commit> commitsById;
    final Map<String, Commit> commitsByTag;

    CommitsImpl(Configuration configuration, Commit root) {
        this.configuration = configuration;
        this.migrations = configuration.dsl().migrations();
        this.commitsById = new LinkedHashMap<String, Commit>();
        this.commitsByTag = new LinkedHashMap<String, Commit>();
        this.root = root;
        this.add(root);
    }

    @Override
    public final Commits add(Commit commit) {
        if (this.root != commit.root()) {
            throw new DataMigrationVerificationException("A Commits graph must contain a single graph whose commits all share the same root.");
        }
        Commit duplicate = this.commitsById.get(commit.id());
        if (duplicate != null) {
            throw new DataMigrationVerificationException("Duplicate commit ID already present on commit: " + String.valueOf(duplicate));
        }
        for (Tag tag : commit.tags()) {
            duplicate = this.commitsByTag.get(tag.id());
            if (duplicate == null) continue;
            throw new DataMigrationVerificationException("Duplicate tag " + String.valueOf(tag) + " already present on commit: " + String.valueOf(duplicate));
        }
        this.commitsById.put(commit.id(), commit);
        for (Tag tag : commit.tags()) {
            this.commitsByTag.put(tag.id(), commit);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Commit added", commit);
        }
        return this;
    }

    @Override
    public final Commits addAll(Commit ... c) {
        return this.addAll(Arrays.asList(c));
    }

    @Override
    public final Commits addAll(Collection<? extends Commit> c) {
        for (Commit commit : c) {
            this.add(commit);
        }
        return this;
    }

    @Override
    public final Commit root() {
        return this.root;
    }

    @Override
    public final Commit current() {
        return new MigrationImpl(this.configuration, this.root).currentCommit();
    }

    @Override
    public final Commit latest() {
        HashMap<String, Commit> commits = new HashMap<String, Commit>(this.commitsById);
        for (Map.Entry<String, Commit> e : this.commitsById.entrySet()) {
            for (Commit parent : e.getValue().parents()) {
                commits.remove(parent.id());
            }
        }
        if (commits.size() == 1) {
            return (Commit)commits.values().iterator().next();
        }
        throw new DataMigrationVerificationException("No latest commit available. There are " + commits.size() + " unmerged branches.");
    }

    @Override
    public final Commit get(String id) {
        Commit result = this.commitsById.get(id);
        return result != null ? result : this.commitsByTag.get(id);
    }

    @Override
    public final Iterator<Commit> iterator() {
        return Collections.unmodifiableCollection(this.commitsById.values()).iterator();
    }

    @Override
    public final Commits load(java.io.File directory) throws IOException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Reading directory", directory);
        }
        Object[] sql = directory.listFiles(f -> f.getName().endsWith(".sql"));
        Object[] xml = directory.listFiles(f -> f.getName().endsWith(".xml"));
        if (!Tools.isEmpty(sql) && !Tools.isEmpty(xml)) {
            throw new DataMigrationVerificationException("A migration directory can only use either SQL files or XML files, not both.");
        }
        if (!Tools.isEmpty(sql)) {
            return this.loadSQL((java.io.File[])sql);
        }
        if (!Tools.isEmpty(xml)) {
            return this.loadXML((java.io.File[])xml);
        }
        return this;
    }

    private final Commits loadSQL(java.io.File[] sql) throws IOException {
        TreeMap<String, List> versionToId = new TreeMap<String, List>();
        HashMap<String, CommitType> idToCommit = new HashMap<String, CommitType>();
        List<FileData> list = Stream.of(sql).map(FileData::new).collect(Collectors.toList());
        if (log.isDebugEnabled()) {
            list.forEach(f -> log.debug((Object)"Reading file", f.basename));
        }
        for (FileData f2 : list) {
            versionToId.computeIfAbsent(f2.version, k -> new ArrayList()).add(f2.id);
        }
        for (FileData f2 : list) {
            idToCommit.put(f2.id, new CommitType().withId(f2.id));
        }
        for (FileData f2 : list) {
            CommitType commit = (CommitType)idToCommit.get(f2.id);
            if (f2.parentIds.isEmpty()) {
                Map.Entry e = versionToId.lowerEntry(f2.version);
                if (e != null) {
                    if (((List)e.getValue()).size() > 1) {
                        throw new DataMigrationVerificationException("Multiple predecessors for " + e.getKey() + ". Implicit parent cannot be detected: " + String.valueOf(e.getValue()));
                    }
                    commit.setParents(Arrays.asList(new ParentType().withId((String)((List)e.getValue()).get(0))));
                }
            } else {
                for (String parent : f2.parentIds) {
                    if (idToCommit.containsKey(parent)) {
                        commit.getParents().add(new ParentType().withId(parent));
                        continue;
                    }
                    throw new DataMigrationVerificationException("Parent " + parent + " is not defined");
                }
            }
            commit.withMessage(f2.message).withTags(f2.tags).withFiles(Arrays.asList(new FileType().withPath(f2.basename).withContentType(ContentType.INCREMENT).withContent(new String(Files.readAllBytes(f2.file.toPath())))));
        }
        return this.load(new MigrationsType().withCommits(idToCommit.values()));
    }

    private final Commits loadXML(java.io.File[] xml) {
        MigrationsType m4 = new MigrationsType();
        for (java.io.File f : xml) {
            MigrationsType u = MiniJAXB.unmarshal(f, MigrationsType.class);
            m4 = MiniJAXB.append(m4, u);
        }
        return this.load(m4);
    }

    @Override
    public final Commits load(MigrationsType migrations) {
        HashMap<String, CommitType> map = new HashMap<String, CommitType>();
        for (CommitType commit : migrations.getCommits()) {
            map.put(commit.getId(), commit);
        }
        for (CommitType commit : migrations.getCommits()) {
            this.load(map, commit);
        }
        return this;
    }

    private final Commit load(Map<String, CommitType> map, CommitType commit) {
        Commit result = this.commitsById.get(commit.getId());
        if (result != null) {
            return result;
        }
        Commit p1 = this.root;
        Commit p2 = null;
        List<ParentType> parents = commit.getParents();
        int size = parents.size();
        if (size > 0) {
            CommitType c1 = map.get(parents.get(0).getId());
            if (c1 == null) {
                throw new DataMigrationVerificationException("Parent not found: " + parents.get(0).getId());
            }
            p1 = this.load(map, c1);
            if (size == 2) {
                CommitType c2 = map.get(parents.get(1).getId());
                if (c2 == null) {
                    throw new DataMigrationVerificationException("Parent not found: " + parents.get(0).getId());
                }
                p2 = this.load(map, c2);
            } else if (size > 2) {
                throw new DataMigrationVerificationException("Merging more than two parents not yet supported");
            }
        }
        result = p2 == null ? p1.commit(commit.getId(), commit.getMessage(), this.files(commit)) : p1.merge(commit.getId(), commit.getMessage(), p2, this.files(commit));
        for (TagType tag : commit.getTags()) {
            result = result.tag(tag.getId(), tag.getMessage());
        }
        this.add(result);
        return result;
    }

    private final List<File> files(CommitType commit) {
        return Tools.map(commit.getFiles(), f -> this.migrations.file(f.getPath(), f.getChange() == ChangeType.DELETE ? null : f.getContent(), f.getContentType()));
    }

    @Override
    public final MigrationsType export() {
        return new MigrationsType().withCommits(Tools.map(this, commit -> new CommitType().withId(commit.id()).withMessage(commit.message()).withParents(Tools.map(commit.parents(), parent -> new ParentType().withId(parent.id()))).withTags(Tools.map(commit.tags(), tag -> new TagType().withId(tag.id()).withMessage(tag.message()))).withFiles(Tools.map(commit.files(), file -> new FileType().withPath(file.path()).withContent(file.content()).withContentType(file.type()).withChange(file.content() == null ? ChangeType.DELETE : ChangeType.MODIFY)))));
    }

    public String toString() {
        return String.valueOf(this.commitsById.values());
    }

    static final class FileData {
        final java.io.File file;
        final String basename;
        final String version;
        final String message;
        final List<TagType> tags;
        final String id;
        final List<String> parentIds;

        FileData(java.io.File file) {
            this.file = file;
            this.basename = file.getName().replace(".sql", "");
            String[] idAndParentsArray = this.basename.split("\\.");
            String[] idAndTagsArray = idAndParentsArray[0].split(",");
            this.id = idAndTagsArray[0];
            this.parentIds = idAndParentsArray.length > 1 ? Arrays.asList(idAndParentsArray[1].split(",")) : Arrays.asList(new String[0]);
            String[] idArray = this.id.split("-");
            this.version = idArray[0];
            this.message = idArray.length > 1 ? idArray[1] : null;
            this.tags = new ArrayList<TagType>();
            for (int i = 1; i < idAndTagsArray.length; ++i) {
                String[] tagArray = idAndTagsArray[i].split("-");
                this.tags.add(new TagType().withId(tagArray[0]).withMessage(tagArray.length > 1 ? tagArray[1] : null));
            }
        }
    }
}

