/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import java.util.List;
import java.util.Set;
import org.jooq.Clause;
import org.jooq.Condition;
import org.jooq.Context;
import org.jooq.Field;
import org.jooq.Name;
import org.jooq.QueryPart;
import org.jooq.SQLDialect;
import org.jooq.Select;
import org.jooq.Table;
import org.jooq.TableLike;
import org.jooq.conf.RenderOptionalKeyword;
import org.jooq.impl.AbstractQueryPart;
import org.jooq.impl.AliasedSelect;
import org.jooq.impl.ArrayTable;
import org.jooq.impl.CommonTableExpressionImpl;
import org.jooq.impl.DSL;
import org.jooq.impl.DerivedTable;
import org.jooq.impl.JoinTable;
import org.jooq.impl.Keywords;
import org.jooq.impl.NoAutoAlias;
import org.jooq.impl.QOM;
import org.jooq.impl.QueryPartListView;
import org.jooq.impl.SelectFieldList;
import org.jooq.impl.SimpleCheckQueryPart;
import org.jooq.impl.TableImpl;
import org.jooq.impl.Tools;
import org.jooq.impl.Values;

final class Alias<Q extends QueryPart>
extends AbstractQueryPart
implements QOM.UEmpty,
SimpleCheckQueryPart {
    private static final Clause[] CLAUSES_TABLE_REFERENCE = new Clause[]{Clause.TABLE, Clause.TABLE_REFERENCE};
    private static final Clause[] CLAUSES_TABLE_ALIAS = new Clause[]{Clause.TABLE, Clause.TABLE_ALIAS};
    private static final Clause[] CLAUSES_FIELD_REFERENCE = new Clause[]{Clause.FIELD, Clause.FIELD_REFERENCE};
    private static final Clause[] CLAUSES_FIELD_ALIAS = new Clause[]{Clause.FIELD, Clause.FIELD_ALIAS};
    static final Set<SQLDialect> NO_SUPPORT_ALIASED_JOIN_TABLES = SQLDialect.supportedBy(SQLDialect.DERBY, SQLDialect.FIREBIRD, SQLDialect.MARIADB, SQLDialect.MYSQL, SQLDialect.SQLITE);
    static final Set<SQLDialect> SUPPORT_AS_REQUIRED = SQLDialect.supportedBy(SQLDialect.DERBY, SQLDialect.HSQLDB, SQLDialect.MARIADB, SQLDialect.MYSQL, SQLDialect.POSTGRES, SQLDialect.SQLITE, SQLDialect.YUGABYTEDB);
    static final Set<SQLDialect> SUPPORT_DERIVED_COLUMN_NAMES_SPECIAL1 = SQLDialect.supportedBy(SQLDialect.CUBRID, SQLDialect.FIREBIRD, SQLDialect.MYSQL);
    static final Set<SQLDialect> SUPPORT_DERIVED_COLUMN_NAMES_SPECIAL2 = SQLDialect.supportedUntil(SQLDialect.IGNITE, SQLDialect.MARIADB, SQLDialect.SQLITE);
    final Q wrapped;
    final Q wrapping;
    final Name alias;
    final Name[] fieldAliases;
    final boolean wrapInParentheses;

    Alias(Q wrapped, Q wrapping, Name alias) {
        this(wrapped, wrapping, alias, null, false);
    }

    Alias(Q wrapped, Q wrapping, Name alias, Name[] fieldAliases, boolean wrapInParentheses) {
        this.wrapped = wrapped;
        this.wrapping = wrapping;
        this.alias = alias;
        this.fieldAliases = fieldAliases;
        this.wrapInParentheses = wrapInParentheses;
    }

    final Q wrapped() {
        return this.wrapped;
    }

    final boolean hasFieldAliases() {
        return Tools.isNotEmpty(this.fieldAliases);
    }

    @Override
    public final boolean isSimple(Context<?> ctx) {
        return this.wrapped instanceof Table && !ctx.declareTables() || this.wrapped instanceof Field && !ctx.declareFields();
    }

    @Override
    public final void accept(Context<?> ctx) {
        if (ctx.declareAliases() && (ctx.declareFields() || ctx.declareTables())) {
            boolean aliasedJoinTable = this.wrapped instanceof JoinTable;
            if (!aliasedJoinTable) {
                ctx.declareAliases(false);
            }
            this.acceptDeclareAliasStandard(ctx);
            if (!aliasedJoinTable) {
                ctx.declareAliases(true);
            }
        } else {
            ctx.qualify(false, c -> c.visit(this.alias));
        }
    }

    private final void acceptDeclareAliasTSQL(Context<?> ctx) {
        ctx.visit(this.alias).sql(" = ");
        this.toSQLWrapped(ctx);
    }

    private final void acceptDeclareAliasStandard(Context<?> context) {
        if (this.wrapped instanceof TableImpl) {
            context.scopeMarkStart((QueryPart)this.wrapping);
        }
        SQLDialect dialect = context.dialect();
        SQLDialect family = context.family();
        boolean emulatedDerivedColumnList = false;
        if (this.hasFieldAliases() && SUPPORT_DERIVED_COLUMN_NAMES_SPECIAL1.contains((Object)dialect) && (this.wrapped instanceof TableImpl || this.wrapped instanceof CommonTableExpressionImpl)) {
            Tools.visitSubquery(context, DSL.select(DSL.asterisk()).from((TableLike<?>)((Object)NoAutoAlias.noAutoAlias((Table)this.wrapped).as(this.alias))), 1);
        } else if (this.hasFieldAliases() && (emulatedDerivedColumnList || SUPPORT_DERIVED_COLUMN_NAMES_SPECIAL2.contains((Object)dialect))) {
            emulatedDerivedColumnList = true;
            if (this.wrapped instanceof Values && Values.NO_SUPPORT_VALUES.contains((Object)dialect)) {
                context.data(Tools.SimpleDataKey.DATA_SELECT_ALIASES, this.fieldAliases, t2 -> this.toSQLWrapped((Context<?>)t2));
            } else {
                Select select;
                Q q = this.wrapped;
                if (q instanceof Select) {
                    Select s2;
                    select = s2 = (Select)q;
                } else {
                    q = this.wrapped;
                    if (q instanceof DerivedTable) {
                        DerivedTable d = (DerivedTable)q;
                        select = d.query();
                    } else {
                        select = DSL.select(DSL.asterisk()).from((TableLike<?>)((Object)NoAutoAlias.noAutoAlias((Table)this.wrapped).as(this.alias)));
                    }
                }
                Select wrappedAsSelect = select;
                List<Field<?>> select2 = wrappedAsSelect.getSelect();
                if (emulatedDerivedColumnList) {
                    if (AliasedSelect.avoidAliasPushdown(context, wrappedAsSelect) || !(this.wrapped instanceof Select) && !(this.wrapped instanceof DerivedTable)) {
                        SelectFieldList fields2 = new SelectFieldList();
                        for (int i = 0; i < this.fieldAliases.length; ++i) {
                            switch (family) {
                                default: 
                            }
                            fields2.add(DSL.field("null").as(this.fieldAliases[i]));
                        }
                        Tools.visitSubquery(context, DSL.select(fields2).where((Condition)DSL.falseCondition()).unionAll(wrappedAsSelect), 1);
                    } else {
                        context.sql('(').visit(new AliasedSelect(wrappedAsSelect, true, false, false, this.fieldAliases)).sql(')');
                    }
                }
            }
        } else {
            this.toSQLWrapped(context);
        }
        this.toSQLAs(context);
        context.sql(' ').qualify(false, c -> c.visit(this.alias));
        if (this.hasFieldAliases() && !emulatedDerivedColumnList) {
            this.toSQLDerivedColumnList(context);
        } else {
            switch (family) {
                case HSQLDB: 
                case POSTGRES: 
                case YUGABYTEDB: {
                    Q o = this.wrapped;
                    if (!context.declareTables() || !(o instanceof ArrayTable)) break;
                    context.sql('(').visit(QueryPartListView.wrap((QueryPart[])((ArrayTable)o).fields()).qualify(false)).sql(')');
                    break;
                }
            }
        }
        if (this.wrapped instanceof TableImpl) {
            context.scopeMarkEnd((QueryPart)this.wrapping);
        }
    }

    final void toSQLAs(Context<?> ctx) {
        if (Boolean.TRUE.equals(ctx.data(Tools.BooleanDataKey.DATA_AS_REQUIRED))) {
            ctx.sql(' ').visit(Keywords.K_AS);
        } else if (this.wrapped instanceof Field) {
            if (ctx.settings().getRenderOptionalAsKeywordForFieldAliases() == RenderOptionalKeyword.DEFAULT && SUPPORT_AS_REQUIRED.contains((Object)ctx.dialect())) {
                ctx.sql(' ').visit(Keywords.K_AS);
            } else if (ctx.settings().getRenderOptionalAsKeywordForFieldAliases() == RenderOptionalKeyword.ON) {
                ctx.sql(' ').visit(Keywords.K_AS);
            }
        } else if (ctx.settings().getRenderOptionalAsKeywordForTableAliases() == RenderOptionalKeyword.DEFAULT && SUPPORT_AS_REQUIRED.contains((Object)ctx.dialect())) {
            ctx.sql(' ').visit(Keywords.K_AS);
        } else if (ctx.settings().getRenderOptionalAsKeywordForTableAliases() == RenderOptionalKeyword.ON) {
            ctx.sql(' ').visit(Keywords.K_AS);
        }
    }

    private final void toSQLWrapped(Context<?> ctx) {
        if (this.wrapInParentheses) {
            ctx.data(Tools.BooleanDataKey.DATA_WRAP_DERIVED_TABLES_IN_PARENTHESES, false, c -> this.toSQLWrapped((Context<?>)c, this.wrapInParentheses));
        } else {
            this.toSQLWrapped(ctx, this.wrapInParentheses);
        }
    }

    private final void toSQLWrapped(Context<?> ctx, boolean wrap) {
        boolean nestedJoinTable = this.wrapped instanceof JoinTable;
        if (wrap) {
            if (nestedJoinTable) {
                ctx.sqlIndentStart('(');
            } else {
                ctx.sql('(');
            }
        }
        if (nestedJoinTable && NO_SUPPORT_ALIASED_JOIN_TABLES.contains((Object)ctx.dialect())) {
            ctx.visit(DSL.select(DSL.asterisk()).from((TableLike<?>)((Table)this.wrapped)));
        } else {
            ctx.visit((QueryPart)this.wrapped);
        }
        if (wrap) {
            if (nestedJoinTable) {
                ctx.sqlIndentEnd(')');
            } else {
                ctx.sql(')');
            }
        }
    }

    private final void toSQLDerivedColumnList(Context<?> ctx) {
        ctx.sql(" (").visit(QueryPartListView.wrap((QueryPart[])this.fieldAliases)).sql(')');
    }

    @Override
    public final Clause[] clauses(Context<?> ctx) {
        if (ctx.declareFields() || ctx.declareTables()) {
            if (this.wrapped instanceof Table) {
                return CLAUSES_TABLE_ALIAS;
            }
            return CLAUSES_FIELD_ALIAS;
        }
        if (this.wrapped instanceof Table) {
            return CLAUSES_TABLE_REFERENCE;
        }
        return CLAUSES_FIELD_REFERENCE;
    }

    @Override
    public final boolean declaresFields() {
        return true;
    }

    @Override
    public final boolean declaresTables() {
        return true;
    }
}

