/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.jooq.Asterisk;
import org.jooq.Configuration;
import org.jooq.Context;
import org.jooq.DMLQuery;
import org.jooq.DSLContext;
import org.jooq.DataType;
import org.jooq.Delete;
import org.jooq.ExecuteContext;
import org.jooq.ExecuteListener;
import org.jooq.Field;
import org.jooq.Identity;
import org.jooq.Insert;
import org.jooq.QualifiedAsterisk;
import org.jooq.Record;
import org.jooq.Result;
import org.jooq.Row;
import org.jooq.SQLDialect;
import org.jooq.Scope;
import org.jooq.SelectFieldOrAsterisk;
import org.jooq.Table;
import org.jooq.TableLike;
import org.jooq.Update;
import org.jooq.conf.ExecuteWithoutWhere;
import org.jooq.conf.FetchTriggerValuesAfterReturning;
import org.jooq.conf.RenderNameCase;
import org.jooq.conf.SettingsTools;
import org.jooq.exception.DataAccessException;
import org.jooq.impl.AbstractQuery;
import org.jooq.impl.AbstractRecord;
import org.jooq.impl.AbstractRow;
import org.jooq.impl.AbstractRowCountQuery;
import org.jooq.impl.CommonTableExpressionList;
import org.jooq.impl.CursorImpl;
import org.jooq.impl.DSL;
import org.jooq.impl.DataChangeDeltaTable;
import org.jooq.impl.DefaultExecuteContext;
import org.jooq.impl.DeleteQueryImpl;
import org.jooq.impl.FieldsImpl;
import org.jooq.impl.Keywords;
import org.jooq.impl.QOM;
import org.jooq.impl.ResultImpl;
import org.jooq.impl.RowAsField;
import org.jooq.impl.SelectFieldList;
import org.jooq.impl.TableAsField;
import org.jooq.impl.ThrowingSupplier;
import org.jooq.impl.Tools;
import org.jooq.impl.WithImpl;
import org.jooq.tools.JooqLogger;
import org.jooq.tools.StringUtils;
import org.jooq.tools.jdbc.JDBCUtils;
import org.jooq.util.sqlite.SQLiteDSL;

abstract class AbstractDMLQuery<R extends Record>
extends AbstractRowCountQuery
implements DMLQuery<R> {
    private static final JooqLogger log = JooqLogger.getLogger(AbstractQuery.class);
    private static final Set<SQLDialect> NO_NATIVE_SUPPORT_INSERT_RETURNING = SQLDialect.supportedUntil(SQLDialect.CUBRID, SQLDialect.DERBY, SQLDialect.H2, SQLDialect.HSQLDB, SQLDialect.IGNITE, SQLDialect.MYSQL, SQLDialect.TRINO);
    private static final Set<SQLDialect> NO_NATIVE_SUPPORT_UPDATE_RETURNING = SQLDialect.supportedUntil(SQLDialect.CUBRID, SQLDialect.DERBY, SQLDialect.H2, SQLDialect.HSQLDB, SQLDialect.IGNITE, SQLDialect.MYSQL, SQLDialect.TRINO);
    private static final Set<SQLDialect> NO_NATIVE_SUPPORT_DELETE_RETURNING = SQLDialect.supportedUntil(SQLDialect.CUBRID, SQLDialect.DERBY, SQLDialect.H2, SQLDialect.HSQLDB, SQLDialect.IGNITE, SQLDialect.MYSQL, SQLDialect.TRINO);
    private static final Set<SQLDialect> NATIVE_SUPPORT_DATA_CHANGE_DELTA_TABLE = SQLDialect.supportedBy(SQLDialect.H2);
    private static final Set<SQLDialect> NO_SUPPORT_FETCHING_KEYS = SQLDialect.supportedBy(SQLDialect.IGNITE, SQLDialect.TRINO);
    private static final Set<SQLDialect> NO_SUPPORT_RETURNING_ASTERISK = SQLDialect.supportedUntil(SQLDialect.MARIADB);
    final WithImpl with;
    final Table<R> table;
    final SelectFieldList<SelectFieldOrAsterisk> returning;
    final List<Field<?>> returningResolvedAsterisks;
    Result<Record> returnedResult;
    Result<R> returned;

    AbstractDMLQuery(Configuration configuration, WithImpl with, Table<R> table) {
        super(configuration);
        this.with = with;
        this.table = table;
        this.returning = new SelectFieldList();
        this.returningResolvedAsterisks = new ArrayList();
    }

    public final void setReturning() {
        this.setReturning(this.table.fields());
    }

    public final void setReturning(Identity<R, ?> identity) {
        if (identity != null) {
            this.setReturning(identity.getField());
        }
    }

    public final void setReturning(SelectFieldOrAsterisk ... fields2) {
        this.setReturning(Arrays.asList(fields2));
    }

    public final void setReturning(Collection<? extends SelectFieldOrAsterisk> fields2) {
        this.returning.clear();
        this.returning.addAll(fields2.isEmpty() ? Arrays.asList(this.table.fields()) : fields2);
        this.returningResolvedAsterisks.clear();
        for (SelectFieldOrAsterisk s2 : this.returning) {
            if (s2 instanceof Field) {
                Field f = (Field)s2;
                this.returningResolvedAsterisks.add(f);
                continue;
            }
            if (s2 instanceof QualifiedAsterisk) {
                QualifiedAsterisk a = (QualifiedAsterisk)s2;
                this.returningResolvedAsterisks.addAll(Arrays.asList(a.qualifier().fields()));
                continue;
            }
            if (s2 instanceof Asterisk) {
                this.returningResolvedAsterisks.addAll(Arrays.asList(this.table.fields()));
                continue;
            }
            if (s2 instanceof Row) {
                Row r = (Row)((Object)s2);
                this.returningResolvedAsterisks.add(new RowAsField(r));
                continue;
            }
            if (s2 instanceof Table) {
                Table t2 = (Table)s2;
                this.returningResolvedAsterisks.add(new TableAsField(t2));
                continue;
            }
            throw new UnsupportedOperationException("Type not supported: " + String.valueOf(s2));
        }
    }

    public final R getReturnedRecord() {
        if (this.getReturnedRecords().isEmpty()) {
            return null;
        }
        return (R)((Record)this.getReturnedRecords().get(0));
    }

    public final Result<R> getReturnedRecords() {
        if (this.returned == null) {
            if (this.table.fields().length > 0) {
                this.warnOnAPIMisuse();
                this.returned = this.getResult().into(this.table);
            } else {
                this.returned = this.getResult();
            }
        }
        return this.returned;
    }

    private final void warnOnAPIMisuse() {
        for (Field<?> field : this.getResult().fields()) {
            if (this.table.field(field) != null) continue;
            log.warn((Object)"API misuse", "Column " + String.valueOf(field) + " has been requested through the returning() clause, which is not present in table " + String.valueOf(this.table) + ". Use StoreQuery.getResult() or the returningResult() clause instead.");
        }
    }

    final Table<R> table() {
        return this.table;
    }

    final Table<?> table(Scope ctx) {
        return this.table();
    }

    public final Result<?> getResult() {
        if (this.returnedResult == null) {
            this.returnedResult = new ResultImpl<Record>(this.configuration(), this.returningResolvedAsterisks);
        }
        return this.returnedResult;
    }

    final void accept0(Context<?> ctx) {
        QOM.UnmodifiableList<Table<?>> unmodifiableList;
        WithImpl w = this.with;
        ctx.data(Tools.SimpleDataKey.DATA_DML_TARGET_TABLE, this.table);
        AbstractDMLQuery abstractDMLQuery = this;
        if (abstractDMLQuery instanceof DeleteQueryImpl) {
            DeleteQueryImpl d = (DeleteQueryImpl)abstractDMLQuery;
            unmodifiableList = d.$using();
        } else {
            unmodifiableList = null;
        }
        ctx.data(Tools.SimpleDataKey.DATA_DML_USING_TABLES, unmodifiableList);
        if (w != null) {
            ctx.visit(w);
        } else {
            CommonTableExpressionList.markTopLevelCteAndAccept(ctx, c -> {});
        }
        boolean previousDeclareFields = ctx.declareFields();
        if (NATIVE_SUPPORT_DATA_CHANGE_DELTA_TABLE.contains((Object)ctx.dialect()) && !this.returning.isEmpty() && ctx.data(Tools.SimpleDataKey.DATA_RENDERING_DATA_CHANGE_DELTA_TABLE) == null) {
            Tools.increment(ctx.data(), Tools.SimpleDataKey.DATA_RENDERING_DATA_CHANGE_DELTA_TABLE, () -> ctx.visit(DSL.select(this.returning).from((TableLike<?>)((Object)new DataChangeDeltaTable(this instanceof Delete ? QOM.ResultOption.OLD : QOM.ResultOption.FINAL, this).as(this.table().getUnqualifiedName())))));
        } else {
            this.accept1(ctx);
        }
        ctx.data().remove(Tools.SimpleDataKey.DATA_DML_USING_TABLES);
        ctx.data().remove(Tools.SimpleDataKey.DATA_DML_TARGET_TABLE);
    }

    private final boolean fetchTriggerValuesAfterReturning(Scope ctx) {
        if (this instanceof Delete) {
            return false;
        }
        if (Boolean.FALSE.equals(ctx.settings().isFetchTriggerValuesAfterSQLServerOutput())) {
            return false;
        }
        switch (StringUtils.defaultIfNull(ctx.settings().getFetchTriggerValuesAfterReturning(), FetchTriggerValuesAfterReturning.WHEN_NEEDED)) {
            case ALWAYS: {
                return true;
            }
            case NEVER: {
                return false;
            }
            case WHEN_NEEDED: {
                if (ctx.configuration().commercial()) {
                    // empty if block
                }
                return true;
            }
        }
        throw new IllegalStateException("Unsupported value: " + String.valueOf((Object)ctx.settings().getFetchTriggerValuesAfterReturning()));
    }

    abstract void accept1(Context<?> var1);

    void executeWithoutWhere(String message, ExecuteWithoutWhere executeWithoutWhere) {
        switch (executeWithoutWhere) {
            case IGNORE: {
                break;
            }
            case LOG_DEBUG: {
                if (!log.isDebugEnabled()) break;
                log.debug((Object)message, "A statement is executed without WHERE clause");
                break;
            }
            case LOG_INFO: {
                if (!log.isInfoEnabled()) break;
                log.info((Object)message, "A statement is executed without WHERE clause");
                break;
            }
            case LOG_WARN: {
                log.warn((Object)message, "A statement is executed without WHERE clause");
                break;
            }
            case THROW: {
                throw new DataAccessException("A statement is executed without WHERE clause");
            }
        }
    }

    final void toSQLReturning(Context<?> ctx) {
        if (!this.returning.isEmpty() && this.nativeSupportReturning(ctx)) {
            boolean unqualify;
            boolean qualify = ctx.qualify();
            boolean bl = unqualify = ctx.family() == SQLDialect.MARIADB;
            if (unqualify) {
                ctx.qualify(false);
            }
            ctx.formatSeparator().visit(Keywords.K_RETURNING).sql(' ').declareFields(true, c -> c.visit(NO_SUPPORT_RETURNING_ASTERISK.contains((Object)c.dialect()) ? new SelectFieldList<SelectFieldOrAsterisk>((Iterable<SelectFieldOrAsterisk>)this.returningResolvedAsterisks) : this.returning));
            if (unqualify) {
                ctx.qualify(qualify);
            }
        }
    }

    final boolean nativeSupportReturning(Scope ctx) {
        return (ctx.family() != SQLDialect.SQLITE || !(this instanceof Insert) || !this.fetchTriggerValuesAfterReturning(ctx)) && (this instanceof Insert && !NO_NATIVE_SUPPORT_INSERT_RETURNING.contains((Object)ctx.dialect()) || this instanceof Update && !NO_NATIVE_SUPPORT_UPDATE_RETURNING.contains((Object)ctx.dialect()) || this instanceof Delete && !NO_NATIVE_SUPPORT_DELETE_RETURNING.contains((Object)ctx.dialect()));
    }

    final boolean nativeSupportReturningOrDataChangeDeltaTable(Scope ctx) {
        return NATIVE_SUPPORT_DATA_CHANGE_DELTA_TABLE.contains((Object)ctx.dialect()) || this.nativeSupportReturning(ctx);
    }

    @Override
    protected final void prepare(ExecuteContext ctx) throws SQLException {
        this.prepare0(ctx);
        Tools.setFetchSize(ctx, 0);
    }

    private final void prepare0(ExecuteContext ctx) throws SQLException {
        Connection connection = ctx.connection();
        if (this.returning.isEmpty()) {
            super.prepare(ctx);
        } else if (NO_SUPPORT_FETCHING_KEYS.contains((Object)ctx.dialect())) {
            super.prepare(ctx);
        } else if (this.nativeSupportReturningOrDataChangeDeltaTable(ctx)) {
            super.prepare(ctx);
        } else {
            switch (ctx.family()) {
                case SQLITE: 
                case CUBRID: {
                    super.prepare(ctx);
                    break;
                }
                case DERBY: 
                case MARIADB: 
                case MYSQL: {
                    if (ctx.statement() != null) break;
                    ctx.statement(connection.prepareStatement(ctx.sql(), 1));
                    break;
                }
                default: {
                    if (ctx.statement() != null) break;
                    RenderNameCase style = SettingsTools.getRenderNameCase(this.configuration().settings());
                    ctx.statement(connection.prepareStatement(ctx.sql(), Tools.map(Tools.flattenCollection(this.returningResolvedAsterisks, false, true), style == RenderNameCase.UPPER ? f -> f.getName().toUpperCase(SettingsTools.renderLocale(this.configuration().settings())) : (style == RenderNameCase.LOWER ? f -> f.getName().toLowerCase(SettingsTools.renderLocale(this.configuration().settings())) : f -> f.getName())).toArray(Tools.EMPTY_STRING)));
                }
            }
        }
    }

    @Override
    protected final int execute(ExecuteContext ctx, ExecuteListener listener) throws SQLException {
        this.returned = null;
        this.returnedResult = null;
        if (this.returning.isEmpty()) {
            return super.execute(ctx, listener);
        }
        if (NO_SUPPORT_FETCHING_KEYS.contains((Object)ctx.dialect())) {
            return super.execute(ctx, listener);
        }
        int result = 0;
        switch (ctx.family()) {
            case SQLITE: {
                if (!this.nativeSupportReturning(ctx)) {
                    listener.executeStart(ctx);
                    result = this.executeImmediate(ctx.statement()).executeUpdate();
                    ctx.rows(result);
                    listener.executeEnd(ctx);
                    DSLContext create = ctx.dsl();
                    this.returnedResult = create.select(this.returning).from((TableLike<?>)this.table).where(SQLiteDSL.rowid().eq(DSL.field("last_insert_rowid()", SQLiteDSL.rowid().getDataType()))).fetch();
                    this.returnedResult.attach(((DefaultExecuteContext)ctx).originalConfiguration());
                    return result;
                }
                this.executeReturningQuery(ctx, listener);
                break;
            }
            case CUBRID: {
                listener.executeStart(ctx);
                result = this.executeImmediate(ctx.statement()).executeUpdate();
                ctx.rows(result);
                listener.executeEnd(ctx);
                this.selectReturning(((DefaultExecuteContext)ctx).originalConfiguration(), ctx.configuration(), ctx.dsl().lastID());
                return result;
            }
            case DERBY: 
            case MYSQL: {
                return this.executeReturningGeneratedKeysFetchAdditionalRows(ctx, listener);
            }
            case MARIADB: {
                if (!this.nativeSupportReturning(ctx)) {
                    return this.executeReturningGeneratedKeysFetchAdditionalRows(ctx, listener);
                }
                this.executeReturningQuery(ctx, listener);
                break;
            }
            case H2: {
                this.executeReturningQuery(ctx, listener);
                break;
            }
            case DUCKDB: 
            case FIREBIRD: 
            case POSTGRES: 
            case YUGABYTEDB: {
                this.executeReturningQuery(ctx, listener);
                break;
            }
            default: {
                result = this.executeReturningGeneratedKeys(ctx, listener);
            }
        }
        this.returnedResult = new CursorImpl(ctx, listener, this.returningResolvedAsterisks.toArray(Tools.EMPTY_FIELD), null, false, false).fetch();
        if (!this.returnedResult.isEmpty() || ctx.family() != SQLDialect.HSQLDB) {
            result = Math.max(Math.max(result, ctx.rows()), this.returnedResult.size());
            ctx.rows(result);
        }
        return result;
    }

    private final int executeReturningGeneratedKeys(ExecuteContext ctx, ExecuteListener listener) throws SQLException {
        listener.executeStart(ctx);
        int result = this.executeImmediate(ctx.statement()).executeUpdate();
        ctx.rows(result);
        ctx.resultSet(ctx.statement().getGeneratedKeys());
        listener.executeEnd(ctx);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final int executeReturningGeneratedKeysFetchAdditionalRows(ExecuteContext ctx, ExecuteListener listener) throws SQLException {
        listener.executeStart(ctx);
        int result = this.executeImmediate(ctx.statement()).executeUpdate();
        ctx.rows(result);
        listener.executeEnd(ctx);
        ResultSet rs = ctx.statement().getGeneratedKeys();
        try {
            ArrayList<Object> list = new ArrayList<Object>();
            if (rs != null) {
                while (rs.next()) {
                    list.add(rs.getObject(1));
                }
            }
            this.selectReturning(((DefaultExecuteContext)ctx).originalConfiguration(), ctx.configuration(), list.toArray());
            int n = result;
            return n;
        }
        finally {
            JDBCUtils.safeClose(rs);
        }
    }

    private final void executeReturningQuery(ExecuteContext ctx, ExecuteListener listener) throws SQLException {
        listener.executeStart(ctx);
        ctx.resultSet(ctx.statement().executeQuery());
        listener.executeEnd(ctx);
    }

    private final void selectReturning(Configuration originalConfiguration, Configuration derivedConfiguration, Object ... values) {
        Field<?> returnIdentity;
        if (values != null && values.length > 0 && (returnIdentity = this.returnedIdentity()) != null) {
            DataType type = returnIdentity.getDataType();
            Object[] ids = Tools.map(values, v -> type.convert(v), Object[]::new);
            if (this.returningResolvedAsterisks.size() == 1 && new FieldsImpl(this.returningResolvedAsterisks).field(returnIdentity) != null) {
                AbstractRow<?> fields2 = Tools.row0(this.returningResolvedAsterisks.toArray(Tools.EMPTY_FIELD));
                for (Object id : ids) {
                    this.getResult().add(Tools.newRecord(true, AbstractRecord.class, fields2, originalConfiguration).operate(record -> {
                        record.values[0] = id;
                        record.originals[0] = id;
                        return record;
                    }));
                }
            } else {
                this.returnedResult = derivedConfiguration.dsl().select(this.returning).from((TableLike<?>)this.table).where(StringUtils.defaultIfNull(this.table.field(returnIdentity), returnIdentity).in(ids)).fetch();
                this.returnedResult.attach(originalConfiguration);
            }
        }
    }

    private final Field<?> returnedIdentity() {
        return this.table.getIdentity() != null ? this.table.getIdentity().getField() : Tools.findAny(this.returningResolvedAsterisks, f -> f.getDataType().identity());
    }

    public final Field<?>[] getFields(ThrowingSupplier<? extends ResultSetMetaData, SQLException> rs) throws SQLException {
        return this.returningResolvedAsterisks.toArray(Tools.EMPTY_FIELD);
    }

    public final Class<? extends Record> getRecordType() {
        return Tools.recordType(this.returningResolvedAsterisks.size());
    }
}

