/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.codegen;

import java.io.StringWriter;
import java.math.BigInteger;
import java.util.List;
import org.jooq.SortOrder;
import org.jooq.codegen.AbstractGenerator;
import org.jooq.codegen.Language;
import org.jooq.codegen.TextWriter;
import org.jooq.impl.QOM;
import org.jooq.meta.CatalogDefinition;
import org.jooq.meta.CheckConstraintDefinition;
import org.jooq.meta.ColumnDefinition;
import org.jooq.meta.DataTypeDefinition;
import org.jooq.meta.Database;
import org.jooq.meta.ForeignKeyDefinition;
import org.jooq.meta.IndexColumnDefinition;
import org.jooq.meta.IndexDefinition;
import org.jooq.meta.PackageDefinition;
import org.jooq.meta.ParameterDefinition;
import org.jooq.meta.PositionedDefinition;
import org.jooq.meta.RoutineDefinition;
import org.jooq.meta.SchemaDefinition;
import org.jooq.meta.SequenceDefinition;
import org.jooq.meta.TableDefinition;
import org.jooq.meta.UniqueKeyDefinition;
import org.jooq.tools.Convert;
import org.jooq.tools.JooqLogger;
import org.jooq.tools.StringUtils;
import org.jooq.util.jaxb.tools.MiniJAXB;
import org.jooq.util.jaxb.tools.XMLAppendable;
import org.jooq.util.xml.jaxb.Catalog;
import org.jooq.util.xml.jaxb.CheckConstraint;
import org.jooq.util.xml.jaxb.Column;
import org.jooq.util.xml.jaxb.Index;
import org.jooq.util.xml.jaxb.IndexColumnUsage;
import org.jooq.util.xml.jaxb.InformationSchema;
import org.jooq.util.xml.jaxb.KeyColumnUsage;
import org.jooq.util.xml.jaxb.Parameter;
import org.jooq.util.xml.jaxb.ParameterMode;
import org.jooq.util.xml.jaxb.ReferentialConstraint;
import org.jooq.util.xml.jaxb.Routine;
import org.jooq.util.xml.jaxb.RoutineType;
import org.jooq.util.xml.jaxb.Schema;
import org.jooq.util.xml.jaxb.Sequence;
import org.jooq.util.xml.jaxb.Table;
import org.jooq.util.xml.jaxb.TableConstraint;
import org.jooq.util.xml.jaxb.TableConstraintType;
import org.jooq.util.xml.jaxb.TableType;
import org.jooq.util.xml.jaxb.View;

public class XMLGenerator
extends AbstractGenerator {
    private static final JooqLogger log = JooqLogger.getLogger(XMLGenerator.class);

    public XMLGenerator() {
        super(Language.XML);
    }

    @Override
    public void generate0(Database db) {
        this.logDatabaseParameters(db);
        log.info("");
        this.logGenerationRemarks(db);
        log.info("");
        log.info("----------------------------------------------------------");
        TextWriter out = new TextWriter(this.getStrategy().getFile("information_schema.xml"), this.targetEncoding);
        log.info("");
        log.info((Object)"Generating XML", out.file().getName());
        log.info("==========================================================");
        InformationSchema is = new InformationSchema();
        boolean hasNonDefaultCatalogs = false;
        for (CatalogDefinition c : db.getCatalogs()) {
            if (StringUtils.isBlank(c.getName())) continue;
            hasNonDefaultCatalogs = true;
            break;
        }
        for (CatalogDefinition c : db.getCatalogs()) {
            String catalogName = c.getOutputName();
            if (hasNonDefaultCatalogs) {
                is.getCatalogs().add(new Catalog().withCatalogName(catalogName).withComment(this.generateCommentsOnCatalogs() ? c.getComment() : null));
            }
            for (SchemaDefinition s2 : c.getSchemata()) {
                String constraintName;
                List<PositionedDefinition> columns;
                Object column;
                Object table;
                String schemaName = s2.getOutputName();
                Schema schema = new Schema();
                schema.setCatalogName(catalogName);
                schema.setSchemaName(schemaName);
                if (this.generateCommentsOnSchemas()) {
                    schema.setComment(s2.getComment());
                }
                is.getSchemata().add(schema);
                for (TableDefinition t2 : s2.getTables()) {
                    String tableName = t2.getOutputName();
                    table = new Table();
                    ((Table)table).setTableCatalog(catalogName);
                    ((Table)table).setTableSchema(schemaName);
                    ((Table)table).setTableName(tableName);
                    ((Table)table).setTableType(t2.isView() ? TableType.VIEW : (t2.isMaterializedView() ? TableType.MATERIALIZED_VIEW : (t2.isTemporary() ? TableType.GLOBAL_TEMPORARY : TableType.BASE_TABLE)));
                    if (this.generateCommentsOnTables()) {
                        ((Table)table).setComment(t2.getComment());
                    }
                    is.getTables().add((Table)table);
                    if (t2.isView() || t2.isMaterializedView()) {
                        View view = new View();
                        view.setTableCatalog(catalogName);
                        view.setTableSchema(schemaName);
                        view.setTableName(tableName);
                        if (this.generateSourcesOnViews()) {
                            view.setViewDefinition(t2.getSource());
                        }
                        is.getViews().add(view);
                    }
                    for (ColumnDefinition co : t2.getColumns()) {
                        String columnName = co.getOutputName();
                        DataTypeDefinition type = co.getType();
                        column = new Column();
                        ((Column)column).setTableCatalog(catalogName);
                        ((Column)column).setTableSchema(schemaName);
                        ((Column)column).setTableName(tableName);
                        ((Column)column).setColumnName(columnName);
                        if (this.generateCommentsOnColumns()) {
                            ((Column)column).setComment(co.getComment());
                        }
                        ((Column)column).setCharacterMaximumLength(type.getLength());
                        ((Column)column).setColumnDefault(type.getDefaultValue());
                        ((Column)column).setDataType(type.getType());
                        if (co.isIdentity()) {
                            ((Column)column).setIdentityGeneration("YES");
                        }
                        ((Column)column).setIsNullable(type.isNullable());
                        ((Column)column).setNumericPrecision(type.getPrecision());
                        ((Column)column).setNumericScale(type.getScale());
                        ((Column)column).setOrdinalPosition(co.getPosition());
                        ((Column)column).setReadonly(co.isReadonly());
                        if (type.isComputed()) {
                            ((Column)column).setIsGenerated(type.isComputed());
                            ((Column)column).setGenerationExpression(type.getGeneratedAlwaysAs());
                            ((Column)column).setGenerationOption(type.getGenerationOption() == QOM.GenerationOption.VIRTUAL ? "VIRTUAL" : (type.getGenerationOption() == QOM.GenerationOption.STORED ? "STORED" : null));
                        }
                        is.getColumns().add((Column)column);
                    }
                }
                for (IndexDefinition i : db.getIndexes(s2)) {
                    String indexName = i.getOutputName();
                    table = i.getTable();
                    columns = i.getIndexColumns();
                    Index index = new Index();
                    index.setIndexCatalog(catalogName);
                    index.setIndexSchema(schemaName);
                    index.setIndexName(indexName);
                    if (this.generateCommentsOnKeys()) {
                        index.setComment(i.getComment());
                    }
                    index.setTableCatalog(table.getCatalog().getOutputName());
                    index.setTableSchema(table.getSchema().getOutputName());
                    index.setTableName(table.getOutputName());
                    index.setIsUnique(i.isUnique());
                    is.getIndexes().add(index);
                    for (int j = 0; j < columns.size(); ++j) {
                        IndexColumnDefinition indexColumn = (IndexColumnDefinition)columns.get(j);
                        column = indexColumn.getColumn();
                        IndexColumnUsage ic = new IndexColumnUsage();
                        ic.setIndexCatalog(catalogName);
                        ic.setIndexSchema(schemaName);
                        ic.setIndexName(indexName);
                        ic.setColumnName(column.getOutputName());
                        ic.setOrdinalPosition(j + 1);
                        ic.setIsDescending(indexColumn.getSortOrder() == SortOrder.DESC);
                        ic.setTableCatalog(table.getCatalog().getOutputName());
                        ic.setTableSchema(table.getSchema().getOutputName());
                        ic.setTableName(table.getOutputName());
                        is.getIndexColumnUsages().add(ic);
                    }
                }
                for (UniqueKeyDefinition u : db.getKeys(s2)) {
                    constraintName = u.getOutputName();
                    table = u.getTable();
                    columns = u.getKeyColumns();
                    TableConstraint tc = new TableConstraint();
                    tc.setConstraintCatalog(catalogName);
                    tc.setConstraintSchema(schemaName);
                    tc.setConstraintName(constraintName);
                    tc.setConstraintType(u.isPrimaryKey() ? TableConstraintType.PRIMARY_KEY : TableConstraintType.UNIQUE);
                    if (this.generateCommentsOnKeys()) {
                        tc.setComment(u.getComment());
                    }
                    tc.setTableCatalog(table.getCatalog().getOutputName());
                    tc.setTableSchema(table.getSchema().getOutputName());
                    tc.setTableName(table.getOutputName());
                    tc.setEnforced(u.enforced());
                    is.getTableConstraints().add(tc);
                    for (int i = 0; i < columns.size(); ++i) {
                        ColumnDefinition column2 = (ColumnDefinition)columns.get(i);
                        KeyColumnUsage kc = new KeyColumnUsage();
                        kc.setConstraintCatalog(catalogName);
                        kc.setConstraintSchema(schemaName);
                        kc.setConstraintName(constraintName);
                        kc.setColumnName(column2.getOutputName());
                        kc.setOrdinalPosition(i + 1);
                        kc.setTableCatalog(table.getCatalog().getOutputName());
                        kc.setTableSchema(table.getSchema().getOutputName());
                        kc.setTableName(table.getOutputName());
                        is.getKeyColumnUsages().add(kc);
                    }
                }
                for (ForeignKeyDefinition f : db.getForeignKeys(s2)) {
                    constraintName = f.getOutputName();
                    UniqueKeyDefinition referenced = f.getReferencedKey();
                    TableDefinition table2 = f.getKeyTable();
                    List<ColumnDefinition> columns2 = f.getKeyColumns();
                    TableConstraint tc = new TableConstraint();
                    tc.setConstraintCatalog(catalogName);
                    tc.setConstraintSchema(schemaName);
                    tc.setConstraintName(constraintName);
                    tc.setConstraintType(TableConstraintType.FOREIGN_KEY);
                    if (this.generateCommentsOnKeys()) {
                        tc.setComment(f.getComment());
                    }
                    tc.setTableCatalog(table2.getCatalog().getOutputName());
                    tc.setTableSchema(table2.getSchema().getOutputName());
                    tc.setTableName(table2.getOutputName());
                    tc.setEnforced(f.enforced());
                    ReferentialConstraint rc = new ReferentialConstraint();
                    rc.setConstraintCatalog(catalogName);
                    rc.setConstraintSchema(schemaName);
                    rc.setConstraintName(constraintName);
                    rc.setUniqueConstraintCatalog(referenced.getCatalog().getOutputName());
                    rc.setUniqueConstraintSchema(referenced.getSchema().getOutputName());
                    rc.setUniqueConstraintName(referenced.getOutputName());
                    is.getTableConstraints().add(tc);
                    is.getReferentialConstraints().add(rc);
                    for (int i = 0; i < columns2.size(); ++i) {
                        ColumnDefinition column3 = columns2.get(i);
                        KeyColumnUsage kc = new KeyColumnUsage();
                        kc.setConstraintCatalog(catalogName);
                        kc.setConstraintSchema(schemaName);
                        kc.setConstraintName(constraintName);
                        kc.setColumnName(column3.getOutputName());
                        kc.setOrdinalPosition(i + 1);
                        kc.setTableCatalog(table2.getCatalog().getOutputName());
                        kc.setTableSchema(table2.getSchema().getOutputName());
                        kc.setTableName(table2.getOutputName());
                        is.getKeyColumnUsages().add(kc);
                    }
                }
                for (CheckConstraintDefinition ch : db.getCheckConstraints(s2)) {
                    constraintName = ch.getOutputName();
                    table = ch.getTable();
                    TableConstraint tc = new TableConstraint();
                    tc.setConstraintCatalog(catalogName);
                    tc.setConstraintSchema(schemaName);
                    tc.setConstraintName(constraintName);
                    tc.setConstraintType(TableConstraintType.CHECK);
                    if (this.generateCommentsOnKeys()) {
                        tc.setComment(ch.getComment());
                    }
                    tc.setTableCatalog(table.getCatalog().getOutputName());
                    tc.setTableSchema(table.getSchema().getOutputName());
                    tc.setTableName(table.getOutputName());
                    tc.setEnforced(ch.enforced());
                    is.getTableConstraints().add(tc);
                    CheckConstraint cc = new CheckConstraint();
                    cc.setConstraintCatalog(catalogName);
                    cc.setConstraintSchema(schemaName);
                    cc.setConstraintName(constraintName);
                    cc.setCheckClause(ch.getCheckClause());
                    is.getCheckConstraints().add(cc);
                }
                for (SequenceDefinition se : db.getSequences(s2)) {
                    String sequenceName = se.getOutputName();
                    DataTypeDefinition type = se.getType();
                    Sequence sequence = new Sequence();
                    sequence.setSequenceCatalog(catalogName);
                    sequence.setSequenceSchema(schemaName);
                    sequence.setSequenceName(sequenceName);
                    if (this.generateCommentsOnSequences()) {
                        sequence.setComment(se.getComment());
                    }
                    sequence.setCharacterMaximumLength(type.getLength());
                    sequence.setDataType(type.getType());
                    sequence.setNumericPrecision(type.getPrecision());
                    sequence.setNumericScale(type.getScale());
                    sequence.setStartValue(Convert.convert((Object)se.getStartWith(), BigInteger.class));
                    sequence.setIncrement(Convert.convert((Object)se.getIncrementBy(), BigInteger.class));
                    sequence.setMinimumValue(Convert.convert((Object)se.getMinvalue(), BigInteger.class));
                    sequence.setMaximumValue(Convert.convert((Object)se.getMaxvalue(), BigInteger.class));
                    sequence.setCycleOption(se.getCycle());
                    sequence.setCache(Convert.convert((Object)se.getCache(), BigInteger.class));
                    is.getSequences().add(sequence);
                }
                for (PackageDefinition pkg : db.getPackages(s2)) {
                    for (RoutineDefinition r : pkg.getRoutines()) {
                        this.exportRoutine(is, r, catalogName, schemaName);
                    }
                }
                for (RoutineDefinition r : db.getRoutines(s2)) {
                    this.exportRoutine(is, r, catalogName, schemaName);
                }
            }
        }
        StringWriter writer = new StringWriter();
        MiniJAXB.marshal((XMLAppendable)is, writer);
        out.print(writer.toString());
        out.close();
    }

    private void exportRoutine(InformationSchema is, RoutineDefinition r, String catalogName, String schemaName) {
        String specificName = r.getName() + (String)(StringUtils.isBlank(r.getOverload()) ? "" : "_" + r.getOverload());
        Routine routine = new Routine();
        routine.setRoutineCatalog(catalogName);
        routine.setSpecificCatalog(catalogName);
        routine.setRoutineSchema(schemaName);
        routine.setSpecificSchema(schemaName);
        if (r.getPackage() != null) {
            routine.setRoutinePackage(r.getPackage().getName());
            routine.setSpecificPackage(r.getPackage().getName());
        }
        routine.setRoutineName(r.getName());
        routine.setSpecificName(specificName);
        if (this.generateCommentsOnRoutines()) {
            routine.setComment(r.getComment());
        }
        if (r.getReturnValue() == null) {
            routine.setRoutineType(RoutineType.PROCEDURE);
        } else {
            routine.setRoutineType(RoutineType.FUNCTION);
            routine.setDataType(r.getReturnType().getType());
            routine.setCharacterMaximumLength(r.getReturnType().getLength());
            routine.setNumericPrecision(r.getReturnType().getPrecision());
            routine.setNumericScale(r.getReturnType().getScale());
        }
        is.getRoutines().add(routine);
        int i = 1;
        for (ParameterDefinition p : r.getAllParameters()) {
            if (p == r.getReturnValue()) continue;
            Parameter parameter = new Parameter();
            parameter.setSpecificCatalog(catalogName);
            parameter.setSpecificSchema(schemaName);
            if (r.getPackage() != null) {
                parameter.setSpecificPackage(r.getPackage().getName());
            }
            parameter.setSpecificName(specificName);
            parameter.setOrdinalPosition(i++);
            parameter.setParameterName(p.getName());
            if (this.generateCommentsOnParameters()) {
                parameter.setComment(p.getComment());
            }
            boolean in = r.getInParameters().contains(p);
            boolean out = r.getOutParameters().contains(p);
            if (in && out) {
                parameter.setParameterMode(ParameterMode.INOUT);
            } else if (in) {
                parameter.setParameterMode(ParameterMode.IN);
            } else if (out) {
                parameter.setParameterMode(ParameterMode.OUT);
            }
            parameter.setDataType(p.getType().getType());
            parameter.setCharacterMaximumLength(p.getType().getLength());
            parameter.setNumericPrecision(p.getType().getPrecision());
            parameter.setNumericScale(p.getType().getScale());
            parameter.setParameterDefault(p.getType().getDefaultValue());
            is.getParameters().add(parameter);
        }
    }
}

