/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.codegen;

import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jooq.codegen.DefaultGeneratorStrategy;
import org.jooq.codegen.GeneratorStrategy;
import org.jooq.meta.AttributeDefinition;
import org.jooq.meta.CatalogDefinition;
import org.jooq.meta.ColumnDefinition;
import org.jooq.meta.Definition;
import org.jooq.meta.EmbeddableDefinition;
import org.jooq.meta.EnumDefinition;
import org.jooq.meta.ForeignKeyDefinition;
import org.jooq.meta.IndexDefinition;
import org.jooq.meta.InverseForeignKeyDefinition;
import org.jooq.meta.ManyToManyKeyDefinition;
import org.jooq.meta.Patterns;
import org.jooq.meta.RoutineDefinition;
import org.jooq.meta.SchemaDefinition;
import org.jooq.meta.SequenceDefinition;
import org.jooq.meta.TableDefinition;
import org.jooq.meta.UDTDefinition;
import org.jooq.meta.UniqueKeyDefinition;
import org.jooq.meta.jaxb.MatcherRule;
import org.jooq.meta.jaxb.MatcherTransformType;
import org.jooq.meta.jaxb.Matchers;
import org.jooq.meta.jaxb.MatchersAttributeType;
import org.jooq.meta.jaxb.MatchersCatalogType;
import org.jooq.meta.jaxb.MatchersEmbeddableType;
import org.jooq.meta.jaxb.MatchersEnumType;
import org.jooq.meta.jaxb.MatchersFieldType;
import org.jooq.meta.jaxb.MatchersForeignKeyType;
import org.jooq.meta.jaxb.MatchersIndexType;
import org.jooq.meta.jaxb.MatchersPrimaryKeyType;
import org.jooq.meta.jaxb.MatchersRoutineType;
import org.jooq.meta.jaxb.MatchersSchemaType;
import org.jooq.meta.jaxb.MatchersSequenceType;
import org.jooq.meta.jaxb.MatchersTableType;
import org.jooq.meta.jaxb.MatchersUDTType;
import org.jooq.meta.jaxb.MatchersUniqueKeyType;
import org.jooq.tools.StringUtils;

public class MatcherStrategy
extends DefaultGeneratorStrategy {
    private final Matchers matchers;
    private final Patterns patterns;

    public MatcherStrategy(Matchers matchers) {
        this(matchers, new Patterns());
    }

    public MatcherStrategy(Matchers matchers, Patterns patterns) {
        this.matchers = matchers;
        this.patterns = patterns;
    }

    public Matchers getMatchers() {
        return this.matchers;
    }

    public Patterns getPatterns() {
        return this.patterns;
    }

    private final String match(Definition definition, String expression, MatcherRule rule) {
        if (rule != null) {
            return this.match(definition, expression, rule.getExpression(), rule.getTransform());
        }
        return null;
    }

    private final String match(String name, String expression, MatcherRule rule) {
        if (rule != null) {
            return this.match(name, expression, rule.getExpression(), rule.getTransform());
        }
        return null;
    }

    private final String match(Definition definition, String expression, String ruleExpression) {
        return this.match(definition, expression, ruleExpression, null);
    }

    private final String match(Definition definition, String expression, String ruleExpression, MatcherTransformType ruleTransformType) {
        String result = this.match(definition.getName(), expression, ruleExpression, ruleTransformType);
        if (result != null) {
            return result;
        }
        return this.match(definition.getQualifiedName(), expression, ruleExpression, ruleTransformType);
    }

    private final String match(String name, String expression, String ruleExpression, MatcherTransformType ruleTransformType) {
        Pattern p;
        Matcher m4;
        if (ruleTransformType != null && ruleExpression == null) {
            ruleExpression = "$0";
        }
        if (ruleExpression != null && (m4 = (p = this.patterns.pattern(StringUtils.defaultIfEmpty(expression, "^.*$").trim())).matcher(name)).matches()) {
            return this.transform(m4.replaceAll(ruleExpression), ruleTransformType);
        }
        return null;
    }

    private final String transform(String string, MatcherTransformType transform) {
        if (transform == null) {
            return string;
        }
        switch (transform) {
            case AS_IS: {
                return string;
            }
            case LOWER: {
                return string.toLowerCase(this.getTargetLocale());
            }
            case LOWER_FIRST_LETTER: {
                return StringUtils.toLC(string);
            }
            case UPPER: {
                return string.toUpperCase(this.getTargetLocale());
            }
            case UPPER_FIRST_LETTER: {
                return StringUtils.toUC(string);
            }
            case CAMEL: {
                return StringUtils.toCamelCaseLC(string);
            }
            case PASCAL: {
                return StringUtils.toCamelCase(string);
            }
        }
        throw new UnsupportedOperationException("Transform Type not supported : " + String.valueOf((Object)transform));
    }

    private final List<MatchersCatalogType> catalogs(Definition definition) {
        if (definition instanceof CatalogDefinition) {
            return this.matchers.getCatalogs();
        }
        return Collections.emptyList();
    }

    private final List<MatchersSchemaType> schemas(Definition definition) {
        if (definition instanceof SchemaDefinition) {
            return this.matchers.getSchemas();
        }
        return Collections.emptyList();
    }

    private final List<MatchersTableType> tables(Definition definition) {
        if (definition instanceof TableDefinition) {
            return this.matchers.getTables();
        }
        return Collections.emptyList();
    }

    private final List<MatchersIndexType> indexes(Definition definition) {
        if (definition instanceof IndexDefinition) {
            return this.matchers.getIndexes();
        }
        return Collections.emptyList();
    }

    private final List<MatchersPrimaryKeyType> primaryKeys(Definition definition) {
        UniqueKeyDefinition u;
        if (definition instanceof UniqueKeyDefinition && (u = (UniqueKeyDefinition)definition).isPrimaryKey()) {
            return this.matchers.getPrimaryKeys();
        }
        return Collections.emptyList();
    }

    private final List<MatchersUniqueKeyType> uniqueKeys(Definition definition) {
        UniqueKeyDefinition u;
        if (definition instanceof UniqueKeyDefinition && !(u = (UniqueKeyDefinition)definition).isPrimaryKey()) {
            return this.matchers.getUniqueKeys();
        }
        return Collections.emptyList();
    }

    private final List<MatchersForeignKeyType> foreignKeys(Definition definition) {
        if (definition instanceof ForeignKeyDefinition) {
            return this.matchers.getForeignKeys();
        }
        return Collections.emptyList();
    }

    private final List<MatchersForeignKeyType> inverseForeignKeys(Definition definition) {
        if (definition instanceof InverseForeignKeyDefinition) {
            return this.matchers.getForeignKeys();
        }
        return Collections.emptyList();
    }

    private final List<MatchersForeignKeyType> manyToManyKeys(Definition definition) {
        if (definition instanceof ManyToManyKeyDefinition) {
            return this.matchers.getForeignKeys();
        }
        return Collections.emptyList();
    }

    private final List<MatchersFieldType> fields(Definition definition) {
        if (definition instanceof ColumnDefinition) {
            return this.matchers.getFields();
        }
        return Collections.emptyList();
    }

    private final List<MatchersRoutineType> routines(Definition definition) {
        if (definition instanceof RoutineDefinition) {
            return this.matchers.getRoutines();
        }
        return Collections.emptyList();
    }

    private final List<MatchersSequenceType> sequences(Definition definition) {
        if (definition instanceof SequenceDefinition) {
            return this.matchers.getSequences();
        }
        return Collections.emptyList();
    }

    private final List<MatchersEnumType> enums(Definition definition) {
        if (definition instanceof EnumDefinition) {
            return this.matchers.getEnums();
        }
        return Collections.emptyList();
    }

    private final List<MatchersEmbeddableType> embeddables(Definition definition) {
        if (definition instanceof EmbeddableDefinition) {
            return this.matchers.getEmbeddables();
        }
        return Collections.emptyList();
    }

    private final List<MatchersUDTType> udts(Definition definition) {
        if (definition instanceof UDTDefinition) {
            return this.matchers.getUdts();
        }
        return Collections.emptyList();
    }

    private final List<MatchersAttributeType> attributes(Definition definition) {
        if (definition instanceof AttributeDefinition) {
            return this.matchers.getAttributes();
        }
        return Collections.emptyList();
    }

    private final List<String> split(String result) {
        return Stream.of(result.split(",")).map(String::trim).collect(Collectors.toList());
    }

    @Override
    public String getJavaIdentifier(Definition definition) {
        String result;
        for (MatchersCatalogType catalogs : this.catalogs(definition)) {
            result = this.match(definition, catalogs.getExpression(), catalogs.getCatalogIdentifier());
            if (result == null) continue;
            return result;
        }
        for (MatchersSchemaType schemas : this.schemas(definition)) {
            result = this.match(definition, schemas.getExpression(), schemas.getSchemaIdentifier());
            if (result == null) continue;
            return result;
        }
        for (MatchersTableType tables : this.tables(definition)) {
            result = this.match(definition, tables.getExpression(), tables.getTableIdentifier());
            if (result == null) continue;
            return result;
        }
        for (MatchersFieldType fields2 : this.fields(definition)) {
            result = this.match(definition, fields2.getExpression(), fields2.getFieldIdentifier());
            if (result == null) continue;
            return result;
        }
        for (MatchersSequenceType sequences : this.sequences(definition)) {
            result = this.match(definition, sequences.getExpression(), sequences.getSequenceIdentifier());
            if (result == null) continue;
            return result;
        }
        for (MatchersIndexType index : this.indexes(definition)) {
            result = this.match(definition, index.getExpression(), index.getKeyIdentifier());
            if (result == null) continue;
            return result;
        }
        for (MatchersPrimaryKeyType primaryKey : this.primaryKeys(definition)) {
            result = this.match(definition, primaryKey.getExpression(), primaryKey.getKeyIdentifier());
            if (result == null) continue;
            return result;
        }
        for (MatchersUniqueKeyType uniqueKey : this.uniqueKeys(definition)) {
            result = this.match(definition, uniqueKey.getExpression(), uniqueKey.getKeyIdentifier());
            if (result == null) continue;
            return result;
        }
        for (MatchersForeignKeyType foreignKey : this.foreignKeys(definition)) {
            result = this.match(definition, foreignKey.getExpression(), foreignKey.getKeyIdentifier());
            if (result == null) continue;
            return result;
        }
        for (MatchersForeignKeyType foreignKey : this.inverseForeignKeys(definition)) {
            result = this.match(definition, foreignKey.getExpression(), foreignKey.getKeyIdentifier());
            if (result == null) continue;
            return result;
        }
        for (MatchersUDTType udt : this.udts(definition)) {
            result = this.match(definition, udt.getExpression(), udt.getUdtIdentifier());
            if (result == null) continue;
            return result;
        }
        for (MatchersAttributeType attribute : this.attributes(definition)) {
            result = this.match(definition, attribute.getExpression(), attribute.getAttributeIdentifier());
            if (result == null) continue;
            return result;
        }
        return super.getJavaIdentifier(definition);
    }

    @Override
    public String getJavaSetterName(Definition definition, GeneratorStrategy.Mode mode) {
        String result;
        for (MatchersFieldType fields2 : this.fields(definition)) {
            result = this.match(definition, fields2.getExpression(), fields2.getFieldSetter());
            if (result == null) continue;
            return result;
        }
        for (MatchersAttributeType attribute : this.attributes(definition)) {
            result = this.match(definition, attribute.getExpression(), attribute.getAttributeSetter());
            if (result == null) continue;
            return result;
        }
        return super.getJavaSetterName(definition, mode);
    }

    @Override
    public String getJavaGetterName(Definition definition, GeneratorStrategy.Mode mode) {
        String result;
        for (MatchersFieldType fields2 : this.fields(definition)) {
            result = this.match(definition, fields2.getExpression(), fields2.getFieldGetter());
            if (result == null) continue;
            return result;
        }
        for (MatchersAttributeType attribute : this.attributes(definition)) {
            result = this.match(definition, attribute.getExpression(), attribute.getAttributeGetter());
            if (result == null) continue;
            return result;
        }
        return super.getJavaGetterName(definition, mode);
    }

    @Override
    public String getJavaMethodName(Definition definition, GeneratorStrategy.Mode mode) {
        String result;
        for (MatchersRoutineType routines : this.routines(definition)) {
            result = this.match(definition, routines.getExpression(), routines.getRoutineMethod());
            if (result == null) continue;
            return result;
        }
        for (MatchersForeignKeyType foreignKeys : this.foreignKeys(definition)) {
            result = this.match(definition, foreignKeys.getExpression(), foreignKeys.getPathMethodName());
            if (result == null) continue;
            return result;
        }
        for (MatchersForeignKeyType inverseForeignKeys : this.inverseForeignKeys(definition)) {
            result = this.match(definition, inverseForeignKeys.getExpression(), inverseForeignKeys.getPathMethodNameInverse());
            if (result == null) continue;
            return result;
        }
        for (MatchersForeignKeyType manyToManyKeys : this.manyToManyKeys(definition)) {
            result = this.match(definition, manyToManyKeys.getExpression(), manyToManyKeys.getPathMethodNameManyToMany());
            if (result == null) continue;
            return result;
        }
        return super.getJavaMethodName(definition, mode);
    }

    @Override
    public String getJavaClassExtends(Definition definition, GeneratorStrategy.Mode mode) {
        String result;
        for (MatchersCatalogType catalogs : this.catalogs(definition)) {
            result = this.match(definition, catalogs.getExpression(), catalogs.getCatalogExtends());
            if (result == null) continue;
            return result;
        }
        for (MatchersSchemaType schemas : this.schemas(definition)) {
            result = this.match(definition, schemas.getExpression(), schemas.getSchemaExtends());
            if (result == null) continue;
            return result;
        }
        for (MatchersTableType tables : this.tables(definition)) {
            result = null;
            switch (mode) {
                case POJO: {
                    result = this.match(definition, tables.getExpression(), tables.getPojoExtends());
                    break;
                }
                case RECORD: {
                    result = this.match(definition, tables.getExpression(), tables.getRecordExtends());
                    break;
                }
                case DAO: {
                    result = this.match(definition, tables.getExpression(), tables.getDaoExtends());
                    break;
                }
                case PATH: {
                    result = this.match(definition, tables.getExpression(), tables.getPathExtends());
                    break;
                }
                case DEFAULT: {
                    result = this.match(definition, tables.getExpression(), tables.getTableExtends());
                }
            }
            if (result == null) continue;
            return result;
        }
        for (MatchersEmbeddableType embeddables : this.embeddables(definition)) {
            result = null;
            switch (mode) {
                case POJO: {
                    result = this.match(definition, embeddables.getExpression(), embeddables.getPojoExtends());
                    break;
                }
                case RECORD: {
                    result = this.match(definition, embeddables.getExpression(), embeddables.getRecordExtends());
                }
            }
            if (result == null) continue;
            return result;
        }
        for (MatchersUDTType udt : this.udts(definition)) {
            result = null;
            switch (mode) {
                case POJO: {
                    result = this.match(definition, udt.getExpression(), udt.getPojoExtends());
                    break;
                }
                case RECORD: {
                    result = this.match(definition, udt.getExpression(), udt.getRecordExtends());
                    break;
                }
                case PATH: {
                    result = this.match(definition, udt.getExpression(), udt.getPathExtends());
                    break;
                }
                case DEFAULT: {
                    result = this.match(definition, udt.getExpression(), udt.getUdtExtends());
                }
            }
            if (result == null) continue;
            return result;
        }
        for (MatchersRoutineType routine : this.routines(definition)) {
            result = this.match(definition, routine.getExpression(), routine.getRoutineExtends());
            if (result == null) continue;
            return result;
        }
        return super.getJavaClassExtends(definition, mode);
    }

    @Override
    public List<String> getJavaClassImplements(Definition definition, GeneratorStrategy.Mode mode) {
        String result;
        for (MatchersCatalogType catalogs : this.catalogs(definition)) {
            result = this.match(definition, catalogs.getExpression(), catalogs.getCatalogImplements());
            if (result == null) continue;
            return this.split(result);
        }
        for (MatchersSchemaType schemas : this.schemas(definition)) {
            result = this.match(definition, schemas.getExpression(), schemas.getSchemaImplements());
            if (result == null) continue;
            return this.split(result);
        }
        for (MatchersTableType tables : this.tables(definition)) {
            result = null;
            switch (mode) {
                case DEFAULT: {
                    result = this.match(definition, tables.getExpression(), tables.getTableImplements());
                    break;
                }
                case DAO: {
                    result = this.match(definition, tables.getExpression(), tables.getDaoImplements());
                    break;
                }
                case INTERFACE: {
                    result = this.match(definition, tables.getExpression(), tables.getInterfaceImplements());
                    break;
                }
                case POJO: {
                    result = this.match(definition, tables.getExpression(), tables.getPojoImplements());
                    break;
                }
                case RECORD: {
                    result = this.match(definition, tables.getExpression(), tables.getRecordImplements());
                    break;
                }
                case PATH: {
                    result = this.match(definition, tables.getExpression(), tables.getTableImplements());
                }
            }
            if (result == null) continue;
            return this.split(result);
        }
        for (MatchersEmbeddableType embeddables : this.embeddables(definition)) {
            result = null;
            switch (mode) {
                case INTERFACE: {
                    result = this.match(definition, embeddables.getExpression(), embeddables.getInterfaceImplements());
                    break;
                }
                case POJO: {
                    result = this.match(definition, embeddables.getExpression(), embeddables.getPojoImplements());
                    break;
                }
                case RECORD: 
                case DEFAULT: {
                    result = this.match(definition, embeddables.getExpression(), embeddables.getRecordImplements());
                }
            }
            if (result == null) continue;
            return this.split(result);
        }
        for (MatchersUDTType udt : this.udts(definition)) {
            result = null;
            switch (mode) {
                case DEFAULT: {
                    result = this.match(definition, udt.getExpression(), udt.getUdtImplements());
                    break;
                }
                case INTERFACE: {
                    result = this.match(definition, udt.getExpression(), udt.getInterfaceImplements());
                    break;
                }
                case POJO: {
                    result = this.match(definition, udt.getExpression(), udt.getPojoImplements());
                    break;
                }
                case RECORD: {
                    result = this.match(definition, udt.getExpression(), udt.getRecordImplements());
                    break;
                }
                case PATH: {
                    result = this.match(definition, udt.getExpression(), udt.getPathImplements());
                }
            }
            if (result == null) continue;
            return this.split(result);
        }
        for (MatchersRoutineType routines : this.routines(definition)) {
            result = this.match(definition, routines.getExpression(), routines.getRoutineImplements());
            if (result == null) continue;
            return this.split(result);
        }
        for (MatchersEnumType enums : this.enums(definition)) {
            result = this.match(definition, enums.getExpression(), enums.getEnumImplements());
            if (result == null) continue;
            return this.split(result);
        }
        return super.getJavaClassImplements(definition, mode);
    }

    @Override
    public String getJavaClassName(Definition definition, GeneratorStrategy.Mode mode) {
        String result;
        for (MatchersCatalogType catalogs : this.catalogs(definition)) {
            result = this.match(definition, catalogs.getExpression(), catalogs.getCatalogClass());
            if (result == null) continue;
            return result;
        }
        for (MatchersSchemaType schemas : this.schemas(definition)) {
            result = this.match(definition, schemas.getExpression(), schemas.getSchemaClass());
            if (result == null) continue;
            return result;
        }
        for (MatchersTableType tables : this.tables(definition)) {
            result = null;
            switch (mode) {
                case DEFAULT: {
                    result = this.match(definition, tables.getExpression(), tables.getTableClass());
                    break;
                }
                case DAO: {
                    result = this.match(definition, tables.getExpression(), tables.getDaoClass());
                    break;
                }
                case INTERFACE: {
                    result = this.match(definition, tables.getExpression(), tables.getInterfaceClass());
                    break;
                }
                case POJO: {
                    result = this.match(definition, tables.getExpression(), tables.getPojoClass());
                    break;
                }
                case RECORD: {
                    result = this.match(definition, tables.getExpression(), tables.getRecordClass());
                    break;
                }
                case PATH: {
                    result = this.match(definition, tables.getExpression(), this.pathDefault(tables.getPathClass()));
                }
            }
            if (result == null) continue;
            return result;
        }
        for (MatchersEmbeddableType embeddables : this.embeddables(definition)) {
            result = null;
            switch (mode) {
                case INTERFACE: {
                    result = this.match(definition, embeddables.getExpression(), embeddables.getInterfaceClass());
                    break;
                }
                case POJO: {
                    result = this.match(definition, embeddables.getExpression(), embeddables.getPojoClass());
                    break;
                }
                case RECORD: 
                case DEFAULT: {
                    result = this.match(definition, embeddables.getExpression(), embeddables.getRecordClass());
                }
            }
            if (result == null) continue;
            return result;
        }
        for (MatchersUDTType udt : this.udts(definition)) {
            result = null;
            switch (mode) {
                case DEFAULT: {
                    result = this.match(definition, udt.getExpression(), udt.getUdtClass());
                    break;
                }
                case INTERFACE: {
                    result = this.match(definition, udt.getExpression(), udt.getInterfaceClass());
                    break;
                }
                case POJO: {
                    result = this.match(definition, udt.getExpression(), udt.getPojoClass());
                    break;
                }
                case RECORD: {
                    result = this.match(definition, udt.getExpression(), udt.getRecordClass());
                    break;
                }
                case PATH: {
                    result = this.match(definition, udt.getExpression(), udt.getPathClass());
                }
            }
            if (result == null) continue;
            return result;
        }
        for (MatchersRoutineType routines : this.routines(definition)) {
            result = this.match(definition, routines.getExpression(), routines.getRoutineClass());
            if (result == null) continue;
            return result;
        }
        for (MatchersEnumType enums : this.enums(definition)) {
            result = this.match(definition, enums.getExpression(), enums.getEnumClass());
            if (result == null) continue;
            return result;
        }
        return super.getJavaClassName(definition, mode);
    }

    private final MatcherRule pathDefault(MatcherRule rule) {
        if (rule == null) {
            return null;
        }
        if (!StringUtils.isBlank(rule.getExpression())) {
            return rule;
        }
        MatcherTransformType transform = rule.getTransform();
        if (transform != null) {
            return new MatcherRule().withTransform(transform).withExpression("$0_PATH");
        }
        return rule;
    }

    @Override
    public String getJavaEnumLiteral(EnumDefinition definition, String literal) {
        for (MatchersEnumType enums : this.enums(definition)) {
            String result = this.match((Definition)definition, enums.getExpression(), enums.getEnumClass());
            if (result != null) {
                result = this.match(literal, null, enums.getEnumLiteral());
            }
            if (result == null) continue;
            return result;
        }
        return super.getJavaEnumLiteral(definition, literal);
    }

    @Override
    public String getJavaPackageName(Definition definition, GeneratorStrategy.Mode mode) {
        return super.getJavaPackageName(definition, mode);
    }

    @Override
    public String getJavaMemberName(Definition definition, GeneratorStrategy.Mode mode) {
        String result;
        for (MatchersFieldType fields2 : this.fields(definition)) {
            result = this.match(definition, fields2.getExpression(), fields2.getFieldMember());
            if (result == null) continue;
            return result;
        }
        for (MatchersAttributeType attribute : this.attributes(definition)) {
            result = this.match(definition, attribute.getExpression(), attribute.getAttributeMember());
            if (result == null) continue;
            return result;
        }
        return super.getJavaMemberName(definition, mode);
    }

    @Override
    public String getOverloadSuffix(Definition definition, GeneratorStrategy.Mode mode, String overloadIndex) {
        return super.getOverloadSuffix(definition, mode, overloadIndex);
    }
}

