/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.codegen;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Properties;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.sql.DataSource;
import org.jooq.DSLContext;
import org.jooq.Log;
import org.jooq.SQLDialect;
import org.jooq.Source;
import org.jooq.codegen.ConstantCatalogVersionProvider;
import org.jooq.codegen.ConstantSchemaVersionProvider;
import org.jooq.codegen.Constants;
import org.jooq.codegen.DefaultGeneratorStrategy;
import org.jooq.codegen.Generator;
import org.jooq.codegen.GeneratorException;
import org.jooq.codegen.GeneratorStrategy;
import org.jooq.codegen.JavaGenerator;
import org.jooq.codegen.MatcherStrategy;
import org.jooq.codegen.SQLCatalogVersionProvider;
import org.jooq.codegen.SQLSchemaVersionProvider;
import org.jooq.impl.DSL;
import org.jooq.meta.CatalogVersionProvider;
import org.jooq.meta.ClassUtils;
import org.jooq.meta.Databases;
import org.jooq.meta.SchemaVersionProvider;
import org.jooq.meta.jaxb.CatalogMappingType;
import org.jooq.meta.jaxb.Configuration;
import org.jooq.meta.jaxb.Database;
import org.jooq.meta.jaxb.Generate;
import org.jooq.meta.jaxb.Jdbc;
import org.jooq.meta.jaxb.Logging;
import org.jooq.meta.jaxb.Matchers;
import org.jooq.meta.jaxb.OnError;
import org.jooq.meta.jaxb.Property;
import org.jooq.meta.jaxb.SchemaMappingType;
import org.jooq.meta.jaxb.Strategy;
import org.jooq.meta.jaxb.Target;
import org.jooq.tools.JooqLogger;
import org.jooq.tools.StringUtils;
import org.jooq.tools.jdbc.JDBCUtils;
import org.jooq.tools.reflect.CompileOptions;
import org.jooq.tools.reflect.Reflect;
import org.jooq.util.jaxb.tools.MiniJAXB;

public class GenerationTool {
    public static final String DEFAULT_TARGET_ENCODING = "UTF-8";
    public static final String DEFAULT_TARGET_DIRECTORY = "target/generated-sources/jooq";
    public static final String DEFAULT_TARGET_PACKAGENAME = "org.jooq.generated";
    private static final JooqLogger log = JooqLogger.getLogger(GenerationTool.class);
    private static final JooqLogger unusedLogger = JooqLogger.getLogger(Unused.class);
    private ClassLoader loader;
    private DataSource dataSource;
    private Connection connection;
    private DSLContext ctx;
    private Boolean autoCommit;
    private boolean close;

    public void setClassLoader(ClassLoader loader) {
        this.loader = loader;
    }

    public void setConnection(Connection connection) {
        this.connection = connection;
        this.ctx = DSL.using(connection);
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        String[] files;
        JooqLogger.initSimpleFormatter();
        if (args.length > 0) {
            files = args;
        } else {
            String property = System.getProperty("jooq.codegen.configurationFile");
            if (property != null) {
                files = new String[]{property};
            } else {
                log.error("Usage : GenerationTool <configuration-file>");
                System.exit(-1);
                return;
            }
        }
        for (String file : files) {
            try (InputStream in = GenerationTool.class.getResourceAsStream(file);){
                if (in == null && !file.startsWith("/")) {
                    in = GenerationTool.class.getResourceAsStream("/" + file);
                }
                if (in == null && new File(file).exists()) {
                    in = new FileInputStream(file);
                }
                if (in == null) {
                    log.error("Cannot find " + file + " on classpath, or in directory " + new File(".").getCanonicalPath());
                    log.error("-----------");
                    log.error("Please be sure it is located");
                    log.error("  - on the classpath and qualified as a classpath location.");
                    log.error("  - in the local directory or at a global path in the file system.");
                    System.exit(-1);
                    return;
                }
                Configuration configuration = GenerationTool.load(in);
                GenerationTool.setGlobalLoggingThreshold(configuration);
                log.info((Object)"Initialising properties", file);
                GenerationTool.generate(configuration);
            }
        }
    }

    @Deprecated
    public static void main(Configuration configuration) throws Exception {
        new GenerationTool().run(configuration);
    }

    public static void generate(String xml) throws Exception {
        new GenerationTool().run(GenerationTool.load(new ByteArrayInputStream(xml.getBytes(DEFAULT_TARGET_ENCODING))));
    }

    public static void generate(Configuration configuration) throws Exception {
        new GenerationTool().run(configuration);
    }

    public void run(Configuration configuration) throws Exception {
        try {
            this.run0(configuration);
        }
        catch (Exception e) {
            OnError onError = configuration.getOnError();
            if (onError == null) {
                onError = OnError.FAIL;
            }
            switch (onError) {
                case SILENT: {
                    break;
                }
                case LOG: {
                    log.warn((Object)"Code generation failed", e);
                    break;
                }
                case FAIL: {
                    throw e;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void run0(Configuration configuration) throws Exception {
        DSL.selectOne().toString();
        boolean propertyOverride = "true".equalsIgnoreCase(System.getProperty("jooq.codegen.propertyOverride"));
        if (configuration.getLogging() != null) {
            GenerationTool.setGlobalLoggingThreshold(configuration);
        } else {
            String property = System.getProperty("jooq.codegen.logging");
            if (property != null) {
                try {
                    Logging.valueOf(property);
                }
                catch (IllegalArgumentException e) {
                    log.error((Object)"Unsupported property", "Unsupported value for system property jooq.codegen.logging: " + property + ". Supported values include: " + String.valueOf(Arrays.asList(Logging.values())));
                }
            }
        }
        if (Boolean.getBoolean("jooq.codegen.skip")) {
            log.info("Skipping jOOQ code generation");
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Input configuration", String.valueOf(configuration));
        }
        if (configuration.getBasedir() == null) {
            configuration.setBasedir(new File(".").getAbsolutePath());
        }
        Jdbc j = configuration.getJdbc();
        org.jooq.meta.jaxb.Generator g2 = configuration.getGenerator();
        if (g2 == null) {
            throw new GeneratorException("The <generator/> tag is mandatory. For details, see http://www.jooq.org/xsd/jooq-codegen-3.19.8.xsd");
        }
        if (g2.getDatabase() == null) {
            g2.setDatabase(new Database());
        }
        Database d = g2.getDatabase();
        String databaseName = GenerationTool.trim(d.getName());
        if (g2.getGenerate() == null) {
            g2.setGenerate(new Generate());
        }
        if (g2.getStrategy() == null) {
            g2.setStrategy(new Strategy());
        }
        if (g2.getTarget() == null) {
            g2.setTarget(new Target());
        }
        Locale locale = Locale.getDefault();
        if (!StringUtils.isBlank(g2.getTarget().getLocale())) {
            locale = Locale.forLanguageTag(g2.getTarget().getLocale());
        }
        org.jooq.meta.Database database = null;
        try {
            GeneratorStrategy strategy;
            if (this.connection == null) {
                this.close = true;
                if (this.dataSource != null) {
                    this.setConnection(this.dataSource.getConnection());
                } else {
                    String url = System.getProperty("jooq.codegen.jdbc.url");
                    if (url != null) {
                        j = StringUtils.defaultIfNull(j, new Jdbc());
                        this.set(j, propertyOverride, "jooq.codegen.jdbc.driver", Jdbc::getDriver, Jdbc::setDriver);
                        this.set(j, propertyOverride, "jooq.codegen.jdbc.url", Jdbc::getUrl, Jdbc::setUrl);
                        this.set(j, propertyOverride, "jooq.codegen.jdbc.user", Jdbc::getUser, Jdbc::setUser);
                        this.set(j, propertyOverride, "jooq.codegen.jdbc.username", Jdbc::getUsername, Jdbc::setUsername);
                        this.set(j, propertyOverride, "jooq.codegen.jdbc.password", Jdbc::getPassword, Jdbc::setPassword);
                        this.set(j, propertyOverride, "jooq.codegen.jdbc.autoCommit", Jdbc::isAutoCommit, Jdbc::setAutoCommit, Boolean::valueOf);
                        this.set(j, propertyOverride, "jooq.codegen.jdbc.initScript", Jdbc::getInitScript, Jdbc::setInitScript);
                        this.set(j, propertyOverride, "jooq.codegen.jdbc.initSeparator", Jdbc::getInitSeparator, Jdbc::setInitSeparator);
                    }
                    if (j != null && !StringUtils.isBlank(j.getUrl())) {
                        try {
                            Connection c;
                            Class<?> driver = this.loadClass(this.driverClass(j));
                            Properties properties = this.properties(j.getProperties());
                            if (!properties.containsKey("user")) {
                                properties.put("user", StringUtils.defaultString(StringUtils.defaultString(j.getUser(), j.getUsername())));
                            }
                            if (!properties.containsKey("password")) {
                                properties.put("password", StringUtils.defaultString(j.getPassword()));
                            }
                            if ((c = ((Driver)driver.newInstance()).connect(StringUtils.defaultString(j.getUrl()), properties)) == null) {
                                throw new SQLException("Cannot connect to database using JDBC URL: " + j.getUrl() + ". Please review your JDBC configuration in the code generator configuration.");
                            }
                            this.setConnection(c);
                            if (j.getInitScript() != null) {
                                for (String sql : Source.resolve(j.getInitScript()).readString().split(StringUtils.defaultIfBlank(j.getInitSeparator(), ";"))) {
                                    if (StringUtils.isBlank(sql)) continue;
                                    this.ctx.execute(sql);
                                }
                            }
                        }
                        catch (Exception e) {
                            if (databaseName != null && (databaseName.contains("DDLDatabase") || databaseName.contains("XMLDatabase") || databaseName.contains("JPADatabase"))) {
                                log.warn((Object)"Error while connecting to database. Note that file based database implementations do not need a <jdbc/> configuration in the code generator.", e);
                            }
                            throw e;
                        }
                    }
                }
            }
            j = StringUtils.defaultIfNull(j, new Jdbc());
            if (this.connection != null && j.isAutoCommit() != null) {
                this.autoCommit = this.connection.getAutoCommit();
                this.connection.setAutoCommit(j.isAutoCommit());
            }
            Class<JavaGenerator> generatorClass = !StringUtils.isBlank(g2.getJava()) ? this.compile(g2.getName(), g2.getJava(), Generator.class) : (!StringUtils.isBlank(g2.getName()) ? this.loadClass(GenerationTool.trim(g2.getName())) : JavaGenerator.class);
            Generator generator = (Generator)generatorClass.newInstance();
            Matchers matchers = g2.getStrategy().getMatchers();
            if (matchers != null) {
                strategy = new MatcherStrategy(matchers);
                if (g2.getStrategy().getName() != null) {
                    if (!DefaultGeneratorStrategy.class.getName().equals(g2.getStrategy().getName())) {
                        log.warn("WARNING: Matchers take precedence over custom strategy. Strategy ignored: " + g2.getStrategy().getName());
                    }
                    g2.getStrategy().setName(null);
                }
            } else {
                Class<DefaultGeneratorStrategy> strategyClass = !StringUtils.isBlank(g2.getStrategy().getJava()) ? this.compile(g2.getStrategy().getName(), g2.getStrategy().getJava(), GeneratorStrategy.class) : (!StringUtils.isBlank(g2.getStrategy().getName()) ? this.loadClass(GenerationTool.trim(g2.getStrategy().getName())) : DefaultGeneratorStrategy.class);
                strategy = (GeneratorStrategy)strategyClass.newInstance();
            }
            generator.setStrategy(strategy);
            Class<org.jooq.meta.Database> databaseClass = !StringUtils.isBlank(d.getJava()) ? this.compile(databaseName, d.getJava(), org.jooq.meta.Database.class) : (!StringUtils.isBlank(databaseName) ? this.loadClass(databaseName) : (this.connection != null ? this.databaseClass(this.connection) : this.databaseClass(j)));
            database = databaseClass.newInstance();
            database.setBasedir(configuration.getBasedir());
            database.setProperties(this.properties(d.getProperties()));
            database.setOnError(configuration.getOnError());
            List<CatalogMappingType> catalogs = d.getCatalogs();
            List<SchemaMappingType> schemata = d.getSchemata();
            boolean catalogsEmpty = catalogs.isEmpty();
            boolean schemataEmpty = schemata.isEmpty();
            if (catalogsEmpty) {
                if (StringUtils.isBlank(d.getInputCatalog()) && !StringUtils.isBlank(d.getOutputCatalog())) {
                    log.warn("WARNING: /configuration/generator/database/outputCatalog must be paired with /configuration/generator/database/inputCatalog");
                }
                CatalogMappingType catalog = new CatalogMappingType();
                catalog.setInputCatalog(GenerationTool.trim(d.getInputCatalog()));
                catalog.setOutputCatalog(GenerationTool.trim(d.getOutputCatalog()));
                catalog.setOutputCatalogToDefault(d.isOutputCatalogToDefault());
                catalogs.add(catalog);
                if (!StringUtils.isBlank(catalog.getInputCatalog())) {
                    catalogsEmpty = false;
                }
                if (schemataEmpty) {
                    if (StringUtils.isBlank(d.getInputSchema()) && !StringUtils.isBlank(d.getOutputSchema())) {
                        log.warn("WARNING: /configuration/generator/database/outputSchema must be paired with /configuration/generator/database/inputSchema");
                    }
                    SchemaMappingType schema = new SchemaMappingType();
                    schema.setInputSchema(GenerationTool.trim(d.getInputSchema()));
                    schema.setOutputSchema(GenerationTool.trim(d.getOutputSchema()));
                    schema.setOutputSchemaToDefault(d.isOutputSchemaToDefault());
                    catalog.getSchemata().add(schema);
                    if (!StringUtils.isBlank(schema.getInputSchema())) {
                        schemataEmpty = false;
                    }
                } else {
                    catalog.getSchemata().addAll(schemata);
                    if (!StringUtils.isBlank(d.getInputSchema())) {
                        log.warn("WARNING: Cannot combine configuration properties /configuration/generator/database/inputSchema and /configuration/generator/database/schemata");
                    }
                    if (!StringUtils.isBlank(d.getOutputSchema())) {
                        log.warn("WARNING: Cannot combine configuration properties /configuration/generator/database/outputSchema and /configuration/generator/database/schemata");
                    }
                }
            } else {
                if (!StringUtils.isBlank(d.getInputCatalog())) {
                    log.warn("WARNING: Cannot combine configuration properties /configuration/generator/database/inputCatalog and /configuration/generator/database/catalogs");
                }
                if (!StringUtils.isBlank(d.getOutputCatalog())) {
                    log.warn("WARNING: Cannot combine configuration properties /configuration/generator/database/outputCatalog and /configuration/generator/database/catalogs");
                }
                if (!StringUtils.isBlank(d.getInputSchema())) {
                    log.warn("WARNING: Cannot combine configuration properties /configuration/generator/database/inputSchema and /configuration/generator/database/catalogs");
                }
                if (!StringUtils.isBlank(d.getOutputSchema())) {
                    log.warn("WARNING: Cannot combine configuration properties /configuration/generator/database/outputSchema and /configuration/generator/database/catalogs");
                }
                if (!schemataEmpty) {
                    log.warn("WARNING: Cannot combine configuration properties /configuration/generator/database/catalogs and /configuration/generator/database/schemata");
                }
            }
            for (CatalogMappingType catalog : catalogs) {
                if ("".equals(catalog.getOutputCatalog())) {
                    log.warn("WARNING: Empty <outputCatalog/> should not be used to model default outputCatalogs. Use <outputCatalogToDefault>true</outputCatalogToDefault>, instead. See also: https://github.com/jOOQ/jOOQ/issues/3018");
                }
                if (Boolean.TRUE.equals(catalog.isOutputCatalogToDefault())) {
                    catalog.setOutputCatalog("");
                } else if (catalog.getOutputCatalog() == null) {
                    catalog.setOutputCatalog(GenerationTool.trim(catalog.getInputCatalog()));
                }
                for (SchemaMappingType schema : catalog.getSchemata()) {
                    if (catalogsEmpty && schemataEmpty && StringUtils.isBlank(schema.getInputSchema())) {
                        if (!StringUtils.isBlank(j.getSchema())) {
                            log.warn("WARNING: The configuration property jdbc.Schema is deprecated and will be removed in the future. Use /configuration/generator/database/inputSchema instead");
                        }
                        schema.setInputSchema(GenerationTool.trim(j.getSchema()));
                    }
                    if ("".equals(schema.getOutputSchema())) {
                        log.warn("WARNING: Empty <outputSchema/> should not be used to model default outputSchemas. Use <outputSchemaToDefault>true</outputSchemaToDefault>, instead. See also: https://github.com/jOOQ/jOOQ/issues/3018");
                    }
                    if (Boolean.TRUE.equals(schema.isOutputSchemaToDefault())) {
                        schema.setOutputSchema("");
                        continue;
                    }
                    if (schema.getOutputSchema() != null) continue;
                    schema.setOutputSchema(GenerationTool.trim(schema.getInputSchema()));
                }
            }
            if (catalogsEmpty) {
                log.info("No <inputCatalog/> was provided. Generating ALL available catalogs instead.");
            }
            if (catalogsEmpty && schemataEmpty) {
                log.info("No <inputSchema/> was provided. Generating ALL available schemata instead.");
            }
            database.setConnection(this.connection);
            database.setConfiguredCatalogs(catalogs);
            database.setConfiguredSchemata(schemata);
            if (!StringUtils.isBlank(d.getIncludes())) {
                database.setIncludes(new String[]{d.getIncludes()});
            }
            if (!StringUtils.isBlank(d.getExcludes())) {
                database.setExcludes(new String[]{d.getExcludes()});
            }
            database.setIncludeSql(d.getIncludeSql());
            database.setExcludeSql(d.getExcludeSql());
            if (d.isDateAsTimestamp() != null) {
                database.setDateAsTimestamp(d.isDateAsTimestamp());
            }
            if (g2.getGenerate().isJavaTimeTypes() != null) {
                database.setJavaTimeTypes(g2.getGenerate().isJavaTimeTypes());
            }
            if (d.isUnsignedTypes() != null) {
                database.setSupportsUnsignedTypes(d.isUnsignedTypes());
            }
            if (d.isIntegerDisplayWidths() != null) {
                database.setIntegerDisplayWidths(d.isIntegerDisplayWidths());
            }
            if (d.isIgnoreProcedureReturnValues() != null) {
                database.setIgnoreProcedureReturnValues(d.isIgnoreProcedureReturnValues());
            }
            database.setIncludeExcludeColumns(Boolean.TRUE.equals(d.isIncludeExcludeColumns()));
            database.setIncludeExcludePackageRoutines(Boolean.TRUE.equals(d.isIncludeExcludePackageRoutines()));
            database.setIncludeForeignKeys(!Boolean.FALSE.equals(d.isIncludeForeignKeys()));
            database.setIncludePackages(!Boolean.FALSE.equals(d.isIncludePackages()));
            database.setIncludePackageRoutines(!Boolean.FALSE.equals(d.isIncludePackageRoutines()));
            database.setIncludePackageUDTs(!Boolean.FALSE.equals(d.isIncludePackageUDTs()));
            database.setIncludePackageConstants(!Boolean.FALSE.equals(d.isIncludePackageConstants()));
            database.setIncludeIndexes(!Boolean.FALSE.equals(d.isIncludeIndexes()));
            database.setIncludeCheckConstraints(!Boolean.FALSE.equals(d.isIncludeCheckConstraints()));
            database.setIncludeSystemTables(Boolean.TRUE.equals(d.isIncludeSystemTables()));
            database.setIncludeSystemIndexes(Boolean.TRUE.equals(d.isIncludeSystemIndexes()));
            database.setIncludeSystemCheckConstraints(Boolean.TRUE.equals(d.isIncludeSystemCheckConstraints()));
            database.setIncludeSystemSequences(Boolean.TRUE.equals(d.isIncludeSystemSequences()));
            database.setIncludeSystemUDTs(Boolean.TRUE.equals(d.isIncludeSystemUDTs()));
            database.setIncludeInvisibleColumns(!Boolean.FALSE.equals(d.isIncludeInvisibleColumns()));
            database.setIncludePrimaryKeys(!Boolean.FALSE.equals(d.isIncludePrimaryKeys()));
            database.setIncludeRoutines(!Boolean.FALSE.equals(d.isIncludeRoutines()));
            database.setIncludeDomains(!Boolean.FALSE.equals(d.isIncludeDomains()));
            database.setIncludeSequences(!Boolean.FALSE.equals(d.isIncludeSequences()));
            database.setIncludeTables(!Boolean.FALSE.equals(d.isIncludeTables()));
            database.setIncludeEmbeddables(!Boolean.FALSE.equals(d.isIncludeEmbeddables()));
            database.setIncludeTriggerRoutines(Boolean.TRUE.equals(d.isIncludeTriggerRoutines()));
            database.setIncludeXMLSchemaCollections(!Boolean.FALSE.equals(d.isIncludeXMLSchemaCollections()));
            database.setIncludeUDTs(!Boolean.FALSE.equals(d.isIncludeUDTs()));
            database.setIncludeUniqueKeys(!Boolean.FALSE.equals(d.isIncludeUniqueKeys()));
            database.setForceIntegerTypesOnZeroScaleDecimals(!Boolean.FALSE.equals(d.isForceIntegerTypesOnZeroScaleDecimals()));
            database.setRecordVersionFields(new String[]{StringUtils.defaultString(d.getRecordVersionFields())});
            database.setRecordTimestampFields(new String[]{StringUtils.defaultString(d.getRecordTimestampFields())});
            database.setSyntheticPrimaryKeys(new String[]{StringUtils.defaultString(d.getSyntheticPrimaryKeys())});
            database.setOverridePrimaryKeys(new String[]{StringUtils.defaultString(d.getOverridePrimaryKeys())});
            database.setSyntheticIdentities(new String[]{StringUtils.defaultString(d.getSyntheticIdentities())});
            database.setConfiguredCustomTypes(d.getCustomTypes());
            database.setConfiguredEnumTypes(d.getEnumTypes());
            database.setConfiguredForcedTypes(d.getForcedTypes());
            database.setForcedTypesForBuiltinDataTypeExtensions(d.isForcedTypesForBuiltinDataTypeExtensions());
            database.setForcedTypesForXMLSchemaCollections(d.isForcedTypesForXMLSchemaCollections());
            database.setConfiguredEmbeddables(d.getEmbeddables());
            database.setConfiguredComments(d.getComments());
            database.setConfiguredSyntheticObjects(d.getSyntheticObjects());
            database.setEmbeddablePrimaryKeys(d.getEmbeddablePrimaryKeys());
            database.setEmbeddableUniqueKeys(d.getEmbeddableUniqueKeys());
            database.setEmbeddableDomains(d.getEmbeddableDomains());
            database.setReadonlyIdentities(Boolean.TRUE.equals(d.isReadonlyIdentities()));
            database.setReadonlyComputedColumns(!Boolean.FALSE.equals(d.isReadonlyComputedColumns()));
            database.setReadonlyNonUpdatableColumns(!Boolean.FALSE.equals(d.isReadonlyNonUpdatableColumns()));
            database.setLogSlowQueriesAfterSeconds(StringUtils.defaultIfNull(d.getLogSlowQueriesAfterSeconds(), 5));
            database.setLogSlowResultsAfterSeconds(StringUtils.defaultIfNull(d.getLogSlowResultsAfterSeconds(), 5));
            if (d.getRegexFlags() != null) {
                database.setRegexFlags(d.getRegexFlags());
                if (strategy instanceof MatcherStrategy) {
                    GeneratorStrategy s2 = strategy;
                    ((MatcherStrategy)s2).getPatterns().setRegexFlags(d.getRegexFlags());
                }
            }
            database.setRegexMatchesPartialQualification(!Boolean.FALSE.equals(d.isRegexMatchesPartialQualification()));
            database.setSqlMatchesPartialQualification(!Boolean.FALSE.equals(d.isSqlMatchesPartialQualification()));
            SchemaVersionProvider svp = null;
            CatalogVersionProvider cvp = null;
            if (!StringUtils.isBlank(d.getSchemaVersionProvider())) {
                try {
                    svp = (SchemaVersionProvider)Class.forName(d.getSchemaVersionProvider()).newInstance();
                    log.info("Using custom schema version provider : " + String.valueOf(svp));
                }
                catch (Exception ignore) {
                    if (d.getSchemaVersionProvider().toLowerCase(locale).startsWith("select")) {
                        svp = new SQLSchemaVersionProvider(this.connection, d.getSchemaVersionProvider());
                        log.info("Using SQL schema version provider : " + d.getSchemaVersionProvider());
                    }
                    svp = new ConstantSchemaVersionProvider(d.getSchemaVersionProvider());
                }
            }
            if (!StringUtils.isBlank(d.getCatalogVersionProvider())) {
                try {
                    cvp = (CatalogVersionProvider)Class.forName(d.getCatalogVersionProvider()).newInstance();
                    log.info("Using custom catalog version provider : " + String.valueOf(cvp));
                }
                catch (Exception ignore) {
                    if (d.getCatalogVersionProvider().toLowerCase(locale).startsWith("select")) {
                        cvp = new SQLCatalogVersionProvider(this.connection, d.getCatalogVersionProvider());
                        log.info("Using SQL catalog version provider : " + d.getCatalogVersionProvider());
                    }
                    cvp = new ConstantCatalogVersionProvider(d.getCatalogVersionProvider());
                }
            }
            if (svp == null) {
                svp = new ConstantSchemaVersionProvider(null);
            }
            if (cvp == null) {
                cvp = new ConstantCatalogVersionProvider(null);
            }
            database.setSchemaVersionProvider(svp);
            database.setCatalogVersionProvider(cvp);
            if (!StringUtils.isBlank(d.getOrderProvider())) {
                Class<?> orderProvider = Class.forName(d.getOrderProvider());
                if (Comparator.class.isAssignableFrom(orderProvider)) {
                    database.setOrderProvider((Comparator)orderProvider.newInstance());
                } else {
                    log.warn("Order provider must be of type java.util.Comparator: " + String.valueOf(orderProvider));
                }
            }
            if (d.getEnumTypes().size() > 0) {
                log.warn((Object)"DEPRECATED", "The configuration property /configuration/generator/database/enumTypes is experimental and deprecated and will be removed in the future.");
            }
            if (Boolean.TRUE.equals(d.isDateAsTimestamp())) {
                log.warn((Object)"DEPRECATED", "The configuration property /configuration/generator/database/dateAsTimestamp is deprecated as it is superseded by custom bindings and converters. It will thus be removed in the future. More information here: https://www.jooq.org/doc/latest/manual/reference/reference-data-types/data-types-oracle-date/");
            }
            if (Boolean.TRUE.equals(d.isIgnoreProcedureReturnValues())) {
                log.warn((Object)"DEPRECATED", "The <ignoreProcedureReturnValues/> flag is deprecated and used for backwards-compatibility only. It will be removed in the future.");
            }
            if (StringUtils.isBlank(g2.getTarget().getPackageName())) {
                g2.getTarget().setPackageName(DEFAULT_TARGET_PACKAGENAME);
            }
            if (StringUtils.isBlank(g2.getTarget().getDirectory())) {
                g2.getTarget().setDirectory(DEFAULT_TARGET_DIRECTORY);
            }
            if (StringUtils.isBlank(g2.getTarget().getEncoding())) {
                g2.getTarget().setEncoding(DEFAULT_TARGET_ENCODING);
            }
            this.set(g2.getTarget(), propertyOverride, "jooq.codegen.target.packageName", Target::getPackageName, Target::setPackageName, Function.identity(), DEFAULT_TARGET_PACKAGENAME::equals);
            this.set(g2.getTarget(), propertyOverride, "jooq.codegen.target.directory", Target::getDirectory, Target::setDirectory, Function.identity(), DEFAULT_TARGET_DIRECTORY::equals);
            this.set(g2.getTarget(), propertyOverride, "jooq.codegen.target.encoding", Target::getEncoding, Target::setEncoding, Function.identity(), DEFAULT_TARGET_ENCODING::equals);
            this.set(g2.getTarget(), propertyOverride, "jooq.codegen.target.locale", Target::getLocale, Target::setLocale);
            if (!new File(g2.getTarget().getDirectory()).isAbsolute()) {
                g2.getTarget().setDirectory(new File(configuration.getBasedir(), g2.getTarget().getDirectory()).getCanonicalPath());
            }
            generator.setTargetPackage(g2.getTarget().getPackageName());
            generator.setTargetDirectory(g2.getTarget().getDirectory());
            generator.setTargetEncoding(g2.getTarget().getEncoding());
            if (g2.getTarget().isClean() != null) {
                generator.setTargetClean(g2.getTarget().isClean());
            }
            generator.setTargetLocale(locale);
            if (g2.getGenerate().isIndexes() != null) {
                generator.setGenerateIndexes(g2.getGenerate().isIndexes());
            }
            if (g2.getGenerate().isRelations() != null) {
                generator.setGenerateRelations(g2.getGenerate().isRelations());
            }
            if (g2.getGenerate().isUdtPaths() != null) {
                generator.setGenerateUDTPaths(g2.getGenerate().isUdtPaths());
            }
            if (g2.getGenerate().isImplicitJoinPathsToOne() != null) {
                generator.setGenerateImplicitJoinPathsToOne(g2.getGenerate().isImplicitJoinPathsToOne());
            }
            if (g2.getGenerate().isImplicitJoinPathsToMany() != null) {
                generator.setGenerateImplicitJoinPathsToMany(g2.getGenerate().isImplicitJoinPathsToMany());
            }
            if (g2.getGenerate().isImplicitJoinPathTableSubtypes() != null) {
                generator.setGenerateImplicitJoinPathTableSubtypes(g2.getGenerate().isImplicitJoinPathTableSubtypes());
            }
            if (g2.getGenerate().isImplicitJoinPathUnusedConstructors() != null) {
                generator.setGenerateImplicitJoinPathUnusedConstructors(g2.getGenerate().isImplicitJoinPathUnusedConstructors());
            }
            if (g2.getGenerate().isImplicitJoinPathsAsKotlinProperties() != null) {
                generator.setGenerateImplicitJoinPathsAsKotlinProperties(g2.getGenerate().isImplicitJoinPathsAsKotlinProperties());
            }
            if (g2.getGenerate().isDeprecated() != null) {
                generator.setGenerateDeprecated(g2.getGenerate().isDeprecated());
            }
            if (g2.getGenerate().isDeprecationOnUnknownTypes() != null) {
                generator.setGenerateDeprecationOnUnknownTypes(g2.getGenerate().isDeprecationOnUnknownTypes());
            }
            if (g2.getGenerate().isInstanceFields() != null) {
                generator.setGenerateInstanceFields(g2.getGenerate().isInstanceFields());
            }
            if (g2.getGenerate().getVisibilityModifier() != null) {
                generator.setGenerateVisibilityModifier(g2.getGenerate().getVisibilityModifier());
            }
            if (g2.getGenerate().isGeneratedAnnotation() != null) {
                generator.setGenerateGeneratedAnnotation(g2.getGenerate().isGeneratedAnnotation());
            }
            if (g2.getGenerate().getGeneratedAnnotationType() != null) {
                generator.setGenerateGeneratedAnnotationType(g2.getGenerate().getGeneratedAnnotationType());
            }
            if (g2.getGenerate().isGeneratedAnnotationDate() != null) {
                generator.setGenerateGeneratedAnnotationDate(g2.getGenerate().isGeneratedAnnotationDate());
            }
            if (g2.getGenerate().isGeneratedAnnotationJooqVersion() != null) {
                generator.setGenerateGeneratedAnnotationJooqVersion(g2.getGenerate().isGeneratedAnnotationJooqVersion());
            }
            if (g2.getGenerate().isNonnullAnnotation() != null) {
                generator.setGenerateNonnullAnnotation(g2.getGenerate().isNonnullAnnotation());
            }
            if (g2.getGenerate().getNonnullAnnotationType() != null) {
                generator.setGeneratedNonnullAnnotationType(g2.getGenerate().getNonnullAnnotationType());
            }
            if (g2.getGenerate().isNullableAnnotation() != null) {
                generator.setGenerateNullableAnnotation(g2.getGenerate().isNullableAnnotation());
            }
            if (g2.getGenerate().getNullableAnnotationType() != null) {
                generator.setGeneratedNullableAnnotationType(g2.getGenerate().getNullableAnnotationType());
            }
            if (g2.getGenerate().isConstructorPropertiesAnnotation() != null) {
                generator.setGenerateConstructorPropertiesAnnotation(g2.getGenerate().isConstructorPropertiesAnnotation());
            }
            if (g2.getGenerate().isConstructorPropertiesAnnotationOnPojos() != null) {
                generator.setGenerateConstructorPropertiesAnnotationOnPojos(g2.getGenerate().isConstructorPropertiesAnnotationOnPojos());
            }
            if (g2.getGenerate().isConstructorPropertiesAnnotationOnRecords() != null) {
                generator.setGenerateConstructorPropertiesAnnotationOnRecords(g2.getGenerate().isConstructorPropertiesAnnotationOnRecords());
            }
            if (g2.getGenerate().isRoutines() != null) {
                generator.setGenerateRoutines(g2.getGenerate().isRoutines());
            }
            if (g2.getGenerate().isSequences() != null) {
                generator.setGenerateSequences(g2.getGenerate().isSequences());
            }
            if (g2.getGenerate().isSequenceFlags() != null) {
                generator.setGenerateSequenceFlags(g2.getGenerate().isSequenceFlags());
            }
            if (g2.getGenerate().isUdts() != null) {
                generator.setGenerateUDTs(g2.getGenerate().isUdts());
            }
            if (g2.getGenerate().isTables() != null) {
                generator.setGenerateTables(g2.getGenerate().isTables());
            }
            if (g2.getGenerate().isEmbeddables() != null) {
                generator.setGenerateEmbeddables(g2.getGenerate().isEmbeddables());
            }
            if (g2.getGenerate().isRecords() != null) {
                generator.setGenerateRecords(g2.getGenerate().isRecords());
            }
            if (g2.getGenerate().isRecordsImplementingRecordN() != null) {
                generator.setGenerateRecordsImplementingRecordN(g2.getGenerate().isRecordsImplementingRecordN());
            }
            if (g2.getGenerate().isEnumsAsScalaSealedTraits() != null) {
                generator.setGenerateEnumsAsScalaSealedTraits(g2.getGenerate().isEnumsAsScalaSealedTraits());
            }
            if (g2.getGenerate().isPojos() != null) {
                generator.setGeneratePojos(g2.getGenerate().isPojos());
            }
            if (g2.getGenerate().isPojosAsJavaRecordClasses() != null) {
                generator.setGeneratePojosAsJavaRecordClasses(g2.getGenerate().isPojosAsJavaRecordClasses());
            }
            if (g2.getGenerate().isPojosAsScalaCaseClasses() != null) {
                generator.setGeneratePojosAsScalaCaseClasses(g2.getGenerate().isPojosAsScalaCaseClasses());
            }
            if (g2.getGenerate().isPojosAsKotlinDataClasses() != null) {
                generator.setGeneratePojosAsKotlinDataClasses(g2.getGenerate().isPojosAsKotlinDataClasses());
            }
            if (g2.getGenerate().isImmutablePojos() != null) {
                generator.setGenerateImmutablePojos(g2.getGenerate().isImmutablePojos());
            }
            if (g2.getGenerate().isSerializablePojos() != null) {
                generator.setGenerateSerializablePojos(g2.getGenerate().isSerializablePojos());
            }
            if (g2.getGenerate().isInterfaces() != null) {
                generator.setGenerateInterfaces(g2.getGenerate().isInterfaces());
            }
            if (g2.getGenerate().isImmutableInterfaces() != null) {
                generator.setGenerateImmutableInterfaces(g2.getGenerate().isImmutableInterfaces());
            }
            if (g2.getGenerate().isSerializableInterfaces() != null) {
                generator.setGenerateSerializableInterfaces(g2.getGenerate().isSerializableInterfaces());
            }
            if (g2.getGenerate().isDaos() != null) {
                generator.setGenerateDaos(g2.getGenerate().isDaos());
            }
            if (g2.getGenerate().isJooqVersionReference() != null) {
                generator.setGenerateJooqVersionReference(g2.getGenerate().isJooqVersionReference());
            }
            if (g2.getGenerate().isJpaAnnotations() != null) {
                generator.setGenerateJPAAnnotations(g2.getGenerate().isJpaAnnotations());
            }
            if (g2.getGenerate().getJpaVersion() != null) {
                generator.setGenerateJPAVersion(g2.getGenerate().getJpaVersion());
            }
            if (g2.getGenerate().isValidationAnnotations() != null) {
                generator.setGenerateValidationAnnotations(g2.getGenerate().isValidationAnnotations());
            }
            if (g2.getGenerate().isSpringAnnotations() != null) {
                generator.setGenerateSpringAnnotations(g2.getGenerate().isSpringAnnotations());
            }
            if (g2.getGenerate().isSpringDao() != null) {
                generator.setGenerateSpringDao(g2.getGenerate().isSpringDao());
            }
            if (g2.getGenerate().isKotlinSetterJvmNameAnnotationsOnIsPrefix() != null) {
                generator.setGenerateKotlinSetterJvmNameAnnotationsOnIsPrefix(g2.getGenerate().isKotlinSetterJvmNameAnnotationsOnIsPrefix());
            }
            if (g2.getGenerate().isKotlinNotNullPojoAttributes() != null) {
                generator.setGenerateKotlinNotNullPojoAttributes(g2.getGenerate().isKotlinNotNullPojoAttributes());
            }
            if (g2.getGenerate().isKotlinNotNullRecordAttributes() != null) {
                generator.setGenerateKotlinNotNullRecordAttributes(g2.getGenerate().isKotlinNotNullRecordAttributes());
            }
            if (g2.getGenerate().isKotlinNotNullInterfaceAttributes() != null) {
                generator.setGenerateKotlinNotNullInterfaceAttributes(g2.getGenerate().isKotlinNotNullInterfaceAttributes());
            }
            if (g2.getGenerate().isKotlinDefaultedNullablePojoAttributes() != null) {
                generator.setGenerateKotlinDefaultedNullablePojoAttributes(g2.getGenerate().isKotlinDefaultedNullablePojoAttributes());
            }
            if (g2.getGenerate().isKotlinDefaultedNullableRecordAttributes() != null) {
                generator.setGenerateKotlinDefaultedNullableRecordAttributes(g2.getGenerate().isKotlinDefaultedNullableRecordAttributes());
            }
            if (g2.getGenerate().getGeneratedSerialVersionUID() != null) {
                generator.setGenerateGeneratedSerialVersionUID(g2.getGenerate().getGeneratedSerialVersionUID());
            }
            if (g2.getGenerate().getMaxMembersPerInitialiser() != null) {
                generator.setMaxMembersPerInitialiser(g2.getGenerate().getMaxMembersPerInitialiser());
            }
            if (g2.getGenerate().isQueues() != null) {
                generator.setGenerateQueues(g2.getGenerate().isQueues());
            }
            if (g2.getGenerate().isLinks() != null) {
                generator.setGenerateLinks(g2.getGenerate().isLinks());
            }
            if (g2.getGenerate().isKeys() != null) {
                generator.setGenerateKeys(g2.getGenerate().isKeys());
            }
            if (g2.getGenerate().isGlobalObjectNames() != null) {
                generator.setGenerateGlobalObjectNames(g2.getGenerate().isGlobalObjectNames());
            }
            if (g2.getGenerate().isGlobalObjectReferences() != null) {
                generator.setGenerateGlobalObjectReferences(g2.getGenerate().isGlobalObjectReferences());
            }
            if (g2.getGenerate().isGlobalCatalogReferences() != null) {
                generator.setGenerateGlobalCatalogReferences(g2.getGenerate().isGlobalCatalogReferences());
            }
            if (g2.getGenerate().isGlobalDomainReferences() != null) {
                generator.setGenerateGlobalDomainReferences(g2.getGenerate().isGlobalDomainReferences());
            }
            if (g2.getGenerate().isGlobalSchemaReferences() != null) {
                generator.setGenerateGlobalSchemaReferences(g2.getGenerate().isGlobalSchemaReferences());
            }
            if (g2.getGenerate().isGlobalRoutineReferences() != null) {
                generator.setGenerateGlobalRoutineReferences(g2.getGenerate().isGlobalRoutineReferences());
            }
            if (g2.getGenerate().isGlobalSequenceReferences() != null) {
                generator.setGenerateGlobalSequenceReferences(g2.getGenerate().isGlobalSequenceReferences());
            }
            if (g2.getGenerate().isGlobalTableReferences() != null) {
                generator.setGenerateGlobalTableReferences(g2.getGenerate().isGlobalTableReferences());
            }
            if (g2.getGenerate().isGlobalUDTReferences() != null) {
                generator.setGenerateGlobalUDTReferences(g2.getGenerate().isGlobalUDTReferences());
            }
            if (g2.getGenerate().isGlobalQueueReferences() != null) {
                generator.setGenerateGlobalQueueReferences(g2.getGenerate().isGlobalQueueReferences());
            }
            if (g2.getGenerate().isGlobalLinkReferences() != null) {
                generator.setGenerateGlobalLinkReferences(g2.getGenerate().isGlobalLinkReferences());
            }
            if (g2.getGenerate().isGlobalKeyReferences() != null) {
                generator.setGenerateGlobalKeyReferences(g2.getGenerate().isGlobalKeyReferences());
            }
            if (g2.getGenerate().isGlobalIndexReferences() != null) {
                generator.setGenerateGlobalIndexReferences(g2.getGenerate().isGlobalIndexReferences());
            }
            if (g2.getGenerate().isDefaultCatalog() != null) {
                generator.setGenerateDefaultCatalog(g2.getGenerate().isDefaultCatalog());
            }
            if (g2.getGenerate().isDefaultSchema() != null) {
                generator.setGenerateDefaultSchema(g2.getGenerate().isDefaultSchema());
            }
            if (g2.getGenerate().isJavadoc() != null) {
                generator.setGenerateJavadoc(g2.getGenerate().isJavadoc());
            }
            if (g2.getGenerate().isComments() != null) {
                generator.setGenerateComments(g2.getGenerate().isComments());
            }
            if (g2.getGenerate().isCommentsOnAttributes() != null) {
                generator.setGenerateCommentsOnAttributes(g2.getGenerate().isCommentsOnAttributes());
            }
            if (g2.getGenerate().isCommentsOnCatalogs() != null) {
                generator.setGenerateCommentsOnCatalogs(g2.getGenerate().isCommentsOnCatalogs());
            }
            if (g2.getGenerate().isCommentsOnColumns() != null) {
                generator.setGenerateCommentsOnColumns(g2.getGenerate().isCommentsOnColumns());
            }
            if (g2.getGenerate().isCommentsOnKeys() != null) {
                generator.setGenerateCommentsOnKeys(g2.getGenerate().isCommentsOnKeys());
            }
            if (g2.getGenerate().isCommentsOnLinks() != null) {
                generator.setGenerateCommentsOnLinks(g2.getGenerate().isCommentsOnLinks());
            }
            if (g2.getGenerate().isCommentsOnPackages() != null) {
                generator.setGenerateCommentsOnPackages(g2.getGenerate().isCommentsOnPackages());
            }
            if (g2.getGenerate().isCommentsOnParameters() != null) {
                generator.setGenerateCommentsOnParameters(g2.getGenerate().isCommentsOnParameters());
            }
            if (g2.getGenerate().isCommentsOnQueues() != null) {
                generator.setGenerateCommentsOnQueues(g2.getGenerate().isCommentsOnQueues());
            }
            if (g2.getGenerate().isCommentsOnRoutines() != null) {
                generator.setGenerateCommentsOnRoutines(g2.getGenerate().isCommentsOnRoutines());
            }
            if (g2.getGenerate().isCommentsOnSchemas() != null) {
                generator.setGenerateCommentsOnSchemas(g2.getGenerate().isCommentsOnSchemas());
            }
            if (g2.getGenerate().isCommentsOnSequences() != null) {
                generator.setGenerateCommentsOnSequences(g2.getGenerate().isCommentsOnSequences());
            }
            if (g2.getGenerate().isCommentsOnTables() != null) {
                generator.setGenerateCommentsOnTables(g2.getGenerate().isCommentsOnTables());
            }
            if (g2.getGenerate().isCommentsOnEmbeddables() != null) {
                generator.setGenerateCommentsOnEmbeddables(g2.getGenerate().isCommentsOnEmbeddables());
            }
            if (g2.getGenerate().isCommentsOnUDTs() != null) {
                generator.setGenerateCommentsOnUDTs(g2.getGenerate().isCommentsOnUDTs());
            }
            if (g2.getGenerate().isSources() != null) {
                generator.setGenerateSources(g2.getGenerate().isSources());
            }
            if (g2.getGenerate().isSourcesOnViews() != null) {
                generator.setGenerateSourcesOnViews(g2.getGenerate().isSourcesOnViews());
            }
            if (g2.getGenerate().isFluentSetters() != null) {
                generator.setGenerateFluentSetters(g2.getGenerate().isFluentSetters());
            }
            if (g2.getGenerate().isJavaBeansGettersAndSetters() != null) {
                generator.setGenerateJavaBeansGettersAndSetters(g2.getGenerate().isJavaBeansGettersAndSetters());
            }
            if (g2.getGenerate().isImplicitJoinPathsUseTableNameForUnambiguousFKs() != null) {
                generator.setGenerateUseTableNameForUnambiguousFKs(g2.getGenerate().isImplicitJoinPathsUseTableNameForUnambiguousFKs());
            }
            if (g2.getGenerate().isVarargSetters() != null) {
                generator.setGenerateVarargsSetters(g2.getGenerate().isVarargSetters());
            }
            if (g2.getGenerate().isPojosEqualsAndHashCode() != null) {
                generator.setGeneratePojosEqualsAndHashCode(g2.getGenerate().isPojosEqualsAndHashCode());
            }
            if (g2.getGenerate().isPojosToString() != null) {
                generator.setGeneratePojosToString(g2.getGenerate().isPojosToString());
            }
            if (g2.getGenerate().getFullyQualifiedTypes() != null) {
                generator.setGenerateFullyQualifiedTypes(g2.getGenerate().getFullyQualifiedTypes());
            }
            if (g2.getGenerate().isJavaTimeTypes() != null) {
                generator.setGenerateJavaTimeTypes(g2.getGenerate().isJavaTimeTypes());
            }
            if (g2.getGenerate().isSpatialTypes() != null) {
                generator.setGenerateSpatialTypes(g2.getGenerate().isSpatialTypes());
            }
            if (g2.getGenerate().isXmlTypes() != null) {
                generator.setGenerateXmlTypes(g2.getGenerate().isXmlTypes());
            }
            if (g2.getGenerate().isJsonTypes() != null) {
                generator.setGenerateJsonTypes(g2.getGenerate().isJsonTypes());
            }
            if (g2.getGenerate().isIntervalTypes() != null) {
                generator.setGenerateIntervalTypes(g2.getGenerate().isIntervalTypes());
            }
            if (g2.getGenerate().isEmptyCatalogs() != null) {
                generator.setGenerateEmptyCatalogs(g2.getGenerate().isEmptyCatalogs());
            }
            if (g2.getGenerate().isEmptySchemas() != null) {
                generator.setGenerateEmptySchemas(g2.getGenerate().isEmptySchemas());
            }
            if (g2.getGenerate().getNewline() != null) {
                generator.setGenerateNewline(g2.getGenerate().getNewline());
            }
            if (g2.getGenerate().getIndentation() != null) {
                generator.setGenerateIndentation(g2.getGenerate().getIndentation());
            }
            if (g2.getGenerate().getPrintMarginForBlockComment() != null) {
                generator.setGeneratePrintMarginForBlockComment(g2.getGenerate().getPrintMarginForBlockComment());
            }
            if (g2.getGenerate().getTextBlocks() != null) {
                generator.setGenerateTextBlocks(g2.getGenerate().getTextBlocks());
            }
            if (g2.getGenerate().isWhereMethodOverrides() != null) {
                generator.setGenerateWhereMethodOverrides(g2.getGenerate().isWhereMethodOverrides());
            }
            if (g2.getGenerate().isRenameMethodOverrides() != null) {
                generator.setGenerateRenameMethodOverrides(g2.getGenerate().isRenameMethodOverrides());
            }
            if (g2.getGenerate().isAsMethodOverrides() != null) {
                generator.setGenerateAsMethodOverrides(g2.getGenerate().isAsMethodOverrides());
            }
            if (!StringUtils.isBlank(d.getSchemaVersionProvider())) {
                generator.setUseSchemaVersionProvider(true);
            }
            if (!StringUtils.isBlank(d.getCatalogVersionProvider())) {
                generator.setUseCatalogVersionProvider(true);
            }
            if (d.isTableValuedFunctions() != null) {
                generator.setGenerateTableValuedFunctions(d.isTableValuedFunctions());
            } else {
                generator.setGenerateTableValuedFunctions(true);
            }
            strategy.setInstanceFields(generator.generateInstanceFields());
            strategy.setJavaBeansGettersAndSetters(generator.generateJavaBeansGettersAndSetters());
            strategy.setUseTableNameForUnambiguousFKs(generator.generateUseTableNameForUnambiguousFKs());
            this.verifyVersions();
            generator.generate(database);
            if (configuration.getOnUnused() != OnError.SILENT) {
                boolean anyUnused = false;
                anyUnused |= this.logUnused("forced type", "forced types", database.getUnusedForcedTypes());
                anyUnused |= this.logUnused("embeddable", "embeddables", database.getUnusedEmbeddables());
                anyUnused |= this.logUnused("comment", "comments", database.getUnusedComments());
                anyUnused |= this.logUnused("synthetic column", "synthetic columns", database.getUnusedSyntheticColumns());
                anyUnused |= this.logUnused("synthetic readonly column", "synthetic readonly columns", database.getUnusedSyntheticReadonlyColumns());
                anyUnused |= this.logUnused("synthetic readonly rowid", "synthetic readonly rowids", database.getUnusedSyntheticReadonlyRowids());
                anyUnused |= this.logUnused("synthetic identity", "synthetic identities", database.getUnusedSyntheticIdentities());
                anyUnused |= this.logUnused("synthetic primary key", "synthetic primary keys", database.getUnusedSyntheticPrimaryKeys());
                anyUnused |= this.logUnused("synthetic unique key", "synthetic unique keys", database.getUnusedSyntheticUniqueKeys());
                anyUnused |= this.logUnused("synthetic foreign key", "synthetic foreign keys", database.getUnusedSyntheticForeignKeys());
                if ((anyUnused |= this.logUnused("synthetic view", "synthetic views", database.getUnusedSyntheticViews())) && configuration.getOnUnused() == OnError.FAIL) {
                    throw new GeneratorException("Unused configuration elements encountered");
                }
            }
        }
        finally {
            if (database != null) {
                try {
                    database.close();
                }
                catch (Exception e) {
                    log.error((Object)"Error while closing database", e);
                }
            }
            if (this.connection != null) {
                if (this.close) {
                    if (this.ctx != null && this.ctx.family() == SQLDialect.HSQLDB && this.dataSource == null) {
                        this.ctx.execute("shutdown");
                    }
                    this.connection.close();
                } else if (this.autoCommit != null) {
                    this.connection.setAutoCommit(this.autoCommit);
                }
            }
        }
    }

    private <T> Class<T> compile(String name, String java, Class<T> type) {
        if (StringUtils.isBlank(name)) {
            throw new GeneratorException("Type " + type.getName() + " must have explicit name configured: " + java);
        }
        Class<?> result = Reflect.compile(name, java, new CompileOptions().classLoader(Thread.currentThread().getContextClassLoader())).type();
        if (type.isAssignableFrom(result)) {
            return result;
        }
        throw new GeneratorException("Type " + name + " must implement " + type.getName());
    }

    private <O> void set(O configurationObject, boolean override, String property, Function<? super O, ? extends String> get, BiConsumer<? super O, ? super String> set) {
        this.set(configurationObject, override, property, get, set, Function.identity());
    }

    private <O, T> void set(O configurationObject, boolean override, String property, Function<? super O, ? extends T> get, BiConsumer<? super O, ? super T> set, Function<? super String, ? extends T> convert) {
        this.set(configurationObject, override, property, get, set, convert, t2 -> t2 == null);
    }

    private <O, T> void set(O configurationObject, boolean override, String property, Function<? super O, ? extends T> get, BiConsumer<? super O, ? super T> set, Function<? super String, ? extends T> convert, Predicate<? super T> checkDefault) {
        String p = System.getProperty(property);
        if (p != null && (override || checkDefault.test(get.apply(configurationObject)))) {
            set.accept(configurationObject, convert.apply(p));
        }
    }

    private void verifyVersions() {
        try {
            Field[] f1 = org.jooq.Constants.class.getFields();
            Field[] f2 = org.jooq.meta.Constants.class.getFields();
            Field[] f3 = Constants.class.getFields();
            Arrays.sort(f1, Comparator.comparing(Field::getName));
            Arrays.sort(f2, Comparator.comparing(Field::getName));
            Arrays.sort(f3, Comparator.comparing(Field::getName));
            if (f1.length != f2.length) {
                log.warn((Object)"Version check", "org.jooq.Constants and org.jooq.meta.Constants contents mismatch. Check if you're using the same versions for org.jooq and org.jooq.meta");
            }
            if (f1.length != f3.length) {
                log.warn((Object)"Version check", "org.jooq.Constants and org.jooq.codegen.Constants contents mismatch. Check if you're using the same versions for org.jooq and org.jooq.meta");
            }
            String v1 = "3.19.13";
            String v2 = "3.19.13";
            String v3 = "3.19.13";
            for (int i = 0; i < f1.length && i < f2.length && i < f3.length; ++i) {
                Object c1 = f1[i].get(org.jooq.Constants.class);
                Object c2 = f2[i].get(org.jooq.meta.Constants.class);
                Object c3 = f3[i].get(Constants.class);
                if (!Objects.equals(c1, c2)) {
                    log.warn((Object)"Version check", "org.jooq.Constants." + f1[i].getName() + " contents mismatch: " + String.valueOf(c1) + " vs " + String.valueOf(c2) + ". Check if you're using the same versions for org.jooq (" + v1 + ") and org.jooq.meta (" + v2 + ")");
                }
                if (Objects.equals(c1, c3)) continue;
                log.warn((Object)"Version check", "org.jooq.Constants." + f1[i].getName() + " contents mismatch: " + String.valueOf(c1) + " vs " + String.valueOf(c3) + ". Check if you're using the same versions for org.jooq (" + v1 + ") and org.jooq.codegen (" + v3 + ")");
            }
        }
        catch (Throwable e) {
            log.warn("Version check", "Something went wrong when comparing versions of org.jooq, org.jooq.meta, and org.jooq.codegen", e);
        }
    }

    private boolean logUnused(String objectType, String objectTypes, List<?> list) {
        if (!list.isEmpty() && Boolean.parseBoolean(System.getProperty("jooq.codegen.logunused", "true"))) {
            unusedLogger.warn((Object)("Unused " + objectTypes), "There are unused " + objectTypes + ", which have not been used by this generation run.\nThis can be because of misconfigurations, such as, for example:\n- case sensitive regular expressions\n- regular expressions depending on whitespace (Pattern.COMMENTS is turned on!)\n- missing or inadequate object qualification\n- the object to which the configuration was applied in the past has been dropped\nTry turning on DEBUG logging (-X in Maven, --debug in Gradle, and <logging/> in jOOQ) to get additional info about the schema");
            for (Object o : list) {
                unusedLogger.warn((Object)("Unused " + objectType), o);
            }
            return true;
        }
        return false;
    }

    private static void setGlobalLoggingThreshold(Configuration configuration) {
        if (configuration.getLogging() != null) {
            switch (configuration.getLogging()) {
                case TRACE: {
                    JooqLogger.globalThreshold(Log.Level.TRACE);
                    break;
                }
                case DEBUG: {
                    JooqLogger.globalThreshold(Log.Level.DEBUG);
                    break;
                }
                case INFO: {
                    JooqLogger.globalThreshold(Log.Level.INFO);
                    break;
                }
                case WARN: {
                    JooqLogger.globalThreshold(Log.Level.WARN);
                    break;
                }
                case ERROR: {
                    JooqLogger.globalThreshold(Log.Level.ERROR);
                    break;
                }
                case FATAL: {
                    JooqLogger.globalThreshold(Log.Level.FATAL);
                }
            }
        }
    }

    private Properties properties(List<Property> properties) {
        Properties result = new Properties();
        for (Property p : properties) {
            result.put(p.getKey(), p.getValue());
        }
        return result;
    }

    private String driverClass(Jdbc j) {
        String result = j.getDriver();
        if (result == null) {
            result = JDBCUtils.driver(j.getUrl());
            log.info((Object)"Database", "Inferring driver " + result + " from URL " + j.getUrl());
        }
        return result;
    }

    private Class<? extends org.jooq.meta.Database> databaseClass(Jdbc j) {
        return this.databaseClass(j.getUrl());
    }

    private Class<? extends org.jooq.meta.Database> databaseClass(Connection c) {
        try {
            return this.databaseClass(c.getMetaData().getURL());
        }
        catch (SQLException e) {
            throw new GeneratorException("Error when reading URL from JDBC connection", e);
        }
    }

    private Class<? extends org.jooq.meta.Database> databaseClass(String url) {
        if (StringUtils.isBlank(url)) {
            throw new GeneratorException("No JDBC URL configured.");
        }
        Class<? extends org.jooq.meta.Database> result = Databases.databaseClass(JDBCUtils.dialect(url));
        log.info((Object)"Database", "Inferring database " + result.getName() + " from URL " + url);
        return result;
    }

    private Class<?> loadClass(String className) throws ClassNotFoundException {
        try {
            if (this.loader == null) {
                return ClassUtils.loadClass(className);
            }
            return this.loader.loadClass(className);
        }
        catch (ClassNotFoundException e) {
            String message = null;
            if (className.startsWith("org.jooq.util.")) {
                String alternative = null;
                for (String pkg : new String[]{"org.jooq.meta", "org.jooq.meta.extensions", "org.jooq.codegen", "org.jooq.codegen.maven"}) {
                    try {
                        alternative = ClassUtils.loadClass(className.replace("org.jooq.util", pkg)).getName();
                        break;
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                    }
                }
                message = "Your configured " + className + " type was not found.\n" + (String)(alternative != null ? "Did you mean " + alternative + "?\n" : "") + "Do note that in jOOQ 3.11, jOOQ-meta and jOOQ-codegen packages have been renamed. New package names are:\n- org.jooq.meta\n- org.jooq.meta.extensions\n- org.jooq.codegen\n- org.jooq.codegen.maven\nSee https://github.com/jOOQ/jOOQ/issues/7419 for details";
                log.warn((Object)"Type not found", message);
            } else if (className.equals("org.jooq.meta.extensions.liquibase.LiquibaseDatabase")) {
                message = "Your configured database type was not found: " + className + ".\n- Please make sure the jooq-meta-extensions-liquibase dependency is on your classpath.\n- In jOOQ 3.14, the dependency name has changed, see https://github.com/jOOQ/jOOQ/issues/10331";
                log.warn((Object)"Type not found", message);
            } else if (className.equals("org.jooq.meta.extensions.jpa.JPADatabase")) {
                message = "Your configured database type was not found: " + className + ".\n- Please make sure the jooq-meta-extensions-hibernate dependency is on your classpath.\n- In jOOQ 3.14, the dependency name has changed, see https://github.com/jOOQ/jOOQ/issues/10331";
                log.warn((Object)"Type not found", message);
            } else if (className.startsWith("org.jooq.meta.") && className.endsWith("Database")) {
                message = "Your configured database type was not found: " + className + ". This can have several reasons:\n- You want to use a commercial jOOQ Edition, but you pulled the Open Source Edition from Maven Central.\n- You have mis-typed your class name.";
                log.warn((Object)"Type not found", message);
            }
            if (message == null) {
                throw e;
            }
            throw new ClassNotFoundException(message, e);
        }
    }

    private static String trim(String string) {
        return string == null ? null : string.trim();
    }

    public static long copyLarge(InputStream input, OutputStream output) throws IOException {
        byte[] buffer = new byte[4096];
        long count = 0L;
        int n = 0;
        while (-1 != (n = input.read(buffer))) {
            output.write(buffer, 0, n);
            count += (long)n;
        }
        return count;
    }

    public static Configuration load(InputStream in) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        GenerationTool.copyLarge(in, out);
        String xml = out.toString();
        xml = xml.replaceAll("<(\\w+:)?configuration xmlns(:\\w+)?=\"http://www.jooq.org/xsd/jooq-codegen-\\d+\\.\\d+\\.\\d+.xsd\">", "<$1configuration xmlns$2=\"http://www.jooq.org/xsd/jooq-codegen-3.19.8.xsd\">");
        return MiniJAXB.unmarshal(xml, Configuration.class);
    }

    private static class Unused {
        private Unused() {
        }
    }
}

