/*
 * Decompiled with CFR 0.152.
 */
package org.geolatte.geom.codec;

import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.geolatte.geom.Geometry;
import org.geolatte.geom.GeometryCollection;
import org.geolatte.geom.GeometryType;
import org.geolatte.geom.LineString;
import org.geolatte.geom.LinearRing;
import org.geolatte.geom.MultiLineString;
import org.geolatte.geom.MultiPoint;
import org.geolatte.geom.MultiPolygon;
import org.geolatte.geom.Point;
import org.geolatte.geom.PointSequence;
import org.geolatte.geom.Points;
import org.geolatte.geom.Polygon;
import org.geolatte.geom.codec.AbstractWktDecoder;
import org.geolatte.geom.codec.PostgisWktVariant;
import org.geolatte.geom.codec.WktDecodeException;
import org.geolatte.geom.codec.WktDecoder;
import org.geolatte.geom.codec.WktGeometryToken;
import org.geolatte.geom.codec.WktPointSequenceToken;
import org.geolatte.geom.codec.WktTokenizer;
import org.geolatte.geom.crs.CrsId;

class PostgisWktDecoder
extends AbstractWktDecoder<Geometry>
implements WktDecoder {
    private static final PostgisWktVariant WKT_GEOM_TOKENS = new PostgisWktVariant();
    private static final Pattern SRID_RE = Pattern.compile("^SRID=(\\d+);", 2);
    private String wktString;
    private CrsId crsId;

    public PostgisWktDecoder() {
        super(WKT_GEOM_TOKENS);
    }

    @Override
    public Geometry decode(String wkt) {
        if (wkt == null || wkt.isEmpty()) {
            throw new WktDecodeException("Null or empty string cannot be decoded into a geometry");
        }
        this.prepare(wkt);
        this.initializeTokenizer();
        return this.decodeGeometry();
    }

    private void prepare(String wkt) {
        Matcher matcher = SRID_RE.matcher(wkt);
        if (matcher.find()) {
            this.crsId = CrsId.valueOf(Integer.parseInt(matcher.group(1)));
            this.wktString = wkt.substring(matcher.end());
        } else {
            this.crsId = CrsId.UNDEFINED;
            this.wktString = wkt;
        }
    }

    private void initializeTokenizer() {
        this.setTokenizer(new WktTokenizer(this.wktString, this.getWktVariant(), this.crsId));
        this.nextToken();
    }

    private Geometry decodeGeometry() {
        if (!(this.currentToken instanceof WktGeometryToken)) {
            throw new WktDecodeException(this.buildWrongSymbolAtPositionMsg());
        }
        GeometryType type = ((WktGeometryToken)this.currentToken).getType();
        this.nextToken();
        switch (type) {
            case POINT: {
                return this.decodePointText();
            }
            case LINE_STRING: {
                return this.decodeLineStringText();
            }
            case POLYGON: {
                return this.decodePolygonText();
            }
            case GEOMETRY_COLLECTION: {
                return this.decodeGeometryCollection();
            }
            case MULTI_POINT: {
                return this.decodeMultiPoint();
            }
            case MULTI_LINE_STRING: {
                return this.decodeMultiLineString();
            }
            case MULTI_POLYGON: {
                return this.decodeMultiPolygon();
            }
        }
        throw new WktDecodeException("Unsupported geometry type in Wkt: " + (Object)((Object)type));
    }

    private Geometry decodeMultiPolygon() {
        if (this.matchesOpenList()) {
            ArrayList<Polygon> polygons = new ArrayList<Polygon>();
            while (!this.matchesCloseList()) {
                polygons.add(this.decodePolygonText());
                this.matchesElementSeparator();
            }
            return new MultiPolygon(polygons.toArray(new Polygon[polygons.size()]));
        }
        if (this.matchesEmptyToken()) {
            return MultiPolygon.createEmpty();
        }
        throw new WktDecodeException(this.buildWrongSymbolAtPositionMsg());
    }

    private Geometry decodeMultiLineString() {
        if (this.matchesOpenList()) {
            ArrayList<LineString> lineStrings = new ArrayList<LineString>();
            while (!this.matchesCloseList()) {
                lineStrings.add(this.decodeLineStringText());
                this.matchesElementSeparator();
            }
            return new MultiLineString(lineStrings.toArray(new LineString[lineStrings.size()]));
        }
        if (this.matchesEmptyToken()) {
            return MultiLineString.createEmpty();
        }
        throw new WktDecodeException(this.buildWrongSymbolAtPositionMsg());
    }

    private Geometry decodeMultiPoint() {
        if (this.matchesOpenList()) {
            ArrayList<Point> points = new ArrayList<Point>();
            if (this.currentToken instanceof WktPointSequenceToken) {
                PointSequence pointSequence = ((WktPointSequenceToken)this.currentToken).getPoints();
                for (Point pnt : pointSequence) {
                    points.add(new Point(pnt));
                }
                this.nextToken();
            }
            while (!this.matchesCloseList()) {
                points.add(this.decodePointText());
                this.matchesElementSeparator();
            }
            return new MultiPoint(points.toArray(new Point[points.size()]));
        }
        if (this.matchesEmptyToken()) {
            return MultiPoint.createEmpty();
        }
        throw new WktDecodeException(this.buildWrongSymbolAtPositionMsg());
    }

    private GeometryCollection decodeGeometryCollection() {
        if (this.matchesOpenList()) {
            ArrayList<Geometry> geometries = new ArrayList<Geometry>();
            while (!this.matchesCloseList()) {
                geometries.add(this.decodeGeometry());
                this.matchesElementSeparator();
            }
            return new GeometryCollection(geometries.toArray(new Geometry[geometries.size()]));
        }
        if (this.matchesEmptyToken()) {
            return GeometryCollection.createEmpty();
        }
        throw new WktDecodeException(this.buildWrongSymbolAtPositionMsg());
    }

    private Polygon decodePolygonText() {
        if (this.matchesOpenList()) {
            ArrayList<LinearRing> rings = new ArrayList<LinearRing>();
            while (!this.matchesCloseList()) {
                LinearRing ring = this.decodeLinearRingText();
                if (ring.isEmpty()) {
                    throw new WktDecodeException("Empty ring found in polygonWkt: " + this.wktString);
                }
                rings.add(ring);
                this.matchesElementSeparator();
            }
            return new Polygon(rings.toArray(new LinearRing[rings.size()]));
        }
        if (this.matchesEmptyToken()) {
            return Polygon.createEmpty();
        }
        throw new WktDecodeException(this.buildWrongSymbolAtPositionMsg());
    }

    private LinearRing decodeLinearRingText() {
        try {
            return new LinearRing(this.decodePointSequence());
        }
        catch (IllegalArgumentException ex) {
            throw new WktDecodeException(ex.getMessage());
        }
    }

    private LineString decodeLineStringText() {
        PointSequence pointSequence = this.decodePointSequence();
        if (pointSequence != null) {
            return new LineString(pointSequence);
        }
        if (this.matchesEmptyToken()) {
            return LineString.createEmpty();
        }
        throw new WktDecodeException(this.buildWrongSymbolAtPositionMsg());
    }

    private Point decodePointText() {
        PointSequence pointSequence = this.decodePointSequence();
        if (pointSequence != null) {
            return new Point(pointSequence);
        }
        if (this.matchesEmptyToken()) {
            return Points.createEmpty();
        }
        throw new WktDecodeException(this.buildWrongSymbolAtPositionMsg());
    }

    private boolean matchesEmptyToken() {
        if (this.currentToken == WKT_GEOM_TOKENS.getEmpty()) {
            this.nextToken();
            return true;
        }
        return false;
    }

    private PointSequence decodePointSequence() {
        PointSequence pointSequence = null;
        if (this.matchesOpenList()) {
            if (!(this.currentToken instanceof WktPointSequenceToken)) {
                throw new WktDecodeException(this.buildWrongSymbolAtPositionMsg());
            }
            pointSequence = ((WktPointSequenceToken)this.currentToken).getPoints();
            this.nextToken();
            if (!this.matchesCloseList()) {
                throw new WktDecodeException(this.buildWrongSymbolAtPositionMsg());
            }
        }
        return pointSequence;
    }

    private String buildWrongSymbolAtPositionMsg() {
        return "Wrong symbol at position: " + this.getTokenizerPosition() + " in Wkt: " + this.wktString;
    }
}

