/*
 * Decompiled with CFR 0.152.
 */
package org.geolatte.geom;

import java.io.Serializable;
import java.util.Arrays;
import org.geolatte.geom.DimensionalFlag;
import org.geolatte.geom.PackedPointSequence;
import org.geolatte.geom.Point;
import org.geolatte.geom.crs.CrsId;

public class Points
implements Serializable {
    public static Point create2D(double x, double y, CrsId crsId) {
        return new Point(new PackedPointSequence(new double[]{x, y}, DimensionalFlag.d2D, crsId));
    }

    public static Point create3D(double x, double y, double z, CrsId crsId) {
        return new Point(new PackedPointSequence(new double[]{x, y, z}, DimensionalFlag.d3D, crsId));
    }

    public static Point create2DM(double x, double y, double m4, CrsId crsId) {
        return new Point(new PackedPointSequence(new double[]{x, y, m4}, DimensionalFlag.d2DM, crsId));
    }

    public static Point create3DM(double x, double y, double z, double m4, CrsId crsId) {
        return new Point(new PackedPointSequence(new double[]{x, y, z, m4}, DimensionalFlag.d3DM, crsId));
    }

    public static Point create2D(double x, double y) {
        return new Point(new PackedPointSequence(new double[]{x, y}, DimensionalFlag.d2D, CrsId.UNDEFINED));
    }

    public static Point create3D(double x, double y, double z) {
        return new Point(new PackedPointSequence(new double[]{x, y, z}, DimensionalFlag.d3D, CrsId.UNDEFINED));
    }

    public static Point create2DM(double x, double y, double m4) {
        return new Point(new PackedPointSequence(new double[]{x, y, m4}, DimensionalFlag.d2DM, CrsId.UNDEFINED));
    }

    public static Point create3DM(double x, double y, double z, double m4) {
        return new Point(new PackedPointSequence(new double[]{x, y, z, m4}, DimensionalFlag.d3DM, CrsId.UNDEFINED));
    }

    static Point create(double[] coordinates, DimensionalFlag dimensionalFlag, CrsId crsId) {
        if (coordinates == null || coordinates.length == 0) {
            return Point.createEmpty();
        }
        return new Point(new PackedPointSequence(Arrays.copyOf(coordinates, coordinates.length), dimensionalFlag, crsId));
    }

    public static Point createEmpty() {
        return Point.createEmpty();
    }
}

