/*
 * Decompiled with CFR 0.152.
 */
package org.geolatte.geom;

import com.vividsolutions.jts.algorithm.ConvexHull;
import com.vividsolutions.jts.operation.BoundaryOp;
import com.vividsolutions.jts.operation.IsSimpleOp;
import com.vividsolutions.jts.operation.buffer.BufferOp;
import com.vividsolutions.jts.operation.distance.DistanceOp;
import com.vividsolutions.jts.operation.overlay.snap.SnapIfNeededOverlayOp;
import com.vividsolutions.jts.operation.relate.RelateOp;
import org.geolatte.geom.ByteBuffer;
import org.geolatte.geom.Envelope;
import org.geolatte.geom.Geometry;
import org.geolatte.geom.GeometryCollection;
import org.geolatte.geom.GeometryOperation;
import org.geolatte.geom.GeometryOperations;
import org.geolatte.geom.MeasureInterpolatingVisitor;
import org.geolatte.geom.Point;
import org.geolatte.geom.PointCollection;
import org.geolatte.geom.PointVisitor;
import org.geolatte.geom.codec.Wkb;
import org.geolatte.geom.codec.Wkt;
import org.geolatte.geom.crs.CrsId;
import org.geolatte.geom.jts.JTS;

class JTSGeometryOperations
implements GeometryOperations {
    JTSGeometryOperations() {
    }

    private static boolean envelopeIntersect(Geometry geometry1, Geometry geometry2) {
        return geometry1.getEnvelope().intersects(geometry2.getEnvelope());
    }

    private static void checkNotGeometryCollection(Geometry geom) {
        if (GeometryCollection.class.equals(geom.getClass())) {
            throw new IllegalArgumentException("GeometryCollection is not allowed");
        }
    }

    private static void checkCompatibleCRS(Geometry geometry, Geometry other) {
        if (!geometry.getCrsId().equals(other.getCrsId())) {
            throw new IllegalArgumentException("Geometries have different CRS's");
        }
    }

    @Override
    public GeometryOperation<Boolean> createIsSimpleOp(Geometry geometry) {
        final IsSimpleOp isSimpleOp = new IsSimpleOp(JTS.to(geometry));
        return new GeometryOperation<Boolean>(){

            @Override
            public Boolean execute() {
                return isSimpleOp.isSimple();
            }
        };
    }

    @Override
    public GeometryOperation<Geometry> createBoundaryOp(Geometry geometry) {
        final BoundaryOp boundaryOp = new BoundaryOp(JTS.to(geometry));
        final CrsId crsId = geometry.getCrsId();
        return new GeometryOperation<Geometry>(){

            @Override
            public Geometry execute() {
                return JTS.from(boundaryOp.getBoundary(), crsId);
            }
        };
    }

    @Override
    public GeometryOperation<Envelope> createEnvelopeOp(final Geometry geometry) {
        return new GeometryOperation<Envelope>(){

            @Override
            public Envelope execute() {
                PointCollection ps = geometry.getPoints();
                EnvelopeVisitor visitor = new EnvelopeVisitor(geometry.getCrsId());
                ps.accept(visitor);
                return visitor.result();
            }
        };
    }

    @Override
    public GeometryOperation<Boolean> createIntersectsOp(final Geometry geometry, final Geometry other) {
        return new GeometryOperation<Boolean>(){

            @Override
            public Boolean execute() {
                if (geometry.isEmpty() || other.isEmpty()) {
                    return Boolean.FALSE;
                }
                JTSGeometryOperations.checkCompatibleCRS(geometry, other);
                if (!JTSGeometryOperations.envelopeIntersect(geometry, other)) {
                    return Boolean.FALSE;
                }
                RelateOp relateOp = new RelateOp(JTS.to(geometry), JTS.to(other));
                return relateOp.getIntersectionMatrix().isIntersects();
            }
        };
    }

    @Override
    public GeometryOperation<Boolean> createTouchesOp(final Geometry geometry, final Geometry other) {
        return new GeometryOperation<Boolean>(){

            @Override
            public Boolean execute() {
                if (geometry.isEmpty() || other.isEmpty()) {
                    return Boolean.FALSE;
                }
                JTSGeometryOperations.checkCompatibleCRS(geometry, other);
                if (!JTSGeometryOperations.envelopeIntersect(geometry, other)) {
                    return Boolean.FALSE;
                }
                RelateOp relateOp = new RelateOp(JTS.to(geometry), JTS.to(other));
                return relateOp.getIntersectionMatrix().isTouches(geometry.getDimension(), other.getDimension());
            }
        };
    }

    @Override
    public GeometryOperation<Boolean> createCrossesOp(final Geometry geometry, final Geometry other) {
        return new GeometryOperation<Boolean>(){

            @Override
            public Boolean execute() {
                if (geometry.isEmpty() || other.isEmpty()) {
                    return Boolean.FALSE;
                }
                JTSGeometryOperations.checkCompatibleCRS(geometry, other);
                if (!JTSGeometryOperations.envelopeIntersect(geometry, other)) {
                    return Boolean.FALSE;
                }
                RelateOp relateOp = new RelateOp(JTS.to(geometry), JTS.to(other));
                return relateOp.getIntersectionMatrix().isCrosses(geometry.getDimension(), other.getDimension());
            }
        };
    }

    @Override
    public GeometryOperation<Boolean> createContainsOp(final Geometry geometry, final Geometry other) {
        return new GeometryOperation<Boolean>(){

            @Override
            public Boolean execute() {
                if (geometry.isEmpty() || other.isEmpty()) {
                    return Boolean.FALSE;
                }
                JTSGeometryOperations.checkCompatibleCRS(geometry, other);
                if (!geometry.getEnvelope().contains(other.getEnvelope())) {
                    return Boolean.FALSE;
                }
                RelateOp relateOp = new RelateOp(JTS.to(geometry), JTS.to(other));
                return relateOp.getIntersectionMatrix().isContains();
            }
        };
    }

    @Override
    public GeometryOperation<Boolean> createOverlapsOp(final Geometry geometry, final Geometry other) {
        return new GeometryOperation<Boolean>(){

            @Override
            public Boolean execute() {
                if (geometry.isEmpty() || other.isEmpty()) {
                    return Boolean.FALSE;
                }
                JTSGeometryOperations.checkCompatibleCRS(geometry, other);
                if (!JTSGeometryOperations.envelopeIntersect(geometry, other)) {
                    return Boolean.FALSE;
                }
                RelateOp relateOp = new RelateOp(JTS.to(geometry), JTS.to(other));
                return relateOp.getIntersectionMatrix().isOverlaps(geometry.getDimension(), other.getDimension());
            }
        };
    }

    @Override
    public GeometryOperation<Boolean> createRelateOp(final Geometry geometry, final Geometry other, final String matrix) {
        return new GeometryOperation<Boolean>(){

            @Override
            public Boolean execute() {
                if (geometry.isEmpty() || other.isEmpty()) {
                    return Boolean.FALSE;
                }
                JTSGeometryOperations.checkCompatibleCRS(geometry, other);
                RelateOp relateOp = new RelateOp(JTS.to(geometry), JTS.to(other));
                return relateOp.getIntersectionMatrix().matches(matrix);
            }
        };
    }

    @Override
    public GeometryOperation<Geometry> createLocateAlongOp(Geometry geometry, double mValue) {
        return this.createLocateBetweenOp(geometry, mValue, mValue);
    }

    @Override
    public GeometryOperation<Geometry> createLocateBetweenOp(final Geometry geometry, final double startMeasure, final double endMeasure) {
        return new GeometryOperation<Geometry>(){

            @Override
            public Geometry execute() {
                if (geometry == null) {
                    throw new IllegalArgumentException("Null geometries not allowed.");
                }
                if (geometry.isEmpty()) {
                    return Point.EMPTY;
                }
                MeasureInterpolatingVisitor visitor = new MeasureInterpolatingVisitor(geometry, startMeasure, endMeasure);
                geometry.accept(visitor);
                return visitor.result();
            }
        };
    }

    @Override
    public GeometryOperation<Double> createDistanceOp(final Geometry geometry, final Geometry other) {
        return new GeometryOperation<Double>(){

            @Override
            public Double execute() {
                DistanceOp op = new DistanceOp(JTS.to(geometry), JTS.to(other));
                return op.distance();
            }
        };
    }

    @Override
    public GeometryOperation<Geometry> createBufferOp(final Geometry geometry, final double distance) {
        return new GeometryOperation<Geometry>(){

            @Override
            public Geometry execute() {
                BufferOp op = new BufferOp(JTS.to(geometry));
                return JTS.from(op.getResultGeometry(distance), geometry.getCrsId());
            }
        };
    }

    @Override
    public GeometryOperation<Geometry> createConvexHullOp(final Geometry geometry) {
        return new GeometryOperation<Geometry>(){

            @Override
            public Geometry execute() {
                ConvexHull convexHull = new ConvexHull(JTS.to(geometry));
                return JTS.from(convexHull.getConvexHull(), geometry.getCrsId());
            }
        };
    }

    @Override
    public GeometryOperation<Geometry> createIntersectionOp(final Geometry geometry, final Geometry other) {
        return new GeometryOperation<Geometry>(){

            @Override
            public Geometry execute() {
                if (geometry.isEmpty() || other.isEmpty()) {
                    return GeometryCollection.createEmpty();
                }
                JTSGeometryOperations.checkNotGeometryCollection(geometry);
                JTSGeometryOperations.checkNotGeometryCollection(other);
                JTSGeometryOperations.checkCompatibleCRS(geometry, other);
                com.vividsolutions.jts.geom.Geometry intersection = SnapIfNeededOverlayOp.overlayOp(JTS.to(geometry), JTS.to(other), 1);
                return JTS.from(intersection, geometry.getCrsId());
            }
        };
    }

    @Override
    public GeometryOperation<Geometry> createUnionOp(final Geometry geometry, final Geometry other) {
        return new GeometryOperation<Geometry>(){

            @Override
            public Geometry execute() {
                if (geometry.isEmpty()) {
                    return other;
                }
                if (other.isEmpty()) {
                    return geometry;
                }
                JTSGeometryOperations.checkNotGeometryCollection(geometry);
                JTSGeometryOperations.checkNotGeometryCollection(other);
                JTSGeometryOperations.checkCompatibleCRS(geometry, other);
                com.vividsolutions.jts.geom.Geometry union = SnapIfNeededOverlayOp.overlayOp(JTS.to(geometry), JTS.to(other), 2);
                return JTS.from(union, geometry.getCrsId());
            }
        };
    }

    @Override
    public GeometryOperation<Geometry> createDifferenceOp(final Geometry geometry, final Geometry other) {
        return new GeometryOperation<Geometry>(){

            @Override
            public Geometry execute() {
                if (geometry.isEmpty()) {
                    return GeometryCollection.createEmpty();
                }
                if (other.isEmpty()) {
                    return geometry;
                }
                JTSGeometryOperations.checkNotGeometryCollection(geometry);
                JTSGeometryOperations.checkNotGeometryCollection(other);
                JTSGeometryOperations.checkCompatibleCRS(geometry, other);
                com.vividsolutions.jts.geom.Geometry difference = SnapIfNeededOverlayOp.overlayOp(JTS.to(geometry), JTS.to(other), 3);
                return JTS.from(difference, geometry.getCrsId());
            }
        };
    }

    @Override
    public GeometryOperation<Geometry> createSymDifferenceOp(final Geometry geometry, final Geometry other) {
        return new GeometryOperation<Geometry>(){

            @Override
            public Geometry execute() {
                if (geometry.isEmpty()) {
                    return other;
                }
                if (other.isEmpty()) {
                    return geometry;
                }
                JTSGeometryOperations.checkNotGeometryCollection(geometry);
                JTSGeometryOperations.checkNotGeometryCollection(other);
                JTSGeometryOperations.checkCompatibleCRS(geometry, other);
                com.vividsolutions.jts.geom.Geometry symDifference = SnapIfNeededOverlayOp.overlayOp(JTS.to(geometry), JTS.to(other), 4);
                return JTS.from(symDifference, geometry.getCrsId());
            }
        };
    }

    @Override
    public GeometryOperation<String> createToWktOp(final Geometry geometry) {
        return new GeometryOperation<String>(){

            @Override
            public String execute() {
                return Wkt.toWkt(geometry);
            }
        };
    }

    @Override
    public GeometryOperation<ByteBuffer> createToWkbOp(final Geometry geometry) {
        return new GeometryOperation<ByteBuffer>(){

            @Override
            public ByteBuffer execute() {
                return Wkb.toWkb(geometry);
            }
        };
    }

    private static class EnvelopeVisitor
    implements PointVisitor {
        double xMin = Double.POSITIVE_INFINITY;
        double yMin = Double.POSITIVE_INFINITY;
        double xMax = Double.NEGATIVE_INFINITY;
        double yMax = Double.NEGATIVE_INFINITY;
        final CrsId crsId;

        EnvelopeVisitor(CrsId crsId) {
            this.crsId = crsId;
        }

        @Override
        public void visit(double[] coordinates) {
            this.xMin = Math.min(this.xMin, coordinates[0]);
            this.xMax = Math.max(this.xMax, coordinates[0]);
            this.yMin = Math.min(this.yMin, coordinates[1]);
            this.yMax = Math.max(this.yMax, coordinates[1]);
        }

        public Envelope result() {
            return new Envelope(this.xMin, this.yMin, this.xMax, this.yMax, this.crsId);
        }
    }
}

