/*
 * Decompiled with CFR 0.152.
 */
package org.geolatte.geom;

import org.geolatte.geom.DimensionalFlag;
import org.geolatte.geom.ExactCoordinatePointEquality;
import org.geolatte.geom.Geometry;
import org.geolatte.geom.GeometryCollection;
import org.geolatte.geom.GeometryOperation;
import org.geolatte.geom.GeometryType;
import org.geolatte.geom.GeometryVisitor;
import org.geolatte.geom.LineSegment;
import org.geolatte.geom.LineSegments;
import org.geolatte.geom.LineString;
import org.geolatte.geom.LinearRing;
import org.geolatte.geom.MeasureGeometryOperations;
import org.geolatte.geom.MultiLineString;
import org.geolatte.geom.Point;
import org.geolatte.geom.PointEquality;
import org.geolatte.geom.PointSequence;
import org.geolatte.geom.PointSequenceBuilder;
import org.geolatte.geom.PointSequenceBuilders;
import org.geolatte.geom.PolyHedralSurface;
import org.geolatte.geom.Polygon;
import org.geolatte.geom.Vector;

public class DefaultMeasureGeometryOperations
implements MeasureGeometryOperations {
    private static final PointEquality pntEq = new ExactCoordinatePointEquality(DimensionalFlag.d2D);

    @Override
    public GeometryOperation<Double> createGetMeasureOp(Geometry geometry, Point point, double tolerance) {
        return this.measureOp(geometry, point, tolerance, true);
    }

    @Override
    public GeometryOperation<Double> createGetMeasureOp(Geometry geometry, Point point) {
        return this.measureOp(geometry, point, 0.0, false);
    }

    private GeometryOperation<Double> measureOp(final Geometry geometry, final Point point, final double tolerance, final boolean testTolerance) {
        if (geometry == null || point == null) {
            throw new IllegalArgumentException("Parameters must not be NULL");
        }
        return new GeometryOperation<Double>(){

            @Override
            public Double execute() {
                if (geometry.isEmpty() || point.isEmpty()) {
                    return Double.NaN;
                }
                InterpolatingVisitor visitor = new InterpolatingVisitor(point, tolerance, testTolerance);
                geometry.accept(visitor);
                return visitor.m();
            }
        };
    }

    @Override
    public GeometryOperation<Geometry> createMeasureOnLengthOp(final Geometry geometry, final boolean keepBeginMeasure) {
        if (geometry == null) {
            throw new IllegalArgumentException("Geometry parameter must not be NULL");
        }
        if (geometry.getGeometryType() != GeometryType.LINE_STRING && geometry.getGeometryType() != GeometryType.MULTI_LINE_STRING) {
            throw new IllegalArgumentException("Geometry parameter must be of type LineString or MultiLineString");
        }
        return new GeometryOperation<Geometry>(){
            private double length = 0.0;

            @Override
            public Geometry execute() {
                if (geometry.isEmpty()) {
                    return geometry;
                }
                if (keepBeginMeasure) {
                    double initialValue = geometry.getPointN(0).getM();
                    double d = this.length = Double.isNaN(initialValue) ? 0.0 : initialValue;
                }
                if (geometry instanceof LineString) {
                    return this.measure((LineString)geometry);
                }
                if (geometry instanceof MultiLineString) {
                    return this.measure((MultiLineString)geometry);
                }
                throw new IllegalStateException(String.format("Requires a LineString or MultiLineString, but received %s", geometry.getClass().getName()));
            }

            private MultiLineString measure(MultiLineString geometry2) {
                LineString[] measuredParts = new LineString[geometry2.getNumGeometries()];
                for (int part = 0; part < geometry2.getNumGeometries(); ++part) {
                    LineString lineString = geometry2.getGeometryN(part);
                    measuredParts[part] = this.measure(lineString);
                }
                return new MultiLineString(measuredParts);
            }

            private LineString measure(LineString geometry2) {
                PointSequence originalPoints = geometry2.getPoints();
                DimensionalFlag dimFlag = DimensionalFlag.valueOf(geometry2.is3D(), true);
                PointSequenceBuilder builder = PointSequenceBuilders.fixedSized(originalPoints.size(), dimFlag, originalPoints.getCrsId());
                double[] coordinates = new double[geometry2.getCoordinateDimension() + 1];
                double[] prevCoordinates = new double[geometry2.getCoordinateDimension()];
                for (int i = 0; i < originalPoints.size(); ++i) {
                    originalPoints.getCoordinates(coordinates, i);
                    if (i > 0) {
                        this.length += Math.hypot(coordinates[0] - prevCoordinates[0], coordinates[1] - prevCoordinates[1]);
                    }
                    coordinates[dimFlag.M] = this.length;
                    builder.add(coordinates);
                    prevCoordinates[0] = coordinates[0];
                    prevCoordinates[1] = coordinates[1];
                }
                return new LineString(builder.toPointSequence(), geometry2.getGeometryOperations());
            }
        };
    }

    private static class InterpolatingVisitor
    implements GeometryVisitor {
        public static final String INVALID_TYPE_MSG = "Operation only valid on LineString, MultiPoint and MultiLineString Geometries.";
        public static final String OUTSIDE_TOL_MSG = "Search point not within tolerance: distance to geometry is %f > %f";
        final Point searchPoint;
        final double tolerance;
        final boolean testTolerance;
        double mValue = Double.NaN;
        double distToSearchPoint = Double.MAX_VALUE;

        InterpolatingVisitor(Point pnt, double tolerance, boolean testTolerance) {
            if (pnt == null) {
                throw new IllegalArgumentException("Null point is not allowed.");
            }
            this.searchPoint = pnt;
            this.tolerance = Math.abs(tolerance);
            this.testTolerance = testTolerance;
        }

        double m() {
            if (!this.testTolerance || this.testTolerance && this.distToSearchPoint <= this.tolerance) {
                return this.mValue;
            }
            throw new IllegalArgumentException(String.format(OUTSIDE_TOL_MSG, this.distToSearchPoint, this.tolerance));
        }

        @Override
        public void visit(Point point) {
            double dts = this.searchPoint.distance(point);
            if (dts <= this.distToSearchPoint) {
                this.mValue = point.getM();
                this.distToSearchPoint = dts;
            }
        }

        @Override
        public void visit(LineString lineString) {
            LineSegments lineSegments = new LineSegments(lineString.getPoints());
            for (LineSegment segment : lineSegments) {
                Point p1;
                Point p0 = segment.getStartPoint();
                double[] dAndR = Vector.pointToSegment2D(p0, p1 = segment.getEndPoint(), this.searchPoint);
                double d = Math.sqrt(Math.abs(dAndR[0]));
                if (!(d <= this.distToSearchPoint)) continue;
                double r = dAndR[1];
                this.mValue = r <= 0.0 ? p0.getM() : (r >= 1.0 ? p1.getM() : p0.getM() + r * (p1.getM() - p0.getM()));
                this.distToSearchPoint = d;
            }
        }

        @Override
        public void visit(Polygon polygon) {
            throw new IllegalArgumentException(INVALID_TYPE_MSG);
        }

        @Override
        public void visit(GeometryCollection collection) {
        }

        @Override
        public void visit(LinearRing linearRing) {
            this.visit((LineString)linearRing);
        }

        @Override
        public void visit(PolyHedralSurface surface) {
            throw new IllegalArgumentException(INVALID_TYPE_MSG);
        }
    }
}

