/*
 * Decompiled with CFR 0.152.
 */
package org.geolatte.common.transformer;

import java.util.ArrayList;
import java.util.Iterator;
import org.geolatte.common.transformer.AbstractObservableTransformer;
import org.geolatte.common.transformer.ClosedTransformerChain;
import org.geolatte.common.transformer.DefaultFilter;
import org.geolatte.common.transformer.DefaultTransformer;
import org.geolatte.common.transformer.IterableTransformerSink;
import org.geolatte.common.transformer.ObservableTransformer;
import org.geolatte.common.transformer.ObservableTransformerSink;
import org.geolatte.common.transformer.ObservableTransformerSource;
import org.geolatte.common.transformer.OneToManyTransformation;
import org.geolatte.common.transformer.OpenTransformerChain;
import org.geolatte.common.transformer.Transformation;
import org.geolatte.common.transformer.Transformer;
import org.geolatte.common.transformer.TransformerErrorEvent;
import org.geolatte.common.transformer.TransformerEventListener;
import org.geolatte.common.transformer.TransformerSink;
import org.geolatte.common.transformer.TransformerSinkErrorEvent;
import org.geolatte.common.transformer.TransformerSinkEventListener;
import org.geolatte.common.transformer.TransformerSource;
import org.geolatte.common.transformer.TransformerSourceErrorEvent;
import org.geolatte.common.transformer.TransformerSourceEventListener;

public class TransformerChainFactory {
    public static <Source, Target> TransformerConcatenatorInitial<Source, Target> newChain() {
        return new TransformerConcatenatorInitial();
    }

    private static class NoOpTransformer
    extends Transformer {
        private Iterable input;

        private NoOpTransformer() {
        }

        protected void setInput(Iterable input) {
            this.input = input;
        }

        protected Iterable output() {
            return this.input;
        }
    }

    private static class ClosedTransformerChainInternal<Source, Target>
    extends ClosedTransformerChain
    implements TransformerEventListener,
    TransformerSourceEventListener,
    TransformerSinkEventListener {
        private TransformerSource<? extends Source> transformerSource;
        private ArrayList<Transformer<?, ?>> chain = new ArrayList();
        private TransformerSink<Target> transformerSink;
        private boolean isConfigured = false;
        private boolean isStarted = false;

        private ClosedTransformerChainInternal() {
        }

        private void configure() {
            if (this.isConfigured) {
                return;
            }
            TransformerChain transformerChain = new TransformerChain(this.chain);
            Iterable<? extends Source> output = this.transformerSource.output();
            if (this.transformerSource instanceof ObservableTransformerSource) {
                ((ObservableTransformerSource)this.transformerSource).addTransformerSourceEventListener(this);
            }
            transformerChain.setInput(output);
            transformerChain.addTransformerEventListener(this);
            if (this.transformerSink instanceof ObservableTransformerSink) {
                ((ObservableTransformerSink)this.transformerSink).addTransformerSinkEventListener(this);
            }
            this.transformerSink.setInput(transformerChain.output());
            this.isConfigured = true;
        }

        @Override
        public void run() {
            if (this.isStarted) {
                return;
            }
            this.isStarted = true;
            this.configure();
            this.transformerSink.start();
        }

        @Override
        public void ErrorOccurred(TransformerErrorEvent event) {
            this.onTransformerErrorOccurred(event);
        }

        @Override
        public void ErrorOccurred(TransformerSinkErrorEvent event) {
            this.onTransformerSinkErrorOccurred(event);
        }

        @Override
        public void ErrorOccurred(TransformerSourceErrorEvent event) {
            this.onTransformerSourceErrorOccurred(event);
        }
    }

    private static class OpenTransformerChainInternal<Source, Target>
    extends OpenTransformerChain<Target>
    implements TransformerEventListener,
    TransformerSourceEventListener {
        private TransformerSource<? extends Source> transformerSource;
        private ArrayList<Transformer<?, ?>> chain = new ArrayList();
        private IterableTransformerSink<Target> transformerSink;
        private Iterator<Target> iterator = null;

        private OpenTransformerChainInternal() {
        }

        private void configure() {
            TransformerChain transformerChain = new TransformerChain(this.chain);
            Iterable<? extends Source> output = this.transformerSource.output();
            if (this.transformerSource instanceof ObservableTransformerSource) {
                ((ObservableTransformerSource)this.transformerSource).addTransformerSourceEventListener(this);
            }
            transformerChain.setInput(output);
            transformerChain.configure();
            transformerChain.addTransformerEventListener(this);
            this.transformerSink = new IterableTransformerSink();
            this.transformerSink.setInput(transformerChain.output());
        }

        @Override
        public Iterator<Target> iterator() {
            if (this.iterator == null) {
                this.configure();
                this.transformerSink.start();
                this.iterator = this.transformerSink.iterator();
            }
            return this.iterator;
        }

        @Override
        public void ErrorOccurred(TransformerErrorEvent event) {
            this.onTransformerErrorOccurred(event);
        }

        @Override
        public void ErrorOccurred(TransformerSourceErrorEvent event) {
            this.onTransformerSourceErrorOccurred(event);
        }
    }

    private static class TransformerChain<Source, Target>
    extends AbstractObservableTransformer<Source, Target>
    implements TransformerEventListener {
        private ArrayList<Transformer<?, ?>> chain = new ArrayList();
        private boolean isConfigured = false;

        TransformerChain(ArrayList<Transformer<?, ?>> chain) {
            if (chain.size() > 0) {
                this.chain = chain;
            } else {
                ArrayList<NoOpTransformer> noOpChain = new ArrayList<NoOpTransformer>(1);
                noOpChain.add(new NoOpTransformer());
                this.chain = noOpChain;
            }
        }

        private void configure() {
            if (this.isConfigured) {
                return;
            }
            for (int i = 1; i < this.chain.size(); ++i) {
                Transformer<?, ?> current = this.chain.get(i);
                current.setInput(this.chain.get(i - 1).output());
                if (!(current instanceof ObservableTransformer)) continue;
                ((ObservableTransformer)current).addTransformerEventListener(this);
            }
            this.isConfigured = true;
        }

        @Override
        public void setInput(Iterable<? extends Source> input) {
            if (input == null) {
                this.isConfigured = false;
            }
            this.chain.get(0).setInput(input);
            this.configure();
        }

        @Override
        public Iterable<? extends Target> output() {
            this.configure();
            return this.chain.get(this.chain.size() - 1).output();
        }

        @Override
        public void ErrorOccurred(TransformerErrorEvent transformerErrorEvent) {
            this.onTransformerErrorOccurred(transformerErrorEvent);
        }
    }

    public static class TransformerConcatenator<Source, IntermediateSource, Target> {
        private ArrayList<Transformer<?, ?>> chain;

        TransformerConcatenator(ArrayList<Transformer<?, ?>> chain) {
            this.chain = chain;
        }

        public <IntermediateTarget> TransformerConcatenator<Source, IntermediateTarget, Target> add(Transformer<? super IntermediateSource, IntermediateTarget> transformer) {
            if (transformer == null) {
                throw new IllegalArgumentException("transformer cannot be null");
            }
            this.chain.add(transformer);
            return new TransformerConcatenator<Source, IntermediateSource, Target>(this.chain);
        }

        public TransformerChain<Source, Target> last(Transformer<? super IntermediateSource, Target> transformer) {
            if (transformer == null) {
                throw new IllegalArgumentException("transformer cannot be null");
            }
            this.chain.add(transformer);
            return new TransformerChain(this.chain);
        }

        public <IntermediateTarget> TransformerConcatenator<Source, IntermediateTarget, Target> add(Transformation<IntermediateSource, IntermediateTarget> transformation) {
            if (transformation == null) {
                throw new IllegalArgumentException("transformation cannot be null");
            }
            return this.add(new DefaultTransformer<IntermediateSource, IntermediateTarget>(transformation));
        }

        public <IntermediateTarget> TransformerConcatenator<Source, IntermediateTarget, Target> add(OneToManyTransformation<IntermediateSource, IntermediateTarget> transformation) {
            if (transformation == null) {
                throw new IllegalArgumentException("transformation cannot be null");
            }
            return this.add(new DefaultTransformer<IntermediateSource, IntermediateTarget>(transformation));
        }

        public TransformerChain<Source, Target> last(Transformation<IntermediateSource, Target> transformation) {
            if (transformation == null) {
                throw new IllegalArgumentException("transformation cannot be null");
            }
            return this.last(new DefaultTransformer<IntermediateSource, Target>(transformation));
        }

        public TransformerConcatenator<Source, IntermediateSource, Target> addFilter(Transformation<IntermediateSource, Boolean> filter) {
            if (filter == null) {
                throw new IllegalArgumentException("filter cannot be null");
            }
            return this.add(new DefaultFilter<IntermediateSource>(filter));
        }
    }

    public static class TransformerConcatenatorWithSource<Source, IntermediateSource, Target> {
        private TransformerSource<? extends Source> source;
        private ArrayList<Transformer<?, ?>> chain = new ArrayList();

        TransformerConcatenatorWithSource(TransformerSource<? extends Source> source, ArrayList<Transformer<?, ?>> chain) {
            this.source = source;
            this.chain = chain;
        }

        public <IntermediateTarget> TransformerConcatenatorWithSource<Source, IntermediateTarget, Target> add(Transformer<? super IntermediateSource, IntermediateTarget> transformer) {
            if (transformer == null) {
                throw new IllegalArgumentException("transformer cannot be null");
            }
            this.chain.add(transformer);
            return new TransformerConcatenatorWithSource<Source, IntermediateSource, Target>(this.source, this.chain);
        }

        public OpenTransformerChain<Target> last(Transformer<? super IntermediateSource, Target> transformer) {
            if (transformer == null) {
                throw new IllegalArgumentException("transformer cannot be null");
            }
            this.chain.add(transformer);
            OpenTransformerChainInternal openChain = new OpenTransformerChainInternal();
            openChain.transformerSource = this.source;
            openChain.chain = this.chain;
            return openChain;
        }

        public <IntermediateTarget> TransformerConcatenatorWithSource<Source, IntermediateTarget, Target> add(Transformation<IntermediateSource, IntermediateTarget> transformation) {
            if (transformation == null) {
                throw new IllegalArgumentException("transformation cannot be null");
            }
            return this.add(new DefaultTransformer<IntermediateSource, IntermediateTarget>(transformation));
        }

        public <IntermediateTarget> TransformerConcatenatorWithSource<Source, IntermediateTarget, Target> add(OneToManyTransformation<IntermediateSource, IntermediateTarget> transformation) {
            if (transformation == null) {
                throw new IllegalArgumentException("transformation cannot be null");
            }
            return this.add(new DefaultTransformer<IntermediateSource, IntermediateTarget>(transformation));
        }

        public TransformerConcatenatorWithSource<Source, IntermediateSource, Target> addFilter(Transformation<IntermediateSource, Boolean> filter) {
            if (filter == null) {
                throw new IllegalArgumentException("filter cannot be null");
            }
            return this.add(new DefaultFilter<IntermediateSource>(filter));
        }

        public ClosedTransformerChain last(TransformerSink<Target> transformerSink) {
            if (transformerSink == null) {
                throw new IllegalArgumentException("transformerSink cannot be null");
            }
            ClosedTransformerChainInternal closedChain = new ClosedTransformerChainInternal();
            closedChain.transformerSource = this.source;
            closedChain.chain = this.chain;
            closedChain.transformerSink = transformerSink;
            return closedChain;
        }
    }

    public static class TransformerConcatenatorInitial<Source, Target> {
        TransformerConcatenatorInitial() {
        }

        public TransformerConcatenatorWithSource<Source, Source, Target> add(TransformerSource<Source> transformerSource) {
            if (transformerSource == null) {
                throw new IllegalArgumentException("transformerSource cannot be null");
            }
            return new TransformerConcatenatorWithSource(transformerSource, new ArrayList());
        }

        public <IntermediateTarget> TransformerConcatenator<Source, IntermediateTarget, Target> add(Transformer<? super Source, IntermediateTarget> transformer) {
            if (transformer == null) {
                throw new IllegalArgumentException("transformer cannot be null");
            }
            ArrayList chain = new ArrayList();
            chain.add(transformer);
            return new TransformerConcatenator(chain);
        }

        public <IntermediateTarget> TransformerConcatenator<Source, IntermediateTarget, Target> add(Transformation<Source, IntermediateTarget> transformation) {
            if (transformation == null) {
                throw new IllegalArgumentException("transformation cannot be null");
            }
            return this.add(new DefaultTransformer<Source, IntermediateTarget>(transformation));
        }

        public <IntermediateTarget> TransformerConcatenator<Source, IntermediateTarget, Target> add(OneToManyTransformation<Source, IntermediateTarget> transformation) {
            if (transformation == null) {
                throw new IllegalArgumentException("transformation cannot be null");
            }
            return this.add(new DefaultTransformer<Source, IntermediateTarget>(transformation));
        }

        public TransformerConcatenator<Source, Source, Target> addFilter(Transformation<Source, Boolean> filter) {
            if (filter == null) {
                throw new IllegalArgumentException("filter cannot be null");
            }
            ArrayList chain = new ArrayList();
            chain.add(new DefaultFilter<Source>(filter));
            return new TransformerConcatenator(chain);
        }
    }
}

