/*
 * Decompiled with CFR 0.152.
 */
package org.geolatte.common.reflection;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.geolatte.geom.Geometry;
import org.geolatte.geom.jts.JTS;

abstract class Accessor {
    Accessor() {
    }

    static Accessor newInstance(Method accessorMethod, String propertyName) {
        if (com.vividsolutions.jts.geom.Geometry.class.isAssignableFrom(accessorMethod.getReturnType())) {
            return new JTSGeometryAccessor(accessorMethod, propertyName);
        }
        return new BasicAccessor(accessorMethod, propertyName);
    }

    abstract Object getValueFrom(Object var1);

    abstract String getPropertyName();

    abstract Class getReturnType();

    private static class JTSGeometryAccessor
    extends BasicAccessor {
        JTSGeometryAccessor(Method accessor, String propertyName) {
            super(accessor, propertyName);
        }

        @Override
        Object getValueFrom(Object object) {
            Object value = super.getValueFrom(object);
            return value == null ? null : JTS.from((com.vividsolutions.jts.geom.Geometry)value);
        }

        @Override
        Class getReturnType() {
            return Geometry.class;
        }
    }

    private static class BasicAccessor
    extends Accessor {
        final Method accessorMethod;
        final String propertyName;

        BasicAccessor(Method method, String name) {
            this.accessorMethod = method;
            this.propertyName = name;
        }

        @Override
        Object getValueFrom(Object object) {
            try {
                return this.accessorMethod.invoke(object, new Object[0]);
            }
            catch (IllegalAccessException e) {
                throw new IllegalStateException("Failed to fetch value", e);
            }
            catch (InvocationTargetException e) {
                throw new IllegalStateException("Failed to fetch value", e);
            }
        }

        @Override
        String getPropertyName() {
            return this.propertyName;
        }

        @Override
        Class getReturnType() {
            return this.accessorMethod.getReturnType();
        }
    }
}

