/*
 * Decompiled with CFR 0.152.
 */
package org.geolatte.common.geo;

import org.geolatte.common.geo.TypeConversionException;
import org.geolatte.common.geo.TypeConverter;
import org.geolatte.geom.Envelope;

public class EnvelopeConverter
implements TypeConverter<Envelope> {
    @Override
    public Envelope convert(String inputString) throws TypeConversionException {
        double[] coordinates = this.getCoordinates(inputString);
        return this.createEnvelope(coordinates);
    }

    public Envelope createEnvelope(double[] coordinates) throws TypeConversionException {
        if (coordinates.length < 4) {
            throw new TypeConversionException("Not enough coordinates in inputstring");
        }
        double minX = Double.MAX_VALUE;
        double minY = Double.MAX_VALUE;
        double maxX = Double.MIN_VALUE;
        double maxY = Double.MIN_VALUE;
        for (int i = 0; i < coordinates.length; ++i) {
            if (i % 2 == 0) {
                if (coordinates[i] < minX) {
                    minX = coordinates[i];
                }
                if (!(coordinates[i] > maxX)) continue;
                maxX = coordinates[i];
                continue;
            }
            if (coordinates[i] < minY) {
                minY = coordinates[i];
            }
            if (!(coordinates[i] > maxY)) continue;
            maxY = coordinates[i];
        }
        return new Envelope(minX, minY, maxX, maxY);
    }

    public double[] getCoordinates(String inputString) throws TypeConversionException {
        String[] cstr = inputString.split(",");
        int coordLength = cstr.length % 2 == 0 ? cstr.length : cstr.length - 1;
        double[] coordinates = new double[coordLength];
        try {
            for (int index = 0; index < coordLength; ++index) {
                coordinates[index] = Double.parseDouble(cstr[index]);
            }
            return coordinates;
        }
        catch (NumberFormatException e) {
            throw new TypeConversionException("String contains non-numeric data. Impossible to create envelope", e);
        }
    }
}

