/*
 * Decompiled with CFR 0.152.
 */
package org.geolatte.common.dataformats.json.to;

import java.util.Arrays;
import org.geolatte.common.dataformats.json.to.CrsTo;
import org.geolatte.common.dataformats.json.to.GeoJsonTo;

public final class PointTo
extends GeoJsonTo {
    private double[] coordinates;

    public PointTo() {
    }

    public PointTo(CrsTo crsTo, double[] coordinates) {
        super(crsTo, PointTo.createBoundingBox(coordinates));
        this.setCoordinates(coordinates);
    }

    @Override
    public boolean isValid() {
        return this.coordinates != null && this.coordinates.length >= 2 && this.coordinates.length <= 4;
    }

    public double[] getCoordinates() {
        return this.coordinates;
    }

    public void setCoordinates(double[] coordinates) {
        this.coordinates = coordinates;
        this.setBbox(PointTo.createBoundingBox(coordinates));
    }

    @Override
    public final boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        PointTo pointTo = (PointTo)o;
        return Arrays.equals(this.coordinates, pointTo.coordinates);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.coordinates != null ? Arrays.hashCode(this.coordinates) : 0);
        return result;
    }
}

